# Organization 2 - HealthcareService Geriatrie - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - HealthcareService Geriatrie**

## Example HealthcareService: Organization 2 - HealthcareService Geriatrie

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**identifier**: `https://cp2-test.example.org/services`/120325af-083c-40ee-b16e-01230fe65655

**active**: true

**providedBy**: [Organization example Hospital](Organization-ad2-o1.md)

**type**: Consultation

**specialty**: Medisch specialisten, geriatrie, Klinisch geriater

**name**: Geriatrie



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "ad2-hs5",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-healthcareservice"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp2-test.example.org/services",
      "value" : "120325af-083c-40ee-b16e-01230fe65655",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "active" : true,
  "providedBy" : {
    "reference" : "Organization/ad2-o1"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11429006",
          "display" : "Consultation"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
          "code" : "0335",
          "display" : "Medisch specialisten, geriatrie"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
          "code" : "01.022",
          "display" : "Klinisch geriater"
        }
      ]
    }
  ],
  "name" : "Geriatrie"
}

```
