# Organization 2 - HealthcareService Cardiology - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - HealthcareService Cardiology**

## Example HealthcareService: Organization 2 - HealthcareService Cardiology

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**identifier**: `https://cp2-test.example.org/services`/5cb05355-474b-4d30-8b0e-a9ca574b8274

**active**: true

**providedBy**: [Organization example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)

**type**: Consultation

**specialty**: Chirurgie (Heelkunde), Chirurg

**name**: Polikliniek 't Vaatje



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "5cb05355-474b-4d30-8b0e-a9ca574b8274",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-healthcareservice"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp2-test.example.org/services",
      "value" : "5cb05355-474b-4d30-8b0e-a9ca574b8274",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "active" : true,
  "providedBy" : {
    "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11429006",
          "display" : "Consultation"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
          "code" : "0303",
          "display" : "Chirurgie (Heelkunde)"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
          "code" : "01.014",
          "display" : "Chirurg"
        }
      ]
    }
  ],
  "name" : "Polikliniek 't Vaatje"
}

```
