# Organization 2 - Endpoint FHIR R4 - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - Endpoint FHIR R4**

## Example Endpoint: Organization 2 - Endpoint FHIR R4

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**identifier**: `https://cp2-test.example.org/api`/430f7379-8ec2-4e55-b096-919995da61e2

**status**: Active

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: FHIR Endpoint 2

**managingOrganization**: Identifier: `http://fhir.nl/fhir/NamingSystem/kvk`/08013836

**contact**: [+3131599991](tel:+3131599991), [info@nedap.example.org](mailto:info@nedap.example.org)

**payloadType**: Care Services Directory for Update Client

**payloadMimeType**: application/fhir+json

**address**: [https://cp2-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "430f7379-8ec2-4e55-b096-919995da61e2",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-endpoint"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp2-test.example.org/api",
      "value" : "430f7379-8ec2-4e55-b096-919995da61e2",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "FHIR Endpoint 2",
  "managingOrganization" : {
    "identifier" : {
      "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
      "value" : "08013836"
    }
  },
  "contact" : [
    {
      "system" : "phone",
      "value" : "+3131599991",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@nedap.example.org",
      "use" : "work"
    }
  ],
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://minvws.github.io/generiekefuncties-docs/CodeSystem/nl-gf-data-exchange-capabilities",
          "code" : "http://minvws.github.io/generiekefuncties-docs/CapabilityStatement/nl-gf-admin-directory-update-client",
          "display" : "Care Services Directory for Update Client"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+json"],
  "address" : "https://cp2-test.example.org/fhirr4"
}

```
