# NL Generic Functions Localization Custodian - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Localization Custodian**

## Extension: NL Generic Functions Localization Custodian 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-localization-custodian | *Version*:0.1.0 |
| Draft as of 2026-02-17 | *Computable Name*:NlGfLocalizationCustodian |

The organization responsible for the localization record, identified by URA number.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [NL Generic Functions Localization List Profile](StructureDefinition-nl-gf-localization-list.md)
* Examples for this Extension: [Bundle/nvi-org1](Bundle-nvi-org1.md) and [List/a1b2c3d4-e5f6-7890-abcd-ef1234567890](List-a1b2c3d4-e5f6-7890-abcd-ef1234567890.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.gf|current/StructureDefinition/nl-gf-localization-custodian)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-localization-custodian.csv), [Excel](StructureDefinition-nl-gf-localization-custodian.xlsx), [Schematron](StructureDefinition-nl-gf-localization-custodian.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-localization-custodian",
  "url" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-localization-custodian",
  "version" : "0.1.0",
  "name" : "NlGfLocalizationCustodian",
  "title" : "NL Generic Functions Localization Custodian",
  "status" : "draft",
  "date" : "2026-02-17T17:25:51+00:00",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "The organization responsible for the localization record, identified by URA number.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "List"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "NL Generic Functions Localization Custodian",
        "definition" : "The organization responsible for the localization record, identified by URA number."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-localization-custodian"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Organization"]
          }
        ]
      },
      {
        "id" : "Extension.value[x].reference",
        "path" : "Extension.value[x].reference",
        "max" : "0"
      },
      {
        "id" : "Extension.value[x].identifier",
        "path" : "Extension.value[x].identifier",
        "min" : 1
      },
      {
        "id" : "Extension.value[x].identifier.system",
        "path" : "Extension.value[x].identifier.system",
        "patternUri" : "http://fhir.nl/fhir/NamingSystem/ura"
      },
      {
        "id" : "Extension.value[x].identifier.value",
        "path" : "Extension.value[x].identifier.value",
        "min" : 1
      }
    ]
  }
}

```
