#  Author Assigned Identifier - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* ** Author Assigned Identifier**

## Data Type Profile: Author Assigned Identifier 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-authorassignedidentifier | *Version*:0.1.0 |
| Draft as of 2026-02-17 | *Computable Name*:AuthorAssignedIdentifier |

 
Identifier assigned by the author of a resource, such as a healthcare service or organization, to uniquely identify that resource AND locate the original authoring organization when copies are stored at other locations 

**Usages:**

* Use this DataType Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md), [NL Generic Functions Location Profile](StructureDefinition-nl-gf-location.md), [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md), [NL Generic Functions OrganizationAffiliation Profile](StructureDefinition-nl-gf-organizationaffiliation.md) and [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.nl.gf|current/StructureDefinition/nl-gf-authorassignedidentifier)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-authorassignedidentifier.csv), [Excel](StructureDefinition-nl-gf-authorassignedidentifier.xlsx), [Schematron](StructureDefinition-nl-gf-authorassignedidentifier.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-authorassignedidentifier",
  "url" : "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-authorassignedidentifier",
  "version" : "0.1.0",
  "name" : "AuthorAssignedIdentifier",
  "title" : " Author Assigned Identifier",
  "status" : "draft",
  "date" : "2026-02-17T17:25:51+00:00",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "Identifier assigned by the author of a resource, such as a healthcare service or organization, to uniquely identify that resource AND locate the original authoring organization when copies are stored at other locations ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Identifier",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Identifier",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Identifier",
        "path" : "Identifier"
      },
      {
        "id" : "Identifier.use",
        "path" : "Identifier.use",
        "min" : 1,
        "patternCode" : "official"
      },
      {
        "id" : "Identifier.system",
        "path" : "Identifier.system",
        "min" : 1
      },
      {
        "id" : "Identifier.value",
        "path" : "Identifier.value",
        "min" : 1
      },
      {
        "id" : "Identifier.assigner",
        "path" : "Identifier.assigner",
        "min" : 1
      },
      {
        "id" : "Identifier.assigner.identifier",
        "path" : "Identifier.assigner.identifier",
        "min" : 1
      },
      {
        "id" : "Identifier.assigner.identifier.type",
        "path" : "Identifier.assigner.identifier.type",
        "min" : 1
      },
      {
        "id" : "Identifier.assigner.identifier.type.coding",
        "path" : "Identifier.assigner.identifier.type.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Identifier.assigner.identifier.type.coding.system",
        "path" : "Identifier.assigner.identifier.type.coding.system",
        "patternUri" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type"
      },
      {
        "id" : "Identifier.assigner.identifier.type.coding.code",
        "path" : "Identifier.assigner.identifier.type.coding.code",
        "patternCode" : "author"
      },
      {
        "id" : "Identifier.assigner.identifier.system",
        "path" : "Identifier.assigner.identifier.system",
        "patternUri" : "http://fhir.nl/fhir/NamingSystem/ura"
      },
      {
        "id" : "Identifier.assigner.identifier.value",
        "path" : "Identifier.assigner.identifier.value",
        "min" : 1
      }
    ]
  }
}

```
