# LRZa - Organization 3 - Organization - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LRZa - Organization 3 - Organization**

## Example Organization: LRZa - Organization 3 - Organization

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/33333333

**type**: Verplegings- of verzorgingsinstelling

**name**: example Care Institution

**telecom**: [+31301234567](tel:+31301234567), [info@organization3.nl](mailto:info@organization3.nl)

**address**: Smidsstraat 10 Zelhem 7021 AC 

**endpoint**: [Endpoint FHIR Endpoint 3](Endpoint-lrza-e3.md)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "lrza-o3",
  "meta" : {
    "profile" : [
      "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-organization"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/ura",
      "value" : "33333333",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
          "value" : "50000535"
        }
      }
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
          "code" : "X3",
          "display" : "Verplegings- of verzorgingsinstelling"
        }
      ]
    }
  ],
  "name" : "example Care Institution",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+31301234567",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@organization3.nl",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["Smidsstraat 10"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Smidsstraat"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "10"
            }
          ]
        }
      ],
      "city" : "Zelhem",
      "postalCode" : "7021 AC"
    }
  ],
  "endpoint" : [
    {
      "reference" : "Endpoint/lrza-e3"
    }
  ]
}

```
