# Electronic Health Record System Example - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Electronic Health Record System Example**

## Example Device: Electronic Health Record System Example

**identifier**: `http://example.org/device-identifiers`/EHR-SYS-2024-001, [Uniform Resource Identifier (URI)](http://terminology.hl7.org/5.3.0/NamingSystem-uri.html)/urn:uuid:a1b2c3d4-e5f6-7890-abcd-ef1234567890

**status**: Active

**manufacturer**: HealthTech Solutions BV

> **deviceName****name**: MedicalRecords Pro**type**: User Friendly name

> **deviceName****name**: MRP-Enterprise-v5.2**type**: Model name

**modelNumber**: MRP-ENT-5.2.1

**type**: Electronic Health Record System

> **version****type**: software**value**: 5.2.1

> **version****type**: firmware**value**: 2.8.0

**owner**: Identifier: `http://fhir.nl/fhir/NamingSystem/kvk`/9999999

**contact**: [support@healthtech.example.com](mailto:support@healthtech.example.com), [+31201234567](tel:+31201234567)



## Resource Content

```json
{
  "resourceType" : "Device",
  "id" : "ehr-system-example-001",
  "identifier" : [
    {
      "system" : "http://example.org/device-identifiers",
      "value" : "EHR-SYS-2024-001"
    },
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:uuid:a1b2c3d4-e5f6-7890-abcd-ef1234567890"
    }
  ],
  "status" : "active",
  "manufacturer" : "HealthTech Solutions BV",
  "deviceName" : [
    {
      "name" : "MedicalRecords Pro",
      "type" : "user-friendly-name"
    },
    {
      "name" : "MRP-Enterprise-v5.2",
      "type" : "model-name"
    }
  ],
  "modelNumber" : "MRP-ENT-5.2.1",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "706689003",
        "display" : "Electronic health record system application software"
      }
    ],
    "text" : "Electronic Health Record System"
  },
  "version" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/device-versiontype",
            "code" : "software"
          }
        ]
      },
      "value" : "5.2.1"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/device-versiontype",
            "code" : "firmware"
          }
        ]
      },
      "value" : "2.8.0"
    }
  ],
  "owner" : {
    "identifier" : {
      "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
      "value" : "9999999"
    }
  },
  "contact" : [
    {
      "system" : "email",
      "value" : "support@healthtech.example.com"
    },
    {
      "system" : "phone",
      "value" : "+31201234567",
      "use" : "work"
    }
  ]
}

```
