# Localization Service (List) - Netherlands - Generic Functions for data exchange Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Localization Service (List)**

## CapabilityStatement: Localization Service (List) 

| | |
| :--- | :--- |
| *Official URL*:http://minvws.github.io/generiekefuncties-docs/CapabilityStatement/nl-gf-localization-repository-list | *Version*:0.1.0 |
| Active as of 2026-02-08 | *Computable Name*: |

 
Dutch profile of the CapabilityStatement for a Localization Service using the List resource. 

 [Raw OpenAPI-Swagger Definition file](nl-gf-localization-repository-list.openapi.json) | [Download](nl-gf-localization-repository-list.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "nl-gf-localization-repository-list",
  "url" : "http://minvws.github.io/generiekefuncties-docs/CapabilityStatement/nl-gf-localization-repository-list",
  "version" : "0.1.0",
  "title" : "Localization Service (List)",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-08",
  "publisher" : "Ministerie van Volksgezondheid, Welzijn en Sport",
  "contact" : [
    {
      "name" : "Ministerie van Volksgezondheid, Welzijn en Sport",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.minvws.nl"
        }
      ]
    }
  ],
  "description" : "Dutch profile of the CapabilityStatement for a Localization Service using the List resource.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["application/fhir+xml", "application/fhir+json"],
  "rest" : [
    {
      "mode" : "server",
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "List",
          "supportedProfile" : [
            "http://minvws.github.io/generiekefuncties-docs/StructureDefinition/nl-gf-localization-list"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "delete"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "patient.identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "code",
              "type" : "token"
            }
          ]
        }
      ],
      "interaction" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "code" : "transaction",
          "documentation" : "Support for Bundle transactions to create, update, or delete multiple List resources in a single request."
        }
      ]
    }
  ]
}

```
