/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.svg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.transform.TransformerException;
import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import net.sourceforge.plantuml.klimt.drawing.AbstractUGraphic;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverCenteredCharacterSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverDotPathSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverEllipseSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverImagePng;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverImageSvgSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverLineSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverPathSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverPixelSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverPolygonSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverRectangleSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverTextAsPathSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.DriverTextSvg;
import net.sourceforge.plantuml.klimt.drawing.svg.SvgGraphics;
import net.sourceforge.plantuml.klimt.drawing.svg.SvgOption;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import net.sourceforge.plantuml.klimt.shape.UComment;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.UPixel;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.url.Url;

public class UGraphicSvg
extends AbstractUGraphic<SvgGraphics>
implements ClipContainer {
    private final boolean textAsPath;
    private SvgOption option;

    @Override
    public double dpiFactor() {
        return 1.0;
    }

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        UGraphicSvg result = new UGraphicSvg(this.getStringBounder(), this.textAsPath);
        result.copy(this);
        result.option = this.option;
        return result;
    }

    private UGraphicSvg(StringBounder stringBounder, boolean textAsPath) {
        super(stringBounder);
        this.textAsPath = textAsPath;
        this.register();
    }

    public static UGraphicSvg build(SvgOption option, boolean textAsPath, long seed, StringBounder stringBounder) {
        UGraphicSvg result = new UGraphicSvg(stringBounder, textAsPath);
        result.copy(option.getBackcolor(), option.getColorMapper(), new SvgGraphics(seed, option));
        result.option = option;
        return result;
    }

    @Override
    protected boolean manageHiddenAutomatically() {
        return false;
    }

    @Override
    protected void beforeDraw() {
        ((SvgGraphics)this.getGraphicObject()).setHidden(this.getParam().isHidden());
    }

    @Override
    protected void afterDraw() {
        ((SvgGraphics)this.getGraphicObject()).setHidden(false);
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleSvg(this));
        if (this.textAsPath) {
            this.registerDriver(UText.class, new DriverTextAsPathSvg(this));
        } else {
            this.registerDriver(UText.class, new DriverTextSvg(this.getStringBounder(), this));
        }
        this.registerDriver(ULine.class, new DriverLineSvg(this));
        this.registerDriver(UPixel.class, new DriverPixelSvg());
        this.registerDriver(UPolygon.class, new DriverPolygonSvg(this));
        this.registerDriver(UEllipse.class, new DriverEllipseSvg(this));
        this.registerDriver(UImage.class, new DriverImagePng(this));
        this.registerDriver(UImageSvg.class, new DriverImageSvgSvg());
        this.registerDriver(UPath.class, new DriverPathSvg(this));
        this.registerDriver(DotPath.class, new DriverDotPathSvg());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterSvg());
    }

    public SvgGraphics getSvgGraphics() {
        return (SvgGraphics)this.getGraphicObject();
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        try {
            if (metadata != null) {
                ((SvgGraphics)this.getGraphicObject()).addCommentMetadata(metadata);
            }
            ((SvgGraphics)this.getGraphicObject()).createXml(os);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void startGroup(Map<UGroupType, String> typeIdents) {
        ((SvgGraphics)this.getGraphicObject()).startGroup(typeIdents);
    }

    @Override
    public void closeGroup() {
        ((SvgGraphics)this.getGraphicObject()).closeGroup();
    }

    @Override
    public void startUrl(Url url) {
        ((SvgGraphics)this.getGraphicObject()).openLink(url.getUrl(), url.getTooltip(), this.option.getLinkTarget());
    }

    @Override
    public void closeUrl() {
        ((SvgGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    protected void drawComment(UComment comment) {
        ((SvgGraphics)this.getGraphicObject()).addComment(comment.getComment());
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        if (propertyName.equalsIgnoreCase("SVG")) {
            return true;
        }
        return super.matchesProperty(propertyName);
    }
}

