# EER System Extension - MSH - DK EHMI Endpoint Register (EER) - Configurations v1.0.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EER System Extension - MSH**

## Extension: EER System Extension - MSH 

| | |
| :--- | :--- |
| *Official URL*:http://medcomehmi.dk/ig/eer-config/StructureDefinition/eer-dk-msh-system-extension | *Version*:1.0.0-draft |
| Draft as of 2025-11-13 | *Computable Name*:EerMSHSystemExtension |

Reference to a Device that is used to specify one or more systems which an Endpoint uses This is equivalent to the SOR-element

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/dk.ehmi.eer-config|current/StructureDefinition/eer-dk-msh-system-extension)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-eer-dk-msh-system-extension.csv), [Excel](StructureDefinition-eer-dk-msh-system-extension.xlsx), [Schematron](StructureDefinition-eer-dk-msh-system-extension.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "eer-dk-msh-system-extension",
  "url" : "http://medcomehmi.dk/ig/eer-config/StructureDefinition/eer-dk-msh-system-extension",
  "version" : "1.0.0-draft",
  "name" : "EerMSHSystemExtension",
  "title" : "EER System Extension - MSH",
  "status" : "draft",
  "date" : "2025-11-13T21:33:42+00:00",
  "publisher" : "MedCom",
  "contact" : [
    {
      "name" : "MedCom",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://medcom.dk"
        },
        {
          "system" : "email",
          "value" : "ehmi@medcom.dk"
        }
      ]
    }
  ],
  "description" : "Reference to a Device that is used to specify one or more systems which an Endpoint uses\nThis is equivalent to the SOR-element",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "DK",
          "display" : "Denmark"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Element"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "EER System Extension - MSH",
        "definition" : "Reference to a Device that is used to specify one or more systems which an Endpoint uses\nThis is equivalent to the SOR-element"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://medcomehmi.dk/ig/eer-config/StructureDefinition/eer-dk-msh-system-extension"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://medcomehmi.dk/ig/eer/StructureDefinition/EerDevice"]
          }
        ]
      }
    ]
  }
}

```
