# DigitalSundhedDanmark-EerEndpointMessaging-eDelivery-DDS-TEST1 - DK EHMI Endpoint Register (EER) - Configurations v1.0.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DigitalSundhedDanmark-EerEndpointMessaging-eDelivery-DDS-TEST1**

## Example Endpoint: DigitalSundhedDanmark-EerEndpointMessaging-eDelivery-DDS-TEST1

Profile: [EER Endpoint - General for Messaging](https://build.fhir.org/ig/medcomdk/dk-ehmi-eer/StructureDefinition-eer.dk.endpoint.messaging.html)

**EER System Extension - MSH**: [Device: identifier = NSPMSH-test-DDS; status = active; manufacturer = KvalitetsIT; type = Message Service Handler](Device-NSPMSH-test-DDS.md)

**EER System Extension - AP**: [Device: identifier = NSPAP-test-DDS; status = active; manufacturer = KvalitetsIT; type = eDelivery Access Point](Device-NSPAP-test-DDS.md)

**identifier**: `https://www.gs1.org/gln`/5790002515811

**status**: Active

**connectionType**: [EHMI Endpoint Register (EER) - Connection Types CS: EerMessagingEdelivery](https://build.fhir.org/ig/medcomdk/dk-ehmi-terminology/CodeSystem-eer-endpoint-connection-type.html#eer-endpoint-connection-type-EerMessagingEdelivery) (EHMI messaging via eDelivery)

**name**: DigitalSundhedDanmark-EerEndpointMessaging-eDelivery-eDelivery-DDS-TEST1

**managingOrganization**: [Organization DigitalSundhedDanmark-Organization-eDelivery (1134981000016000)](Organization-1134981000016000.md)

**period**: 2026-01-01 --> (ongoing)

**payloadType**: HomeCareObservation 1.1

**payloadMimeType**: text/xml, application/fhir+xml, application/fhir+json

**address**: [http://www.dsd-dds.dk/dds-test1](http://www.dsd-dds.dk/dds-test1)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "5790002515811",
  "meta" : {
    "profile" : [
      "http://medcomehmi.dk/ig/eer/StructureDefinition/eer.dk.endpoint.messaging"
    ]
  },
  "extension" : [
    {
      "url" : "http://medcomehmi.dk/ig/eer/StructureDefinition/eer-dk-msh-system-extension",
      "valueReference" : {
        "reference" : "Device/NSPMSH-test-DDS"
      }
    },
    {
      "url" : "http://medcomehmi.dk/ig/eer/StructureDefinition/eer-dk-ap-system-extension",
      "valueReference" : {
        "reference" : "Device/NSPAP-test-DDS"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://www.gs1.org/gln",
      "value" : "5790002515811"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-endpoint-connection-type",
    "code" : "EerMessagingEdelivery"
  },
  "name" : "DigitalSundhedDanmark-EerEndpointMessaging-eDelivery-eDelivery-DDS-TEST1",
  "managingOrganization" : {
    "reference" : "Organization/1134981000016000"
  },
  "period" : {
    "start" : "2026-01-01"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition:homecareobservation:1.1"
        }
      ]
    }
  ],
  "payloadMimeType" : ["text/xml", "application/fhir+xml", "application/fhir+json"],
  "address" : "http://www.dsd-dds.dk/dds-test1"
}

```
