# 352264ea-9bee-4957-8c8f-c5aff61e1d44 - DK EHMI Endpoint Register (EER) - Configurations v1.0.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **352264ea-9bee-4957-8c8f-c5aff61e1d44**

## Example Endpoint: 352264ea-9bee-4957-8c8f-c5aff61e1d44

Profile: [EER Endpoint - General for Messaging](https://build.fhir.org/ig/medcomdk/dk-ehmi-eer/StructureDefinition-eer.dk.endpoint.messaging.html)

**EER System Extension - MSH**: [Device: identifier = MultiMedMSH-prod-LPS; status = active; manufacturer = MultiMed; type = Message Service Handler](Device-MultiMedMSH-prod-LPS.md)

**EER System Extension - AP**: [Device: identifier = MultiMedAP-prod-LPS; status = active; manufacturer = MultiMed; type = eDelivery Access Point](Device-MultiMedAP-prod-LPS.md)

**identifier**: GLN/5790001995669

**status**: Active

**connectionType**: [EHMI Endpoint Register (EER) - Connection Types CS: EerMessagingEdelivery](https://build.fhir.org/ig/medcomdk/dk-ehmi-terminology/CodeSystem-eer-endpoint-connection-type.html#eer-endpoint-connection-type-EerMessagingEdelivery) (EHMI messaging via eDelivery)

**name**: EER Messaging Endpoint - TrøjborgLægehusI/S.8200.AarhusN.468851000016000 FHIR Endpoint

**managingOrganization**: [Organization Trøjborg Lægehus I/S (468851000016000)](Organization-69b3d28b-7eb6-4e91-bf8b-b03df44243f8.md)

**period**: 2023-08-11 00:00:00+0200 --> (ongoing)

**payloadType**: HomeCareObservation 1.1, Acknowledgement 2.0

**payloadMimeType**: text/xml, application/fhir+xml, application/fhir+json

**address**: [https://example.org/fhir](https://example.org/fhir)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "352264ea-9bee-4957-8c8f-c5aff61e1d44",
  "meta" : {
    "profile" : [
      "http://medcomehmi.dk/ig/eer/StructureDefinition/eer.dk.endpoint.messaging"
    ]
  },
  "extension" : [
    {
      "url" : "http://medcomehmi.dk/ig/eer/StructureDefinition/eer-dk-msh-system-extension",
      "valueReference" : {
        "reference" : "Device/MultiMedMSH-prod-LPS"
      }
    },
    {
      "url" : "http://medcomehmi.dk/ig/eer/StructureDefinition/eer-dk-ap-system-extension",
      "valueReference" : {
        "reference" : "Device/MultiMedAP-prod-LPS"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-delivery-status-agent-who-identifier-types",
            "code" : "GLN"
          }
        ]
      },
      "system" : "https://www.gs1.org/gln",
      "value" : "5790001995669"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-endpoint-connection-type",
    "code" : "EerMessagingEdelivery"
  },
  "name" : "EER Messaging Endpoint - TrøjborgLægehusI/S.8200.AarhusN.468851000016000 FHIR Endpoint",
  "managingOrganization" : {
    "reference" : "Organization/69b3d28b-7eb6-4e91-bf8b-b03df44243f8",
    "type" : "Organization",
    "identifier" : {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-sor-organization-identier-type",
            "code" : "SORID",
            "display" : "SOR Identifier"
          }
        ]
      },
      "system" : "urn:oid:1.2.208.176.1.1",
      "value" : "468851000016000"
    }
  },
  "period" : {
    "start" : "2023-08-11T00:00:00+02:00"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition:homecareobservation:1.1"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition:acknowledgement:2.0"
        }
      ]
    }
  ],
  "payloadMimeType" : ["text/xml", "application/fhir+xml", "application/fhir+json"],
  "address" : "https://example.org/fhir"
}

```
