# Artifacts Summary - DK EHMI Endpoint Register (EER) - Configurations v1.0.0-draft

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [EER System Extension - AP](StructureDefinition-eer-dk-network-supply-system-extension.md) | Reference to a Device that is used to specify one or more systems which an Endpoint uses |
| [EER System Extension - EUA](StructureDefinition-eer-dk-eua-system-extension.md) | Reference to a Device that is used to specify one or more systems which an Endpoint uses This is equivalent to the SOR-element |
| [EER System Extension - MSH](StructureDefinition-eer-dk-msh-system-extension.md) | Reference to a Device that is used to specify one or more systems which an Endpoint uses This is equivalent to the SOR-element |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [352264ea-9bee-4957-8c8f-c5aff61e1d44](Endpoint-352264ea-9bee-4957-8c8f-c5aff61e1d44.md) | Endpoint instance |
| [69b3d28b-7eb6-4e91-bf8b-b03df44243f8](Organization-69b3d28b-7eb6-4e91-bf8b-b03df44243f8.md) | Organization instance |
| [DigitalSundhedDanmark-EerEndpointMessaging-eDelivery-DDS-PROD](Endpoint-5790002515804.md) | DigitalSundhedDanmark-EerEndpointMessaging–eDelivery-DDS-PROD for PROD |
| [DigitalSundhedDanmark-EerEndpointMessaging-eDelivery-DDS-TEST1](Endpoint-5790002515811.md) | DigitalSundhedDanmark-EerEndpointMessaging-eDelivery-eDelivery-DDS-TEST1 for NSP TEST1 |
| [DigitalSundhedDanmark-EerEndpointMessaging-eDelivery-DDS-TEST2](Endpoint-5790002515798.md) | DigitalSundhedDanmark-EerEndpointMessaging-eDelivery-eDelivery-DDS-TEST2 for NSP TEST2 |
| [DigitalSundhedDanmark-Organization-MedCom](Organization-325421000016001.md) | DigitalSundhedDanmark - IE for the SOR eDelivery tree at SDS (In the MedCom SOR-tree) |
| [DigitalSundhedDanmark-Organization-eDelivery](Organization-1134981000016000.md) | DigitalSundhedDanmark - SI for the SOR eDelivery tree at SDS (In the MedCom SOR-tree) |
| [DigitalSundhedDanmark-Organization-eDelivery-DDS-PROD](Organization-1135011000016005.md) | DigitalSundhedDanmark - OE for the SOR eDelivery tree at SDS for the PROD Endpoint |
| [DigitalSundhedDanmark-Organization-eDelivery-eDelivery-DDS-TEST1](Organization-1135051000016009.md) | DigitalSundhedDanmark - OE for the SOR eDelivery tree at SDS for the TEST1 Endpoint |
| [DigitalSundhedDanmark-Organization-eDelivery-eDelivery-DDS-TEST2](Organization-1134991000016003.md) | DigitalSundhedDanmark - OE for the SOR eDelivery tree at SDS for the TEST2 Endpoint |
| [EER Messaging Endpoint - LaegerneStjernepladsen.8200.AarhusN.5790002401428](Endpoint-LaegerneStjernepladsen.8200.AarhusN.5790002401428.md) | EER Messaging Endpoint - LaegerneStjernepladsen.8200.AarhusN.5790002401428 |
| [EER Messaging Organization - LaegerneStjernepladsen.8200.AarhusN.698141000016008](Organization-LaegerneStjernepladsen.8200.AarhusN.698141000016008.md) | EER Messaging Organization - LaegerneStjernepladsen.8200.AarhusN.698141000016008 |
| [EER Messaging Organization - LaegerneStjernepladsen.8200.AarhusN.698161000016009](Organization-LaegerneStjernepladsen.8200.AarhusN.698161000016009.md) | EER Messaging Organization - LaegerneStjernepladsen.8200.AarhusN.698161000016009 |
| [EerDevice-EGClineaEUA-prod-aarhus](Device-EGClineaEUA-prod-aarhus.md) | EerDevice-EGClineaEUA |
| [EerDevice-EGClineaEUA-prod-kobenhavn](Device-EGClineaEUA-prod-kobenhavn.md) | EerDevice-EGClineaEUA-prod-kobenhavn |
| [EerDevice-EGClineaEUA-test-aarhus](Device-EGClineaEUA-test-aarhus.md) | EerDevice-EGClineaEUA |
| [EerDevice-EGClineaEUA-test-kobenhavn](Device-EGClineaEUA-test-kobenhavn.md) | EerDevice-EGClineaEUA |
| [EerDevice-KvalitetsItAP-prod-aarhus](Device-KvalitetsItAP-prod-aarhus.md) | EerDevice-KvalitetsItAP |
| [EerDevice-KvalitetsItAP-prod-kobenhavn](Device-KvalitetsItAP-prod-kobenhavn.md) | EerDevice-KvalitetsItAP |
| [EerDevice-KvalitetsItAP-test-aarhus](Device-KvalitetsItAP-test-aarhus.md) | EerDevice-KvalitetsItAP |
| [EerDevice-KvalitetsItAP-test-kobenhavn](Device-KvalitetsItAP-test-kobenhavn.md) | EerDevice-KvalitetsItAP |
| [EerDevice-MultiMedAP-prod-LPS](Device-MultiMedAP-prod-LPS.md) | EerDevice-MultiMed AP |
| [EerDevice-MultiMedAP-test-LPS](Device-MultiMedAP-test-LPS.md) | EerDevice-MultiMed AP |
| [EerDevice-MultiMedMSH-prod-LPS](Device-MultiMedMSH-prod-LPS.md) | EerDevice-MultiMedMSH |
| [EerDevice-MultiMedMSH-test-LPS](Device-MultiMedMSH-test-LPS.md) | EerDevice-MultiMedMSH |
| [EerDevice-NSPAP-prod-DDS](Device-NSPAP-prod-DDS.md) | EerDevice-NSPAP-prod-DDS |
| [EerDevice-NSPAP-test-DDS](Device-NSPAP-test-DDS.md) | EerDevice-NSPAP-test-DDS |
| [EerDevice-NSPEUA-prod-DDS](Device-NSPEUA-prod-DDS.md) | EerDevice-NSPEUA-prod-DDS |
| [EerDevice-NSPEUA-test-DDS](Device-NSPEUA-test-DDS.md) | EerDevice-NSPEUA-test-DDS |
| [EerDevice-NSPMSH-prod-DDS](Device-NSPMSH-prod-DDS.md) | EerDevice-NSPMSH-prod-DDS |
| [EerDevice-NSPMSH-test-DDS](Device-NSPMSH-test-DDS.md) | EerDevice-NSPMSH-test-DDS |
| [EerDevice-SystematicCuraEUA-prod-aarhus](Device-SystematicCuraEUA-prod-aarhus.md) | EerDevice-SystematicCuraEUA for Aarhus |
| [EerDevice-SystematicCuraEUA-prod-kobenhavn](Device-SystematicCuraEUA-prod-kobenhavn.md) | EerDevice-SystematicCuraEUA for Copenhagen |
| [EerDevice-SystematicCuraEUA-test-aarhus](Device-SystematicCuraEUA-test-aarhus.md) | EerDevice-SystematicCuraEUA for Aarhus |
| [EerDevice-SystematicCuraEUA-test-kobenhavn](Device-SystematicCuraEUA-test-kobenhavn.md) | EerDevice-SystematicCuraEUA for Copenhagen |
| [EerDevice-SystematicCuraMSH-prod-aarhus](Device-SystematicCuraMSH-prod-aarhus.md) | EerDevice-SystematicCuraMSH for Aarhus |
| [EerDevice-SystematicCuraMSH-prod-kobenhavn](Device-SystematicCuraMSH-prod-kobenhavn.md) | EerDevice-SystematicCuraMSH for Copenhagen |
| [EerDevice-SystematicMSH-test-aarhus](Device-SystematicMSH-test-aarhus.md) | EerDevice-SystematicMSH for Aarhus |
| [EerDevice-SystematicMSH-test-kobenhavn](Device-SystematicMSH-test-kobenhavn.md) | EerDevice-SystematicMSH for Copenhagen |
| [Example EER Messaging Organization](Organization-LaegerneStjernepladsen.8200.AarhusN.698131000016001.md) | An example instance of the EER Messaging Organization with a required endpoint. |
| [c8dac996-4210-45fc-bc6c-be64ae3f82ec](Organization-c8dac996-4210-45fc-bc6c-be64ae3f82ec.md) | Organization instance |
| [d627cb60-c3e3-4ae0-bca9-88c668ea627e](Organization-d627cb60-c3e3-4ae0-bca9-88c668ea627e.md) | Organization instance |
| [d741b66b-41cc-4f05-b0b2-ab631ddf6369](Organization-d741b66b-41cc-4f05-b0b2-ab631ddf6369.md) | Organization instance |

