# Example EER Messaging Organization - DK EHMI Endpoint Register (EER) - Configurations v1.0.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example EER Messaging Organization**

## Example Organization: Example EER Messaging Organization

Profile: [EerMessagingOrganization](https://build.fhir.org/ig/medcomdk/dk-ehmi-eer/StructureDefinition-Eer.Messaging.Organization.html)

**EER System Extension - EUA**: [Device: identifier = EerDevice-EGClineaEUA-test-aarhus; status = active; manufacturer = EG; type = End User Application](Device-EGClineaEUA-test-aarhus.md)

**EER System Extension - EUA**: [Device: identifier = EerDevice-EGClineaEUA-prod-aarhus; status = active; manufacturer = EG; type = End User Application](Device-EGClineaEUA-prod-aarhus.md)

**identifier**: `urn:oid:1.2.208.176.1.1`/543210987654321

**type**: Institutionsejer

**name**: Lægerne Stjernepladsen I/S

**endpoint**: [Endpoint EER Messaging Endpoint - LaegerneStjernepladsen.8200.AarhusN.5790002401428 FHIR Endpoint](Endpoint-LaegerneStjernepladsen.8200.AarhusN.5790002401428.md)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "LaegerneStjernepladsen.8200.AarhusN.698131000016001",
  "meta" : {
    "profile" : [
      "http://medcomehmi.dk/ig/eer/StructureDefinition/Eer.Messaging.Organization"
    ]
  },
  "extension" : [
    {
      "url" : "http://medcomehmi.dk/ig/eer/StructureDefinition/eer-dk-eua-system-extension",
      "valueReference" : {
        "reference" : "Device/EGClineaEUA-test-aarhus"
      }
    },
    {
      "url" : "http://medcomehmi.dk/ig/eer/StructureDefinition/eer-dk-eua-system-extension",
      "valueReference" : {
        "reference" : "Device/EGClineaEUA-prod-aarhus"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "urn:oid:1.2.208.176.1.1",
      "value" : "543210987654321"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-sor-organization-type",
          "code" : "IO"
        }
      ]
    }
  ],
  "name" : "Lægerne Stjernepladsen I/S",
  "endpoint" : [
    {
      "reference" : "Endpoint/LaegerneStjernepladsen.8200.AarhusN.5790002401428"
    }
  ]
}

```
