# IHE Index - DK EHMI Endpoint Register (EER) - Configurations v1.0.1-draft

* [**Table of Contents**](toc.md)
* **IHE Index**

## IHE Index

The Mobile Care Services Discovery (mCSD) Profile supports RESTful queries across related care services resources.

The loosely coupled design and flexible querying capability of the mCSD Profile means it can be deployed within a variety of eHealth architectures and support a wide array of care workflows.

| |
| :--- |
| [Significant Changes, Open, and Closed Issues](https://profiles.ihe.net/ITI/mCSD/issues.html) |

**[Search this IG](https://www.google.com/search?q=site%3Ahttps%3A%2F%2Fprofiles.ihe.net%2FITI%2FmCSD)**

### Organization of This Guide

This guide is organized into the following four main sections:

1. Volume 1: Profiles
1. [mCSD Introduction](IHE-volume-1.md)
1. [mCSD Actors, Transactions, and Content Modules](IHE-volume-1.md#1461-mcsd-actors-transactions-and-content-modules)
1. [mCSD Actor Options](IHE-volume-1.md#1462-mcsd-actor-options)
1. [mCSD Required Groupings](IHE-volume-1.md#1463-mcsd-required-actor-groupings)
1. [mCSD Overview](IHE-volume-1.md#1464-mcsd-overview)
1. [mCSD Security Considerations](IHE-volume-1.md#1465-mcsd-security-considerations)
1. [mCSD Cross-Profile Considerations](IHE-volume-1.md#1466-mcsd-cross-profile-considerations)
1. [mCSD Deployment Considerations](IHE-volume-1.md#1467-mcsd-deployment-considerations)
1. [mCSD Endpoint Usage Considerations](IHE-volume-1.md#1468-mcsd-endpoint-usage-considerations)

1. Volume 2: Transaction Detail
1. [Find Matching Care Services [IHE-ITI-90]](IHE-ITI-90.md)
1. [Request Care Services Updates [IHE-ITI-91]](IHE-ITI-91.md)

1. [Test Plan](https://profiles.ihe.net/ITI/mCSD/testplan.html)
1. [Changes to other Profiles](https://profiles.ihe.net/ITI/mCSD/other.html)

Click on any of the links above, navigate the contents using the [table of contents](toc.md), or if you are looking for a specific artifact, check out the [index](artifacts.md).

### Conformance Expectations

IHE uses the normative words: Shall, Should, and May according to [standards conventions](https://profiles.ihe.net/GeneralIntro/ch-E.html).

mCSD uses `Must Support` in StructureDefinition profiles. This is equivalent to the IHE use of **R2** as defined in [Appendix Z](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.10-profiling-conventions-for-constraints-on-fhir).

### Download

You can also download:

* [this entire guide](full-ig.zip),
* the definition resources in [json](definitions.json.zip), [xml](definitions.xml.zip), [ttl](definitions.ttl.zip), or [csv](csvs.zip) format, or
* the example resources in [json](examples.json.zip), [xml](examples.xml.zip) or [ttl](examples.ttl.zip) format.

The source code for this Implementation Guide can be found on [IHE GitHub](https://github.com/IHE/ITI.mCSD). <!–

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (dk.ehmi.eer-config.r4)](package.r4.tgz) and [R4B (dk.ehmi.eer-config.r4b)](package.r4b.tgz) are available.

#### Dependency Table
























#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [EHMIEndpointRegisterEERIGConfigurations](index.md)


–>

