# DefaultEndpoint - DK EHMI Endpoint Register (EER) - Configurations v1.0.1-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DefaultEndpoint**

## Example Endpoint: DefaultEndpoint

Profile: [EER Endpoint - General for Messaging](https://build.fhir.org/ig/medcomdk/dk-ehmi-eer/StructureDefinition-eer.dk.endpoint.messaging.html)

**identifier**: GLN/9999999999999

**status**: Active

**connectionType**: [EHMI Endpoint Register (EER) - Connection Types CS: EerMessagingEdelivery](https://build.fhir.org/ig/medcomdk/dk-ehmi-terminology/CodeSystem-eer-endpoint-connection-type.html#eer-endpoint-connection-type-EerMessagingEdelivery) (EHMI messaging via eDelivery)

**name**: EER Messaging Endpoint - Default FHIR Endpoint

**managingOrganization**: [Organization Default Org. Not used for anything.](Organization-DefaultOrg.md)

**period**: 2026-02-03 00:00:00+0100 --> (ongoing)

**payloadType**: Acknowledgement 2.0, ehmiSBDH Acknowledgement 1.0

**payloadMimeType**: text/xml, application/fhir+xml, application/fhir+json

**address**: [https://example.org/fhir](https://example.org/fhir)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "DefaultEndpoint",
  "meta" : {
    "profile" : ["http://medcomehmi.dk/ig/eer/StructureDefinition/eer.dk.endpoint.messaging"]
  },
  "identifier" : [{
    "type" : {
      "coding" : [{
        "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-delivery-status-agent-who-identifier-types",
        "code" : "GLN"
      }]
    },
    "system" : "http://www.gs1.org/gln",
    "value" : "9999999999999"
  }],
  "status" : "active",
  "connectionType" : {
    "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-endpoint-connection-type",
    "code" : "EerMessagingEdelivery"
  },
  "name" : "EER Messaging Endpoint - Default FHIR Endpoint",
  "managingOrganization" : {
    "reference" : "Organization/DefaultOrg"
  },
  "period" : {
    "start" : "2026-02-03T00:00:00+01:00"
  },
  "payloadType" : [{
    "coding" : [{
      "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
      "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition::acknowledgement-message##urn:dk:medcom:fhir:acknowledgement-message::2.0"
    }]
  },
  {
    "coding" : [{
      "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
      "code" : "urn:dk:healthcare:messaging:oasis:ebxml:schema:xsd::ehmisbdh-acknowledgement##urn:dk:ehmi:sbdh:ehmisbdh-acknowledgement::1.0"
    }]
  }],
  "payloadMimeType" : ["text/xml", "application/fhir+xml", "application/fhir+json"],
  "address" : "https://example.org/fhir"
}

```
