# SOR EER Mapping - DK EHMI Endpoint Register (EER) - Configurations v1.0.0-draft

* [**Table of Contents**](toc.md)
* **SOR EER Mapping**

## SOR EER Mapping

# EER and SOR

Traditionally messaging metadata for a SOR unit has been placed in SOR and SOR-EDI.

EER replaces and reorganizes how these messaging metadata are represented.

The following table gives and overview of how these messaging metadata are mapped and reorganized in EER:

* SOR: SOR-Unit
  * EER: EER-Organization
  * Link: [EER-SOR-Organization](./StructureDefinition-Eer.Messaging.Organization.md)
  * Notes: Note, that this is EER-SOR-Organization representing the SOR-Unit is only carrying the most necessary information from SOR. It is not a complete representation of the SOR unit. It holds the relationship between the SOR-unit and the EER-Endpoint.***Most importantly it will not carry the GLN-identifier as it has been moved to the Endpoint ressource***
* SOR: SOR-EDI
  * EER: EER-Endpoint with MedCom MessageDefinitions as payloadType
  * Link: [EER-Endpoint](./StructureDefinition-eer.dk.endpoint.md)
  * Notes: EER-Endpoint represents or hold relationsships to all metadata regarding an endpoint in EHMI. EER-Endpoint holds relationsships to all MedCom Messages through the references of payloadTypes (MedCom MessageDefinitions). A MedCom MessageDefinition is defined together with the FHIR Message Profile and is included in an IG
* SOR: SOR-GLN (attribute)
  * EER: EER-Endpoint
  * Link: [EER-Endpoint](./StructureDefinition-eer.dk.endpoint.md)
  * Notes: In EHMI messaging it will hold SOR-GLN is now the primary identifier of an EER-Endpoint ressource
* SOR: SOR-System (attribute)
  * EER: EER-Device
  * Link: [EER-Device](https://medcomehmi.dk/ig/eer/StructureDefinition-EerDevice.html)
  * Notes: EER-Device represents the System, End-User Application (EUA), that operates for the organization on the endpoint. Only MedCom Certified Systems can appear as a EER-device
* SOR: SOR-Network Supply System (attribute)
  * EER: EER-Device
  * Link: [EER-Device](https://medcomehmi.dk/ig/eer/StructureDefinition-EerDevice.html)
  * Notes: EER-Device represents the network System, Message Service Handler (MSH) or eDelivery Access Point (AP), that operates for the organization on the endpoint. While SOR-System is the actal EUA, the SOR-Network is the more technical device that connects with the EHMI Network. Only MedCom Certified Systems can appear as a EER-device
* SOR: x
  * EER: y
  * Link: Link
  * Notes: z

