# 5790000131150 - DK EHMI Endpoint Register (EER) - Configurations v1.0.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **5790000131150**

## Example Endpoint: 5790000131150

Profile: [EER Endpoint - General for Messaging](https://build.fhir.org/ig/medcomdk/dk-ehmi-eer/StructureDefinition-eer.dk.endpoint.messaging.html)

**identifier**: GLN/5790000131150

**status**: Suspended

**connectionType**: [EHMI Endpoint Register (EER) - Connection Types CS: EerMessagingEdelivery](https://build.fhir.org/ig/medcomdk/dk-ehmi-terminology/CodeSystem-eer-endpoint-connection-type.html#eer-endpoint-connection-type-EerMessagingEdelivery) (EHMI messaging via eDelivery)

**name**: EER Messaging Endpoint - LægehusetRyesgade1.8000.AarhusC.38141000016007 FHIR Endpoint

**managingOrganization**: [Organization Lægehuset Ryesgade 1 (38141000016007)](Organization-38141000016007.md)

**period**: 2021-12-23 00:00:00+0100 --> (ongoing)

**payloadType**: HomeCareObservation 1.1, Acknowledgement 2.0

**payloadMimeType**: text/xml, application/fhir+xml, application/fhir+json

**address**: [https://example.org/fhir](https://example.org/fhir)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "5790000131150",
  "meta" : {
    "profile" : [
      "http://medcomehmi.dk/ig/eer/StructureDefinition/eer.dk.endpoint.messaging"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-delivery-status-agent-who-identifier-types",
            "code" : "GLN"
          }
        ]
      },
      "system" : "https://www.gs1.org/gln",
      "value" : "5790000131150"
    }
  ],
  "status" : "suspended",
  "connectionType" : {
    "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-endpoint-connection-type",
    "code" : "EerMessagingEdelivery"
  },
  "name" : "EER Messaging Endpoint - LægehusetRyesgade1.8000.AarhusC.38141000016007 FHIR Endpoint",
  "managingOrganization" : {
    "reference" : "Organization/38141000016007",
    "type" : "Organization",
    "identifier" : {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-sor-organization-identier-type",
            "code" : "SORID",
            "display" : "SOR Identifier"
          }
        ]
      },
      "system" : "urn:oid:1.2.208.176.1.1",
      "value" : "38141000016007"
    }
  },
  "period" : {
    "start" : "2021-12-23T00:00:00+01:00"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition:homecareobservation:1.1"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition:acknowledgement:2.0"
        }
      ]
    }
  ],
  "payloadMimeType" : ["text/xml", "application/fhir+xml", "application/fhir+json"],
  "address" : "https://example.org/fhir"
}

```
