# dk.ehmi.eer-config#1.0.0-draft: DK EHMI Endpoint Register (EER) - Configurations

## Pages

* [Home](index.md)
* [SOR EER Mapping](SOR-EER-mapping.md)
* [Extensions](extensions.md)
* [Instances Endpoints](instances-endpoints.md)
* [Instances Devices](instances-devices.md)
* [IHE ITI 91](IHE-ITI-91.md)
* [IHE Index](IHE-index.md)
* [Terminology](terminology.md)
* [Instances Organizations](instances-organizations.md)
* [Dependencies](dependencies.md)
* [Security English](security-english.md)
* [IHE ITI 90](IHE-ITI-90.md)
* [Xhtml Fragments](xhtml-fragments.md)
* [Security Danish](security-danish.md)
* [IHE Volume 1](IHE-volume-1.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](downloads.md)

## Resources

### ImplementationGuides

* [DK EHMI Endpoint Register (EER) - Configurations](index.md)

### Examples

* [EGClineaEUA-prod-aarhus (Device)](Device-EGClineaEUA-prod-aarhus.md)
* [EGClineaEUA-prod-kobenhavn (Device)](Device-EGClineaEUA-prod-kobenhavn.md)
* [EGClineaEUA-test-aarhus (Device)](Device-EGClineaEUA-test-aarhus.md)
* [EGClineaEUA-test-kobenhavn (Device)](Device-EGClineaEUA-test-kobenhavn.md)
* [EMR-AP-prod-PROD (Device)](Device-EMR-AP-prod-PROD.md)
* [EMR-AP-test-TEST1 (Device)](Device-EMR-AP-test-TEST1.md)
* [EMR-AP-test-TEST2 (Device)](Device-EMR-AP-test-TEST2.md)
* [KvalitetsItAP-prod-aarhus (Device)](Device-KvalitetsItAP-prod-aarhus.md)
* [KvalitetsItAP-prod-kobenhavn (Device)](Device-KvalitetsItAP-prod-kobenhavn.md)
* [KvalitetsItAP-test-aarhus (Device)](Device-KvalitetsItAP-test-aarhus.md)
* [KvalitetsItAP-test-kobenhavn (Device)](Device-KvalitetsItAP-test-kobenhavn.md)
* [MultiMedAP-prod-LPS (Device)](Device-MultiMedAP-prod-LPS.md)
* [MultiMedAP-test-LPS (Device)](Device-MultiMedAP-test-LPS.md)
* [MultiMedMSH-prod-LPS (Device)](Device-MultiMedMSH-prod-LPS.md)
* [MultiMedMSH-test-LPS (Device)](Device-MultiMedMSH-test-LPS.md)
* [NSP-EMR-MSH-prod-PROD (Device)](Device-NSP-EMR-MSH-prod-PROD.md)
* [NSP-EMR-MSH-test-TEST1 (Device)](Device-NSP-EMR-MSH-test-TEST1.md)
* [NSP-EMR-MSH-test-TEST2 (Device)](Device-NSP-EMR-MSH-test-TEST2.md)
* [SystematicCuraEUA-prod-aarhus (Device)](Device-SystematicCuraEUA-prod-aarhus.md)
* [SystematicCuraEUA-prod-kobenhavn (Device)](Device-SystematicCuraEUA-prod-kobenhavn.md)
* [SystematicCuraEUA-test-aarhus (Device)](Device-SystematicCuraEUA-test-aarhus.md)
* [SystematicCuraEUA-test-kobenhavn (Device)](Device-SystematicCuraEUA-test-kobenhavn.md)
* [SystematicCuraMSH-prod-aarhus (Device)](Device-SystematicCuraMSH-prod-aarhus.md)
* [SystematicCuraMSH-prod-kobenhavn (Device)](Device-SystematicCuraMSH-prod-kobenhavn.md)
* [SystematicMSH-test-aarhus (Device)](Device-SystematicMSH-test-aarhus.md)
* [SystematicMSH-test-kobenhavn (Device)](Device-SystematicMSH-test-kobenhavn.md)
* [EER Messaging Endpoint - SundhedogOmsorg.8260.VibyJ.937961000016000 FHIR Endpoint (Endpoint)](Endpoint-5790000123117.md)
* [EER Messaging Endpoint - Banegårdslægerne.8000.AarhusC.83991000016000 FHIR Endpoint (Endpoint)](Endpoint-5790000125159.md)
* [EER Messaging Endpoint - LægerneiMalling.8340.Malling.57361000016005 FHIR Endpoint (Endpoint)](Endpoint-5790000125876.md)
* [EER Messaging Endpoint - SkejbylægerneI/S.8200.AarhusN.56221000016006 FHIR Endpoint (Endpoint)](Endpoint-5790000126101.md)
* [EER Messaging Endpoint - LægerneØstergadeI/S.8000.AarhusC.55701000016003 FHIR Endpoint (Endpoint)](Endpoint-5790000126330.md)
* [EER Messaging Endpoint - LægerneJohanssonBechtoldI/S.8520.Lystrup.55471000016004 FHIR Endpoint (Endpoint)](Endpoint-5790000126392.md)
* [EER Messaging Endpoint - FamilielægerneiHolmeI/S.8270.Højbjerg.54401000016009 FHIR Endpoint (Endpoint)](Endpoint-5790000126583.md)
* [EER Messaging Endpoint - LægerneValdemarsgadeI/S.8000.AarhusC.53881000016000 FHIR Endpoint (Endpoint)](Endpoint-5790000126675.md)
* [EER Messaging Endpoint - LægeAnetteHenriksen.8520.Lystrup.917681000016008 FHIR Endpoint (Endpoint)](Endpoint-5790000126798.md)
* [EER Messaging Endpoint - SkødstrupLægepraksis.8541.Skødstrup.52581000016005 FHIR Endpoint (Endpoint)](Endpoint-5790000127092.md)
* [EER Messaging Endpoint - FamilielægerneStoreTorvI/S.8000.AarhusC.51781000016008 FHIR Endpoint (Endpoint)](Endpoint-5790000127221.md)
* [EER Messaging Endpoint - LægerneStoreTorv6,AarhusI/S.8000.AarhusC.51241000016006 FHIR Endpoint (Endpoint)](Endpoint-5790000127382.md)
* [EER Messaging Endpoint - Lægehuset,Egålægerne.8250.Egå.1206171000016001 FHIR Endpoint (Endpoint)](Endpoint-5790000127504.md)
* [EER Messaging Endpoint - LægerneMereteAndersenogDorteLeiKaltoft.8240.Risskov.753691000016000 FHIR Endpoint (Endpoint)](Endpoint-5790000127528.md)
* [EER Messaging Endpoint - LægerneiTranbjerg.8310.TranbjergJ.1145841000016004 FHIR Endpoint (Endpoint)](Endpoint-5790000127696.md)
* [EER Messaging Endpoint - LægerneSct.OlufsgadeI/Sv/Johansen,Dam-HansenogPoulsen.8000.AarhusC.49581000016002 FHIR Endpoint (Endpoint)](Endpoint-5790000127870.md)
* [EER Messaging Endpoint - LægerneBorggadeI/S.8000.AarhusC.48961000016005 FHIR Endpoint (Endpoint)](Endpoint-5790000128020.md)
* [EER Messaging Endpoint - LægerneiGellerupI/S.8220.Brabrand.47401000016001 FHIR Endpoint (Endpoint)](Endpoint-5790000128419.md)
* [EER Messaging Endpoint - ÅbyhøjLægehus.8230.Åbyhøj.41501000016009 FHIR Endpoint (Endpoint)](Endpoint-5790000130122.md)
* [EER Messaging Endpoint - LægerneiRisvangenI/S.8200.AarhusN.38551000016003 FHIR Endpoint (Endpoint)](Endpoint-5790000131051.md)
* [EER Messaging Endpoint - LægehusetRyesgade1.8000.AarhusC.38141000016007 FHIR Endpoint (Endpoint)](Endpoint-5790000131150.md)
* [EER Messaging Endpoint - AlmentPraktiserendeLægeOleJuelThiisKnudsenApS.8240.Risskov.35381000016009 FHIR Endpoint (Endpoint)](Endpoint-5790000132119.md)
* [EER Messaging Endpoint - LægeHenrikNordentoft.8000.AarhusC.774141000016003 FHIR Endpoint (Endpoint)](Endpoint-5790000132973.md)
* [EER Messaging Endpoint - LægerneBrabrandhusI/S.8220.Brabrand.32301000016008 FHIR Endpoint (Endpoint)](Endpoint-5790000133031.md)
* [EER Messaging Endpoint - LægerneTilst.8381.Tilst.31831000016004 FHIR Endpoint (Endpoint)](Endpoint-5790000133147.md)
* [EER Messaging Endpoint - LægehusetHarlev.8462.HarlevJ.29191000016008 FHIR Endpoint (Endpoint)](Endpoint-5790000134038.md)
* [EER Messaging Endpoint - LægerneRådhuspladsen.8000.AarhusC.1361821000016009 FHIR Endpoint (Endpoint)](Endpoint-5790000134212.md)
* [EER Messaging Endpoint - MårsletLægehus.8320.Mårslet.23871000016003 FHIR Endpoint (Endpoint)](Endpoint-5790000135837.md)
* [EER Messaging Endpoint - LægerneOdensegadeI/Sv/LiseHøyer&TokeCasperØsterby.8000.AarhusC.23671000016004 FHIR Endpoint (Endpoint)](Endpoint-5790000135882.md)
* [EER Messaging Endpoint - FrederiksbjergLægehus.8000.AarhusC.1216891000016007 FHIR Endpoint (Endpoint)](Endpoint-5790000135912.md)
* [EER Messaging Endpoint - KoltLægepraksis.8361.Hasselager.22931000016002 FHIR Endpoint (Endpoint)](Endpoint-5790000136117.md)
* [EER Messaging Endpoint - LægeklinikkenAnneBlom.8000.AarhusC.1320731000016003 FHIR Endpoint (Endpoint)](Endpoint-5790000136612.md)
* [EER Messaging Endpoint - SkådeLægehusI/S.8270.Højbjerg.20171000016003 FHIR Endpoint (Endpoint)](Endpoint-5790000137060.md)
* [EER Messaging Endpoint - KirstenLinnebjergJensby.8240.Risskov.17621000016003 FHIR Endpoint (Endpoint)](Endpoint-5790000137985.md)
* [EER Messaging Endpoint - LægerneBusgadehusetI/S.8000.AarhusC.13761000016005 FHIR Endpoint (Endpoint)](Endpoint-5790000139286.md)
* [EER Messaging Endpoint - LægerneLund&NielsenI/S.8000.AarhusC.13511000016003 FHIR Endpoint (Endpoint)](Endpoint-5790000139453.md)
* [EER Messaging Endpoint - LægerneNrd.Strandvej.8240.Risskov.12851000016007 FHIR Endpoint (Endpoint)](Endpoint-5790000139729.md)
* [EER Messaging Endpoint - LægerneRosenvangsAllé.8270.Højbjerg.11491000016008 FHIR Endpoint (Endpoint)](Endpoint-5790000140206.md)
* [EER Messaging Endpoint - LægerneLotteBrogaardogJonasDyhrRask.8330.Beder.10191000016007 FHIR Endpoint (Endpoint)](Endpoint-5790000140589.md)
* [EER Messaging Endpoint - ByensLægehusI/S.8000.AarhusC.9561000016001 FHIR Endpoint (Endpoint)](Endpoint-5790000140763.md)
* [EER Messaging Endpoint - LægerneBerg,LentzogFjeldborgI/S.8000.AarhusC.8951000016003 FHIR Endpoint (Endpoint)](Endpoint-5790000140992.md)
* [EER Messaging Endpoint - LægerneBanegårdspladsen16.8000.AarhusC.32781000016004 FHIR Endpoint (Endpoint)](Endpoint-5790000142019.md)
* [EER Messaging Endpoint - BirgitteFromogPiaBrønlundOlesenI/S.8200.AarhusN.63611000016003 FHIR Endpoint (Endpoint)](Endpoint-5790000142750.md)
* [EER Messaging Endpoint - LægerneVestreStrandalle.8240.Risskov.1372861000016004 FHIR Endpoint (Endpoint)](Endpoint-5790000143030.md)
* [EER Messaging Endpoint - LægehusetBanegårdspladsen6I/S.8000.AarhusC.68591000016004 FHIR Endpoint (Endpoint)](Endpoint-5790000145447.md)
* [EER Messaging Endpoint - LægerneSehested,BilleskovogKristensen.8000.AarhusC.68991000016006 FHIR Endpoint (Endpoint)](Endpoint-5790000145676.md)
* [EER Messaging Endpoint - LægerneSktPaulsKirkeplads2.8000.AarhusC.73011000016001 FHIR Endpoint (Endpoint)](Endpoint-5790000147403.md)
* [EER Messaging Endpoint - LægeMarieGeday.8000.AarhusC.745061000016000 FHIR Endpoint (Endpoint)](Endpoint-5790000147717.md)
* [EER Messaging Endpoint - LægerneFuglesangsAllé95.8210.AarhusV.1476191000016005 FHIR Endpoint (Endpoint)](Endpoint-5790000148271.md)
* [EER Messaging Endpoint - LægerneiSolbjergI/S.8355.Solbjerg.75451000016008 FHIR Endpoint (Endpoint)](Endpoint-5790000149087.md)
* [EER Messaging Endpoint - LægerneBjerreogIngvardsenI/S.8260.VibyJ.481121000016009 FHIR Endpoint (Endpoint)](Endpoint-5790000151226.md)
* [EER Messaging Endpoint - AlléLægerneI/S.8000.AarhusC.84511000016002 FHIR Endpoint (Endpoint)](Endpoint-5790000155170.md)
* [EER Messaging Endpoint - FolkesundhedAarhus.8000.AarhusC.193071000016008 FHIR Endpoint (Endpoint)](Endpoint-5790000160921.md)
* [EER Messaging Endpoint - LægeMikaelMunk.8260.VibyJ.85521000016005 FHIR Endpoint (Endpoint)](Endpoint-5790000161584.md)
* [EER Messaging Endpoint - LægernevedHasleTorv.8210.AarhusV.88311000016003 FHIR Endpoint (Endpoint)](Endpoint-5790001356644.md)
* [EER Messaging Endpoint - KianPedrampour.8260.VibyJ.88481000016000 FHIR Endpoint (Endpoint)](Endpoint-5790001358303.md)
* [EER Messaging Endpoint - LægeklinikkenTrøjborgI/S.8200.AarhusN.88681000016003 FHIR Endpoint (Endpoint)](Endpoint-5790001363895.md)
* [EER Messaging Endpoint - NeurocenterGOP,AarhusKommune-KUNINTERNTBRUG.8260.VibyJ.331071000016009 FHIR Endpoint (Endpoint)](Endpoint-5790001368623.md)
* [EER Messaging Endpoint - Ortopædkir.GOPcenter,AarhusKommune-KUNINTERNTBRUG.8260.VibyJ.331081000016006 FHIR Endpoint (Endpoint)](Endpoint-5790001368630.md)
* [EER Messaging Endpoint - GOP§140,AarhusKommune.8260.VibyJ.331091000016008 FHIR Endpoint (Endpoint)](Endpoint-5790001368647.md)
* [EER Messaging Endpoint - LægeElisabethMøller-Hansen.8230.Åbyhøj.89381000016004 FHIR Endpoint (Endpoint)](Endpoint-5790001369897.md)
* [EER Messaging Endpoint - LægerneMagnus.8000.AarhusC.1499141000016001 FHIR Endpoint (Endpoint)](Endpoint-5790001384944.md)
* [EER Messaging Endpoint - HasleLægehusv/ThomasOtbo.8210.AarhusV.438991000016006 FHIR Endpoint (Endpoint)](Endpoint-5790001986315.md)
* [EER Messaging Endpoint - LægerneRolighedsvejI/S.8240.Risskov.448001000016001 FHIR Endpoint (Endpoint)](Endpoint-5790001989613.md)
* [EER Messaging Endpoint - LægeJacobLaurberg.8000.AarhusC.455551000016003 FHIR Endpoint (Endpoint)](Endpoint-5790001991555.md)
* [EER Messaging Endpoint - TrøjborgLægehusI/S.8200.AarhusN.468851000016000 FHIR Endpoint (Endpoint)](Endpoint-5790001995669.md)
* [EER Messaging Endpoint - Sundhedspleje.8000.AarhusC.951321000016004 FHIR Endpoint (Endpoint)](Endpoint-5790002000416.md)
* [EER Messaging Endpoint - LægeIngerTingsgårdBone.8000.AarhusC.493721000016008 FHIR Endpoint (Endpoint)](Endpoint-5790002001543.md)
* [EER Messaging Endpoint - LægeJosefineHirschsprungLange.8000.AarhusC.497751000016008 FHIR Endpoint (Endpoint)](Endpoint-5790002002960.md)
* [EER Messaging Endpoint - LægeErikHøgh.8000.AarhusC.506931000016008 FHIR Endpoint (Endpoint)](Endpoint-5790002004896.md)
* [EER Messaging Endpoint - PraktiserendelægeAsgerLauDalmose.8230.Åbyhøj.515261000016000 FHIR Endpoint (Endpoint)](Endpoint-5790002007040.md)
* [EER Messaging Endpoint - I/SLægerneFrydenlund.8210.AarhusV.533081000016008 FHIR Endpoint (Endpoint)](Endpoint-5790002010545.md)
* [EER Messaging Endpoint - SociallægeinstitutionenAarhus.8000.AarhusC.535411000016006 FHIR Endpoint (Endpoint)](Endpoint-5790002010996.md)
* [EER Messaging Endpoint - Marselislægerne.8000.AarhusC.573961000016000 FHIR Endpoint (Endpoint)](Endpoint-5790002020834.md)
* [EER Messaging Endpoint - LÆ-blanketter,suppl.kommunikation,Aarhus.8000.AarhusC.576011000016009 FHIR Endpoint (Endpoint)](Endpoint-5790002021442.md)
* [EER Messaging Endpoint - TilstLægehusI/S.8381.Tilst.596191000016005 FHIR Endpoint (Endpoint)](Endpoint-5790002026843.md)
* [EER Messaging Endpoint - I/SLægerneSønderhøj.8260.VibyJ.609501000016005 FHIR Endpoint (Endpoint)](Endpoint-5790002269684.md)
* [EER Messaging Endpoint - VibyLægehus.8260.VibyJ.632931000016006 FHIR Endpoint (Endpoint)](Endpoint-5790002277160.md)
* [EER Messaging Endpoint - LægeklinikkenTordenskjoldsgade.8200.AarhusN.637191000016008 FHIR Endpoint (Endpoint)](Endpoint-5790002278846.md)
* [EER Messaging Endpoint - LægePhilippHarbig.8200.AarhusN.643771000016003 FHIR Endpoint (Endpoint)](Endpoint-5790002280696.md)
* [EER Messaging Endpoint - LægeKirstenSlemming.8260.VibyJ.649071000016004 FHIR Endpoint (Endpoint)](Endpoint-5790002282126.md)
* [EER Messaging Endpoint - LægerneSkt.ClemensBroI/S.8000.AarhusC.672261000016008 FHIR Endpoint (Endpoint)](Endpoint-5790002288289.md)
* [EER Messaging Endpoint - LægeAneSchmeltzSøgaard.8000.AarhusC.686301000016007 FHIR Endpoint (Endpoint)](Endpoint-5790002398162.md)
* [EER Messaging Endpoint - LægeklinikkenØstergade1,LægeNielsBjørn.8000.AarhusC.883021000016003 FHIR Endpoint (Endpoint)](Endpoint-5790002401305.md)
* [EER Messaging Endpoint - LægerneStjernepladsenI/S.8200.AarhusN.698131000016001 FHIR Endpoint (Endpoint)](Endpoint-5790002401428.md)
* [EER Messaging Endpoint - LægeSebastianFriisAbrahamsen.8240.Risskov.903551000016008 FHIR Endpoint (Endpoint)](Endpoint-5790002405105.md)
* [EER Messaging Endpoint - LægerneKirstinelund.8520.Lystrup.991721000016006 FHIR Endpoint (Endpoint)](Endpoint-5790002407314.md)
* [EER Messaging Endpoint - LægeAndersBrøndt.8000.AarhusC.928971000016007 FHIR Endpoint (Endpoint)](Endpoint-5790002407840.md)
* [EER Messaging Endpoint - Højbjerglægepraksis.8270.Højbjerg.930291000016000 FHIR Endpoint (Endpoint)](Endpoint-5790002408045.md)
* [EER Messaging Endpoint - Voksentandplejen,Aarhus.8240.Risskov.947251000016006 FHIR Endpoint (Endpoint)](Endpoint-5790002409684.md)
* [EER Messaging Endpoint - AlmentPraktiserendeLægeBetinaSjøbergWolff.8260.VibyJ.954931000016001 FHIR Endpoint (Endpoint)](Endpoint-5790002410468.md)
* [EER Messaging Endpoint - Flyvelæge-Aarhus.dk.8200.AarhusN.962371000016004 FHIR Endpoint (Endpoint)](Endpoint-5790002411397.md)
* [EER Messaging Endpoint - LægeSigneBrøndt.8000.AarhusC.970111000016003 FHIR Endpoint (Endpoint)](Endpoint-5790002412042.md)
* [EER Messaging Endpoint - LægerneGyldenløvesgade.8200.AarhusN.994611000016008 FHIR Endpoint (Endpoint)](Endpoint-5790002414428.md)
* [EER Messaging Endpoint - LægeHelenaDalsgaardGrove.8000.AarhusC.711571000016006 FHIR Endpoint (Endpoint)](Endpoint-5790002506932.md)
* [EER Messaging Endpoint - Hjortshøjlægehus.8530.Hjortshøj.1047891000016007 FHIR Endpoint (Endpoint)](Endpoint-5790002507410.md)
* [EER Messaging Endpoint - TandplejenAarhusSyd.8270.Højbjerg.1027261000016002 FHIR Endpoint (Endpoint)](Endpoint-5790002507809.md)
* [EER Messaging Endpoint - TandplejenMøllevangskolen.8210.AarhusV.1027271000016007 FHIR Endpoint (Endpoint)](Endpoint-5790002507816.md)
* [EER Messaging Endpoint - TandplejenTovshøj.8220.Brabrand.1027301000016005 FHIR Endpoint (Endpoint)](Endpoint-5790002507830.md)
* [EER Messaging Endpoint - TandplejenVejlby.8240.Risskov.1027311000016007 FHIR Endpoint (Endpoint)](Endpoint-5790002507847.md)
* [EER Messaging Endpoint - AarhusTandregulering.8260.VibyJ.1052151000016006 FHIR Endpoint (Endpoint)](Endpoint-5790002507854.md)
* [EER Messaging Endpoint - TandplejenSkæringSkole.8250.Egå.1027281000016009 FHIR Endpoint (Endpoint)](Endpoint-5790002507861.md)
* [EER Messaging Endpoint - Sygehusadviser,Aarhus.8000.AarhusC.1053851000016007 FHIR Endpoint (Endpoint)](Endpoint-5790002508868.md)
* [EER Messaging Endpoint - LægerneWarrerogIsaksen.8250.Egå.992681000016005 FHIR Endpoint (Endpoint)](Endpoint-5790002510731.md)
* [EER Messaging Endpoint - FamilielægenHøjbjergIS.8270.Højbjerg.1285371000016005 FHIR Endpoint (Endpoint)](Endpoint-5790002513503.md)
* [DigitalSundhedDanmark-EerEndpoint-EMR-TEST2 (Endpoint)](Endpoint-5790002515798.md)
* [DigitalSundhedDanmark-EerEndpoint-EMR-PROD (Endpoint)](Endpoint-5790002515804.md)
* [DigitalSundhedDanmark-EerEndpoint-EMR-TEST1 (Endpoint)](Endpoint-5790002515811.md)
* [EER Messaging Endpoint - LægeCamillaRostgaardBerthelsen.8000.AarhusC.1152941000016004 FHIR Endpoint (Endpoint)](Endpoint-5790002516856.md)
* [EER Messaging Endpoint - TandplejenAarhus,AarhusKommune.8260.VibyJ.1203461000016006 FHIR Endpoint (Endpoint)](Endpoint-5790002520273.md)
* [EER Messaging Endpoint - LægeIntaAndersen.8230.Åbyhøj.1206581000016005 FHIR Endpoint (Endpoint)](Endpoint-5790002520433.md)
* [EER Messaging Endpoint - LægeklinikkenAros.8000.AarhusC.1332981000016003 FHIR Endpoint (Endpoint)](Endpoint-5790002618383.md)
* [EER Messaging Endpoint - LægeKarenKjærLarsen.8000.AarhusC.1277261000016009 FHIR Endpoint (Endpoint)](Endpoint-5790002621482.md)
* [EER Messaging Endpoint - SocialeForholdogBeskæftigelse.8000.AarhusC.1280171000016004 FHIR Endpoint (Endpoint)](Endpoint-5790002621741.md)
* [EER Messaging Endpoint - LægerneVennelystparken.8000.AarhusC.1283771000016007 FHIR Endpoint (Endpoint)](Endpoint-5790002622038.md)
* [EER Messaging Endpoint - LægeLineStaehelin.8000.AarhusC.1287781000016004 FHIR Endpoint (Endpoint)](Endpoint-5790002622205.md)
* [EER Messaging Endpoint - FamilielægerneÅbyhøj.8230.Åbyhøj.1304301000016009 FHIR Endpoint (Endpoint)](Endpoint-5790002623622.md)
* [EER Messaging Endpoint - LægerneBystævnet.8520.Lystrup.1369491000016008 FHIR Endpoint (Endpoint)](Endpoint-5790002630019.md)
* [EER Messaging Endpoint - LægerneBellogRask.8000.AarhusC.1371721000016006 FHIR Endpoint (Endpoint)](Endpoint-5790002630682.md)
* [EER Messaging Endpoint - Langenæslægehus.8000.AarhusC.1394741000016009 FHIR Endpoint (Endpoint)](Endpoint-5790002633133.md)
* [EER Messaging Endpoint - PPR(PædagogiskPsykologiskRådgivning).8260.VibyJ.1437191000016005 FHIR Endpoint (Endpoint)](Endpoint-5790002637384.md)
* [EER Messaging Endpoint - LægehusetKirkedammen.8000.AarhusC.1461771000016005 FHIR Endpoint (Endpoint)](Endpoint-5790002757549.md)
* [EER Messaging Endpoint - LaegerneStjernepladsen.8200.AarhusN.5790002401428 FHIR Endpoint (Endpoint)](Endpoint-LaegerneStjernepladsen.8200.AarhusN.5790002401428.md)
* [Gitte Nørsøller (1009391000016001) (Organization)](Organization-1009391000016001.md)
* [Tine Hagenau (1009401000016003) (Organization)](Organization-1009401000016003.md)
* [Bahareh Khaki-Fristed (1017511000016006) (Organization)](Organization-1017511000016006.md)
* [Lægerne Lotte Brogaard og Jonas Dyhr Rask (10191000016007) (Organization)](Organization-10191000016007.md)
* [Lægerne i Beder (10201000016009) (Organization)](Organization-10201000016009.md)
* [Martin Svensson (1021441000016009) (Organization)](Organization-1021441000016009.md)
* [Anders Prior (1021451000016007) (Organization)](Organization-1021451000016007.md)
* [Lotte Brogaard (10221000016002) (Organization)](Organization-10221000016002.md)
* [Michael Schriver (1024311000016003) (Organization)](Organization-1024311000016003.md)
* [Merete Andersen (1026071000016003) (Organization)](Organization-1026071000016003.md)
* [Dorte Lei Kaltoft (1026081000016001) (Organization)](Organization-1026081000016001.md)
* [Børn og Unge-lægerne, Aarhus Kommune (1027201000016001) (Organization)](Organization-1027201000016001.md)
* [Sundhedsplejen Nord, Aarhus Kommune (1027211000016004) (Organization)](Organization-1027211000016004.md)
* [Sundhedsplejen Syd (1027221000016008) (Organization)](Organization-1027221000016008.md)
* [Sundhedsplejen Øst, Aarhus Kommune (1027231000016005) (Organization)](Organization-1027231000016005.md)
* [Sundhedsplejen Vest, Aarhus Kommune (1027241000016003) (Organization)](Organization-1027241000016003.md)
* [Ammehjælpen, Aarhus Kommune (1027251000016000) (Organization)](Organization-1027251000016000.md)
* [Tandplejen Aarhus Syd (1027261000016002) (Organization)](Organization-1027261000016002.md)
* [Tandplejen Møllevangskolen (1027271000016007) (Organization)](Organization-1027271000016007.md)
* [Tandplejen Skæring Skole (1027281000016009) (Organization)](Organization-1027281000016009.md)
* [Tandplejen Søndervangskolen (1027291000016006) (Organization)](Organization-1027291000016006.md)
* [Tandplejen Tovshøj (1027301000016005) (Organization)](Organization-1027301000016005.md)
* [Tandplejen Vejlby (1027311000016007) (Organization)](Organization-1027311000016007.md)
* [Tandklinikken Tilst (1027321000016003) (Organization)](Organization-1027321000016003.md)
* [Tandklinikken Tranbjergskolen (1027331000016001) (Organization)](Organization-1027331000016001.md)
* [Tandklinikken Aarhus Tandlægeskolen (1027341000016008) (Organization)](Organization-1027341000016008.md)
* [Hj.pl. Trøjborg/Møllestien (1027381000016002) (Organization)](Organization-1027381000016002.md)
* [Hj.pl. Vestervang (1027401000016002) (Organization)](Organization-1027401000016002.md)
* [Hj.pl. Åbygård (1027431000016006) (Organization)](Organization-1027431000016006.md)
* [Sundhedsklinik Carl Blochs Gade (1027441000016004) (Organization)](Organization-1027441000016004.md)
* [Plejehjem Vestervang 44 (1027461000016003) (Organization)](Organization-1027461000016003.md)
* [Plejehjem Vestervang 42 (1027471000016008) (Organization)](Organization-1027471000016008.md)
* [Hj.pl. Skødstrup (1027491000016007) (Organization)](Organization-1027491000016007.md)
* [Hj.pl. Hjortshøj (1027501000016003) (Organization)](Organization-1027501000016003.md)
* [Sundhedsklinik Risskov (1027511000016001) (Organization)](Organization-1027511000016001.md)
* [Hj.pl. Skæring (1027561000016004) (Organization)](Organization-1027561000016004.md)
* [Hj.pl. Stavtrup/Bøgeskovhus (1027601000016004) (Organization)](Organization-1027601000016004.md)
* [Sundhedsklinik Gellerup (1027721000016002) (Organization)](Organization-1027721000016002.md)
* [Sundhedsklinik Toftegården (1027731000016000) (Organization)](Organization-1027731000016000.md)
* [Hj.pl. Brabrand (1027741000016007) (Organization)](Organization-1027741000016007.md)
* [Tandklinikken Bavnehøj (1027761000016008) (Organization)](Organization-1027761000016008.md)
* [Plejehjem Skovvang (1027771000016003) (Organization)](Organization-1027771000016003.md)
* [Hj.pl. Fuglebakken (1027781000016001) (Organization)](Organization-1027781000016001.md)
* [Hj.pl. Skelager (1027811000016003) (Organization)](Organization-1027811000016003.md)
* [Hj.pl. Vejlby (1027821000016007) (Organization)](Organization-1027821000016007.md)
* [Sundhedsklinik Abildgården (1027861000016001) (Organization)](Organization-1027861000016001.md)
* [Hj.pl. Viby (1027881000016008) (Organization)](Organization-1027881000016008.md)
* [Hj.pl. Holme (1027891000016005) (Organization)](Organization-1027891000016005.md)
* [Hj.pl. Skåde (1027921000016004) (Organization)](Organization-1027921000016004.md)
* [Hj.pl. Marselis (1027981000016003) (Organization)](Organization-1027981000016003.md)
* [Hj.pl. Dalgas (1028021000016001) (Organization)](Organization-1028021000016001.md)
* [Hjerneskadeteamet (voksne) (1028041000016006) (Organization)](Organization-1028041000016006.md)
* [Ortopædisk Genoptræningscenter (1028061000016007) (Organization)](Organization-1028061000016007.md)
* [Center for Specialrådgivning Aarhus (1028081000016000) (Organization)](Organization-1028081000016000.md)
* [Vikærgården (1028091000016003) (Organization)](Organization-1028091000016003.md)
* [Tandklinikken Beder Skole (1028141000016007) (Organization)](Organization-1028141000016007.md)
* [Tandklinikken Frederiksbjerg Skole (1028151000016005) (Organization)](Organization-1028151000016005.md)
* [Tandklinikken Hasle (1028161000016008) (Organization)](Organization-1028161000016008.md)
* [Tandklinikken Højvangskolen (1028171000016003) (Organization)](Organization-1028171000016003.md)
* [Tandklinikken Lystrup Skole (1028191000016004) (Organization)](Organization-1028191000016004.md)
* [Tandklinikken Næshøjskolen (1028201000016002) (Organization)](Organization-1028201000016002.md)
* [Tandklinikken Sabro-Korsvejskolen (1028211000016000) (Organization)](Organization-1028211000016000.md)
* [Tandklinikken Skovvangskolen (1028221000016009) (Organization)](Organization-1028221000016009.md)
* [Tandklinikken Strandskolen (1028231000016006) (Organization)](Organization-1028231000016006.md)
* [Tandklinikken Bakkegårdsskolen (1028241000016004) (Organization)](Organization-1028241000016004.md)
* [Socialmedicinsk Tandklinik (1028251000016001) (Organization)](Organization-1028251000016001.md)
* [UC Katrinebjerg. (1028261000016003) (Organization)](Organization-1028261000016003.md)
* [UC Turbo. (1028281000016005) (Organization)](Organization-1028281000016005.md)
* [UC Nørre Allé (1028301000016006) (Organization)](Organization-1028301000016006.md)
* [RCA Stof Heroinklinikken (1028311000016008) (Organization)](Organization-1028311000016008.md)
* [CBV Tranbjerg Afdeling 1 (1028321000016004) (Organization)](Organization-1028321000016004.md)
* [CBB Søstjernen (1028331000016002) (Organization)](Organization-1028331000016002.md)
* [CBB Annehuse (1028341000016009) (Organization)](Organization-1028341000016009.md)
* [CBB Hasselager (1028351000016007) (Organization)](Organization-1028351000016007.md)
* [CSV Majvænget. (1028361000016005) (Organization)](Organization-1028361000016005.md)
* [CSV Mallinglund (1028371000016000) (Organization)](Organization-1028371000016000.md)
* [CBB Stautruphus (1028381000016003) (Organization)](Organization-1028381000016003.md)
* [CBB Stenhøj (1028391000016001) (Organization)](Organization-1028391000016001.md)
* [CSV Hvilstedhuse. (1028401000016003) (Organization)](Organization-1028401000016003.md)
* [CB Provstebakken (1028421000016005) (Organization)](Organization-1028421000016005.md)
* [CAV Albertsvænge (1028431000016007) (Organization)](Organization-1028431000016007.md)
* [CBB Bronzealdertoften (1028441000016000) (Organization)](Organization-1028441000016000.md)
* [CBB Harlev (1028451000016002) (Organization)](Organization-1028451000016002.md)
* [CAV Kilebo (1028461000016004) (Organization)](Organization-1028461000016004.md)
* [CAV Tingagergården (1028471000016009) (Organization)](Organization-1028471000016009.md)
* [CSV Snåstrup Vestergård Afdeling 1 (1028481000016006) (Organization)](Organization-1028481000016006.md)
* [CSV Vintervej afdeling 1 (1028491000016008) (Organization)](Organization-1028491000016008.md)
* [Center for Forsorg (1028501000016004) (Organization)](Organization-1028501000016004.md)
* [BC Mini Solbrinken (1028511000016002) (Organization)](Organization-1028511000016002.md)
* [BC Mini Sølyst (1028521000016006) (Organization)](Organization-1028521000016006.md)
* [BC Mini Toften (1028531000016008) (Organization)](Organization-1028531000016008.md)
* [CBB  Myrholmsvej. (1028541000016001) (Organization)](Organization-1028541000016001.md)
* [CSV Nordbyvænget. (1028551000016003) (Organization)](Organization-1028551000016003.md)
* [CB BOF Sletten (1028561000016000) (Organization)](Organization-1028561000016000.md)
* [RCA Alkohol Behandlingsteamet (1028571000016005) (Organization)](Organization-1028571000016005.md)
* [Sundhedsplejen Sydvest, Aarhus Kommune (1028581000016007) (Organization)](Organization-1028581000016007.md)
* [Hårup Skole (1028591000016009) (Organization)](Organization-1028591000016009.md)
* [Strandskolen (1028601000016000) (Organization)](Organization-1028601000016000.md)
* [Sabro-Korsvejskolen (1028611000016003) (Organization)](Organization-1028611000016003.md)
* [Skjoldhøjskolen (1028621000016007) (Organization)](Organization-1028621000016007.md)
* [Vorrevangskolen (1028631000016009) (Organization)](Organization-1028631000016009.md)
* [N. Koch Skole (1028641000016002) (Organization)](Organization-1028641000016002.md)
* [Skovvangsskolen (1028651000016004) (Organization)](Organization-1028651000016004.md)
* [Beder Skole (1028661000016001) (Organization)](Organization-1028661000016001.md)
* [Frederiksbjerg Skole (1028671000016006) (Organization)](Organization-1028671000016006.md)
* [Kragelundskolen (1028681000016008) (Organization)](Organization-1028681000016008.md)
* [Læssøesgade Skole (1028691000016005) (Organization)](Organization-1028691000016005.md)
* [Malling Skole (1028701000016005) (Organization)](Organization-1028701000016005.md)
* [Solbjerg Skole (1028711000016007) (Organization)](Organization-1028711000016007.md)
* [Tranbjerg Skole (1028721000016003) (Organization)](Organization-1028721000016003.md)
* [Forældreskolen (1028731000016001) (Organization)](Organization-1028731000016001.md)
* [Interskolen (1028741000016008) (Organization)](Organization-1028741000016008.md)
* [Hasle Skole (1028751000016006) (Organization)](Organization-1028751000016006.md)
* [Aarhus Academy for Global Education (1028761000016009) (Organization)](Organization-1028761000016009.md)
* [Bavnehøj Skole (1028771000016004) (Organization)](Organization-1028771000016004.md)
* [Engdalskolen (1028781000016002) (Organization)](Organization-1028781000016002.md)
* [Højvangskolen (1028791000016000) (Organization)](Organization-1028791000016000.md)
* [Næshøjskolen (1028801000016001) (Organization)](Organization-1028801000016001.md)
* [Rosenvangskolen (1028811000016004) (Organization)](Organization-1028811000016004.md)
* [Tovshøjskolen (1028821000016008) (Organization)](Organization-1028821000016008.md)
* [Viby Skole (1028831000016005) (Organization)](Organization-1028831000016005.md)
* [Langagerskolen (1028841000016003) (Organization)](Organization-1028841000016003.md)
* [Lykke Skolen (1028851000016000) (Organization)](Organization-1028851000016000.md)
* [Selam Friskole (1028861000016002) (Organization)](Organization-1028861000016002.md)
* [Stensagerskolen (1028871000016007) (Organization)](Organization-1028871000016007.md)
* [Århus Friskole (1028881000016009) (Organization)](Organization-1028881000016009.md)
* [CF Ungetilbuddet Nord f/unge (1028901000016007) (Organization)](Organization-1028901000016007.md)
* [CM Akut- og Opsøgende Gadeteam (1028911000016009) (Organization)](Organization-1028911000016009.md)
* [Specialdagtilbud Skovbrynet, Afdeling Terapi (1028921000016000) (Organization)](Organization-1028921000016000.md)
* [Tandklinikken Engdalskolen (1028931000016003) (Organization)](Organization-1028931000016003.md)
* [UC Skansen. (1028941000016005) (Organization)](Organization-1028941000016005.md)
* [CBV Skødstrup HUS 1-3 (1028951000016008) (Organization)](Organization-1028951000016008.md)
* [CBV Elev Hus 1-3 (1028961000016006) (Organization)](Organization-1028961000016006.md)
* [CSV Lisbjerghus. (1028971000016001) (Organization)](Organization-1028971000016001.md)
* [CB Hasle Kollegiet (1028981000016004) (Organization)](Organization-1028981000016004.md)
* [CB Korsagergården (1028991000016002) (Organization)](Organization-1028991000016002.md)
* [CB Kragelund (1029001000016002) (Organization)](Organization-1029001000016002.md)
* [CB Tuesten Huse Botilbud (1029011000016000) (Organization)](Organization-1029011000016000.md)
* [CBB Lyngå kollegiet (1029021000016009) (Organization)](Organization-1029021000016009.md)
* [CB Windsor (1029031000016006) (Organization)](Organization-1029031000016006.md)
* [CB BOF Søndervangen (1029041000016004) (Organization)](Organization-1029041000016004.md)
* [CBV Skovlund Afdeling 1 (1029051000016001) (Organization)](Organization-1029051000016001.md)
* [RCA Stof Sundhedsteam (1029061000016003) (Organization)](Organization-1029061000016003.md)
* [CBV Skødstrup Hus 4 og Aktivitetstilbud (1029071000016008) (Organization)](Organization-1029071000016008.md)
* [Karen Dirksen (1034131000016009) (Organization)](Organization-1034131000016009.md)
* [Hjortshøj Lægehus (1047881000016005) (Organization)](Organization-1047881000016005.md)
* [Hjortshøj lægehus (1047891000016007) (Organization)](Organization-1047891000016007.md)
* [Gitte Refsgaard Andersen (1047901000016008) (Organization)](Organization-1047901000016008.md)
* [Aarhus Tandregulering (1052151000016006) (Organization)](Organization-1052151000016006.md)
* [Sygehusadviser,  Aarhus (1053851000016007) (Organization)](Organization-1053851000016007.md)
* [Hj.pl. Brabrand/Gellerup (1055241000016007) (Organization)](Organization-1055241000016007.md)
* [Hj.pl. Hasle (1055251000016005) (Organization)](Organization-1055251000016005.md)
* [Hj.pl. Tilst/Sabro (1055261000016008) (Organization)](Organization-1055261000016008.md)
* [Hj.pl. Abildgården/Bjerggården (1069231000016007) (Organization)](Organization-1069231000016007.md)
* [Sundhedsklinik Fuglebakken (1069291000016008) (Organization)](Organization-1069291000016008.md)
* [Sundhedsklinik Vejlby (1069301000016007) (Organization)](Organization-1069301000016007.md)
* [Sundhedsklinik Trige (1069391000016002) (Organization)](Organization-1069391000016002.md)
* [Sundhedsklinik Skødstrup (1069401000016004) (Organization)](Organization-1069401000016004.md)
* [Sundhedsklinik Lystrup (1069451000016003) (Organization)](Organization-1069451000016003.md)
* [Ungdomscentret (1078221000016005) (Organization)](Organization-1078221000016005.md)
* [RCA Halvvejshuset (1078241000016000) (Organization)](Organization-1078241000016000.md)
* [AKUT TEAMET (1078251000016002) (Organization)](Organization-1078251000016002.md)
* [Omsorgscenter Svalegangen (1080341000016002) (Organization)](Organization-1080341000016002.md)
* [Omsorgscenter Svalegangen (1080351000016004) (Organization)](Organization-1080351000016004.md)
* [DigitalSundhedDanmark-EMR (1134981000016000) (SI) (Organization)](Organization-1134981000016000.md)
* [DigitalSundhedDanmark-EMR-TEST2 (1134991000016003) (OE) (Organization)](Organization-1134991000016003.md)
* [DigitalSundhedDanmark-EMR-PROD (1135011000016005) (OE) (Organization)](Organization-1135011000016005.md)
* [DigitalSundhedDanmark-EMR-TEST1 (1135051000016009) (OE) (Organization)](Organization-1135051000016009.md)
* [Anne Kathrine Erdmann Andersen (1143501000016004) (Organization)](Organization-1143501000016004.md)
* [Borgervelfærd (1144301000016008) (Organization)](Organization-1144301000016008.md)
* [Borgerkonsulenter (1144311000016005) (Organization)](Organization-1144311000016005.md)
* [Borgerkonsulenter Nord (1144321000016001) (Organization)](Organization-1144321000016001.md)
* [Borgerkonsulenter Midt (1144331000016004) (Organization)](Organization-1144331000016004.md)
* [Borgerkonsulenter Syd (1144341000016006) (Organization)](Organization-1144341000016006.md)
* [Sundhed og Forebyggelse (1144351000016009) (Organization)](Organization-1144351000016009.md)
* [Sundhed Midt (1144361000016007) (Organization)](Organization-1144361000016007.md)
* [Sundhedsenhed Midt (1144371000016002) (Organization)](Organization-1144371000016002.md)
* [Sundhedsenhed Brabrand (1144381000016000) (Organization)](Organization-1144381000016000.md)
* [Sundhedsenhed Aarhus C (1144391000016003) (Organization)](Organization-1144391000016003.md)
* [Sundhedsenhed Fuglebakken (1144401000016000) (Organization)](Organization-1144401000016000.md)
* [Sundhed Syd (1144421000016007) (Organization)](Organization-1144421000016007.md)
* [Sundhedsenhed Syd (1144431000016009) (Organization)](Organization-1144431000016009.md)
* [Sundhedsenhed Viby-Højbjerg (1144441000016002) (Organization)](Organization-1144441000016002.md)
* [Sundhedsenhed Beder (1144451000016004) (Organization)](Organization-1144451000016004.md)
* [Sundhedsenhed Tranbjerg (1144471000016006) (Organization)](Organization-1144471000016006.md)
* [Sundhed Nord (1144481000016008) (Organization)](Organization-1144481000016008.md)
* [Sundhedsenhed Nord (1144491000016005) (Organization)](Organization-1144491000016005.md)
* [Sundhedsenhed Vejlby-Risskov (1144501000016001) (Organization)](Organization-1144501000016001.md)
* [Sundhedsenhed Tilst (1144511000016004) (Organization)](Organization-1144511000016004.md)
* [Sundhedsenhed Skejby (1144521000016008) (Organization)](Organization-1144521000016008.md)
* [Sundhedsenhed Hjortshøj (1144531000016005) (Organization)](Organization-1144531000016005.md)
* [Pleje og Rehabilitering (1144541000016003) (Organization)](Organization-1144541000016003.md)
* [Hjemmeplejen Midt (1144551000016000) (Organization)](Organization-1144551000016000.md)
* [Hj.pl. Frederiksbjerg (1144571000016007) (Organization)](Organization-1144571000016007.md)
* [Hj.pl. Rosenvang (1144581000016009) (Organization)](Organization-1144581000016009.md)
* [Hjemmeplejen Syd (1144591000016006) (Organization)](Organization-1144591000016006.md)
* [Hj.pl. Mårslet (1144631000016006) (Organization)](Organization-1144631000016006.md)
* [Hj.pl. Solbjerg/Mårslet (1144641000016004) (Organization)](Organization-1144641000016004.md)
* [Hj.pl. Tranbjerg (1144651000016001) (Organization)](Organization-1144651000016001.md)
* [Hj.pl. Kolt/Harlev (1144661000016003) (Organization)](Organization-1144661000016003.md)
* [Hjemmeplejen Nord (1144671000016008) (Organization)](Organization-1144671000016008.md)
* [Hj.pl. Lystrup (1144691000016007) (Organization)](Organization-1144691000016007.md)
* [Hj.pl. Risskov (1144701000016007) (Organization)](Organization-1144701000016007.md)
* [Hj.pl. Trige/Toftegården (1144711000016009) (Organization)](Organization-1144711000016009.md)
* [Hj.pl. Tilst (1144741000016005) (Organization)](Organization-1144741000016005.md)
* [Ældre og Omsorg (1144751000016008) (Organization)](Organization-1144751000016008.md)
* [Plejehjem Nord (1144761000016006) (Organization)](Organization-1144761000016006.md)
* [Plejehjem Midt Øst (1144771000016001) (Organization)](Organization-1144771000016001.md)
* [Plejehjem Midt Vest (1144781000016004) (Organization)](Organization-1144781000016004.md)
* [Plejehjem Syd (1144791000016002) (Organization)](Organization-1144791000016002.md)
* [Plejehjem Møllestien (1144921000016002) (Organization)](Organization-1144921000016002.md)
* [Lægerne i Tranbjerg I/S (1145531000016009) (Organization)](Organization-1145531000016009.md)
* [Lægerne i Tranbjerg (1145841000016004) (Organization)](Organization-1145841000016004.md)
* [Jens Albertsen (1145861000016003) (Organization)](Organization-1145861000016003.md)
* [Ane Fuglsbjerg (1145871000016008) (Organization)](Organization-1145871000016008.md)
* [Lægerne Rosenvangs Allé (11491000016008) (Organization)](Organization-11491000016008.md)
* [Lægerne Rosenvangs Allé (11501000016004) (Organization)](Organization-11501000016004.md)
* [Lægehuset Marselis (1152921000016009) (Organization)](Organization-1152921000016009.md)
* [Læge Camilla Rostgaard Berthelsen (1152941000016004) (Organization)](Organization-1152941000016004.md)
* [Camilla Rostgaard Berthelsen (1152951000016001) (Organization)](Organization-1152951000016001.md)
* [Alment praktiserende læge Toke F. Holst ApS (1154891000016006) (Organization)](Organization-1154891000016006.md)
* [Alment praktiserende læge Toke F. Holst (1154901000016007) (Organization)](Organization-1154901000016007.md)
* [Toke Falkenberg Holst (1154911000016009) (Organization)](Organization-1154911000016009.md)
* [CBV Mårslet nr. 15 (1161151000016003) (Organization)](Organization-1161151000016003.md)
* [CAV Solgården (1161511000016006) (Organization)](Organization-1161511000016006.md)
* [Mikkel Schaldemose Erichsen (1166501000016004) (Organization)](Organization-1166501000016004.md)
* [Ylva Ivraeus (1180391000016000) (Organization)](Organization-1180391000016000.md)
* [Birgitte Langelund (1198051000016006) (Organization)](Organization-1198051000016006.md)
* [Tandplejen Aarhus, Aarhus Kommune (1203461000016006) (Organization)](Organization-1203461000016006.md)
* [Lægerne Hansen, Isaksen og Saksø I/S (1206161000016006) (Organization)](Organization-1206161000016006.md)
* [Lægehuset, Egålægerne (1206171000016001) (Organization)](Organization-1206171000016001.md)
* [Henriette Schou Hansen (1206181000016004) (Organization)](Organization-1206181000016004.md)
* [Mikkel Saksø (1206191000016002) (Organization)](Organization-1206191000016002.md)
* [Troels Isaksen (1206201000016000) (Organization)](Organization-1206201000016000.md)
* [Læge Inta Andersen (1206571000016008) (Organization)](Organization-1206571000016008.md)
* [Læge Inta Andersen (1206581000016005) (Organization)](Organization-1206581000016005.md)
* [Inta Andersen (1206591000016007) (Organization)](Organization-1206591000016007.md)
* [Sara Aagaard (1216861000016003) (Organization)](Organization-1216861000016003.md)
* [Stefan Telling Johansen (1216871000016008) (Organization)](Organization-1216871000016008.md)
* [Frederiksbjerg Lægehus (1216881000016005) (Organization)](Organization-1216881000016005.md)
* [Frederiksbjerg Lægehus (1216891000016007) (Organization)](Organization-1216891000016007.md)
* [Anne Sofie Karstoft Madsen (1216901000016008) (Organization)](Organization-1216901000016008.md)
* [Børneterapi (1221961000016009) (Organization)](Organization-1221961000016009.md)
* [Pleje og Rehabilitering Stab (1244701000016009) (Organization)](Organization-1244701000016009.md)
* [Hjerneteamet (1244721000016002) (Organization)](Organization-1244721000016002.md)
* [Digitalisering Velfærdstek. Hjælpemidler (1244791000016004) (Organization)](Organization-1244791000016004.md)
* [Civilsamfund og Samskabelse (1244821000016007) (Organization)](Organization-1244821000016007.md)
* [Digitalisering og Kvalitet (1244841000016002) (Organization)](Organization-1244841000016002.md)
* [HR. (1244851000016004) (Organization)](Organization-1244851000016004.md)
* [Velfærdsteknologi og Hjælpemidler (1244871000016006) (Organization)](Organization-1244871000016006.md)
* [Hjælpemiddelcentret (1244901000016006) (Organization)](Organization-1244901000016006.md)
* [APV Hjælpemidler (1244921000016004) (Organization)](Organization-1244921000016004.md)
* [Sundhed- og Omsorgslinjen (1244991000016001) (Organization)](Organization-1244991000016001.md)
* [Staben for Borgervelfærd (1245011000016008) (Organization)](Organization-1245011000016008.md)
* [Sårteamet (1245021000016004) (Organization)](Organization-1245021000016004.md)
* [Folkesundhed Aarhus MarselisborgCentret (1245041000016009) (Organization)](Organization-1245041000016009.md)
* [Kontinensklinikken (1245051000016007) (Organization)](Organization-1245051000016007.md)
* [Sekundær ES (1245061000016005) (Organization)](Organization-1245061000016005.md)
* [Stomisygeplejerske (1245071000016000) (Organization)](Organization-1245071000016000.md)
* [Forebyggende hjemmebesøg (1245081000016003) (Organization)](Organization-1245081000016003.md)
* [Sundhedsklinik Brabrand (1245101000016007) (Organization)](Organization-1245101000016007.md)
* [Sundhedsklinik Ankersgade (1245111000016009) (Organization)](Organization-1245111000016009.md)
* [Sundhedsklinik Dalgas (1245121000016000) (Organization)](Organization-1245121000016000.md)
* [Sundhedsklinik Hasle (1245131000016003) (Organization)](Organization-1245131000016003.md)
* [Sundhedsklinik Marselis (1245141000016005) (Organization)](Organization-1245141000016005.md)
* [Sundhedsklinik Møllestien (1245151000016008) (Organization)](Organization-1245151000016008.md)
* [Sundhedsklinik Rosenvang (1245161000016006) (Organization)](Organization-1245161000016006.md)
* [Sundhedsklinik Vestervang (1245171000016001) (Organization)](Organization-1245171000016001.md)
* [Sundhedsklinik Åbygård (1245181000016004) (Organization)](Organization-1245181000016004.md)
* [Akut Natsygeplejerske (1245211000016003) (Organization)](Organization-1245211000016003.md)
* [Sundhedsklinik Hjortshøj (1245241000016002) (Organization)](Organization-1245241000016002.md)
* [Sundhedsklinik Sabro (1245281000016008) (Organization)](Organization-1245281000016008.md)
* [Sundhedsklinik Skelager (1245291000016005) (Organization)](Organization-1245291000016005.md)
* [Sundhedsklinik Skæring (1245301000016009) (Organization)](Organization-1245301000016009.md)
* [Sundhedsklinik Tilst (1245321000016002) (Organization)](Organization-1245321000016002.md)
* [Udredning- og Rehabiliteringsteam (1245341000016007) (Organization)](Organization-1245341000016007.md)
* [CSA Høreteam (1245371000016003) (Organization)](Organization-1245371000016003.md)
* [CSA Høretekniske hjælpemidler (1245391000016004) (Organization)](Organization-1245391000016004.md)
* [CSA IT (1245401000016001) (Organization)](Organization-1245401000016001.md)
* [CSA Kommunikation (1245411000016004) (Organization)](Organization-1245411000016004.md)
* [CSA Siddestillingsteam (1245431000016005) (Organization)](Organization-1245431000016005.md)
* [CSA Optik (1245441000016003) (Organization)](Organization-1245441000016003.md)
* [CSA Syn Børn og Unge (1245461000016002) (Organization)](Organization-1245461000016002.md)
* [CSA Syn Voksen (1245471000016007) (Organization)](Organization-1245471000016007.md)
* [CSA Uddannelse og arbejdsmarked (1245491000016006) (Organization)](Organization-1245491000016006.md)
* [Sundhedsklinik Beder (1245501000016002) (Organization)](Organization-1245501000016002.md)
* [Sundhedsklinik Bøgeskovhus (1245511000016000) (Organization)](Organization-1245511000016000.md)
* [Sundhedsklinik Holme (1245521000016009) (Organization)](Organization-1245521000016009.md)
* [Sundhedsklinik Kolt (1245531000016006) (Organization)](Organization-1245531000016006.md)
* [Sundhedsklinik Mårslet (1245541000016004) (Organization)](Organization-1245541000016004.md)
* [Sundhedsklinik Næshøj (1245551000016001) (Organization)](Organization-1245551000016001.md)
* [Sundhedsklinik Skåde (1245561000016003) (Organization)](Organization-1245561000016003.md)
* [Sundhedsklinik Solbjerg (1245571000016008) (Organization)](Organization-1245571000016008.md)
* [Sundhedsklinik Tranbjerg (1245581000016005) (Organization)](Organization-1245581000016005.md)
* [Sundhedsklinik Viby (1245591000016007) (Organization)](Organization-1245591000016007.md)
* [Plejehjem Ankersgade 19-23 (1249811000016004) (Organization)](Organization-1249811000016004.md)
* [Plejehjem Ankersgade 25-27 (1249821000016008) (Organization)](Organization-1249821000016008.md)
* [Generationernes Hus 9 (1249831000016005) (Organization)](Organization-1249831000016005.md)
* [Generationernes Hus 3 (1249841000016003) (Organization)](Organization-1249841000016003.md)
* [Pleje Dag Generationernes Hus 3 (1249851000016000) (Organization)](Organization-1249851000016000.md)
* [Sygeplejersker Generationernes Hus 3 (1249861000016002) (Organization)](Organization-1249861000016002.md)
* [Terapeuter Generationernes Hus 3 (1249871000016007) (Organization)](Organization-1249871000016007.md)
* [Pleje Dag Generationernes Hus 9 (1249881000016009) (Organization)](Organization-1249881000016009.md)
* [Sygeplejersker Generationernes Hus 9 (1249891000016006) (Organization)](Organization-1249891000016006.md)
* [Terapeuterne Generationernes Hus 9 (1249901000016007) (Organization)](Organization-1249901000016007.md)
* [Laura Hansted (1251411000016000) (Organization)](Organization-1251411000016000.md)
* [Michael Gejl (1257821000016001) (Organization)](Organization-1257821000016001.md)
* [Anna Budtz-Lilly (1260731000016000) (Organization)](Organization-1260731000016000.md)
* [Læge Karen Kjær Larsen (1277251000016006) (Organization)](Organization-1277251000016006.md)
* [Læge Karen Kjær Larsen (1277261000016009) (Organization)](Organization-1277261000016009.md)
* [Karen Kjær Larsen (1277271000016004) (Organization)](Organization-1277271000016004.md)
* [Sociale Forhold og Beskæftigelse (1280171000016004) (Organization)](Organization-1280171000016004.md)
* [Udredningsafdeling 1 (1283621000016004) (Organization)](Organization-1283621000016004.md)
* [Udredningsafdeling 2 (1283631000016002) (Organization)](Organization-1283631000016002.md)
* [Rehabiliteringsenhed (1283641000016009) (Organization)](Organization-1283641000016009.md)
* [Lægerne Vennelystparken (1283761000016002) (Organization)](Organization-1283761000016002.md)
* [Lægerne Vennelystparken (1283771000016007) (Organization)](Organization-1283771000016007.md)
* [Signe Engkjær Christensen (1283781000016009) (Organization)](Organization-1283781000016009.md)
* [Lægerne Nrd. Strandvej (12851000016007) (Organization)](Organization-12851000016007.md)
* [Familielægen Højbjerg I/S (1285361000016000) (Organization)](Organization-1285361000016000.md)
* [Familielægen Højbjerg IS (1285371000016005) (Organization)](Organization-1285371000016005.md)
* [Neven Akrawi (1285381000016007) (Organization)](Organization-1285381000016007.md)
* [Maibrit Petri Christensen (1285391000016009) (Organization)](Organization-1285391000016009.md)
* [Lægerne Nordre Strandvej (12861000016005) (Organization)](Organization-12861000016005.md)
* [Læge Line Staehelin (1287061000016009) (Organization)](Organization-1287061000016009.md)
* [Læge Line Staehelin (1287781000016004) (Organization)](Organization-1287781000016004.md)
* [Line Staehelin (1287791000016002) (Organization)](Organization-1287791000016002.md)
* [Peter Stokvad (12881000016003) (Organization)](Organization-12881000016003.md)
* [Røde Kors sundhedsklinik for  migranter Aarhus (1288491000016006) (Organization)](Organization-1288491000016006.md)
* [Røde Kors sundhedsklinik for udokumenterede migranter Aarhus (1288501000016002) (Organization)](Organization-1288501000016002.md)
* [Røde Kors sundhedsklinik for  migranter Odense (1290951000016005) (Organization)](Organization-1290951000016005.md)
* [Røde Kors sundhedsklinik for udokumenterede migranter Odense (1290961000016008) (Organization)](Organization-1290961000016008.md)
* [Børnecentret og BFF Selvejeende (1296491000016008) (Organization)](Organization-1296491000016008.md)
* [Aarhus Krisecenter adm. (1296501000016004) (Organization)](Organization-1296501000016004.md)
* [Aarhus Krisecenter (1296511000016002) (Organization)](Organization-1296511000016002.md)
* [Børnecentret (1296521000016006) (Organization)](Organization-1296521000016006.md)
* [BC Dagområdet (1296531000016008) (Organization)](Organization-1296531000016008.md)
* [BC Tidlig indsats (1296541000016001) (Organization)](Organization-1296541000016001.md)
* [BC Ryhave Kollegiet (1296551000016003) (Organization)](Organization-1296551000016003.md)
* [BC Døgnområdet (1296561000016000) (Organization)](Organization-1296561000016000.md)
* [BC Mini institutionerne (1296571000016005) (Organization)](Organization-1296571000016005.md)
* [BC Vikingdalen (1296581000016007) (Organization)](Organization-1296581000016007.md)
* [BC Familieindsats med ventil (1296591000016009) (Organization)](Organization-1296591000016009.md)
* [BC Ydungården døgninstitution (1296601000016000) (Organization)](Organization-1296601000016000.md)
* [Ellengården (1296611000016003) (Organization)](Organization-1296611000016003.md)
* [Bostedet Ellengården (1296621000016007) (Organization)](Organization-1296621000016007.md)
* [Center for Specialpædagogiske Børnetilbud (1296631000016009) (Organization)](Organization-1296631000016009.md)
* [CSB Egebækken (1296641000016002) (Organization)](Organization-1296641000016002.md)
* [CSB Egebækken (Heden/Havet) (1296651000016004) (Organization)](Organization-1296651000016004.md)
* [CSB Lysningen (1296661000016001) (Organization)](Organization-1296661000016001.md)
* [CSB Oasen (1296671000016006) (Organization)](Organization-1296671000016006.md)
* [CSB Skovkanten (1296681000016008) (Organization)](Organization-1296681000016008.md)
* [CSB Toppen (1296691000016005) (Organization)](Organization-1296691000016005.md)
* [Familiecentret (1296701000016005) (Organization)](Organization-1296701000016005.md)
* [Familieplejen (1296711000016007) (Organization)](Organization-1296711000016007.md)
* [Aflastningsordningen (1296721000016003) (Organization)](Organization-1296721000016003.md)
* [FC Administration og Elever (1296731000016001) (Organization)](Organization-1296731000016001.md)
* [FC Administration (1296741000016008) (Organization)](Organization-1296741000016008.md)
* [FC Familierådgivning 1 (1296751000016006) (Organization)](Organization-1296751000016006.md)
* [FC Familierådgivning 2 (1296761000016009) (Organization)](Organization-1296761000016009.md)
* [FC Familierådgivning 3 (1296771000016004) (Organization)](Organization-1296771000016004.md)
* [FC Familierådgivning 4 (1296781000016002) (Organization)](Organization-1296781000016002.md)
* [FC Familierådgivning 5 (1296791000016000) (Organization)](Organization-1296791000016000.md)
* [FC Familierådgivning 6 (1296801000016001) (Organization)](Organization-1296801000016001.md)
* [FC Familierådgivning 7 (1296811000016004) (Organization)](Organization-1296811000016004.md)
* [FC Modtagelse mv. (1296821000016008) (Organization)](Organization-1296821000016008.md)
* [Familierådgivning Modtagelse (1296831000016005) (Organization)](Organization-1296831000016005.md)
* [FC Underretningsenhed (1296841000016003) (Organization)](Organization-1296841000016003.md)
* [FC Organisation og Udvikling, Drift (1296851000016000) (Organization)](Organization-1296851000016000.md)
* [Koordinerende Familierådgivning (1296861000016002) (Organization)](Organization-1296861000016002.md)
* [Job, Sundhed og Ydelse (1296871000016007) (Organization)](Organization-1296871000016007.md)
* [Rusmiddelcenter Aarhus (1296881000016009) (Organization)](Organization-1296881000016009.md)
* [RCA Basen Broen Kompas (1296891000016006) (Organization)](Organization-1296891000016006.md)
* [RCA Rådgivning Behandling (1296901000016007) (Organization)](Organization-1296901000016007.md)
* [RCA Substitution (1296911000016009) (Organization)](Organization-1296911000016009.md)
* [Center for Botilbud (1296921000016000) (Organization)](Organization-1296921000016000.md)
* [CB Bjørnbakvej, Korsagergården, Lindely (1296931000016003) (Organization)](Organization-1296931000016003.md)
* [CB BOF Bjørnbakvej (1296941000016005) (Organization)](Organization-1296941000016005.md)
* [CB BOF Lindely (1296951000016008) (Organization)](Organization-1296951000016008.md)
* [CB Grøfthøj, Søndervangen, Skejby, Vejlby (1296961000016006) (Organization)](Organization-1296961000016006.md)
* [CB BOF Grøfthøj (1296971000016001) (Organization)](Organization-1296971000016001.md)
* [CB BOF Skejbyhave (1296981000016004) (Organization)](Organization-1296981000016004.md)
* [CB Hasle, Bymosevej (1296991000016002) (Organization)](Organization-1296991000016002.md)
* [CB BOF Bymosevej (1297001000016006) (Organization)](Organization-1297001000016006.md)
* [CB Hestehavevej, Provstebakken (1297011000016008) (Organization)](Organization-1297011000016008.md)
* [CB BOF Hestehavevej (1297021000016004) (Organization)](Organization-1297021000016004.md)
* [CB BOF Provstebakken (1297031000016002) (Organization)](Organization-1297031000016002.md)
* [CB Provstebakken §107 (1297041000016009) (Organization)](Organization-1297041000016009.md)
* [CB Nygårdsvej (1297051000016007) (Organization)](Organization-1297051000016007.md)
* [CB Tilst, Havkær, Sletten, Tuesten Huse (1297061000016005) (Organization)](Organization-1297061000016005.md)
* [CB Tilst, Havkær, Sletten (1297071000016000) (Organization)](Organization-1297071000016000.md)
* [CB BOF Havkærhus (1297081000016003) (Organization)](Organization-1297081000016003.md)
* [CB BOF Tilst Søndervej (1297091000016001) (Organization)](Organization-1297091000016001.md)
* [CB Tuesten Huse (1297101000016007) (Organization)](Organization-1297101000016007.md)
* [CB Windsor, Sjællandsgade (1297121000016000) (Organization)](Organization-1297121000016000.md)
* [CB Sjællandsgade (1297151000016008) (Organization)](Organization-1297151000016008.md)
* [CF Forsorgshjemmet Østervang (1297481000016009) (Organization)](Organization-1297481000016009.md)
* [CF Boligenheden (1297491000016006) (Organization)](Organization-1297491000016006.md)
* [CF Østervang Boliger (1297501000016002) (Organization)](Organization-1297501000016002.md)
* [CF Boliger (1297511000016000) (Organization)](Organization-1297511000016000.md)
* [CF Grundtvigsvej (1297521000016009) (Organization)](Organization-1297521000016009.md)
* [CF Klyngehusene (1297531000016006) (Organization)](Organization-1297531000016006.md)
* [CF Mosen og Bækken (1297541000016004) (Organization)](Organization-1297541000016004.md)
* [CF Forsorg Nord, L (1297551000016001) (Organization)](Organization-1297551000016001.md)
* [CF Forsorg Nord (1297561000016003) (Organization)](Organization-1297561000016003.md)
* [CF Modtage og Nat (1297571000016008) (Organization)](Organization-1297571000016008.md)
* [CF Modtageenheden (1297581000016005) (Organization)](Organization-1297581000016005.md)
* [CF Ungetilbuddet Nord (1297591000016007) (Organization)](Organization-1297591000016007.md)
* [CF Tre Ege (1297611000016001) (Organization)](Organization-1297611000016001.md)
* [CF Tre Ege Forsorgsafdeling (1297621000016005) (Organization)](Organization-1297621000016005.md)
* [Center for Mestring (1297661000016004) (Organization)](Organization-1297661000016004.md)
* [CM MidtVest (1297671000016009) (Organization)](Organization-1297671000016009.md)
* [CMMV Ledelse 3 (1297681000016006) (Organization)](Organization-1297681000016006.md)
* [CB BOF B. S. Ingemannsvej (1297691000016008) (Organization)](Organization-1297691000016008.md)
* [CMMV BOF Hall Sti (1297701000016008) (Organization)](Organization-1297701000016008.md)
* [CMMV BOF Herredsvang (1297711000016005) (Organization)](Organization-1297711000016005.md)
* [CMMV BOF Jettesvej (1297721000016001) (Organization)](Organization-1297721000016001.md)
* [CMMV BOF Marselisborg Alle (1297731000016004) (Organization)](Organization-1297731000016004.md)
* [CMMV BOF PM Møllersvej (1297741000016006) (Organization)](Organization-1297741000016006.md)
* [CMMV BOF Tjelevej (1297751000016009) (Organization)](Organization-1297751000016009.md)
* [CB BOF Vejlbygade (1297761000016007) (Organization)](Organization-1297761000016007.md)
* [CM Udsatte (1297771000016002) (Organization)](Organization-1297771000016002.md)
* [CM DOT & Gadeteamet (1297781000016000) (Organization)](Organization-1297781000016000.md)
* [Unge, Job og Uddannelse (1297941000016008) (Organization)](Organization-1297941000016008.md)
* [UCV Ungecentret Værkmestergade (1297951000016006) (Organization)](Organization-1297951000016006.md)
* [UCV Administration og Økonomi (1297961000016009) (Organization)](Organization-1297961000016009.md)
* [UCV Modtagelse og Centerunderstøttelse (1297971000016004) (Organization)](Organization-1297971000016004.md)
* [UCV Modtagelsen (1297981000016002) (Organization)](Organization-1297981000016002.md)
* [UCV Rådgivning (1297991000016000) (Organization)](Organization-1297991000016000.md)
* [UCV Rådgivning Afdeling H (1298001000016007) (Organization)](Organization-1298001000016007.md)
* [UCV Rådgivning Afdeling K (1298011000016009) (Organization)](Organization-1298011000016009.md)
* [UCV Rådgivning Afdeling P (1298021000016000) (Organization)](Organization-1298021000016000.md)
* [UCV Rådgivning Afdeling U (1298031000016003) (Organization)](Organization-1298031000016003.md)
* [UCV SORAS (1298041000016005) (Organization)](Organization-1298041000016005.md)
* [UCV SORAS Kollegiet (1298051000016008) (Organization)](Organization-1298051000016008.md)
* [Ungecentret Skanderborgvej (1298061000016006) (Organization)](Organization-1298061000016006.md)
* [UC Katrinebjerg (1298071000016001) (Organization)](Organization-1298071000016001.md)
* [UC Skansen (1298081000016004) (Organization)](Organization-1298081000016004.md)
* [UC Turbo (1298091000016002) (Organization)](Organization-1298091000016002.md)
* [Lægerne Slemming og Wolff I/S (1298281000016009) (Organization)](Organization-1298281000016009.md)
* [Lægerne Slemming og Wollf (1298291000016006) (Organization)](Organization-1298291000016006.md)
* [Kirsten Slemming (1298311000016007) (Organization)](Organization-1298311000016007.md)
* [Betina Sjøberg Wolff (1298321000016003) (Organization)](Organization-1298321000016003.md)
* [Center f bofællesskaber og besk. voksne (1298571000016009) (Organization)](Organization-1298571000016009.md)
* [CBB Annehuse, Hjortshøj (1298581000016006) (Organization)](Organization-1298581000016006.md)
* [CBB Hjortshøj (1298591000016008) (Organization)](Organization-1298591000016008.md)
* [CBB Bøgeskov Aktivitetstilbud (1298601000016004) (Organization)](Organization-1298601000016004.md)
* [CBB Bøgeskovgård Aktivitetstilbud (1298611000016002) (Organization)](Organization-1298611000016002.md)
* [CBB Grundt, Nagel, Kolt, Stenhøj, Hassel (1298621000016006) (Organization)](Organization-1298621000016006.md)
* [CBB Grundtvigsvej (1298631000016008) (Organization)](Organization-1298631000016008.md)
* [CBB Kolt (1298641000016001) (Organization)](Organization-1298641000016001.md)
* [CBB Nagelsvej (1298651000016003) (Organization)](Organization-1298651000016003.md)
* [CBB Harlev, Bronzealdertoften (1298661000016000) (Organization)](Organization-1298661000016000.md)
* [CBB Idræt, Karavana, Klub (1298691000016009) (Organization)](Organization-1298691000016009.md)
* [CBB Idrætscenter Aarhus (1298701000016009) (Organization)](Organization-1298701000016009.md)
* [CBB Karavana (1298711000016006) (Organization)](Organization-1298711000016006.md)
* [CBB Perron X (1298721000016002) (Organization)](Organization-1298721000016002.md)
* [CBB Smil TV (1298731000016000) (Organization)](Organization-1298731000016000.md)
* [CBB Kompetencecenter Nord, Abildhus (1298741000016007) (Organization)](Organization-1298741000016007.md)
* [CBB Idrætscenter Aarhus (1298751000016005) (Organization)](Organization-1298751000016005.md)
* [CBB Kompetencecenter Nord (1298761000016008) (Organization)](Organization-1298761000016008.md)
* [CBB Lyngå Kollegiet, Skejbyparken (1298771000016003) (Organization)](Organization-1298771000016003.md)
* [CBB Skejbyparken (1298781000016001) (Organization)](Organization-1298781000016001.md)
* [CBB Myrholmsvej (1298791000016004) (Organization)](Organization-1298791000016004.md)
* [CBB Søstjernen, Stautruphus (1298801000016000) (Organization)](Organization-1298801000016000.md)
* [Center for autismetilbud til voksne (1298811000016003) (Organization)](Organization-1298811000016003.md)
* [CAV Havbo (1298821000016007) (Organization)](Organization-1298821000016007.md)
* [CAV Havkærparken (1298831000016009) (Organization)](Organization-1298831000016009.md)
* [CAV Havkærparken. (1298841000016002) (Organization)](Organization-1298841000016002.md)
* [CAV Kilebo Hus 1-2 (1298851000016004) (Organization)](Organization-1298851000016004.md)
* [CAV Kilebo Hus 3-4 (1298861000016001) (Organization)](Organization-1298861000016001.md)
* [CAV Kileparken (1298871000016006) (Organization)](Organization-1298871000016006.md)
* [CAV Riskovbrynet, Baldergården (1298881000016008) (Organization)](Organization-1298881000016008.md)
* [CAV Baldergården (1298891000016005) (Organization)](Organization-1298891000016005.md)
* [CAV Risskovbrynet (1298901000016006) (Organization)](Organization-1298901000016006.md)
* [CAV Solgården Sagagården (1298911000016008) (Organization)](Organization-1298911000016008.md)
* [CAV Sagagården (1298921000016004) (Organization)](Organization-1298921000016004.md)
* [CAV Tingagergården, Albertsvænge (1298931000016002) (Organization)](Organization-1298931000016002.md)
* [Center for bosteder til voksne (1298941000016009) (Organization)](Organization-1298941000016009.md)
* [Center for bosteder til voksne (1298951000016007) (Organization)](Organization-1298951000016007.md)
* [CBV Elevhus (1298961000016005) (Organization)](Organization-1298961000016005.md)
* [CBV Elevhus og Aktivitetstilbud (1298971000016000) (Organization)](Organization-1298971000016000.md)
* [CBV Elevhus Hus 4-5 (1298981000016003) (Organization)](Organization-1298981000016003.md)
* [CBV Elevhus Aktivitetstilbud (1298991000016001) (Organization)](Organization-1298991000016001.md)
* [CBV Mårslet (1299001000016001) (Organization)](Organization-1299001000016001.md)
* [CBV Mårslet Afdeling 1 (1299011000016004) (Organization)](Organization-1299011000016004.md)
* [CBV Mårslet Aktivitetstilbud (1299021000016008) (Organization)](Organization-1299021000016008.md)
* [CBV Mårslet Afdeling 2 (1299031000016005) (Organization)](Organization-1299031000016005.md)
* [CBV Mårslet nr. 17 (1299041000016003) (Organization)](Organization-1299041000016003.md)
* [CBV Mårslet nr. 23 (1299051000016000) (Organization)](Organization-1299051000016000.md)
* [CBV Skovlund (1299061000016002) (Organization)](Organization-1299061000016002.md)
* [CBV Skovlund Afdeling 2 (1299071000016007) (Organization)](Organization-1299071000016007.md)
* [CBV Skødstrup (1299081000016009) (Organization)](Organization-1299081000016009.md)
* [CBV Tranbjerg (1299091000016006) (Organization)](Organization-1299091000016006.md)
* [CBV Tranbjerg Afdeling 2 (1299101000016000) (Organization)](Organization-1299101000016000.md)
* [Center specialpæd tilbud voksne og Stef (1299111000016003) (Organization)](Organization-1299111000016003.md)
* [CSV Hvilstedhus (1299121000016007) (Organization)](Organization-1299121000016007.md)
* [CSV Lisbjerghus (1299131000016009) (Organization)](Organization-1299131000016009.md)
* [CSV Majvænget (1299141000016002) (Organization)](Organization-1299141000016002.md)
* [CSV Møllevang, Børglum, Malling (1299151000016004) (Organization)](Organization-1299151000016004.md)
* [CSV Børglumvej (1299161000016001) (Organization)](Organization-1299161000016001.md)
* [CSV Møllevangs Alle (1299171000016006) (Organization)](Organization-1299171000016006.md)
* [CSV Nordbyvænget (1299181000016008) (Organization)](Organization-1299181000016008.md)
* [CSV Snåstrup Vestergård (1299191000016005) (Organization)](Organization-1299191000016005.md)
* [CSV Snåstrup Vestergård Afdeling 2 (1299201000016007) (Organization)](Organization-1299201000016007.md)
* [CSV Vintervej (1299211000016009) (Organization)](Organization-1299211000016009.md)
* [CSV Vintervej afdeling 2 (1299221000016000) (Organization)](Organization-1299221000016000.md)
* [Stefanshjemmet (1299241000016005) (Organization)](Organization-1299241000016005.md)
* [Stefanshjemmet botilbud (1299251000016008) (Organization)](Organization-1299251000016008.md)
* [Stefanshjemmet Havglimt 1. (1299261000016006) (Organization)](Organization-1299261000016006.md)
* [Stefanshjemmet Havglimt 2. (1299271000016001) (Organization)](Organization-1299271000016001.md)
* [Stefanshjemmet Strandvejen 1. sal (1299281000016004) (Organization)](Organization-1299281000016004.md)
* [Stefanshjemmet Strandvejen stuen (1299291000016002) (Organization)](Organization-1299291000016002.md)
* [Rådgivning og Visitation Voksne (1299301000016003) (Organization)](Organization-1299301000016003.md)
* [RVV Administration og Økonomi (1299311000016001) (Organization)](Organization-1299311000016001.md)
* [RVV Administration & Økonomi (1299321000016005) (Organization)](Organization-1299321000016005.md)
* [RVV BPA Merudgifter (1299331000016007) (Organization)](Organization-1299331000016007.md)
* [RVV BPA Rådgivere (1299341000016000) (Organization)](Organization-1299341000016000.md)
* [RVV Merudgifter Rådgivere (1299351000016002) (Organization)](Organization-1299351000016002.md)
* [RVV Døgnområdet (1299361000016004) (Organization)](Organization-1299361000016004.md)
* [RVV Døgnområdet Rådgivere (1299371000016009) (Organization)](Organization-1299371000016009.md)
* [RVV Ekstern afdeling (1299381000016006) (Organization)](Organization-1299381000016006.md)
* [RVV Externt Rådgivere (1299391000016008) (Organization)](Organization-1299391000016008.md)
* [RVV Konsulent kt 6 (1299401000016006) (Organization)](Organization-1299401000016006.md)
* [RVV Dagområdet (1303991000016003) (Organization)](Organization-1303991000016003.md)
* [RVV Dagområdet Rådgivere (1304001000016006) (Organization)](Organization-1304001000016006.md)
* [CF Bygninger og Beskæftigelse (1304031000016002) (Organization)](Organization-1304031000016002.md)
* [CM Ungeindsatserne og Flexbo (1304041000016009) (Organization)](Organization-1304041000016009.md)
* [CM Ungeindsatsen Grønnegade (1304051000016007) (Organization)](Organization-1304051000016007.md)
* [CM Ungeindsatsen Havnegade 107 (1304061000016005) (Organization)](Organization-1304061000016005.md)
* [CBV Mårslet nr. 19 (1304071000016000) (Organization)](Organization-1304071000016000.md)
* [Lægerne Aabyhøj I/S (1304291000016005) (Organization)](Organization-1304291000016005.md)
* [Familielægerne Åbyhøj (1304301000016009) (Organization)](Organization-1304301000016009.md)
* [Rune Enggaard Sennels (1304321000016002) (Organization)](Organization-1304321000016002.md)
* [Peter Hjertholm (1304331000016000) (Organization)](Organization-1304331000016000.md)
* [CF Forsorg Syd, L (1308341000016000) (Organization)](Organization-1308341000016000.md)
* [CF Forsorg Syd (1308351000016002) (Organization)](Organization-1308351000016002.md)
* [CBB Bofællesskabet Generationernes Hus (1308361000016004) (Organization)](Organization-1308361000016004.md)
* [Stefanshjemmet Aktivitetscentret (1308371000016009) (Organization)](Organization-1308371000016009.md)
* [Bettina Lousdal Riis (1309071000016001) (Organization)](Organization-1309071000016001.md)
* [Generationernes Hus (1311441000016002) (Organization)](Organization-1311441000016002.md)
* [Plejehjem Generationernes Hus 3 (1311451000016004) (Organization)](Organization-1311451000016004.md)
* [Plejehjem Generationernes Hus 9 (1311461000016001) (Organization)](Organization-1311461000016001.md)
* [Hj.pl. og Sundhedsklinik Generat. Hus (1311471000016006) (Organization)](Organization-1311471000016006.md)
* [Pleje Hj.pl. og Sundhedsklinik Generat. Hus (1311481000016008) (Organization)](Organization-1311481000016008.md)
* [Sundhedsklinik Generationernes Hus (1311491000016005) (Organization)](Organization-1311491000016005.md)
* [Sygeplejersker Hj.pl. og Sundhedsklinik Generat. Hus (1311501000016001) (Organization)](Organization-1311501000016001.md)
* [Terapeuter Hj.pl. og Sundhedsklinik Generat. Hus (1311511000016004) (Organization)](Organization-1311511000016004.md)
* [Lægeklinikken Anne Blom (1320711000016009) (Organization)](Organization-1320711000016009.md)
* [Lægeklinikken Anne Blom (1320731000016003) (Organization)](Organization-1320731000016003.md)
* [Anne Blom (1320741000016005) (Organization)](Organization-1320741000016005.md)
* [Dorthe Jensen (1323111000016001) (Organization)](Organization-1323111000016001.md)
* [Lægeklinikken Aros I/S (1332971000016000) (Organization)](Organization-1332971000016000.md)
* [Lægeklinikken Aros (1332981000016003) (Organization)](Organization-1332981000016003.md)
* [Hanne Heje (1332991000016001) (Organization)](Organization-1332991000016001.md)
* [Mads Schmidt (1333001000016002) (Organization)](Organization-1333001000016002.md)
* [Ninna Marturin Gammelager (1335721000016006) (Organization)](Organization-1335721000016006.md)
* [Digital forretningsudvikling, MSB (1336701000016008) (Organization)](Organization-1336701000016008.md)
* [Aarhus Friplejehjem Helheden (1340281000016009) (Organization)](Organization-1340281000016009.md)
* [Danny Amanoal (1349381000016008) (Organization)](Organization-1349381000016008.md)
* [Røde Kors sundhedsklinik for migranter Aalborg (1350751000016007) (Organization)](Organization-1350751000016007.md)
* [Røde Kors sundhedsklinik for migranter Aalborg (1350761000016005) (Organization)](Organization-1350761000016005.md)
* [Lægerne Lund & Nielsen I/S (13511000016003) (Organization)](Organization-13511000016003.md)
* [Lægerne Park Alle 5 (13521000016007) (Organization)](Organization-13521000016007.md)
* [HFH Consult (1352751000016006) (Organization)](Organization-1352751000016006.md)
* [Regionsklinik Læsø (1352761000016009) (Organization)](Organization-1352761000016009.md)
* [Helga Marie Fogtmann Have (1352771000016004) (Organization)](Organization-1352771000016004.md)
* [Jette Møller Nielsen (13531000016009) (Organization)](Organization-13531000016009.md)
* [Lis Lund (13541000016002) (Organization)](Organization-13541000016002.md)
* [Klinik Blossom (1355751000016004) (Organization)](Organization-1355751000016004.md)
* [pari said ghader (1355761000016001) (Organization)](Organization-1355761000016001.md)
* [Lægerne Rådhuspladsen I/S (1361811000016000) (Organization)](Organization-1361811000016000.md)
* [Lægerne Rådhuspladsen (1361821000016009) (Organization)](Organization-1361821000016009.md)
* [Signe Aakjær (1361831000016006) (Organization)](Organization-1361831000016006.md)
* [Christina Barbara Bech Schou (1362011000016003) (Organization)](Organization-1362011000016003.md)
* [Plejehjem Malling (1363531000016005) (Organization)](Organization-1363531000016005.md)
* [Pernille Urup Ruban (1368901000016003) (Organization)](Organization-1368901000016003.md)
* [Lægerne Bystævnet (1369481000016006) (Organization)](Organization-1369481000016006.md)
* [Lægerne Bystævnet (1369491000016008) (Organization)](Organization-1369491000016008.md)
* [Jonas Baandrup (1369501000016004) (Organization)](Organization-1369501000016004.md)
* [Dorte Haubjerg Vestergaard (1369511000016002) (Organization)](Organization-1369511000016002.md)
* [Lægerne Bell og Rask I/S (1371711000016002) (Organization)](Organization-1371711000016002.md)
* [Lægerne Bell og Rask (1371721000016006) (Organization)](Organization-1371721000016006.md)
* [Martin Bell Lybecker (1371731000016008) (Organization)](Organization-1371731000016008.md)
* [Christina Rask Nors (1371741000016001) (Organization)](Organization-1371741000016001.md)
* [Lægerne Vestre Strandallé (1372851000016002) (Organization)](Organization-1372851000016002.md)
* [Lægerne Vestre Strandalle (1372861000016004) (Organization)](Organization-1372861000016004.md)
* [Majbrit Bruun Andersen (1372871000016009) (Organization)](Organization-1372871000016009.md)
* [Britta Lindberg Vejbæk (1372881000016006) (Organization)](Organization-1372881000016006.md)
* [Lægerne Busgadehuset I/S (13761000016005) (Organization)](Organization-13761000016005.md)
* [Lægerne Busgadehuset (13771000016000) (Organization)](Organization-13771000016000.md)
* [Lars Ebbe Petersen (13791000016001) (Organization)](Organization-13791000016001.md)
* [Dorthe Houe (13801000016002) (Organization)](Organization-13801000016002.md)
* [Specialklinik Taastrup (1386021000016006) (Organization)](Organization-1386021000016006.md)
* [Amin Baram (1386031000016008) (Organization)](Organization-1386031000016008.md)
* [Langenæs Lægehus (1394731000016002) (Organization)](Organization-1394731000016002.md)
* [Langenæs lægehus (1394741000016009) (Organization)](Organization-1394741000016009.md)
* [Susanne Brogård Carlsen (1394751000016007) (Organization)](Organization-1394751000016007.md)
* [Aurora Borealis ApS (1396221000016002) (Organization)](Organization-1396221000016002.md)
* [Lægekonsulent L.Mattes (1396231000016000) (Organization)](Organization-1396231000016000.md)
* [Liubov Aleksandrovna Penova Schaldemose Mattes (1396241000016007) (Organization)](Organization-1396241000016007.md)
* [UDS Kløvedal (1406191000016001) (Organization)](Organization-1406191000016001.md)
* [UDS Kløvedal. (1406201000016004) (Organization)](Organization-1406201000016004.md)
* [Anna Visby Lunde (1406851000016002) (Organization)](Organization-1406851000016002.md)
* [Camilla Kjellerup (1408901000016008) (Organization)](Organization-1408901000016008.md)
* [Line Johannessen (1408911000016005) (Organization)](Organization-1408911000016005.md)
* [Martin Christensen (1408921000016001) (Organization)](Organization-1408921000016001.md)
* [Simon Birk Tousgaard (1408931000016004) (Organization)](Organization-1408931000016004.md)
* [Line Petersen (1409421000016001) (Organization)](Organization-1409421000016001.md)
* [Lene Maria Ørts Clemmensen (1409431000016004) (Organization)](Organization-1409431000016004.md)
* [PPR (Pædagogisk Psykologisk Rådgivning) (1437191000016005) (Organization)](Organization-1437191000016005.md)
* [Administrativ Service (1438141000016001) (Organization)](Organization-1438141000016001.md)
* [Læge Allan Axelsen (1438971000016007) (Organization)](Organization-1438971000016007.md)
* [Allan Axelsen (1438981000016009) (Organization)](Organization-1438981000016009.md)
* [Allan Axelsen (1438991000016006) (Organization)](Organization-1438991000016006.md)
* [Omsorgscenter Aalborg (1442231000016001) (Organization)](Organization-1442231000016001.md)
* [Ane Møller (1442241000016008) (Organization)](Organization-1442241000016008.md)
* [Look Amazing Beauty Clinic (1461001000016001) (Organization)](Organization-1461001000016001.md)
* [Liubov Penova Mattes (1461021000016008) (Organization)](Organization-1461021000016008.md)
* [Lægehuset Kirkedammen (1461771000016005) (Organization)](Organization-1461771000016005.md)
* [Breeze Diggle (1461781000016007) (Organization)](Organization-1461781000016007.md)
* [CBV Skovlund Hus 29 (1462481000016008) (Organization)](Organization-1462481000016008.md)
* [CBV Skovlund Hus 33 (1462491000016005) (Organization)](Organization-1462491000016005.md)
* [CBV Skovlund Hus 31 (1462501000016001) (Organization)](Organization-1462501000016001.md)
* [CBV Skovlund Hus 35 (1462511000016004) (Organization)](Organization-1462511000016004.md)
* [Luise Solgaard Andersen (1464831000016001) (Organization)](Organization-1464831000016001.md)
* [Eva Laier Cervin (1464841000016008) (Organization)](Organization-1464841000016008.md)
* [Sara Hasseriis (1464851000016006) (Organization)](Organization-1464851000016006.md)
* [Center for trivsel (1467791000016004) (Organization)](Organization-1467791000016004.md)
* [SI Sundhedsteam og Psykologhjælp (1469741000016002) (Organization)](Organization-1469741000016002.md)
* [SI Gratis Psykologhjælp (1469751000016004) (Organization)](Organization-1469751000016004.md)
* [Lægerne Fuglesangs Allé 95 I/S (1476181000016008) (Organization)](Organization-1476181000016008.md)
* [Lægerne Fuglesangs Allé 95 (1476191000016005) (Organization)](Organization-1476191000016005.md)
* [Bjarne Lauritsen (1477441000016006) (Organization)](Organization-1477441000016006.md)
* [Anne Skytte Kaa (1477451000016009) (Organization)](Organization-1477451000016009.md)
* [Lægerne Magnus I/S (1477821000016003) (Organization)](Organization-1477821000016003.md)
* [Lægerne Magnus (1499141000016001) (Organization)](Organization-1499141000016001.md)
* [Charlotte Magnus (1499151000016003) (Organization)](Organization-1499151000016003.md)
* [Simone Holst Magnus (1499181000016007) (Organization)](Organization-1499181000016007.md)
* [Anna Kirstine Winthereik (1515211000016002) (Organization)](Organization-1515211000016002.md)
* [Hasle Ringvej 114 (1517401000016007) (Organization)](Organization-1517401000016007.md)
* [Liubov A. Penova Schaldemose Mattes (1517411000016009) (Organization)](Organization-1517411000016009.md)
* [Beautystyle/ v S. Mikkelsen (1517421000016000) (Organization)](Organization-1517421000016000.md)
* [Svitlana Mikkelsen (1517431000016003) (Organization)](Organization-1517431000016003.md)
* [Laura Faunø Thrane (1520871000016007) (Organization)](Organization-1520871000016007.md)
* [Anders Vibæk (1525481000016003) (Organization)](Organization-1525481000016003.md)
* [Økonomi HR og Borgervelfærd (1525901000016002) (Organization)](Organization-1525901000016002.md)
* [Staben for Sundhed og Forebyggelse (1525911000016000) (Organization)](Organization-1525911000016000.md)
* [Ani Tamoian (1533111000016002) (Organization)](Organization-1533111000016002.md)
* [Lilia Tamoian (1533121000016006) (Organization)](Organization-1533121000016006.md)
* [Stine Sarauw Lindegaard (1533431000016001) (Organization)](Organization-1533431000016001.md)
* [Anne Kvistholm Jensen (1533441000016008) (Organization)](Organization-1533441000016008.md)
* [ArVel P/S (1556461000016001) (Organization)](Organization-1556461000016001.md)
* [Familielægen ArVel (1556721000016000) (Organization)](Organization-1556721000016000.md)
* [Dorthe Precht (1556731000016003) (Organization)](Organization-1556731000016003.md)
* [Kirsten Linnebjerg Jensby (17621000016003) (Organization)](Organization-17621000016003.md)
* [Folkesundhed Aarhus (193071000016008) (Organization)](Organization-193071000016008.md)
* [Skåde Lægehus I/S (20171000016003) (Organization)](Organization-20171000016003.md)
* [Skåde Lægehus (20181000016001) (Organization)](Organization-20181000016001.md)
* [Kolt Lægepraksis (22931000016002) (Organization)](Organization-22931000016002.md)
* [Kolt Lægepraksis (22941000016009) (Organization)](Organization-22941000016009.md)
* [Ingelis Vendel Nielsen (22961000016005) (Organization)](Organization-22961000016005.md)
* [Lægerne Odensegade I/S v/Lise Høyer & Toke Casper Østerby (23671000016004) (Organization)](Organization-23671000016004.md)
* [Lægerne odensegade (23681000016002) (Organization)](Organization-23681000016002.md)
* [Mårslet Lægehus (23871000016003) (Organization)](Organization-23871000016003.md)
* [Mårslet Lægehus (23881000016001) (Organization)](Organization-23881000016001.md)
* [Mette Gregersen (23901000016003) (Organization)](Organization-23901000016003.md)
* [Dorte Lillelund Mortensen (23911000016001) (Organization)](Organization-23911000016001.md)
* [Søren Svenningsen (23921000016005) (Organization)](Organization-23921000016005.md)
* [Lægehuset Harlev (29191000016008) (Organization)](Organization-29191000016008.md)
* [Lægehuset Harlev (29201000016005) (Organization)](Organization-29201000016005.md)
* [Anne Nielsen (29241000016008) (Organization)](Organization-29241000016008.md)
* [Aarhus Kommune (311000016009) (Organization)](Organization-311000016009.md)
* [Lægerne Tilst (31831000016004) (Organization)](Organization-31831000016004.md)
* [Lægerne Tilst (31841000016006) (Organization)](Organization-31841000016006.md)
* [Pernille Rykær (31851000016009) (Organization)](Organization-31851000016009.md)
* [Lægerne Brabrandhus I/S (32301000016008) (Organization)](Organization-32301000016008.md)
* [Lægerne Brabrandhus (32311000016005) (Organization)](Organization-32311000016005.md)
* [Karsten Gott Schmidt (32321000016001) (Organization)](Organization-32321000016001.md)
* [DigitalSundhedDanmark-EMR (325421000016001) (IE) (Organization)](Organization-325421000016001.md)
* [Lægerne Banegårdspladsen 16 (32781000016004) (Organization)](Organization-32781000016004.md)
* [Lægerne Banegårdspladsen 16 (32791000016002) (Organization)](Organization-32791000016002.md)
* [Beinta Maria Skaalum (32811000016001) (Organization)](Organization-32811000016001.md)
* [Søren Top (32821000016005) (Organization)](Organization-32821000016005.md)
* [Flyttet lok.nr. 14/5 Sundhed og Omsorg, Aarhus Kommune (328781000016001) (Organization)](Organization-328781000016001.md)
* [Neurocenter GOP, Aarhus Kommune -KUN INTERNT BRUG (331071000016009) (Organization)](Organization-331071000016009.md)
* [Ortopædkir. GOPcenter, Aarhus Kommune -KUN INTERNT BRUG (331081000016006) (Organization)](Organization-331081000016006.md)
* [GOP §140, Aarhus Kommune (331091000016008) (Organization)](Organization-331091000016008.md)
* [Alment Praktiserende Læge Ole Juel Thiis Knudsen ApS (35381000016009) (Organization)](Organization-35381000016009.md)
* [Læge Ole Juel Thiis Knudsen (35391000016006) (Organization)](Organization-35391000016006.md)
* [Ole Juel Thiis Knudsen (35401000016009) (Organization)](Organization-35401000016009.md)
* [Selvejende Fortegården (361201000016003) (Organization)](Organization-361201000016003.md)
* [Selvejende Sct. Olaf (361221000016005) (Organization)](Organization-361221000016005.md)
* [Selvejende Kløvervangen (361241000016000) (Organization)](Organization-361241000016000.md)
* [Aarhus Friplejehjem Slet (361321000016000) (Organization)](Organization-361321000016000.md)
* [Pernille Bech (363791000016002) (Organization)](Organization-363791000016002.md)
* [Lægehuset Ryesgade 1 (38141000016007) (Organization)](Organization-38141000016007.md)
* [Lægehuset Ryesgade 1 (38151000016005) (Organization)](Organization-38151000016005.md)
* [Lægerne i Risvangen I/S (38551000016003) (Organization)](Organization-38551000016003.md)
* [Lægerne i Risvangen (38561000016000) (Organization)](Organization-38561000016000.md)
* [Pia Brønlund Olesen (389021000016004) (Organization)](Organization-389021000016004.md)
* [Lene Berg (393391000016000) (Organization)](Organization-393391000016000.md)
* [MarselisborgCentret (4091000016003) (Organization)](Organization-4091000016003.md)
* [Åbyhøj Lægehus I/S (41491000016000) (Organization)](Organization-41491000016000.md)
* [Åbyhøj Lægehus (41501000016009) (Organization)](Organization-41501000016009.md)
* [Hasle Lægehus v/Thomas Otbo (438991000016006) (Organization)](Organization-438991000016006.md)
* [Hasle Lægehus, Thomas Otbo (439001000016006) (Organization)](Organization-439001000016006.md)
* [Thomas Otbo (439011000016008) (Organization)](Organization-439011000016008.md)
* [Lægerne Rolighedsvej I/S (448001000016001) (Organization)](Organization-448001000016001.md)
* [Lægerne Rolighedsvej (448011000016004) (Organization)](Organization-448011000016004.md)
* [Jakob Ravn (448621000016002) (Organization)](Organization-448621000016002.md)
* [Læge Jacob Laurberg (455551000016003) (Organization)](Organization-455551000016003.md)
* [Læge Jacob Laurberg (455561000016000) (Organization)](Organization-455561000016000.md)
* [Jacob Laurberg (455571000016005) (Organization)](Organization-455571000016005.md)
* [Læge Ejner Kjær (45591000016002) (Organization)](Organization-45591000016002.md)
* [Læge Ejner Kjær (45601000016006) (Organization)](Organization-45601000016006.md)
* [Ejner Kjær (45611000016008) (Organization)](Organization-45611000016008.md)
* [Lone Vejlø Bækby (458241000016008) (Organization)](Organization-458241000016008.md)
* [Pia Krebs Hessellund (460891000016009) (Organization)](Organization-460891000016009.md)
* [Margrethe Sehested (467631000016008) (Organization)](Organization-467631000016008.md)
* [Simon Skibsholt (468221000016009) (Organization)](Organization-468221000016009.md)
* [Trøjborg Lægehus I/S (468851000016000) (Organization)](Organization-468851000016000.md)
* [Trøjborg Lægehus (468861000016002) (Organization)](Organization-468861000016002.md)
* [Morten Charles (468871000016007) (Organization)](Organization-468871000016007.md)
* [Rikke Pilegaard Hansen (468881000016009) (Organization)](Organization-468881000016009.md)
* [Wicky Kastrup (469331000016008) (Organization)](Organization-469331000016008.md)
* [Sune Lange (473831000016007) (Organization)](Organization-473831000016007.md)
* [Lægerne i Gellerup I/S (47401000016001) (Organization)](Organization-47401000016001.md)
* [Lægerne i Gellerup (47411000016004) (Organization)](Organization-47411000016004.md)
* [Flyttet lok.nr 14/5 Socialforvaltningen, Aarhus Kommune (480601000016000) (Organization)](Organization-480601000016000.md)
* [Lægerne Bjerre og Ingvardsen I/S (481121000016009) (Organization)](Organization-481121000016009.md)
* [Lægerne Bjerre og Ingvardsen (481131000016006) (Organization)](Organization-481131000016006.md)
* [Birgitte Vandborg Bjerre (481141000016004) (Organization)](Organization-481141000016004.md)
* [Christina Bilenberg (485801000016008) (Organization)](Organization-485801000016008.md)
* [Flyttet lok.nr 14/5 Sundhedspleje og Børn og Unge-læge (488291000016009) (Organization)](Organization-488291000016009.md)
* [Lægerne Borggade I/S (48961000016005) (Organization)](Organization-48961000016005.md)
* [Lægerne Borggade (48971000016000) (Organization)](Organization-48971000016000.md)
* [Anna Marie Villadsen (48981000016003) (Organization)](Organization-48981000016003.md)
* [Tove Poulsen (48991000016001) (Organization)](Organization-48991000016001.md)
* [Selvejende OK Fonden Egå (490181000016002) (Organization)](Organization-490181000016002.md)
* [Læge Inger Tingsgård Bone (493721000016008) (Organization)](Organization-493721000016008.md)
* [Lægerne Sct. Olufsgade I/S v/Johansen, Dam-Hansen og Poulsen (49581000016002) (Organization)](Organization-49581000016002.md)
* [Lægerne Skt. Olufsgade (49591000016000) (Organization)](Organization-49591000016000.md)
* [Ulla Thybo Johansen (49601000016009) (Organization)](Organization-49601000016009.md)
* [Jette Dam-Hansen (49611000016006) (Organization)](Organization-49611000016006.md)
* [Frans Algren (49621000016002) (Organization)](Organization-49621000016002.md)
* [Linda Rolfsen (497331000016004) (Organization)](Organization-497331000016004.md)
* [Læge Josefine Hirschsprung Lange (497751000016008) (Organization)](Organization-497751000016008.md)
* [Læge Josefine Hirschsprung Lange (497761000016006) (Organization)](Organization-497761000016006.md)
* [Josefine H. Lange (497771000016001) (Organization)](Organization-497771000016001.md)
* [Lisbeth Christiansen (500311000016001) (Organization)](Organization-500311000016001.md)
* [Malene Johansson Bechtold (506401000016008) (Organization)](Organization-506401000016008.md)
* [Læge Erik Høgh (506931000016008) (Organization)](Organization-506931000016008.md)
* [Læge Erik Høgh (506941000016001) (Organization)](Organization-506941000016001.md)
* [Erik Høgh (506951000016003) (Organization)](Organization-506951000016003.md)
* [Lægerne Store Torv 6, Aarhus I/S (51241000016006) (Organization)](Organization-51241000016006.md)
* [Lægerne Store Torv 6, 1. sal, Aarhus (51251000016009) (Organization)](Organization-51251000016009.md)
* [Elna Hansen (51261000016007) (Organization)](Organization-51261000016007.md)
* [Anna Meldgaard Esbjerg (51271000016002) (Organization)](Organization-51271000016002.md)
* [Praktiserende læge Asger Lau Dalmose (515261000016000) (Organization)](Organization-515261000016000.md)
* [Læge Asger Dalmose (515271000016005) (Organization)](Organization-515271000016005.md)
* [Asger Dalmose (515281000016007) (Organization)](Organization-515281000016007.md)
* [Familielægerne Store Torv I/S (51781000016008) (Organization)](Organization-51781000016008.md)
* [Familielægerne Store Torv (51791000016005) (Organization)](Organization-51791000016005.md)
* [Skødstrup Lægepraksis (52581000016005) (Organization)](Organization-52581000016005.md)
* [Skødstrup Lægepraksis (52591000016007) (Organization)](Organization-52591000016007.md)
* [Lone Kongstad (52621000016005) (Organization)](Organization-52621000016005.md)
* [Per Kallestrup (52661000016004) (Organization)](Organization-52661000016004.md)
* [Kurt Rasmussen (52671000016009) (Organization)](Organization-52671000016009.md)
* [I/S Lægerne Frydenlund (533081000016008) (Organization)](Organization-533081000016008.md)
* [Lægerne Frydenlund (533091000016005) (Organization)](Organization-533091000016005.md)
* [Tanja Nygaard Henriksen (533101000016004) (Organization)](Organization-533101000016004.md)
* [Pernille Rosbjerg Hansen (533111000016002) (Organization)](Organization-533111000016002.md)
* [Lise Høyer (534621000016004) (Organization)](Organization-534621000016004.md)
* [Sociallægeinstitutionen Aarhus (535411000016006) (Organization)](Organization-535411000016006.md)
* [Lægerne Valdemarsgade I/S (53881000016000) (Organization)](Organization-53881000016000.md)
* [Lægerne Valdemarsgade (53891000016003) (Organization)](Organization-53891000016003.md)
* [Jette Kolding Kristensen (53921000016009) (Organization)](Organization-53921000016009.md)
* [Pia Brahe (541111000016002) (Organization)](Organization-541111000016002.md)
* [Familielægerne i Holme I/S (54401000016009) (Organization)](Organization-54401000016009.md)
* [Familielægerne i Holme (54411000016006) (Organization)](Organization-54411000016006.md)
* [Jens Fredslund (544191000016006) (Organization)](Organization-544191000016006.md)
* [Jesper Bernt Madsen (54421000016002) (Organization)](Organization-54421000016002.md)
* [Sociallægeinstitutionen - Inspektion (545241000016007) (Organization)](Organization-545241000016007.md)
* [Forenede Care Bøgeskovhus Plejebolig (545311000016003) (Organization)](Organization-545311000016003.md)
* [Læge Inger Tingsgård Bone (545521000016000) (Organization)](Organization-545521000016000.md)
* [Inger Tingsgård Bone (545531000016003) (Organization)](Organization-545531000016003.md)
* [Claus Risegaard Sohrt (549811000016005) (Organization)](Organization-549811000016005.md)
* [Lægerne Johansson Bechtold I/S (55471000016004) (Organization)](Organization-55471000016004.md)
* [Lægerne Johansson Bechtold (55481000016002) (Organization)](Organization-55481000016002.md)
* [Mats Johansson Bechtold (55491000016000) (Organization)](Organization-55491000016000.md)
* [Anders Langelund (554911000016003) (Organization)](Organization-554911000016003.md)
* [Lægerne Østergade I/S (55701000016003) (Organization)](Organization-55701000016003.md)
* [Lægerne Østergade (55711000016001) (Organization)](Organization-55711000016001.md)
* [Eva Cathrine Sangild (55731000016007) (Organization)](Organization-55731000016007.md)
* [Lene Frisk Jeppesen (55741000016000) (Organization)](Organization-55741000016000.md)
* [Skejbylægerne I/S (56221000016006) (Organization)](Organization-56221000016006.md)
* [Skejbylægerne (56231000016008) (Organization)](Organization-56231000016008.md)
* [Lars Løvgreen (56251000016003) (Organization)](Organization-56251000016003.md)
* [Lægerne i Malling (57361000016005) (Organization)](Organization-57361000016005.md)
* [Lægerne i Malling (57371000016000) (Organization)](Organization-57371000016000.md)
* [Tore Karsø (57381000016003) (Organization)](Organization-57381000016003.md)
* [Marselislægerne (573961000016000) (Organization)](Organization-573961000016000.md)
* [Marselislægerne (573971000016005) (Organization)](Organization-573971000016005.md)
* [Torben Elgaard Lock (573981000016007) (Organization)](Organization-573981000016007.md)
* [Susanne Bjerggaard Jensen (573991000016009) (Organization)](Organization-573991000016009.md)
* [Henrik Spanggård (57401000016003) (Organization)](Organization-57401000016003.md)
* [Ellen Marg. Bach Hellfritzsch (57411000016001) (Organization)](Organization-57411000016001.md)
* [Mette Kjærgaard (57421000016005) (Organization)](Organization-57421000016005.md)
* [LÆ- blanketter, suppl. kommunikation, Aarhus (576011000016009) (Organization)](Organization-576011000016009.md)
* [Troels Buus Treebak (576151000016009) (Organization)](Organization-576151000016009.md)
* [Morten Bundgaard Villadsen (594101000016008) (Organization)](Organization-594101000016008.md)
* [Rune Linderoth Christiansen (595011000016008) (Organization)](Organization-595011000016008.md)
* [Tilst Lægehus I/S (596191000016005) (Organization)](Organization-596191000016005.md)
* [Tilst Lægehus (596201000016007) (Organization)](Organization-596201000016007.md)
* [Niels Bechtold (596251000016008) (Organization)](Organization-596251000016008.md)
* [Toke Casper Østerby (600291000016009) (Organization)](Organization-600291000016009.md)
* [Rasmus Nørøxe (601471000016004) (Organization)](Organization-601471000016004.md)
* [Line Staehelin (602011000016006) (Organization)](Organization-602011000016006.md)
* [Christina Kaas Løber (603661000016006) (Organization)](Organization-603661000016006.md)
* [I/S Lægerne Sønderhøj (609501000016005) (Organization)](Organization-609501000016005.md)
* [Lægerne Sønderhøj (609511000016007) (Organization)](Organization-609511000016007.md)
* [Louise Ledet Sohrt (609521000016003) (Organization)](Organization-609521000016003.md)
* [Rikke Mejer (609531000016001) (Organization)](Organization-609531000016001.md)
* [Kirurgisk klinik Brabrand (610821000016008) (Organization)](Organization-610821000016008.md)
* [Kirurgisk klinik Brabrand (610831000016005) (Organization)](Organization-610831000016005.md)
* [Kirurgisk klinik Brabrand (610841000016003) (Organization)](Organization-610841000016003.md)
* [Jonas Engkjær Christensen (618071000016004) (Organization)](Organization-618071000016004.md)
* [Jeppe Bohl Larsen (618971000016003) (Organization)](Organization-618971000016003.md)
* [Jacob Breining (619491000016004) (Organization)](Organization-619491000016004.md)
* [Peter Krogh Fjeldborg (626401000016005) (Organization)](Organization-626401000016005.md)
* [Viby Lægehus (632931000016006) (Organization)](Organization-632931000016006.md)
* [Viby Lægehus (632941000016004) (Organization)](Organization-632941000016004.md)
* [Hans Jacob Teglers Feer (632951000016001) (Organization)](Organization-632951000016001.md)
* [Birgitte From og Pia Brønlund Olesen I/S (63611000016003) (Organization)](Organization-63611000016003.md)
* [Lægerne Skejbyparken (63621000016007) (Organization)](Organization-63621000016007.md)
* [Birgitte From (63631000016009) (Organization)](Organization-63631000016009.md)
* [Lægeklinikken Tordenskjoldsgade (637191000016008) (Organization)](Organization-637191000016008.md)
* [Lægeklinikken Tordenskjoldsgade (637211000016007) (Organization)](Organization-637211000016007.md)
* [Tina Schnoor (637221000016003) (Organization)](Organization-637221000016003.md)
* [Læge Philipp Harbig (643771000016003) (Organization)](Organization-643771000016003.md)
* [Læge Philipp Harbig (643781000016001) (Organization)](Organization-643781000016001.md)
* [Philipp Harbig (643791000016004) (Organization)](Organization-643791000016004.md)
* [Trine Brogaard (648601000016007) (Organization)](Organization-648601000016007.md)
* [Læge Kirsten Slemming (649071000016004) (Organization)](Organization-649071000016004.md)
* [Læge Kirsten Slemming (649081000016002) (Organization)](Organization-649081000016002.md)
* [Kirsten Slemming (649091000016000) (Organization)](Organization-649091000016000.md)
* [Jonas Dyhr Rask (651431000016008) (Organization)](Organization-651431000016008.md)
* [Lægerne Skt. Clemens Bro I/S (672261000016008) (Organization)](Organization-672261000016008.md)
* [Lægerne Skt. Clemens Bro (672271000016003) (Organization)](Organization-672271000016003.md)
* [Charlotte Melchior Bendtsen (672281000016001) (Organization)](Organization-672281000016001.md)
* [Andreas Rosborg Kristensen (672291000016004) (Organization)](Organization-672291000016004.md)
* [Marie Aaen (681391000016008) (Organization)](Organization-681391000016008.md)
* [Lægehuset Banegårdspladsen 6 I/S (68591000016004) (Organization)](Organization-68591000016004.md)
* [Lægehuset Banegårdspladsen 6 (68601000016008) (Organization)](Organization-68601000016008.md)
* [Morten Bondo Christensen (68611000016005) (Organization)](Organization-68611000016005.md)
* [Læge Ane Schmeltz Søgaard (686301000016007) (Organization)](Organization-686301000016007.md)
* [Henrik Ovesen (68631000016004) (Organization)](Organization-68631000016004.md)
* [Læge Ane Søgaard (686311000016009) (Organization)](Organization-686311000016009.md)
* [Ane Søgaard (686321000016000) (Organization)](Organization-686321000016000.md)
* [Læge Kirsten Linnebjerg Jensby (689031000016006) (Organization)](Organization-689031000016006.md)
* [Kirsten Linnebjerg Jensby (689041000016004) (Organization)](Organization-689041000016004.md)
* [Lægerne Sehested, Billeskov og Kristensen (68991000016006) (Organization)](Organization-68991000016006.md)
* [Lægerne Sehested, Billeskov og Kristensen (69001000016006) (Organization)](Organization-69001000016006.md)
* [Ellen Louise Kristensen (69021000016004) (Organization)](Organization-69021000016004.md)
* [Lægerne Stjernepladsen I/S (698131000016001) (Organization)](Organization-698131000016001.md)
* [Lægerne Stjernepladsen (698141000016008) (Organization)](Organization-698141000016008.md)
* [Tine Nørregaard Nielsen (698161000016009) (Organization)](Organization-698161000016009.md)
* [Læge Jørgen Bach Holm (710431000016000) (Organization)](Organization-710431000016000.md)
* [Læge Jørgen Holm (710441000016007) (Organization)](Organization-710441000016007.md)
* [Læge Jørgen Holm (710451000016005) (Organization)](Organization-710451000016005.md)
* [Alment Praktiserende Læge Helena Dalsgaard Grove Aps (711561000016001) (Organization)](Organization-711561000016001.md)
* [Læge Helena Dalsgaard Grove (711571000016006) (Organization)](Organization-711571000016006.md)
* [Læge Helena Grove (711581000016008) (Organization)](Organization-711581000016008.md)
* [Øvrig kommunal forvaltning, Aarhus (7141000016000) (Organization)](Organization-7141000016000.md)
* [Lægerne Skt Pauls Kirkeplads 2 (73011000016001) (Organization)](Organization-73011000016001.md)
* [Lægerne Skt. Pauls Kirkeplads 2 (73021000016005) (Organization)](Organization-73021000016005.md)
* [Læge Marie Geday (745051000016003) (Organization)](Organization-745051000016003.md)
* [Læge Marie Geday (745061000016000) (Organization)](Organization-745061000016000.md)
* [Marie Geday (745071000016005) (Organization)](Organization-745071000016005.md)
* [Hasle Lægehus I/S (749581000016003) (Organization)](Organization-749581000016003.md)
* [Hasle Lægehus (749591000016001) (Organization)](Organization-749591000016001.md)
* [Helle Bisgaard (749601000016005) (Organization)](Organization-749601000016005.md)
* [Lægerne Merete Andersen og Dorte Lei Kaltoft I/S (753681000016002) (Organization)](Organization-753681000016002.md)
* [Lægerne Merete Andersen og Dorte Lei Kaltoft (753691000016000) (Organization)](Organization-753691000016000.md)
* [Lægerne i Solbjerg I/S (75451000016008) (Organization)](Organization-75451000016008.md)
* [Lægerne i Solbjerg (75461000016006) (Organization)](Organization-75461000016006.md)
* [Karin Gubi (75471000016001) (Organization)](Organization-75471000016001.md)
* [Lene Skovmose (75481000016004) (Organization)](Organization-75481000016004.md)
* [Neurocenter AAK (7671000016001) (Organization)](Organization-7671000016001.md)
* [Læge Henrik Nordentoft (774131000016005) (Organization)](Organization-774131000016005.md)
* [Læge Henrik Nordentoft (774141000016003) (Organization)](Organization-774141000016003.md)
* [Henrik Nordentoft (774151000016000) (Organization)](Organization-774151000016000.md)
* [Læge Bruce P. Kyle Aarhus Privatklinik (786941000016001) (Organization)](Organization-786941000016001.md)
* [Aarhus Privatklinik (786951000016003) (Organization)](Organization-786951000016003.md)
* [Bruce Phillip Kyle (786961000016000) (Organization)](Organization-786961000016000.md)
* [Læge Lene Rosendahl (817251000016008) (Organization)](Organization-817251000016008.md)
* [Læge Lene Rosendahl (817261000016006) (Organization)](Organization-817261000016006.md)
* [Lene Rosendahl (817271000016001) (Organization)](Organization-817271000016001.md)
* [Lægeklinikken Østergade 1 I/S (826671000016008) (Organization)](Organization-826671000016008.md)
* [Lægeklinikken Østergade 1 (826681000016005) (Organization)](Organization-826681000016005.md)
* [Lægeklinikken Østergade 1 (826691000016007) (Organization)](Organization-826691000016007.md)
* [Lægehuset Kirkedammen (830611000016000) (Organization)](Organization-830611000016000.md)
* [Lægevagten Region Midt (830621000016009) (Organization)](Organization-830621000016009.md)
* [Breeze Diggle (830631000016006) (Organization)](Organization-830631000016006.md)
* [Institute for Cure (833031000016008) (Organization)](Organization-833031000016008.md)
* [Institute for Cure (833041000016001) (Organization)](Organization-833041000016001.md)
* [Søren Stoustrup Aarslev Flytlie (833051000016003) (Organization)](Organization-833051000016003.md)
* [Banegårdslægerne (83991000016000) (Organization)](Organization-83991000016000.md)
* [Lægerne ved Banegården (84001000016008) (Organization)](Organization-84001000016008.md)
* [Inge Husted (84011000016005) (Organization)](Organization-84011000016005.md)
* [Anette Aggerholm (84021000016001) (Organization)](Organization-84021000016001.md)
* [Allé Lægerne I/S (84511000016002) (Organization)](Organization-84511000016002.md)
* [Park alle 11, 8000, Aarhus c (84521000016006) (Organization)](Organization-84521000016006.md)
* [Nikolaj Evaldsen (84531000016008) (Organization)](Organization-84531000016008.md)
* [Læge Mikael Munk (85521000016005) (Organization)](Organization-85521000016005.md)
* [Lægerne Viby Midtpunkt (85531000016007) (Organization)](Organization-85531000016007.md)
* [Mikael Munk Jensen (85541000016000) (Organization)](Organization-85541000016000.md)
* [Paradisklinikken I/S (862261000016007) (Organization)](Organization-862261000016007.md)
* [Paradisklinikken (862271000016002) (Organization)](Organization-862271000016002.md)
* [Jacob Laurberg (862281000016000) (Organization)](Organization-862281000016000.md)
* [Røde Kors (873061000016003) (Organization)](Organization-873061000016003.md)
* [Røde Kors Sundhedsklinik for migranter København (873071000016008) (Organization)](Organization-873071000016008.md)
* [Sundhedsklinik for udokumenterede migranter (873081000016005) (Organization)](Organization-873081000016005.md)
* [Røde Kors (873111000016004) (Organization)](Organization-873111000016004.md)
* [Røde Kors (873121000016008) (Organization)](Organization-873121000016008.md)
* [Læge Niels Bjørn (883011000016007) (Organization)](Organization-883011000016007.md)
* [Lægeklinikken Østergade 1, Læge Niels Bjørn (883021000016003) (Organization)](Organization-883021000016003.md)
* [Læge Niels Bjørn (883031000016001) (Organization)](Organization-883031000016001.md)
* [Lægerne ved Hasle Torv (88311000016003) (Organization)](Organization-88311000016003.md)
* [Lægerne ved Hasle Torv (88321000016007) (Organization)](Organization-88321000016007.md)
* [Mette Odborg (88341000016002) (Organization)](Organization-88341000016002.md)
* [Kian Pedrampour (88481000016000) (Organization)](Organization-88481000016000.md)
* [Praktiserende læge Kian Pedrampour (88491000016003) (Organization)](Organization-88491000016003.md)
* [Kian Pedrampour (88501000016007) (Organization)](Organization-88501000016007.md)
* [Lægeklinikken Trøjborg I/S (88681000016003) (Organization)](Organization-88681000016003.md)
* [Lægeklinikken Trøjborg (88691000016001) (Organization)](Organization-88691000016001.md)
* [Kristian Berg Sandvej (88701000016001) (Organization)](Organization-88701000016001.md)
* [Læge Elisabeth Møller-Hansen (89381000016004) (Organization)](Organization-89381000016004.md)
* [Læge Elisabeth Møller-Hansen (89391000016002) (Organization)](Organization-89391000016002.md)
* [Elisabeth Møller-Hansen (89401000016004) (Organization)](Organization-89401000016004.md)
* [Lægerne Berg, Lentz og Fjeldborg I/S (8951000016003) (Organization)](Organization-8951000016003.md)
* [Lægerne i Midtbyen (8961000016000) (Organization)](Organization-8961000016000.md)
* [Marianne Roslev Lentz (8991000016009) (Organization)](Organization-8991000016009.md)
* [Praktiserende læge Sebastian Friis Abrahamsen (903541000016005) (Organization)](Organization-903541000016005.md)
* [Læge Sebastian Friis Abrahamsen (903551000016008) (Organization)](Organization-903551000016008.md)
* [Sebastian Friis Abrahamsen (903561000016006) (Organization)](Organization-903561000016006.md)
* [Jesper Billeskov Jansen (911041000016004) (Organization)](Organization-911041000016004.md)
* [Læge Anette Henriksen (917671000016006) (Organization)](Organization-917671000016006.md)
* [Læge Anette Henriksen (917681000016008) (Organization)](Organization-917681000016008.md)
* [Anette Henriksen (917691000016005) (Organization)](Organization-917691000016005.md)
* [Stine Lykke Storgaard (924161000016005) (Organization)](Organization-924161000016005.md)
* [Niclas Seth Sørensen (924171000016000) (Organization)](Organization-924171000016000.md)
* [Læge Anders Brøndt (928961000016002) (Organization)](Organization-928961000016002.md)
* [Læge Anders Brøndt (928971000016007) (Organization)](Organization-928971000016007.md)
* [Anders Brøndt (928981000016009) (Organization)](Organization-928981000016009.md)
* [Højbjerg Lægepraksis (930281000016002) (Organization)](Organization-930281000016002.md)
* [Højbjerg lægepraksis (930291000016000) (Organization)](Organization-930291000016000.md)
* [Pari Said Ghader (930301000016001) (Organization)](Organization-930301000016001.md)
* [Sundhed og Omsorg (937961000016000) (Organization)](Organization-937961000016000.md)
* [Private plejehjem (937971000016005) (Organization)](Organization-937971000016005.md)
* [Voksentandplejen, Aarhus (947241000016008) (Organization)](Organization-947241000016008.md)
* [Voksentandplejen, Aarhus (947251000016006) (Organization)](Organization-947251000016006.md)
* [Rehabiliteringshøjskolen (951241000016004) (Organization)](Organization-951241000016004.md)
* [Folkesundhed Aarhus Globus1 (951291000016007) (Organization)](Organization-951291000016007.md)
* [Folkesundhed Aarhus FrydenlundHUSET (951301000016006) (Organization)](Organization-951301000016006.md)
* [Børn og unge (951311000016008) (Organization)](Organization-951311000016008.md)
* [Sundhedspleje (951321000016004) (Organization)](Organization-951321000016004.md)
* [Tandplejen Aarhus (951341000016009) (Organization)](Organization-951341000016009.md)
* [Voksne, Job og Handicap (951361000016005) (Organization)](Organization-951361000016005.md)
* [Børn, Familier og Fællesskaber (951391000016001) (Organization)](Organization-951391000016001.md)
* [Job, Udsatte og Socialpsykiatri (951401000016003) (Organization)](Organization-951401000016003.md)
* [Plejehjem Abildgården (951431000016007) (Organization)](Organization-951431000016007.md)
* [Plejehjem Bjerggården (951441000016000) (Organization)](Organization-951441000016000.md)
* [Plejehjem Skelager (951451000016002) (Organization)](Organization-951451000016002.md)
* [Plejehjem Trøjborg (951461000016004) (Organization)](Organization-951461000016004.md)
* [Plejehjem Vejlbygade (951471000016009) (Organization)](Organization-951471000016009.md)
* [Plejehjem Fuglebakken (951481000016006) (Organization)](Organization-951481000016006.md)
* [Plejehjem Augustenborggade (951651000016004) (Organization)](Organization-951651000016004.md)
* [Plejehjem Husumvej (951671000016006) (Organization)](Organization-951671000016006.md)
* [Plejehjem Rosenvang (951681000016008) (Organization)](Organization-951681000016008.md)
* [Plejehjem Vidtskuevej (951691000016005) (Organization)](Organization-951691000016005.md)
* [Plejehjem Kildevang (951981000016004) (Organization)](Organization-951981000016004.md)
* [Plejehjem Koltgården (951991000016002) (Organization)](Organization-951991000016002.md)
* [Plejehjem Kristiansgården (952001000016004) (Organization)](Organization-952001000016004.md)
* [Plejehjem Solbjerg (952011000016002) (Organization)](Organization-952011000016002.md)
* [Plejehjem Tranbjerg (952021000016006) (Organization)](Organization-952021000016006.md)
* [Plejehjem Carl Blochs Gade (952051000016003) (Organization)](Organization-952051000016003.md)
* [Plejehjem Ceres Huset (952061000016000) (Organization)](Organization-952061000016000.md)
* [Plejehjem Sifsgård (952081000016007) (Organization)](Organization-952081000016007.md)
* [Plejehjem Thorsgården (952101000016003) (Organization)](Organization-952101000016003.md)
* [Plejehjem Åbygård (952111000016001) (Organization)](Organization-952111000016001.md)
* [Plejehjem Bjørnshøj (952141000016000) (Organization)](Organization-952141000016000.md)
* [Plejehjem Hedevej (952151000016002) (Organization)](Organization-952151000016002.md)
* [Plejehjem Hjortshøj (952161000016004) (Organization)](Organization-952161000016004.md)
* [Plejehjem Hørgården (952171000016009) (Organization)](Organization-952171000016009.md)
* [Plejehjem Jasminvej (952181000016006) (Organization)](Organization-952181000016006.md)
* [Plejehjem Skæring (952191000016008) (Organization)](Organization-952191000016008.md)
* [Plejehjem Sønderskovhus (952201000016005) (Organization)](Organization-952201000016005.md)
* [Plejehjem Engsøgård (952581000016000) (Organization)](Organization-952581000016000.md)
* [Plejehjem Hasle (952591000016003) (Organization)](Organization-952591000016003.md)
* [Plejehjem Havkær (952601000016007) (Organization)](Organization-952601000016007.md)
* [Plejehjem Lotus (952611000016009) (Organization)](Organization-952611000016009.md)
* [Plejehjem Næshøj (952621000016000) (Organization)](Organization-952621000016000.md)
* [Plejehjem Sabro (952631000016003) (Organization)](Organization-952631000016003.md)
* [Plejehjem Søholm (952641000016005) (Organization)](Organization-952641000016005.md)
* [Plejehjem Borgvold (952671000016001) (Organization)](Organization-952671000016001.md)
* [Plejehjem Egely (952681000016004) (Organization)](Organization-952681000016004.md)
* [Plejehjem Hestehavehusene (952691000016002) (Organization)](Organization-952691000016002.md)
* [Plejehjem Kongsgården (952701000016002) (Organization)](Organization-952701000016002.md)
* [Plejehjem Madsbjerg (952711000016000) (Organization)](Organization-952711000016000.md)
* [Alment Praktiserende Læge Betina Sjøberg Wolff ApS (954921000016003) (Organization)](Organization-954921000016003.md)
* [Alment Praktiserende Læge Betina Sjøberg Wolff (954931000016001) (Organization)](Organization-954931000016001.md)
* [Betina Sjøberg Wolff (954941000016008) (Organization)](Organization-954941000016008.md)
* [Byens Lægehus I/S (9561000016001) (Organization)](Organization-9561000016001.md)
* [Byens Lægehus (9571000016006) (Organization)](Organization-9571000016006.md)
* [Vibeke Hoffmeyer (9591000016005) (Organization)](Organization-9591000016005.md)
* [Demenshjørnet (960671000016006) (Organization)](Organization-960671000016006.md)
* [Louise Søgaard Selmer (961961000016000) (Organization)](Organization-961961000016000.md)
* [Flyvelæge-Aarhus.dk (962361000016009) (Organization)](Organization-962361000016009.md)
* [Flyvelæge-Aarhus.dk (962371000016004) (Organization)](Organization-962371000016004.md)
* [Søren Termansen Okholm (962381000016002) (Organization)](Organization-962381000016002.md)
* [Mikkel Reimer Hansen (964271000016000) (Organization)](Organization-964271000016000.md)
* [Trine Tousgaard Piil (964281000016003) (Organization)](Organization-964281000016003.md)
* [Lægeklinik Signe Brøndt (970101000016000) (Organization)](Organization-970101000016000.md)
* [Læge Signe Brøndt (970111000016003) (Organization)](Organization-970111000016003.md)
* [Signe Brøndt (970121000016007) (Organization)](Organization-970121000016007.md)
* [Lægerne Warrer og Isaksen (984151000016000) (Organization)](Organization-984151000016000.md)
* [Hasse Skibsted Clemmensen (988101000016008) (Organization)](Organization-988101000016008.md)
* [Lægerne Søndergaard og Pedersen I/S (991711000016002) (Organization)](Organization-991711000016002.md)
* [Lægerne Kirstinelund (991721000016006) (Organization)](Organization-991721000016006.md)
* [Tine Søndergaard (991731000016008) (Organization)](Organization-991731000016008.md)
* [Stine Bundgaard Pedersen (991741000016001) (Organization)](Organization-991741000016001.md)
* [Lægerne Warrer og Isaksen (992681000016005) (Organization)](Organization-992681000016005.md)
* [Inge Bitsch Isaksen (992691000016007) (Organization)](Organization-992691000016007.md)
* [Anne Birgitte Warrer (992711000016009) (Organization)](Organization-992711000016009.md)
* [I/S Lægerne Gyldenløvesgade (994581000016004) (Organization)](Organization-994581000016004.md)
* [Lægerne Gyldenløvesgade (994611000016008) (Organization)](Organization-994611000016008.md)
* [Morten Steen Hansen (994631000016002) (Organization)](Organization-994631000016002.md)
* [Birgit Morre Pedersen (994641000016009) (Organization)](Organization-994641000016009.md)
* [Annette Lundgaard (994651000016007) (Organization)](Organization-994651000016007.md)
* [Isabel Zanjani (994871000016004) (Organization)](Organization-994871000016004.md)
* [Lægerne Stjernepladsen I/S (Organization)](Organization-LaegerneStjernepladsen.8200.AarhusN.698131000016001.md)
* [Lægerne Stjernepladsen I/S (Organization)](Organization-LaegerneStjernepladsen.8200.AarhusN.698141000016008.md)
* [Tine Nørregaard Nielsen (Organization)](Organization-LaegerneStjernepladsen.8200.AarhusN.698161000016009.md)
