# DigitalSundhedDanmark-EerEndpoint-EMR-PROD - DK EHMI Endpoint Register (EER) - Configurations v1.0.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DigitalSundhedDanmark-EerEndpoint-EMR-PROD**

## Example Endpoint: DigitalSundhedDanmark-EerEndpoint-EMR-PROD

Profile: [EER Endpoint - General for Messaging](https://build.fhir.org/ig/medcomdk/dk-ehmi-eer/StructureDefinition-eer.dk.endpoint.messaging.html)

**EER System Extension - MSH**: [Device: identifier = NSP-EMR-MSH-prod-PROD; status = active; manufacturer = KvalitetsIT; type = Message Service Handler](Device-NSP-EMR-MSH-prod-PROD.md)

**EER System Extension - AP**: [Device: identifier = EMR-AP-prod-PROD; status = active; manufacturer = KvalitetsIT; type = eDelivery Access Point](Device-EMR-AP-prod-PROD.md)

**identifier**: `https://www.gs1.org/gln`/5790002515804

**status**: Active

**connectionType**: [EHMI Endpoint Register (EER) - Connection Types CS: EerMessagingEdelivery](https://build.fhir.org/ig/medcomdk/dk-ehmi-terminology/CodeSystem-eer-endpoint-connection-type.html#eer-endpoint-connection-type-EerMessagingEdelivery) (EHMI messaging via eDelivery)

**name**: DigitalSundhedDanmark-EerEndpoint-EMR-PROD

**managingOrganization**: [Organization DigitalSundhedDanmark-EMR (1134981000016000) (SI)](Organization-1134981000016000.md)

**period**: 2026-01-01 --> (ongoing)

**payloadType**: HomeCareObservation 1.1

**payloadMimeType**: text/xml, application/fhir+xml, application/fhir+json

**address**: [http://www.dsd-dds.dk/dds-prod](http://www.dsd-dds.dk/dds-prod)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "5790002515804",
  "meta" : {
    "profile" : [
      "http://medcomehmi.dk/ig/eer/StructureDefinition/eer.dk.endpoint.messaging"
    ]
  },
  "extension" : [
    {
      "url" : "http://medcomehmi.dk/ig/eer/StructureDefinition/eer-dk-msh-system-extension",
      "valueReference" : {
        "reference" : "Device/NSP-EMR-MSH-prod-PROD",
        "type" : "Device",
        "identifier" : {
          "value" : "NSP-EMR-MSH-prod-PROD"
        }
      }
    },
    {
      "url" : "http://medcomehmi.dk/ig/eer/StructureDefinition/eer-dk-ap-system-extension",
      "valueReference" : {
        "reference" : "Device/EMR-AP-prod-PROD",
        "type" : "Device",
        "identifier" : {
          "value" : "EMR-AP-prod-PROD"
        }
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://www.gs1.org/gln",
      "value" : "5790002515804"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-endpoint-connection-type",
    "code" : "EerMessagingEdelivery"
  },
  "name" : "DigitalSundhedDanmark-EerEndpoint-EMR-PROD",
  "managingOrganization" : {
    "reference" : "Organization/1134981000016000"
  },
  "period" : {
    "start" : "2026-01-01"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition:homecareobservation:1.1"
        }
      ]
    }
  ],
  "payloadMimeType" : ["text/xml", "application/fhir+xml", "application/fhir+json"],
  "address" : "http://www.dsd-dds.dk/dds-prod"
}

```
