# 5790002401428 - DK EHMI Endpoint Register (EER) - Configurations v1.0.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **5790002401428**

## Example Endpoint: 5790002401428

Profile: [EER Endpoint - General for Messaging](https://build.fhir.org/ig/medcomdk/dk-ehmi-eer/StructureDefinition-eer.dk.endpoint.messaging.html)

**EER System Extension - MSH**: [Device: identifier = MultiMedMSH-prod-LPS; status = active; manufacturer = Datagruppen MultiMed A/S; type = Message Service Handler](Device-MultiMedMSH-prod-LPS.md)

**EER System Extension - AP**: [Device: identifier = MultiMedAP-prod-LPS; status = active; manufacturer = Datagruppen MultiMed A/S; type = eDelivery Access Point](Device-MultiMedAP-prod-LPS.md)

**identifier**: GLN/5790002401428

**status**: Active

**connectionType**: [EHMI Endpoint Register (EER) - Connection Types CS: EerMessagingEdelivery](https://build.fhir.org/ig/medcomdk/dk-ehmi-terminology/CodeSystem-eer-endpoint-connection-type.html#eer-endpoint-connection-type-EerMessagingEdelivery) (EHMI messaging via eDelivery)

**name**: EER Messaging Endpoint - LægerneStjernepladsenI/S.8200.AarhusN.698131000016001 FHIR Endpoint

**managingOrganization**: [Organization Lægerne Stjernepladsen I/S (698131000016001)](Organization-698131000016001.md)

**period**: 2018-09-21 00:00:00+0200 --> (ongoing)

**payloadType**: HomeCareObservation 1.0, Acknowledgement 2.0, SBDH Ack 1.0

**payloadMimeType**: text/xml, application/fhir+xml, application/fhir+json

**address**: [https://example.org/fhir](https://example.org/fhir)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "5790002401428",
  "meta" : {
    "profile" : [
      "http://medcomehmi.dk/ig/eer/StructureDefinition/eer.dk.endpoint.messaging"
    ]
  },
  "extension" : [
    {
      "url" : "http://medcomehmi.dk/ig/eer/StructureDefinition/eer-dk-msh-system-extension",
      "valueReference" : {
        "reference" : "Device/MultiMedMSH-prod-LPS",
        "type" : "Device",
        "identifier" : {
          "value" : "MultiMedMSH-prod-LPS"
        }
      }
    },
    {
      "url" : "http://medcomehmi.dk/ig/eer/StructureDefinition/eer-dk-ap-system-extension",
      "valueReference" : {
        "reference" : "Device/MultiMedAP-prod-LPS",
        "type" : "Device",
        "identifier" : {
          "value" : "MultiMedAP-prod-LPS"
        }
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-delivery-status-agent-who-identifier-types",
            "code" : "GLN"
          }
        ]
      },
      "system" : "https://www.gs1.org/gln",
      "value" : "5790002401428"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-endpoint-connection-type",
    "code" : "EerMessagingEdelivery"
  },
  "name" : "EER Messaging Endpoint - LægerneStjernepladsenI/S.8200.AarhusN.698131000016001 FHIR Endpoint",
  "managingOrganization" : {
    "reference" : "Organization/698131000016001",
    "type" : "Organization",
    "identifier" : {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-sor-organization-identier-type",
            "code" : "SORID",
            "display" : "SOR Identifier"
          }
        ]
      },
      "system" : "urn:oid:1.2.208.176.1.1",
      "value" : "698131000016001"
    }
  },
  "period" : {
    "start" : "2018-09-21T00:00:00+02:00"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition:homecareobservation:1.0"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition:acknowledgement:2.0"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:ehmi:messaging:envelope:xml:sbdhacknowledgement:1.0"
        }
      ]
    }
  ],
  "payloadMimeType" : ["text/xml", "application/fhir+xml", "application/fhir+json"],
  "address" : "https://example.org/fhir"
}

```
