# 5790000137060 - DK EHMI Endpoint Register (EER) - Configurations v1.0.0-draft

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **5790000137060**

## Example Endpoint: 5790000137060

Profile: [EER Endpoint - General for Messaging](https://build.fhir.org/ig/medcomdk/dk-ehmi-eer/StructureDefinition-eer.dk.endpoint.messaging.html)

**identifier**: GLN/5790000137060

**status**: Suspended

**connectionType**: [EHMI Endpoint Register (EER) - Connection Types CS: EerMessagingEdelivery](https://build.fhir.org/ig/medcomdk/dk-ehmi-terminology/CodeSystem-eer-endpoint-connection-type.html#eer-endpoint-connection-type-EerMessagingEdelivery) (EHMI messaging via eDelivery)

**name**: EER Messaging Endpoint - SkådeLægehusI/S.8270.Højbjerg.20171000016003 FHIR Endpoint

**managingOrganization**: [Organization Skåde Lægehus I/S (20171000016003)](Organization-20171000016003.md)

**period**: 2018-09-21 00:00:00+0200 --> (ongoing)

**payloadType**: HomeCareObservation 1.1, Acknowledgement 2.0

**payloadMimeType**: text/xml, application/fhir+xml, application/fhir+json

**address**: [https://example.org/fhir](https://example.org/fhir)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "5790000137060",
  "meta" : {
    "profile" : [
      "http://medcomehmi.dk/ig/eer/StructureDefinition/eer.dk.endpoint.messaging"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-delivery-status-agent-who-identifier-types",
            "code" : "GLN"
          }
        ]
      },
      "system" : "https://www.gs1.org/gln",
      "value" : "5790000137060"
    }
  ],
  "status" : "suspended",
  "connectionType" : {
    "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-endpoint-connection-type",
    "code" : "EerMessagingEdelivery"
  },
  "name" : "EER Messaging Endpoint - SkådeLægehusI/S.8270.Højbjerg.20171000016003 FHIR Endpoint",
  "managingOrganization" : {
    "reference" : "Organization/20171000016003",
    "type" : "Organization",
    "identifier" : {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/eer-sor-organization-identier-type",
            "code" : "SORID",
            "display" : "SOR Identifier"
          }
        ]
      },
      "system" : "urn:oid:1.2.208.176.1.1",
      "value" : "20171000016003"
    }
  },
  "period" : {
    "start" : "2018-09-21T00:00:00+02:00"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition:homecareobservation:1.1"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://medcomehmi.dk/ig/terminology/CodeSystem/ehmi-message-definition-uri",
          "code" : "urn:dk:healthcare:medcom:messaging:fhir:structuredefinition:acknowledgement:2.0"
        }
      ]
    }
  ],
  "payloadMimeType" : ["text/xml", "application/fhir+xml", "application/fhir+json"],
  "address" : "https://example.org/fhir"
}

```
