# Catalog of Use Cases - SMART Permission Tickets v0.1.0

* [**Table of Contents**](toc.md)
* **Catalog of Use Cases**

## Catalog of Use Cases

## Detailed Use Case Catalog

Here are seven scenarios demonstrating how FHIR resources are used to model diverse authorization needs.

### Use Case 1: Network-Mediated Patient Access

**A patient uses a high-assurance Digital ID wallet to authorize an app to fetch their data from multiple hospitals.**

* **Subject:** The Patient (Matched by Demographics).
* **Actor:** (Implicitly the App/Patient).
* **Constraint:** Granular scope (Immunizations only).

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://trust-broker.org",
  "sub": "https://client-app.example.com/123",
  "aud": "https://network.org",
  "ticket_context": {
    "subject": {
      "type": "match",
      "traits": {
        "resourceType": "Patient",
        "name": [
          {
            "family": "Smith",
            "given": [
              "John"
            ]
          }
        ],
        "birthDate": "1980-01-01"
      }
    },
    "capability": {
      "scopes": [
        "patient/Immunization.read",
        "patient/AllergyIntolerance.read"
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

### Use Case 2: Authorized Representative (Proxy)

**An adult daughter accesses her elderly mother's records. The relationship is verified by a Trust Broker, not the Hospital.**

* **Subject:** The Mother (`Patient`).
* **Actor:** The Daughter (`RelatedPerson`).

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://trust-broker.org",
  "sub": "https://client-app.example.com/456",
  "aud": "https://network.org",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "identifier": [
        {
          "system": "https://national-mpi.net",
          "value": "pt-555"
        }
      ]
    },
    "actor": {
      "resourceType": "RelatedPerson",
      "name": [
        {
          "family": "Doe",
          "given": [
            "Jane"
          ]
        }
      ],
      "telecom": [
        {
          "system": "email",
          "value": "jane.doe@example.com"
        }
      ],
      "relationship": [
        {
          "coding": [
            {
              "system": "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code": "DAU",
              "display": "Daughter"
            }
          ]
        }
      ]
    },
    "capability": {
      "scopes": [
        "patient/*.read",
        "patient/*.search"
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

### Use Case 3: Public Health Investigation

**A Hospital creates a Case Report. The Public Health Agency (PHA) uses the report as a ticket to query for follow-up data.**

* **Subject:** The Patient.
* **Actor:** The Public Health Agency (`Organization`).
* **Context:** The specific Case ID.

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://hospital-a.com",
  "sub": "https://pha.gov/apps/report-client",
  "aud": "https://hospital-a.com",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "id": "local-patient-123"
    },
    "actor": {
      "resourceType": "Organization",
      "name": "State Dept of Health",
      "identifier": [
        {
          "system": "urn:ietf:rfc:3986",
          "value": "https://doh.state.gov"
        }
      ],
      "type": [
        {
          "coding": [
            {
              "system": "http://terminology.hl7.org/CodeSystem/organization-type",
              "code": "govt"
            }
          ]
        }
      ]
    },
    "context": {
      "type": {
        "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code": "PUBHLTH",
        "display": "Public Health"
      },
      "focus": {
        "system": "http://snomed.info/sct",
        "code": "56717001",
        "display": "Tuberculosis"
      },
      "identifier": [
        {
          "system": "https://doh.wa.gov/cases",
          "value": "CASE-2024-999"
        }
      ]
    },
    "capability": {
      "scopes": [
        "patient/*.read"
      ],
      "periods": [
        {
          "start": "2025-01-01",
          "end": "2026-01-01"
        }
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

### Use Case 4: Social Care (CBO) Referral

**A transactional/ad-hoc user. A Food Bank volunteer needs to update a referral status. She does not have an NPI or a user account.**

* **Subject:** The Patient.
* **Actor:** A Volunteer (`PractitionerRole`) with identity embedded via **FHIR`contained`**.

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://referring-ehr.org",
  "sub": "https://foodbank.org/apps/intake",
  "aud": "https://referring-ehr.org",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "reference": "Patient/123"
    },
    "actor": {
      "resourceType": "PractitionerRole",
      "contained": [
        {
          "resourceType": "Practitioner",
          "id": "p1",
          "name": [
            {
              "family": "Volunteer",
              "given": [
                "Alice"
              ]
            }
          ],
          "telecom": [
            {
              "system": "email",
              "value": "alice@foodbank.org"
            }
          ]
        },
        {
          "resourceType": "Organization",
          "id": "o1",
          "name": "Downtown Food Bank"
        }
      ],
      "practitioner": {
        "reference": "#p1"
      },
      "organization": {
        "reference": "#o1"
      }
    },
    "context": {
      "type": {
        "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code": "REFER",
        "display": "Referral"
      },
      "focus": {
        "system": "http://snomed.info/sct",
        "code": "733423003",
        "display": "Food insecurity"
      }
    },
    "capability": {
      "scopes": [
        "patient/ServiceRequest.read",
        "patient/ServiceRequest.write",
        "patient/Task.read",
        "patient/Task.write"
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

### Use Case 5: Payer Claims Adjudication

**A Payer requests clinical documents to support a specific claim.**

* **Actor:** The Payer (`Organization`).
* **Context:** The Claim ID.

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://provider.com",
  "sub": "https://payer.com/apps/claims-processor",
  "aud": "https://provider.com",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "reference": "Patient/456"
    },
    "actor": {
      "resourceType": "Organization",
      "identifier": [
        {
          "system": "http://hl7.org/fhir/sid/us-npi",
          "value": "9876543210"
        }
      ],
      "name": "Blue Payer Inc"
    },
    "context": {
      "type": {
        "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code": "CLMATTCH",
        "display": "Claim Attachment"
      },
      "focus": {
        "system": "http://snomed.info/sct",
        "code": "80146002",
        "display": "Appendectomy"
      }
    },
    "capability": {
      "scopes": [
        "patient/DocumentReference.read",
        "patient/Procedure.read"
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

### Use Case 6: Research Study

**A patient consents to a study. The ticket proves consent exists without requiring the researcher to be a "user" at the hospital.**

* **Actor:** The Research Institute (`Organization`).
* **Context:** Research Study + Consent Evidence.

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://consent-platform.org",
  "sub": "https://research.org/studies/lung-cancer/app",
  "aud": "https://hospital.com",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "identifier": [
        {
          "value": "MRN-123"
        }
      ]
    },
    "actor": {
      "resourceType": "Organization",
      "name": "Oncology Research Institute",
      "identifier": [
        {
          "value": "research-org-id"
        }
      ]
    },
    "context": {
      "type": {
        "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code": "RESCH",
        "display": "Biomedical Research"
      },
      "focus": {
        "system": "http://snomed.info/sct",
        "code": "363358000",
        "display": "Malignant tumor of lung"
      }
    },
    "capability": {
      "scopes": [
        "patient/*.read"
      ],
      "periods": [
        {
          "start": "2020-01-01",
          "end": "2025-01-01"
        }
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

### Use Case 7: Provider-to-Provider Consult

**A Specialist (Practitioner) requests data from a Referring Provider.**

* **Actor:** The Specialist (`Practitioner`).

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://referring-ehr.org",
  "sub": "https://specialist-clinic.org/apps/referral-viewer",
  "aud": "https://referring-ehr.org",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "reference": "Patient/999"
    },
    "actor": {
      "resourceType": "Practitioner",
      "identifier": [
        {
          "system": "http://hl7.org/fhir/sid/us-npi",
          "value": "1112223333"
        }
      ],
      "name": [
        {
          "family": "Heart",
          "given": [
            "A."
          ]
        }
      ]
    },
    "context": {
      "type": {
        "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code": "REFER",
        "display": "Referral"
      },
      "focus": {
        "system": "http://snomed.info/sct",
        "code": "49436004",
        "display": "Atrial fibrillation"
      }
    },
    "capability": {
      "scopes": [
        "patient/*.read"
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

