# Permission Ticket Architecture - SMART Permission Tickets v0.1.0

* [**Table of Contents**](toc.md)
* **Permission Ticket Architecture**

## Permission Ticket Architecture

| | |
| :--- | :--- |
| *Official URL*:http://smarthealthit.org/ig/permission-tickets/ImplementationGuide/smart.permission-tickets | *Version*:0.1.0 |
| Draft as of 2025-11-20 | *Computable Name*:SmartPermissionTickets |

**Enabling Granular, Context-Aware Authorization in Health Networks**

### Executive Summary

Current interoperability standards and frameworks (SMART on FHIR, TEFCA) face a "granularity gap." Authorization flows effectively force a choice between two extremes:

1. **User-Centric friction:**Relying on patients to manually log in to**N**different portals to authorize a single app.
1. **System-Centric rigidity:**Relying on backend configurations where trusted nodes get broad, "super-user" access because defining granular rules per-patient is administratively impossible.

**Permission Tickets** solve this by introducing a **Capability-Based Access Control** model to OAuth. Instead of the Data Holder asking, "Who are you and what is your pre-configured role?", it asks, "What proof do you hold that authorizes this specific request?"

A Permission Ticket is a portable, cryptographically signed artifact. It uses standard **FHIR Resources** as data models to describe the **Subject** (Patient), the **Actor** (Requesting Agent), and the **Context** (Trigger Event), enabling precise access control without requiring realtime user interaction at the data source.

-------

### Problem Space

#### "N Portals" Bottleneck (Consumer Access)

In standard SMART flows, if a patient wants to aggregate their data from five different hospitals into a personal health app, they must locate five different portals, remember five usernames/passwords, and click "Approve" five times. This friction destroys adoption. Furthermore, the scopes are coarse; a user can usually only say "Yes" to everything or "No" to everything.

#### "All-or-Nothing" Network (Backend Services)

In B2B flows (like TEFCA Treatment or Payer exchange), Client Apps authenticate via certificates. Because it is too hard to configure specific permissions for every patient and every external partner, Data Holders often default to binary trust: if the partner is a "Trusted Node," they get access to the firehose. This is unacceptable for sensitive use cases like Research, Public Health, or Social Care.

-------

### Solution: Permission Tickets

A **Permission Ticket** is a JWT minted by a Trusted Issuer. It acts as a self-contained authorization grant.

#### Core Principles

1. **Issuer-Signed:**The ticket is minted by an entity the Data Holder trusts (e.g., a Trust Broker, an Identity Verifier, or the Data Holder itself).
1. **Client-Bound:**The ticket is cryptographically bound to the Client ID of the requesting application.
1. **FHIR-Native:**The payload uses strict FHIR Resource structures (`Patient`,`PractitionerRole`,`Organization`) to define identities, making integration with existing EHR logic seamless.
1. **Zero-Interaction:**The Data Holder validates the ticket signature and grants access immediately. No user login page is presented.

#### Authorization Flow

```
sequenceDiagram
    participant Trigger as Trigger Event
    participant Issuer as Trusted Issuer
    participant Client as Client App
    participant Server as Data Holder (FHIR)

    Note over Trigger, Client: 1. Context Established
    Trigger->>Issuer: Event (e.g. Referral, Case Report)
    Issuer->>Issuer: Verify Context & Identity
    Issuer->>Client: Mint Permission Ticket (JWT)
    
    Note over Client, Server: 2. Redemption
    Client->>Client: Generate Client Assertion (JWT)
    Client->>Client: Embed Ticket in Assertion
    Client->>Server: POST /token (client_credentials + assertion)
    
    Note over Server: 3. Validation
    Server->>Server: Verify Client Signature
    Server->>Server: Verify Ticket Signature (Issuer Trust)
    Server->>Server: Enforce Ticket Constraints
    Server-->>Client: Access Token (Down-scoped)
    
    Note over Client, Server: 4. Access
    Client->>Server: GET /Patient/123/Immunization
    Server-->>Client: FHIR Resources

```

-------

### Technical Specification

#### Transport: SMART Backend Services Profile

This architecture is a strict profile of **[SMART Backend Services](https://build.fhir.org/ig/HL7/smart-app-launch/backend-services.html)** (which itself profiles **RFC 7523**).

The key difference is the payload of the `client_assertion`. In standard SMART Backend Services, the assertion proves the client's identity. In this architecture, the assertion **also carries the Permission Tickets** as an extension claim.

##### Trust* Automatic Registration: Clients can be automatically registered using OpenID Federation 1.0. The client includes a trust_chain in the header of its client_assertion, allowing the Authorization Server to verify the client's metadata and trust status dynamically.

* **Client IDs** MUST be **URL Entity Identifiers** (e.g., `https://app.example.com`).
* Clients SHOULD include a `trust_chain` in their assertion. This allows Data Holders to verify the client's legitimacy via a common Trust Anchor without requiring manual pre-registration of every client.

**The Request:**

```
POST /token HTTP/1.1
Host: fhir.hospital.com
Content-Type: application/x-www-form-urlencoded

grant_type=client_credentials
&client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer
&client_assertion=eyJhbGciOiJ... (Signed JWT containing tickets and trust_chain)
&scope=system/Patient.r

```

##### Full Client Assertion Example

Here is what the `client_assertion` looks like when decoded. Note the `trust_chain` for automatic registration and the embedded `ticket_context`.

#### Client Assertion 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8",
  "trust_chain": [
    "eyJhbGciOiJFUzI1NiIs... (Signed Entity Statement for Client)",
    "eyJhbGciOiJFUzI1NiIs... (Signed Entity Statement for Intermediate)",
    "eyJhbGciOiJFUzI1NiIs... (Signed Entity Statement for Trust Anchor)"
  ]
}
```

##### Payload (Claims)

```
{
  "iss": "https://app.client.id",
  "sub": "https://app.client.id",
  "aud": "https://network.org/token",
  "jti": "assertion-jti-123",
  "iat": 1763678603,
  "exp": 1763678903,
  "https://smarthealthit.org/permission_tickets": [
    "eyJhbGciOiJFUzI1NiIsImtpZCI6Im52T0dSQ3NUejJRSVFMc2JsMFpRX3V4MHRmeWg1aWF2ZS1qdk5zQU5XdjgifQ.eyJpc3MiOiJodHRwczovL3RydXN0LWJyb2tlci5vcmciLCJzdWIiOiJodHRwczovL2FwcC5jbGllbnQuaWQiLCJhdWQiOiJodHRwczovL25ldHdvcmsub3JnIiwidGlja2V0X2NvbnRleHQiOnsic3ViamVjdCI6eyJyZXNvdXJjZVR5cGUiOiJQYXRpZW50IiwiaWQiOiIxMjMifSwiY2FwYWJpbGl0eSI6eyJzY29wZXMiOlsicGF0aWVudC8qLnJlYWQiXX19LCJpYXQiOjE3NjM2Nzg2MDMsImV4cCI6MTc2MzY4MjIwM30.AtaAYlKjgHyhKSdkusMBrGKfmsVUDABL7yj3Vm_ihZsFpDho8DM6XqzuTrx8pnM9K9ybbAwIL4Bh6NPK4SXXPg"
  ]
}
```

#### Artifact: Ticket Structure

The ticket payload is a JWT. It wraps standard FHIR JSON objects within a `ticket_context` claim.

```
{
  "iss": "https://trust-broker.org",  // Who vouches for this?
  "sub": "https://app.client.id",     // Which App can use this?
  "aud": "https://network.org",       // Where is it valid?
  "exp": 1710000000,
  
  "ticket_context": {
    // WHO is the data about? (Uses FHIR Patient shape)
    "subject": { "resourceType": "Patient", ... },

    // WHO is requesting it? (Uses FHIR Practitioner/Role/Org shapes)
    // Optional: If missing, implies the App Client is the sole actor.
    "actor": { "resourceType": "PractitionerRole", ... },

    // WHY is this allowed? (Trigger Context)
    "context": { 
      "type": { "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason", "code": "REFER" },
      "focus": { "system": "http://snomed.info/sct", "code": "49436004", "display": "Atrial fibrillation" },
      
      // Optional: Issuer-specific identifiers (e.g., Case ID, Referral ID)
      // Can be used for internal tracking or opaque tokens for the issuing server.
      "identifier": [
        { "system": "https://issuer.org/cases", "value": "CASE-123" }
      ]
    },

    // WHAT data is allowed?
    "capability": { "resources": [] }
  }
}

```

### Downloads

* **[Full Specification (PDF)](full-ig.pdf)**
* **[Source Code & Examples (ZIP)](source-code.zip)**: Includes TypeScript scripts for key generation, ticket signing, and example generation.
* **[Permission Ticket Logical Model](StructureDefinition-permission-ticket.md)** for formal definitions.

#### Server-Side Validation

The Data Holder must perform a two-layer validation:

1. **Layer 1: Client Authentication (Standard SMART)**
* Verify the `client_assertion` signature using the Client's registered public key (JWK).
* Ensure the client is registered and active.

1. **Layer 2: Ticket Validation (Permission Ticket Specific)**
* Extract the `https://smarthealthit.org/extension_tickets` array from the assertion.
* For each ticket: 
* **Verify Signature:** Use the `iss` (Trust Broker) public key.
* **Verify Trust:** Is this `iss` in the Data Holder's trusted list?
* **Verify Binding:** Does `ticket.sub` match `assertion.sub` (Client ID)?
 
* **Grant Access:** If valid, grant the requested scopes **constrained** by the ticket's `capability` rules.

-------

### Developer Documentation

This section provides technical details for developers implementing the Permission Ticket Architecture, including strict schema definitions, signing algorithms, and validation logic.

#### TypeScript Interfaces

The following TypeScript interfaces define the structure of the Permission Ticket and the Client Assertion. These can be used for strict type checking in your implementation.

```typescript export interface PermissionTicket { iss: string; // Issuer URL (Trust Broker) sub: string; // Client ID (App) aud: string; // Audience (Network/Data Holder) exp?: number; // Expiration Timestamp jti?: string; // Unique Ticket ID ticket_context: { subject: { type?: "match" | "reference"; resourceType?: string; id?: string; identifier?: any[]; traits?: { resourceType: "Patient"; name?: { family?: string; given?: string[] }[]; birthDate?: string; identifier?: any[]; [key: string]: any; }; reference?: string; [key: string]: any; }; actor?: { resourceType: "PractitionerRole" | "RelatedPerson" | "Organization" | "Practitioner"; name?: any; identifier?: any[]; telecom?: any[]; type?: any[]; relationship?: any[]; contained?: any[]; practitioner?: { reference: string }; organization?: { reference: string }; [key: string]: any; }; context?: { type: { system?: string; code?: string; display?: string; }; focus?: { system?: string; code?: string; display?: string; }; identifier?: any[]; }; capability: { scopes?: string[]; periods?: { start?: string; end?: string; }[]; locations?: any[]; // FHIR Address organizations?: any[]; // FHIR Organization }; }; }

export interface ClientAssertion { iss: string; // Client ID (URL) sub: string; // Client ID (URL) aud: string; // Token Endpoint URL jti: string; // Unique ID iat: number; // Issued At exp: number; // Expiration

// The Permission Ticket(s) "https://smarthealthit.org/permission_tickets": string[]; }

#### Signing and Validation

##### Signing Algorithm

* **Algorithm:** ES256 (ECDSA using P-256 and SHA-256) is RECOMMENDED. RS256 is also supported.
* **Header:** Must include `alg` and `kid` (Key ID) to facilitate key rotation.
* **Keys:** 
* **Issuer:** Signs the `PermissionTicket`. Public keys must be exposed via a JWK Set URL (e.g., `https://trust-broker.org/.well-known/jwks.json`).
* **Client:** Signs the `ClientAssertion`. Public keys must be registered with the Data Holder or exposed via JWKS.
 

##### Server-Side Validation Steps

When a Data Holder receives a token request with a `client_assertion`, it must perform the following checks:

1. **Validate Client Assertion:**
* Verify the signature using the Client's public key.
* Check `iss` == `sub` == Client ID.
* Check `aud` matches the Token Endpoint URL.
* Check `exp` is in the future.

1. **Extract Tickets:**
* Parse the `https://smarthealthit.org/extension_tickets` array.

1. **Validate Each Ticket:**
* **Signature:** Verify the signature using the Issuer's public key (fetched from `iss` JWKS).
* **Trust:** Verify the `iss` is a trusted Trust Broker.
* **Binding:** Verify `sub` matches the Client ID from the Client Assertion.
* **Expiration:** Check `exp` is in the future.

1. **Enforce Permissions:**
* Map `ticket_context.capability` to OAuth Scopes.
* Log `ticket_context.actor` and `ticket_context.context` for audit purposes.
* Issue an Access Token with the calculated scopes.

-------

### Catalog of Use Cases

Here are seven scenarios demonstrating how FHIR resources are used to model diverse authorization needs.

#### Use Case 1: Network-Mediated Patient Access

**A patient uses a high-assurance Digital ID wallet to authorize an app to fetch their data from multiple hospitals.**

##### Ticket Schema

* **Subject:** `Patient` (Matched by Demographics: Name, DOB, Identifier).
* **Actor:** None (Implicitly the App/Patient).
* **Context:** None.
* **Capability:** `mode` = `read`, `resources` = `Immunization`, `AllergyIntolerance`.

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://trust-broker.org",
  "sub": "https://client-app.example.com/123",
  "aud": "https://network.org",
  "ticket_context": {
    "subject": {
      "type": "match",
      "traits": {
        "resourceType": "Patient",
        "name": [
          {
            "family": "Smith",
            "given": [
              "John"
            ]
          }
        ],
        "birthDate": "1980-01-01"
      }
    },
    "capability": {
      "scopes": [
        "patient/Immunization.read",
        "patient/AllergyIntolerance.read"
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

#### Use Case 2: Authorized Representative (Proxy)

**An adult daughter accesses her elderly mother's records. The relationship is verified by a Trust Broker, not the Hospital.**

##### Ticket Schema

* **Subject:** `Patient` (Matched by Identifier).
* **Actor:** `RelatedPerson` (Name, Telecom, Relationship Code).
* **Context:** None.
* **Capability:** `mode` = `read`, `search` (Full Access).

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://trust-broker.org",
  "sub": "https://client-app.example.com/456",
  "aud": "https://network.org",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "identifier": [
        {
          "system": "https://national-mpi.net",
          "value": "pt-555"
        }
      ]
    },
    "actor": {
      "resourceType": "RelatedPerson",
      "name": [
        {
          "family": "Doe",
          "given": [
            "Jane"
          ]
        }
      ],
      "telecom": [
        {
          "system": "email",
          "value": "jane.doe@example.com"
        }
      ],
      "relationship": [
        {
          "coding": [
            {
              "system": "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code": "DAU",
              "display": "Daughter"
            }
          ]
        }
      ]
    },
    "capability": {
      "scopes": [
        "patient/*.read",
        "patient/*.search"
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

#### Use Case 3: Public Health Investigation

**A Hospital creates a Case Report. The Public Health Agency (PHA) uses the report as a ticket to query for follow-up data.**

##### Ticket Schema

* **Subject:** `Patient` (Matched by Hospital ID).
* **Actor:** `Organization` (Name, Identifier, Type).
* **Context:** `type` = `PUBHLTH` (Public Health), `focus` = `Tuberculosis` (SCT 56717001), `identifier` = Case ID.
* **Capability:** `scopes` = `patient/*.read`, `periods` (Start Date).

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://hospital-a.com",
  "sub": "https://pha.gov/apps/report-client",
  "aud": "https://hospital-a.com",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "id": "local-patient-123"
    },
    "actor": {
      "resourceType": "Organization",
      "name": "State Dept of Health",
      "identifier": [
        {
          "system": "urn:ietf:rfc:3986",
          "value": "https://doh.state.gov"
        }
      ],
      "type": [
        {
          "coding": [
            {
              "system": "http://terminology.hl7.org/CodeSystem/organization-type",
              "code": "govt"
            }
          ]
        }
      ]
    },
    "context": {
      "type": {
        "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code": "PUBHLTH",
        "display": "Public Health"
      },
      "focus": {
        "system": "http://snomed.info/sct",
        "code": "56717001",
        "display": "Tuberculosis"
      },
      "identifier": [
        {
          "system": "https://doh.wa.gov/cases",
          "value": "CASE-2024-999"
        }
      ]
    },
    "capability": {
      "scopes": [
        "patient/*.read"
      ],
      "periods": [
        {
          "start": "2025-01-01",
          "end": "2026-01-01"
        }
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

#### Use Case 4: Social Care (CBO) Referral

**A transactional/ad-hoc user. A Food Bank volunteer needs to update a referral status. She does not have an NPI or a user account.**

##### Ticket Schema

* **Subject:** `Patient` (Reference).
* **Actor:** `PractitionerRole` (Contained `Practitioner` + `Organization`).
* **Context:** `type` = `REFER` (Referral), `focus` = `Food insecurity` (SCT 733423003).
* **Capability:** `scopes` = `patient/ServiceRequest.read`, `patient/ServiceRequest.write`, `patient/Task.read`, `patient/Task.write`.

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://referring-ehr.org",
  "sub": "https://foodbank.org/apps/intake",
  "aud": "https://referring-ehr.org",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "reference": "Patient/123"
    },
    "actor": {
      "resourceType": "PractitionerRole",
      "contained": [
        {
          "resourceType": "Practitioner",
          "id": "p1",
          "name": [
            {
              "family": "Volunteer",
              "given": [
                "Alice"
              ]
            }
          ],
          "telecom": [
            {
              "system": "email",
              "value": "alice@foodbank.org"
            }
          ]
        },
        {
          "resourceType": "Organization",
          "id": "o1",
          "name": "Downtown Food Bank"
        }
      ],
      "practitioner": {
        "reference": "#p1"
      },
      "organization": {
        "reference": "#o1"
      }
    },
    "context": {
      "type": {
        "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code": "REFER",
        "display": "Referral"
      },
      "focus": {
        "system": "http://snomed.info/sct",
        "code": "733423003",
        "display": "Food insecurity"
      }
    },
    "capability": {
      "scopes": [
        "patient/ServiceRequest.read",
        "patient/ServiceRequest.write",
        "patient/Task.read",
        "patient/Task.write"
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

#### Use Case 5: Payer Claims Adjudication

**A Payer requests clinical documents to support a specific claim.**

##### Ticket Schema

* **Subject:** `Patient` (Reference).
* **Actor:** `Organization` (Payer NPI).
* **Context:** `type` = `CLMATTCH` (Claim Attachment), `focus` = `Appendectomy` (SCT 80146002).
* **Capability:** `scopes` = `patient/DocumentReference.read`, `patient/Procedure.read`.

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://provider.com",
  "sub": "https://payer.com/apps/claims-processor",
  "aud": "https://provider.com",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "reference": "Patient/456"
    },
    "actor": {
      "resourceType": "Organization",
      "identifier": [
        {
          "system": "http://hl7.org/fhir/sid/us-npi",
          "value": "9876543210"
        }
      ],
      "name": "Blue Payer Inc"
    },
    "context": {
      "type": {
        "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code": "CLMATTCH",
        "display": "Claim Attachment"
      },
      "focus": {
        "system": "http://snomed.info/sct",
        "code": "80146002",
        "display": "Appendectomy"
      }
    },
    "capability": {
      "scopes": [
        "patient/DocumentReference.read",
        "patient/Procedure.read"
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

#### Use Case 6: Research Study

**A patient consents to a study. The ticket proves consent exists without requiring the researcher to be a "user" at the hospital.**

##### Ticket Schema

* **Subject:** `Patient` (MRN).
* **Actor:** `Organization` (Research Institute ID).
* **Context:** `type` = `RESCH` (Biomedical Research), `focus` = `Malignant tumor of lung` (SCT 363358000).
* **Capability:** `scopes` = `patient/*.read`, `periods` (Start/End Date).

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://consent-platform.org",
  "sub": "https://research.org/studies/lung-cancer/app",
  "aud": "https://hospital.com",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "identifier": [
        {
          "value": "MRN-123"
        }
      ]
    },
    "actor": {
      "resourceType": "Organization",
      "name": "Oncology Research Institute",
      "identifier": [
        {
          "value": "research-org-id"
        }
      ]
    },
    "context": {
      "type": {
        "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code": "RESCH",
        "display": "Biomedical Research"
      },
      "focus": {
        "system": "http://snomed.info/sct",
        "code": "363358000",
        "display": "Malignant tumor of lung"
      }
    },
    "capability": {
      "scopes": [
        "patient/*.read"
      ],
      "periods": [
        {
          "start": "2020-01-01",
          "end": "2025-01-01"
        }
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```

#### Use Case 7: Provider-to-Provider Consult

**A Specialist (Practitioner) requests data from a Referring Provider.**

##### Ticket Schema

* **Subject:** `Patient` (Reference).
* **Actor:** `Practitioner` (NPI).
* **Context:** `type` = `REFER` (Referral), `focus` = `Atrial fibrillation` (SCT 49436004).
* **Capability:** `scopes` = `patient/*.read`.

#### Permission Ticket Artifact 

##### Header

```
{
  "alg": "ES256",
  "kid": "nvOGRCsTz2QIQLsbl0ZQ_ux0tfyh5iave-jvNsANWv8"
}
```

##### Payload (Claims)

```
{
  "iss": "https://referring-ehr.org",
  "sub": "https://specialist-clinic.org/apps/referral-viewer",
  "aud": "https://referring-ehr.org",
  "ticket_context": {
    "subject": {
      "resourceType": "Patient",
      "reference": "Patient/999"
    },
    "actor": {
      "resourceType": "Practitioner",
      "identifier": [
        {
          "system": "http://hl7.org/fhir/sid/us-npi",
          "value": "1112223333"
        }
      ],
      "name": [
        {
          "family": "Heart",
          "given": [
            "A."
          ]
        }
      ]
    },
    "context": {
      "type": {
        "system": "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code": "REFER",
        "display": "Referral"
      },
      "focus": {
        "system": "http://snomed.info/sct",
        "code": "49436004",
        "display": "Atrial fibrillation"
      }
    },
    "capability": {
      "scopes": [
        "patient/*.read"
      ]
    }
  },
  "iat": 1763678603,
  "exp": 1763682203
}
```



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "smart.permission-tickets",
  "url" : "http://smarthealthit.org/ig/permission-tickets/ImplementationGuide/smart.permission-tickets",
  "version" : "0.1.0",
  "name" : "SmartPermissionTickets",
  "title" : "SMART Permission Tickets",
  "status" : "draft",
  "date" : "2025-11-20T22:44:35+00:00",
  "packageId" : "smart.permission-tickets",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2024+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://smarthealthit.org/ig/permission-tickets/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2024+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://smarthealthit.org/ig/permission-tickets/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PermissionTicket"
        },
        "name" : "Permission Ticket (JWT Payload)",
        "description" : "The full payload of a Permission Ticket, including standard JWT claims and the custom permission object.",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Permission Ticket Architecture",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "problem.html"
            }
          ],
          "nameUrl" : "problem.html",
          "title" : "The Problem Space",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "solution.html"
            }
          ],
          "nameUrl" : "solution.html",
          "title" : "The Solution",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "specification.html"
            }
          ],
          "nameUrl" : "specification.html",
          "title" : "Technical Specification",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "use-cases.html"
            }
          ],
          "nameUrl" : "use-cases.html",
          "title" : "Catalog of Use Cases",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
