# Permission Ticket (JWT Payload) - SMART Permission Tickets v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Permission Ticket (JWT Payload)**

## Logical Model: Permission Ticket (JWT Payload) 

| | |
| :--- | :--- |
| *Official URL*:http://smarthealthit.org/ig/permission-tickets/StructureDefinition/PermissionTicket | *Version*:0.1.0 |
| Draft as of 2025-11-20 | *Computable Name*:PermissionTicket |

 
The full payload of a Permission Ticket, including standard JWT claims and the custom permission object. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/smart.permission-tickets|current/StructureDefinition/PermissionTicket)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PermissionTicket.csv), [Excel](StructureDefinition-PermissionTicket.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PermissionTicket",
  "url" : "http://smarthealthit.org/ig/permission-tickets/StructureDefinition/PermissionTicket",
  "version" : "0.1.0",
  "name" : "PermissionTicket",
  "title" : "Permission Ticket (JWT Payload)",
  "status" : "draft",
  "date" : "2025-11-20T22:44:35+00:00",
  "description" : "The full payload of a Permission Ticket, including standard JWT claims and the custom permission object.",
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "http://smarthealthit.org/ig/permission-tickets/StructureDefinition/PermissionTicket",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "PermissionTicket",
        "path" : "PermissionTicket",
        "short" : "Permission Ticket (JWT Payload)",
        "definition" : "The full payload of a Permission Ticket, including standard JWT claims and the custom permission object."
      },
      {
        "id" : "PermissionTicket.iss",
        "path" : "PermissionTicket.iss",
        "short" : "Issuer (Trust Broker URL)",
        "definition" : "Issuer (Trust Broker URL)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PermissionTicket.sub",
        "path" : "PermissionTicket.sub",
        "short" : "Subject (Client ID)",
        "definition" : "Subject (Client ID)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PermissionTicket.aud",
        "path" : "PermissionTicket.aud",
        "short" : "Audience (Network/Data Holder)",
        "definition" : "Audience (Network/Data Holder)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PermissionTicket.exp",
        "path" : "PermissionTicket.exp",
        "short" : "Expiration Timestamp",
        "definition" : "Expiration Timestamp",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "PermissionTicket.jti",
        "path" : "PermissionTicket.jti",
        "short" : "Unique Ticket ID",
        "definition" : "Unique Ticket ID",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context",
        "path" : "PermissionTicket.ticket_context",
        "short" : "Permission Details",
        "definition" : "Permission Details",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.subject",
        "path" : "PermissionTicket.ticket_context.subject",
        "short" : "The Patient or Subject of the data",
        "definition" : "The Patient or Subject of the data",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.subject.type",
        "path" : "PermissionTicket.ticket_context.subject.type",
        "short" : "Type of subject match (e.g., 'match' or 'reference')",
        "definition" : "Type of subject match (e.g., 'match' or 'reference')",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.subject.traits",
        "path" : "PermissionTicket.ticket_context.subject.traits",
        "short" : "Demographic traits for matching",
        "definition" : "Demographic traits for matching",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.subject.resourceType",
        "path" : "PermissionTicket.ticket_context.subject.resourceType",
        "short" : "Resource Type (e.g. Patient)",
        "definition" : "Resource Type (e.g. Patient)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.subject.id",
        "path" : "PermissionTicket.ticket_context.subject.id",
        "short" : "Resource ID",
        "definition" : "Resource ID",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.subject.identifier",
        "path" : "PermissionTicket.ticket_context.subject.identifier",
        "short" : "Business Identifier",
        "definition" : "Business Identifier",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.actor",
        "path" : "PermissionTicket.ticket_context.actor",
        "short" : "The Requesting Agent",
        "definition" : "The Requesting Agent",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.actor.resourceType",
        "path" : "PermissionTicket.ticket_context.actor.resourceType",
        "short" : "Type of actor (PractitionerRole, RelatedPerson, Organization)",
        "definition" : "Type of actor (PractitionerRole, RelatedPerson, Organization)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.actor.name",
        "path" : "PermissionTicket.ticket_context.actor.name",
        "short" : "Name of the actor",
        "definition" : "Name of the actor",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.actor.telecom",
        "path" : "PermissionTicket.ticket_context.actor.telecom",
        "short" : "Contact details",
        "definition" : "Contact details",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.actor.identifier",
        "path" : "PermissionTicket.ticket_context.actor.identifier",
        "short" : "Actor identifiers (NPI, etc)",
        "definition" : "Actor identifiers (NPI, etc)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.actor.relationship",
        "path" : "PermissionTicket.ticket_context.actor.relationship",
        "short" : "Relationship to subject",
        "definition" : "Relationship to subject",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.actor.type",
        "path" : "PermissionTicket.ticket_context.actor.type",
        "short" : "Organization type",
        "definition" : "Organization type",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.actor.contained",
        "path" : "PermissionTicket.ticket_context.actor.contained",
        "short" : "Embedded resources",
        "definition" : "Embedded resources",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Resource"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.context",
        "path" : "PermissionTicket.ticket_context.context",
        "short" : "The Trigger Event",
        "definition" : "The Trigger Event",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.context.type",
        "path" : "PermissionTicket.ticket_context.context.type",
        "short" : "Type of context (e.g. ActReason)",
        "definition" : "Type of context (e.g. ActReason)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.context.focus",
        "path" : "PermissionTicket.ticket_context.context.focus",
        "short" : "Clinical Focus (e.g. Condition)",
        "definition" : "Clinical Focus (e.g. Condition)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.context.identifier",
        "path" : "PermissionTicket.ticket_context.context.identifier",
        "short" : "Issuer-specific identifiers (Case ID, etc)",
        "definition" : "Issuer-specific identifiers (Case ID, etc)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.capability",
        "path" : "PermissionTicket.ticket_context.capability",
        "short" : "Access Capabilities",
        "definition" : "Access Capabilities",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.capability.scopes",
        "path" : "PermissionTicket.ticket_context.capability.scopes",
        "short" : "SMART Scopes (e.g. patient/Immunization.read)",
        "definition" : "SMART Scopes (e.g. patient/Immunization.read)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.capability.periods",
        "path" : "PermissionTicket.ticket_context.capability.periods",
        "short" : "Time restrictions (Service Date)",
        "definition" : "Time restrictions (Service Date)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.capability.locations",
        "path" : "PermissionTicket.ticket_context.capability.locations",
        "short" : "Allowed Locations (Jurisdictions)",
        "definition" : "Allowed Locations (Jurisdictions)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "PermissionTicket.ticket-context.capability.organizations",
        "path" : "PermissionTicket.ticket_context.capability.organizations",
        "short" : "Allowed Organizations",
        "definition" : "Allowed Organizations",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Organization"
          }
        ]
      }
    ]
  }
}

```
