# Terminology - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* **Terminology**

## Terminology

### ValueSets

These are ValueSets that have been defined in this guide for coded elements.

Each ValueSet resource has a globally unique url (the [Canonical](http://hl7.org/fhir/references.html#canonical) url) that is used to unambiguously identify it. This url generally should resolve to the to the FHIR ValueSet resource, though the infrastructure to support this is not yet in place. There's a [specific note](http://hl7.org/fhir/valueset.html#ident) in the spec on ValueSet identification.

The [FHIR spec](http://hl7.org/fhir/terminology-module.html) has much more detail on the use of Terminology in FHIR.

* ValueSet: [ACC Patient Occupation](ValueSet-acc-patient-occupation-valueset.md)
  * Purpose: ValueSet of codes for classifying patient occupations, drawn from the ACC codeset
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/acc-patient-occupation-code
* ValueSet: [Additional Practitioner authorisations](ValueSet-practitioner-additional-authorisation-code.md)
  * Purpose: A coded type for additional authorisations
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/practitioner-additional-authorisation-code
* ValueSet: [Alias types](ValueSet-location-alias-type.md)
  * Purpose: The complete set of alias types that apply to Locations and Organizations
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/alias-type-code
* ValueSet: [ContactPoint purpose](ValueSet-contact-point-purpose.md)
  * Purpose: The purpose of a ContactPoint - what it is used for.
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/contact-point-purpose-code
* ValueSet: [Coverage Category](ValueSet-coverage-category.md)
  * Purpose: New Zealand codes for Coverage category types
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/coverage-category-code
* ValueSet: [Coverage Type](ValueSet-coverage-type.md)
  * Purpose: New Zealand codes for Coverage Types
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/coverage-type-code
* ValueSet: [Datum code](ValueSet-datumCode.md)
  * Purpose: Datum codes used
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/nz-datum-code
* ValueSet: [Death date Information Source](ValueSet-dod-information-source.md)
  * Purpose: The source from where the date of death was sourced
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/dod-information-source-code
* ValueSet: [District Health Board Identifer](ValueSet-dhb.md)
  * Purpose: District Health Board Identifer. Assigned by the HPI.
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/dhb-code
* ValueSet: [Domicile Code](ValueSet-domicile-code.md)
  * Purpose: Domicile Code
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/domicile-code
* ValueSet: [Ethnicity of a person (L4)](ValueSet-ethnicity.md)
  * Purpose: Codes to record a person's ethnicity, drawn from[Level 4 of the Ethnicity code system](http://aria.stats.govt.nz/aria/#ClassificationView:uri=http://stats.govt.nz/cms/ClassificationVersion/YVqOcFHSlguKkT17)
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/ethnic-group-level-4-code
* ValueSet: [Ethnicity of a person (full)](ValueSet-ethnicityfull.md)
  * Purpose: Ethnicity New Zealand Standard Classification 2005. Ethnicity is the ethnic group or groups that people identify with or feel they belong to.
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/nz-ethnic-group-code
* ValueSet: [Funded Programme](ValueSet-funded-programme.md)
  * Purpose: Codes to describe NZ-specific types of funded programmes.
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/funded-programme-code
* ValueSet: [Information Source](ValueSet-information-source.md)
  * Purpose: The source from where the value of this item was sourced
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/information-source-code
* ValueSet: [Iwi](ValueSet-iwi.md)
  * Purpose: New Zealand iwi codes. The 2 digit codes are abstract codes and provided in the expansion for navigational purposes. A user should not select an abstract code directly as a proper value.
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/iwi-code
* ValueSet: [Māori Descent](ValueSet-maori-descent-valueset.md)
  * Purpose: A code indicating whether a person is of Māori descent
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/maori-descent
* ValueSet: [NZ Citizenship status](ValueSet-citizenship-status.md)
  * Purpose: Citizenship status
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/nz-citizenship-status-code
* ValueSet: [NZ Residency status](ValueSet-nz-residency.md)
  * Purpose: Is the person a NZ resident
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/nz-residency-code
* ValueSet: [PHO](ValueSet-pho.md)
  * Purpose: Primary Healthcare Organization
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/pho-code
* ValueSet: [PractitionerRole status reason](ValueSet-hpi-practitionerrole-status-reason.md)
  * Purpose: The reason for the change in status of PractitionerRole
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/hpi-practitioner-role-status-reason-code
* ValueSet: [Registration Status of Practitioners](ValueSet-practitioner-registration-status-code.md)
  * Purpose: The code list represents the current practicing status of the Provider Person as per their registration with an RA.
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/practitioner-registration-status-code
* ValueSet: [Scope of practice](ValueSet-practitioner-scope-of-practice.md)
  * Purpose: A coded type for professional scope of practice.
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/practitioner-scope-of-practice-code
* ValueSet: [Valid use values for NHI](ValueSet-nhi-use.md)
  * Purpose: NHI Use codes
  * Canonical url: https://nzhts.digital.health.nz/fhir/ValueSet/nhi-use-code

### CodeSystems

These are code systems that have been defined in this guide. They define specific concepts that are included in ValueSets. It is preferable to use an international code system such as SNOMED, ICD or LOINC - but this is not always possible.

Each CodeSystem resource has a globally unique url (the canonical url) that is used to unambiguously identify it. The url generally refers to a description of the codesystem, rather than to the FHIR CodeSystem resource.

The [FHIR spec](http://hl7.org/fhir/terminology-module.html) has much more detail on the use of Terminology in FHIR

* CodeSystem: [ACC Patient Occupation CodeSystem](CodeSystem-acc-patient-occupation-codesystem.md)
  * Purpose: Codes for classifying patient occupations, drawn from the ACC codeset
  * Canonical Url: https://standards.digital.health.nz/ns/acc-patient-occupation-code
* CodeSystem: [Additional Authorisation](CodeSystem-practitioner-additional-authorisation.md)
  * Purpose: Additional authorisations that a practitioner is authorised to practice or prescribe.
  * Canonical Url: https://standards.digital.health.nz/ns/practitioner-additional-authorisation-code
* CodeSystem: [ContactPoint purpose](CodeSystem-contact-point-purpose.md)
  * Purpose: The purpose of a ContactPoint - what it is used for.
  * Canonical Url: https://standards.digital.health.nz/ns/contact-point-purpose-code
* CodeSystem: [Coverage category](CodeSystem-coverage-category.md)
  * Purpose: New Zealand codes for Coverage category types
  * Canonical Url: https://standards.digital.health.nz/ns/coverage-category-code
* CodeSystem: [Coverage type](CodeSystem-coverage-type.md)
  * Purpose: New Zealand codes for Coverage Types
  * Canonical Url: https://standards.digital.health.nz/ns/coverage-type-code
* CodeSystem: [Datum codes](CodeSystem-datum-code.md)
  * Purpose: Possible datum codes
  * Canonical Url: https://standards.digital.health.nz/ns/nz-datum-code
* CodeSystem: [Domicile Code](CodeSystem-domicile-code.md)
  * Purpose: Domicile Code
  * Canonical Url: https://standards.digital.health.nz/ns/domicile-code
* CodeSystem: [Funded Programme](CodeSystem-funded-programme.md)
  * Purpose: Codes to describe NZ-specific types of funded programmes.
  * Canonical Url: https://standards.digital.health.nz/ns/funded-programme-code
* CodeSystem: [Information Source](CodeSystem-information-source.md)
  * Purpose: All possible sources of information
  * Canonical Url: https://standards.digital.health.nz/ns/information-source-code
* CodeSystem: [Level 4 ethnicity codes](CodeSystem-ethnicityL4.md)
  * Purpose: Codes to record a person’s ethnicity, drawn from Level 4 of the Ethnicity code system described[here](http://aria.stats.govt.nz/aria/#ClassificationView:uri=http://stats.govt.nz/cms/ClassificationVersion/YVqOcFHSlguKkT17)
  * Canonical Url: https://standards.digital.health.nz/ns/ethnic-group-level-4-code
* CodeSystem: [Māori Descent](CodeSystem-maori-descent-codesystem.md)
  * Purpose: Codes for classifying Māori descent. Defined by Stats NZ - Māori descent v1.0.0
  * Canonical Url: https://standards.digital.health.nz/ns/maori-descent-code
* CodeSystem: [NZ Citizenship status](CodeSystem-citizenship-status.md)
  * Purpose: Is this person a NZ Citizen
  * Canonical Url: https://standards.digital.health.nz/ns/nz-citizenship-status-code
* CodeSystem: [NZ DHB](CodeSystem-dhb-code.md)
  * Purpose: NZ District Health Board (HPI-ORG) Codes
  * Canonical Url: https://standards.digital.health.nz/ns/dhb-code
* CodeSystem: [NZ Iwi](CodeSystem-iwi-code.md)
  * Purpose: NZ Iwi Statistical Standard
  * Canonical Url: https://standards.digital.health.nz/ns/iwi-code
* CodeSystem: [NZ Residency status](CodeSystem-nz-residency.md)
  * Purpose: NZ Residency status
  * Canonical Url: https://standards.digital.health.nz/ns/nz-residency-code
* CodeSystem: [NZ ethnic group codes](CodeSystem-Ethnicity.md)
  * Purpose: Ethnicity New Zealand Standard Classification 2005. Ethnicity is the ethnic group or groups that people identify with or feel they belong to.
  * Canonical Url: https://standards.digital.health.nz/ns/nz-ethnic-group-codes
* CodeSystem: [PHO](CodeSystem-pho-status.md)
  * Purpose: Primary Healthcare Organization
  * Canonical Url: https://standards.digital.health.nz/ns/pho-code
* CodeSystem: [PractitionerRole status reason](CodeSystem-hpi-practitionerRole-status-reason.md)
  * Purpose: The reason for the change in status of PractitionerRole
  * Canonical Url: https://standards.digital.health.nz/ns/hpi-practitioner-role-status-reason-code
* CodeSystem: [Registration Status of Practitioners](CodeSystem-practitioner-registration-status-code.md)
  * Purpose: The code list represents the current practicing status of the Provider Person as per their registration with an RA.
  * Canonical Url: https://standards.digital.health.nz/ns/practitioner-registration-status-code
* CodeSystem: [Scope of practice](CodeSystem-scopeOfPractice.md)
  * Purpose: A classification of the type or range of health services that a practitioner is authorised to provide, as determined by the Responsible Authority or other statutory authority (e.g. PHARMAC), that is, what the practitioner can or cannot do. It includes Scope of Practice as defined by the Health Practitioners Competence Assurance Act 2003, any special authorisations granted, and any conditions or limitations imposed by the Responsible Authority.
  * Canonical Url: https://standards.digital.health.nz/ns/practitioner-scope-of-practice-code
* CodeSystem: [Type of Alias](CodeSystem-alias-type.md)
  * Purpose: Used in Organization and Location to indicate what is the type of Alias
  * Canonical Url: https://standards.digital.health.nz/ns/alias-type-code

