# Naming Systems - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* **Naming Systems**

## Naming Systems

### Identifiers

These are identifiers defined in this IG. They are defined using
[NamingSystem](http://hl7.org/fhir/namingsystem.html)resources.

* Description: ACC 45 number
  * Url: https://standards.digital.health.nz/ns/acc-45-number
  * Other identifiers: 
  * Responsible: HISO
* Description: Chiropractic Board Register number
  * Url: https://standards.digital.health.nz/ns/chiropractic-board-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.1 (oid) 

  * Responsible: HISO
* Description: Dental Council Register Number
  * Url: https://standards.digital.health.nz/ns/dental-council-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.2 (oid) 

  * Responsible: HISO
* Description: Dietitians Board Register Number
  * Url: https://standards.digital.health.nz/ns/dietitians-board-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.3 (oid) 

  * Responsible: HISO
* Description: HPI facilities
  * Url: https://standards.digital.health.nz/ns/hpi-facility-id
  * Other identifiers: * https://standards.digital.health.nz/ns/moh-facility-id (uri) 
* https://standards.digital.health.nz/id/hpi-facility (uri) Deprecated
* 2.16.840.1.113883.2.18.3.2 (oid) 
* https://standards.digital.health.nz/ns/nzhis-facility-id (uri) 

  * Responsible: HISO
* Description: HPI organizations
  * Url: https://standards.digital.health.nz/ns/hpi-organisation-id
  * Other identifiers: * https://standards.digital.health.nz/ns/moh-agency-id (uri) NZHIS Agency code. Deprecated
* https://standards.digital.health.nz/id/hpi-organisation (uri) Deprecated
* 2.16.840.1.113883.2.18.3.3 (oid) 
* https://standards.digital.health.nz/ns/nzhis-agency-id (uri) Deprecated

  * Responsible: HISO
* Description: HPI providers
  * Url: https://standards.digital.health.nz/ns/hpi-person-id
  * Other identifiers: * https://standards.digital.health.nz/id/hpi-person (uri) Deprecated
* 2.16.840.1.113883.2.18.3.1 (oid) 

  * Responsible: HISO
* Description: Identifier assigned by the Rheumatic Fever Care Coordination System, used on CarePlan, Condition, CareTeam, and Observation resources.
  * Url: https://standards.digital.health.nz/ns/rf-ccs-id
  * Other identifiers: 
  * Responsible: New Zealand Health Information Standards Organisation (HISO)
* Description: Medical Council of New Zealand Register Number
  * Url: https://standards.digital.health.nz/ns/medical-council-id
  * Other identifiers: * 2.16.840.1.113883.2.18.41 (oid) 

  * Responsible: HISO
* Description: Medical Radiation Technologists Board Register Number
  * Url: https://standards.digital.health.nz/ns/medical-radiation-technologists-board-id
  * Other identifiers: 
  * Responsible: HISO
* Description: Medical Sciences Council Register Number
  * Url: https://standards.digital.health.nz/ns/medical-sciences-council-id
  * Other identifiers: 
  * Responsible: HISO
* Description: Midwifery Council Register Number
  * Url: https://standards.digital.health.nz/ns/midwifery-council-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.5 (oid) 

  * Responsible: HISO
* Description: NHI number
  * Url: https://standards.digital.health.nz/ns/nhi-id
  * Other identifiers: * https://standards.digital.health.nz/id/nhi (uri) Deprecated
* 2.16.840.1.113883.2.18.2 (oid) 

  * Responsible: HISO
* Description: New Zealand Business Number
  * Url: https://standards.digital.health.nz/ns/hpi-nzbn
  * Other identifiers: 
  * Responsible: HISO
* Description: New Zealand Street Address Mapping Identifier
  * Url: https://standards.digital.health.nz/ns/nz-address-id
  * Other identifiers: 
  * Responsible: New Zealand Health Information Standards Organisation (HISO)
* Description: Nursing Council of New Zealand Register Number
  * Url: https://standards.digital.health.nz/ns/nursing-council-id
  * Other identifiers: * 2.16.840.1.113883.2.18.42 (oid) 

  * Responsible: HISO
* Description: Occupational Therapy Board Register Number
  * Url: https://standards.digital.health.nz/ns/occupational-therapy-board-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.13 (oid) 

  * Responsible: HISO
* Description: Optometrists & Dispensing Opticians Board Register Number
  * Url: https://standards.digital.health.nz/ns/optometrists-dispensing-opticians-board-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.12 (oid) 

  * Responsible: HISO
* Description: Osteopathic Council Register Number
  * Url: https://standards.digital.health.nz/ns/osteopathic-council-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.6 (oid) 

  * Responsible: HISO
* Description: Paramedic Council Register Number
  * Url: https://standards.digital.health.nz/ns/paramedic-council-id
  * Other identifiers: 
  * Responsible: HISO
* Description: Pharmacy Council of New Zealand Register Number
  * Url: https://standards.digital.health.nz/ns/pharmacy-council-id
  * Other identifiers: * 2.16.840.1.113883.2.18.68 (oid) 
* 2.16.840.1.113883.2.18.9 (oid) 

  * Responsible: HISO
* Description: Physiotherapy Board Register Number
  * Url: https://standards.digital.health.nz/ns/physiotherapy-board-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.7 (oid) 

  * Responsible: HISO
* Description: Podiatrists Board Register Number
  * Url: https://standards.digital.health.nz/ns/podiatrists-board-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.8 (oid) 

  * Responsible: HISO
* Description: Psychologists Board Register Number
  * Url: https://standards.digital.health.nz/ns/psychologists-board-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.9 (oid) 

  * Responsible: HISO
* Description: Psychotherapists Board register Number
  * Url: https://standards.digital.health.nz/ns/psychotherapists-board-id
  * Other identifiers: * 2.16.840.1.113883.2.18.70.7 (oid) 

  * Responsible: HISO
* Description: This identifier, known as the 'MoE Number' or 'School Number', is used by the education sector to identify an NZ education institution. These identifiers can be looked up at the \[[educationcounts.govt.nz](http://educationcounts.govt.nz)\]([https://www.educationcounts.govt.nz/directories/list-of-nz-schools](https://www.educationcounts.govt.nz/directories/list-of-nz-schools)) website.
  * Url: https://standards.digital.health.nz/ns/moe-facility-id
  * Other identifiers: 
  * Responsible: New Zealand Health Information Standards Organisation (HISO)

