# fhir.org.nz.ig.base#3.1.0: HL7® FHIR® New Zealand Base Implementation Guide

## Pages

* [Home](index.md)
* [Extensions](extensions.md)
* [Naming Systems](namingSystems.md)
* [Terminology](terminology.md)
* [Profiles](profiles.md)
* [Artifacts Summary](artifacts.md)

## Resources

### CodeSystems

* [NZ ethnic group codes](CodeSystem-Ethnicity.md)
* [ACC Patient Occupation CodeSystem](CodeSystem-acc-patient-occupation-codesystem.md)
* [Type of Alias](CodeSystem-alias-type.md)
* [NZ Citizenship status](CodeSystem-citizenship-status.md)
* [ContactPoint purpose](CodeSystem-contact-point-purpose.md)
* [Coverage category](CodeSystem-coverage-category.md)
* [Coverage type](CodeSystem-coverage-type.md)
* [Datum codes](CodeSystem-datum-code.md)
* [NZ DHB](CodeSystem-dhb-code.md)
* [Domicile Code](CodeSystem-domicile-code.md)
* [Level 4 ethnicity codes](CodeSystem-ethnicityL4.md)
* [Funded Programme](CodeSystem-funded-programme.md)
* [PractitionerRole status reason](CodeSystem-hpi-practitionerRole-status-reason.md)
* [Information Source](CodeSystem-information-source.md)
* [NZ Iwi](CodeSystem-iwi-code.md)
* [Māori Descent](CodeSystem-maori-descent-codesystem.md)
* [NZ Residency status](CodeSystem-nz-residency.md)
* [PHO](CodeSystem-pho-status.md)
* [Additional Authorisation](CodeSystem-practitioner-additional-authorisation.md)
* [Registration Status of Practitioners](CodeSystem-practitioner-registration-status-code.md)
* [Scope of practice](CodeSystem-scopeOfPractice.md)

### ValueSets

* [ACC Patient Occupation](ValueSet-acc-patient-occupation-valueset.md)
* [NZ Citizenship status](ValueSet-citizenship-status.md)
* [ContactPoint purpose](ValueSet-contact-point-purpose.md)
* [Coverage Category](ValueSet-coverage-category.md)
* [Coverage Type](ValueSet-coverage-type.md)
* [Datum code](ValueSet-datumCode.md)
* [District Health Board Identifer](ValueSet-dhb.md)
* [Death date Information Source](ValueSet-dod-information-source.md)
* [Domicile Code](ValueSet-domicile-code.md)
* [Ethnicity of a person (L4)](ValueSet-ethnicity.md)
* [Ethnicity of a person (full)](ValueSet-ethnicityfull.md)
* [Funded Programme](ValueSet-funded-programme.md)
* [PractitionerRole status reason](ValueSet-hpi-practitionerrole-status-reason.md)
* [Information Source](ValueSet-information-source.md)
* [Iwi](ValueSet-iwi.md)
* [Alias types](ValueSet-location-alias-type.md)
* [Māori Descent](ValueSet-maori-descent-valueset.md)
* [Valid use values for NHI](ValueSet-nhi-use.md)
* [NZ Residency status](ValueSet-nz-residency.md)
* [PHO](ValueSet-pho.md)
* [Additional Practitioner authorisations](ValueSet-practitioner-additional-authorisation-code.md)
* [Registration Status of Practitioners](ValueSet-practitioner-registration-status-code.md)
* [Scope of practice](ValueSet-practitioner-scope-of-practice.md)

### Complex-type Profiles

* [Common NZ Address datatype](StructureDefinition-NzAddress.md)
* [Common NZ ContactPoint datatype](StructureDefinition-NzContactPoint.md)

### Resource Profiles

* [Condition resource for use in NZ](StructureDefinition-NzCondition.md)
* [Coverage resource for use in NZ (Trial use)](StructureDefinition-NzCoverage.md)
* [HealthcareService resource for use in NZ](StructureDefinition-NzHealthcareService.md)
* [Location resource for use in NZ](StructureDefinition-NzLocation.md)
* [Medication resource for use in NZ](StructureDefinition-NzMedication.md)
* [Medication Dispense resource for use in NZ](StructureDefinition-NzMedicationDispense.md)
* [MedicationRequest resource for use in NZ](StructureDefinition-NzMedicationRequest.md)
* [MedicationStatement resource for use in NZ](StructureDefinition-NzMedicationStatement.md)
* [Organization resource for use in NZ](StructureDefinition-NzOrganization.md)
* [NZ Patient](StructureDefinition-NzPatient.md)
* [Practitioner resource for use in NZ](StructureDefinition-NzPractitioner.md)
* [PractitionerRole resource for use in NZ](StructureDefinition-NzPractitionerRole.md)
* [NZ RelatedPerson](StructureDefinition-NzRelatedPerson.md)

### Extensions

* [AccPatientOccupation](StructureDefinition-acc-patient-occupation.md)
* [AdditionalAuthorisation](StructureDefinition-additional-authorisation.md)
* [AliasType](StructureDefinition-alias-type.md)
* [Building Name](StructureDefinition-building-name.md)
* [ConditionOnPractice](StructureDefinition-condition-on-practice.md)
* [A specific purpose for which this ContactPoint dataType would be used](StructureDefinition-contactpoint-purpose.md)
* [Country Name](StructureDefinition-country-name.md)
* [Date of death](StructureDefinition-death-date.md)
* [District Health Board linked to a NZ Healthcare Service, Location or Patient](StructureDefinition-dhb.md)
* [NZ Domicile Code](StructureDefinition-domicile-code.md)
* [EDI Address](StructureDefinition-edi-address.md)
* [EducationalQualification](StructureDefinition-educational-qualification.md)
* [Established](StructureDefinition-established.md)
* [Funded Healthcare Programme](StructureDefinition-funded-programme.md)
* [GenderOriginalText](StructureDefinition-gender-original-text.md)
* [Information Source](StructureDefinition-information-source.md)
* [Long Term Condition Indicator](StructureDefinition-long-term-condition.md)
* [MaoriDescent](StructureDefinition-maori-descent.md)
* [Messaging Address](StructureDefinition-messaging-address.md)
* [NZ Citizenship](StructureDefinition-nz-citizenship.md)
* [NZ Ethnicity](StructureDefinition-nz-ethnicity.md)
* [NZ Geocode](StructureDefinition-nz-geocode.md)
* [Nz_iwi](StructureDefinition-nz-iwi.md)
* [NZResidency](StructureDefinition-nz-residency.md)
* [NZePS Long Term Medication Indicator](StructureDefinition-nzeps-long-term-medication.md)
* [NZePS Supply Period Reason](StructureDefinition-nzeps-supply-period-reason.md)
* [NZePS Unusual Dose Quantity Indicator](StructureDefinition-nzeps-unusual-dose-quantity.md)
* [Nzf_atc](StructureDefinition-nzf-atc.md)
* [Nzf_nzmt_type](StructureDefinition-nzf-nzmt-type.md)
* [Primary Healthcare Organisation](StructureDefinition-pho.md)
* [PractitionerRoleCreator](StructureDefinition-practitionerRole-creator.md)
* [PractitionerRoleStatusReason](StructureDefinition-practitionerRole-status-reason.md)
* [RegistrationInitialDate](StructureDefinition-registration-initial-date.md)
* [RegistrationStatusCode](StructureDefinition-registration-status-code.md)
* [ScopeOfPractice](StructureDefinition-scope-of-practice.md)
* [Sex At Birth](StructureDefinition-sex-at-birth.md)
* [NZ Suburb](StructureDefinition-suburb.md)

### ImplementationGuides

* [HL7® FHIR® New Zealand Base Implementation Guide](index.md)

### NamingSystems

* [NZACC45](NamingSystem-acc45-id.md)
* [NZChiro](NamingSystem-chiropractic-board-id.md)
* [NZDental](NamingSystem-dental-council-id.md)
* [NZDiet](NamingSystem-dietitians-board-id.md)
* [HPIFacility](NamingSystem-hpi-facility-id.md)
* [NBN](NamingSystem-hpi-nzbn.md)
* [HPIOrganization](NamingSystem-hpi-organisation-id.md)
* [HPIProvider](NamingSystem-hpi-person-id.md)
* [NZMC](NamingSystem-medical-council-id.md)
* [NZRadiologist](NamingSystem-medical-radiation-technologists-board-id.md)
* [NZScience](NamingSystem-medical-sciences-council-id.md)
* [NZMidwife](NamingSystem-midwifery-council-id.md)
* [Moe_facility_id](NamingSystem-moe-facility-id.md)
* [NHI](NamingSystem-nhi-id.md)
* [NZNC](NamingSystem-nursing-council-id.md)
* [Nz_address_id](NamingSystem-nz-address-id.md)
* [NZOCC](NamingSystem-occupational-therapy-board-id.md)
* [NZOpt](NamingSystem-optometrists-dispensing-opticians-board-id.md)
* [NZOst](NamingSystem-osteopathic-council-id.md)
* [NZParamed](NamingSystem-paramedic-council-id.md)
* [NZMC](NamingSystem-pharmacy-council-id.md)
* [NZPhysio](NamingSystem-physiotherapy-board-id.md)
* [NZPodiatry](NamingSystem-podiatrists-board-id.md)
* [NZPsych](NamingSystem-psychologists-board-id.md)
* [NZPsycho](NamingSystem-psychotherapists-board-id.md)
* [Rheumatic_fever_ccs_id](NamingSystem-rheumatic-fever-ccs-id.md)

### Examples

* [condition-long-term-condition (Condition)](Condition-condition-long-term-condition.md)
* [CoverageCSC (Coverage)](Coverage-CoverageCSC.md)
* [CoverageGMS (Coverage)](Coverage-CoverageGMS.md)
* [CoverageHUHC (Coverage)](Coverage-CoverageHUHC.md)
* [Daves health centre (Location)](Location-location-alias-type.md)
* [Daves health centre (Location)](Location-location-established.md)
* [medicationrequest-nzeps-long-term-medication (MedicationRequest)](MedicationRequest-medicationrequest-nzeps-long-term-medication.md)
* [medicationrequest-nzeps-supply-period-reason (MedicationRequest)](MedicationRequest-medicationrequest-nzeps-supply-period-reason.md)
* [medicationrequest-nzeps-unusual-dose-quantity (MedicationRequest)](MedicationRequest-medicationrequest-nzeps-unusual-dose-quantity.md)
* [Health R Us (Organization)](Organization-organization-edi-address.md)
* [Dianes Dental care (Organization)](Organization-organization-funded-programme.md)
* [Ministry Of Health (Organization)](Organization-organization-moh.md)
* [patient-address-building-name (Patient)](Patient-patient-address-building-name.md)
* [patient-address-suburb (Patient)](Patient-patient-address-suburb.md)
* [patient-building-name (Patient)](Patient-patient-building-name.md)
* [patient-deceased-information-source (Patient)](Patient-patient-deceased-information-source.md)
* [patient-dhb (Patient)](Patient-patient-dhb.md)
* [patient-domicile-code (Patient)](Patient-patient-domicile-code.md)
* [patient-information-source (Patient)](Patient-patient-information-source.md)
* [patient-messaging-address (Patient)](Patient-patient-messaging-address.md)
* [patient-nhi (Patient)](Patient-patient-nhi.md)
* [patient-nz-citizenship (Patient)](Patient-patient-nz-citizenship.md)
* [patient-nz-ethnicity (Patient)](Patient-patient-nz-ethnicity.md)
* [patient-nz-geocode (Patient)](Patient-patient-nz-geocode.md)
* [patient-nz-residency (Patient)](Patient-patient-nz-residency.md)
* [patient-pho (Patient)](Patient-patient-pho.md)
* [patient-sex-at-birth (Patient)](Patient-patient-sex-at-birth.md)
* [patient-suburb (Patient)](Patient-patient-suburb.md)
* [practitioner-additional-authorisation (Practitioner)](Practitioner-practitioner-additional-authorisation.md)
* [practitioner-condition-on-practice (Practitioner)](Practitioner-practitioner-condition-on-practice.md)
* [practitioner-death-date (Practitioner)](Practitioner-practitioner-death-date.md)
* [practitioner-edi-address (Practitioner)](Practitioner-practitioner-edi-address.md)
* [practitioner-educational-qualification (Practitioner)](Practitioner-practitioner-educational-qualification.md)
* [practitioner-registration-initial-date (Practitioner)](Practitioner-practitioner-registration-initial-date.md)
* [practitioner-registration-status-code (Practitioner)](Practitioner-practitioner-registration-status-code.md)
* [practitioner-scope-of-practice (Practitioner)](Practitioner-practitioner-scope-of-practice.md)
* [practitionerRole-creator (PractitionerRole)](PractitionerRole-practitionerRole-creator.md)
* [practitionerRole-messaging-address (PractitionerRole)](PractitionerRole-practitionerRole-messaging-address.md)
* [practitionerRole-status-reason (PractitionerRole)](PractitionerRole-practitionerRole-status-reason.md)
