# Extensions - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* **Extensions**

## Extensions

* Id: [acc-patient-occupation](StructureDefinition-acc-patient-occupation.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/acc-patient-occupation
  * Context of Use: Patient
  * Description: Codes to describe a patient's occupation, using ACC's patient occupation codeset.Note that the current ValueSet binding contains codes from NZSC099. ACC are planning to update this ValueSet to base the codes on ANZSCO at the request of Stats NZ (Timing TBC), so the binding strength has been left as 'example'.
  * Purpose: 
* Id: [additional-authorisation](StructureDefinition-additional-authorisation.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/additional-authorisation
  * Context of Use: Practitioner.qualification
  * Description: Additional authorisations that a practitioner is authorised to perform in addition to their registration and scope of practice. Examples include:**Prescribing authorisation for a nurse practitioner**Authorisation to administer immunisations
  * Purpose: 
* Id: [alias-type](StructureDefinition-alias-type.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/alias-type
  * Context of Use: Location.aliasOrganization.alias
  * Description: Used to indicate what sort of alias is being used in a Location or Organization - eg that it is a legal name.
  * Purpose: 
* Id: [building-name](StructureDefinition-building-name.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/building-name
  * Context of Use: Address
  * Description: The name of a building cited in an address.
  * Purpose: 
* Id: [condition-on-practice](StructureDefinition-condition-on-practice.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/condition-on-practice
  * Context of Use: Practitioner.qualification
  * Description: A full description of the conditions the health practitioner is subject to in relation to their scope of practice.
  * Purpose: 
* Id: [contactpoint-purpose](StructureDefinition-contactpoint-purpose.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/contactpoint-purpose
  * Context of Use: ContactPoint
  * Description: A specific purpose for which this ContactPoint dataType would be used. An example would be to indicate that this ContactPoint is used for video conferencing.
  * Purpose: 
* Id: [country-name](StructureDefinition-country-name.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/country-name
  * Context of Use: Address
  * Description: The display name for a country in an address.
  * Purpose: 
* Id: [death-date](StructureDefinition-death-date.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/death-date
  * Context of Use: Practitioner
  * Description: The date of death of the individual, plus the source of that information
  * Purpose: 
* Id: [dhb](StructureDefinition-dhb.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/dhb
  * Context of Use: HealthcareServiceLocationPatient
  * Description: District Health Board relating to a NZ Healthcare Service, Location (Facility) or Patient (primary, physical home address).
  * Purpose: Administrative - to allow NZ HealthcareService, Location (Facility) or Patient Resources to include the related District Health Board.
* Id: [domicile-code](StructureDefinition-domicile-code.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/domicile-code
  * Context of Use: PatientAddress
  * Description: NZ Domicile Code. Derived from a patient's primary physical, home address.
  * Purpose: 
* Id: [edi-address](StructureDefinition-edi-address.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/edi-address
  * Context of Use: ContactPoint.system
  * Description: Represents an Electronic Data Interchange (EDI) address. It is intended as an extension on ContactPoint.system, with the system value being 'other'. The value of the extension is the EDI supplier, the actual EDI address is the value element. Note that a new extension 'messaging address' is preferred.
  * Purpose: 
* Id: [educational-qualification](StructureDefinition-educational-qualification.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/educational-qualification
  * Context of Use: Practitioner
  * Description: Educational qualifications a practitioner has. These may or may not be related to registration information.
  * Purpose: 
* Id: [established](StructureDefinition-established.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/established
  * Context of Use: LocationOrganization
  * Description: The period over which the location or Organization is open
  * Purpose: 
* Id: [funded-programme](StructureDefinition-funded-programme.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/funded-programme
  * Context of Use: LocationOrganizationHealthcareService
  * Description: Funded NZ Healthcare Programmes
  * Purpose: Details of a NZ Healthcare Funded Programme relevant to its implementation status at an individual organisation, facility or service.
* Id: [gender-original-text](StructureDefinition-gender-original-text.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/gender-original-text
  * Context of Use: Patient.gender
  * Description: Text provided by the person with the choice of 'Another gender' (The FHIR AdministrativeGender CodeSystem codes this as '[other](http://hl7.org/fhir/R4B/codesystem-administrative-gender.html)').
  * Purpose: 
* Id: [information-source](StructureDefinition-information-source.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/information-source
  * Context of Use: Patient.namePatient.birthDatePatient.deceased.ofType(dateTime)
  * Description: The official source of information held about a patient.
  * Purpose: 
* Id: [long-term-condition](StructureDefinition-long-term-condition.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/long-term-condition
  * Context of Use: Condition
  * Description: Long Term Condition Indicator. A long term condition can be defined as any ongoing, long term or recurring conditions that can have a significant impact on people’s lives.
  * Purpose: For more info see[https://www.tewhatuora.govt.nz/for-the-health-sector/health-sector-guidance/diseases-and-conditions/long-term-conditions](https://www.tewhatuora.govt.nz/for-the-health-sector/health-sector-guidance/diseases-and-conditions/long-term-conditions).
* Id: [maori-descent](StructureDefinition-maori-descent.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/maori-descent
  * Context of Use: Patient
  * Description: Code indicating whether the person is of Māori descent
  * Purpose: 
* Id: [messaging-address](StructureDefinition-messaging-address.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/messaging-address
  * Context of Use: PatientLocationOrganizationHealthcareServicePractitionerRolePractitioner
  * Description: The address to where electronic communications might be sent. For historical reasons, there is an overlap with edi-address.
  * Purpose: 
* Id: [nz-citizenship](StructureDefinition-nz-citizenship.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship
  * Context of Use: Patient
  * Description: New Zealand citizenship
  * Purpose: 
* Id: [nz-ethnicity](StructureDefinition-nz-ethnicity.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity
  * Context of Use: PatientPractitionerRelatedPerson
  * Description: The ethnic group or groups that a person identifies with or feels they belong to. Ethnicity is a measure of cultural affiliation as opposed to race, ancestry, nationality or citizen. Ethnicity is self-perceived and a person can belong to more than one group.The Stats New Zealand standard can be found[here](http://aria.stats.govt.nz/aria/#ClassificationView:uri=http://stats.govt.nz/cms/ClassificationVersion/YVqOcFHSlguKkT17).
  * Purpose: 
* Id: [nz-geocode](StructureDefinition-nz-geocode.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/nz-geocode
  * Context of Use: Address
  * Description: New Zealand Geocode. This uses a different datum from that defined in the HL7 FHIR specification for a Geocode.
  * Purpose: 
* Id: [nz-iwi](StructureDefinition-nz-iwi.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/nz-iwi
  * Context of Use: PatientPractitionerRelatedPerson
  * Description: Persons Iwi affiliation
  * Purpose: 
* Id: [nz-residency](StructureDefinition-nz-residency.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/nz-residency
  * Context of Use: Patient
  * Description: NZ Residency status
  * Purpose: 
* Id: [nzeps-long-term-medication](StructureDefinition-nzeps-long-term-medication.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/nzeps-long-term-medication
  * Context of Use: MedicationRequestMedicationStatement
  * Description: NZePS Long Term Medication Indicator
  * Purpose: This has specific uses in NZ Pharmacy and GP systems for funding and clinical purposes. It is also part of the HISO 10041.1 standard for Medication Lists.
* Id: [nzeps-supply-period-reason](StructureDefinition-nzeps-supply-period-reason.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/nzeps-supply-period-reason
  * Context of Use: MedicationRequest
  * Description: The reason for a non-standard Supply Period.
  * Purpose: The reason for a non-standard supply period, e.g. the patient going abroad.
* Id: [nzeps-unusual-dose-quantity](StructureDefinition-nzeps-unusual-dose-quantity.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/nzeps-unusual-dose-quantity
  * Context of Use: MedicationRequest
  * Description: NZePS Unusual Dose Quantity Indicator
  * Purpose: Indicates if an unusual dose quantity has been prescribed deliberately.
* Id: [nzf-atc](StructureDefinition-nzf-atc.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/nzf-atc
  * Context of Use: Medication
  * Description: Anatomical Therapeutic Chemical (ATC) Classification - see https://www.who.int/tools/atc-ddd-toolkit/atc-classification
  * Purpose: 
* Id: [nzf-nzmt-type](StructureDefinition-nzf-nzmt-type.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/nzf-nzmt-type
  * Context of Use: Medication
  * Description: The NZ Medicines Terminology (NZMT) Data Class – MP (Medicinal Product), MPUU (Medicinal Product Unit of Use), MPP (Medicinal Product Pack), TP (Trade Product), TPUU (Trade Product Unit of Use), TPP (Trade Product Pack) or CTPP (Containered Trade Product Pack) – that the Medication is a member of.
  * Purpose: 
* Id: [pho](StructureDefinition-pho.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/pho
  * Context of Use: HealthcareServiceLocationPatient
  * Description: Primary Healthcare Organisation associated with a General Practice linked to a NZ Healthcare Service, Location (Facility) or Patient (GP).
  * Purpose: Administrative - to allow NZ HealthcareService, Location (Facility) or Patient Resources to include the related Primary Healthcare Organisation.
* Id: [practitionerRole-creator](StructureDefinition-practitionerRole-creator.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/practitionerRole-creator
  * Context of Use: PractitionerRole
  * Description: The organisation and person that created this role
  * Purpose: 
* Id: [practitionerRole-status-reason](StructureDefinition-practitionerRole-status-reason.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/practitionerRole-status-reason
  * Context of Use: PractitionerRole
  * Description: The reason for the status. Generally only used for inactive resources.
  * Purpose: 
* Id: [registration-initial-date](StructureDefinition-registration-initial-date.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/registration-initial-date
  * Context of Use: Practitioner.qualification
  * Description: The date the practitioner first became registered with the Responsible Authority or professional body
  * Purpose: 
* Id: [registration-status-code](StructureDefinition-registration-status-code.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/registration-status-code
  * Context of Use: Practitioner.qualification
  * Description: An indicator of the practicing status of the practitioner as supplied by their Responsible Authority or professional body.
  * Purpose: 
* Id: [scope-of-practice](StructureDefinition-scope-of-practice.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/scope-of-practice
  * Context of Use: Practitioner.qualification
  * Description: The type or range of health services a practitioner is authorised to perform, as determined by the Responsible Authority or professional body.
  * Purpose: 
* Id: [sex-at-birth](StructureDefinition-sex-at-birth.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/sex-at-birth
  * Context of Use: Patient
  * Description: A person’s sex at the time of their birth (considered to be immutable).
  * Purpose: 
* Id: [suburb](StructureDefinition-suburb.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/suburb
  * Context of Use: Address
  * Description: Suburb element of a NZ Address.
  * Purpose: Required as FHIR Base Address Type does not contain an element for Suburb (only District or State which, in population terms, are both broader than City - whereas Suburb is narrower).

