# Registration Status of Practitioners - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Registration Status of Practitioners**

## CodeSystem: Registration Status of Practitioners 

| | |
| :--- | :--- |
| *Official URL*:https://standards.digital.health.nz/ns/practitioner-registration-status-code | *Version*:2.0 |
| Active as of 2025-12-18 | *Computable Name*:PractitionerRegistrationStatusCode |

 
The code list represents the current practicing status of the Provider Person as per their registration with an RA. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [PractitionerRegistrationStatusCode](ValueSet-practitioner-registration-status-code.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "practitioner-registration-status-code",
  "url" : "https://standards.digital.health.nz/ns/practitioner-registration-status-code",
  "version" : "2.0",
  "name" : "PractitionerRegistrationStatusCode",
  "title" : "Registration Status of Practitioners",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-18T23:25:53+00:00",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "The code list represents the current practicing status of the Provider Person as per their registration with an RA.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 4,
  "concept" : [
    {
      "code" : "current",
      "display" : "Current",
      "definition" : "A provider who holds or is deemed to hold a current practising certificate."
    },
    {
      "code" : "inactive",
      "display" : "Inactive",
      "definition" : "A provider who is not practising"
    },
    {
      "code" : "removed",
      "display" : "Removed",
      "definition" : "A provider who has been removed from the register – this includes voluntary removal, de-registration and deceased"
    },
    {
      "code" : "suspended",
      "display" : "Suspended",
      "definition" : "A provider who is suspended from practising by a Responsible Authority"
    }
  ]
}

```
