# Māori Descent - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Māori Descent**

## CodeSystem: Māori Descent 

| | |
| :--- | :--- |
| *Official URL*:https://standards.digital.health.nz/ns/maori-descent-code | *Version*:1.0.0 |
| Active as of 2025-12-18 | *Computable Name*:MaoriDescent |

 
Codes for classifying Māori descent. Defined by Stats NZ - Māori descent v1.0.0 

 This Code system is referenced in the content logical definition of the following value sets: 

* [MaoriDescentValues](ValueSet-maori-descent-valueset.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "maori-descent-codesystem",
  "url" : "https://standards.digital.health.nz/ns/maori-descent-code",
  "version" : "1.0.0",
  "name" : "MaoriDescent",
  "title" : "Māori Descent",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-18T23:25:53+00:00",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "Codes for classifying Māori descent. Defined by Stats NZ - Māori descent v1.0.0",
  "caseSensitive" : true,
  "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/maori-descent",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "1",
      "display" : "Māori Descent"
    },
    {
      "code" : "2",
      "display" : "No Māori Descent"
    },
    {
      "code" : "4",
      "display" : "Don't Know"
    },
    {
      "code" : "5",
      "display" : "Refused to Answer"
    },
    {
      "code" : "7",
      "display" : "Response Unidentifiable"
    },
    {
      "code" : "8",
      "display" : "Response Outside Scope"
    },
    {
      "code" : "9",
      "display" : "Not Stated"
    }
  ]
}

```
