# Information Source - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Information Source**

## CodeSystem: Information Source 

| | |
| :--- | :--- |
| *Official URL*:https://standards.digital.health.nz/ns/information-source-code | *Version*:1.0.0 |
| Active as of 2025-12-18 | *Computable Name*:InformationSource |

 
All possible sources of information 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DodInformationSource](ValueSet-dod-information-source.md)
* [InformationSource](ValueSet-information-source.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "information-source",
  "url" : "https://standards.digital.health.nz/ns/information-source-code",
  "version" : "1.0.0",
  "name" : "InformationSource",
  "title" : "Information Source",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-18T23:25:53+00:00",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "All possible sources of information",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 25,
  "concept" : [
    {
      "code" : "BREG",
      "display" : "Birth Register",
      "definition" : "This code is added only after verification via MOH/DIA birth register matching"
    },
    {
      "code" : "BRCT",
      "display" : "Birth Certificate",
      "definition" : "Birth Certificate"
    },
    {
      "code" : "NZCT",
      "display" : "NZ Citizenship Certificate",
      "definition" : "New Zealand Citizenship Certificate issued by DIA"
    },
    {
      "code" : "PPRT",
      "display" : "Passport",
      "definition" : "Passport"
    },
    {
      "code" : "NZCI",
      "display" : "NZ Certificate of Identity",
      "definition" : "Certificate of Identity issued by DIA"
    },
    {
      "code" : "NZRT",
      "display" : "NZ Refugee Travel Document",
      "definition" : "Refugee Travel document issued by DIA"
    },
    {
      "code" : "NZET",
      "display" : "NZ Emergency Travel Document",
      "definition" : "Emergency Travel document issued by DIA"
    },
    {
      "code" : "OTHR",
      "display" : "Other",
      "definition" : "Other official document provided that is not found in the list provided"
    },
    {
      "code" : "NPRF",
      "display" : "Proof not Sighted",
      "definition" : "Information (not proof) provided by the patient / whānau verbally communicated. No proof sighted"
    },
    {
      "code" : "NZPV",
      "display" : "NZ Permanent Resident Visa",
      "definition" : "A New Zealand Permanent Resident Visa (not time bound) issued by Immigration New Zealand"
    },
    {
      "code" : "NZTV",
      "display" : "NZ Resident Visa",
      "definition" : "A New Zealand Resident Visa (time bound) issued by Immigration New Zealand"
    },
    {
      "code" : "NZMC",
      "display" : "NZ Marriage Certificate"
    },
    {
      "code" : "NZCU",
      "display" : "NZ Civil Union Certificate"
    },
    {
      "code" : "NZNC",
      "display" : "NZ Name Change Certificate or Deed Poll",
      "definition" : "NZ Name Change Certificate effective from 25 January 2009, Name Change by Statutary Declaration Documents issued for names changes made between September 1995 and 25 January 2009, Deed Poll for name changes prior to September 1995"
    },
    {
      "code" : "NZDL",
      "display" : "NZ Driver Licence"
    },
    {
      "code" : "CSC",
      "display" : "Community Services Card"
    },
    {
      "code" : "HL7",
      "display" : "HL7 applied",
      "definition" : "Data has been applied via HL7 message"
    },
    {
      "code" : "MIGR",
      "display" : "Migrated",
      "definition" : "From the legacy NHI System with no known external source"
    },
    {
      "code" : "DREG",
      "display" : "Death Register",
      "definition" : "The code is added only after MOH/DIA data matching"
    },
    {
      "code" : "OSEA",
      "display" : "Death Overseas",
      "definition" : "Indicates a non-New Zealand registered death advised by a third party or discovered by a media search"
    },
    {
      "code" : "MCCOD",
      "display" : "Medical Certificate Cause of Death",
      "definition" : "Date of Death from a Medical Certificate Cause of  Death. Forms HP4720, HP4721 or BDM 50"
    },
    {
      "code" : "CORONER",
      "display" : "Coroner Notification",
      "definition" : "Date of death notified to the Ministry by a Coronial Office"
    },
    {
      "code" : "OSEAOFF",
      "display" : "Death Overseas Official",
      "definition" : "Indicates a non-New Zealand registered death advised by an official source from another country."
    },
    {
      "code" : "DIA",
      "display" : "DIA data share",
      "definition" : "The code is added only after DHB or MOH/DIA data matching"
    },
    {
      "code" : "INZ",
      "display" : "ImmigrationNZ",
      "definition" : "The code is added only by the MoH or DHB from information provided by ImmigrationNZ data sharing"
    }
  ]
}

```
