# Funded Programme - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Funded Programme**

## CodeSystem: Funded Programme 

| | |
| :--- | :--- |
| *Official URL*:https://standards.digital.health.nz/ns/funded-programme-code | *Version*:1.0.0 |
| Active as of 2025-12-18 | *Computable Name*:FundedProgramme |

 
Codes to describe NZ-specific types of funded programmes. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [FundedProgramme](ValueSet-funded-programme.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "funded-programme",
  "url" : "https://standards.digital.health.nz/ns/funded-programme-code",
  "version" : "1.0.0",
  "name" : "FundedProgramme",
  "title" : "Funded Programme",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-18T23:25:53+00:00",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "Codes to describe NZ-specific types of funded programmes.",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 4,
  "concept" : [
    {
      "code" : "DENTAL_CHILD",
      "display" : "Dental Care - Children up to age 13"
    },
    {
      "code" : "DENTAL_ADULT_EMERGENCY",
      "display" : "Dental Care – Adult Emergency"
    },
    {
      "code" : "ENROLLING_GP_PRACTICE",
      "display" : "General Practice Enrollment"
    },
    {
      "code" : "OTHER",
      "display" : "Some other funded programme not otherwise defined"
    }
  ]
}

```
