# NZ DHB - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NZ DHB**

## CodeSystem: NZ DHB 

| | |
| :--- | :--- |
| *Official URL*:https://standards.digital.health.nz/ns/dhb-code | *Version*:1.0.0 |
| Draft as of 2022-08-25 | *Computable Name*:Dhb_code |
| **Copyright/Legal**: © 2020+ New Zealand Crown Copyright | |

 
NZ District Health Board (HPI-ORG) Codes 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DHB](ValueSet-dhb.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "dhb-code",
  "url" : "https://standards.digital.health.nz/ns/dhb-code",
  "version" : "1.0.0",
  "name" : "Dhb_code",
  "title" : "NZ DHB",
  "status" : "draft",
  "experimental" : false,
  "date" : "2022-08-25",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "NZ District Health Board (HPI-ORG) Codes",
  "copyright" : "© 2020+ New Zealand Crown Copyright",
  "caseSensitive" : true,
  "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/dhb-code",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "count" : 20,
  "concept" : [
    {
      "code" : "G00011-K",
      "display" : "Auckland District Health Board"
    },
    {
      "code" : "G00031-E",
      "display" : "Bay of Plenty District Health Board"
    },
    {
      "code" : "G00005-D",
      "display" : "Canterbury District Health Board"
    },
    {
      "code" : "G00036-D",
      "display" : "Capital and Coast District Health Board"
    },
    {
      "code" : "G00012-A",
      "display" : "Counties Manukau District Health Board"
    },
    {
      "code" : "G00032-G",
      "display" : "Hawkes Bay District Health Board"
    },
    {
      "code" : "G00006-F",
      "display" : "Hutt Valley District Health Board"
    },
    {
      "code" : "G00028-E",
      "display" : "Lakes District Health Board"
    },
    {
      "code" : "G00033-J",
      "display" : "Mid Central District Health Board"
    },
    {
      "code" : "G00038-H",
      "display" : "Nelson Marlborough District Health Board"
    },
    {
      "code" : "G00026-A",
      "display" : "Northland District Health Board"
    },
    {
      "code" : "G00025-K",
      "display" : "South Canterbury District Health Board"
    },
    {
      "code" : "G02328-E",
      "display" : "Southern District Health Board"
    },
    {
      "code" : "G00029-G",
      "display" : "Tairawhiti District Health Board"
    },
    {
      "code" : "G00030-C",
      "display" : "Taranaki District Health Board"
    },
    {
      "code" : "G00027-C",
      "display" : "Waikato District Health Board"
    },
    {
      "code" : "G00037-F",
      "display" : "Wairarapa District Health Board"
    },
    {
      "code" : "G00013-C",
      "display" : "Waitemata District Health Board"
    },
    {
      "code" : "G00039-K",
      "display" : "West Coast District Health Board"
    },
    {
      "code" : "G00035-B",
      "display" : "Whanganui District Health Board"
    }
  ]
}

```
