# Profiles - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* **Profiles**

## Profiles

**Profiles defined in this guide**

* Id: [NzAddress](StructureDefinition-NzAddress.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzAddress
  * Description: Adds building name, suburb, domicile code and geocode to the Address datatype
* Id: [NzCondition](StructureDefinition-NzCondition.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzCondition
  * Description: This profile adds the Long-Term Condition extension to the base Condition resource
* Id: [NzContactPoint](StructureDefinition-NzContactPoint.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzContactpoint
  * Description: This profile adds the Contact Point Purpose and EDI address extensions to the standard data type
* Id: [NzCoverage](StructureDefinition-NzCoverage.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzCoverage
  * Description: Coverage resource for use in NZ (Trial use)
* Id: [NzHealthcareService](StructureDefinition-NzHealthcareService.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzHealthcareService
  * Description: HealthcareService resource for use in NZ
* Id: [NzLocation](StructureDefinition-NzLocation.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzLocation
  * Description: Location resource for use in NZ
* Id: [NzMedication](StructureDefinition-NzMedication.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzMedication
  * Description: Medication resource for use in NZ
* Id: [NzMedicationDispense](StructureDefinition-NzMedicationDispense.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzMedicationDispense
  * Description: Medication Dispense resource for use in NZ
* Id: [NzMedicationRequest](StructureDefinition-NzMedicationRequest.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzMedicationRequest
  * Description: MedicationRequest resource for use in NZ
* Id: [NzMedicationStatement](StructureDefinition-NzMedicationStatement.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzMedicationStatement
  * Description: MedicationStatement resource for use in NZ
* Id: [NzOrganization](StructureDefinition-NzOrganization.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzOrganization
  * Description: Organization resource for use in NZ
* Id: [NzPatient](StructureDefinition-NzPatient.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzPatient
  * Description: The base New Zealand Patient profile
* Id: [NzPractitioner](StructureDefinition-NzPractitioner.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzPractitioner
  * Description: Practitioner resource for use in NZ
* Id: [NzPractitionerRole](StructureDefinition-NzPractitionerRole.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzPractitionerRole
  * Description: PractitionerRole resource for use in NZ
* Id: [NzRelatedPerson](StructureDefinition-NzRelatedPerson.md)
  * Canonical url: http://hl7.org.nz/fhir/StructureDefinition/NzRelatedPerson
  * Description: The base New Zealand RelatedPerson profile

