# Medication resource for use in NZ - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication resource for use in NZ**

## Resource Profile: Medication resource for use in NZ 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/NzMedication | *Version*:1.0.0 |
| Draft as of 2025-12-18 | *Computable Name*:NzMedication |

 
Medication resource for use in NZ 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.org.nz.ig.base|current/StructureDefinition/NzMedication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-NzMedication.csv), [Excel](StructureDefinition-NzMedication.xlsx), [Schematron](StructureDefinition-NzMedication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "NzMedication",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/NzMedication",
  "version" : "1.0.0",
  "name" : "NzMedication",
  "title" : "Medication resource for use in NZ",
  "status" : "draft",
  "date" : "2025-12-18T23:25:53+00:00",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "Medication resource for use in NZ",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.extension",
        "path" : "Medication.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Medication.extension:nzf-atc",
        "path" : "Medication.extension",
        "sliceName" : "nzf-atc",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/nzf-atc"]
          }
        ]
      },
      {
        "id" : "Medication.extension:nzf-nzmt-type",
        "path" : "Medication.extension",
        "sliceName" : "nzf-nzmt-type",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/nzf-nzmt-type"]
          }
        ]
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://nzmt.org.nz/vs"
        }
      }
    ]
  }
}

```
