# NZ Residency status - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NZ Residency status**

## CodeSystem: NZ Residency status 

| | |
| :--- | :--- |
| *Official URL*:https://standards.digital.health.nz/ns/nz-residency-code | *Version*:1.1.0 |
| Active as of 2025-12-18 | *Computable Name*:NZResidency |

 
NZ Residency status 

 This Code system is referenced in the content logical definition of the following value sets: 

* [NZResidency](ValueSet-nz-residency.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "nz-residency",
  "url" : "https://standards.digital.health.nz/ns/nz-residency-code",
  "version" : "1.1.0",
  "name" : "NZResidency",
  "title" : "NZ Residency status",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-18T23:25:53+00:00",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "NZ Residency status",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "yes",
      "display" : "Permanent Resident",
      "definition" : "Use this status if the person holds a residence class visa"
    },
    {
      "code" : "no",
      "display" : "Not a Permanent Resident",
      "definition" : "Use this status for a person who is a NZ Citizen or does not hold a residence class visa"
    },
    {
      "code" : "unknown",
      "display" : "Unknown",
      "definition" : "use this status if the residency status of the person cannot be determined or is unknown"
    }
  ]
}

```
