# Domicile Code - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Domicile Code**

## CodeSystem: Domicile Code 

| | |
| :--- | :--- |
| *Official URL*:https://standards.digital.health.nz/ns/domicile-code | *Version*:3.0 |
| Active as of 2025-12-18 | *Computable Name*:DomicileCode |

 
Domicile Code 

 This Code system is referenced in the content logical definition of the following value sets: 

* [DomicileCode](ValueSet-domicile-code.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "domicile-code",
  "url" : "https://standards.digital.health.nz/ns/domicile-code",
  "version" : "3.0",
  "name" : "DomicileCode",
  "title" : "Domicile Code",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-18T23:25:53+00:00",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "Domicile Code",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 2059,
  "concept" : [
    {
      "code" : "0001",
      "display" : "Awanui"
    },
    {
      "code" : "0002",
      "display" : "Karikari Peninsula-Maungataniwha"
    },
    {
      "code" : "0003",
      "display" : "Taipa Bay - Mangonui"
    },
    {
      "code" : "0004",
      "display" : "Herekino"
    },
    {
      "code" : "0005",
      "display" : "Ahipara"
    },
    {
      "code" : "0006",
      "display" : "North Cape"
    },
    {
      "code" : "0007",
      "display" : "Houhora"
    },
    {
      "code" : "0008",
      "display" : "Motutangi - Kareponia"
    },
    {
      "code" : "0009",
      "display" : "Kaitaia West"
    },
    {
      "code" : "0010",
      "display" : "Kaitaia East"
    },
    {
      "code" : "0011",
      "display" : "Kaeo"
    },
    {
      "code" : "0012",
      "display" : "Mangapai - Matauri Bay"
    },
    {
      "code" : "0013",
      "display" : "Kohukohu"
    },
    {
      "code" : "0014",
      "display" : "Rawene"
    },
    {
      "code" : "0015",
      "display" : "Omapere and Opononi"
    },
    {
      "code" : "0016",
      "display" : "Hokianga North"
    },
    {
      "code" : "0017",
      "display" : "Hokianga South"
    },
    {
      "code" : "0019",
      "display" : "Russell"
    },
    {
      "code" : "0020",
      "display" : "Paihia"
    },
    {
      "code" : "0021",
      "display" : "Haruru Falls"
    },
    {
      "code" : "0022",
      "display" : "Opua East"
    },
    {
      "code" : "0023",
      "display" : "Kawakawa"
    },
    {
      "code" : "0024",
      "display" : "Moerewa"
    },
    {
      "code" : "0027",
      "display" : "Okaihau"
    },
    {
      "code" : "0028",
      "display" : "Ohaeawai"
    },
    {
      "code" : "0029",
      "display" : "Waihou Valley - Hupara"
    },
    {
      "code" : "0030",
      "display" : "Ngapuhi - Kaikou"
    },
    {
      "code" : "0031",
      "display" : "Kaikohe"
    },
    {
      "code" : "0032",
      "display" : "Opouteke - Tanekaha"
    },
    {
      "code" : "0034",
      "display" : "Marsden Point - Ruakaka"
    },
    {
      "code" : "0035",
      "display" : "Ngunguru"
    },
    {
      "code" : "0037",
      "display" : "Wharekohe - Oakleigh"
    },
    {
      "code" : "0038",
      "display" : "Maungatapere"
    },
    {
      "code" : "0039",
      "display" : "Waiotira - Springfield"
    },
    {
      "code" : "0041",
      "display" : "Springs Flat"
    },
    {
      "code" : "0042",
      "display" : "Three Mile Bush"
    },
    {
      "code" : "0043",
      "display" : "Te Hihi"
    },
    {
      "code" : "0045",
      "display" : "Otaika - Portland"
    },
    {
      "code" : "0046",
      "display" : "Kamo West"
    },
    {
      "code" : "0047",
      "display" : "Kamo East"
    },
    {
      "code" : "0048",
      "display" : "Tikipunga West"
    },
    {
      "code" : "0049",
      "display" : "Tikipunga East"
    },
    {
      "code" : "0050",
      "display" : "Whau Valley"
    },
    {
      "code" : "0051",
      "display" : "Otangarei"
    },
    {
      "code" : "0052",
      "display" : "Western Hills"
    },
    {
      "code" : "0053",
      "display" : "Kensington"
    },
    {
      "code" : "0054",
      "display" : "Mairtown"
    },
    {
      "code" : "0055",
      "display" : "Regent"
    },
    {
      "code" : "0056",
      "display" : "Woodhill"
    },
    {
      "code" : "0057",
      "display" : "Vinetown"
    },
    {
      "code" : "0058",
      "display" : "Whangarei Central"
    },
    {
      "code" : "0059",
      "display" : "Riverside"
    },
    {
      "code" : "0060",
      "display" : "Horahora"
    },
    {
      "code" : "0061",
      "display" : "Maunu"
    },
    {
      "code" : "0062",
      "display" : "Raumanga East"
    },
    {
      "code" : "0063",
      "display" : "Morningside"
    },
    {
      "code" : "0064",
      "display" : "Parahaki"
    },
    {
      "code" : "0065",
      "display" : "Raumanga West"
    },
    {
      "code" : "0066",
      "display" : "Port - Limeburners"
    },
    {
      "code" : "0068",
      "display" : "Onerahi"
    },
    {
      "code" : "0069",
      "display" : "Hikurangi"
    },
    {
      "code" : "0070",
      "display" : "Te Kopuru"
    },
    {
      "code" : "0071",
      "display" : "Kaipara Coastal"
    },
    {
      "code" : "0072",
      "display" : "Maungaru"
    },
    {
      "code" : "0073",
      "display" : "Dargaville"
    },
    {
      "code" : "0075",
      "display" : "Ruawai"
    },
    {
      "code" : "0076",
      "display" : "Kaiwaka"
    },
    {
      "code" : "0079",
      "display" : "Wellsford"
    },
    {
      "code" : "0080",
      "display" : "Leigh"
    },
    {
      "code" : "0081",
      "display" : "Warkworth"
    },
    {
      "code" : "0083",
      "display" : "Waipareira West"
    },
    {
      "code" : "0087",
      "display" : "Manly"
    },
    {
      "code" : "0091",
      "display" : "Dairy Flat - Redvale"
    },
    {
      "code" : "0092",
      "display" : "Paremoremo West"
    },
    {
      "code" : "0094",
      "display" : "Tauhoa - Puhoi"
    },
    {
      "code" : "0095",
      "display" : "Tahekeroa"
    },
    {
      "code" : "0096",
      "display" : "Kawau"
    },
    {
      "code" : "0097",
      "display" : "Snells Beach"
    },
    {
      "code" : "0100",
      "display" : "Kerikeri"
    },
    {
      "code" : "0102",
      "display" : "Opua West"
    },
    {
      "code" : "0103",
      "display" : "Bay of Islands"
    },
    {
      "code" : "0105",
      "display" : "Pokere - Waihaha"
    },
    {
      "code" : "0106",
      "display" : "Whangaruru Harbour"
    },
    {
      "code" : "0107",
      "display" : "Punaruku - Kiripaka"
    },
    {
      "code" : "0108",
      "display" : "Abbey Caves"
    },
    {
      "code" : "0109",
      "display" : "Sherwood Rise"
    },
    {
      "code" : "0110",
      "display" : "Maungaturoto"
    },
    {
      "code" : "0111",
      "display" : "Rehia-Oneriri"
    },
    {
      "code" : "0113",
      "display" : "Wairewa"
    },
    {
      "code" : "0114",
      "display" : "Hatfields Beach"
    },
    {
      "code" : "0115",
      "display" : "Orewa"
    },
    {
      "code" : "0117",
      "display" : "Matheson Bay"
    },
    {
      "code" : "0118",
      "display" : "Mangawhai"
    },
    {
      "code" : "0119",
      "display" : "Mangawhai Heads"
    },
    {
      "code" : "0120",
      "display" : "Army Bay"
    },
    {
      "code" : "0122",
      "display" : "Kapiro"
    },
    {
      "code" : "0123",
      "display" : "Waitangi"
    },
    {
      "code" : "0124",
      "display" : "Bream Bay"
    },
    {
      "code" : "0125",
      "display" : "Waipu"
    },
    {
      "code" : "0126",
      "display" : "Pataua-Whareora"
    },
    {
      "code" : "0127",
      "display" : "Parua Bay"
    },
    {
      "code" : "0128",
      "display" : "Bream Head"
    },
    {
      "code" : "0129",
      "display" : "Vipond"
    },
    {
      "code" : "0130",
      "display" : "Stanmore Bay West"
    },
    {
      "code" : "0131",
      "display" : "Stanmore Bay East"
    },
    {
      "code" : "0132",
      "display" : "Wade Heads"
    },
    {
      "code" : "0133",
      "display" : "Gulf Harbour"
    },
    {
      "code" : "0134",
      "display" : "Gulf Harbour Marina"
    },
    {
      "code" : "0135",
      "display" : "Waimauku"
    },
    {
      "code" : "0136",
      "display" : "Huapai"
    },
    {
      "code" : "0137",
      "display" : "Riverhead Urban"
    },
    {
      "code" : "0138",
      "display" : "Kumeu East"
    },
    {
      "code" : "0139",
      "display" : "Kumeu West"
    },
    {
      "code" : "0140",
      "display" : "Silverdale Central"
    },
    {
      "code" : "0141",
      "display" : "Red Beach West"
    },
    {
      "code" : "0142",
      "display" : "Red Beach East"
    },
    {
      "code" : "0143",
      "display" : "Weiti River"
    },
    {
      "code" : "0144",
      "display" : "Stillwater"
    },
    {
      "code" : "0145",
      "display" : "Silverdale South"
    },
    {
      "code" : "0146",
      "display" : "Silverdale North"
    },
    {
      "code" : "0147",
      "display" : "Orewa West"
    },
    {
      "code" : "0148",
      "display" : "Algies Bay"
    },
    {
      "code" : "0149",
      "display" : "Mahurangi"
    },
    {
      "code" : "0150",
      "display" : "Parakai Rural"
    },
    {
      "code" : "0151",
      "display" : "Parakai Urban"
    },
    {
      "code" : "0152",
      "display" : "Point Wells"
    },
    {
      "code" : "0153",
      "display" : "Omaha"
    },
    {
      "code" : "0154",
      "display" : "Matakana"
    },
    {
      "code" : "0155",
      "display" : "Cape Rodney"
    },
    {
      "code" : "0156",
      "display" : "Cape Rodney South"
    },
    {
      "code" : "0200",
      "display" : "South Head"
    },
    {
      "code" : "0203",
      "display" : "Rewiti"
    },
    {
      "code" : "0204",
      "display" : "Riverhead"
    },
    {
      "code" : "0206",
      "display" : "Awaruku"
    },
    {
      "code" : "0207",
      "display" : "Glamorgan"
    },
    {
      "code" : "0208",
      "display" : "Torbay"
    },
    {
      "code" : "0209",
      "display" : "Waiake"
    },
    {
      "code" : "0210",
      "display" : "Browns Bay"
    },
    {
      "code" : "0211",
      "display" : "Oaktree"
    },
    {
      "code" : "0212",
      "display" : "Rothesay Bay"
    },
    {
      "code" : "0213",
      "display" : "Murrays Bay"
    },
    {
      "code" : "0214",
      "display" : "Mairangi Bay"
    },
    {
      "code" : "0215",
      "display" : "Campbells Bay"
    },
    {
      "code" : "0216",
      "display" : "Castor Bay"
    },
    {
      "code" : "0217",
      "display" : "Crown Hill"
    },
    {
      "code" : "0218",
      "display" : "Lake Pupuke"
    },
    {
      "code" : "0219",
      "display" : "Westlake"
    },
    {
      "code" : "0220",
      "display" : "Takapuna Central"
    },
    {
      "code" : "0221",
      "display" : "Hauraki"
    },
    {
      "code" : "0222",
      "display" : "Seacliffe"
    },
    {
      "code" : "0223",
      "display" : "Bayswater"
    },
    {
      "code" : "0224",
      "display" : "Kaipatiki"
    },
    {
      "code" : "0225",
      "display" : "Windy Ridge"
    },
    {
      "code" : "0226",
      "display" : "Glenfield Central"
    },
    {
      "code" : "0227",
      "display" : "Glenfield North"
    },
    {
      "code" : "0228",
      "display" : "Glendhu"
    },
    {
      "code" : "0229",
      "display" : "Witheford"
    },
    {
      "code" : "0230",
      "display" : "Target Road"
    },
    {
      "code" : "0231",
      "display" : "Forrest Hill"
    },
    {
      "code" : "0232",
      "display" : "Sunnynook"
    },
    {
      "code" : "0233",
      "display" : "Monarch Park"
    },
    {
      "code" : "0234",
      "display" : "Sunnybrae"
    },
    {
      "code" : "0237",
      "display" : "Long Bay"
    },
    {
      "code" : "0238",
      "display" : "Paremoremo East"
    },
    {
      "code" : "0239",
      "display" : "Greenhithe"
    },
    {
      "code" : "0240",
      "display" : "Narrow Neck"
    },
    {
      "code" : "0241",
      "display" : "Mt Victoria"
    },
    {
      "code" : "0242",
      "display" : "Stanley Bay"
    },
    {
      "code" : "0243",
      "display" : "Ocean View"
    },
    {
      "code" : "0244",
      "display" : "Tuff Crater"
    },
    {
      "code" : "0245",
      "display" : "Northcote South"
    },
    {
      "code" : "0246",
      "display" : "Beachhaven North"
    },
    {
      "code" : "0247",
      "display" : "Beachhaven South"
    },
    {
      "code" : "0248",
      "display" : "Birkdale North"
    },
    {
      "code" : "0249",
      "display" : "Birkdale South"
    },
    {
      "code" : "0250",
      "display" : "Kauri Park"
    },
    {
      "code" : "0251",
      "display" : "Chelsea"
    },
    {
      "code" : "0252",
      "display" : "Birkenhead East"
    },
    {
      "code" : "0253",
      "display" : "Henderson North"
    },
    {
      "code" : "0254",
      "display" : "Henderson South"
    },
    {
      "code" : "0255",
      "display" : "Tangutu"
    },
    {
      "code" : "0256",
      "display" : "Woodglen"
    },
    {
      "code" : "0257",
      "display" : "Glen Eden East"
    },
    {
      "code" : "0259",
      "display" : "Fruitvale"
    },
    {
      "code" : "0260",
      "display" : "Rewarewa"
    },
    {
      "code" : "0261",
      "display" : "Glendene North"
    },
    {
      "code" : "0262",
      "display" : "Glendene South"
    },
    {
      "code" : "0263",
      "display" : "Kelston Central"
    },
    {
      "code" : "0264",
      "display" : "Sunnyvale"
    },
    {
      "code" : "0265",
      "display" : "Kaurilands"
    },
    {
      "code" : "0266",
      "display" : "Crum Park"
    },
    {
      "code" : "0267",
      "display" : "Titirangi South"
    },
    {
      "code" : "0268",
      "display" : "Green Bay"
    },
    {
      "code" : "0269",
      "display" : "Matipo"
    },
    {
      "code" : "0270",
      "display" : "Durham Green"
    },
    {
      "code" : "0271",
      "display" : "Te Atatu Central"
    },
    {
      "code" : "0272",
      "display" : "Edmonton"
    },
    {
      "code" : "0273",
      "display" : "Wakeling"
    },
    {
      "code" : "0274",
      "display" : "McLeod"
    },
    {
      "code" : "0275",
      "display" : "Konini"
    },
    {
      "code" : "0276",
      "display" : "Waima"
    },
    {
      "code" : "0277",
      "display" : "Laingholm"
    },
    {
      "code" : "0278",
      "display" : "Armour Bay"
    },
    {
      "code" : "0280",
      "display" : "Otimai"
    },
    {
      "code" : "0282",
      "display" : "Opanuku"
    },
    {
      "code" : "0285",
      "display" : "Sturges North"
    },
    {
      "code" : "0286",
      "display" : "Kingdale"
    },
    {
      "code" : "0287",
      "display" : "Fairdene"
    },
    {
      "code" : "0289",
      "display" : "Herald"
    },
    {
      "code" : "0292",
      "display" : "West Harbour"
    },
    {
      "code" : "0293",
      "display" : "Lucken Point"
    },
    {
      "code" : "0294",
      "display" : "Royal Heights"
    },
    {
      "code" : "0295",
      "display" : "West Massey"
    },
    {
      "code" : "0297",
      "display" : "Waimumu North"
    },
    {
      "code" : "0298",
      "display" : "Waimumu South"
    },
    {
      "code" : "0299",
      "display" : "Taupaki"
    },
    {
      "code" : "0301",
      "display" : "Helensville"
    },
    {
      "code" : "0302",
      "display" : "Whenuapai West"
    },
    {
      "code" : "0303",
      "display" : "Albany"
    },
    {
      "code" : "0307",
      "display" : "Unsworth Heights"
    },
    {
      "code" : "0308",
      "display" : "Westgate"
    },
    {
      "code" : "0309",
      "display" : "Royal Road West"
    },
    {
      "code" : "0310",
      "display" : "Fairview"
    },
    {
      "code" : "0311",
      "display" : "Northcross"
    },
    {
      "code" : "0312",
      "display" : "Pinehill"
    },
    {
      "code" : "0313",
      "display" : "Windsor Park"
    },
    {
      "code" : "0314",
      "display" : "North Harbour West"
    },
    {
      "code" : "0315",
      "display" : "North Harbour East"
    },
    {
      "code" : "0316",
      "display" : "New Lynn North"
    },
    {
      "code" : "0317",
      "display" : "New Lynn South"
    },
    {
      "code" : "0318",
      "display" : "Lynnmall"
    },
    {
      "code" : "0319",
      "display" : "Henderson West"
    },
    {
      "code" : "0320",
      "display" : "Palm Heights"
    },
    {
      "code" : "0321",
      "display" : "McLaren Park"
    },
    {
      "code" : "0322",
      "display" : "Urlich"
    },
    {
      "code" : "0323",
      "display" : "Starling Park"
    },
    {
      "code" : "0324",
      "display" : "Ranui Domain"
    },
    {
      "code" : "0325",
      "display" : "Ranui South"
    },
    {
      "code" : "0326",
      "display" : "Kaukapakapa Rural"
    },
    {
      "code" : "0327",
      "display" : "Kaukapakapa"
    },
    {
      "code" : "0328",
      "display" : "Helensville South"
    },
    {
      "code" : "0329",
      "display" : "Muriwai Beach"
    },
    {
      "code" : "0330",
      "display" : "Muriwai Valley"
    },
    {
      "code" : "0331",
      "display" : "Waitakere West"
    },
    {
      "code" : "0332",
      "display" : "Parrs Park West"
    },
    {
      "code" : "0333",
      "display" : "Parrs Park"
    },
    {
      "code" : "0334",
      "display" : "Oratia West"
    },
    {
      "code" : "0335",
      "display" : "Oratia"
    },
    {
      "code" : "0336",
      "display" : "Swanson"
    },
    {
      "code" : "0337",
      "display" : "Swanson South"
    },
    {
      "code" : "0338",
      "display" : "Hobsonville East"
    },
    {
      "code" : "0339",
      "display" : "Hobsonville South"
    },
    {
      "code" : "0340",
      "display" : "Birdwood West"
    },
    {
      "code" : "0341",
      "display" : "Birdwood East"
    },
    {
      "code" : "0400",
      "display" : "Waitakere"
    },
    {
      "code" : "0401",
      "display" : "Karekare"
    },
    {
      "code" : "0402",
      "display" : "Freemans Bay"
    },
    {
      "code" : "0404",
      "display" : "Newton"
    },
    {
      "code" : "0406",
      "display" : "Roberton"
    },
    {
      "code" : "0407",
      "display" : "Glenavon"
    },
    {
      "code" : "0408",
      "display" : "New Windsor"
    },
    {
      "code" : "0409",
      "display" : "Avondale South"
    },
    {
      "code" : "0410",
      "display" : "Blockhouse Bay"
    },
    {
      "code" : "0411",
      "display" : "Rosebank"
    },
    {
      "code" : "0412",
      "display" : "Avondale West"
    },
    {
      "code" : "0413",
      "display" : "Waterview"
    },
    {
      "code" : "0414",
      "display" : "Point Chevalier West"
    },
    {
      "code" : "0415",
      "display" : "Point Chevalier East"
    },
    {
      "code" : "0416",
      "display" : "Point Chevalier South"
    },
    {
      "code" : "0417",
      "display" : "Westmere"
    },
    {
      "code" : "0418",
      "display" : "Herne Bay"
    },
    {
      "code" : "0419",
      "display" : "St Marys"
    },
    {
      "code" : "0420",
      "display" : "Ponsonby West"
    },
    {
      "code" : "0421",
      "display" : "Ponsonby East"
    },
    {
      "code" : "0422",
      "display" : "Grey Lynn West"
    },
    {
      "code" : "0423",
      "display" : "Grey Lynn East"
    },
    {
      "code" : "0425",
      "display" : "Arch Hill"
    },
    {
      "code" : "0427",
      "display" : "Epsom North"
    },
    {
      "code" : "0428",
      "display" : "Epsom Central"
    },
    {
      "code" : "0429",
      "display" : "Epsom South"
    },
    {
      "code" : "0430",
      "display" : "Parnell East"
    },
    {
      "code" : "0431",
      "display" : "Parnell West"
    },
    {
      "code" : "0432",
      "display" : "Mt Hobson"
    },
    {
      "code" : "0433",
      "display" : "Remuera South"
    },
    {
      "code" : "0434",
      "display" : "Abbotts Park"
    },
    {
      "code" : "0435",
      "display" : "Remuera West"
    },
    {
      "code" : "0436",
      "display" : "Waitaramoa"
    },
    {
      "code" : "0437",
      "display" : "Orakei South"
    },
    {
      "code" : "0438",
      "display" : "Waiata"
    },
    {
      "code" : "0439",
      "display" : "Meadowbank North"
    },
    {
      "code" : "0440",
      "display" : "Meadowbank South"
    },
    {
      "code" : "0441",
      "display" : "Orakei North"
    },
    {
      "code" : "0442",
      "display" : "Mission Bay"
    },
    {
      "code" : "0443",
      "display" : "Kohimarama West"
    },
    {
      "code" : "0444",
      "display" : "Kohimarama East"
    },
    {
      "code" : "0445",
      "display" : "St Heliers"
    },
    {
      "code" : "0446",
      "display" : "Glendowie"
    },
    {
      "code" : "0447",
      "display" : "Glen Innes North"
    },
    {
      "code" : "0448",
      "display" : "Glen Innes West"
    },
    {
      "code" : "0449",
      "display" : "Glen Innes East"
    },
    {
      "code" : "0450",
      "display" : "Point England"
    },
    {
      "code" : "0452",
      "display" : "Newmarket"
    },
    {
      "code" : "0453",
      "display" : "Kingsland"
    },
    {
      "code" : "0454",
      "display" : "St Lukes"
    },
    {
      "code" : "0455",
      "display" : "Sandringham North"
    },
    {
      "code" : "0456",
      "display" : "Sandringham West"
    },
    {
      "code" : "0457",
      "display" : "Sandringham East"
    },
    {
      "code" : "0458",
      "display" : "Mt Albert Central"
    },
    {
      "code" : "0459",
      "display" : "Springleigh"
    },
    {
      "code" : "0460",
      "display" : "Owairaka West"
    },
    {
      "code" : "0461",
      "display" : "Owairaka East"
    },
    {
      "code" : "0463",
      "display" : "Sherbourne"
    },
    {
      "code" : "0464",
      "display" : "Balmoral"
    },
    {
      "code" : "0465",
      "display" : "Mt Eden East"
    },
    {
      "code" : "0466",
      "display" : "Maungawhau"
    },
    {
      "code" : "0467",
      "display" : "Mt Eden South"
    },
    {
      "code" : "0468",
      "display" : "Three Kings"
    },
    {
      "code" : "0469",
      "display" : "Royal Oak"
    },
    {
      "code" : "0470",
      "display" : "Hillsborough West"
    },
    {
      "code" : "0471",
      "display" : "Hillsborough East"
    },
    {
      "code" : "0472",
      "display" : "Walmsley"
    },
    {
      "code" : "0473",
      "display" : "Wesley"
    },
    {
      "code" : "0474",
      "display" : "Akarana"
    },
    {
      "code" : "0475",
      "display" : "Lynfield North"
    },
    {
      "code" : "0476",
      "display" : "Lynfield South"
    },
    {
      "code" : "0477",
      "display" : "Waikowhai West"
    },
    {
      "code" : "0478",
      "display" : "Waikowhai East"
    },
    {
      "code" : "0479",
      "display" : "Mt St John"
    },
    {
      "code" : "0480",
      "display" : "One Tree Hill Central"
    },
    {
      "code" : "0481",
      "display" : "One Tree Hill East"
    },
    {
      "code" : "0482",
      "display" : "Penrose"
    },
    {
      "code" : "0483",
      "display" : "Onehunga North West"
    },
    {
      "code" : "0484",
      "display" : "Onehunga North East"
    },
    {
      "code" : "0485",
      "display" : "Onehunga South West"
    },
    {
      "code" : "0486",
      "display" : "Onehunga South East"
    },
    {
      "code" : "0487",
      "display" : "Oranga"
    },
    {
      "code" : "0488",
      "display" : "Te Papapa"
    },
    {
      "code" : "0489",
      "display" : "Ellerslie North"
    },
    {
      "code" : "0490",
      "display" : "Ellerslie South"
    },
    {
      "code" : "0492",
      "display" : "Ferndale"
    },
    {
      "code" : "0493",
      "display" : "Hamlin"
    },
    {
      "code" : "0494",
      "display" : "Mt Wellington South"
    },
    {
      "code" : "0495",
      "display" : "Tamaki"
    },
    {
      "code" : "0496",
      "display" : "Panmure Basin"
    },
    {
      "code" : "0497",
      "display" : "Waiheke Island"
    },
    {
      "code" : "0499",
      "display" : "Islands - Motutapu Rangitoto Rakino"
    },
    {
      "code" : "0500",
      "display" : "Surrey Crescent"
    },
    {
      "code" : "0501",
      "display" : "St Lukes North"
    },
    {
      "code" : "0502",
      "display" : "Eden Terrace"
    },
    {
      "code" : "0503",
      "display" : "Mt Eden North"
    },
    {
      "code" : "0504",
      "display" : "Auckland Harbourside"
    },
    {
      "code" : "0505",
      "display" : "Auckland Central West"
    },
    {
      "code" : "0506",
      "display" : "Auckland Central East"
    },
    {
      "code" : "0507",
      "display" : "Grafton West"
    },
    {
      "code" : "0508",
      "display" : "Grafton East"
    },
    {
      "code" : "0509",
      "display" : "Bays-Waiheke Island"
    },
    {
      "code" : "0510",
      "display" : "Tidal-Waiheke Island"
    },
    {
      "code" : "0511",
      "display" : "St Johns"
    },
    {
      "code" : "0512",
      "display" : "Stonefields"
    },
    {
      "code" : "0513",
      "display" : "Mt Wellington Domain"
    },
    {
      "code" : "0514",
      "display" : "Mt Wellington West"
    },
    {
      "code" : "0515",
      "display" : "Mt Wellington North"
    },
    {
      "code" : "0600",
      "display" : "Great Barrier Island"
    },
    {
      "code" : "0601",
      "display" : "Paerata - Cape Hill"
    },
    {
      "code" : "0602",
      "display" : "Eden Road - Hill Top"
    },
    {
      "code" : "0604",
      "display" : "Redoubt"
    },
    {
      "code" : "0605",
      "display" : "Opuawhanga"
    },
    {
      "code" : "0606",
      "display" : "Patumahoe"
    },
    {
      "code" : "0607",
      "display" : "Kingseat"
    },
    {
      "code" : "0608",
      "display" : "Pokeno"
    },
    {
      "code" : "0609",
      "display" : "Hunua"
    },
    {
      "code" : "0611",
      "display" : "Awhitu"
    },
    {
      "code" : "0612",
      "display" : "Glenbrook"
    },
    {
      "code" : "0613",
      "display" : "Otaua"
    },
    {
      "code" : "0614",
      "display" : "Bombay"
    },
    {
      "code" : "0615",
      "display" : "Hingaia"
    },
    {
      "code" : "0616",
      "display" : "Whangapouri Creek"
    },
    {
      "code" : "0617",
      "display" : "Bremner"
    },
    {
      "code" : "0618",
      "display" : "Drury"
    },
    {
      "code" : "0619",
      "display" : "Runciman"
    },
    {
      "code" : "0620",
      "display" : "Mellons Bay"
    },
    {
      "code" : "0622",
      "display" : "Howick West"
    },
    {
      "code" : "0623",
      "display" : "Howick Central"
    },
    {
      "code" : "0625",
      "display" : "Otahuhu West"
    },
    {
      "code" : "0626",
      "display" : "Middlemore"
    },
    {
      "code" : "0627",
      "display" : "Papatoetoe West"
    },
    {
      "code" : "0628",
      "display" : "Papatoetoe North"
    },
    {
      "code" : "0629",
      "display" : "Papatoetoe Central"
    },
    {
      "code" : "0630",
      "display" : "Dingwall"
    },
    {
      "code" : "0631",
      "display" : "Papatoetoe East"
    },
    {
      "code" : "0632",
      "display" : "Puhinui"
    },
    {
      "code" : "0633",
      "display" : "Bucklands and Eastern Beaches"
    },
    {
      "code" : "0635",
      "display" : "Bleakhouse"
    },
    {
      "code" : "0636",
      "display" : "Pigeon Mountain North"
    },
    {
      "code" : "0637",
      "display" : "Murvale"
    },
    {
      "code" : "0638",
      "display" : "Pigeon Mountain South"
    },
    {
      "code" : "0639",
      "display" : "Aberfeldy"
    },
    {
      "code" : "0640",
      "display" : "Elsmore Park"
    },
    {
      "code" : "0641",
      "display" : "Halfmoon Bay"
    },
    {
      "code" : "0642",
      "display" : "Pakuranga North"
    },
    {
      "code" : "0643",
      "display" : "Sunnyhills"
    },
    {
      "code" : "0644",
      "display" : "Pakuranga Central"
    },
    {
      "code" : "0645",
      "display" : "Edgewater"
    },
    {
      "code" : "0646",
      "display" : "Pakuranga East"
    },
    {
      "code" : "0647",
      "display" : "Botany Downs"
    },
    {
      "code" : "0651",
      "display" : "Shelly Park"
    },
    {
      "code" : "0652",
      "display" : "Turanga"
    },
    {
      "code" : "0653",
      "display" : "Beachlands - Maraetai"
    },
    {
      "code" : "0655",
      "display" : "Otara West"
    },
    {
      "code" : "0656",
      "display" : "Otara North"
    },
    {
      "code" : "0657",
      "display" : "Otara East"
    },
    {
      "code" : "0658",
      "display" : "Otara South"
    },
    {
      "code" : "0659",
      "display" : "Ferguson"
    },
    {
      "code" : "0661",
      "display" : "Clover Park"
    },
    {
      "code" : "0662",
      "display" : "Redoubt North"
    },
    {
      "code" : "0665",
      "display" : "Ardmore"
    },
    {
      "code" : "0666",
      "display" : "Redoubt South"
    },
    {
      "code" : "0668",
      "display" : "Takanini West"
    },
    {
      "code" : "0669",
      "display" : "Ambury"
    },
    {
      "code" : "0670",
      "display" : "Mangere Bridge"
    },
    {
      "code" : "0671",
      "display" : "Mangere Central"
    },
    {
      "code" : "0672",
      "display" : "Mascot"
    },
    {
      "code" : "0673",
      "display" : "Arahanga"
    },
    {
      "code" : "0674",
      "display" : "Viscount"
    },
    {
      "code" : "0675",
      "display" : "Mangere South"
    },
    {
      "code" : "0676",
      "display" : "Mangere East"
    },
    {
      "code" : "0677",
      "display" : "Aorere"
    },
    {
      "code" : "0678",
      "display" : "Kohuora"
    },
    {
      "code" : "0680",
      "display" : "Mangere Station"
    },
    {
      "code" : "0681",
      "display" : "Harania North"
    },
    {
      "code" : "0682",
      "display" : "Harania West"
    },
    {
      "code" : "0683",
      "display" : "Harania East"
    },
    {
      "code" : "0685",
      "display" : "Wiri"
    },
    {
      "code" : "0686",
      "display" : "Burbank"
    },
    {
      "code" : "0687",
      "display" : "Homai West"
    },
    {
      "code" : "0688",
      "display" : "Rowandale"
    },
    {
      "code" : "0689",
      "display" : "Homai East"
    },
    {
      "code" : "0692",
      "display" : "Hillpark"
    },
    {
      "code" : "0693",
      "display" : "Manurewa East"
    },
    {
      "code" : "0694",
      "display" : "Manurewa Central"
    },
    {
      "code" : "0695",
      "display" : "Beaumont"
    },
    {
      "code" : "0696",
      "display" : "Leabank"
    },
    {
      "code" : "0697",
      "display" : "Wattle Farm"
    },
    {
      "code" : "0699",
      "display" : "Papakura Central"
    },
    {
      "code" : "0700",
      "display" : "Cockle Bay"
    },
    {
      "code" : "0701",
      "display" : "Maungamaungaroa"
    },
    {
      "code" : "0702",
      "display" : "Golfland"
    },
    {
      "code" : "0703",
      "display" : "Millhouse"
    },
    {
      "code" : "0704",
      "display" : "Burswood"
    },
    {
      "code" : "0706",
      "display" : "Dannemora"
    },
    {
      "code" : "0707",
      "display" : "Kilkenny"
    },
    {
      "code" : "0709",
      "display" : "Ormiston"
    },
    {
      "code" : "0711",
      "display" : "Flat Bush"
    },
    {
      "code" : "0712",
      "display" : "Donegal Park"
    },
    {
      "code" : "0713",
      "display" : "Totara Heights"
    },
    {
      "code" : "0714",
      "display" : "Randwick Park"
    },
    {
      "code" : "0715",
      "display" : "Hyperion"
    },
    {
      "code" : "0716",
      "display" : "Takanini North"
    },
    {
      "code" : "0717",
      "display" : "Takanini South"
    },
    {
      "code" : "0718",
      "display" : "Otahuhu North"
    },
    {
      "code" : "0719",
      "display" : "Fairburn"
    },
    {
      "code" : "0720",
      "display" : "Otahuhu East"
    },
    {
      "code" : "0721",
      "display" : "Bucklands Beach South"
    },
    {
      "code" : "0722",
      "display" : "Half Moon Bay Marina"
    },
    {
      "code" : "0723",
      "display" : "Favona West"
    },
    {
      "code" : "0724",
      "display" : "Favona North"
    },
    {
      "code" : "0725",
      "display" : "Favona South"
    },
    {
      "code" : "0726",
      "display" : "Weymouth West"
    },
    {
      "code" : "0727",
      "display" : "Weymouth East"
    },
    {
      "code" : "0728",
      "display" : "Clendon North"
    },
    {
      "code" : "0729",
      "display" : "Clendon South"
    },
    {
      "code" : "0730",
      "display" : "Clevedon"
    },
    {
      "code" : "0731",
      "display" : "Kawakawa-Orere"
    },
    {
      "code" : "0732",
      "display" : "Buckland"
    },
    {
      "code" : "0733",
      "display" : "Buckland South"
    },
    {
      "code" : "0734",
      "display" : "Paparata"
    },
    {
      "code" : "0735",
      "display" : "Mangatawhiri"
    },
    {
      "code" : "0736",
      "display" : "Kaiaua"
    },
    {
      "code" : "0737",
      "display" : "Highbrook"
    },
    {
      "code" : "0738",
      "display" : "Greenmount"
    },
    {
      "code" : "0739",
      "display" : "Point View"
    },
    {
      "code" : "0740",
      "display" : "Baverstock Oaks"
    },
    {
      "code" : "0741",
      "display" : "Mission Heights"
    },
    {
      "code" : "0742",
      "display" : "Wymondley"
    },
    {
      "code" : "0743",
      "display" : "Grange"
    },
    {
      "code" : "0744",
      "display" : "Redoubt East"
    },
    {
      "code" : "0745",
      "display" : "Mill Road"
    },
    {
      "code" : "0746",
      "display" : "Puhinui South"
    },
    {
      "code" : "0747",
      "display" : "Manukau Central"
    },
    {
      "code" : "0800",
      "display" : "Papakura North"
    },
    {
      "code" : "0801",
      "display" : "Papakura South"
    },
    {
      "code" : "0802",
      "display" : "Opaheke"
    },
    {
      "code" : "0803",
      "display" : "Rosehill"
    },
    {
      "code" : "0804",
      "display" : "Pahurehure"
    },
    {
      "code" : "0805",
      "display" : "Papakura East"
    },
    {
      "code" : "0806",
      "display" : "Massey Park"
    },
    {
      "code" : "0807",
      "display" : "North East Papakura"
    },
    {
      "code" : "0808",
      "display" : "Red Hill"
    },
    {
      "code" : "0809",
      "display" : "Pukekohe North"
    },
    {
      "code" : "0810",
      "display" : "Pukekohe West"
    },
    {
      "code" : "0811",
      "display" : "Bledisloe Park"
    },
    {
      "code" : "0814",
      "display" : "Tuakau"
    },
    {
      "code" : "0815",
      "display" : "Rotowaro"
    },
    {
      "code" : "0816",
      "display" : "Raglan"
    },
    {
      "code" : "0817",
      "display" : "Glen Massey"
    },
    {
      "code" : "0818",
      "display" : "Te Uku"
    },
    {
      "code" : "0819",
      "display" : "Te Pahu"
    },
    {
      "code" : "0820",
      "display" : "Onewhero"
    },
    {
      "code" : "0821",
      "display" : "Te Akau"
    },
    {
      "code" : "0822",
      "display" : "Te Kauwhata"
    },
    {
      "code" : "0825",
      "display" : "Matangi"
    },
    {
      "code" : "0826",
      "display" : "Whitikahu"
    },
    {
      "code" : "0827",
      "display" : "Taupiri Community"
    },
    {
      "code" : "0829",
      "display" : "Gordonton"
    },
    {
      "code" : "0830",
      "display" : "Kainui"
    },
    {
      "code" : "0831",
      "display" : "Tamahere - Tauwhare"
    },
    {
      "code" : "0833",
      "display" : "Waerenga"
    },
    {
      "code" : "0834",
      "display" : "Maramarua"
    },
    {
      "code" : "0835",
      "display" : "Meremere"
    },
    {
      "code" : "0836",
      "display" : "Huntly West"
    },
    {
      "code" : "0837",
      "display" : "Huntly East"
    },
    {
      "code" : "0838",
      "display" : "Cambridge North"
    },
    {
      "code" : "0839",
      "display" : "Cambridge West"
    },
    {
      "code" : "0840",
      "display" : "Cambridge Central"
    },
    {
      "code" : "0841",
      "display" : "Leamington West"
    },
    {
      "code" : "0842",
      "display" : "Leamington East"
    },
    {
      "code" : "0843",
      "display" : "Ohaupo"
    },
    {
      "code" : "0844",
      "display" : "Kihikihi"
    },
    {
      "code" : "0845",
      "display" : "Peacocke"
    },
    {
      "code" : "0846",
      "display" : "Temple View"
    },
    {
      "code" : "0848",
      "display" : "Te Kowhai"
    },
    {
      "code" : "0849",
      "display" : "Whatawhata"
    },
    {
      "code" : "0850",
      "display" : "Ngahinapouri"
    },
    {
      "code" : "0851",
      "display" : "Lake Cameron"
    },
    {
      "code" : "0852",
      "display" : "Te Rore"
    },
    {
      "code" : "0853",
      "display" : "Pirongia"
    },
    {
      "code" : "0854",
      "display" : "Pokuru"
    },
    {
      "code" : "0855",
      "display" : "Lake Ngaroto"
    },
    {
      "code" : "0856",
      "display" : "Tokanui"
    },
    {
      "code" : "0857",
      "display" : "Pukerimu"
    },
    {
      "code" : "0858",
      "display" : "Kaipaki"
    },
    {
      "code" : "0859",
      "display" : "Rotoorangi"
    },
    {
      "code" : "0860",
      "display" : "Te Rahu"
    },
    {
      "code" : "0861",
      "display" : "Kihikihi Flat"
    },
    {
      "code" : "0862",
      "display" : "Allen Road"
    },
    {
      "code" : "0863",
      "display" : "Rotongata"
    },
    {
      "code" : "0864",
      "display" : "Ngaruawahia"
    },
    {
      "code" : "0865",
      "display" : "Bryant"
    },
    {
      "code" : "0866",
      "display" : "Pukete"
    },
    {
      "code" : "0867",
      "display" : "Pukete West"
    },
    {
      "code" : "0868",
      "display" : "Te Rapa"
    },
    {
      "code" : "0870",
      "display" : "Nawton"
    },
    {
      "code" : "0872",
      "display" : "Dinsdale North"
    },
    {
      "code" : "0873",
      "display" : "Dinsdale South"
    },
    {
      "code" : "0874",
      "display" : "Beerescourt"
    },
    {
      "code" : "0875",
      "display" : "Maeroa"
    },
    {
      "code" : "0876",
      "display" : "Frankton Junction"
    },
    {
      "code" : "0877",
      "display" : "Swarbrick"
    },
    {
      "code" : "0878",
      "display" : "Hamilton Lake"
    },
    {
      "code" : "0879",
      "display" : "Melville"
    },
    {
      "code" : "0880",
      "display" : "Glenview"
    },
    {
      "code" : "0881",
      "display" : "Queenwood"
    },
    {
      "code" : "0882",
      "display" : "Chedworth"
    },
    {
      "code" : "0883",
      "display" : "Porritt"
    },
    {
      "code" : "0884",
      "display" : "Insoll"
    },
    {
      "code" : "0885",
      "display" : "Fairview Downs"
    },
    {
      "code" : "0886",
      "display" : "Chartwell"
    },
    {
      "code" : "0887",
      "display" : "Hamilton Central"
    },
    {
      "code" : "0888",
      "display" : "Clarkin"
    },
    {
      "code" : "0889",
      "display" : "Claudelands"
    },
    {
      "code" : "0890",
      "display" : "Enderley"
    },
    {
      "code" : "0891",
      "display" : "Peachgrove"
    },
    {
      "code" : "0892",
      "display" : "Hamilton East"
    },
    {
      "code" : "0893",
      "display" : "Naylor"
    },
    {
      "code" : "0894",
      "display" : "Bader"
    },
    {
      "code" : "0895",
      "display" : "University"
    },
    {
      "code" : "0896",
      "display" : "Silverdale"
    },
    {
      "code" : "0897",
      "display" : "Hillcrest West"
    },
    {
      "code" : "0898",
      "display" : "Riverlea"
    },
    {
      "code" : "0899",
      "display" : "Te Awamutu West"
    },
    {
      "code" : "0900",
      "display" : "Horsham Downs"
    },
    {
      "code" : "0901",
      "display" : "Rototuna"
    },
    {
      "code" : "0902",
      "display" : "Huntington"
    },
    {
      "code" : "0903",
      "display" : "Sylvester"
    },
    {
      "code" : "0904",
      "display" : "Flagstaff"
    },
    {
      "code" : "0905",
      "display" : "Burbush"
    },
    {
      "code" : "0906",
      "display" : "Rotokauri"
    },
    {
      "code" : "0907",
      "display" : "Crawshaw"
    },
    {
      "code" : "0908",
      "display" : "Grandview"
    },
    {
      "code" : "0909",
      "display" : "Brymer"
    },
    {
      "code" : "0910",
      "display" : "Waiuku West"
    },
    {
      "code" : "0911",
      "display" : "Waiuku East"
    },
    {
      "code" : "0912",
      "display" : "South Waiuku"
    },
    {
      "code" : "0913",
      "display" : "Pukeoware"
    },
    {
      "code" : "0914",
      "display" : "Newstead"
    },
    {
      "code" : "0915",
      "display" : "Eureka"
    },
    {
      "code" : "0916",
      "display" : "Hautapu"
    },
    {
      "code" : "0917",
      "display" : "Swayne"
    },
    {
      "code" : "0918",
      "display" : "Horotiu"
    },
    {
      "code" : "0919",
      "display" : "Te Rapa North"
    },
    {
      "code" : "1000",
      "display" : "Te Awamutu Central"
    },
    {
      "code" : "1001",
      "display" : "Te Awamutu East"
    },
    {
      "code" : "1002",
      "display" : "Te Awamutu South"
    },
    {
      "code" : "1003",
      "display" : "Kawhia Community"
    },
    {
      "code" : "1004",
      "display" : "Otorohanga"
    },
    {
      "code" : "1005",
      "display" : "Otorohanga Rural West"
    },
    {
      "code" : "1007",
      "display" : "Piopio Community"
    },
    {
      "code" : "1008",
      "display" : "Taharoa"
    },
    {
      "code" : "1009",
      "display" : "Mahoenui"
    },
    {
      "code" : "1010",
      "display" : "Marokopa"
    },
    {
      "code" : "1011",
      "display" : "Waipa Valley"
    },
    {
      "code" : "1012",
      "display" : "Tiroa"
    },
    {
      "code" : "1013",
      "display" : "Mokauiti"
    },
    {
      "code" : "1014",
      "display" : "Te Kuiti"
    },
    {
      "code" : "1015",
      "display" : "Omori"
    },
    {
      "code" : "1016",
      "display" : "Owhango"
    },
    {
      "code" : "1017",
      "display" : "Ohura"
    },
    {
      "code" : "1018",
      "display" : "Ngapuke"
    },
    {
      "code" : "1019",
      "display" : "Kuratau"
    },
    {
      "code" : "1020",
      "display" : "Raurimu"
    },
    {
      "code" : "1021",
      "display" : "National Park"
    },
    {
      "code" : "1022",
      "display" : "Otangiwai - Heao"
    },
    {
      "code" : "1023",
      "display" : "Tarrangower"
    },
    {
      "code" : "1024",
      "display" : "Taumarunui Central"
    },
    {
      "code" : "1025",
      "display" : "Sunshine - Hospital Hill"
    },
    {
      "code" : "1026",
      "display" : "Manunui"
    },
    {
      "code" : "1027",
      "display" : "Whitianga"
    },
    {
      "code" : "1028",
      "display" : "Coromandel"
    },
    {
      "code" : "1029",
      "display" : "Te Rerenga"
    },
    {
      "code" : "1030",
      "display" : "Whangamata"
    },
    {
      "code" : "1031",
      "display" : "Tairua"
    },
    {
      "code" : "1032",
      "display" : "Moanataiari"
    },
    {
      "code" : "1033",
      "display" : "Parawai"
    },
    {
      "code" : "1034",
      "display" : "Pauanui Beach"
    },
    {
      "code" : "1035",
      "display" : "Hikuai"
    },
    {
      "code" : "1036",
      "display" : "Te Puru - Thornton Bay"
    },
    {
      "code" : "1037",
      "display" : "Ngatea"
    },
    {
      "code" : "1038",
      "display" : "Hauraki Plains"
    },
    {
      "code" : "1039",
      "display" : "Turua"
    },
    {
      "code" : "1040",
      "display" : "Kerepehi"
    },
    {
      "code" : "1041",
      "display" : "Waihi Beach"
    },
    {
      "code" : "1043",
      "display" : "Paeroa"
    },
    {
      "code" : "1047",
      "display" : "Waitoa"
    },
    {
      "code" : "1050",
      "display" : "Waharoa"
    },
    {
      "code" : "1051",
      "display" : "Tirau"
    },
    {
      "code" : "1052",
      "display" : "Mangakaretu"
    },
    {
      "code" : "1053",
      "display" : "Kinleith"
    },
    {
      "code" : "1054",
      "display" : "Okauia"
    },
    {
      "code" : "1055",
      "display" : "Te Poi"
    },
    {
      "code" : "1056",
      "display" : "Tapapa"
    },
    {
      "code" : "1057",
      "display" : "Karapiro"
    },
    {
      "code" : "1058",
      "display" : "Hinuera"
    },
    {
      "code" : "1059",
      "display" : "Arapuni"
    },
    {
      "code" : "1060",
      "display" : "Lichfield"
    },
    {
      "code" : "1061",
      "display" : "Wawa"
    },
    {
      "code" : "1062",
      "display" : "Paraonui"
    },
    {
      "code" : "1063",
      "display" : "Parkdale"
    },
    {
      "code" : "1064",
      "display" : "Matarawa"
    },
    {
      "code" : "1065",
      "display" : "Stanley Park"
    },
    {
      "code" : "1066",
      "display" : "Tokoroa Central"
    },
    {
      "code" : "1067",
      "display" : "Aotea"
    },
    {
      "code" : "1068",
      "display" : "Strathmore"
    },
    {
      "code" : "1069",
      "display" : "Amisfield"
    },
    {
      "code" : "1071",
      "display" : "Putaruru"
    },
    {
      "code" : "1072",
      "display" : "Athenree"
    },
    {
      "code" : "1073",
      "display" : "Katikati Community"
    },
    {
      "code" : "1074",
      "display" : "Maketu Community"
    },
    {
      "code" : "1075",
      "display" : "Omokoroa"
    },
    {
      "code" : "1077",
      "display" : "Island View - Pios Beach"
    },
    {
      "code" : "1079",
      "display" : "Te Puna"
    },
    {
      "code" : "1081",
      "display" : "Matapihi"
    },
    {
      "code" : "1082",
      "display" : "Inlet - Tauranga Harbour Omokoroa"
    },
    {
      "code" : "1084",
      "display" : "Matakana Island"
    },
    {
      "code" : "1086",
      "display" : "Inlet - Tauranga Harbour North"
    },
    {
      "code" : "1087",
      "display" : "Minden"
    },
    {
      "code" : "1088",
      "display" : "Kaimai"
    },
    {
      "code" : "1089",
      "display" : "Ohauiti - Ngapeke"
    },
    {
      "code" : "1090",
      "display" : "Upper Papamoa"
    },
    {
      "code" : "1091",
      "display" : "Paengaroa"
    },
    {
      "code" : "1093",
      "display" : "Mt Maunganui North"
    },
    {
      "code" : "1095",
      "display" : "Arataki"
    },
    {
      "code" : "1096",
      "display" : "Te Maunga"
    },
    {
      "code" : "1097",
      "display" : "Matua"
    },
    {
      "code" : "1098",
      "display" : "Bellevue"
    },
    {
      "code" : "1099",
      "display" : "Otumoetai North"
    },
    {
      "code" : "1100",
      "display" : "Te Kawa"
    },
    {
      "code" : "1101",
      "display" : "Otorohanga Rural East"
    },
    {
      "code" : "1102",
      "display" : "Ohinemuri"
    },
    {
      "code" : "1103",
      "display" : "Waihi"
    },
    {
      "code" : "1104",
      "display" : "Tahuroa"
    },
    {
      "code" : "1106",
      "display" : "Te Aroha"
    },
    {
      "code" : "1108",
      "display" : "Inlet - Tauranga Harbour"
    },
    {
      "code" : "1109",
      "display" : "Waikareao Estuary"
    },
    {
      "code" : "1110",
      "display" : "Motuopae Island"
    },
    {
      "code" : "1112",
      "display" : "Kairua"
    },
    {
      "code" : "1113",
      "display" : "Bethlehem East"
    },
    {
      "code" : "1114",
      "display" : "Bethlehem"
    },
    {
      "code" : "1115",
      "display" : "Tahawai"
    },
    {
      "code" : "1116",
      "display" : "Aongatete"
    },
    {
      "code" : "1117",
      "display" : "Rangiuru"
    },
    {
      "code" : "1118",
      "display" : "Pongakawa"
    },
    {
      "code" : "1119",
      "display" : "Morrinsville West"
    },
    {
      "code" : "1120",
      "display" : "Morrinsville East"
    },
    {
      "code" : "1121",
      "display" : "Springdale"
    },
    {
      "code" : "1122",
      "display" : "Waihou-Walton"
    },
    {
      "code" : "1123",
      "display" : "Matamata North"
    },
    {
      "code" : "1124",
      "display" : "Matamata South"
    },
    {
      "code" : "1125",
      "display" : "Papamoa Beach East"
    },
    {
      "code" : "1126",
      "display" : "Palm Springs"
    },
    {
      "code" : "1127",
      "display" : "Doncaster"
    },
    {
      "code" : "1128",
      "display" : "Pacific View"
    },
    {
      "code" : "1129",
      "display" : "Palm Beach"
    },
    {
      "code" : "1130",
      "display" : "Gravatt"
    },
    {
      "code" : "1131",
      "display" : "Omanu"
    },
    {
      "code" : "1132",
      "display" : "Tauranga City-Marinas"
    },
    {
      "code" : "1200",
      "display" : "Otumoetai South"
    },
    {
      "code" : "1201",
      "display" : "Brookfield"
    },
    {
      "code" : "1202",
      "display" : "Te Reti"
    },
    {
      "code" : "1203",
      "display" : "Judea"
    },
    {
      "code" : "1204",
      "display" : "Gate Pa"
    },
    {
      "code" : "1206",
      "display" : "Yatton Park"
    },
    {
      "code" : "1207",
      "display" : "Poike"
    },
    {
      "code" : "1208",
      "display" : "Hairini"
    },
    {
      "code" : "1209",
      "display" : "Maungatapu"
    },
    {
      "code" : "1211",
      "display" : "Tauranga South"
    },
    {
      "code" : "1215",
      "display" : "Te Puke West"
    },
    {
      "code" : "1216",
      "display" : "Te Puke East"
    },
    {
      "code" : "1217",
      "display" : "Ngongotaha North"
    },
    {
      "code" : "1221",
      "display" : "Owhata West"
    },
    {
      "code" : "1222",
      "display" : "Owhata East"
    },
    {
      "code" : "1224",
      "display" : "Tikitere"
    },
    {
      "code" : "1225",
      "display" : "Kaingaroa Forest"
    },
    {
      "code" : "1228",
      "display" : "Reporoa"
    },
    {
      "code" : "1229",
      "display" : "Ngakuru"
    },
    {
      "code" : "1230",
      "display" : "Arahiwi"
    },
    {
      "code" : "1231",
      "display" : "Waiwhero"
    },
    {
      "code" : "1232",
      "display" : "Mamaku"
    },
    {
      "code" : "1233",
      "display" : "Selwyn Heights"
    },
    {
      "code" : "1234",
      "display" : "Western Heights"
    },
    {
      "code" : "1236",
      "display" : "Pukehangi North"
    },
    {
      "code" : "1237",
      "display" : "Pukehangi South"
    },
    {
      "code" : "1238",
      "display" : "Mangakakahi"
    },
    {
      "code" : "1239",
      "display" : "Sunnybrook"
    },
    {
      "code" : "1240",
      "display" : "Fordlands"
    },
    {
      "code" : "1241",
      "display" : "Utuhina"
    },
    {
      "code" : "1242",
      "display" : "Pomare"
    },
    {
      "code" : "1243",
      "display" : "Hillcrest"
    },
    {
      "code" : "1244",
      "display" : "Springfield"
    },
    {
      "code" : "1245",
      "display" : "Kawaha Point"
    },
    {
      "code" : "1246",
      "display" : "Koutu"
    },
    {
      "code" : "1247",
      "display" : "Ohinemutu"
    },
    {
      "code" : "1248",
      "display" : "Kuirau"
    },
    {
      "code" : "1249",
      "display" : "Victoria"
    },
    {
      "code" : "1250",
      "display" : "Glenholme East"
    },
    {
      "code" : "1251",
      "display" : "Glenholme West"
    },
    {
      "code" : "1252",
      "display" : "Fenton"
    },
    {
      "code" : "1253",
      "display" : "Whaka"
    },
    {
      "code" : "1254",
      "display" : "Mangakino"
    },
    {
      "code" : "1255",
      "display" : "Turangi"
    },
    {
      "code" : "1256",
      "display" : "Acacia Bay"
    },
    {
      "code" : "1257",
      "display" : "Wairakei - Aratiatia"
    },
    {
      "code" : "1258",
      "display" : "Maunganamu"
    },
    {
      "code" : "1260",
      "display" : "Taupo East"
    },
    {
      "code" : "1261",
      "display" : "Wharewaka"
    },
    {
      "code" : "1262",
      "display" : "Marotiri"
    },
    {
      "code" : "1264",
      "display" : "Rangitaiki"
    },
    {
      "code" : "1266",
      "display" : "Rangipo"
    },
    {
      "code" : "1267",
      "display" : "Te More"
    },
    {
      "code" : "1268",
      "display" : "Taharua"
    },
    {
      "code" : "1269",
      "display" : "Nukuhau"
    },
    {
      "code" : "1270",
      "display" : "Taupo Central"
    },
    {
      "code" : "1271",
      "display" : "Tauhara"
    },
    {
      "code" : "1272",
      "display" : "Hilltop"
    },
    {
      "code" : "1273",
      "display" : "Waipahihi"
    },
    {
      "code" : "1274",
      "display" : "Richmond Heights"
    },
    {
      "code" : "1276",
      "display" : "Matata"
    },
    {
      "code" : "1277",
      "display" : "Taneatua"
    },
    {
      "code" : "1278",
      "display" : "Edgecumbe"
    },
    {
      "code" : "1279",
      "display" : "Te Teko"
    },
    {
      "code" : "1280",
      "display" : "Whakatane North"
    },
    {
      "code" : "1281",
      "display" : "Coastlands"
    },
    {
      "code" : "1282",
      "display" : "Whakatane West"
    },
    {
      "code" : "1283",
      "display" : "Trident"
    },
    {
      "code" : "1285",
      "display" : "Orini"
    },
    {
      "code" : "1287",
      "display" : "Poroporo"
    },
    {
      "code" : "1288",
      "display" : "Otakiri"
    },
    {
      "code" : "1289",
      "display" : "Rotoma"
    },
    {
      "code" : "1290",
      "display" : "Matahina - Minginui"
    },
    {
      "code" : "1291",
      "display" : "Waimana"
    },
    {
      "code" : "1292",
      "display" : "Urewera"
    },
    {
      "code" : "1293",
      "display" : "Kawerau"
    },
    {
      "code" : "1294",
      "display" : "Murupara"
    },
    {
      "code" : "1296",
      "display" : "Te Kaha"
    },
    {
      "code" : "1298",
      "display" : "Cape Runaway"
    },
    {
      "code" : "1299",
      "display" : "Oponae"
    },
    {
      "code" : "1300",
      "display" : "Tauranga Hospital"
    },
    {
      "code" : "1302",
      "display" : "Tauranga Central"
    },
    {
      "code" : "1303",
      "display" : "Sulphur Point"
    },
    {
      "code" : "1304",
      "display" : "Ngongotaha South"
    },
    {
      "code" : "1305",
      "display" : "Poets Corner"
    },
    {
      "code" : "1306",
      "display" : "Ngapuna"
    },
    {
      "code" : "1307",
      "display" : "Owhata South"
    },
    {
      "code" : "1308",
      "display" : "Lynmore"
    },
    {
      "code" : "1309",
      "display" : "Tarawera"
    },
    {
      "code" : "1310",
      "display" : "Golden Springs"
    },
    {
      "code" : "1311",
      "display" : "Fairy Springs"
    },
    {
      "code" : "1312",
      "display" : "Ohope"
    },
    {
      "code" : "1313",
      "display" : "Allandale - Mokorua"
    },
    {
      "code" : "1314",
      "display" : "Inlet-Ohiwa Harbour West"
    },
    {
      "code" : "1315",
      "display" : "Maraetotara"
    },
    {
      "code" : "1316",
      "display" : "Opotiki"
    },
    {
      "code" : "1317",
      "display" : "Inlet-Ohiwa Harbour East"
    },
    {
      "code" : "1318",
      "display" : "Waiotahi"
    },
    {
      "code" : "1319",
      "display" : "Greerton"
    },
    {
      "code" : "1320",
      "display" : "Pyes Pa"
    },
    {
      "code" : "1321",
      "display" : "Hamurana"
    },
    {
      "code" : "1322",
      "display" : "Inland Water-Lake Rotorua"
    },
    {
      "code" : "1323",
      "display" : "Rangatira Park"
    },
    {
      "code" : "1324",
      "display" : "Rangatira"
    },
    {
      "code" : "1325",
      "display" : "Lakewood"
    },
    {
      "code" : "1326",
      "display" : "Kaitemako"
    },
    {
      "code" : "1327",
      "display" : "Welcome Bay West"
    },
    {
      "code" : "1328",
      "display" : "Welcome Bay East"
    },
    {
      "code" : "1330",
      "display" : "Kinloch"
    },
    {
      "code" : "1331",
      "display" : "Tatua"
    },
    {
      "code" : "1332",
      "display" : "Oruanui"
    },
    {
      "code" : "1333",
      "display" : "Broadlands"
    },
    {
      "code" : "1334",
      "display" : "Waitahanui"
    },
    {
      "code" : "1335",
      "display" : "Tongariro"
    },
    {
      "code" : "1336",
      "display" : "Motuoapa"
    },
    {
      "code" : "1337",
      "display" : "Tokaanu"
    },
    {
      "code" : "1400",
      "display" : "East Cape"
    },
    {
      "code" : "1401",
      "display" : "Ruatoria"
    },
    {
      "code" : "1402",
      "display" : "Tokomaru Bay"
    },
    {
      "code" : "1403",
      "display" : "Tarndale - Rakauroa"
    },
    {
      "code" : "1404",
      "display" : "Te Karaka"
    },
    {
      "code" : "1405",
      "display" : "Patutahi"
    },
    {
      "code" : "1406",
      "display" : "Makaraka"
    },
    {
      "code" : "1407",
      "display" : "Matokitoki"
    },
    {
      "code" : "1408",
      "display" : "Wainui"
    },
    {
      "code" : "1409",
      "display" : "Wharekaka"
    },
    {
      "code" : "1410",
      "display" : "Tiniroto"
    },
    {
      "code" : "1411",
      "display" : "Manutuke"
    },
    {
      "code" : "1412",
      "display" : "Tolaga Bay"
    },
    {
      "code" : "1413",
      "display" : "Mangapapa"
    },
    {
      "code" : "1414",
      "display" : "Te Hapara"
    },
    {
      "code" : "1415",
      "display" : "Gisborne Airport"
    },
    {
      "code" : "1416",
      "display" : "Whataupoko"
    },
    {
      "code" : "1417",
      "display" : "Gisborne Central"
    },
    {
      "code" : "1419",
      "display" : "Kaiti South"
    },
    {
      "code" : "1420",
      "display" : "Tamarau"
    },
    {
      "code" : "1421",
      "display" : "Riverdale"
    },
    {
      "code" : "1422",
      "display" : "Tuai"
    },
    {
      "code" : "1423",
      "display" : "Frasertown"
    },
    {
      "code" : "1425",
      "display" : "Ruakituri - Morere"
    },
    {
      "code" : "1426",
      "display" : "Raupunga"
    },
    {
      "code" : "1427",
      "display" : "Whakaki"
    },
    {
      "code" : "1428",
      "display" : "Nuhaka"
    },
    {
      "code" : "1429",
      "display" : "Mahia"
    },
    {
      "code" : "1430",
      "display" : "Wairoa"
    },
    {
      "code" : "1431",
      "display" : "Bay View"
    },
    {
      "code" : "1432",
      "display" : "Poraiti"
    },
    {
      "code" : "1433",
      "display" : "Meeanee"
    },
    {
      "code" : "1434",
      "display" : "Awatoto"
    },
    {
      "code" : "1436",
      "display" : "Karamu"
    },
    {
      "code" : "1437",
      "display" : "Whakatu"
    },
    {
      "code" : "1438",
      "display" : "Clive"
    },
    {
      "code" : "1439",
      "display" : "Haumoana"
    },
    {
      "code" : "1441",
      "display" : "Irongate"
    },
    {
      "code" : "1442",
      "display" : "Longlands South"
    },
    {
      "code" : "1443",
      "display" : "Tangoio"
    },
    {
      "code" : "1444",
      "display" : "Eskdale"
    },
    {
      "code" : "1445",
      "display" : "Sherenden - Puketapu"
    },
    {
      "code" : "1446",
      "display" : "Omahu"
    },
    {
      "code" : "1447",
      "display" : "Waiohiki"
    },
    {
      "code" : "1448",
      "display" : "Pakowhai"
    },
    {
      "code" : "1449",
      "display" : "Maraekakaho"
    },
    {
      "code" : "1450",
      "display" : "Bridge Pa"
    },
    {
      "code" : "1451",
      "display" : "Poukawa"
    },
    {
      "code" : "1452",
      "display" : "Pakipaki"
    },
    {
      "code" : "1453",
      "display" : "Waimarama"
    },
    {
      "code" : "1454",
      "display" : "Tutira"
    },
    {
      "code" : "1455",
      "display" : "Puketitiri"
    },
    {
      "code" : "1456",
      "display" : "Whanawhana"
    },
    {
      "code" : "1457",
      "display" : "Westshore"
    },
    {
      "code" : "1458",
      "display" : "Ahuriri"
    },
    {
      "code" : "1459",
      "display" : "Onekawa Central"
    },
    {
      "code" : "1460",
      "display" : "Onekawa West"
    },
    {
      "code" : "1461",
      "display" : "Onekawa South"
    },
    {
      "code" : "1462",
      "display" : "Marewa"
    },
    {
      "code" : "1463",
      "display" : "Maraenui"
    },
    {
      "code" : "1464",
      "display" : "Hospital Hill"
    },
    {
      "code" : "1465",
      "display" : "Bluff Hill"
    },
    {
      "code" : "1466",
      "display" : "Nelson Park"
    },
    {
      "code" : "1467",
      "display" : "McLean Park"
    },
    {
      "code" : "1468",
      "display" : "Tamatea North"
    },
    {
      "code" : "1469",
      "display" : "Tamatea South"
    },
    {
      "code" : "1470",
      "display" : "Greenmeadows"
    },
    {
      "code" : "1471",
      "display" : "Taradale North"
    },
    {
      "code" : "1472",
      "display" : "Taradale South"
    },
    {
      "code" : "1473",
      "display" : "Pirimai"
    },
    {
      "code" : "1474",
      "display" : "Mahora"
    },
    {
      "code" : "1475",
      "display" : "St Leonards"
    },
    {
      "code" : "1477",
      "display" : "Raureka"
    },
    {
      "code" : "1478",
      "display" : "Mayfair"
    },
    {
      "code" : "1479",
      "display" : "Parkvale"
    },
    {
      "code" : "1480",
      "display" : "Hastings Central"
    },
    {
      "code" : "1481",
      "display" : "Akina"
    },
    {
      "code" : "1482",
      "display" : "Woolwich"
    },
    {
      "code" : "1483",
      "display" : "Camberley"
    },
    {
      "code" : "1484",
      "display" : "Kingsley - Chatham"
    },
    {
      "code" : "1485",
      "display" : "Lochain"
    },
    {
      "code" : "1486",
      "display" : "Flaxmere East"
    },
    {
      "code" : "1487",
      "display" : "Anderson Park"
    },
    {
      "code" : "1490",
      "display" : "Takapau"
    },
    {
      "code" : "1491",
      "display" : "Waipawa"
    },
    {
      "code" : "1492",
      "display" : "Tikokino"
    },
    {
      "code" : "1493",
      "display" : "Otane"
    },
    {
      "code" : "1495",
      "display" : "Porangahau"
    },
    {
      "code" : "1498",
      "display" : "Owahanga"
    },
    {
      "code" : "1499",
      "display" : "Mara"
    },
    {
      "code" : "1500",
      "display" : "Twyford"
    },
    {
      "code" : "1501",
      "display" : "Brookvale"
    },
    {
      "code" : "1502",
      "display" : "Frimley"
    },
    {
      "code" : "1504",
      "display" : "Waipukurau"
    },
    {
      "code" : "1505",
      "display" : "Elsthorpe - Flemington"
    },
    {
      "code" : "1506",
      "display" : "Norsewood - Herbertville"
    },
    {
      "code" : "1507",
      "display" : "Kaiti North"
    },
    {
      "code" : "1508",
      "display" : "Outer Kaiti"
    },
    {
      "code" : "1509",
      "display" : "Maungataniwha"
    },
    {
      "code" : "1510",
      "display" : "Inland Water-Lake Waikaremoana"
    },
    {
      "code" : "1511",
      "display" : "Bare Island"
    },
    {
      "code" : "1512",
      "display" : "Iona"
    },
    {
      "code" : "1513",
      "display" : "Havelock Hills"
    },
    {
      "code" : "1514",
      "display" : "Te Mata"
    },
    {
      "code" : "1515",
      "display" : "Havelock North Central"
    },
    {
      "code" : "1516",
      "display" : "Te Mata Hills"
    },
    {
      "code" : "1600",
      "display" : "Dannevirke West"
    },
    {
      "code" : "1601",
      "display" : "Dannevirke East"
    },
    {
      "code" : "1602",
      "display" : "Papatawa"
    },
    {
      "code" : "1603",
      "display" : "Woodville"
    },
    {
      "code" : "1604",
      "display" : "Urenui"
    },
    {
      "code" : "1605",
      "display" : "Okoki - Okau"
    },
    {
      "code" : "1606",
      "display" : "Oakura"
    },
    {
      "code" : "1607",
      "display" : "Bell Block"
    },
    {
      "code" : "1608",
      "display" : "Paraite"
    },
    {
      "code" : "1609",
      "display" : "Glen Avon"
    },
    {
      "code" : "1610",
      "display" : "Bowden"
    },
    {
      "code" : "1611",
      "display" : "Mangaoraka"
    },
    {
      "code" : "1612",
      "display" : "Carrington"
    },
    {
      "code" : "1613",
      "display" : "Highlands Park"
    },
    {
      "code" : "1614",
      "display" : "Fernleigh"
    },
    {
      "code" : "1615",
      "display" : "Barrett"
    },
    {
      "code" : "1616",
      "display" : "Omata"
    },
    {
      "code" : "1617",
      "display" : "Lepperton"
    },
    {
      "code" : "1618",
      "display" : "Kaitake"
    },
    {
      "code" : "1619",
      "display" : "Okato"
    },
    {
      "code" : "1620",
      "display" : "Waitara West"
    },
    {
      "code" : "1621",
      "display" : "Waitara East"
    },
    {
      "code" : "1622",
      "display" : "Moturoa"
    },
    {
      "code" : "1623",
      "display" : "Lynmouth"
    },
    {
      "code" : "1624",
      "display" : "Spotswood"
    },
    {
      "code" : "1625",
      "display" : "Marfell"
    },
    {
      "code" : "1626",
      "display" : "Upper Westown"
    },
    {
      "code" : "1627",
      "display" : "Westown"
    },
    {
      "code" : "1628",
      "display" : "New Plymouth Central"
    },
    {
      "code" : "1629",
      "display" : "Kawaroa"
    },
    {
      "code" : "1630",
      "display" : "Mount Bryan"
    },
    {
      "code" : "1631",
      "display" : "Marsland Hill"
    },
    {
      "code" : "1632",
      "display" : "Fitzroy"
    },
    {
      "code" : "1633",
      "display" : "Welbourn"
    },
    {
      "code" : "1634",
      "display" : "Merrilands"
    },
    {
      "code" : "1635",
      "display" : "Frankleigh"
    },
    {
      "code" : "1636",
      "display" : "Struan Park"
    },
    {
      "code" : "1637",
      "display" : "Egmont Village"
    },
    {
      "code" : "1638",
      "display" : "Kaimata"
    },
    {
      "code" : "1639",
      "display" : "Inglewood"
    },
    {
      "code" : "1640",
      "display" : "Midhurst"
    },
    {
      "code" : "1641",
      "display" : "Whangamomona"
    },
    {
      "code" : "1642",
      "display" : "Douglas"
    },
    {
      "code" : "1643",
      "display" : "Toko"
    },
    {
      "code" : "1644",
      "display" : "Pembroke"
    },
    {
      "code" : "1645",
      "display" : "Stratford West"
    },
    {
      "code" : "1646",
      "display" : "Stratford East"
    },
    {
      "code" : "1647",
      "display" : "Opunake"
    },
    {
      "code" : "1648",
      "display" : "Rahotu"
    },
    {
      "code" : "1649",
      "display" : "Kahui"
    },
    {
      "code" : "1650",
      "display" : "Kaponga"
    },
    {
      "code" : "1651",
      "display" : "Mangatoki - Moeroa"
    },
    {
      "code" : "1652",
      "display" : "Eltham"
    },
    {
      "code" : "1653",
      "display" : "Kapuni"
    },
    {
      "code" : "1654",
      "display" : "Manaia"
    },
    {
      "code" : "1655",
      "display" : "Normanby"
    },
    {
      "code" : "1661",
      "display" : "Ohangai"
    },
    {
      "code" : "1662",
      "display" : "Okaiawa"
    },
    {
      "code" : "1663",
      "display" : "Waitotara"
    },
    {
      "code" : "1664",
      "display" : "Whenuakura"
    },
    {
      "code" : "1665",
      "display" : "Makakaho"
    },
    {
      "code" : "1666",
      "display" : "Patea"
    },
    {
      "code" : "1667",
      "display" : "Waverley"
    },
    {
      "code" : "1668",
      "display" : "Tangiwai"
    },
    {
      "code" : "1669",
      "display" : "Ohakune"
    },
    {
      "code" : "1670",
      "display" : "Raetihi"
    },
    {
      "code" : "1671",
      "display" : "Otamatea"
    },
    {
      "code" : "1672",
      "display" : "Blueskin"
    },
    {
      "code" : "1673",
      "display" : "Maxwell"
    },
    {
      "code" : "1674",
      "display" : "Castlecliff North"
    },
    {
      "code" : "1675",
      "display" : "Castlecliff South"
    },
    {
      "code" : "1676",
      "display" : "Mosston"
    },
    {
      "code" : "1677",
      "display" : "Balgownie"
    },
    {
      "code" : "1678",
      "display" : "Tawhero"
    },
    {
      "code" : "1679",
      "display" : "Gonville South"
    },
    {
      "code" : "1680",
      "display" : "Gonville East"
    },
    {
      "code" : "1681",
      "display" : "Gonville West"
    },
    {
      "code" : "1682",
      "display" : "Springvale West"
    },
    {
      "code" : "1683",
      "display" : "Springvale East"
    },
    {
      "code" : "1684",
      "display" : "Wanganui Collegiate"
    },
    {
      "code" : "1685",
      "display" : "Laird Park"
    },
    {
      "code" : "1686",
      "display" : "Wanganui Central"
    },
    {
      "code" : "1687",
      "display" : "Spriggens Park"
    },
    {
      "code" : "1688",
      "display" : "Cooks Gardens"
    },
    {
      "code" : "1689",
      "display" : "St Johns Hill"
    },
    {
      "code" : "1690",
      "display" : "Lower Aramoho"
    },
    {
      "code" : "1691",
      "display" : "Upper Aramoho"
    },
    {
      "code" : "1692",
      "display" : "Williams Domain"
    },
    {
      "code" : "1693",
      "display" : "Wembley Park"
    },
    {
      "code" : "1694",
      "display" : "Kowhai Park"
    },
    {
      "code" : "1695",
      "display" : "Bastia Hill"
    },
    {
      "code" : "1696",
      "display" : "Durie Hill"
    },
    {
      "code" : "1697",
      "display" : "Putiki"
    },
    {
      "code" : "1698",
      "display" : "Marybank - Gordon Park"
    },
    {
      "code" : "1699",
      "display" : "Fordell - Kakatahi"
    },
    {
      "code" : "1700",
      "display" : "Hawera North"
    },
    {
      "code" : "1701",
      "display" : "Hawera South"
    },
    {
      "code" : "1702",
      "display" : "Ohawe Beach"
    },
    {
      "code" : "1703",
      "display" : "Tawhiti"
    },
    {
      "code" : "1704",
      "display" : "Waingongoro"
    },
    {
      "code" : "1705",
      "display" : "Hawera West"
    },
    {
      "code" : "1800",
      "display" : "Waiouru"
    },
    {
      "code" : "1801",
      "display" : "Mangaweka"
    },
    {
      "code" : "1802",
      "display" : "Hunterville"
    },
    {
      "code" : "1803",
      "display" : "Ratana Community"
    },
    {
      "code" : "1804",
      "display" : "Bulls"
    },
    {
      "code" : "1805",
      "display" : "Ngamatea"
    },
    {
      "code" : "1806",
      "display" : "Moawhango"
    },
    {
      "code" : "1807",
      "display" : "Pohonui - Porewa"
    },
    {
      "code" : "1809",
      "display" : "Koitiata"
    },
    {
      "code" : "1810",
      "display" : "Taihape"
    },
    {
      "code" : "1812",
      "display" : "Kiwitea"
    },
    {
      "code" : "1813",
      "display" : "Pohangina"
    },
    {
      "code" : "1814",
      "display" : "Ashhurst"
    },
    {
      "code" : "1815",
      "display" : "Stoney Creek"
    },
    {
      "code" : "1816",
      "display" : "Whakarongo"
    },
    {
      "code" : "1817",
      "display" : "Oroua Bridge"
    },
    {
      "code" : "1818",
      "display" : "Maewa"
    },
    {
      "code" : "1819",
      "display" : "Halcombe"
    },
    {
      "code" : "1820",
      "display" : "Tokorangi - Hiwinui"
    },
    {
      "code" : "1821",
      "display" : "Feilding North"
    },
    {
      "code" : "1822",
      "display" : "Feilding West"
    },
    {
      "code" : "1823",
      "display" : "Feilding Central"
    },
    {
      "code" : "1824",
      "display" : "Feilding East"
    },
    {
      "code" : "1825",
      "display" : "Sanson"
    },
    {
      "code" : "1826",
      "display" : "Rongotea"
    },
    {
      "code" : "1827",
      "display" : "Tangimoana"
    },
    {
      "code" : "1828",
      "display" : "Himatangi Beach"
    },
    {
      "code" : "1829",
      "display" : "Foxton Beach"
    },
    {
      "code" : "1830",
      "display" : "Rakiraki"
    },
    {
      "code" : "1831",
      "display" : "Ohakea"
    },
    {
      "code" : "1832",
      "display" : "Oroua Downs - Waitohi"
    },
    {
      "code" : "1835",
      "display" : "Kairanga"
    },
    {
      "code" : "1836",
      "display" : "Longburn"
    },
    {
      "code" : "1837",
      "display" : "Massey University"
    },
    {
      "code" : "1838",
      "display" : "Linton Military Camp"
    },
    {
      "code" : "1839",
      "display" : "Kauwhata"
    },
    {
      "code" : "1840",
      "display" : "Turitea"
    },
    {
      "code" : "1841",
      "display" : "Milson"
    },
    {
      "code" : "1842",
      "display" : "Kelvin Grove"
    },
    {
      "code" : "1843",
      "display" : "Takaro"
    },
    {
      "code" : "1844",
      "display" : "Cloverlea"
    },
    {
      "code" : "1845",
      "display" : "Palmerston North Hospital"
    },
    {
      "code" : "1846",
      "display" : "Papaeoia"
    },
    {
      "code" : "1847",
      "display" : "Roslyn"
    },
    {
      "code" : "1848",
      "display" : "Terrace End"
    },
    {
      "code" : "1849",
      "display" : "Highbury"
    },
    {
      "code" : "1850",
      "display" : "Westbrook"
    },
    {
      "code" : "1851",
      "display" : "Palmerston North Central"
    },
    {
      "code" : "1852",
      "display" : "Awapuni North"
    },
    {
      "code" : "1853",
      "display" : "Awapuni West"
    },
    {
      "code" : "1854",
      "display" : "Awapuni South"
    },
    {
      "code" : "1855",
      "display" : "West End"
    },
    {
      "code" : "1856",
      "display" : "Hokowhitu West"
    },
    {
      "code" : "1857",
      "display" : "Hokowhitu Lagoon"
    },
    {
      "code" : "1858",
      "display" : "Hokowhitu East"
    },
    {
      "code" : "1859",
      "display" : "Aokautere"
    },
    {
      "code" : "1860",
      "display" : "Shannon"
    },
    {
      "code" : "1861",
      "display" : "Waitarere"
    },
    {
      "code" : "1862",
      "display" : "Waikanae Beach"
    },
    {
      "code" : "1864",
      "display" : "Waikanae East"
    },
    {
      "code" : "1865",
      "display" : "Tokomaru"
    },
    {
      "code" : "1866",
      "display" : "Opiki"
    },
    {
      "code" : "1867",
      "display" : "Kaitawa"
    },
    {
      "code" : "1868",
      "display" : "Lake Horowhenua"
    },
    {
      "code" : "1869",
      "display" : "Waiopehu"
    },
    {
      "code" : "1870",
      "display" : "Kohitere"
    },
    {
      "code" : "1871",
      "display" : "Mangaore - Manakau"
    },
    {
      "code" : "1872",
      "display" : "Otaki Forks"
    },
    {
      "code" : "1873",
      "display" : "Te Horo"
    },
    {
      "code" : "1874",
      "display" : "Levin North"
    },
    {
      "code" : "1875",
      "display" : "Levin West"
    },
    {
      "code" : "1876",
      "display" : "Playford Park"
    },
    {
      "code" : "1877",
      "display" : "Levin South"
    },
    {
      "code" : "1878",
      "display" : "Levin East"
    },
    {
      "code" : "1879",
      "display" : "Otaki"
    },
    {
      "code" : "1880",
      "display" : "Heretaunga Park"
    },
    {
      "code" : "1881",
      "display" : "Trentham South"
    },
    {
      "code" : "1882",
      "display" : "Pinehaven"
    },
    {
      "code" : "1884",
      "display" : "Glendale"
    },
    {
      "code" : "1885",
      "display" : "Parkway"
    },
    {
      "code" : "1886",
      "display" : "Fernlea"
    },
    {
      "code" : "1887",
      "display" : "Arakura"
    },
    {
      "code" : "1888",
      "display" : "Homedale West"
    },
    {
      "code" : "1889",
      "display" : "Homedale East"
    },
    {
      "code" : "1890",
      "display" : "Pencarrow"
    },
    {
      "code" : "1891",
      "display" : "Pauatahanui"
    },
    {
      "code" : "1892",
      "display" : "Endeavour"
    },
    {
      "code" : "1893",
      "display" : "Resolution"
    },
    {
      "code" : "1894",
      "display" : "Adventure"
    },
    {
      "code" : "1895",
      "display" : "Paekakariki Hill"
    },
    {
      "code" : "1896",
      "display" : "Paraparaumu Beach North"
    },
    {
      "code" : "1897",
      "display" : "Otaihanga"
    },
    {
      "code" : "1898",
      "display" : "Paraparaumu Beach South"
    },
    {
      "code" : "1899",
      "display" : "Paraparaumu Central"
    },
    {
      "code" : "1900",
      "display" : "Lake Alice"
    },
    {
      "code" : "1901",
      "display" : "Marton"
    },
    {
      "code" : "1902",
      "display" : "Moutoa"
    },
    {
      "code" : "1903",
      "display" : "Foxton"
    },
    {
      "code" : "1904",
      "display" : "Peka Peka"
    },
    {
      "code" : "1905",
      "display" : "Waikanae Park"
    },
    {
      "code" : "1906",
      "display" : "Waikanae West"
    },
    {
      "code" : "1907",
      "display" : "Nabhra"
    },
    {
      "code" : "1908",
      "display" : "Riverstone Terraces"
    },
    {
      "code" : "2000",
      "display" : "Raumati Beach"
    },
    {
      "code" : "2001",
      "display" : "Raumati South"
    },
    {
      "code" : "2002",
      "display" : "Paekakariki"
    },
    {
      "code" : "2003",
      "display" : "Kapiti Island"
    },
    {
      "code" : "2004",
      "display" : "Maungakotukutuku"
    },
    {
      "code" : "2005",
      "display" : "Te Marua"
    },
    {
      "code" : "2006",
      "display" : "Akatarawa"
    },
    {
      "code" : "2007",
      "display" : "Emerald Hill"
    },
    {
      "code" : "2008",
      "display" : "Maoribank"
    },
    {
      "code" : "2009",
      "display" : "Clouston Park"
    },
    {
      "code" : "2010",
      "display" : "Totara Park"
    },
    {
      "code" : "2011",
      "display" : "Ebdentown"
    },
    {
      "code" : "2012",
      "display" : "Upper Hutt Central"
    },
    {
      "code" : "2013",
      "display" : "Maidstone"
    },
    {
      "code" : "2014",
      "display" : "Wallaceville"
    },
    {
      "code" : "2015",
      "display" : "Elderslea"
    },
    {
      "code" : "2016",
      "display" : "Moonshine"
    },
    {
      "code" : "2017",
      "display" : "Brentwood"
    },
    {
      "code" : "2018",
      "display" : "Trentham North"
    },
    {
      "code" : "2019",
      "display" : "Heretaunga - Silverstream"
    },
    {
      "code" : "2020",
      "display" : "Cloustonville"
    },
    {
      "code" : "2021",
      "display" : "Mangaroa"
    },
    {
      "code" : "2022",
      "display" : "Tawhai"
    },
    {
      "code" : "2023",
      "display" : "Holburn"
    },
    {
      "code" : "2024",
      "display" : "Delaney"
    },
    {
      "code" : "2025",
      "display" : "Manuka"
    },
    {
      "code" : "2026",
      "display" : "Taita North"
    },
    {
      "code" : "2027",
      "display" : "Taita South"
    },
    {
      "code" : "2028",
      "display" : "Avalon East"
    },
    {
      "code" : "2029",
      "display" : "Naenae North"
    },
    {
      "code" : "2030",
      "display" : "Naenae South"
    },
    {
      "code" : "2032",
      "display" : "Epuni West"
    },
    {
      "code" : "2033",
      "display" : "Epuni East"
    },
    {
      "code" : "2035",
      "display" : "Waiwhetu North"
    },
    {
      "code" : "2036",
      "display" : "Waiwhetu South"
    },
    {
      "code" : "2037",
      "display" : "Gracefield"
    },
    {
      "code" : "2038",
      "display" : "Moera"
    },
    {
      "code" : "2039",
      "display" : "Woburn North"
    },
    {
      "code" : "2040",
      "display" : "Woburn South"
    },
    {
      "code" : "2041",
      "display" : "Hutt Central"
    },
    {
      "code" : "2042",
      "display" : "Melling"
    },
    {
      "code" : "2043",
      "display" : "Alicetown"
    },
    {
      "code" : "2044",
      "display" : "Normandale"
    },
    {
      "code" : "2045",
      "display" : "Maungaraki"
    },
    {
      "code" : "2047",
      "display" : "Kelson"
    },
    {
      "code" : "2048",
      "display" : "Haywards - Manor Park"
    },
    {
      "code" : "2049",
      "display" : "Korokoro"
    },
    {
      "code" : "2050",
      "display" : "Petone Central"
    },
    {
      "code" : "2051",
      "display" : "Esplanade"
    },
    {
      "code" : "2052",
      "display" : "Wilford"
    },
    {
      "code" : "2053",
      "display" : "Eastbourne"
    },
    {
      "code" : "2054",
      "display" : "Titahi Bay North"
    },
    {
      "code" : "2055",
      "display" : "Onepoto"
    },
    {
      "code" : "2056",
      "display" : "Titahi Bay South"
    },
    {
      "code" : "2057",
      "display" : "Elsdon - Takapuwahia"
    },
    {
      "code" : "2059",
      "display" : "Porirua East"
    },
    {
      "code" : "2061",
      "display" : "Cannons Creek North"
    },
    {
      "code" : "2062",
      "display" : "Cannons Creek South"
    },
    {
      "code" : "2063",
      "display" : "Cannons Creek East"
    },
    {
      "code" : "2064",
      "display" : "Waitangirua"
    },
    {
      "code" : "2066",
      "display" : "Ascot Park"
    },
    {
      "code" : "2067",
      "display" : "Pukerua Bay"
    },
    {
      "code" : "2070",
      "display" : "Paremata - Postgate"
    },
    {
      "code" : "2071",
      "display" : "Discovery"
    },
    {
      "code" : "2072",
      "display" : "Mana Island"
    },
    {
      "code" : "2073",
      "display" : "Tawa South"
    },
    {
      "code" : "2075",
      "display" : "Linden"
    },
    {
      "code" : "2076",
      "display" : "Greenacres"
    },
    {
      "code" : "2077",
      "display" : "Thorndon - Tinakori Road"
    },
    {
      "code" : "2078",
      "display" : "Lambton"
    },
    {
      "code" : "2080",
      "display" : "Aro Street - Nairn Street"
    },
    {
      "code" : "2081",
      "display" : "Mt Cook - Wallace Street"
    },
    {
      "code" : "2082",
      "display" : "Mt Victoria West"
    },
    {
      "code" : "2085",
      "display" : "Johnsonville North"
    },
    {
      "code" : "2086",
      "display" : "Johnsonville South"
    },
    {
      "code" : "2090",
      "display" : "Raroa"
    },
    {
      "code" : "2091",
      "display" : "Khandallah Park"
    },
    {
      "code" : "2095",
      "display" : "Ngaio"
    },
    {
      "code" : "2096",
      "display" : "Kaiwharawhara"
    },
    {
      "code" : "2097",
      "display" : "Wadestown"
    },
    {
      "code" : "2099",
      "display" : "Karori North"
    },
    {
      "code" : "2100",
      "display" : "Porirua Central"
    },
    {
      "code" : "2101",
      "display" : "Ranui Heights"
    },
    {
      "code" : "2103",
      "display" : "Plimmerton"
    },
    {
      "code" : "2104",
      "display" : "Mana - Camborne"
    },
    {
      "code" : "2105",
      "display" : "Tawa Central"
    },
    {
      "code" : "2106",
      "display" : "Glenside North"
    },
    {
      "code" : "2109",
      "display" : "Grenada North"
    },
    {
      "code" : "2110",
      "display" : "Grenada Village"
    },
    {
      "code" : "2111",
      "display" : "Newlands East"
    },
    {
      "code" : "2113",
      "display" : "Newlands South"
    },
    {
      "code" : "2114",
      "display" : "Ngauranga East"
    },
    {
      "code" : "2115",
      "display" : "Te Kainga"
    },
    {
      "code" : "2116",
      "display" : "Ngauranga West"
    },
    {
      "code" : "2117",
      "display" : "Rangoon Heights"
    },
    {
      "code" : "2118",
      "display" : "Awarua"
    },
    {
      "code" : "2119",
      "display" : "Avalon West"
    },
    {
      "code" : "2120",
      "display" : "Boulcott"
    },
    {
      "code" : "2121",
      "display" : "Waterloo West"
    },
    {
      "code" : "2122",
      "display" : "Waterloo East"
    },
    {
      "code" : "2123",
      "display" : "Tirohanga"
    },
    {
      "code" : "2124",
      "display" : "Belmont"
    },
    {
      "code" : "2125",
      "display" : "Willis Street-Cambridge Terrace"
    },
    {
      "code" : "2126",
      "display" : "Wellington City-Marinas"
    },
    {
      "code" : "2127",
      "display" : "Takapu"
    },
    {
      "code" : "2128",
      "display" : "Horokiwi"
    },
    {
      "code" : "2129",
      "display" : "Papakowhai North"
    },
    {
      "code" : "2130",
      "display" : "Papakowhai South"
    },
    {
      "code" : "2131",
      "display" : "Churton Park North"
    },
    {
      "code" : "2132",
      "display" : "Churton Park South"
    },
    {
      "code" : "2133",
      "display" : "Paparangi West"
    },
    {
      "code" : "2134",
      "display" : "Johnsonville East"
    },
    {
      "code" : "2135",
      "display" : "Paparangi"
    },
    {
      "code" : "2136",
      "display" : "Woodridge"
    },
    {
      "code" : "2137",
      "display" : "Newlands North"
    },
    {
      "code" : "2138",
      "display" : "Crofton Downs"
    },
    {
      "code" : "2139",
      "display" : "Wilton"
    },
    {
      "code" : "2140",
      "display" : "Northland North"
    },
    {
      "code" : "2200",
      "display" : "Karori Park"
    },
    {
      "code" : "2201",
      "display" : "Karori East"
    },
    {
      "code" : "2202",
      "display" : "Karori South"
    },
    {
      "code" : "2203",
      "display" : "Northland"
    },
    {
      "code" : "2204",
      "display" : "Kelburn"
    },
    {
      "code" : "2205",
      "display" : "Taitville"
    },
    {
      "code" : "2206",
      "display" : "Mitchelltown"
    },
    {
      "code" : "2207",
      "display" : "Brooklyn"
    },
    {
      "code" : "2209",
      "display" : "Kingston"
    },
    {
      "code" : "2211",
      "display" : "Island Bay West"
    },
    {
      "code" : "2212",
      "display" : "Island Bay East"
    },
    {
      "code" : "2213",
      "display" : "Melrose"
    },
    {
      "code" : "2214",
      "display" : "Berhampore"
    },
    {
      "code" : "2216",
      "display" : "Newtown East"
    },
    {
      "code" : "2217",
      "display" : "Adelaide"
    },
    {
      "code" : "2218",
      "display" : "Oriental Bay"
    },
    {
      "code" : "2219",
      "display" : "Roseneath"
    },
    {
      "code" : "2220",
      "display" : "Hataitai"
    },
    {
      "code" : "2221",
      "display" : "Kilbirnie East"
    },
    {
      "code" : "2223",
      "display" : "Lyall Bay"
    },
    {
      "code" : "2225",
      "display" : "Miramar South"
    },
    {
      "code" : "2227",
      "display" : "Karaka Bay - Worser Bay"
    },
    {
      "code" : "2228",
      "display" : "Seatoun"
    },
    {
      "code" : "2233",
      "display" : "Eketahuna"
    },
    {
      "code" : "2234",
      "display" : "Nireaha - Tiraumea"
    },
    {
      "code" : "2235",
      "display" : "Homebush - Te Ore Ore"
    },
    {
      "code" : "2236",
      "display" : "Opaki-Fernridge"
    },
    {
      "code" : "2237",
      "display" : "Kopuaranga"
    },
    {
      "code" : "2238",
      "display" : "Whareama"
    },
    {
      "code" : "2239",
      "display" : "Masterton Central"
    },
    {
      "code" : "2240",
      "display" : "Masterton West"
    },
    {
      "code" : "2241",
      "display" : "Masterton East"
    },
    {
      "code" : "2242",
      "display" : "Solway North"
    },
    {
      "code" : "2243",
      "display" : "Solway South"
    },
    {
      "code" : "2244",
      "display" : "Ngaumutawa"
    },
    {
      "code" : "2245",
      "display" : "Masterton Railway"
    },
    {
      "code" : "2246",
      "display" : "Lansdowne"
    },
    {
      "code" : "2247",
      "display" : "Waingawa"
    },
    {
      "code" : "2248",
      "display" : "Mt Holdsworth"
    },
    {
      "code" : "2249",
      "display" : "Te Wharau"
    },
    {
      "code" : "2250",
      "display" : "Carterton"
    },
    {
      "code" : "2252",
      "display" : "Tuturumuri"
    },
    {
      "code" : "2253",
      "display" : "Greytown"
    },
    {
      "code" : "2254",
      "display" : "Featherston"
    },
    {
      "code" : "2255",
      "display" : "Martinborough"
    },
    {
      "code" : "2256",
      "display" : "Havelock"
    },
    {
      "code" : "2257",
      "display" : "Renwick"
    },
    {
      "code" : "2258",
      "display" : "Woodbourne"
    },
    {
      "code" : "2259",
      "display" : "Omaka"
    },
    {
      "code" : "2261",
      "display" : "Waikawa"
    },
    {
      "code" : "2264",
      "display" : "Severn"
    },
    {
      "code" : "2265",
      "display" : "Ward"
    },
    {
      "code" : "2266",
      "display" : "Seddon"
    },
    {
      "code" : "2267",
      "display" : "Lake Tennyson"
    },
    {
      "code" : "2269",
      "display" : "Springlands"
    },
    {
      "code" : "2270",
      "display" : "Mayfield"
    },
    {
      "code" : "2271",
      "display" : "Blenheim Central"
    },
    {
      "code" : "2272",
      "display" : "Whitney"
    },
    {
      "code" : "2273",
      "display" : "Redwoodtown"
    },
    {
      "code" : "2274",
      "display" : "Witherlea"
    },
    {
      "code" : "2275",
      "display" : "Kaikoura Township"
    },
    {
      "code" : "2276",
      "display" : "Kaikoura Rural"
    },
    {
      "code" : "2277",
      "display" : "Golden Bay"
    },
    {
      "code" : "2278",
      "display" : "Takaka"
    },
    {
      "code" : "2279",
      "display" : "Glenduan"
    },
    {
      "code" : "2281",
      "display" : "Ngawhatu"
    },
    {
      "code" : "2283",
      "display" : "Aniseed Hill"
    },
    {
      "code" : "2284",
      "display" : "Hope"
    },
    {
      "code" : "2285",
      "display" : "Richmond Hill"
    },
    {
      "code" : "2286",
      "display" : "Whangamoa"
    },
    {
      "code" : "2287",
      "display" : "Brightwater"
    },
    {
      "code" : "2288",
      "display" : "Wakefield"
    },
    {
      "code" : "2292",
      "display" : "Golden Downs"
    },
    {
      "code" : "2293",
      "display" : "Lake Rotoroa"
    },
    {
      "code" : "2294",
      "display" : "Murchison"
    },
    {
      "code" : "2295",
      "display" : "Tapawera"
    },
    {
      "code" : "2296",
      "display" : "Riwaka"
    },
    {
      "code" : "2297",
      "display" : "Clifton"
    },
    {
      "code" : "2300",
      "display" : "Brooklyn South"
    },
    {
      "code" : "2301",
      "display" : "Happy Valley - Owhiro Bay"
    },
    {
      "code" : "2302",
      "display" : "Makara - Ohariu"
    },
    {
      "code" : "2303",
      "display" : "Maingatainoka"
    },
    {
      "code" : "2304",
      "display" : "Pahiatua"
    },
    {
      "code" : "2305",
      "display" : "Marlborough Sounds Coastal Marine"
    },
    {
      "code" : "2306",
      "display" : "Marlborough Sounds Terrestrial"
    },
    {
      "code" : "2307",
      "display" : "Picton"
    },
    {
      "code" : "2308",
      "display" : "Saxton Island"
    },
    {
      "code" : "2309",
      "display" : "Waimea Inlet East"
    },
    {
      "code" : "2310",
      "display" : "Saxton"
    },
    {
      "code" : "2311",
      "display" : "Bests Island"
    },
    {
      "code" : "2312",
      "display" : "Bells Island"
    },
    {
      "code" : "2313",
      "display" : "Ranzau"
    },
    {
      "code" : "2314",
      "display" : "Mapua"
    },
    {
      "code" : "2315",
      "display" : "Inlet - Motueka"
    },
    {
      "code" : "2316",
      "display" : "Kaiteriteri"
    },
    {
      "code" : "2317",
      "display" : "Motueka Outer"
    },
    {
      "code" : "2318",
      "display" : "Rabbit Island"
    },
    {
      "code" : "2319",
      "display" : "Waimea Inlet West"
    },
    {
      "code" : "2320",
      "display" : "Wai - iti"
    },
    {
      "code" : "2321",
      "display" : "Atawhai"
    },
    {
      "code" : "2322",
      "display" : "Port Nelson"
    },
    {
      "code" : "2324",
      "display" : "Inlet - Tasman Bay"
    },
    {
      "code" : "2325",
      "display" : "Kahutara"
    },
    {
      "code" : "2326",
      "display" : "Inland Water-Lake Wairarapa"
    },
    {
      "code" : "2327",
      "display" : "Kilbirnie West"
    },
    {
      "code" : "2328",
      "display" : "Evans Bay Marina"
    },
    {
      "code" : "2329",
      "display" : "Vogeltown West"
    },
    {
      "code" : "2330",
      "display" : "Vogeltown"
    },
    {
      "code" : "2331",
      "display" : "Newtown West"
    },
    {
      "code" : "2332",
      "display" : "Berhampore East"
    },
    {
      "code" : "2333",
      "display" : "Seatoun Tunnel West"
    },
    {
      "code" : "2334",
      "display" : "Strathmore Park"
    },
    {
      "code" : "2335",
      "display" : "Miramar North"
    },
    {
      "code" : "2336",
      "display" : "Miramar"
    },
    {
      "code" : "2337",
      "display" : "Maupuia"
    },
    {
      "code" : "2338",
      "display" : "Miramar West"
    },
    {
      "code" : "2339",
      "display" : "Spring Creek-Grovetown"
    },
    {
      "code" : "2340",
      "display" : "Riverlands"
    },
    {
      "code" : "2341",
      "display" : "Wairau North"
    },
    {
      "code" : "2342",
      "display" : "Tuamarina"
    },
    {
      "code" : "2343",
      "display" : "Rapaura"
    },
    {
      "code" : "2344",
      "display" : "Wairau South"
    },
    {
      "code" : "2345",
      "display" : "Weld Pass"
    },
    {
      "code" : "2346",
      "display" : "Fairhall"
    },
    {
      "code" : "2400",
      "display" : "The Wood"
    },
    {
      "code" : "2402",
      "display" : "Trafalgar"
    },
    {
      "code" : "2403",
      "display" : "Maitai"
    },
    {
      "code" : "2404",
      "display" : "Kirks"
    },
    {
      "code" : "2405",
      "display" : "Bronte"
    },
    {
      "code" : "2406",
      "display" : "Atmore"
    },
    {
      "code" : "2407",
      "display" : "Tahunanui"
    },
    {
      "code" : "2408",
      "display" : "Tahuna Hills"
    },
    {
      "code" : "2409",
      "display" : "Toi Toi"
    },
    {
      "code" : "2410",
      "display" : "Broads"
    },
    {
      "code" : "2411",
      "display" : "Grampians"
    },
    {
      "code" : "2412",
      "display" : "The Brook"
    },
    {
      "code" : "2414",
      "display" : "Nayland"
    },
    {
      "code" : "2415",
      "display" : "Enner Glynn"
    },
    {
      "code" : "2416",
      "display" : "Maitlands"
    },
    {
      "code" : "2417",
      "display" : "Isel Park"
    },
    {
      "code" : "2419",
      "display" : "Richmond East"
    },
    {
      "code" : "2420",
      "display" : "Richmond West"
    },
    {
      "code" : "2424",
      "display" : "Karamea"
    },
    {
      "code" : "2425",
      "display" : "Hector - Ngakawau"
    },
    {
      "code" : "2426",
      "display" : "Granity"
    },
    {
      "code" : "2427",
      "display" : "Westport Urban"
    },
    {
      "code" : "2428",
      "display" : "Reefton"
    },
    {
      "code" : "2430",
      "display" : "Karoro"
    },
    {
      "code" : "2431",
      "display" : "Kaiata"
    },
    {
      "code" : "2432",
      "display" : "South Beach - Camerons"
    },
    {
      "code" : "2433",
      "display" : "Blackball"
    },
    {
      "code" : "2434",
      "display" : "Point Elizabeth"
    },
    {
      "code" : "2436",
      "display" : "Dobson"
    },
    {
      "code" : "2437",
      "display" : "Runanga - Rapahoe"
    },
    {
      "code" : "2438",
      "display" : "Cobden"
    },
    {
      "code" : "2439",
      "display" : "Blaketown"
    },
    {
      "code" : "2440",
      "display" : "Greymouth Central"
    },
    {
      "code" : "2441",
      "display" : "Greymouth South"
    },
    {
      "code" : "2444",
      "display" : "Kumara"
    },
    {
      "code" : "2445",
      "display" : "Kaniere"
    },
    {
      "code" : "2447",
      "display" : "Ross"
    },
    {
      "code" : "2449",
      "display" : "Harihari"
    },
    {
      "code" : "2450",
      "display" : "Franz Josef"
    },
    {
      "code" : "2451",
      "display" : "Fox Glacier"
    },
    {
      "code" : "2452",
      "display" : "Hokitika Urban"
    },
    {
      "code" : "2453",
      "display" : "Hanmer Springs"
    },
    {
      "code" : "2455",
      "display" : "Culverden"
    },
    {
      "code" : "2456",
      "display" : "Parnassus"
    },
    {
      "code" : "2457",
      "display" : "Cheviot"
    },
    {
      "code" : "2458",
      "display" : "Hurunui"
    },
    {
      "code" : "2459",
      "display" : "Amberley"
    },
    {
      "code" : "2460",
      "display" : "Leithfield"
    },
    {
      "code" : "2462",
      "display" : "Sefton"
    },
    {
      "code" : "2463",
      "display" : "Camside"
    },
    {
      "code" : "2464",
      "display" : "Pines - Kairaki Beach"
    },
    {
      "code" : "2465",
      "display" : "Waikuku"
    },
    {
      "code" : "2467",
      "display" : "Cust"
    },
    {
      "code" : "2468",
      "display" : "Woodend"
    },
    {
      "code" : "2471",
      "display" : "Rangiora East"
    },
    {
      "code" : "2472",
      "display" : "Southbrook"
    },
    {
      "code" : "2475",
      "display" : "Clarkville"
    },
    {
      "code" : "2478",
      "display" : "Ashley Gorge"
    },
    {
      "code" : "2479",
      "display" : "Oxford"
    },
    {
      "code" : "2480",
      "display" : "Darfield"
    },
    {
      "code" : "2481",
      "display" : "Kirwee"
    },
    {
      "code" : "2482",
      "display" : "Burnham Military Camp"
    },
    {
      "code" : "2483",
      "display" : "Malvern"
    },
    {
      "code" : "2485",
      "display" : "Halswell South"
    },
    {
      "code" : "2486",
      "display" : "Hornby North"
    },
    {
      "code" : "2487",
      "display" : "Hornby South"
    },
    {
      "code" : "2488",
      "display" : "Sockburn"
    },
    {
      "code" : "2489",
      "display" : "Wigram"
    },
    {
      "code" : "2490",
      "display" : "Yaldhurst"
    },
    {
      "code" : "2491",
      "display" : "Broomfield"
    },
    {
      "code" : "2493",
      "display" : "Islington"
    },
    {
      "code" : "2495",
      "display" : "Halswell West"
    },
    {
      "code" : "2497",
      "display" : "Westmorland"
    },
    {
      "code" : "2498",
      "display" : "McLeans Island"
    },
    {
      "code" : "2499",
      "display" : "Kennedys Bush"
    },
    {
      "code" : "2500",
      "display" : "Nelson Airport"
    },
    {
      "code" : "2501",
      "display" : "Langbein"
    },
    {
      "code" : "2502",
      "display" : "Motueka West"
    },
    {
      "code" : "2503",
      "display" : "Motueka East"
    },
    {
      "code" : "2504",
      "display" : "Moutere Inlet"
    },
    {
      "code" : "2505",
      "display" : "Jackett Island"
    },
    {
      "code" : "2506",
      "display" : "Orowaiti"
    },
    {
      "code" : "2508",
      "display" : "Okuku"
    },
    {
      "code" : "2509",
      "display" : "Loburn"
    },
    {
      "code" : "2510",
      "display" : "Ashley"
    },
    {
      "code" : "2511",
      "display" : "Mairaki"
    },
    {
      "code" : "2519",
      "display" : "Inangahua Junction"
    },
    {
      "code" : "2520",
      "display" : "Inangahua Valley"
    },
    {
      "code" : "2521",
      "display" : "Mawheraiti"
    },
    {
      "code" : "2522",
      "display" : "Maruia"
    },
    {
      "code" : "2523",
      "display" : "Barrytown"
    },
    {
      "code" : "2524",
      "display" : "Coalcreek"
    },
    {
      "code" : "2525",
      "display" : "Atarau"
    },
    {
      "code" : "2526",
      "display" : "Greymouth Rural"
    },
    {
      "code" : "2527",
      "display" : "Marsden-Hohonu"
    },
    {
      "code" : "2528",
      "display" : "Arnold Valley"
    },
    {
      "code" : "2529",
      "display" : "Nelson Creek-Ngahere"
    },
    {
      "code" : "2530",
      "display" : "Ahaura"
    },
    {
      "code" : "2531",
      "display" : "Lake Brunner"
    },
    {
      "code" : "2532",
      "display" : "Haupiri"
    },
    {
      "code" : "2533",
      "display" : "Bruce Bay-Paringa"
    },
    {
      "code" : "2534",
      "display" : "Haast"
    },
    {
      "code" : "2535",
      "display" : "Taramakau"
    },
    {
      "code" : "2536",
      "display" : "Otira"
    },
    {
      "code" : "2537",
      "display" : "Waimea-Arahura"
    },
    {
      "code" : "2538",
      "display" : "Hokitika Rural"
    },
    {
      "code" : "2539",
      "display" : "Hokitika Valley"
    },
    {
      "code" : "2540",
      "display" : "Totara River"
    },
    {
      "code" : "2541",
      "display" : "Waitaha"
    },
    {
      "code" : "2542",
      "display" : "Whataroa"
    },
    {
      "code" : "2543",
      "display" : "Waio"
    },
    {
      "code" : "2544",
      "display" : "Karangarua"
    },
    {
      "code" : "2545",
      "display" : "Westport Rural"
    },
    {
      "code" : "2546",
      "display" : "Little Wanganui"
    },
    {
      "code" : "2547",
      "display" : "Mokihinui"
    },
    {
      "code" : "2548",
      "display" : "Buller Coalfields"
    },
    {
      "code" : "2549",
      "display" : "Charleston"
    },
    {
      "code" : "2550",
      "display" : "Britannia"
    },
    {
      "code" : "2551",
      "display" : "Washington"
    },
    {
      "code" : "2552",
      "display" : "Waiau"
    },
    {
      "code" : "2553",
      "display" : "Amuri"
    },
    {
      "code" : "2554",
      "display" : "Kingsbury"
    },
    {
      "code" : "2555",
      "display" : "Rangiora North"
    },
    {
      "code" : "2556",
      "display" : "Kaiapoi South"
    },
    {
      "code" : "2557",
      "display" : "Mansfield"
    },
    {
      "code" : "2558",
      "display" : "Courtenay"
    },
    {
      "code" : "2559",
      "display" : "Mandeville"
    },
    {
      "code" : "2560",
      "display" : "Ohoka"
    },
    {
      "code" : "2561",
      "display" : "Oaklands West"
    },
    {
      "code" : "2562",
      "display" : "Oaklands East"
    },
    {
      "code" : "2563",
      "display" : "Aidanfield"
    },
    {
      "code" : "2564",
      "display" : "Halswell Domain"
    },
    {
      "code" : "2565",
      "display" : "Hendersons Basin"
    },
    {
      "code" : "2566",
      "display" : "Fernside"
    },
    {
      "code" : "2567",
      "display" : "Lehmans"
    },
    {
      "code" : "2568",
      "display" : "Pegasus"
    },
    {
      "code" : "2569",
      "display" : "Woodend Beach"
    },
    {
      "code" : "2570",
      "display" : "Coldstream"
    },
    {
      "code" : "2571",
      "display" : "Ravenswood"
    },
    {
      "code" : "2572",
      "display" : "Tuahiwi"
    },
    {
      "code" : "2573",
      "display" : "Woodend West"
    },
    {
      "code" : "2574",
      "display" : "Rangiora West"
    },
    {
      "code" : "2575",
      "display" : "Rangiora Central"
    },
    {
      "code" : "2576",
      "display" : "Kaiapoi East"
    },
    {
      "code" : "2577",
      "display" : "Kaiapoi North West"
    },
    {
      "code" : "2578",
      "display" : "Kaiapoi North East"
    },
    {
      "code" : "2579",
      "display" : "Kaiapoi West"
    },
    {
      "code" : "2580",
      "display" : "Silverstream"
    },
    {
      "code" : "2581",
      "display" : "West Eyreton"
    },
    {
      "code" : "2582",
      "display" : "Eyrewell"
    },
    {
      "code" : "2583",
      "display" : "Paparua"
    },
    {
      "code" : "2584",
      "display" : "Templeton"
    },
    {
      "code" : "2585",
      "display" : "Prebbleton"
    },
    {
      "code" : "2586",
      "display" : "Trents-Ladbrooks"
    },
    {
      "code" : "2600",
      "display" : "West Melton"
    },
    {
      "code" : "2601",
      "display" : "Taitapu"
    },
    {
      "code" : "2602",
      "display" : "Redwood North"
    },
    {
      "code" : "2603",
      "display" : "Redwood South"
    },
    {
      "code" : "2604",
      "display" : "Styx Mill"
    },
    {
      "code" : "2605",
      "display" : "Casebrook"
    },
    {
      "code" : "2607",
      "display" : "Kaimahi"
    },
    {
      "code" : "2608",
      "display" : "Harewood"
    },
    {
      "code" : "2609",
      "display" : "Bishopdale"
    },
    {
      "code" : "2610",
      "display" : "Russley"
    },
    {
      "code" : "2611",
      "display" : "Burnside"
    },
    {
      "code" : "2612",
      "display" : "Wairarapa"
    },
    {
      "code" : "2613",
      "display" : "Jellie Park"
    },
    {
      "code" : "2614",
      "display" : "Bryndwr"
    },
    {
      "code" : "2615",
      "display" : "Holmwood"
    },
    {
      "code" : "2616",
      "display" : "Fendalton"
    },
    {
      "code" : "2617",
      "display" : "Deans Bush"
    },
    {
      "code" : "2618",
      "display" : "Hawthornden"
    },
    {
      "code" : "2619",
      "display" : "Merrin"
    },
    {
      "code" : "2620",
      "display" : "Westburn"
    },
    {
      "code" : "2621",
      "display" : "Masham"
    },
    {
      "code" : "2622",
      "display" : "Avonhead"
    },
    {
      "code" : "2623",
      "display" : "Ilam"
    },
    {
      "code" : "2624",
      "display" : "Upper Riccarton"
    },
    {
      "code" : "2625",
      "display" : "Wharenui"
    },
    {
      "code" : "2626",
      "display" : "Middleton"
    },
    {
      "code" : "2627",
      "display" : "Belfast"
    },
    {
      "code" : "2630",
      "display" : "Parklands"
    },
    {
      "code" : "2632",
      "display" : "Riccarton"
    },
    {
      "code" : "2633",
      "display" : "Riccarton South"
    },
    {
      "code" : "2634",
      "display" : "Cashmere West"
    },
    {
      "code" : "2635",
      "display" : "Cashmere East"
    },
    {
      "code" : "2636",
      "display" : "Rapaki Track"
    },
    {
      "code" : "2637",
      "display" : "Heathcote Valley"
    },
    {
      "code" : "2638",
      "display" : "Cathedral Square"
    },
    {
      "code" : "2639",
      "display" : "Hagley Park"
    },
    {
      "code" : "2640",
      "display" : "Avon Loop"
    },
    {
      "code" : "2641",
      "display" : "Northcote"
    },
    {
      "code" : "2642",
      "display" : "Papanui"
    },
    {
      "code" : "2643",
      "display" : "Aorangi"
    },
    {
      "code" : "2644",
      "display" : "Strowan"
    },
    {
      "code" : "2645",
      "display" : "Merivale"
    },
    {
      "code" : "2646",
      "display" : "Rutland"
    },
    {
      "code" : "2647",
      "display" : "St Albans West"
    },
    {
      "code" : "2648",
      "display" : "St Albans East"
    },
    {
      "code" : "2649",
      "display" : "Mairehau"
    },
    {
      "code" : "2650",
      "display" : "Edgeware"
    },
    {
      "code" : "2651",
      "display" : "Shirley West"
    },
    {
      "code" : "2652",
      "display" : "Shirley East"
    },
    {
      "code" : "2653",
      "display" : "Burwood"
    },
    {
      "code" : "2654",
      "display" : "Dallington"
    },
    {
      "code" : "2655",
      "display" : "Travis"
    },
    {
      "code" : "2656",
      "display" : "Avondale"
    },
    {
      "code" : "2657",
      "display" : "Chisnall"
    },
    {
      "code" : "2658",
      "display" : "Aranui"
    },
    {
      "code" : "2659",
      "display" : "Richmond North"
    },
    {
      "code" : "2660",
      "display" : "Richmond South"
    },
    {
      "code" : "2661",
      "display" : "Avonside"
    },
    {
      "code" : "2662",
      "display" : "Linwood"
    },
    {
      "code" : "2663",
      "display" : "Phillipstown"
    },
    {
      "code" : "2664",
      "display" : "Linwood North"
    },
    {
      "code" : "2665",
      "display" : "Linwood East"
    },
    {
      "code" : "2666",
      "display" : "Bexley"
    },
    {
      "code" : "2667",
      "display" : "Bromley"
    },
    {
      "code" : "2668",
      "display" : "Woolston West"
    },
    {
      "code" : "2669",
      "display" : "Ferrymead"
    },
    {
      "code" : "2670",
      "display" : "Woolston South"
    },
    {
      "code" : "2671",
      "display" : "Ensors"
    },
    {
      "code" : "2672",
      "display" : "Opawa"
    },
    {
      "code" : "2673",
      "display" : "St Martins"
    },
    {
      "code" : "2674",
      "display" : "Waltham"
    },
    {
      "code" : "2675",
      "display" : "Sydenham"
    },
    {
      "code" : "2676",
      "display" : "Addington"
    },
    {
      "code" : "2677",
      "display" : "Barrington North"
    },
    {
      "code" : "2678",
      "display" : "Barrington South"
    },
    {
      "code" : "2679",
      "display" : "Spreydon"
    },
    {
      "code" : "2680",
      "display" : "Hoon Hay"
    },
    {
      "code" : "2681",
      "display" : "Hoon Hay South"
    },
    {
      "code" : "2682",
      "display" : "Hillmorton"
    },
    {
      "code" : "2683",
      "display" : "Somerfield"
    },
    {
      "code" : "2684",
      "display" : "Beckenham"
    },
    {
      "code" : "2685",
      "display" : "North Beach"
    },
    {
      "code" : "2686",
      "display" : "Rawhiti"
    },
    {
      "code" : "2687",
      "display" : "New Brighton"
    },
    {
      "code" : "2689",
      "display" : "Mt Pleasant"
    },
    {
      "code" : "2691",
      "display" : "Sumner"
    },
    {
      "code" : "2692",
      "display" : "Lyttelton"
    },
    {
      "code" : "2694",
      "display" : "Diamond Harbour"
    },
    {
      "code" : "2695",
      "display" : "Port Levy"
    },
    {
      "code" : "2696",
      "display" : "Akaroa"
    },
    {
      "code" : "2698",
      "display" : "Chatham Islands"
    },
    {
      "code" : "2700",
      "display" : "South Brighton"
    },
    {
      "code" : "2701",
      "display" : "Avon - Heathcote Estuary"
    },
    {
      "code" : "2702",
      "display" : "Moncks Bay"
    },
    {
      "code" : "2703",
      "display" : "Governors Bay"
    },
    {
      "code" : "2704",
      "display" : "Quail Island"
    },
    {
      "code" : "2705",
      "display" : "Little River"
    },
    {
      "code" : "2706",
      "display" : "Inland Water-Lake Ellesmere South"
    },
    {
      "code" : "2707",
      "display" : "Belfast South"
    },
    {
      "code" : "2708",
      "display" : "Sawyers Arms"
    },
    {
      "code" : "2709",
      "display" : "Travis Wetland"
    },
    {
      "code" : "2711",
      "display" : "Waimairi Beach"
    },
    {
      "code" : "2712",
      "display" : "Styx"
    },
    {
      "code" : "2713",
      "display" : "Mona Vale"
    },
    {
      "code" : "2714",
      "display" : "Riccarton West"
    },
    {
      "code" : "2715",
      "display" : "Akaroa Harbour"
    },
    {
      "code" : "2716",
      "display" : "Banks Peninsula Eastern Bays"
    },
    {
      "code" : "2717",
      "display" : "Mairehau North"
    },
    {
      "code" : "2718",
      "display" : "Westhaven"
    },
    {
      "code" : "2719",
      "display" : "Highfield Park"
    },
    {
      "code" : "2720",
      "display" : "Prestons"
    },
    {
      "code" : "2800",
      "display" : "Lincoln"
    },
    {
      "code" : "2801",
      "display" : "Leeston"
    },
    {
      "code" : "2802",
      "display" : "Southbridge"
    },
    {
      "code" : "2805",
      "display" : "Dunsandel"
    },
    {
      "code" : "2806",
      "display" : "Methven"
    },
    {
      "code" : "2808",
      "display" : "Plains Railway"
    },
    {
      "code" : "2809",
      "display" : "Mt Somers"
    },
    {
      "code" : "2810",
      "display" : "Hinds"
    },
    {
      "code" : "2811",
      "display" : "Chertsey"
    },
    {
      "code" : "2812",
      "display" : "Rakaia"
    },
    {
      "code" : "2814",
      "display" : "Ashburton Central West"
    },
    {
      "code" : "2815",
      "display" : "Netherby"
    },
    {
      "code" : "2816",
      "display" : "Ashburton Central East"
    },
    {
      "code" : "2817",
      "display" : "Hampstead"
    },
    {
      "code" : "2818",
      "display" : "Tinwald"
    },
    {
      "code" : "2819",
      "display" : "Winchester"
    },
    {
      "code" : "2820",
      "display" : "Fairview - Scarborough"
    },
    {
      "code" : "2821",
      "display" : "Otipua Creek - Washdyke Flat"
    },
    {
      "code" : "2822",
      "display" : "Ben McLeod"
    },
    {
      "code" : "2823",
      "display" : "Orari"
    },
    {
      "code" : "2824",
      "display" : "Levels"
    },
    {
      "code" : "2825",
      "display" : "Pareora"
    },
    {
      "code" : "2826",
      "display" : "Pleasant Point"
    },
    {
      "code" : "2827",
      "display" : "Geraldine"
    },
    {
      "code" : "2828",
      "display" : "Temuka"
    },
    {
      "code" : "2829",
      "display" : "Washdyke"
    },
    {
      "code" : "2830",
      "display" : "Waimataitai"
    },
    {
      "code" : "2831",
      "display" : "Marchwiel"
    },
    {
      "code" : "2832",
      "display" : "Maori Park"
    },
    {
      "code" : "2833",
      "display" : "Highfield"
    },
    {
      "code" : "2834",
      "display" : "Glenwood"
    },
    {
      "code" : "2835",
      "display" : "Gleniti"
    },
    {
      "code" : "2836",
      "display" : "Fraser Park"
    },
    {
      "code" : "2837",
      "display" : "Seaview"
    },
    {
      "code" : "2838",
      "display" : "Watlington"
    },
    {
      "code" : "2839",
      "display" : "Parkside"
    },
    {
      "code" : "2840",
      "display" : "Timaru Gardens"
    },
    {
      "code" : "2841",
      "display" : "Redruth"
    },
    {
      "code" : "2842",
      "display" : "Twizel Community"
    },
    {
      "code" : "2843",
      "display" : "Fairlie"
    },
    {
      "code" : "2845",
      "display" : "Mt Cook"
    },
    {
      "code" : "2847",
      "display" : "Waihao"
    },
    {
      "code" : "2848",
      "display" : "St Andrews"
    },
    {
      "code" : "2849",
      "display" : "Waimate"
    },
    {
      "code" : "2850",
      "display" : "Weston"
    },
    {
      "code" : "2851",
      "display" : "Pukeuri"
    },
    {
      "code" : "2852",
      "display" : "Ardgowan"
    },
    {
      "code" : "2853",
      "display" : "Cape Wanbrow"
    },
    {
      "code" : "2854",
      "display" : "Duntroon"
    },
    {
      "code" : "2855",
      "display" : "Kurow"
    },
    {
      "code" : "2857",
      "display" : "Maheno"
    },
    {
      "code" : "2858",
      "display" : "Omarama"
    },
    {
      "code" : "2859",
      "display" : "Kakanui"
    },
    {
      "code" : "2860",
      "display" : "Otematata"
    },
    {
      "code" : "2861",
      "display" : "Hampden"
    },
    {
      "code" : "2862",
      "display" : "Oamaru North"
    },
    {
      "code" : "2863",
      "display" : "Orana Park"
    },
    {
      "code" : "2864",
      "display" : "Oamaru Central"
    },
    {
      "code" : "2865",
      "display" : "Oamaru South"
    },
    {
      "code" : "2866",
      "display" : "Palmerston"
    },
    {
      "code" : "2867",
      "display" : "Waihemo"
    },
    {
      "code" : "2868",
      "display" : "Hyde"
    },
    {
      "code" : "2869",
      "display" : "Waikouaiti"
    },
    {
      "code" : "2870",
      "display" : "Aramoana"
    },
    {
      "code" : "2871",
      "display" : "Waitati"
    },
    {
      "code" : "2872",
      "display" : "Evansdale"
    },
    {
      "code" : "2873",
      "display" : "Karitane"
    },
    {
      "code" : "2874",
      "display" : "Warrington"
    },
    {
      "code" : "2875",
      "display" : "Nenthorn"
    },
    {
      "code" : "2876",
      "display" : "Fairfield"
    },
    {
      "code" : "2877",
      "display" : "Brighton"
    },
    {
      "code" : "2878",
      "display" : "Waldronville"
    },
    {
      "code" : "2879",
      "display" : "Outram"
    },
    {
      "code" : "2880",
      "display" : "Middlemarch"
    },
    {
      "code" : "2881",
      "display" : "Wyllies Crossing"
    },
    {
      "code" : "2882",
      "display" : "Wingatui"
    },
    {
      "code" : "2883",
      "display" : "Kaikorai Hill"
    },
    {
      "code" : "2884",
      "display" : "Saddle Hill"
    },
    {
      "code" : "2885",
      "display" : "Taieri"
    },
    {
      "code" : "2886",
      "display" : "Strath Taieri"
    },
    {
      "code" : "2887",
      "display" : "Harbourside"
    },
    {
      "code" : "2888",
      "display" : "Fernhill"
    },
    {
      "code" : "2889",
      "display" : "High St - Stuart St"
    },
    {
      "code" : "2890",
      "display" : "Stuart St - Frederick St"
    },
    {
      "code" : "2891",
      "display" : "Opoho"
    },
    {
      "code" : "2892",
      "display" : "Forrester Park"
    },
    {
      "code" : "2893",
      "display" : "North East Valley"
    },
    {
      "code" : "2894",
      "display" : "Pine Hill"
    },
    {
      "code" : "2895",
      "display" : "Woodhaugh"
    },
    {
      "code" : "2896",
      "display" : "North Dunedin"
    },
    {
      "code" : "2897",
      "display" : "Otago University"
    },
    {
      "code" : "2898",
      "display" : "Maori Hill"
    },
    {
      "code" : "2899",
      "display" : "Balmacewen"
    },
    {
      "code" : "2900",
      "display" : "Lake Tekapo"
    },
    {
      "code" : "2901",
      "display" : "Inland Water-Lake Alexandrina"
    },
    {
      "code" : "2902",
      "display" : "Inland Water - Lake Tekapo"
    },
    {
      "code" : "2903",
      "display" : "Mackenzie"
    },
    {
      "code" : "2905",
      "display" : "Inland Water-Lake Ellesmere North"
    },
    {
      "code" : "2906",
      "display" : "Selwyn-Rakaia"
    },
    {
      "code" : "2907",
      "display" : "Aviemore"
    },
    {
      "code" : "2908",
      "display" : "Inland Water-Lake Ohai"
    },
    {
      "code" : "2909",
      "display" : "Rolleston North West"
    },
    {
      "code" : "2910",
      "display" : "Rolleston Central"
    },
    {
      "code" : "2911",
      "display" : "Rolleston North East"
    },
    {
      "code" : "2912",
      "display" : "Rolleston South West"
    },
    {
      "code" : "2913",
      "display" : "Springston"
    },
    {
      "code" : "2914",
      "display" : "Rolleston South East"
    },
    {
      "code" : "2915",
      "display" : "Ashburton North"
    },
    {
      "code" : "2916",
      "display" : "Fairton"
    },
    {
      "code" : "2917",
      "display" : "Ashburton East"
    },
    {
      "code" : "2918",
      "display" : "Allenton West"
    },
    {
      "code" : "2919",
      "display" : "Allenton East"
    },
    {
      "code" : "3000",
      "display" : "Glenleith"
    },
    {
      "code" : "3001",
      "display" : "Helensburgh"
    },
    {
      "code" : "3002",
      "display" : "Wakari"
    },
    {
      "code" : "3003",
      "display" : "Halfway Bush"
    },
    {
      "code" : "3004",
      "display" : "Brockville"
    },
    {
      "code" : "3005",
      "display" : "Roslyn North"
    },
    {
      "code" : "3006",
      "display" : "Roslyn South"
    },
    {
      "code" : "3007",
      "display" : "Mornington"
    },
    {
      "code" : "3008",
      "display" : "Belleknowes"
    },
    {
      "code" : "3009",
      "display" : "Kenmure"
    },
    {
      "code" : "3010",
      "display" : "Caversham"
    },
    {
      "code" : "3012",
      "display" : "Caledonian"
    },
    {
      "code" : "3013",
      "display" : "South Dunedin"
    },
    {
      "code" : "3014",
      "display" : "Forbury"
    },
    {
      "code" : "3015",
      "display" : "St Clair"
    },
    {
      "code" : "3016",
      "display" : "Musselburgh"
    },
    {
      "code" : "3017",
      "display" : "Andersons Bay"
    },
    {
      "code" : "3018",
      "display" : "Vauxhall"
    },
    {
      "code" : "3019",
      "display" : "St Leonards - Blanket Bay"
    },
    {
      "code" : "3020",
      "display" : "Ravensbourne"
    },
    {
      "code" : "3021",
      "display" : "Inner Peninsula"
    },
    {
      "code" : "3023",
      "display" : "Broad Bay - Portobello"
    },
    {
      "code" : "3024",
      "display" : "Tairaroa - Cape Saunders"
    },
    {
      "code" : "3025",
      "display" : "Sandymount"
    },
    {
      "code" : "3026",
      "display" : "Sawyers Bay"
    },
    {
      "code" : "3027",
      "display" : "Port Chalmers"
    },
    {
      "code" : "3028",
      "display" : "St Kilda West"
    },
    {
      "code" : "3029",
      "display" : "St Kilda Central"
    },
    {
      "code" : "3030",
      "display" : "St Kilda East"
    },
    {
      "code" : "3031",
      "display" : "Green Island"
    },
    {
      "code" : "3032",
      "display" : "Abbotsford"
    },
    {
      "code" : "3033",
      "display" : "Concord"
    },
    {
      "code" : "3034",
      "display" : "Mosgiel East"
    },
    {
      "code" : "3035",
      "display" : "Mosgiel South"
    },
    {
      "code" : "3036",
      "display" : "East Taieri"
    },
    {
      "code" : "3037",
      "display" : "Bush Road"
    },
    {
      "code" : "3038",
      "display" : "Benhar"
    },
    {
      "code" : "3039",
      "display" : "Stirling"
    },
    {
      "code" : "3040",
      "display" : "Bruce"
    },
    {
      "code" : "3041",
      "display" : "Milton"
    },
    {
      "code" : "3042",
      "display" : "Kaitangata"
    },
    {
      "code" : "3043",
      "display" : "Clinton"
    },
    {
      "code" : "3044",
      "display" : "Kaka Point"
    },
    {
      "code" : "3045",
      "display" : "Owaka"
    },
    {
      "code" : "3048",
      "display" : "Teviot"
    },
    {
      "code" : "3049",
      "display" : "Tuapeka"
    },
    {
      "code" : "3050",
      "display" : "Tapanui"
    },
    {
      "code" : "3051",
      "display" : "Lawrence"
    },
    {
      "code" : "3052",
      "display" : "Roxburgh"
    },
    {
      "code" : "3053",
      "display" : "Ranfurly"
    },
    {
      "code" : "3054",
      "display" : "Maniototo"
    },
    {
      "code" : "3055",
      "display" : "Naseby"
    },
    {
      "code" : "3057",
      "display" : "Dunstan"
    },
    {
      "code" : "3058",
      "display" : "Clyde"
    },
    {
      "code" : "3059",
      "display" : "Alexandra"
    },
    {
      "code" : "3060",
      "display" : "Cromwell"
    },
    {
      "code" : "3061",
      "display" : "Frankton"
    },
    {
      "code" : "3062",
      "display" : "Wanaka"
    },
    {
      "code" : "3063",
      "display" : "Milford"
    },
    {
      "code" : "3065",
      "display" : "Kelvin Heights"
    },
    {
      "code" : "3066",
      "display" : "Sunshine Bay"
    },
    {
      "code" : "3071",
      "display" : "Queenstown Hill"
    },
    {
      "code" : "3072",
      "display" : "Balfour Community"
    },
    {
      "code" : "3073",
      "display" : "Riversdale Community"
    },
    {
      "code" : "3074",
      "display" : "Lumsden Community"
    },
    {
      "code" : "3075",
      "display" : "Edendale Community"
    },
    {
      "code" : "3076",
      "display" : "Wyndham"
    },
    {
      "code" : "3077",
      "display" : "Makarewa North"
    },
    {
      "code" : "3079",
      "display" : "Bay Road West"
    },
    {
      "code" : "3083",
      "display" : "Charlton"
    },
    {
      "code" : "3084",
      "display" : "Waikaia"
    },
    {
      "code" : "3085",
      "display" : "Kaweku"
    },
    {
      "code" : "3086",
      "display" : "Chatton"
    },
    {
      "code" : "3087",
      "display" : "Kaiwera"
    },
    {
      "code" : "3088",
      "display" : "Hokonui"
    },
    {
      "code" : "3089",
      "display" : "Waianiwa"
    },
    {
      "code" : "3090",
      "display" : "Oreti Beach"
    },
    {
      "code" : "3091",
      "display" : "Dacre"
    },
    {
      "code" : "3092",
      "display" : "Myross Bush"
    },
    {
      "code" : "3094",
      "display" : "Waituna"
    },
    {
      "code" : "3095",
      "display" : "Woodlands"
    },
    {
      "code" : "3096",
      "display" : "Toetoes"
    },
    {
      "code" : "3097",
      "display" : "Wallacetown"
    },
    {
      "code" : "3098",
      "display" : "North Gore"
    },
    {
      "code" : "3099",
      "display" : "East Gore"
    },
    {
      "code" : "3100",
      "display" : "Corstorphine West"
    },
    {
      "code" : "3101",
      "display" : "Corstorphine East"
    },
    {
      "code" : "3102",
      "display" : "Company Bay"
    },
    {
      "code" : "3103",
      "display" : "MacAndrew Bay"
    },
    {
      "code" : "3104",
      "display" : "Clutha"
    },
    {
      "code" : "3105",
      "display" : "Balclutha"
    },
    {
      "code" : "3107",
      "display" : "Arrowtown"
    },
    {
      "code" : "3108",
      "display" : "Makarewa"
    },
    {
      "code" : "3109",
      "display" : "Mill Road - Woodend"
    },
    {
      "code" : "3110",
      "display" : "Bushy Point"
    },
    {
      "code" : "3111",
      "display" : "Otatara"
    },
    {
      "code" : "3112",
      "display" : "Greenhills"
    },
    {
      "code" : "3113",
      "display" : "Tiwai Point"
    },
    {
      "code" : "3114",
      "display" : "Waikiwi"
    },
    {
      "code" : "3115",
      "display" : "Hawea"
    },
    {
      "code" : "3116",
      "display" : "Inland Water-Lake Hawea"
    },
    {
      "code" : "3117",
      "display" : "Inland Water-Lake Wakatipu"
    },
    {
      "code" : "3118",
      "display" : "Matukituki"
    },
    {
      "code" : "3119",
      "display" : "Inland Water-Lake Wanaka"
    },
    {
      "code" : "3121",
      "display" : "Lake Hayes"
    },
    {
      "code" : "3122",
      "display" : "Glenorchy"
    },
    {
      "code" : "3123",
      "display" : "Kingston South"
    },
    {
      "code" : "3124",
      "display" : "Outer Wakatipu"
    },
    {
      "code" : "3125",
      "display" : "Wakatipu Basin"
    },
    {
      "code" : "3126",
      "display" : "Frankton East"
    },
    {
      "code" : "3127",
      "display" : "Lake Hayes South"
    },
    {
      "code" : "3128",
      "display" : "Jacks Point"
    },
    {
      "code" : "3129",
      "display" : "Arthurs Point"
    },
    {
      "code" : "3130",
      "display" : "Queenstown Bay"
    },
    {
      "code" : "3200",
      "display" : "Central Gore"
    },
    {
      "code" : "3201",
      "display" : "West Gore"
    },
    {
      "code" : "3202",
      "display" : "South Gore"
    },
    {
      "code" : "3203",
      "display" : "Mataura"
    },
    {
      "code" : "3204",
      "display" : "Winton"
    },
    {
      "code" : "3205",
      "display" : "Grasmere"
    },
    {
      "code" : "3207",
      "display" : "Rosedale"
    },
    {
      "code" : "3208",
      "display" : "Gladstone - Avenal"
    },
    {
      "code" : "3209",
      "display" : "Windsor"
    },
    {
      "code" : "3210",
      "display" : "Waverley-Glengarry"
    },
    {
      "code" : "3211",
      "display" : "Hawthorndale"
    },
    {
      "code" : "3212",
      "display" : "Richmond"
    },
    {
      "code" : "3213",
      "display" : "Otakaro Park"
    },
    {
      "code" : "3214",
      "display" : "Crinan"
    },
    {
      "code" : "3215",
      "display" : "West Invercargill"
    },
    {
      "code" : "3216",
      "display" : "Georgetown"
    },
    {
      "code" : "3217",
      "display" : "Newfield - Rockdale"
    },
    {
      "code" : "3218",
      "display" : "Heidelberg"
    },
    {
      "code" : "3219",
      "display" : "Strathern"
    },
    {
      "code" : "3220",
      "display" : "Appleby - Kew"
    },
    {
      "code" : "3222",
      "display" : "Tisbury"
    },
    {
      "code" : "3223",
      "display" : "Bluff"
    },
    {
      "code" : "3224",
      "display" : "Nightcaps"
    },
    {
      "code" : "3225",
      "display" : "Ohai"
    },
    {
      "code" : "3226",
      "display" : "Te Anau"
    },
    {
      "code" : "3227",
      "display" : "Tuatapere"
    },
    {
      "code" : "3228",
      "display" : "Otautau"
    },
    {
      "code" : "3230",
      "display" : "Manapouri"
    },
    {
      "code" : "3231",
      "display" : "Mossburn"
    },
    {
      "code" : "3232",
      "display" : "Wairio"
    },
    {
      "code" : "3233",
      "display" : "Te Waewae"
    },
    {
      "code" : "3237",
      "display" : "Stewart Island"
    },
    {
      "code" : "3240",
      "display" : "Inlet - Hokianga Harbour"
    },
    {
      "code" : "3241",
      "display" : "Inlet - Rangaunu Harbour"
    },
    {
      "code" : "3242",
      "display" : "Inlet - Doubtless Bay"
    },
    {
      "code" : "3243",
      "display" : "Inlet - Whangaroa Harbour"
    },
    {
      "code" : "3244",
      "display" : "Inlet - Bay of Islands"
    },
    {
      "code" : "3246",
      "display" : "Inlet - Port Whangarei"
    },
    {
      "code" : "3247",
      "display" : "Inlet - Mangawhai Harbour"
    },
    {
      "code" : "3248",
      "display" : "Mokohinau Island"
    },
    {
      "code" : "3249",
      "display" : "Little Barrier Island"
    },
    {
      "code" : "3250",
      "display" : "Kaikoura and Rangiahua Islands"
    },
    {
      "code" : "3251",
      "display" : "Inlet - Port Fitzroy"
    },
    {
      "code" : "3252",
      "display" : "Cape Barrier"
    },
    {
      "code" : "3253",
      "display" : "Rakitu Island"
    },
    {
      "code" : "3254",
      "display" : "Browns Island"
    },
    {
      "code" : "3255",
      "display" : "Aiguilles Island"
    },
    {
      "code" : "3256",
      "display" : "Inlet - Kaipara Harbour North"
    },
    {
      "code" : "3258",
      "display" : "Inlet - Kaipara River"
    },
    {
      "code" : "3259",
      "display" : "Inlet - Takapuna Head"
    },
    {
      "code" : "3260",
      "display" : "Inlet - Hobson Bay"
    },
    {
      "code" : "3263",
      "display" : "Oceanic - Auckland Region West"
    },
    {
      "code" : "3265",
      "display" : "Inlet - Waiuku River"
    },
    {
      "code" : "3267",
      "display" : "Te Motu Island"
    },
    {
      "code" : "3268",
      "display" : "Motiti Island"
    },
    {
      "code" : "3269",
      "display" : "Mayor Island"
    },
    {
      "code" : "3270",
      "display" : "Inlet - Raglan Harbour"
    },
    {
      "code" : "3271",
      "display" : "Inlet - Aotea Harbour North"
    },
    {
      "code" : "3272",
      "display" : "Inlets - Otorohanga District"
    },
    {
      "code" : "3273",
      "display" : "Inlet - Waitomo District"
    },
    {
      "code" : "3274",
      "display" : "Oceanic - Waikato Region West"
    },
    {
      "code" : "3275",
      "display" : "Inlets - Thames Coromandel District"
    },
    {
      "code" : "3276",
      "display" : "Islands - Thames Coromandel District"
    },
    {
      "code" : "3277",
      "display" : "Bays - Thames Coromandel District"
    },
    {
      "code" : "3278",
      "display" : "Oceanic - Waikato Region East"
    },
    {
      "code" : "3279",
      "display" : "Inlet - Firth of Thames"
    },
    {
      "code" : "3281",
      "display" : "White Island"
    },
    {
      "code" : "3282",
      "display" : "Inland Water - Lake Taupo"
    },
    {
      "code" : "3283",
      "display" : "Oceanic - Gisborne District"
    },
    {
      "code" : "3284",
      "display" : "Inlet - Port Napier"
    },
    {
      "code" : "3286",
      "display" : "Port - Taranaki"
    },
    {
      "code" : "3287",
      "display" : "Oceanic - Taranaki Region"
    },
    {
      "code" : "3288",
      "display" : "Oceanic-Oil Rigs Taranaki"
    },
    {
      "code" : "3289",
      "display" : "Oceanic-Tararua Constituency"
    },
    {
      "code" : "3291",
      "display" : "Inlet - Porirua Harbour"
    },
    {
      "code" : "3292",
      "display" : "Oceanic - Wellington Region"
    },
    {
      "code" : "3293",
      "display" : "Oceanic - Manawatu Wanganui Region"
    },
    {
      "code" : "3296",
      "display" : "Inlet - Ligar Bay"
    },
    {
      "code" : "3297",
      "display" : "Inlet - Buller River"
    },
    {
      "code" : "3298",
      "display" : "Oceanic - West Coast Region"
    },
    {
      "code" : "3300",
      "display" : "Kingswell - Clifton"
    },
    {
      "code" : "3301",
      "display" : "Fairfax"
    },
    {
      "code" : "3302",
      "display" : "Riverton East"
    },
    {
      "code" : "3303",
      "display" : "Riverton West"
    },
    {
      "code" : "3304",
      "display" : "Three Kings Islands"
    },
    {
      "code" : "3305",
      "display" : "Oceanic - Northland Region"
    },
    {
      "code" : "3306",
      "display" : "Inlet - Kaipara Harbour South"
    },
    {
      "code" : "3308",
      "display" : "Moutohora Island"
    },
    {
      "code" : "3309",
      "display" : "Oceanic - Bay of Plenty Region"
    },
    {
      "code" : "3310",
      "display" : "Oceanic - Tasman Region"
    },
    {
      "code" : "3311",
      "display" : "Oceanic - Nelson Region"
    },
    {
      "code" : "3312",
      "display" : "Oceanic - Marlborough Region"
    },
    {
      "code" : "3313",
      "display" : "Oceanic - Canterbury Region North"
    },
    {
      "code" : "3314",
      "display" : "Inlet - Port Lyttleton"
    },
    {
      "code" : "3315",
      "display" : "Mararoa River"
    },
    {
      "code" : "3316",
      "display" : "Inland Water-Lake Te Anau"
    },
    {
      "code" : "3317",
      "display" : "Fiordland"
    },
    {
      "code" : "3318",
      "display" : "Inland Water-Lake Manapouri"
    },
    {
      "code" : "3319",
      "display" : "Inland Water-Lake Hauroko"
    },
    {
      "code" : "3320",
      "display" : "Oceanic-Southland Region"
    },
    {
      "code" : "3321",
      "display" : "Oceanic-Kermadec Islands"
    },
    {
      "code" : "3322",
      "display" : "Kermadec Islands"
    },
    {
      "code" : "3323",
      "display" : "Inlet - Tutukaka Harbour"
    },
    {
      "code" : "3324",
      "display" : "Inlet - Whangarei Harbour"
    },
    {
      "code" : "3326",
      "display" : "Tidal-Manukau Harbour"
    },
    {
      "code" : "3328",
      "display" : "Tidal-Tamaki"
    },
    {
      "code" : "3329",
      "display" : "Oceanic-Hawke's Bay Region"
    },
    {
      "code" : "3330",
      "display" : "Oceanic-Auckland Region East"
    },
    {
      "code" : "3331",
      "display" : "Tidal-Great Barrier Island"
    },
    {
      "code" : "3332",
      "display" : "Tidal-Motutapu and Browns Islands"
    },
    {
      "code" : "3333",
      "display" : "Inlet-Manukau Harbour"
    },
    {
      "code" : "3334",
      "display" : "Tidal-Manukau Harbour  North"
    },
    {
      "code" : "3335",
      "display" : "Tamaki Strait"
    },
    {
      "code" : "3336",
      "display" : "Tidal-Eastern Bays"
    },
    {
      "code" : "3337",
      "display" : "Inlet-Waitemata Harbour"
    },
    {
      "code" : "3338",
      "display" : "Tidal-Waitemata Harbour"
    },
    {
      "code" : "3339",
      "display" : "Auckland City-Marinas"
    },
    {
      "code" : "3340",
      "display" : "Inlet-Wellington Harbour"
    },
    {
      "code" : "3341",
      "display" : "Seaview Marina"
    },
    {
      "code" : "3400",
      "display" : "Inlets - Banks Peninsula Bays"
    },
    {
      "code" : "3401",
      "display" : "Oceanic - Canterbury Region South"
    },
    {
      "code" : "3402",
      "display" : "Oceanic - Chatham Islands"
    },
    {
      "code" : "3403",
      "display" : "Inlet - Port Timaru"
    },
    {
      "code" : "3404",
      "display" : "Inlet - Otago Harbour"
    },
    {
      "code" : "3405",
      "display" : "Inlet - Dunedin City Bays"
    },
    {
      "code" : "3406",
      "display" : "Oceanic - Otago Region"
    },
    {
      "code" : "3407",
      "display" : "Inlet - Port Oamaru"
    },
    {
      "code" : "3408",
      "display" : "Inlet - Milford Sound"
    },
    {
      "code" : "3409",
      "display" : "Dog Island"
    },
    {
      "code" : "3411",
      "display" : "Centre Island"
    },
    {
      "code" : "3413",
      "display" : "Inlet - New River Estuary"
    },
    {
      "code" : "3414",
      "display" : "Oceanic-Oil Rig Southland"
    },
    {
      "code" : "3417",
      "display" : "Ross Dependency"
    },
    {
      "code" : "3500",
      "display" : "Inlet - Bluff Harbour"
    },
    {
      "code" : "3501",
      "display" : "Inlet - Jacobs River Estuary"
    },
    {
      "code" : "3502",
      "display" : "Oceanic-Campbell Island"
    },
    {
      "code" : "3503",
      "display" : "Campbell Island"
    },
    {
      "code" : "3504",
      "display" : "Oceanic-Auckland Islands"
    },
    {
      "code" : "3505",
      "display" : "Auckland Islands"
    },
    {
      "code" : "3506",
      "display" : "NZ Economic Zone"
    },
    {
      "code" : "3507",
      "display" : "Oceanic-Bounty Islands"
    },
    {
      "code" : "3508",
      "display" : "Bounty Islands"
    },
    {
      "code" : "3509",
      "display" : "Oceanic-Snares Islands"
    },
    {
      "code" : "3510",
      "display" : "Snares Island"
    },
    {
      "code" : "3511",
      "display" : "Oceanic-Antipodes Islands"
    },
    {
      "code" : "3512",
      "display" : "Antipodes Islands"
    },
    {
      "code" : "9999",
      "display" : "Overseas resident"
    },
    {
      "code" : "BD00",
      "display" : "Unknown Area Health Board"
    },
    {
      "code" : "BD01",
      "display" : "Northland Area Health board"
    },
    {
      "code" : "BD02",
      "display" : "Auckland Area Health Board"
    },
    {
      "code" : "BD03",
      "display" : "Waikato Area Health Board"
    },
    {
      "code" : "BD04",
      "display" : "Bay of Plenty Area Health Board"
    },
    {
      "code" : "BD05",
      "display" : "Tairawhiti Area Health Board"
    },
    {
      "code" : "BD06",
      "display" : "Hawke's Bay Area Health Board"
    },
    {
      "code" : "BD07",
      "display" : "Taranaki Area Health Board"
    },
    {
      "code" : "BD08",
      "display" : "Manawatu/Wanganui Area Health Board"
    },
    {
      "code" : "BD09",
      "display" : "Wellington Area Health Board"
    },
    {
      "code" : "BD10",
      "display" : "Nelson/Marlborough Area Health Board"
    },
    {
      "code" : "BD11",
      "display" : "Westland Area Health Board"
    },
    {
      "code" : "BD12",
      "display" : "Canterbury Area Health Board"
    },
    {
      "code" : "BD13",
      "display" : "Otago Area Health Board"
    },
    {
      "code" : "BD14",
      "display" : "Southland Area Health Board"
    },
    {
      "code" : "BD99",
      "display" : "Area Health Board not applicable"
    },
    {
      "code" : "D011",
      "display" : "Northland District Health Board"
    },
    {
      "code" : "D021",
      "display" : "Waitemata District Health Board"
    },
    {
      "code" : "D022",
      "display" : "Auckland District Health Board"
    },
    {
      "code" : "D023",
      "display" : "Counties Manukau District Health Board"
    },
    {
      "code" : "D031",
      "display" : "Waikato District Health Board"
    },
    {
      "code" : "D042",
      "display" : "Lakes District Health Board"
    },
    {
      "code" : "D047",
      "display" : "Bay of Plenty District Health Board"
    },
    {
      "code" : "D051",
      "display" : "Tairawhiti District Health Board"
    },
    {
      "code" : "D061",
      "display" : "Hawkes Bay District Health Board"
    },
    {
      "code" : "D071",
      "display" : "Taranaki District Health Board"
    },
    {
      "code" : "D081",
      "display" : "Mid Central District Health Board"
    },
    {
      "code" : "D082",
      "display" : "Whanganui District Health Board"
    },
    {
      "code" : "D091",
      "display" : "Capital and Coast District Health Board"
    },
    {
      "code" : "D092",
      "display" : "Hutt Valley District Health Board"
    },
    {
      "code" : "D093",
      "display" : "Wairarapa District Health Board"
    },
    {
      "code" : "D101",
      "display" : "Nelson Marlborough District Health Board"
    },
    {
      "code" : "D111",
      "display" : "West Coast District Health Board"
    },
    {
      "code" : "D121",
      "display" : "Canterbury District Health Board"
    },
    {
      "code" : "D123",
      "display" : "South Canterbury District Health Board"
    },
    {
      "code" : "D131",
      "display" : "Otago District Health Board"
    },
    {
      "code" : "D141",
      "display" : "Southland District Health Board"
    },
    {
      "code" : "D161",
      "display" : "Southern District Health Board"
    }
  ]
}

```
