# NZ Citizenship status - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NZ Citizenship status**

## CodeSystem: NZ Citizenship status 

| | |
| :--- | :--- |
| *Official URL*:https://standards.digital.health.nz/ns/nz-citizenship-status-code | *Version*:1.1.0 |
| Active as of 2025-12-18 | *Computable Name*:CitizenshipStatus |

 
Is this person a NZ Citizen 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CitizenshipStatus](ValueSet-citizenship-status.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "citizenship-status",
  "url" : "https://standards.digital.health.nz/ns/nz-citizenship-status-code",
  "version" : "1.1.0",
  "name" : "CitizenshipStatus",
  "title" : "NZ Citizenship status",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-18T23:25:53+00:00",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "Is this person a NZ Citizen",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "yes",
      "display" : "Yes",
      "definition" : "This person is a citizen."
    },
    {
      "code" : "no",
      "display" : "No",
      "definition" : "This person is not a citizen."
    },
    {
      "code" : "unknown",
      "display" : "Unknown",
      "definition" : "The citizenship status is unknown."
    }
  ]
}

```
