# Type of Alias - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Type of Alias**

## CodeSystem: Type of Alias 

| | |
| :--- | :--- |
| *Official URL*:https://standards.digital.health.nz/ns/alias-type-code | *Version*:1.0.0 |
| Active as of 2025-12-18 | *Computable Name*:AliasType |

 
Used in Organization and Location to indicate what is the type of Alias 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AliasType](ValueSet-location-alias-type.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "alias-type",
  "url" : "https://standards.digital.health.nz/ns/alias-type-code",
  "version" : "1.0.0",
  "name" : "AliasType",
  "title" : "Type of Alias",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-18T23:25:53+00:00",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "Used in Organization and Location to indicate what is the type of Alias",
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "aka",
      "display" : "Aka",
      "definition" : "The name by which the organisation or facility is also known as."
    },
    {
      "code" : "old",
      "display" : "Old",
      "definition" : "The previous legal name(s) of the organisation/facility."
    },
    {
      "code" : "maori",
      "display" : "Māori",
      "definition" : "The Māori name of the organisation or facility."
    },
    {
      "code" : "legal",
      "display" : "Legal",
      "definition" : "The name as recorded in the official register eg Register of Companies."
    },
    {
      "code" : "short",
      "display" : "Short",
      "definition" : "An abbreviated name by which the organisation or facility is known."
    },
    {
      "code" : "trade-as",
      "display" : "Trading as",
      "definition" : "Used when the organisation/facility has a separate trading name."
    },
    {
      "code" : "current",
      "display" : "Current",
      "definition" : "The name currently used for a facility."
    }
  ]
}

```
