# ACC Patient Occupation CodeSystem - HL7® FHIR® New Zealand Base Implementation Guide v3.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ACC Patient Occupation CodeSystem**

## CodeSystem: ACC Patient Occupation CodeSystem 

| | |
| :--- | :--- |
| *Official URL*:https://standards.digital.health.nz/ns/acc-patient-occupation-code | *Version*:1.0.0 |
| Active as of 2025-12-18 | *Computable Name*:AccPatientOccupationCodeSystem |

 
Codes for classifying patient occupations, drawn from the ACC codeset 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AccPatientOccupationValueSet](ValueSet-acc-patient-occupation-valueset.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "acc-patient-occupation-codesystem",
  "url" : "https://standards.digital.health.nz/ns/acc-patient-occupation-code",
  "version" : "1.0.0",
  "name" : "AccPatientOccupationCodeSystem",
  "title" : "ACC Patient Occupation CodeSystem",
  "status" : "active",
  "date" : "2025-12-18T23:25:53+00:00",
  "publisher" : "HL7 New Zealand",
  "contact" : [
    {
      "name" : "HL7 New Zealand",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:admin@hl7.org.nz"
        }
      ]
    }
  ],
  "description" : "Codes for classifying patient occupations, drawn from the ACC codeset",
  "caseSensitive" : false,
  "valueSet" : "https://nzhts.digital.health.nz/fhir/ValueSet/acc-patient-occupation-code",
  "content" : "complete",
  "count" : 6909,
  "concept" : [
    {
      "code" : "1111",
      "display" : "Legislator",
      "definition" : "Legislator"
    },
    {
      "code" : "1121",
      "display" : "Senior Government Administrator",
      "definition" : "Senior Government Administrator"
    },
    {
      "code" : "1131",
      "display" : "Senior Business Administrator",
      "definition" : "Senior Business Administrator"
    },
    {
      "code" : "1141",
      "display" : "Special-interest Org.administrator",
      "definition" : "Special-interest Org.administrator"
    },
    {
      "code" : "1211",
      "display" : "Corporate Mgr Or Managing Director",
      "definition" : "Corporate Mgr Or Managing Director"
    },
    {
      "code" : "1221",
      "display" : "Production & Operation Manager",
      "definition" : "Production & Operation Manager"
    },
    {
      "code" : "1222",
      "display" : "Finance & Administration Manager",
      "definition" : "Finance & Administration Manager"
    },
    {
      "code" : "1223",
      "display" : "Human Resources Manager",
      "definition" : "Human Resources Manager"
    },
    {
      "code" : "1224",
      "display" : "Sales & Marketing Manager",
      "definition" : "Sales & Marketing Manager"
    },
    {
      "code" : "1225",
      "display" : "Advertising & Public Relations Mgr",
      "definition" : "Advertising & Public Relations Mgr"
    },
    {
      "code" : "1226",
      "display" : "Supply & Distribution Manager",
      "definition" : "Supply & Distribution Manager"
    },
    {
      "code" : "1227",
      "display" : "Computing Services Manager",
      "definition" : "Computing Services Manager"
    },
    {
      "code" : "1228",
      "display" : "Research & Development Manager",
      "definition" : "Research & Development Manager"
    },
    {
      "code" : "1229",
      "display" : "Other Specialised Manager",
      "definition" : "Other Specialised Manager"
    },
    {
      "code" : "2111",
      "display" : "Physicist, Astronomer",
      "definition" : "Physicist, Astronomer"
    },
    {
      "code" : "2112",
      "display" : "Meteorologist",
      "definition" : "Meteorologist"
    },
    {
      "code" : "2113",
      "display" : "Chemist",
      "definition" : "Chemist"
    },
    {
      "code" : "2114",
      "display" : "Geologist, Geophysicist",
      "definition" : "Geologist, Geophysicist"
    },
    {
      "code" : "2121",
      "display" : "Mathematician, Statistician",
      "definition" : "Mathematician, Statistician"
    },
    {
      "code" : "2131",
      "display" : "Computing Professional",
      "definition" : "Computing Professional"
    },
    {
      "code" : "2141",
      "display" : "Architect,town Or Traffic Planner",
      "definition" : "Architect,town Or Traffic Planner"
    },
    {
      "code" : "2142",
      "display" : "Civil Engineer",
      "definition" : "Civil Engineer"
    },
    {
      "code" : "2143",
      "display" : "Electrical Engineer",
      "definition" : "Electrical Engineer"
    },
    {
      "code" : "2144",
      "display" : "Electronic & Telecomm. Engineer",
      "definition" : "Electronic & Telecomm. Engineer"
    },
    {
      "code" : "2145",
      "display" : "Mechanical Engineer",
      "definition" : "Mechanical Engineer"
    },
    {
      "code" : "2146",
      "display" : "Chemical Engineer",
      "definition" : "Chemical Engineer"
    },
    {
      "code" : "2147",
      "display" : "Mining Engineer, Metallurgist",
      "definition" : "Mining Engineer, Metallurgist"
    },
    {
      "code" : "2148",
      "display" : "Cartographer, Surveyor",
      "definition" : "Cartographer, Surveyor"
    },
    {
      "code" : "2211",
      "display" : "Biologist, Botanist, Zoologist",
      "definition" : "Biologist, Botanist, Zoologist"
    },
    {
      "code" : "2212",
      "display" : "Microbiologist Or Related Prof",
      "definition" : "Microbiologist Or Related Prof"
    },
    {
      "code" : "2213",
      "display" : "Agricultural Scientist",
      "definition" : "Agricultural Scientist"
    },
    {
      "code" : "2221",
      "display" : "Medical Doctor",
      "definition" : "Medical Doctor"
    },
    {
      "code" : "2222",
      "display" : "Dentist",
      "definition" : "Dentist"
    },
    {
      "code" : "2223",
      "display" : "Veterinarian",
      "definition" : "Veterinarian"
    },
    {
      "code" : "2224",
      "display" : "Pharmacist",
      "definition" : "Pharmacist"
    },
    {
      "code" : "2225",
      "display" : "Dietitian, Pub.health Nutritionist",
      "definition" : "Dietitian, Pub.health Nutritionist"
    },
    {
      "code" : "2226",
      "display" : "Other Health Professional",
      "definition" : "Other Health Professional"
    },
    {
      "code" : "2231",
      "display" : "Nursing & Midwifery Professional",
      "definition" : "Nursing & Midwifery Professional"
    },
    {
      "code" : "2311",
      "display" : "Tertiary Teaching Professional",
      "definition" : "Tertiary Teaching Professional"
    },
    {
      "code" : "2321",
      "display" : "Secondary Teaching Professional",
      "definition" : "Secondary Teaching Professional"
    },
    {
      "code" : "2331",
      "display" : "Primary Teaching Professional",
      "definition" : "Primary Teaching Professional"
    },
    {
      "code" : "2332",
      "display" : "Early Childhood Teaching Prof",
      "definition" : "Early Childhood Teaching Prof"
    },
    {
      "code" : "2341",
      "display" : "Special Education Teaching Prof",
      "definition" : "Special Education Teaching Prof"
    },
    {
      "code" : "2351",
      "display" : "Education Advisor",
      "definition" : "Education Advisor"
    },
    {
      "code" : "2352",
      "display" : "Education Reviewer",
      "definition" : "Education Reviewer"
    },
    {
      "code" : "2411",
      "display" : "Accountant",
      "definition" : "Accountant"
    },
    {
      "code" : "2412",
      "display" : "Personnel Professional",
      "definition" : "Personnel Professional"
    },
    {
      "code" : "2413",
      "display" : "Other Business Professional",
      "definition" : "Other Business Professional"
    },
    {
      "code" : "2421",
      "display" : "Barrister & Solicitor",
      "definition" : "Barrister & Solicitor"
    },
    {
      "code" : "2422",
      "display" : "Judge",
      "definition" : "Judge"
    },
    {
      "code" : "2423",
      "display" : "Other Legal Professional",
      "definition" : "Other Legal Professional"
    },
    {
      "code" : "2431",
      "display" : "Archivist, Curator",
      "definition" : "Archivist, Curator"
    },
    {
      "code" : "2432",
      "display" : "Librarian Or Related Info Prof",
      "definition" : "Librarian Or Related Info Prof"
    },
    {
      "code" : "2441",
      "display" : "Economist",
      "definition" : "Economist"
    },
    {
      "code" : "2442",
      "display" : "Social Scientist",
      "definition" : "Social Scientist"
    },
    {
      "code" : "2443",
      "display" : "Philologist,translator,interpreter",
      "definition" : "Philologist,translator,interpreter"
    },
    {
      "code" : "2444",
      "display" : "Psychologist",
      "definition" : "Psychologist"
    },
    {
      "code" : "2445",
      "display" : "Counsellor",
      "definition" : "Counsellor"
    },
    {
      "code" : "2446",
      "display" : "Other Government Professional",
      "definition" : "Other Government Professional"
    },
    {
      "code" : "2451",
      "display" : "Religious Professional",
      "definition" : "Religious Professional"
    },
    {
      "code" : "3111",
      "display" : "Physical Science Technician",
      "definition" : "Physical Science Technician"
    },
    {
      "code" : "3112",
      "display" : "Civil Engineering Technician",
      "definition" : "Civil Engineering Technician"
    },
    {
      "code" : "3113",
      "display" : "Electrical Engineering Technician",
      "definition" : "Electrical Engineering Technician"
    },
    {
      "code" : "3114",
      "display" : "Electronic Engineering Technician",
      "definition" : "Electronic Engineering Technician"
    },
    {
      "code" : "3115",
      "display" : "Mechanical Engineering Technician",
      "definition" : "Mechanical Engineering Technician"
    },
    {
      "code" : "3116",
      "display" : "Chemical Engineering Technician",
      "definition" : "Chemical Engineering Technician"
    },
    {
      "code" : "3117",
      "display" : "Mining & Metallurgical Technician",
      "definition" : "Mining & Metallurgical Technician"
    },
    {
      "code" : "3118",
      "display" : "Draughting Technician",
      "definition" : "Draughting Technician"
    },
    {
      "code" : "3119",
      "display" : "Other Engineering Technician",
      "definition" : "Other Engineering Technician"
    },
    {
      "code" : "3121",
      "display" : "Computer Equipment Controller",
      "definition" : "Computer Equipment Controller"
    },
    {
      "code" : "3131",
      "display" : "Photographr & Recordng Equip Cntrl",
      "definition" : "Photographr & Recordng Equip Cntrl"
    },
    {
      "code" : "3132",
      "display" : "Broadcasting Equip. Controller",
      "definition" : "Broadcasting Equip. Controller"
    },
    {
      "code" : "3133",
      "display" : "Medical Equipment Controller",
      "definition" : "Medical Equipment Controller"
    },
    {
      "code" : "3141",
      "display" : "Ships Engineer",
      "definition" : "Ships Engineer"
    },
    {
      "code" : "3142",
      "display" : "Ships Deck Officer & Pilot",
      "definition" : "Ships Deck Officer & Pilot"
    },
    {
      "code" : "3143",
      "display" : "Aircraft Pilot Or Related Worker",
      "definition" : "Aircraft Pilot Or Related Worker"
    },
    {
      "code" : "3144",
      "display" : "Air Traffic Controller",
      "definition" : "Air Traffic Controller"
    },
    {
      "code" : "3151",
      "display" : "Safety & Health Inspector",
      "definition" : "Safety & Health Inspector"
    },
    {
      "code" : "3211",
      "display" : "Life Science Technician",
      "definition" : "Life Science Technician"
    },
    {
      "code" : "3212",
      "display" : "Agricultral Technician",
      "definition" : "Agricultral Technician"
    },
    {
      "code" : "3221",
      "display" : "Optician",
      "definition" : "Optician"
    },
    {
      "code" : "3222",
      "display" : "Dental Assistant",
      "definition" : "Dental Assistant"
    },
    {
      "code" : "3223",
      "display" : "Physiotherapist",
      "definition" : "Physiotherapist"
    },
    {
      "code" : "3224",
      "display" : "Veterinary Assistant",
      "definition" : "Veterinary Assistant"
    },
    {
      "code" : "3225",
      "display" : "Pharmaceutical Assistant",
      "definition" : "Pharmaceutical Assistant"
    },
    {
      "code" : "3226",
      "display" : "Other Health Associate Professionl",
      "definition" : "Other Health Associate Professionl"
    },
    {
      "code" : "3231",
      "display" : "Nursing Associate Professional",
      "definition" : "Nursing Associate Professional"
    },
    {
      "code" : "3311",
      "display" : "Securities & Finance Dealer,broker",
      "definition" : "Securities & Finance Dealer,broker"
    },
    {
      "code" : "3312",
      "display" : "Insurance Representative",
      "definition" : "Insurance Representative"
    },
    {
      "code" : "3313",
      "display" : "Real Estate Agent",
      "definition" : "Real Estate Agent"
    },
    {
      "code" : "3314",
      "display" : "Travel Consultant, Organiser",
      "definition" : "Travel Consultant, Organiser"
    },
    {
      "code" : "3315",
      "display" : "Technical & Commercial Sales Rep",
      "definition" : "Technical & Commercial Sales Rep"
    },
    {
      "code" : "3316",
      "display" : "Buyer",
      "definition" : "Buyer"
    },
    {
      "code" : "3317",
      "display" : "Appraiser, Valuer",
      "definition" : "Appraiser, Valuer"
    },
    {
      "code" : "3318",
      "display" : "Auctioneer",
      "definition" : "Auctioneer"
    },
    {
      "code" : "3319",
      "display" : "Other Finance,sales Associate Prof",
      "definition" : "Other Finance,sales Associate Prof"
    },
    {
      "code" : "3321",
      "display" : "Admin Or Related Associate Prof",
      "definition" : "Admin Or Related Associate Prof"
    },
    {
      "code" : "3322",
      "display" : "Legal Or Rel. Business Assoc. Prof",
      "definition" : "Legal Or Rel. Business Assoc. Prof"
    },
    {
      "code" : "3323",
      "display" : "Bookkeeper",
      "definition" : "Bookkeeper"
    },
    {
      "code" : "3324",
      "display" : "Statistical,mathematical Ass. Prof",
      "definition" : "Statistical,mathematical Ass. Prof"
    },
    {
      "code" : "3331",
      "display" : "Customs & Border Inspector",
      "definition" : "Customs & Border Inspector"
    },
    {
      "code" : "3341",
      "display" : "Social Work Associate Professional",
      "definition" : "Social Work Associate Professional"
    },
    {
      "code" : "3342",
      "display" : "Education Associate Professional",
      "definition" : "Education Associate Professional"
    },
    {
      "code" : "3351",
      "display" : "Careers & Employment Advisor",
      "definition" : "Careers & Employment Advisor"
    },
    {
      "code" : "3361",
      "display" : "Author,journalist Or Other Writer",
      "definition" : "Author,journalist Or Other Writer"
    },
    {
      "code" : "3362",
      "display" : "Sculptor,painter Or Related Artist",
      "definition" : "Sculptor,painter Or Related Artist"
    },
    {
      "code" : "3363",
      "display" : "Decorator, Commercial Designer",
      "definition" : "Decorator, Commercial Designer"
    },
    {
      "code" : "3364",
      "display" : "Composer, Musician, Singer",
      "definition" : "Composer, Musician, Singer"
    },
    {
      "code" : "3365",
      "display" : "Choreographer, Dancer",
      "definition" : "Choreographer, Dancer"
    },
    {
      "code" : "3366",
      "display" : "Film,stage Or Rel.actor Or Directr",
      "definition" : "Film,stage Or Rel.actor Or Directr"
    },
    {
      "code" : "3367",
      "display" : "Radio,television,other Announcer",
      "definition" : "Radio,television,other Announcer"
    },
    {
      "code" : "3368",
      "display" : "Clown, Magician Or Rel. Worker",
      "definition" : "Clown, Magician Or Rel. Worker"
    },
    {
      "code" : "3369",
      "display" : "Athlete Or Related Worker",
      "definition" : "Athlete Or Related Worker"
    },
    {
      "code" : "3371",
      "display" : "Non-ordained Religious Assoc. Prof",
      "definition" : "Non-ordained Religious Assoc. Prof"
    },
    {
      "code" : "3381",
      "display" : "Environment Protection Assoc. Prof",
      "definition" : "Environment Protection Assoc. Prof"
    },
    {
      "code" : "4111",
      "display" : "Typist Or Word Processor Operator",
      "definition" : "Typist Or Word Processor Operator"
    },
    {
      "code" : "4112",
      "display" : "Data Entry Operator",
      "definition" : "Data Entry Operator"
    },
    {
      "code" : "4114",
      "display" : "Secretary",
      "definition" : "Secretary"
    },
    {
      "code" : "4121",
      "display" : "Accounting, Bookkeeping Clerk",
      "definition" : "Accounting, Bookkeeping Clerk"
    },
    {
      "code" : "4122",
      "display" : "Statistical, Finance Clerk",
      "definition" : "Statistical, Finance Clerk"
    },
    {
      "code" : "4131",
      "display" : "Stock Clerk",
      "definition" : "Stock Clerk"
    },
    {
      "code" : "4132",
      "display" : "Production Clerk",
      "definition" : "Production Clerk"
    },
    {
      "code" : "4133",
      "display" : "Transport Clerk",
      "definition" : "Transport Clerk"
    },
    {
      "code" : "4141",
      "display" : "Library, Filing Clerk",
      "definition" : "Library, Filing Clerk"
    },
    {
      "code" : "4142",
      "display" : "Mail Carrier, Sorting Clerk",
      "definition" : "Mail Carrier, Sorting Clerk"
    },
    {
      "code" : "4143",
      "display" : "Coding,proof Reading Or Rel. Clerk",
      "definition" : "Coding,proof Reading Or Rel. Clerk"
    },
    {
      "code" : "4144",
      "display" : "Office Clerk",
      "definition" : "Office Clerk"
    },
    {
      "code" : "4211",
      "display" : "Cashier, Ticket Issuer",
      "definition" : "Cashier, Ticket Issuer"
    },
    {
      "code" : "4212",
      "display" : "Teller Or Other Counter Clerk",
      "definition" : "Teller Or Other Counter Clerk"
    },
    {
      "code" : "4213",
      "display" : "Croupier",
      "definition" : "Croupier"
    },
    {
      "code" : "4215",
      "display" : "Bill,debt Or Rel. Cash Collector",
      "definition" : "Bill,debt Or Rel. Cash Collector"
    },
    {
      "code" : "4221",
      "display" : "Receptionist, Information Clerk",
      "definition" : "Receptionist, Information Clerk"
    },
    {
      "code" : "4222",
      "display" : "Telephone Switchboard Operator",
      "definition" : "Telephone Switchboard Operator"
    },
    {
      "code" : "5111",
      "display" : "Travel Attendant",
      "definition" : "Travel Attendant"
    },
    {
      "code" : "5112",
      "display" : "Travel Guide",
      "definition" : "Travel Guide"
    },
    {
      "code" : "5121",
      "display" : "Housekeeper",
      "definition" : "Housekeeper"
    },
    {
      "code" : "5122",
      "display" : "Cook",
      "definition" : "Cook"
    },
    {
      "code" : "5123",
      "display" : "Waiter, Bartender",
      "definition" : "Waiter, Bartender"
    },
    {
      "code" : "5131",
      "display" : "Personal Care Worker",
      "definition" : "Personal Care Worker"
    },
    {
      "code" : "5141",
      "display" : "Hairdressr,beautician Or Rel.workr",
      "definition" : "Hairdressr,beautician Or Rel.workr"
    },
    {
      "code" : "5142",
      "display" : "Child Care Worker",
      "definition" : "Child Care Worker"
    },
    {
      "code" : "5143",
      "display" : "Undertaker, Embalmer",
      "definition" : "Undertaker, Embalmer"
    },
    {
      "code" : "5151",
      "display" : "Fire Fighter",
      "definition" : "Fire Fighter"
    },
    {
      "code" : "5152",
      "display" : "Police",
      "definition" : "Police"
    },
    {
      "code" : "5153",
      "display" : "Prison Guard",
      "definition" : "Prison Guard"
    },
    {
      "code" : "5154",
      "display" : "Other Protective Service Worker",
      "definition" : "Other Protective Service Worker"
    },
    {
      "code" : "5155",
      "display" : "Armed Forces",
      "definition" : "Armed Forces"
    },
    {
      "code" : "5211",
      "display" : "Salesperson, Demonstrator",
      "definition" : "Salesperson, Demonstrator"
    },
    {
      "code" : "5221",
      "display" : "Street Vendor",
      "definition" : "Street Vendor"
    },
    {
      "code" : "5231",
      "display" : "Fashion Or Other Model",
      "definition" : "Fashion Or Other Model"
    },
    {
      "code" : "6111",
      "display" : "Field Crop, Vegetable Grower",
      "definition" : "Field Crop, Vegetable Grower"
    },
    {
      "code" : "6112",
      "display" : "Fruit Grower",
      "definition" : "Fruit Grower"
    },
    {
      "code" : "6113",
      "display" : "Gardener, Nursery Grower",
      "definition" : "Gardener, Nursery Grower"
    },
    {
      "code" : "6121",
      "display" : "Livestock Producer",
      "definition" : "Livestock Producer"
    },
    {
      "code" : "6122",
      "display" : "Mixed Livestock Producer",
      "definition" : "Mixed Livestock Producer"
    },
    {
      "code" : "6123",
      "display" : "Poultry Producer",
      "definition" : "Poultry Producer"
    },
    {
      "code" : "6124",
      "display" : "Apiarist",
      "definition" : "Apiarist"
    },
    {
      "code" : "6125",
      "display" : "Crop & Livestock Producer",
      "definition" : "Crop & Livestock Producer"
    },
    {
      "code" : "6126",
      "display" : "Other Agricultural Worker",
      "definition" : "Other Agricultural Worker"
    },
    {
      "code" : "6131",
      "display" : "Forestry Worker, Logger",
      "definition" : "Forestry Worker, Logger"
    },
    {
      "code" : "6141",
      "display" : "Fishery Worker",
      "definition" : "Fishery Worker"
    },
    {
      "code" : "6142",
      "display" : "Aquatic Life Cultivation Worker",
      "definition" : "Aquatic Life Cultivation Worker"
    },
    {
      "code" : "6143",
      "display" : "Hunter, Trapper",
      "definition" : "Hunter, Trapper"
    },
    {
      "code" : "6144",
      "display" : "Animal Welfare Worker",
      "definition" : "Animal Welfare Worker"
    },
    {
      "code" : "7111",
      "display" : "Bricklayer, Stonemason",
      "definition" : "Bricklayer, Stonemason"
    },
    {
      "code" : "7112",
      "display" : "Carpenter & Joiner",
      "definition" : "Carpenter & Joiner"
    },
    {
      "code" : "7121",
      "display" : "Plasterer",
      "definition" : "Plasterer"
    },
    {
      "code" : "7122",
      "display" : "Glazier",
      "definition" : "Glazier"
    },
    {
      "code" : "7123",
      "display" : "Plumber",
      "definition" : "Plumber"
    },
    {
      "code" : "7124",
      "display" : "Painter & Paperhanger",
      "definition" : "Painter & Paperhanger"
    },
    {
      "code" : "7131",
      "display" : "Electrician",
      "definition" : "Electrician"
    },
    {
      "code" : "7211",
      "display" : "Metal Moulder",
      "definition" : "Metal Moulder"
    },
    {
      "code" : "7212",
      "display" : "Sheet-metal Worker",
      "definition" : "Sheet-metal Worker"
    },
    {
      "code" : "7221",
      "display" : "Blacksmith",
      "definition" : "Blacksmith"
    },
    {
      "code" : "7222",
      "display" : "Tool Or Pattern Maker,metal Marker",
      "definition" : "Tool Or Pattern Maker,metal Marker"
    },
    {
      "code" : "7223",
      "display" : "Fitter & Turner",
      "definition" : "Fitter & Turner"
    },
    {
      "code" : "7224",
      "display" : "Saw Doctor",
      "definition" : "Saw Doctor"
    },
    {
      "code" : "7231",
      "display" : "Machinery Mechanic & Fitter",
      "definition" : "Machinery Mechanic & Fitter"
    },
    {
      "code" : "7241",
      "display" : "Electrical Mechanic & Fitter",
      "definition" : "Electrical Mechanic & Fitter"
    },
    {
      "code" : "7242",
      "display" : "Electronics Fitter & Servicer",
      "definition" : "Electronics Fitter & Servicer"
    },
    {
      "code" : "7243",
      "display" : "Radio & Television Servicer",
      "definition" : "Radio & Television Servicer"
    },
    {
      "code" : "7311",
      "display" : "Precision Inst. Maker & Repairer",
      "definition" : "Precision Inst. Maker & Repairer"
    },
    {
      "code" : "7312",
      "display" : "Musical Instrument Maker, Tuner",
      "definition" : "Musical Instrument Maker, Tuner"
    },
    {
      "code" : "7313",
      "display" : "Jeweller,precious Met.trade Worker",
      "definition" : "Jeweller,precious Met.trade Worker"
    },
    {
      "code" : "7321",
      "display" : "Glass Cutter & Finisher",
      "definition" : "Glass Cutter & Finisher"
    },
    {
      "code" : "7331",
      "display" : "Printing Trades Worker",
      "definition" : "Printing Trades Worker"
    },
    {
      "code" : "7332",
      "display" : "Binding Trades Worker",
      "definition" : "Binding Trades Worker"
    },
    {
      "code" : "7333",
      "display" : "Printing Engraver & Etcher",
      "definition" : "Printing Engraver & Etcher"
    },
    {
      "code" : "7411",
      "display" : "Butcher",
      "definition" : "Butcher"
    },
    {
      "code" : "7412",
      "display" : "Baker",
      "definition" : "Baker"
    },
    {
      "code" : "7421",
      "display" : "Cabinet Maker Or Related Worker",
      "definition" : "Cabinet Maker Or Related Worker"
    },
    {
      "code" : "7431",
      "display" : "Tailor & Dressmaker",
      "definition" : "Tailor & Dressmaker"
    },
    {
      "code" : "7432",
      "display" : "Upholsterer Or Related Worker",
      "definition" : "Upholsterer Or Related Worker"
    },
    {
      "code" : "7433",
      "display" : "Floor Covering Layer",
      "definition" : "Floor Covering Layer"
    },
    {
      "code" : "7441",
      "display" : "Leather Goods Maker",
      "definition" : "Leather Goods Maker"
    },
    {
      "code" : "8111",
      "display" : "Mining Plant Operator",
      "definition" : "Mining Plant Operator"
    },
    {
      "code" : "8112",
      "display" : "Mineral Ore, Stone Treat Plant Op",
      "definition" : "Mineral Ore, Stone Treat Plant Op"
    },
    {
      "code" : "8113",
      "display" : "Well Driller, Borer & Rel. Worker",
      "definition" : "Well Driller, Borer & Rel. Worker"
    },
    {
      "code" : "8121",
      "display" : "Ore Smelting & Refining Furnace Op",
      "definition" : "Ore Smelting & Refining Furnace Op"
    },
    {
      "code" : "8122",
      "display" : "Metal Melter, Caster",
      "definition" : "Metal Melter, Caster"
    },
    {
      "code" : "8123",
      "display" : "Metal Welder",
      "definition" : "Metal Welder"
    },
    {
      "code" : "8124",
      "display" : "Metal Drawer & Extruder",
      "definition" : "Metal Drawer & Extruder"
    },
    {
      "code" : "8131",
      "display" : "Glass & Ceramics Kiln Operator",
      "definition" : "Glass & Ceramics Kiln Operator"
    },
    {
      "code" : "8132",
      "display" : "Other Glass & Ceramics Worker",
      "definition" : "Other Glass & Ceramics Worker"
    },
    {
      "code" : "8141",
      "display" : "Sawmill Or Rel. Wood Processing Op",
      "definition" : "Sawmill Or Rel. Wood Processing Op"
    },
    {
      "code" : "8142",
      "display" : "Paper Pulp Preparation Plant Op",
      "definition" : "Paper Pulp Preparation Plant Op"
    },
    {
      "code" : "8143",
      "display" : "Papermaking Plant Operator",
      "definition" : "Papermaking Plant Operator"
    },
    {
      "code" : "8151",
      "display" : "Crushing,grinding,mixing Equip. Op",
      "definition" : "Crushing,grinding,mixing Equip. Op"
    },
    {
      "code" : "8152",
      "display" : "Filtering & Separating Equip. Op",
      "definition" : "Filtering & Separating Equip. Op"
    },
    {
      "code" : "8153",
      "display" : "Still & Reactor Operator",
      "definition" : "Still & Reactor Operator"
    },
    {
      "code" : "8154",
      "display" : "Other Chemical Processing Plant Op",
      "definition" : "Other Chemical Processing Plant Op"
    },
    {
      "code" : "8161",
      "display" : "Power Generating Plant Operator",
      "definition" : "Power Generating Plant Operator"
    },
    {
      "code" : "8211",
      "display" : "Machine Tool Operator",
      "definition" : "Machine Tool Operator"
    },
    {
      "code" : "8212",
      "display" : "Cement & Other Processing Mach Op",
      "definition" : "Cement & Other Processing Mach Op"
    },
    {
      "code" : "8221",
      "display" : "Pharmaceutical Products Mach Op",
      "definition" : "Pharmaceutical Products Mach Op"
    },
    {
      "code" : "8222",
      "display" : "Metal Finisher, Plater, Coater",
      "definition" : "Metal Finisher, Plater, Coater"
    },
    {
      "code" : "8223",
      "display" : "Photographic Products Machine Op",
      "definition" : "Photographic Products Machine Op"
    },
    {
      "code" : "8231",
      "display" : "Tyre Making Vulcanising Mach Op",
      "definition" : "Tyre Making Vulcanising Mach Op"
    },
    {
      "code" : "8232",
      "display" : "Other Rubber, Plastic Prod Mach Op",
      "definition" : "Other Rubber, Plastic Prod Mach Op"
    },
    {
      "code" : "8241",
      "display" : "Wood Products Machine Operator",
      "definition" : "Wood Products Machine Operator"
    },
    {
      "code" : "8242",
      "display" : "Wood Treater",
      "definition" : "Wood Treater"
    },
    {
      "code" : "8251",
      "display" : "Paper & Paper Products Mach Op",
      "definition" : "Paper & Paper Products Mach Op"
    },
    {
      "code" : "8261",
      "display" : "Spinning, Winding Machine Operator",
      "definition" : "Spinning, Winding Machine Operator"
    },
    {
      "code" : "8262",
      "display" : "Weaving, Knitting Machine Operator",
      "definition" : "Weaving, Knitting Machine Operator"
    },
    {
      "code" : "8263",
      "display" : "Sewing, Embroidering Mach. Op",
      "definition" : "Sewing, Embroidering Mach. Op"
    },
    {
      "code" : "8264",
      "display" : "Textile Dyeing, Cleaning Mach Op",
      "definition" : "Textile Dyeing, Cleaning Mach Op"
    },
    {
      "code" : "8265",
      "display" : "Other Textile Products Machine Op",
      "definition" : "Other Textile Products Machine Op"
    },
    {
      "code" : "8271",
      "display" : "Meat, Fish Processing Machine Op",
      "definition" : "Meat, Fish Processing Machine Op"
    },
    {
      "code" : "8272",
      "display" : "Dairy Products Machine Operator",
      "definition" : "Dairy Products Machine Operator"
    },
    {
      "code" : "8273",
      "display" : "Grain Milling Machine Operator",
      "definition" : "Grain Milling Machine Operator"
    },
    {
      "code" : "8274",
      "display" : "Baked Goods, Cereals Prod Mach Op",
      "definition" : "Baked Goods, Cereals Prod Mach Op"
    },
    {
      "code" : "8275",
      "display" : "Fruit,vege,nut Process. Mach Op",
      "definition" : "Fruit,vege,nut Process. Mach Op"
    },
    {
      "code" : "8276",
      "display" : "Sugar Process, Refining Mach Op",
      "definition" : "Sugar Process, Refining Mach Op"
    },
    {
      "code" : "8277",
      "display" : "Tea,coffee,cocoa Machine Operator",
      "definition" : "Tea,coffee,cocoa Machine Operator"
    },
    {
      "code" : "8278",
      "display" : "Tobacco Prods Process. Mach Op",
      "definition" : "Tobacco Prods Process. Mach Op"
    },
    {
      "code" : "8279",
      "display" : "Brewer, Wine & Beverage Mach Op",
      "definition" : "Brewer, Wine & Beverage Mach Op"
    },
    {
      "code" : "8281",
      "display" : "Leather & Rel. Products Processor",
      "definition" : "Leather & Rel. Products Processor"
    },
    {
      "code" : "8291",
      "display" : "Mechanical Machinery Assembler",
      "definition" : "Mechanical Machinery Assembler"
    },
    {
      "code" : "8292",
      "display" : "Electrical Machinery Assembler",
      "definition" : "Electrical Machinery Assembler"
    },
    {
      "code" : "8293",
      "display" : "Metal,rubber &plastic Prods Assemb",
      "definition" : "Metal,rubber &plastic Prods Assemb"
    },
    {
      "code" : "8294",
      "display" : "Wood &rel Material Prods Assemblr",
      "definition" : "Wood &rel Material Prods Assemblr"
    },
    {
      "code" : "8295",
      "display" : "Leather Goods Assembler",
      "definition" : "Leather Goods Assembler"
    },
    {
      "code" : "8311",
      "display" : "Railway Engine Driver",
      "definition" : "Railway Engine Driver"
    },
    {
      "code" : "8321",
      "display" : "Car, Taxi, Light Van Driver",
      "definition" : "Car, Taxi, Light Van Driver"
    },
    {
      "code" : "8322",
      "display" : "Bus Driver",
      "definition" : "Bus Driver"
    },
    {
      "code" : "8323",
      "display" : "Heavy Truck Driver",
      "definition" : "Heavy Truck Driver"
    },
    {
      "code" : "8331",
      "display" : "Motorised Farm Machinery Operator",
      "definition" : "Motorised Farm Machinery Operator"
    },
    {
      "code" : "8332",
      "display" : "Earthmoving Or Rel. Machinery Op",
      "definition" : "Earthmoving Or Rel. Machinery Op"
    },
    {
      "code" : "8333",
      "display" : "Crane Operator",
      "definition" : "Crane Operator"
    },
    {
      "code" : "8334",
      "display" : "Lifting-truck Operator",
      "definition" : "Lifting-truck Operator"
    },
    {
      "code" : "8341",
      "display" : "Ships Deck Crew Or Rel. Worker",
      "definition" : "Ships Deck Crew Or Rel. Worker"
    },
    {
      "code" : "8411",
      "display" : "Building Or Related Worker",
      "definition" : "Building Or Related Worker"
    },
    {
      "code" : "8412",
      "display" : "Underwater Worker",
      "definition" : "Underwater Worker"
    },
    {
      "code" : "9111",
      "display" : "Caretaker, Cleaner",
      "definition" : "Caretaker, Cleaner"
    },
    {
      "code" : "9121",
      "display" : "Messenger, Doorkeeper",
      "definition" : "Messenger, Doorkeeper"
    },
    {
      "code" : "9131",
      "display" : "Refuse Collector Or Rel. Labourer",
      "definition" : "Refuse Collector Or Rel. Labourer"
    },
    {
      "code" : "9141",
      "display" : "Packer, Freight Handler",
      "definition" : "Packer, Freight Handler"
    },
    {
      "code" : "9151",
      "display" : "Labourer",
      "definition" : "Labourer"
    },
    {
      "code" : "9970",
      "display" : "Occupation Unidentified/inadequate",
      "definition" : "Occupation Unidentified/inadequate"
    },
    {
      "code" : "9980",
      "display" : "Workers Not Reporting Any Descrip",
      "definition" : "Workers Not Reporting Any Descrip"
    },
    {
      "code" : "9991",
      "display" : "Housewife \\ Househusband",
      "definition" : "Housewife \\ Househusband"
    },
    {
      "code" : "9992",
      "display" : "Sickness Beneficiary",
      "definition" : "Sickness Beneficiary"
    },
    {
      "code" : "9993",
      "display" : "Retired",
      "definition" : "Retired"
    },
    {
      "code" : "9994",
      "display" : "Student",
      "definition" : "Student"
    },
    {
      "code" : "9995",
      "display" : "Overseas Visitor",
      "definition" : "Overseas Visitor"
    },
    {
      "code" : "9996",
      "display" : "Unemployed",
      "definition" : "Unemployed"
    },
    {
      "code" : "9997",
      "display" : "Pre-school Child",
      "definition" : "Pre-school Child"
    },
    {
      "code" : "9998",
      "display" : "Prison Inmate",
      "definition" : "Prison Inmate"
    },
    {
      "code" : "9999",
      "display" : "Not Obtainable",
      "definition" : "Not Obtainable"
    },
    {
      "code" : "1111.001",
      "display" : "Cabinet Minister",
      "definition" : "Cabinet Minister"
    },
    {
      "code" : "1111.002",
      "display" : "Central Government Politician",
      "definition" : "Central Government Politician"
    },
    {
      "code" : "1111.003",
      "display" : "City Council Chairman",
      "definition" : "City Council Chairman"
    },
    {
      "code" : "1111.004",
      "display" : "City Councillor",
      "definition" : "City Councillor"
    },
    {
      "code" : "1111.005",
      "display" : "Councillor",
      "definition" : "Councillor"
    },
    {
      "code" : "1111.006",
      "display" : "Government Minister",
      "definition" : "Government Minister"
    },
    {
      "code" : "1111.007",
      "display" : "Local Government Legislator",
      "definition" : "Local Government Legislator"
    },
    {
      "code" : "1111.008",
      "display" : "Mayor",
      "definition" : "Mayor"
    },
    {
      "code" : "1111.009",
      "display" : "Member of Parliament",
      "definition" : "Member of Parliament"
    },
    {
      "code" : "1111.010",
      "display" : "Minister of the Crown",
      "definition" : "Minister of the Crown"
    },
    {
      "code" : "1111.011",
      "display" : "Parliamentary Representative",
      "definition" : "Parliamentary Representative"
    },
    {
      "code" : "1111.012",
      "display" : "Regional Councillor",
      "definition" : "Regional Councillor"
    },
    {
      "code" : "1121.001",
      "display" : "Ambassador",
      "definition" : "Ambassador"
    },
    {
      "code" : "1121.002",
      "display" : "Censor",
      "definition" : "Censor"
    },
    {
      "code" : "1121.003",
      "display" : "Central Government Administrator",
      "definition" : "Central Government Administrator"
    },
    {
      "code" : "1121.004",
      "display" : "Charge daffaires",
      "definition" : "Charge daffaires"
    },
    {
      "code" : "1121.005",
      "display" : "Chief Executive - Central Government",
      "definition" : "Chief Executive - Central Government"
    },
    {
      "code" : "1121.006",
      "display" : "Chief Executive - Local Government",
      "definition" : "Chief Executive - Local Government"
    },
    {
      "code" : "1121.007",
      "display" : "City Administrator",
      "definition" : "City Administrator"
    },
    {
      "code" : "1121.008",
      "display" : "Civil Defence Officer",
      "definition" : "Civil Defence Officer"
    },
    {
      "code" : "1121.009",
      "display" : "Commissioner of Inland Revenue",
      "definition" : "Commissioner of Inland Revenue"
    },
    {
      "code" : "1121.010",
      "display" : "Consul General",
      "definition" : "Consul General"
    },
    {
      "code" : "1121.011",
      "display" : "Consular Affairs Officer",
      "definition" : "Consular Affairs Officer"
    },
    {
      "code" : "1121.012",
      "display" : "Controller of Customs",
      "definition" : "Controller of Customs"
    },
    {
      "code" : "1121.013",
      "display" : "Diplomatic Representative",
      "definition" : "Diplomatic Representative"
    },
    {
      "code" : "1121.014",
      "display" : "Government Administration Director",
      "definition" : "Government Administration Director"
    },
    {
      "code" : "1121.015",
      "display" : "Government Department Head",
      "definition" : "Government Department Head"
    },
    {
      "code" : "1121.016",
      "display" : "Government Divisional Director",
      "definition" : "Government Divisional Director"
    },
    {
      "code" : "1121.017",
      "display" : "Government Executive Official",
      "definition" : "Government Executive Official"
    },
    {
      "code" : "1121.018",
      "display" : "Governor General",
      "definition" : "Governor General"
    },
    {
      "code" : "1121.019",
      "display" : "High Commissioner",
      "definition" : "High Commissioner"
    },
    {
      "code" : "1121.020",
      "display" : "Local Government Administrator",
      "definition" : "Local Government Administrator"
    },
    {
      "code" : "1121.021",
      "display" : "Patents Commissioner",
      "definition" : "Patents Commissioner"
    },
    {
      "code" : "1121.022",
      "display" : "Police Commissioner",
      "definition" : "Police Commissioner"
    },
    {
      "code" : "1121.023",
      "display" : "Public Service Administrator",
      "definition" : "Public Service Administrator"
    },
    {
      "code" : "1121.024",
      "display" : "Public Service Commissioner",
      "definition" : "Public Service Commissioner"
    },
    {
      "code" : "1121.025",
      "display" : "Registrar General",
      "definition" : "Registrar General"
    },
    {
      "code" : "1121.026",
      "display" : "Senior Central Government Official",
      "definition" : "Senior Central Government Official"
    },
    {
      "code" : "1121.027",
      "display" : "Senior Local Government Official",
      "definition" : "Senior Local Government Official"
    },
    {
      "code" : "1121.028",
      "display" : "State Services Commissioner",
      "definition" : "State Services Commissioner"
    },
    {
      "code" : "1121.029",
      "display" : "Town Clerk",
      "definition" : "Town Clerk"
    },
    {
      "code" : "1121.030",
      "display" : "Vice Consul",
      "definition" : "Vice Consul"
    },
    {
      "code" : "1131.001",
      "display" : "Business Chief Executive",
      "definition" : "Business Chief Executive"
    },
    {
      "code" : "1131.002",
      "display" : "CEO",
      "definition" : "CEO"
    },
    {
      "code" : "1131.003",
      "display" : "Chief Executive",
      "definition" : "Chief Executive"
    },
    {
      "code" : "1131.004",
      "display" : "Chief Executive and/or Managing Director",
      "definition" : "Chief Executive and/or Managing Director"
    },
    {
      "code" : "1131.005",
      "display" : "Chief Executive Officer",
      "definition" : "Chief Executive Officer"
    },
    {
      "code" : "1131.007",
      "display" : "Company President",
      "definition" : "Company President"
    },
    {
      "code" : "1131.008",
      "display" : "Executive Director",
      "definition" : "Executive Director"
    },
    {
      "code" : "1131.009",
      "display" : "Hospital Executive Officer",
      "definition" : "Hospital Executive Officer"
    },
    {
      "code" : "1131.010",
      "display" : "Internet Chief Executive Officer",
      "definition" : "Internet Chief Executive Officer"
    },
    {
      "code" : "1131.011",
      "display" : "Managing Director",
      "definition" : "Managing Director"
    },
    {
      "code" : "1131.012",
      "display" : "NZ Port Authority Administrator",
      "definition" : "NZ Port Authority Administrator"
    },
    {
      "code" : "1131.013",
      "display" : "Senior Business Administrator",
      "definition" : "Senior Business Administrator"
    },
    {
      "code" : "1141.001",
      "display" : "Community Services Administrator",
      "definition" : "Community Services Administrator"
    },
    {
      "code" : "1141.002",
      "display" : "Political Party Organiser Secretary",
      "definition" : "Political Party Organiser Secretary"
    },
    {
      "code" : "1141.003",
      "display" : "Recreation Administrator",
      "definition" : "Recreation Administrator"
    },
    {
      "code" : "1141.004",
      "display" : "Secretary Organiser",
      "definition" : "Secretary Organiser"
    },
    {
      "code" : "1141.005",
      "display" : "Secretary Social Sporting Organisation",
      "definition" : "Secretary Social Sporting Organisation"
    },
    {
      "code" : "1141.006",
      "display" : "Special-Interest Organisation Administrator",
      "definition" : "Special-Interest Organisation Administrator"
    },
    {
      "code" : "1141.007",
      "display" : "Sports Administrator",
      "definition" : "Sports Administrator"
    },
    {
      "code" : "1141.008",
      "display" : "Sports Coordinator",
      "definition" : "Sports Coordinator"
    },
    {
      "code" : "1141.009",
      "display" : "Trade Union Official",
      "definition" : "Trade Union Official"
    },
    {
      "code" : "1141.010",
      "display" : "Trade Union Secretary",
      "definition" : "Trade Union Secretary"
    },
    {
      "code" : "1141.011",
      "display" : "Union Official",
      "definition" : "Union Official"
    },
    {
      "code" : "1141.012",
      "display" : "Union Organiser",
      "definition" : "Union Organiser"
    },
    {
      "code" : "1211.001",
      "display" : "Area Manager",
      "definition" : "Area Manager"
    },
    {
      "code" : "1211.002",
      "display" : "Business Director",
      "definition" : "Business Director"
    },
    {
      "code" : "1211.003",
      "display" : "Business Owner",
      "definition" : "Business Owner"
    },
    {
      "code" : "1211.004",
      "display" : "Business Services Manager",
      "definition" : "Business Services Manager"
    },
    {
      "code" : "1211.005",
      "display" : "Company Director",
      "definition" : "Company Director"
    },
    {
      "code" : "1211.006",
      "display" : "Company Manager",
      "definition" : "Company Manager"
    },
    {
      "code" : "1211.007",
      "display" : "Corporate Manager",
      "definition" : "Corporate Manager"
    },
    {
      "code" : "1211.008",
      "display" : "Culture Chief",
      "definition" : "Culture Chief"
    },
    {
      "code" : "1211.009",
      "display" : "Franchise Company Manager",
      "definition" : "Franchise Company Manager"
    },
    {
      "code" : "1211.010",
      "display" : "Franchise General Manager",
      "definition" : "Franchise General Manager"
    },
    {
      "code" : "1211.011",
      "display" : "General Manager",
      "definition" : "General Manager"
    },
    {
      "code" : "1211.012",
      "display" : "General Manager Government Department",
      "definition" : "General Manager Government Department"
    },
    {
      "code" : "1211.013",
      "display" : "Kaiwhakahaere",
      "definition" : "Kaiwhakahaere"
    },
    {
      "code" : "1211.014",
      "display" : "Kaiwhakahaere Kopareihana",
      "definition" : "Kaiwhakahaere Kopareihana"
    },
    {
      "code" : "1211.015",
      "display" : "Kaiwhakahaere Uanga",
      "definition" : "Kaiwhakahaere Uanga"
    },
    {
      "code" : "1211.016",
      "display" : "Kaiwhakahaere Umanga",
      "definition" : "Kaiwhakahaere Umanga"
    },
    {
      "code" : "1211.017",
      "display" : "Managing Editor",
      "definition" : "Managing Editor"
    },
    {
      "code" : "1211.018",
      "display" : "Net Loyalty Director",
      "definition" : "Net Loyalty Director"
    },
    {
      "code" : "1211.019",
      "display" : "Publisher",
      "definition" : "Publisher"
    },
    {
      "code" : "1211.020",
      "display" : "Rangatira",
      "definition" : "Rangatira"
    },
    {
      "code" : "1211.021",
      "display" : "Rangatira Uanga",
      "definition" : "Rangatira Uanga"
    },
    {
      "code" : "1211.022",
      "display" : "Rangatira Umanga",
      "definition" : "Rangatira Umanga"
    },
    {
      "code" : "1211.023",
      "display" : "Regional Manager",
      "definition" : "Regional Manager"
    },
    {
      "code" : "1211.024",
      "display" : "Society or Trustee Company Director",
      "definition" : "Society or Trustee Company Director"
    },
    {
      "code" : "1221.001",
      "display" : "Air Transport Manager",
      "definition" : "Air Transport Manager"
    },
    {
      "code" : "1221.002",
      "display" : "Air Transport Planning Manager",
      "definition" : "Air Transport Planning Manager"
    },
    {
      "code" : "1221.003",
      "display" : "Airline Executive",
      "definition" : "Airline Executive"
    },
    {
      "code" : "1221.004",
      "display" : "Airline Manager",
      "definition" : "Airline Manager"
    },
    {
      "code" : "1221.005",
      "display" : "Airport Manager",
      "definition" : "Airport Manager"
    },
    {
      "code" : "1221.006",
      "display" : "Airport Manager Operations",
      "definition" : "Airport Manager Operations"
    },
    {
      "code" : "1221.007",
      "display" : "Area Manager Production",
      "definition" : "Area Manager Production"
    },
    {
      "code" : "1221.008",
      "display" : "Bakery Factory Manager",
      "definition" : "Bakery Factory Manager"
    },
    {
      "code" : "1221.009",
      "display" : "Broadcasting and Theatrical Production Manager",
      "definition" : "Broadcasting and Theatrical Production Manager"
    },
    {
      "code" : "1221.010",
      "display" : "Broadcasting Production Manager",
      "definition" : "Broadcasting Production Manager"
    },
    {
      "code" : "1221.011",
      "display" : "Construction Manager",
      "definition" : "Construction Manager"
    },
    {
      "code" : "1221.012",
      "display" : "Construction Site Manager",
      "definition" : "Construction Site Manager"
    },
    {
      "code" : "1221.013",
      "display" : "Dairy Factory Manager",
      "definition" : "Dairy Factory Manager"
    },
    {
      "code" : "1221.014",
      "display" : "Deputy Principal",
      "definition" : "Deputy Principal"
    },
    {
      "code" : "1221.015",
      "display" : "Deputy School Principal",
      "definition" : "Deputy School Principal"
    },
    {
      "code" : "1221.016",
      "display" : "Distillery Manager",
      "definition" : "Distillery Manager"
    },
    {
      "code" : "1221.017",
      "display" : "Education Administrator",
      "definition" : "Education Administrator"
    },
    {
      "code" : "1221.018",
      "display" : "Engineering Technical Manager",
      "definition" : "Engineering Technical Manager"
    },
    {
      "code" : "1221.019",
      "display" : "Executive Producer",
      "definition" : "Executive Producer"
    },
    {
      "code" : "1221.020",
      "display" : "Exploration Manager",
      "definition" : "Exploration Manager"
    },
    {
      "code" : "1221.021",
      "display" : "Factory Manager",
      "definition" : "Factory Manager"
    },
    {
      "code" : "1221.022",
      "display" : "Factory Production Manager",
      "definition" : "Factory Production Manager"
    },
    {
      "code" : "1221.023",
      "display" : "Film and Television Production Manager",
      "definition" : "Film and Television Production Manager"
    },
    {
      "code" : "1221.024",
      "display" : "Film Producer",
      "definition" : "Film Producer"
    },
    {
      "code" : "1221.025",
      "display" : "Forest Manager",
      "definition" : "Forest Manager"
    },
    {
      "code" : "1221.026",
      "display" : "Forest Manager Logging Operations",
      "definition" : "Forest Manager Logging Operations"
    },
    {
      "code" : "1221.027",
      "display" : "Forest Ranger",
      "definition" : "Forest Ranger"
    },
    {
      "code" : "1221.028",
      "display" : "Freezing Works Manager",
      "definition" : "Freezing Works Manager"
    },
    {
      "code" : "1221.029",
      "display" : "Freight Road Transport Manager",
      "definition" : "Freight Road Transport Manager"
    },
    {
      "code" : "1221.030",
      "display" : "Gas Manager",
      "definition" : "Gas Manager"
    },
    {
      "code" : "1221.031",
      "display" : "Head Master",
      "definition" : "Head Master"
    },
    {
      "code" : "1221.032",
      "display" : "Head Mistress",
      "definition" : "Head Mistress"
    },
    {
      "code" : "1221.033",
      "display" : "Head Teacher",
      "definition" : "Head Teacher"
    },
    {
      "code" : "1221.034",
      "display" : "Headmaster",
      "definition" : "Headmaster"
    },
    {
      "code" : "1221.035",
      "display" : "Headmistress",
      "definition" : "Headmistress"
    },
    {
      "code" : "1221.036",
      "display" : "Industrial Production Manager",
      "definition" : "Industrial Production Manager"
    },
    {
      "code" : "1221.037",
      "display" : "Logging Planner",
      "definition" : "Logging Planner"
    },
    {
      "code" : "1221.038",
      "display" : "Managing Publisher",
      "definition" : "Managing Publisher"
    },
    {
      "code" : "1221.039",
      "display" : "Mill Manager",
      "definition" : "Mill Manager"
    },
    {
      "code" : "1221.040",
      "display" : "Mine Manager",
      "definition" : "Mine Manager"
    },
    {
      "code" : "1221.041",
      "display" : "Motion Picture Producer",
      "definition" : "Motion Picture Producer"
    },
    {
      "code" : "1221.042",
      "display" : "Musical Producer",
      "definition" : "Musical Producer"
    },
    {
      "code" : "1221.043",
      "display" : "Oil Manager",
      "definition" : "Oil Manager"
    },
    {
      "code" : "1221.044",
      "display" : "Operations Manager (Production)",
      "definition" : "Operations Manager (Production)"
    },
    {
      "code" : "1221.045",
      "display" : "Passenger Transport Manager",
      "definition" : "Passenger Transport Manager"
    },
    {
      "code" : "1221.046",
      "display" : "Plantation Manager",
      "definition" : "Plantation Manager"
    },
    {
      "code" : "1221.047",
      "display" : "Primary School Principal",
      "definition" : "Primary School Principal"
    },
    {
      "code" : "1221.048",
      "display" : "Principal",
      "definition" : "Principal"
    },
    {
      "code" : "1221.049",
      "display" : "Principal Head Teacher",
      "definition" : "Principal Head Teacher"
    },
    {
      "code" : "1221.050",
      "display" : "Processing Manager",
      "definition" : "Processing Manager"
    },
    {
      "code" : "1221.051",
      "display" : "Producer (Film/Television)",
      "definition" : "Producer (Film/Television)"
    },
    {
      "code" : "1221.052",
      "display" : "Producer Performing Arts",
      "definition" : "Producer Performing Arts"
    },
    {
      "code" : "1221.053",
      "display" : "Production Manager",
      "definition" : "Production Manager"
    },
    {
      "code" : "1221.054",
      "display" : "Production Manager (Manufacturing)",
      "definition" : "Production Manager (Manufacturing)"
    },
    {
      "code" : "1221.055",
      "display" : "Production Manager Performing Arts",
      "definition" : "Production Manager Performing Arts"
    },
    {
      "code" : "1221.056",
      "display" : "Publishing Manager",
      "definition" : "Publishing Manager"
    },
    {
      "code" : "1221.057",
      "display" : "Quarry Manager",
      "definition" : "Quarry Manager"
    },
    {
      "code" : "1221.058",
      "display" : "Radio Producer",
      "definition" : "Radio Producer"
    },
    {
      "code" : "1221.059",
      "display" : "Radio Programme Organiser",
      "definition" : "Radio Programme Organiser"
    },
    {
      "code" : "1221.060",
      "display" : "Radio Programmer",
      "definition" : "Radio Programmer"
    },
    {
      "code" : "1221.061",
      "display" : "Radio Station Manager",
      "definition" : "Radio Station Manager"
    },
    {
      "code" : "1221.062",
      "display" : "Railway Goods Freight Manager",
      "definition" : "Railway Goods Freight Manager"
    },
    {
      "code" : "1221.063",
      "display" : "Railway Station Master",
      "definition" : "Railway Station Master"
    },
    {
      "code" : "1221.064",
      "display" : "Railway Stationmaster",
      "definition" : "Railway Stationmaster"
    },
    {
      "code" : "1221.065",
      "display" : "Record Producer",
      "definition" : "Record Producer"
    },
    {
      "code" : "1221.066",
      "display" : "Road Goods Freight Manager",
      "definition" : "Road Goods Freight Manager"
    },
    {
      "code" : "1221.067",
      "display" : "Sawmill Manager",
      "definition" : "Sawmill Manager"
    },
    {
      "code" : "1221.068",
      "display" : "School Administrator",
      "definition" : "School Administrator"
    },
    {
      "code" : "1221.069",
      "display" : "School Principal",
      "definition" : "School Principal"
    },
    {
      "code" : "1221.070",
      "display" : "Secondary School Principal",
      "definition" : "Secondary School Principal"
    },
    {
      "code" : "1221.071",
      "display" : "Senior Education Manager",
      "definition" : "Senior Education Manager"
    },
    {
      "code" : "1221.072",
      "display" : "Shipping Manager",
      "definition" : "Shipping Manager"
    },
    {
      "code" : "1221.073",
      "display" : "Stage Producer",
      "definition" : "Stage Producer"
    },
    {
      "code" : "1221.074",
      "display" : "Television Producer",
      "definition" : "Television Producer"
    },
    {
      "code" : "1221.075",
      "display" : "Television Programme Organiser",
      "definition" : "Television Programme Organiser"
    },
    {
      "code" : "1221.076",
      "display" : "Television Programmer",
      "definition" : "Television Programmer"
    },
    {
      "code" : "1221.077",
      "display" : "Theatre Producer",
      "definition" : "Theatre Producer"
    },
    {
      "code" : "1221.078",
      "display" : "Theatrical Production Manager",
      "definition" : "Theatrical Production Manager"
    },
    {
      "code" : "1221.079",
      "display" : "Timber Production Manager",
      "definition" : "Timber Production Manager"
    },
    {
      "code" : "1221.080",
      "display" : "Traffic Manager",
      "definition" : "Traffic Manager"
    },
    {
      "code" : "1221.081",
      "display" : "Transport Manager",
      "definition" : "Transport Manager"
    },
    {
      "code" : "1221.082",
      "display" : "Transport Operations Manager",
      "definition" : "Transport Operations Manager"
    },
    {
      "code" : "1221.083",
      "display" : "Travel Manager Shipping",
      "definition" : "Travel Manager Shipping"
    },
    {
      "code" : "1221.084",
      "display" : "Video Producer",
      "definition" : "Video Producer"
    },
    {
      "code" : "1221.085",
      "display" : "Works Manager",
      "definition" : "Works Manager"
    },
    {
      "code" : "1222.001",
      "display" : "Accounting Manager",
      "definition" : "Accounting Manager"
    },
    {
      "code" : "1222.002",
      "display" : "Admin Manager",
      "definition" : "Admin Manager"
    },
    {
      "code" : "1222.003",
      "display" : "Administration Manager",
      "definition" : "Administration Manager"
    },
    {
      "code" : "1222.004",
      "display" : "Bank Executive",
      "definition" : "Bank Executive"
    },
    {
      "code" : "1222.005",
      "display" : "Bank Inspector",
      "definition" : "Bank Inspector"
    },
    {
      "code" : "1222.006",
      "display" : "Bank Manager",
      "definition" : "Bank Manager"
    },
    {
      "code" : "1222.007",
      "display" : "Branch Manager",
      "definition" : "Branch Manager"
    },
    {
      "code" : "1222.008",
      "display" : "Budgeting Manager",
      "definition" : "Budgeting Manager"
    },
    {
      "code" : "1222.009",
      "display" : "Building Manager",
      "definition" : "Building Manager"
    },
    {
      "code" : "1222.010",
      "display" : "Building Society Investment Manager",
      "definition" : "Building Society Investment Manager"
    },
    {
      "code" : "1222.011",
      "display" : "Bureau Manager",
      "definition" : "Bureau Manager"
    },
    {
      "code" : "1222.012",
      "display" : "Cinema Manager",
      "definition" : "Cinema Manager"
    },
    {
      "code" : "1222.013",
      "display" : "Club Secretary (Administration)",
      "definition" : "Club Secretary (Administration)"
    },
    {
      "code" : "1222.014",
      "display" : "Corporate Banker",
      "definition" : "Corporate Banker"
    },
    {
      "code" : "1222.015",
      "display" : "Credit Controller",
      "definition" : "Credit Controller"
    },
    {
      "code" : "1222.016",
      "display" : "Credit Manager",
      "definition" : "Credit Manager"
    },
    {
      "code" : "1222.017",
      "display" : "Dental Administrator",
      "definition" : "Dental Administrator"
    },
    {
      "code" : "1222.018",
      "display" : "Department Manager",
      "definition" : "Department Manager"
    },
    {
      "code" : "1222.019",
      "display" : "District Commissioner Inland Revenue",
      "definition" : "District Commissioner Inland Revenue"
    },
    {
      "code" : "1222.020",
      "display" : "Electoral Officer",
      "definition" : "Electoral Officer"
    },
    {
      "code" : "1222.021",
      "display" : "Executive Company Secretary",
      "definition" : "Executive Company Secretary"
    },
    {
      "code" : "1222.022",
      "display" : "Factory Facilities Manager",
      "definition" : "Factory Facilities Manager"
    },
    {
      "code" : "1222.023",
      "display" : "Finance Director",
      "definition" : "Finance Director"
    },
    {
      "code" : "1222.024",
      "display" : "Finance Executive",
      "definition" : "Finance Executive"
    },
    {
      "code" : "1222.025",
      "display" : "Finance Manager",
      "definition" : "Finance Manager"
    },
    {
      "code" : "1222.026",
      "display" : "Financial Controller",
      "definition" : "Financial Controller"
    },
    {
      "code" : "1222.027",
      "display" : "Financial Manager",
      "definition" : "Financial Manager"
    },
    {
      "code" : "1222.028",
      "display" : "Fitness Centre Manager",
      "definition" : "Fitness Centre Manager"
    },
    {
      "code" : "1222.029",
      "display" : "Foreign Exchange Manager",
      "definition" : "Foreign Exchange Manager"
    },
    {
      "code" : "1222.030",
      "display" : "Health Service Coordinator",
      "definition" : "Health Service Coordinator"
    },
    {
      "code" : "1222.031",
      "display" : "Health Services Manager",
      "definition" : "Health Services Manager"
    },
    {
      "code" : "1222.032",
      "display" : "Hospital Administrator",
      "definition" : "Hospital Administrator"
    },
    {
      "code" : "1222.033",
      "display" : "Inland Revenue Controller",
      "definition" : "Inland Revenue Controller"
    },
    {
      "code" : "1222.034",
      "display" : "Insurance Branch Manager",
      "definition" : "Insurance Branch Manager"
    },
    {
      "code" : "1222.035",
      "display" : "Insurance Executive",
      "definition" : "Insurance Executive"
    },
    {
      "code" : "1222.036",
      "display" : "Insurance Manager",
      "definition" : "Insurance Manager"
    },
    {
      "code" : "1222.037",
      "display" : "Investment Manager",
      "definition" : "Investment Manager"
    },
    {
      "code" : "1222.038",
      "display" : "Loans Manager",
      "definition" : "Loans Manager"
    },
    {
      "code" : "1222.039",
      "display" : "Medical Administrator",
      "definition" : "Medical Administrator"
    },
    {
      "code" : "1222.040",
      "display" : "Medical Superintendent",
      "definition" : "Medical Superintendent"
    },
    {
      "code" : "1222.041",
      "display" : "Merchant Banker",
      "definition" : "Merchant Banker"
    },
    {
      "code" : "1222.042",
      "display" : "Nursing Administrator",
      "definition" : "Nursing Administrator"
    },
    {
      "code" : "1222.043",
      "display" : "Price Inspector",
      "definition" : "Price Inspector"
    },
    {
      "code" : "1222.044",
      "display" : "Project Manager",
      "definition" : "Project Manager"
    },
    {
      "code" : "1222.045",
      "display" : "Project Manager (Administration)",
      "definition" : "Project Manager (Administration)"
    },
    {
      "code" : "1222.046",
      "display" : "Project Officer Regional Health Authority",
      "definition" : "Project Officer Regional Health Authority"
    },
    {
      "code" : "1222.047",
      "display" : "Property Manager",
      "definition" : "Property Manager"
    },
    {
      "code" : "1222.048",
      "display" : "Public Health Administrator",
      "definition" : "Public Health Administrator"
    },
    {
      "code" : "1222.049",
      "display" : "Public Health Manager",
      "definition" : "Public Health Manager"
    },
    {
      "code" : "1222.050",
      "display" : "Racing Administrator",
      "definition" : "Racing Administrator"
    },
    {
      "code" : "1222.051",
      "display" : "Recreation Manager",
      "definition" : "Recreation Manager"
    },
    {
      "code" : "1222.052",
      "display" : "Regional Commander of Civil Defence",
      "definition" : "Regional Commander of Civil Defence"
    },
    {
      "code" : "1222.053",
      "display" : "Regional Controller Inland Revenue",
      "definition" : "Regional Controller Inland Revenue"
    },
    {
      "code" : "1222.054",
      "display" : "Regional Director Government Administration",
      "definition" : "Regional Director Government Administration"
    },
    {
      "code" : "1222.055",
      "display" : "Resources Manager",
      "definition" : "Resources Manager"
    },
    {
      "code" : "1222.056",
      "display" : "Sales Finance Manager",
      "definition" : "Sales Finance Manager"
    },
    {
      "code" : "1222.057",
      "display" : "Sales Tax Inspector",
      "definition" : "Sales Tax Inspector"
    },
    {
      "code" : "1222.058",
      "display" : "Savings Bank Manager",
      "definition" : "Savings Bank Manager"
    },
    {
      "code" : "1222.059",
      "display" : "Secretary Minister of the Crown",
      "definition" : "Secretary Minister of the Crown"
    },
    {
      "code" : "1222.060",
      "display" : "Tax Inspector",
      "definition" : "Tax Inspector"
    },
    {
      "code" : "1222.061",
      "display" : "Theatre Manager",
      "definition" : "Theatre Manager"
    },
    {
      "code" : "1222.062",
      "display" : "Treasurer",
      "definition" : "Treasurer"
    },
    {
      "code" : "1222.063",
      "display" : "Under Secretary Government Department",
      "definition" : "Under Secretary Government Department"
    },
    {
      "code" : "1222.064",
      "display" : "University Bursar",
      "definition" : "University Bursar"
    },
    {
      "code" : "1222.065",
      "display" : "University Registrar",
      "definition" : "University Registrar"
    },
    {
      "code" : "1223.001",
      "display" : "Employee Relations Manager",
      "definition" : "Employee Relations Manager"
    },
    {
      "code" : "1223.002",
      "display" : "Human Resources Development Manager",
      "definition" : "Human Resources Development Manager"
    },
    {
      "code" : "1223.003",
      "display" : "Human Resources Manager",
      "definition" : "Human Resources Manager"
    },
    {
      "code" : "1223.004",
      "display" : "Industrial Relations Manager",
      "definition" : "Industrial Relations Manager"
    },
    {
      "code" : "1223.005",
      "display" : "Kaiwhakahaere Tumu",
      "definition" : "Kaiwhakahaere Tumu"
    },
    {
      "code" : "1223.006",
      "display" : "Labour Relations Manager",
      "definition" : "Labour Relations Manager"
    },
    {
      "code" : "1223.007",
      "display" : "Personnel Manager",
      "definition" : "Personnel Manager"
    },
    {
      "code" : "1223.008",
      "display" : "Technical Training Manager",
      "definition" : "Technical Training Manager"
    },
    {
      "code" : "1223.009",
      "display" : "Training and Development Manager",
      "definition" : "Training and Development Manager"
    },
    {
      "code" : "1224.001",
      "display" : "Aapiha Whakahaere Hokohoko",
      "definition" : "Aapiha Whakahaere Hokohoko"
    },
    {
      "code" : "1224.002",
      "display" : "Apiha Whakahaere Hokohoko",
      "definition" : "Apiha Whakahaere Hokohoko"
    },
    {
      "code" : "1224.003",
      "display" : "Area Sales Manager",
      "definition" : "Area Sales Manager"
    },
    {
      "code" : "1224.004",
      "display" : "District Sales Manager",
      "definition" : "District Sales Manager"
    },
    {
      "code" : "1224.005",
      "display" : "Export Marketing Manager",
      "definition" : "Export Marketing Manager"
    },
    {
      "code" : "1224.006",
      "display" : "Key Account Manager",
      "definition" : "Key Account Manager"
    },
    {
      "code" : "1224.007",
      "display" : "Market Development Manager",
      "definition" : "Market Development Manager"
    },
    {
      "code" : "1224.008",
      "display" : "Marketing Executive",
      "definition" : "Marketing Executive"
    },
    {
      "code" : "1224.009",
      "display" : "Marketing Manager",
      "definition" : "Marketing Manager"
    },
    {
      "code" : "1224.010",
      "display" : "Marketing Manager Executive",
      "definition" : "Marketing Manager Executive"
    },
    {
      "code" : "1224.011",
      "display" : "National Sales Manager",
      "definition" : "National Sales Manager"
    },
    {
      "code" : "1224.012",
      "display" : "Rangatira Hokohoko",
      "definition" : "Rangatira Hokohoko"
    },
    {
      "code" : "1224.013",
      "display" : "Rangatira Whakahaere Hokohoko",
      "definition" : "Rangatira Whakahaere Hokohoko"
    },
    {
      "code" : "1224.014",
      "display" : "Sales Coordinator",
      "definition" : "Sales Coordinator"
    },
    {
      "code" : "1224.015",
      "display" : "Sales Director",
      "definition" : "Sales Director"
    },
    {
      "code" : "1224.016",
      "display" : "Sales Executive",
      "definition" : "Sales Executive"
    },
    {
      "code" : "1224.017",
      "display" : "Sales Executive Manager",
      "definition" : "Sales Executive Manager"
    },
    {
      "code" : "1224.018",
      "display" : "Sales Manager",
      "definition" : "Sales Manager"
    },
    {
      "code" : "1224.019",
      "display" : "Sales Manager (Banking)",
      "definition" : "Sales Manager (Banking)"
    },
    {
      "code" : "1224.020",
      "display" : "Sales or Marketing Manager",
      "definition" : "Sales or Marketing Manager"
    },
    {
      "code" : "1224.021",
      "display" : "Senior Sales Executive Ecommerce",
      "definition" : "Senior Sales Executive Ecommerce"
    },
    {
      "code" : "1224.022",
      "display" : "Travel Manager",
      "definition" : "Travel Manager"
    },
    {
      "code" : "1225.001",
      "display" : "Advertising Account Director",
      "definition" : "Advertising Account Director"
    },
    {
      "code" : "1225.002",
      "display" : "Advertising Account Executive",
      "definition" : "Advertising Account Executive"
    },
    {
      "code" : "1225.003",
      "display" : "Advertising Agency Director",
      "definition" : "Advertising Agency Director"
    },
    {
      "code" : "1225.004",
      "display" : "Advertising and Public Relations Manager",
      "definition" : "Advertising and Public Relations Manager"
    },
    {
      "code" : "1225.005",
      "display" : "Advertising Manager",
      "definition" : "Advertising Manager"
    },
    {
      "code" : "1225.006",
      "display" : "Advertising Office Manager",
      "definition" : "Advertising Office Manager"
    },
    {
      "code" : "1225.007",
      "display" : "Company Promoter",
      "definition" : "Company Promoter"
    },
    {
      "code" : "1225.008",
      "display" : "Public Affairs Manager",
      "definition" : "Public Affairs Manager"
    },
    {
      "code" : "1225.009",
      "display" : "Public Relations Manager",
      "definition" : "Public Relations Manager"
    },
    {
      "code" : "1226.001",
      "display" : "Antique Dealer",
      "definition" : "Antique Dealer"
    },
    {
      "code" : "1226.002",
      "display" : "Apartments Manager",
      "definition" : "Apartments Manager"
    },
    {
      "code" : "1226.003",
      "display" : "Backpacker Operator",
      "definition" : "Backpacker Operator"
    },
    {
      "code" : "1226.004",
      "display" : "Bakery Shop Manager",
      "definition" : "Bakery Shop Manager"
    },
    {
      "code" : "1226.005",
      "display" : "Bar or Caf� Manager",
      "definition" : "Bar or Caf� Manager"
    },
    {
      "code" : "1226.006",
      "display" : "Billiard Saloon Proprietor Manager",
      "definition" : "Billiard Saloon Proprietor Manager"
    },
    {
      "code" : "1226.007",
      "display" : "Boarding House Keeper",
      "definition" : "Boarding House Keeper"
    },
    {
      "code" : "1226.008",
      "display" : "Boarding House Manager",
      "definition" : "Boarding House Manager"
    },
    {
      "code" : "1226.009",
      "display" : "Book Store Proprietor",
      "definition" : "Book Store Proprietor"
    },
    {
      "code" : "1226.010",
      "display" : "Bookshop Manager",
      "definition" : "Bookshop Manager"
    },
    {
      "code" : "1226.011",
      "display" : "Bottle Store Manager",
      "definition" : "Bottle Store Manager"
    },
    {
      "code" : "1226.012",
      "display" : "Boutique Manager",
      "definition" : "Boutique Manager"
    },
    {
      "code" : "1226.013",
      "display" : "Boutique Proprietor",
      "definition" : "Boutique Proprietor"
    },
    {
      "code" : "1226.014",
      "display" : "Cafe Keeper",
      "definition" : "Cafe Keeper"
    },
    {
      "code" : "1226.015",
      "display" : "Cafe Manager",
      "definition" : "Cafe Manager"
    },
    {
      "code" : "1226.016",
      "display" : "Cafe Owner",
      "definition" : "Cafe Owner"
    },
    {
      "code" : "1226.017",
      "display" : "Cafeteria Manager",
      "definition" : "Cafeteria Manager"
    },
    {
      "code" : "1226.018",
      "display" : "Cafeteria Proprietor",
      "definition" : "Cafeteria Proprietor"
    },
    {
      "code" : "1226.019",
      "display" : "Camping Ground Manager",
      "definition" : "Camping Ground Manager"
    },
    {
      "code" : "1226.020",
      "display" : "Camping Site Manager",
      "definition" : "Camping Site Manager"
    },
    {
      "code" : "1226.021",
      "display" : "Camping Site Proprietor",
      "definition" : "Camping Site Proprietor"
    },
    {
      "code" : "1226.022",
      "display" : "Canteen Manager",
      "definition" : "Canteen Manager"
    },
    {
      "code" : "1226.023",
      "display" : "Canteen Proprietor",
      "definition" : "Canteen Proprietor"
    },
    {
      "code" : "1226.024",
      "display" : "Car Dealer",
      "definition" : "Car Dealer"
    },
    {
      "code" : "1226.025",
      "display" : "Caravan Park Manager",
      "definition" : "Caravan Park Manager"
    },
    {
      "code" : "1226.026",
      "display" : "Caravan Park Proprietor",
      "definition" : "Caravan Park Proprietor"
    },
    {
      "code" : "1226.027",
      "display" : "Caterer",
      "definition" : "Caterer"
    },
    {
      "code" : "1226.028",
      "display" : "Catering Contractor",
      "definition" : "Catering Contractor"
    },
    {
      "code" : "1226.029",
      "display" : "Catering Establishment Manager",
      "definition" : "Catering Establishment Manager"
    },
    {
      "code" : "1226.030",
      "display" : "Catering Proprietor",
      "definition" : "Catering Proprietor"
    },
    {
      "code" : "1226.031",
      "display" : "Catering Services Manager",
      "definition" : "Catering Services Manager"
    },
    {
      "code" : "1226.032",
      "display" : "Circulation Manager Newspaper",
      "definition" : "Circulation Manager Newspaper"
    },
    {
      "code" : "1226.033",
      "display" : "Clothing Retailer",
      "definition" : "Clothing Retailer"
    },
    {
      "code" : "1226.034",
      "display" : "Club Manager",
      "definition" : "Club Manager"
    },
    {
      "code" : "1226.035",
      "display" : "Club Manager Licensed",
      "definition" : "Club Manager Licensed"
    },
    {
      "code" : "1226.036",
      "display" : "Coal Merchant",
      "definition" : "Coal Merchant"
    },
    {
      "code" : "1226.037",
      "display" : "Coffee Bar Manager",
      "definition" : "Coffee Bar Manager"
    },
    {
      "code" : "1226.038",
      "display" : "Coffee Bar Proprietor",
      "definition" : "Coffee Bar Proprietor"
    },
    {
      "code" : "1226.039",
      "display" : "Coffee Lounge Manageress",
      "definition" : "Coffee Lounge Manageress"
    },
    {
      "code" : "1226.040",
      "display" : "Coffee Lounge Owner",
      "definition" : "Coffee Lounge Owner"
    },
    {
      "code" : "1226.041",
      "display" : "Crane Hirer Manager",
      "definition" : "Crane Hirer Manager"
    },
    {
      "code" : "1226.042",
      "display" : "Dairy Proprietor",
      "definition" : "Dairy Proprietor"
    },
    {
      "code" : "1226.043",
      "display" : "Dairy Shop Manager",
      "definition" : "Dairy Shop Manager"
    },
    {
      "code" : "1226.044",
      "display" : "Department Store Manager",
      "definition" : "Department Store Manager"
    },
    {
      "code" : "1226.045",
      "display" : "Distribution Manager",
      "definition" : "Distribution Manager"
    },
    {
      "code" : "1226.046",
      "display" : "Draper",
      "definition" : "Draper"
    },
    {
      "code" : "1226.047",
      "display" : "Export Manager",
      "definition" : "Export Manager"
    },
    {
      "code" : "1226.048",
      "display" : "Exporter",
      "definition" : "Exporter"
    },
    {
      "code" : "1226.049",
      "display" : "Fairground Amusment Park Proprietor",
      "definition" : "Fairground Amusment Park Proprietor"
    },
    {
      "code" : "1226.050",
      "display" : "Fast Food Manager",
      "definition" : "Fast Food Manager"
    },
    {
      "code" : "1226.051",
      "display" : "Fish and Chip Shop Proprietor",
      "definition" : "Fish and Chip Shop Proprietor"
    },
    {
      "code" : "1226.052",
      "display" : "Fishmonger",
      "definition" : "Fishmonger"
    },
    {
      "code" : "1226.053",
      "display" : "Flooring Manager",
      "definition" : "Flooring Manager"
    },
    {
      "code" : "1226.054",
      "display" : "Food Bar Proprietor",
      "definition" : "Food Bar Proprietor"
    },
    {
      "code" : "1226.055",
      "display" : "Food Services Manager",
      "definition" : "Food Services Manager"
    },
    {
      "code" : "1226.056",
      "display" : "Foodbar Proprietor",
      "definition" : "Foodbar Proprietor"
    },
    {
      "code" : "1226.057",
      "display" : "Footwear Retailer",
      "definition" : "Footwear Retailer"
    },
    {
      "code" : "1226.058",
      "display" : "Fresh Fish Shop Manager",
      "definition" : "Fresh Fish Shop Manager"
    },
    {
      "code" : "1226.059",
      "display" : "Fruit Shop Owner",
      "definition" : "Fruit Shop Owner"
    },
    {
      "code" : "1226.060",
      "display" : "Fruiterer",
      "definition" : "Fruiterer"
    },
    {
      "code" : "1226.061",
      "display" : "Greengrocer",
      "definition" : "Greengrocer"
    },
    {
      "code" : "1226.062",
      "display" : "Grocer",
      "definition" : "Grocer"
    },
    {
      "code" : "1226.063",
      "display" : "Grocery Manager",
      "definition" : "Grocery Manager"
    },
    {
      "code" : "1226.064",
      "display" : "Grocery Store Manager",
      "definition" : "Grocery Store Manager"
    },
    {
      "code" : "1226.065",
      "display" : "Guest House Keeper",
      "definition" : "Guest House Keeper"
    },
    {
      "code" : "1226.066",
      "display" : "Guest House Manager",
      "definition" : "Guest House Manager"
    },
    {
      "code" : "1226.067",
      "display" : "Halls of Residence Manager",
      "definition" : "Halls of Residence Manager"
    },
    {
      "code" : "1226.068",
      "display" : "Holiday Park Manager",
      "definition" : "Holiday Park Manager"
    },
    {
      "code" : "1226.069",
      "display" : "Hospital Pharmacy Manager",
      "definition" : "Hospital Pharmacy Manager"
    },
    {
      "code" : "1226.070",
      "display" : "Hostel Manager",
      "definition" : "Hostel Manager"
    },
    {
      "code" : "1226.071",
      "display" : "Hotel Keeper",
      "definition" : "Hotel Keeper"
    },
    {
      "code" : "1226.072",
      "display" : "Hotel Manager",
      "definition" : "Hotel Manager"
    },
    {
      "code" : "1226.073",
      "display" : "Hotel or Motel Manager",
      "definition" : "Hotel or Motel Manager"
    },
    {
      "code" : "1226.074",
      "display" : "Hotel Owner",
      "definition" : "Hotel Owner"
    },
    {
      "code" : "1226.075",
      "display" : "Hotelier",
      "definition" : "Hotelier"
    },
    {
      "code" : "1226.076",
      "display" : "Import Manager",
      "definition" : "Import Manager"
    },
    {
      "code" : "1226.077",
      "display" : "Importer",
      "definition" : "Importer"
    },
    {
      "code" : "1226.078",
      "display" : "Innkeeper",
      "definition" : "Innkeeper"
    },
    {
      "code" : "1226.079",
      "display" : "Kaiwhakahaere Hotera",
      "definition" : "Kaiwhakahaere Hotera"
    },
    {
      "code" : "1226.080",
      "display" : "Kaiwhakahaere Toa",
      "definition" : "Kaiwhakahaere Toa"
    },
    {
      "code" : "1226.081",
      "display" : "Landlady",
      "definition" : "Landlady"
    },
    {
      "code" : "1226.082",
      "display" : "Landlord",
      "definition" : "Landlord"
    },
    {
      "code" : "1226.083",
      "display" : "Licenced Motor Vehicle Dealer",
      "definition" : "Licenced Motor Vehicle Dealer"
    },
    {
      "code" : "1226.084",
      "display" : "Licensed Motor Vehicle Dealer",
      "definition" : "Licensed Motor Vehicle Dealer"
    },
    {
      "code" : "1226.085",
      "display" : "Liquor Merchant",
      "definition" : "Liquor Merchant"
    },
    {
      "code" : "1226.086",
      "display" : "Lodge Manager",
      "definition" : "Lodge Manager"
    },
    {
      "code" : "1226.087",
      "display" : "Logistics Manager",
      "definition" : "Logistics Manager"
    },
    {
      "code" : "1226.088",
      "display" : "Lunch Bar Manager",
      "definition" : "Lunch Bar Manager"
    },
    {
      "code" : "1226.089",
      "display" : "Lunch Bar Proprietor",
      "definition" : "Lunch Bar Proprietor"
    },
    {
      "code" : "1226.090",
      "display" : "Manager Retail Trade",
      "definition" : "Manager Retail Trade"
    },
    {
      "code" : "1226.091",
      "display" : "Meat Retailer",
      "definition" : "Meat Retailer"
    },
    {
      "code" : "1226.092",
      "display" : "Menswear Retailer",
      "definition" : "Menswear Retailer"
    },
    {
      "code" : "1226.093",
      "display" : "Milk Bar Proprietor",
      "definition" : "Milk Bar Proprietor"
    },
    {
      "code" : "1226.094",
      "display" : "Money Lender",
      "definition" : "Money Lender"
    },
    {
      "code" : "1226.095",
      "display" : "Motel Manager",
      "definition" : "Motel Manager"
    },
    {
      "code" : "1226.096",
      "display" : "Motel Owner",
      "definition" : "Motel Owner"
    },
    {
      "code" : "1226.097",
      "display" : "Motelier",
      "definition" : "Motelier"
    },
    {
      "code" : "1226.098",
      "display" : "Motor Camp Manager",
      "definition" : "Motor Camp Manager"
    },
    {
      "code" : "1226.099",
      "display" : "Motor Camp Proprietor",
      "definition" : "Motor Camp Proprietor"
    },
    {
      "code" : "1226.100",
      "display" : "Motor Inn Manager",
      "definition" : "Motor Inn Manager"
    },
    {
      "code" : "1226.101",
      "display" : "Motor Vehicle Dealer",
      "definition" : "Motor Vehicle Dealer"
    },
    {
      "code" : "1226.102",
      "display" : "Other Catering Services Manager",
      "definition" : "Other Catering Services Manager"
    },
    {
      "code" : "1226.103",
      "display" : "Other Lodging Services Manager",
      "definition" : "Other Lodging Services Manager"
    },
    {
      "code" : "1226.104",
      "display" : "Pawnbroker",
      "definition" : "Pawnbroker"
    },
    {
      "code" : "1226.105",
      "display" : "Pharmacy Manager Retail",
      "definition" : "Pharmacy Manager Retail"
    },
    {
      "code" : "1226.106",
      "display" : "Philatelist",
      "definition" : "Philatelist"
    },
    {
      "code" : "1226.107",
      "display" : "Pie Cart Proprietor",
      "definition" : "Pie Cart Proprietor"
    },
    {
      "code" : "1226.108",
      "display" : "Private Hotel Keeper",
      "definition" : "Private Hotel Keeper"
    },
    {
      "code" : "1226.109",
      "display" : "Proprietor Fast Food",
      "definition" : "Proprietor Fast Food"
    },
    {
      "code" : "1226.110",
      "display" : "Publican",
      "definition" : "Publican"
    },
    {
      "code" : "1226.111",
      "display" : "Purchasing Manager",
      "definition" : "Purchasing Manager"
    },
    {
      "code" : "1226.112",
      "display" : "Rangatira o te Toa",
      "definition" : "Rangatira o te Toa"
    },
    {
      "code" : "1226.113",
      "display" : "Recycling Dealer",
      "definition" : "Recycling Dealer"
    },
    {
      "code" : "1226.114",
      "display" : "Recycling Merchant",
      "definition" : "Recycling Merchant"
    },
    {
      "code" : "1226.115",
      "display" : "Rest Home Proprietor",
      "definition" : "Rest Home Proprietor"
    },
    {
      "code" : "1226.116",
      "display" : "Restaurant Manager",
      "definition" : "Restaurant Manager"
    },
    {
      "code" : "1226.117",
      "display" : "Restaurant Manageress",
      "definition" : "Restaurant Manageress"
    },
    {
      "code" : "1226.118",
      "display" : "Restaurant or Tavern Manager",
      "definition" : "Restaurant or Tavern Manager"
    },
    {
      "code" : "1226.119",
      "display" : "Restaurant Owner",
      "definition" : "Restaurant Owner"
    },
    {
      "code" : "1226.120",
      "display" : "Restauranteur",
      "definition" : "Restauranteur"
    },
    {
      "code" : "1226.121",
      "display" : "Resthome Manager",
      "definition" : "Resthome Manager"
    },
    {
      "code" : "1226.122",
      "display" : "Resthome Owner",
      "definition" : "Resthome Owner"
    },
    {
      "code" : "1226.123",
      "display" : "Retail and Shop Manager",
      "definition" : "Retail and Shop Manager"
    },
    {
      "code" : "1226.124",
      "display" : "Retail Bakery Proprietor",
      "definition" : "Retail Bakery Proprietor"
    },
    {
      "code" : "1226.125",
      "display" : "Retail Dealer",
      "definition" : "Retail Dealer"
    },
    {
      "code" : "1226.126",
      "display" : "Retail Floor Manager",
      "definition" : "Retail Floor Manager"
    },
    {
      "code" : "1226.127",
      "display" : "Retail Manager",
      "definition" : "Retail Manager"
    },
    {
      "code" : "1226.128",
      "display" : "Retail Proprietor",
      "definition" : "Retail Proprietor"
    },
    {
      "code" : "1226.129",
      "display" : "Retail Sales Manager",
      "definition" : "Retail Sales Manager"
    },
    {
      "code" : "1226.130",
      "display" : "Scrap Merchant",
      "definition" : "Scrap Merchant"
    },
    {
      "code" : "1226.131",
      "display" : "Scrap Metal Dealer",
      "definition" : "Scrap Metal Dealer"
    },
    {
      "code" : "1226.132",
      "display" : "Second Hand Dealer",
      "definition" : "Second Hand Dealer"
    },
    {
      "code" : "1226.133",
      "display" : "Secondhand Dealer",
      "definition" : "Secondhand Dealer"
    },
    {
      "code" : "1226.134",
      "display" : "Service Station Manager",
      "definition" : "Service Station Manager"
    },
    {
      "code" : "1226.135",
      "display" : "Service Station Owner",
      "definition" : "Service Station Owner"
    },
    {
      "code" : "1226.136",
      "display" : "Service Station Proprietor",
      "definition" : "Service Station Proprietor"
    },
    {
      "code" : "1226.137",
      "display" : "Shop Keeper",
      "definition" : "Shop Keeper"
    },
    {
      "code" : "1226.138",
      "display" : "Shop Manager",
      "definition" : "Shop Manager"
    },
    {
      "code" : "1226.139",
      "display" : "Shop Manageress",
      "definition" : "Shop Manageress"
    },
    {
      "code" : "1226.140",
      "display" : "Shop Owner",
      "definition" : "Shop Owner"
    },
    {
      "code" : "1226.141",
      "display" : "Shop Proprietor",
      "definition" : "Shop Proprietor"
    },
    {
      "code" : "1226.142",
      "display" : "Shopkeeper",
      "definition" : "Shopkeeper"
    },
    {
      "code" : "1226.143",
      "display" : "Snack Bar Proprietor",
      "definition" : "Snack Bar Proprietor"
    },
    {
      "code" : "1226.144",
      "display" : "Stock Saleyards Manager",
      "definition" : "Stock Saleyards Manager"
    },
    {
      "code" : "1226.145",
      "display" : "Storage and Warehousing Manager",
      "definition" : "Storage and Warehousing Manager"
    },
    {
      "code" : "1226.146",
      "display" : "Store Manager",
      "definition" : "Store Manager"
    },
    {
      "code" : "1226.147",
      "display" : "Storekeeper",
      "definition" : "Storekeeper"
    },
    {
      "code" : "1226.148",
      "display" : "Supermarket Manager",
      "definition" : "Supermarket Manager"
    },
    {
      "code" : "1226.149",
      "display" : "Supply and Distribution Manager",
      "definition" : "Supply and Distribution Manager"
    },
    {
      "code" : "1226.150",
      "display" : "Supply Manager",
      "definition" : "Supply Manager"
    },
    {
      "code" : "1226.151",
      "display" : "Supply Planning Manager",
      "definition" : "Supply Planning Manager"
    },
    {
      "code" : "1226.152",
      "display" : "TAB Agent",
      "definition" : "TAB Agent"
    },
    {
      "code" : "1226.153",
      "display" : "TAB District Manager",
      "definition" : "TAB District Manager"
    },
    {
      "code" : "1226.154",
      "display" : "TAB Manager",
      "definition" : "TAB Manager"
    },
    {
      "code" : "1226.155",
      "display" : "Takeaway Shop Owner",
      "definition" : "Takeaway Shop Owner"
    },
    {
      "code" : "1226.156",
      "display" : "Takeaways Manager",
      "definition" : "Takeaways Manager"
    },
    {
      "code" : "1226.157",
      "display" : "Tavern Keeper",
      "definition" : "Tavern Keeper"
    },
    {
      "code" : "1226.158",
      "display" : "Tavern Manager",
      "definition" : "Tavern Manager"
    },
    {
      "code" : "1226.159",
      "display" : "Tea Room Proprietor",
      "definition" : "Tea Room Proprietor"
    },
    {
      "code" : "1226.160",
      "display" : "Timber Merchant",
      "definition" : "Timber Merchant"
    },
    {
      "code" : "1226.161",
      "display" : "Tourist Hotel Manager",
      "definition" : "Tourist Hotel Manager"
    },
    {
      "code" : "1226.162",
      "display" : "Video Shop Manager",
      "definition" : "Video Shop Manager"
    },
    {
      "code" : "1226.163",
      "display" : "Warehouse Manager",
      "definition" : "Warehouse Manager"
    },
    {
      "code" : "1226.164",
      "display" : "Warehouse Sales Manager",
      "definition" : "Warehouse Sales Manager"
    },
    {
      "code" : "1226.165",
      "display" : "Warehouse Wholesaler",
      "definition" : "Warehouse Wholesaler"
    },
    {
      "code" : "1226.166",
      "display" : "Warehousing Department Manager",
      "definition" : "Warehousing Department Manager"
    },
    {
      "code" : "1226.167",
      "display" : "Wholesale and Warehouse Manager",
      "definition" : "Wholesale and Warehouse Manager"
    },
    {
      "code" : "1226.168",
      "display" : "Wholesale Area Manager",
      "definition" : "Wholesale Area Manager"
    },
    {
      "code" : "1226.169",
      "display" : "Wholesale Bakery Manager",
      "definition" : "Wholesale Bakery Manager"
    },
    {
      "code" : "1226.170",
      "display" : "Wholesale Manager",
      "definition" : "Wholesale Manager"
    },
    {
      "code" : "1226.171",
      "display" : "Wholesale Merchant",
      "definition" : "Wholesale Merchant"
    },
    {
      "code" : "1226.172",
      "display" : "Wholesale Sales Manager",
      "definition" : "Wholesale Sales Manager"
    },
    {
      "code" : "1226.173",
      "display" : "Wholesale Seed and Produce Merchant",
      "definition" : "Wholesale Seed and Produce Merchant"
    },
    {
      "code" : "1226.174",
      "display" : "Wholesaler",
      "definition" : "Wholesaler"
    },
    {
      "code" : "1226.175",
      "display" : "Wine and Liquor Merchant",
      "definition" : "Wine and Liquor Merchant"
    },
    {
      "code" : "1226.176",
      "display" : "Wool Store Manager",
      "definition" : "Wool Store Manager"
    },
    {
      "code" : "1226.177",
      "display" : "Working Proprietor Retail",
      "definition" : "Working Proprietor Retail"
    },
    {
      "code" : "1226.178",
      "display" : "Youth Hostel Manager",
      "definition" : "Youth Hostel Manager"
    },
    {
      "code" : "1227.001",
      "display" : "Computer Marketing Executive",
      "definition" : "Computer Marketing Executive"
    },
    {
      "code" : "1227.002",
      "display" : "Computer Operations Coordinator",
      "definition" : "Computer Operations Coordinator"
    },
    {
      "code" : "1227.003",
      "display" : "Computer Product Manager",
      "definition" : "Computer Product Manager"
    },
    {
      "code" : "1227.004",
      "display" : "Computer Support Manager",
      "definition" : "Computer Support Manager"
    },
    {
      "code" : "1227.005",
      "display" : "Computer Systems Manager",
      "definition" : "Computer Systems Manager"
    },
    {
      "code" : "1227.006",
      "display" : "Computing Services Manager",
      "definition" : "Computing Services Manager"
    },
    {
      "code" : "1227.007",
      "display" : "Computing Systems Manager",
      "definition" : "Computing Systems Manager"
    },
    {
      "code" : "1227.008",
      "display" : "Data Processing Manager",
      "definition" : "Data Processing Manager"
    },
    {
      "code" : "1227.009",
      "display" : "EDP Manager",
      "definition" : "EDP Manager"
    },
    {
      "code" : "1227.010",
      "display" : "Information Technology Manager",
      "definition" : "Information Technology Manager"
    },
    {
      "code" : "1227.011",
      "display" : "IT Director",
      "definition" : "IT Director"
    },
    {
      "code" : "1227.012",
      "display" : "IT Infrastructure Manager",
      "definition" : "IT Infrastructure Manager"
    },
    {
      "code" : "1227.013",
      "display" : "IT Manager",
      "definition" : "IT Manager"
    },
    {
      "code" : "1227.014",
      "display" : "IT Support Manager",
      "definition" : "IT Support Manager"
    },
    {
      "code" : "1227.015",
      "display" : "TSS Manager",
      "definition" : "TSS Manager"
    },
    {
      "code" : "1228.001",
      "display" : "Organisation and Methods Manager",
      "definition" : "Organisation and Methods Manager"
    },
    {
      "code" : "1228.002",
      "display" : "Quality Assurance Manager",
      "definition" : "Quality Assurance Manager"
    },
    {
      "code" : "1228.003",
      "display" : "Quality Certification Manager",
      "definition" : "Quality Certification Manager"
    },
    {
      "code" : "1228.004",
      "display" : "Research and Development Manager",
      "definition" : "Research and Development Manager"
    },
    {
      "code" : "1229.001",
      "display" : "Chief Clerk",
      "definition" : "Chief Clerk"
    },
    {
      "code" : "1229.002",
      "display" : "Clerical Executive Officer",
      "definition" : "Clerical Executive Officer"
    },
    {
      "code" : "1229.003",
      "display" : "Departmental Head Clerical",
      "definition" : "Departmental Head Clerical"
    },
    {
      "code" : "1229.004",
      "display" : "Kaiwhakahaere Tari",
      "definition" : "Kaiwhakahaere Tari"
    },
    {
      "code" : "1229.005",
      "display" : "Office Manager",
      "definition" : "Office Manager"
    },
    {
      "code" : "1229.006",
      "display" : "Office Manageress",
      "definition" : "Office Manageress"
    },
    {
      "code" : "1229.007",
      "display" : "Rangatira o te Tari",
      "definition" : "Rangatira o te Tari"
    },
    {
      "code" : "2111.001",
      "display" : "Astronomer",
      "definition" : "Astronomer"
    },
    {
      "code" : "2111.002",
      "display" : "Astrophysicist",
      "definition" : "Astrophysicist"
    },
    {
      "code" : "2111.003",
      "display" : "Biophysicist",
      "definition" : "Biophysicist"
    },
    {
      "code" : "2111.004",
      "display" : "Nuclear Physicist",
      "definition" : "Nuclear Physicist"
    },
    {
      "code" : "2111.005",
      "display" : "Physical Scientist",
      "definition" : "Physical Scientist"
    },
    {
      "code" : "2111.006",
      "display" : "Physicist",
      "definition" : "Physicist"
    },
    {
      "code" : "2111.007",
      "display" : "Radio Astronomer",
      "definition" : "Radio Astronomer"
    },
    {
      "code" : "2111.008",
      "display" : "Solid State Physicist",
      "definition" : "Solid State Physicist"
    },
    {
      "code" : "2112.001",
      "display" : "Atmospheric Scientist",
      "definition" : "Atmospheric Scientist"
    },
    {
      "code" : "2112.002",
      "display" : "Climate Scientist",
      "definition" : "Climate Scientist"
    },
    {
      "code" : "2112.003",
      "display" : "Climatologist",
      "definition" : "Climatologist"
    },
    {
      "code" : "2112.004",
      "display" : "Meteorologist",
      "definition" : "Meteorologist"
    },
    {
      "code" : "2112.005",
      "display" : "Weather Forecaster",
      "definition" : "Weather Forecaster"
    },
    {
      "code" : "2113.001",
      "display" : "Chemist (Other than Pharmacist)",
      "definition" : "Chemist (Other than Pharmacist)"
    },
    {
      "code" : "2113.002",
      "display" : "General Chemist",
      "definition" : "General Chemist"
    },
    {
      "code" : "2113.003",
      "display" : "Industrial Chemist",
      "definition" : "Industrial Chemist"
    },
    {
      "code" : "2113.004",
      "display" : "Manufacturing Chemist",
      "definition" : "Manufacturing Chemist"
    },
    {
      "code" : "2113.005",
      "display" : "Nuclear Chemist",
      "definition" : "Nuclear Chemist"
    },
    {
      "code" : "2113.006",
      "display" : "Organic Chemist",
      "definition" : "Organic Chemist"
    },
    {
      "code" : "2113.007",
      "display" : "Paint Technologist",
      "definition" : "Paint Technologist"
    },
    {
      "code" : "2113.008",
      "display" : "Pharmaceutical Chemist",
      "definition" : "Pharmaceutical Chemist"
    },
    {
      "code" : "2113.009",
      "display" : "Polymer Chemist",
      "definition" : "Polymer Chemist"
    },
    {
      "code" : "2113.010",
      "display" : "Research Chemist",
      "definition" : "Research Chemist"
    },
    {
      "code" : "2114.001",
      "display" : "Earth Scientist",
      "definition" : "Earth Scientist"
    },
    {
      "code" : "2114.002",
      "display" : "Geological Oceanographer",
      "definition" : "Geological Oceanographer"
    },
    {
      "code" : "2114.003",
      "display" : "Geologist",
      "definition" : "Geologist"
    },
    {
      "code" : "2114.004",
      "display" : "Geomorphologist",
      "definition" : "Geomorphologist"
    },
    {
      "code" : "2114.005",
      "display" : "Geophysical Oceanographer",
      "definition" : "Geophysical Oceanographer"
    },
    {
      "code" : "2114.006",
      "display" : "Geophysical Scientist",
      "definition" : "Geophysical Scientist"
    },
    {
      "code" : "2114.007",
      "display" : "Geophysicist",
      "definition" : "Geophysicist"
    },
    {
      "code" : "2114.008",
      "display" : "Hydrologist",
      "definition" : "Hydrologist"
    },
    {
      "code" : "2114.009",
      "display" : "Marine Scientist",
      "definition" : "Marine Scientist"
    },
    {
      "code" : "2114.010",
      "display" : "Palaeontologist",
      "definition" : "Palaeontologist"
    },
    {
      "code" : "2114.011",
      "display" : "Petrologist",
      "definition" : "Petrologist"
    },
    {
      "code" : "2114.012",
      "display" : "Seismologist",
      "definition" : "Seismologist"
    },
    {
      "code" : "2114.013",
      "display" : "Vulcanologist",
      "definition" : "Vulcanologist"
    },
    {
      "code" : "2121.001",
      "display" : "Actuary",
      "definition" : "Actuary"
    },
    {
      "code" : "2121.002",
      "display" : "Applied Maths Scientist",
      "definition" : "Applied Maths Scientist"
    },
    {
      "code" : "2121.003",
      "display" : "Average Adjuster",
      "definition" : "Average Adjuster"
    },
    {
      "code" : "2121.004",
      "display" : "Biometrician",
      "definition" : "Biometrician"
    },
    {
      "code" : "2121.005",
      "display" : "Epidemiologist",
      "definition" : "Epidemiologist"
    },
    {
      "code" : "2121.006",
      "display" : "Mathematical Statistician",
      "definition" : "Mathematical Statistician"
    },
    {
      "code" : "2121.007",
      "display" : "Mathematician",
      "definition" : "Mathematician"
    },
    {
      "code" : "2121.008",
      "display" : "Mathematician and/or Statistician",
      "definition" : "Mathematician and/or Statistician"
    },
    {
      "code" : "2121.009",
      "display" : "Operations Research Analyst",
      "definition" : "Operations Research Analyst"
    },
    {
      "code" : "2121.010",
      "display" : "Statistician",
      "definition" : "Statistician"
    },
    {
      "code" : "2131.001",
      "display" : "Analyst Programmer",
      "definition" : "Analyst Programmer"
    },
    {
      "code" : "2131.002",
      "display" : "Applications Architect",
      "definition" : "Applications Architect"
    },
    {
      "code" : "2131.003",
      "display" : "Architect - Call Centre",
      "definition" : "Architect - Call Centre"
    },
    {
      "code" : "2131.004",
      "display" : "Architect - Desktop",
      "definition" : "Architect - Desktop"
    },
    {
      "code" : "2131.005",
      "display" : "Architect - Networking",
      "definition" : "Architect - Networking"
    },
    {
      "code" : "2131.006",
      "display" : "Architect Internet Security",
      "definition" : "Architect Internet Security"
    },
    {
      "code" : "2131.007",
      "display" : "Chief Software Architect",
      "definition" : "Chief Software Architect"
    },
    {
      "code" : "2131.008",
      "display" : "Cold Fusion Developer",
      "definition" : "Cold Fusion Developer"
    },
    {
      "code" : "2131.009",
      "display" : "Computer Analyst",
      "definition" : "Computer Analyst"
    },
    {
      "code" : "2131.010",
      "display" : "Computer Applications Engineer",
      "definition" : "Computer Applications Engineer"
    },
    {
      "code" : "2131.011",
      "display" : "Computer Programme Analyst",
      "definition" : "Computer Programme Analyst"
    },
    {
      "code" : "2131.012",
      "display" : "Computer Service Engineer",
      "definition" : "Computer Service Engineer"
    },
    {
      "code" : "2131.013",
      "display" : "Computer Support Engineer",
      "definition" : "Computer Support Engineer"
    },
    {
      "code" : "2131.014",
      "display" : "Computer Systems Analyst",
      "definition" : "Computer Systems Analyst"
    },
    {
      "code" : "2131.015",
      "display" : "Computer Systems Engineer",
      "definition" : "Computer Systems Engineer"
    },
    {
      "code" : "2131.016",
      "display" : "Computing Network Controller",
      "definition" : "Computing Network Controller"
    },
    {
      "code" : "2131.017",
      "display" : "Computing Systems Architect",
      "definition" : "Computing Systems Architect"
    },
    {
      "code" : "2131.018",
      "display" : "Content Engineer",
      "definition" : "Content Engineer"
    },
    {
      "code" : "2131.019",
      "display" : "Content Product Manager",
      "definition" : "Content Product Manager"
    },
    {
      "code" : "2131.020",
      "display" : "Data Architect",
      "definition" : "Data Architect"
    },
    {
      "code" : "2131.021",
      "display" : "Data Warehouse Consultant",
      "definition" : "Data Warehouse Consultant"
    },
    {
      "code" : "2131.022",
      "display" : "Data Warehouse Project Manager",
      "definition" : "Data Warehouse Project Manager"
    },
    {
      "code" : "2131.023",
      "display" : "Database Administrator",
      "definition" : "Database Administrator"
    },
    {
      "code" : "2131.024",
      "display" : "Database Specialist",
      "definition" : "Database Specialist"
    },
    {
      "code" : "2131.025",
      "display" : "Decision Support Tools Developer",
      "definition" : "Decision Support Tools Developer"
    },
    {
      "code" : "2131.026",
      "display" : "Ecommerce Consultant",
      "definition" : "Ecommerce Consultant"
    },
    {
      "code" : "2131.027",
      "display" : "Ecommerce Developer",
      "definition" : "Ecommerce Developer"
    },
    {
      "code" : "2131.028",
      "display" : "Ecommerce Technical Architect",
      "definition" : "Ecommerce Technical Architect"
    },
    {
      "code" : "2131.029",
      "display" : "Geographic Information Systems Developer",
      "definition" : "Geographic Information Systems Developer"
    },
    {
      "code" : "2131.030",
      "display" : "Geographic Information Systems Officer",
      "definition" : "Geographic Information Systems Officer"
    },
    {
      "code" : "2131.031",
      "display" : "GIS Developer",
      "definition" : "GIS Developer"
    },
    {
      "code" : "2131.032",
      "display" : "GIS Officer",
      "definition" : "GIS Officer"
    },
    {
      "code" : "2131.033",
      "display" : "Head of Business Ecommerce",
      "definition" : "Head of Business Ecommerce"
    },
    {
      "code" : "2131.034",
      "display" : "HTML Coder",
      "definition" : "HTML Coder"
    },
    {
      "code" : "2131.035",
      "display" : "HTML Developer",
      "definition" : "HTML Developer"
    },
    {
      "code" : "2131.036",
      "display" : "Internet Architect",
      "definition" : "Internet Architect"
    },
    {
      "code" : "2131.037",
      "display" : "Internet Consultant",
      "definition" : "Internet Consultant"
    },
    {
      "code" : "2131.038",
      "display" : "Intranet Administrator",
      "definition" : "Intranet Administrator"
    },
    {
      "code" : "2131.039",
      "display" : "Intranet Developer",
      "definition" : "Intranet Developer"
    },
    {
      "code" : "2131.040",
      "display" : "IP Technology System Engineer",
      "definition" : "IP Technology System Engineer"
    },
    {
      "code" : "2131.041",
      "display" : "IT Administrator",
      "definition" : "IT Administrator"
    },
    {
      "code" : "2131.042",
      "display" : "IT Consultant",
      "definition" : "IT Consultant"
    },
    {
      "code" : "2131.043",
      "display" : "IT Recruitment Consultant",
      "definition" : "IT Recruitment Consultant"
    },
    {
      "code" : "2131.044",
      "display" : "IT Systems Manager",
      "definition" : "IT Systems Manager"
    },
    {
      "code" : "2131.045",
      "display" : "Java Architect",
      "definition" : "Java Architect"
    },
    {
      "code" : "2131.046",
      "display" : "Java Developer",
      "definition" : "Java Developer"
    },
    {
      "code" : "2131.047",
      "display" : "Java Mentor",
      "definition" : "Java Mentor"
    },
    {
      "code" : "2131.048",
      "display" : "Java Programmer",
      "definition" : "Java Programmer"
    },
    {
      "code" : "2131.049",
      "display" : "LAN Administrator",
      "definition" : "LAN Administrator"
    },
    {
      "code" : "2131.050",
      "display" : "LAN Consultant",
      "definition" : "LAN Consultant"
    },
    {
      "code" : "2131.051",
      "display" : "Lotus Notes Developer",
      "definition" : "Lotus Notes Developer"
    },
    {
      "code" : "2131.052",
      "display" : "Lotus Web Developer",
      "definition" : "Lotus Web Developer"
    },
    {
      "code" : "2131.053",
      "display" : "Network Administrator",
      "definition" : "Network Administrator"
    },
    {
      "code" : "2131.054",
      "display" : "Programme Analyst Data Processing",
      "definition" : "Programme Analyst Data Processing"
    },
    {
      "code" : "2131.055",
      "display" : "Project Analyst Computing",
      "definition" : "Project Analyst Computing"
    },
    {
      "code" : "2131.056",
      "display" : "Project Manager Ecommerce",
      "definition" : "Project Manager Ecommerce"
    },
    {
      "code" : "2131.057",
      "display" : "Project Manager Methods Consultant",
      "definition" : "Project Manager Methods Consultant"
    },
    {
      "code" : "2131.058",
      "display" : "Smalltalk Visualworks Analyst Programmer",
      "definition" : "Smalltalk Visualworks Analyst Programmer"
    },
    {
      "code" : "2131.059",
      "display" : "Software Designer",
      "definition" : "Software Designer"
    },
    {
      "code" : "2131.060",
      "display" : "Software Developer",
      "definition" : "Software Developer"
    },
    {
      "code" : "2131.061",
      "display" : "Software Engineer",
      "definition" : "Software Engineer"
    },
    {
      "code" : "2131.062",
      "display" : "Software Programmer",
      "definition" : "Software Programmer"
    },
    {
      "code" : "2131.063",
      "display" : "SQL Database Administrator",
      "definition" : "SQL Database Administrator"
    },
    {
      "code" : "2131.064",
      "display" : "Systems Administrator",
      "definition" : "Systems Administrator"
    },
    {
      "code" : "2131.065",
      "display" : "Systems Analyst",
      "definition" : "Systems Analyst"
    },
    {
      "code" : "2131.066",
      "display" : "Systems Designer",
      "definition" : "Systems Designer"
    },
    {
      "code" : "2131.067",
      "display" : "Systems Manager",
      "definition" : "Systems Manager"
    },
    {
      "code" : "2131.068",
      "display" : "Systems Software Engineer",
      "definition" : "Systems Software Engineer"
    },
    {
      "code" : "2131.069",
      "display" : "Technical Architect Computing",
      "definition" : "Technical Architect Computing"
    },
    {
      "code" : "2131.070",
      "display" : "Technical Architect Ecommerce",
      "definition" : "Technical Architect Ecommerce"
    },
    {
      "code" : "2131.071",
      "display" : "Technology Consultant Computing",
      "definition" : "Technology Consultant Computing"
    },
    {
      "code" : "2131.072",
      "display" : "UNIX Architect",
      "definition" : "UNIX Architect"
    },
    {
      "code" : "2131.073",
      "display" : "UNIX System Administrator",
      "definition" : "UNIX System Administrator"
    },
    {
      "code" : "2131.074",
      "display" : "VB Access Analyst Programmer",
      "definition" : "VB Access Analyst Programmer"
    },
    {
      "code" : "2131.075",
      "display" : "Visual Basic Developer",
      "definition" : "Visual Basic Developer"
    },
    {
      "code" : "2131.076",
      "display" : "WAN Administrator",
      "definition" : "WAN Administrator"
    },
    {
      "code" : "2131.077",
      "display" : "WAN Consultant",
      "definition" : "WAN Consultant"
    },
    {
      "code" : "2131.078",
      "display" : "WAN Engineer",
      "definition" : "WAN Engineer"
    },
    {
      "code" : "2131.079",
      "display" : "Web Administrator",
      "definition" : "Web Administrator"
    },
    {
      "code" : "2131.080",
      "display" : "Web Architect",
      "definition" : "Web Architect"
    },
    {
      "code" : "2131.081",
      "display" : "Web Design Team Leader",
      "definition" : "Web Design Team Leader"
    },
    {
      "code" : "2131.082",
      "display" : "Web Designer",
      "definition" : "Web Designer"
    },
    {
      "code" : "2131.083",
      "display" : "Web Developer",
      "definition" : "Web Developer"
    },
    {
      "code" : "2131.084",
      "display" : "Web Developer Ecommerce",
      "definition" : "Web Developer Ecommerce"
    },
    {
      "code" : "2131.085",
      "display" : "Web Development Manager",
      "definition" : "Web Development Manager"
    },
    {
      "code" : "2131.086",
      "display" : "Web Development Team Member",
      "definition" : "Web Development Team Member"
    },
    {
      "code" : "2131.087",
      "display" : "Web Interface Developer",
      "definition" : "Web Interface Developer"
    },
    {
      "code" : "2131.088",
      "display" : "Web Master",
      "definition" : "Web Master"
    },
    {
      "code" : "2131.089",
      "display" : "Web Page Producer",
      "definition" : "Web Page Producer"
    },
    {
      "code" : "2131.090",
      "display" : "Web Production Manager",
      "definition" : "Web Production Manager"
    },
    {
      "code" : "2131.091",
      "display" : "Web Programmer Cold Fusion",
      "definition" : "Web Programmer Cold Fusion"
    },
    {
      "code" : "2131.092",
      "display" : "Web Startup Developer",
      "definition" : "Web Startup Developer"
    },
    {
      "code" : "2131.093",
      "display" : "Web Support Engineer",
      "definition" : "Web Support Engineer"
    },
    {
      "code" : "2131.094",
      "display" : "Web Wonderstar",
      "definition" : "Web Wonderstar"
    },
    {
      "code" : "2131.095",
      "display" : "Webmaster",
      "definition" : "Webmaster"
    },
    {
      "code" : "2131.096",
      "display" : "Website Administrator",
      "definition" : "Website Administrator"
    },
    {
      "code" : "2131.097",
      "display" : "Website Designer",
      "definition" : "Website Designer"
    },
    {
      "code" : "2131.098",
      "display" : "Website Developer",
      "definition" : "Website Developer"
    },
    {
      "code" : "2141.001",
      "display" : "Architect",
      "definition" : "Architect"
    },
    {
      "code" : "2141.002",
      "display" : "Building Designer",
      "definition" : "Building Designer"
    },
    {
      "code" : "2141.003",
      "display" : "Commercial Architect",
      "definition" : "Commercial Architect"
    },
    {
      "code" : "2141.004",
      "display" : "Community Liaison Planner",
      "definition" : "Community Liaison Planner"
    },
    {
      "code" : "2141.005",
      "display" : "Community Planner",
      "definition" : "Community Planner"
    },
    {
      "code" : "2141.006",
      "display" : "Community Recreation Planner",
      "definition" : "Community Recreation Planner"
    },
    {
      "code" : "2141.007",
      "display" : "Country Planner",
      "definition" : "Country Planner"
    },
    {
      "code" : "2141.008",
      "display" : "District Planner",
      "definition" : "District Planner"
    },
    {
      "code" : "2141.009",
      "display" : "Garden Designer",
      "definition" : "Garden Designer"
    },
    {
      "code" : "2141.010",
      "display" : "Housing Architect",
      "definition" : "Housing Architect"
    },
    {
      "code" : "2141.011",
      "display" : "Landscape Architect",
      "definition" : "Landscape Architect"
    },
    {
      "code" : "2141.012",
      "display" : "Landscape Designer",
      "definition" : "Landscape Designer"
    },
    {
      "code" : "2141.013",
      "display" : "Landscape Planner",
      "definition" : "Landscape Planner"
    },
    {
      "code" : "2141.014",
      "display" : "Resource Consent Planner",
      "definition" : "Resource Consent Planner"
    },
    {
      "code" : "2141.015",
      "display" : "Resource Management Planner",
      "definition" : "Resource Management Planner"
    },
    {
      "code" : "2141.016",
      "display" : "Town and Country Planner",
      "definition" : "Town and Country Planner"
    },
    {
      "code" : "2141.017",
      "display" : "Town Planner",
      "definition" : "Town Planner"
    },
    {
      "code" : "2141.018",
      "display" : "Urban Planner",
      "definition" : "Urban Planner"
    },
    {
      "code" : "2142.001",
      "display" : "Airport Construction Engineer",
      "definition" : "Airport Construction Engineer"
    },
    {
      "code" : "2142.002",
      "display" : "Building Construction Engineer",
      "definition" : "Building Construction Engineer"
    },
    {
      "code" : "2142.003",
      "display" : "Civil Consulting Engineer",
      "definition" : "Civil Consulting Engineer"
    },
    {
      "code" : "2142.004",
      "display" : "Civil Design Engineer",
      "definition" : "Civil Design Engineer"
    },
    {
      "code" : "2142.005",
      "display" : "Civil Engineer",
      "definition" : "Civil Engineer"
    },
    {
      "code" : "2142.006",
      "display" : "Construction Engineer",
      "definition" : "Construction Engineer"
    },
    {
      "code" : "2142.007",
      "display" : "Construction Engineer Roads",
      "definition" : "Construction Engineer Roads"
    },
    {
      "code" : "2142.008",
      "display" : "Drainage Engineer",
      "definition" : "Drainage Engineer"
    },
    {
      "code" : "2142.009",
      "display" : "Highway Maintenance Engineer",
      "definition" : "Highway Maintenance Engineer"
    },
    {
      "code" : "2142.010",
      "display" : "Hydraulic Engineer",
      "definition" : "Hydraulic Engineer"
    },
    {
      "code" : "2142.011",
      "display" : "Hydrographical Engineer",
      "definition" : "Hydrographical Engineer"
    },
    {
      "code" : "2142.012",
      "display" : "Hydrological Engineer",
      "definition" : "Hydrological Engineer"
    },
    {
      "code" : "2142.013",
      "display" : "Irrigation Engineer",
      "definition" : "Irrigation Engineer"
    },
    {
      "code" : "2142.014",
      "display" : "Local Body Engineer",
      "definition" : "Local Body Engineer"
    },
    {
      "code" : "2142.015",
      "display" : "Municipal Engineer",
      "definition" : "Municipal Engineer"
    },
    {
      "code" : "2142.016",
      "display" : "Other Civil Engineer",
      "definition" : "Other Civil Engineer"
    },
    {
      "code" : "2142.017",
      "display" : "Project Engineer (Construction)",
      "definition" : "Project Engineer (Construction)"
    },
    {
      "code" : "2142.018",
      "display" : "Project Inspector Civil Engineer",
      "definition" : "Project Inspector Civil Engineer"
    },
    {
      "code" : "2142.019",
      "display" : "Public Health Engineer",
      "definition" : "Public Health Engineer"
    },
    {
      "code" : "2142.020",
      "display" : "Railway Construction Engineer",
      "definition" : "Railway Construction Engineer"
    },
    {
      "code" : "2142.021",
      "display" : "Roading Consulting Engineer",
      "definition" : "Roading Consulting Engineer"
    },
    {
      "code" : "2142.022",
      "display" : "Roading Engineer",
      "definition" : "Roading Engineer"
    },
    {
      "code" : "2142.023",
      "display" : "Sanitary Drainage Engineer",
      "definition" : "Sanitary Drainage Engineer"
    },
    {
      "code" : "2142.024",
      "display" : "Sanitation Engineer",
      "definition" : "Sanitation Engineer"
    },
    {
      "code" : "2142.025",
      "display" : "Structural Engineer",
      "definition" : "Structural Engineer"
    },
    {
      "code" : "2142.026",
      "display" : "Structural Steel Engineer",
      "definition" : "Structural Steel Engineer"
    },
    {
      "code" : "2142.027",
      "display" : "Traffic Engineer",
      "definition" : "Traffic Engineer"
    },
    {
      "code" : "2142.028",
      "display" : "Traffic Planning Engineer",
      "definition" : "Traffic Planning Engineer"
    },
    {
      "code" : "2142.029",
      "display" : "Transportation Engineer",
      "definition" : "Transportation Engineer"
    },
    {
      "code" : "2142.030",
      "display" : "Water and Soil Engineer",
      "definition" : "Water and Soil Engineer"
    },
    {
      "code" : "2142.031",
      "display" : "Water Flow Engineer",
      "definition" : "Water Flow Engineer"
    },
    {
      "code" : "2142.032",
      "display" : "Water Flow Research Engineer",
      "definition" : "Water Flow Research Engineer"
    },
    {
      "code" : "2142.033",
      "display" : "Water Resources Engineer",
      "definition" : "Water Resources Engineer"
    },
    {
      "code" : "2142.034",
      "display" : "Water Supply Engineer",
      "definition" : "Water Supply Engineer"
    },
    {
      "code" : "2143.001",
      "display" : "Electrical Consulting Engineer",
      "definition" : "Electrical Consulting Engineer"
    },
    {
      "code" : "2143.002",
      "display" : "Electrical Engineer",
      "definition" : "Electrical Engineer"
    },
    {
      "code" : "2143.003",
      "display" : "Electrical Engineer (Automotive)",
      "definition" : "Electrical Engineer (Automotive)"
    },
    {
      "code" : "2143.004",
      "display" : "Electrical Instrument Engineer",
      "definition" : "Electrical Instrument Engineer"
    },
    {
      "code" : "2143.005",
      "display" : "Industrial Electrical Engineer",
      "definition" : "Industrial Electrical Engineer"
    },
    {
      "code" : "2143.006",
      "display" : "Power Distribution Engineer",
      "definition" : "Power Distribution Engineer"
    },
    {
      "code" : "2143.007",
      "display" : "Power Systems Engineer",
      "definition" : "Power Systems Engineer"
    },
    {
      "code" : "2143.008",
      "display" : "Power Transmission Engineer",
      "definition" : "Power Transmission Engineer"
    },
    {
      "code" : "2144.001",
      "display" : "Electronic and Telecommunication Engineer",
      "definition" : "Electronic and Telecommunication Engineer"
    },
    {
      "code" : "2144.002",
      "display" : "Electronic Instrument Engineer",
      "definition" : "Electronic Instrument Engineer"
    },
    {
      "code" : "2144.003",
      "display" : "Electronics Consulting Engineer",
      "definition" : "Electronics Consulting Engineer"
    },
    {
      "code" : "2144.004",
      "display" : "Electronics Design Engineer",
      "definition" : "Electronics Design Engineer"
    },
    {
      "code" : "2144.005",
      "display" : "Electronics Designer",
      "definition" : "Electronics Designer"
    },
    {
      "code" : "2144.006",
      "display" : "Electronics Engineer",
      "definition" : "Electronics Engineer"
    },
    {
      "code" : "2144.007",
      "display" : "Electronics Project Engineer",
      "definition" : "Electronics Project Engineer"
    },
    {
      "code" : "2144.008",
      "display" : "Fibre Optics Engineer",
      "definition" : "Fibre Optics Engineer"
    },
    {
      "code" : "2144.009",
      "display" : "Fibre Optics Transmission Engineer",
      "definition" : "Fibre Optics Transmission Engineer"
    },
    {
      "code" : "2144.010",
      "display" : "Radar Engineer",
      "definition" : "Radar Engineer"
    },
    {
      "code" : "2144.011",
      "display" : "Radio and Telecommunications Engineer",
      "definition" : "Radio and Telecommunications Engineer"
    },
    {
      "code" : "2144.012",
      "display" : "Radio Engineer",
      "definition" : "Radio Engineer"
    },
    {
      "code" : "2144.013",
      "display" : "Satellite Transmission Engineer",
      "definition" : "Satellite Transmission Engineer"
    },
    {
      "code" : "2144.014",
      "display" : "Signal Systems Engineer",
      "definition" : "Signal Systems Engineer"
    },
    {
      "code" : "2144.015",
      "display" : "Telecommunications Engineer",
      "definition" : "Telecommunications Engineer"
    },
    {
      "code" : "2144.016",
      "display" : "Television Engineer",
      "definition" : "Television Engineer"
    },
    {
      "code" : "2145.001",
      "display" : "Aeronautical Design Engineer",
      "definition" : "Aeronautical Design Engineer"
    },
    {
      "code" : "2145.002",
      "display" : "Aeronautical Engineer",
      "definition" : "Aeronautical Engineer"
    },
    {
      "code" : "2145.003",
      "display" : "Aerospace Engineer",
      "definition" : "Aerospace Engineer"
    },
    {
      "code" : "2145.004",
      "display" : "Agricultural Engineer",
      "definition" : "Agricultural Engineer"
    },
    {
      "code" : "2145.005",
      "display" : "Air Conditioning Engineer",
      "definition" : "Air Conditioning Engineer"
    },
    {
      "code" : "2145.006",
      "display" : "Aircraft Designer",
      "definition" : "Aircraft Designer"
    },
    {
      "code" : "2145.007",
      "display" : "Aircraft Engineer",
      "definition" : "Aircraft Engineer"
    },
    {
      "code" : "2145.008",
      "display" : "Aircraft Engineering Consultant",
      "definition" : "Aircraft Engineering Consultant"
    },
    {
      "code" : "2145.009",
      "display" : "Aircraft Examiner",
      "definition" : "Aircraft Examiner"
    },
    {
      "code" : "2145.010",
      "display" : "Aircraft Inspector",
      "definition" : "Aircraft Inspector"
    },
    {
      "code" : "2145.011",
      "display" : "Aircraft Surveyor",
      "definition" : "Aircraft Surveyor"
    },
    {
      "code" : "2145.012",
      "display" : "Diesel Engineer",
      "definition" : "Diesel Engineer"
    },
    {
      "code" : "2145.013",
      "display" : "Diesel Engineer (Automotive)",
      "definition" : "Diesel Engineer (Automotive)"
    },
    {
      "code" : "2145.014",
      "display" : "Engineer Freezing Works",
      "definition" : "Engineer Freezing Works"
    },
    {
      "code" : "2145.015",
      "display" : "Farm Engineer",
      "definition" : "Farm Engineer"
    },
    {
      "code" : "2145.016",
      "display" : "Farm Equipment Design Engineer",
      "definition" : "Farm Equipment Design Engineer"
    },
    {
      "code" : "2145.017",
      "display" : "Heating and Ventilation Engineer",
      "definition" : "Heating and Ventilation Engineer"
    },
    {
      "code" : "2145.018",
      "display" : "Heating Control Engineer",
      "definition" : "Heating Control Engineer"
    },
    {
      "code" : "2145.019",
      "display" : "Heating Engineer",
      "definition" : "Heating Engineer"
    },
    {
      "code" : "2145.020",
      "display" : "Heavy Industrial Engineer",
      "definition" : "Heavy Industrial Engineer"
    },
    {
      "code" : "2145.021",
      "display" : "Horticultural Engineer",
      "definition" : "Horticultural Engineer"
    },
    {
      "code" : "2145.022",
      "display" : "Industrial Engineer",
      "definition" : "Industrial Engineer"
    },
    {
      "code" : "2145.023",
      "display" : "Industrial Engineer (Automotive)",
      "definition" : "Industrial Engineer (Automotive)"
    },
    {
      "code" : "2145.024",
      "display" : "Industrial Machinery Engineer",
      "definition" : "Industrial Machinery Engineer"
    },
    {
      "code" : "2145.025",
      "display" : "Instrument Engineer Mechanical",
      "definition" : "Instrument Engineer Mechanical"
    },
    {
      "code" : "2145.026",
      "display" : "Marine Architect",
      "definition" : "Marine Architect"
    },
    {
      "code" : "2145.027",
      "display" : "Marine Designer",
      "definition" : "Marine Designer"
    },
    {
      "code" : "2145.028",
      "display" : "Marine Examiner",
      "definition" : "Marine Examiner"
    },
    {
      "code" : "2145.029",
      "display" : "Mechanical Consulting Engineer",
      "definition" : "Mechanical Consulting Engineer"
    },
    {
      "code" : "2145.030",
      "display" : "Mechanical Engineer",
      "definition" : "Mechanical Engineer"
    },
    {
      "code" : "2145.031",
      "display" : "Mechanical Engineer (Automotive)",
      "definition" : "Mechanical Engineer (Automotive)"
    },
    {
      "code" : "2145.032",
      "display" : "Mechanical Engineer Aeronautical",
      "definition" : "Mechanical Engineer Aeronautical"
    },
    {
      "code" : "2145.033",
      "display" : "Mechanical Engineer Heating and Ventilation",
      "definition" : "Mechanical Engineer Heating and Ventilation"
    },
    {
      "code" : "2145.034",
      "display" : "Nautical Surveyor",
      "definition" : "Nautical Surveyor"
    },
    {
      "code" : "2145.035",
      "display" : "Naval Architect",
      "definition" : "Naval Architect"
    },
    {
      "code" : "2145.036",
      "display" : "Refrigeration and Air Conditioning Engineer",
      "definition" : "Refrigeration and Air Conditioning Engineer"
    },
    {
      "code" : "2145.037",
      "display" : "Refrigeration Engineer",
      "definition" : "Refrigeration Engineer"
    },
    {
      "code" : "2145.038",
      "display" : "Refrigeration Services Engineer",
      "definition" : "Refrigeration Services Engineer"
    },
    {
      "code" : "2145.039",
      "display" : "Refrigeration System Engineer",
      "definition" : "Refrigeration System Engineer"
    },
    {
      "code" : "2145.040",
      "display" : "Ship Designer",
      "definition" : "Ship Designer"
    },
    {
      "code" : "2145.041",
      "display" : "Ships Surveyor",
      "definition" : "Ships Surveyor"
    },
    {
      "code" : "2145.042",
      "display" : "Ventilation Engineer",
      "definition" : "Ventilation Engineer"
    },
    {
      "code" : "2146.001",
      "display" : "Biochemical Engineer",
      "definition" : "Biochemical Engineer"
    },
    {
      "code" : "2146.002",
      "display" : "Bioprocess Engineer",
      "definition" : "Bioprocess Engineer"
    },
    {
      "code" : "2146.003",
      "display" : "Biotechnologist",
      "definition" : "Biotechnologist"
    },
    {
      "code" : "2146.004",
      "display" : "Brewery Technologist",
      "definition" : "Brewery Technologist"
    },
    {
      "code" : "2146.005",
      "display" : "Chemical Engineer",
      "definition" : "Chemical Engineer"
    },
    {
      "code" : "2146.006",
      "display" : "Food and Drink Technologist",
      "definition" : "Food and Drink Technologist"
    },
    {
      "code" : "2146.007",
      "display" : "Food Chemist",
      "definition" : "Food Chemist"
    },
    {
      "code" : "2146.008",
      "display" : "Food Engineer",
      "definition" : "Food Engineer"
    },
    {
      "code" : "2146.009",
      "display" : "Food Scientist",
      "definition" : "Food Scientist"
    },
    {
      "code" : "2146.010",
      "display" : "Food Technologist",
      "definition" : "Food Technologist"
    },
    {
      "code" : "2146.011",
      "display" : "Gas Engineer",
      "definition" : "Gas Engineer"
    },
    {
      "code" : "2146.012",
      "display" : "Glass and Ceramics Technologist",
      "definition" : "Glass and Ceramics Technologist"
    },
    {
      "code" : "2146.013",
      "display" : "Oil Refinery Engineer",
      "definition" : "Oil Refinery Engineer"
    },
    {
      "code" : "2146.014",
      "display" : "Petroleum Engineer",
      "definition" : "Petroleum Engineer"
    },
    {
      "code" : "2146.015",
      "display" : "Petroleum Engineer Refinery",
      "definition" : "Petroleum Engineer Refinery"
    },
    {
      "code" : "2147.001",
      "display" : "Applied Scientist Metallurgy",
      "definition" : "Applied Scientist Metallurgy"
    },
    {
      "code" : "2147.002",
      "display" : "Assayer",
      "definition" : "Assayer"
    },
    {
      "code" : "2147.003",
      "display" : "Coal Mining Engineer",
      "definition" : "Coal Mining Engineer"
    },
    {
      "code" : "2147.004",
      "display" : "Colliery Engineer",
      "definition" : "Colliery Engineer"
    },
    {
      "code" : "2147.005",
      "display" : "Metallurgist",
      "definition" : "Metallurgist"
    },
    {
      "code" : "2147.006",
      "display" : "Metals Scientist",
      "definition" : "Metals Scientist"
    },
    {
      "code" : "2147.007",
      "display" : "Mining Engineer",
      "definition" : "Mining Engineer"
    },
    {
      "code" : "2147.008",
      "display" : "Prospecter Oil Petroleum Gas",
      "definition" : "Prospecter Oil Petroleum Gas"
    },
    {
      "code" : "2148.001",
      "display" : "Cartographer",
      "definition" : "Cartographer"
    },
    {
      "code" : "2148.002",
      "display" : "Engineering Surveyor",
      "definition" : "Engineering Surveyor"
    },
    {
      "code" : "2148.003",
      "display" : "Facilities Engineer",
      "definition" : "Facilities Engineer"
    },
    {
      "code" : "2148.004",
      "display" : "Geodetic Surveyor",
      "definition" : "Geodetic Surveyor"
    },
    {
      "code" : "2148.005",
      "display" : "Hydraulic Surveyor",
      "definition" : "Hydraulic Surveyor"
    },
    {
      "code" : "2148.006",
      "display" : "Hydrographic Surveyor",
      "definition" : "Hydrographic Surveyor"
    },
    {
      "code" : "2148.007",
      "display" : "Land Surveyor",
      "definition" : "Land Surveyor"
    },
    {
      "code" : "2148.008",
      "display" : "Map Maker",
      "definition" : "Map Maker"
    },
    {
      "code" : "2148.009",
      "display" : "Marine Cartographer",
      "definition" : "Marine Cartographer"
    },
    {
      "code" : "2148.010",
      "display" : "Marine Surveyor",
      "definition" : "Marine Surveyor"
    },
    {
      "code" : "2148.011",
      "display" : "Mines Surveyor",
      "definition" : "Mines Surveyor"
    },
    {
      "code" : "2148.012",
      "display" : "Photogrammetrist",
      "definition" : "Photogrammetrist"
    },
    {
      "code" : "2148.013",
      "display" : "Photographic Surveyor",
      "definition" : "Photographic Surveyor"
    },
    {
      "code" : "2148.014",
      "display" : "Surveyor",
      "definition" : "Surveyor"
    },
    {
      "code" : "2211.001",
      "display" : "Agricultural Scientist",
      "definition" : "Agricultural Scientist"
    },
    {
      "code" : "2211.002",
      "display" : "Agronomist",
      "definition" : "Agronomist"
    },
    {
      "code" : "2211.003",
      "display" : "Agrostologist",
      "definition" : "Agrostologist"
    },
    {
      "code" : "2211.004",
      "display" : "Anatomist",
      "definition" : "Anatomist"
    },
    {
      "code" : "2211.005",
      "display" : "Animal Ecologist",
      "definition" : "Animal Ecologist"
    },
    {
      "code" : "2211.006",
      "display" : "Animal Physiologist",
      "definition" : "Animal Physiologist"
    },
    {
      "code" : "2211.007",
      "display" : "Animal Scientist",
      "definition" : "Animal Scientist"
    },
    {
      "code" : "2211.008",
      "display" : "Apicultural Scientist",
      "definition" : "Apicultural Scientist"
    },
    {
      "code" : "2211.009",
      "display" : "Aquatic Biologist",
      "definition" : "Aquatic Biologist"
    },
    {
      "code" : "2211.010",
      "display" : "Biologist",
      "definition" : "Biologist"
    },
    {
      "code" : "2211.011",
      "display" : "Botanist",
      "definition" : "Botanist"
    },
    {
      "code" : "2211.012",
      "display" : "Crop Research Scientist",
      "definition" : "Crop Research Scientist"
    },
    {
      "code" : "2211.013",
      "display" : "Ecological Researcher",
      "definition" : "Ecological Researcher"
    },
    {
      "code" : "2211.014",
      "display" : "Ecologist",
      "definition" : "Ecologist"
    },
    {
      "code" : "2211.015",
      "display" : "Endocrinologist",
      "definition" : "Endocrinologist"
    },
    {
      "code" : "2211.016",
      "display" : "Entomologist",
      "definition" : "Entomologist"
    },
    {
      "code" : "2211.017",
      "display" : "Environmental Scientist",
      "definition" : "Environmental Scientist"
    },
    {
      "code" : "2211.018",
      "display" : "Environmentalist",
      "definition" : "Environmentalist"
    },
    {
      "code" : "2211.019",
      "display" : "Farming Scientist",
      "definition" : "Farming Scientist"
    },
    {
      "code" : "2211.020",
      "display" : "Fisheries Researcher",
      "definition" : "Fisheries Researcher"
    },
    {
      "code" : "2211.021",
      "display" : "Fisheries Scientist",
      "definition" : "Fisheries Scientist"
    },
    {
      "code" : "2211.022",
      "display" : "Forest Pathologist",
      "definition" : "Forest Pathologist"
    },
    {
      "code" : "2211.023",
      "display" : "Forest Product Scientist",
      "definition" : "Forest Product Scientist"
    },
    {
      "code" : "2211.024",
      "display" : "Forest Scientist",
      "definition" : "Forest Scientist"
    },
    {
      "code" : "2211.025",
      "display" : "Forester",
      "definition" : "Forester"
    },
    {
      "code" : "2211.026",
      "display" : "Forestry Conservationist",
      "definition" : "Forestry Conservationist"
    },
    {
      "code" : "2211.027",
      "display" : "Forestry Researcher",
      "definition" : "Forestry Researcher"
    },
    {
      "code" : "2211.028",
      "display" : "Forestry Scientist",
      "definition" : "Forestry Scientist"
    },
    {
      "code" : "2211.029",
      "display" : "Freshwater Ecologist",
      "definition" : "Freshwater Ecologist"
    },
    {
      "code" : "2211.030",
      "display" : "Fruit Research Scientist",
      "definition" : "Fruit Research Scientist"
    },
    {
      "code" : "2211.031",
      "display" : "Horticultural Scientist",
      "definition" : "Horticultural Scientist"
    },
    {
      "code" : "2211.032",
      "display" : "Marine Biologist",
      "definition" : "Marine Biologist"
    },
    {
      "code" : "2211.033",
      "display" : "Marine Ecologist",
      "definition" : "Marine Ecologist"
    },
    {
      "code" : "2211.034",
      "display" : "Molecular Biologist",
      "definition" : "Molecular Biologist"
    },
    {
      "code" : "2211.035",
      "display" : "Mycologist",
      "definition" : "Mycologist"
    },
    {
      "code" : "2211.036",
      "display" : "Ornithologist",
      "definition" : "Ornithologist"
    },
    {
      "code" : "2211.037",
      "display" : "Osteologist",
      "definition" : "Osteologist"
    },
    {
      "code" : "2211.038",
      "display" : "Phytotomist",
      "definition" : "Phytotomist"
    },
    {
      "code" : "2211.039",
      "display" : "Plant Biologist",
      "definition" : "Plant Biologist"
    },
    {
      "code" : "2211.040",
      "display" : "Plant Ecologist",
      "definition" : "Plant Ecologist"
    },
    {
      "code" : "2211.041",
      "display" : "Plant Environmental Biologist",
      "definition" : "Plant Environmental Biologist"
    },
    {
      "code" : "2211.042",
      "display" : "Plant Molecular Biologist",
      "definition" : "Plant Molecular Biologist"
    },
    {
      "code" : "2211.043",
      "display" : "Plant Pathologist",
      "definition" : "Plant Pathologist"
    },
    {
      "code" : "2211.044",
      "display" : "Plant Physiologist",
      "definition" : "Plant Physiologist"
    },
    {
      "code" : "2211.045",
      "display" : "Plant Taxonomist",
      "definition" : "Plant Taxonomist"
    },
    {
      "code" : "2211.046",
      "display" : "Plant Toxicologist",
      "definition" : "Plant Toxicologist"
    },
    {
      "code" : "2211.047",
      "display" : "Pomologist",
      "definition" : "Pomologist"
    },
    {
      "code" : "2211.048",
      "display" : "Silviculturist",
      "definition" : "Silviculturist"
    },
    {
      "code" : "2211.049",
      "display" : "Wildlife Biologist",
      "definition" : "Wildlife Biologist"
    },
    {
      "code" : "2211.050",
      "display" : "Wildlife Conservationist",
      "definition" : "Wildlife Conservationist"
    },
    {
      "code" : "2211.051",
      "display" : "Wool Research Scientist",
      "definition" : "Wool Research Scientist"
    },
    {
      "code" : "2211.052",
      "display" : "Zoologist",
      "definition" : "Zoologist"
    },
    {
      "code" : "2212.001",
      "display" : "Anatomical Pathologist",
      "definition" : "Anatomical Pathologist"
    },
    {
      "code" : "2212.002",
      "display" : "Bacteriologist",
      "definition" : "Bacteriologist"
    },
    {
      "code" : "2212.003",
      "display" : "Biochemist",
      "definition" : "Biochemist"
    },
    {
      "code" : "2212.004",
      "display" : "Biological Chemist",
      "definition" : "Biological Chemist"
    },
    {
      "code" : "2212.005",
      "display" : "Biomedical Engineer",
      "definition" : "Biomedical Engineer"
    },
    {
      "code" : "2212.006",
      "display" : "Cellular Biochemist",
      "definition" : "Cellular Biochemist"
    },
    {
      "code" : "2212.007",
      "display" : "Cytologist",
      "definition" : "Cytologist"
    },
    {
      "code" : "2212.008",
      "display" : "Forensic Biologist",
      "definition" : "Forensic Biologist"
    },
    {
      "code" : "2212.009",
      "display" : "Forensic Scientist",
      "definition" : "Forensic Scientist"
    },
    {
      "code" : "2212.010",
      "display" : "Haemotologist",
      "definition" : "Haemotologist"
    },
    {
      "code" : "2212.011",
      "display" : "Histologist",
      "definition" : "Histologist"
    },
    {
      "code" : "2212.012",
      "display" : "Immunologist",
      "definition" : "Immunologist"
    },
    {
      "code" : "2212.013",
      "display" : "Industrial Microbiologist",
      "definition" : "Industrial Microbiologist"
    },
    {
      "code" : "2212.014",
      "display" : "Medical Microbiologist",
      "definition" : "Medical Microbiologist"
    },
    {
      "code" : "2212.015",
      "display" : "Medical Pathologist",
      "definition" : "Medical Pathologist"
    },
    {
      "code" : "2212.016",
      "display" : "Medical Scientist",
      "definition" : "Medical Scientist"
    },
    {
      "code" : "2212.017",
      "display" : "Microbiologist",
      "definition" : "Microbiologist"
    },
    {
      "code" : "2212.018",
      "display" : "Molecular Biochemist",
      "definition" : "Molecular Biochemist"
    },
    {
      "code" : "2212.019",
      "display" : "Molecular Scientist (Medicine)",
      "definition" : "Molecular Scientist (Medicine)"
    },
    {
      "code" : "2212.020",
      "display" : "Parasitologist",
      "definition" : "Parasitologist"
    },
    {
      "code" : "2212.021",
      "display" : "Pharmacologist",
      "definition" : "Pharmacologist"
    },
    {
      "code" : "2212.022",
      "display" : "Physiologist",
      "definition" : "Physiologist"
    },
    {
      "code" : "2212.023",
      "display" : "Public Health Scientist",
      "definition" : "Public Health Scientist"
    },
    {
      "code" : "2212.024",
      "display" : "Research Biochemist",
      "definition" : "Research Biochemist"
    },
    {
      "code" : "2212.025",
      "display" : "Respiratory Physiologist",
      "definition" : "Respiratory Physiologist"
    },
    {
      "code" : "2212.026",
      "display" : "Toxicologist",
      "definition" : "Toxicologist"
    },
    {
      "code" : "2212.027",
      "display" : "Virologist",
      "definition" : "Virologist"
    },
    {
      "code" : "2213.001",
      "display" : "Agricultural Advisor",
      "definition" : "Agricultural Advisor"
    },
    {
      "code" : "2213.002",
      "display" : "Agricultural Consultant",
      "definition" : "Agricultural Consultant"
    },
    {
      "code" : "2213.003",
      "display" : "Agricultural Economic Advisor",
      "definition" : "Agricultural Economic Advisor"
    },
    {
      "code" : "2213.004",
      "display" : "Animal Husbandry Advisor",
      "definition" : "Animal Husbandry Advisor"
    },
    {
      "code" : "2213.005",
      "display" : "Apiculture Advisor",
      "definition" : "Apiculture Advisor"
    },
    {
      "code" : "2213.006",
      "display" : "Citrus Farm Advisor",
      "definition" : "Citrus Farm Advisor"
    },
    {
      "code" : "2213.007",
      "display" : "Conservation Officer",
      "definition" : "Conservation Officer"
    },
    {
      "code" : "2213.008",
      "display" : "Dairy Farm Advisor",
      "definition" : "Dairy Farm Advisor"
    },
    {
      "code" : "2213.009",
      "display" : "Farm Advisor",
      "definition" : "Farm Advisor"
    },
    {
      "code" : "2213.010",
      "display" : "Farm Advisory Officer",
      "definition" : "Farm Advisory Officer"
    },
    {
      "code" : "2213.011",
      "display" : "Farm Consultant",
      "definition" : "Farm Consultant"
    },
    {
      "code" : "2213.012",
      "display" : "Farm Drainage Advisor",
      "definition" : "Farm Drainage Advisor"
    },
    {
      "code" : "2213.013",
      "display" : "Farm Economic Techniques Advisor",
      "definition" : "Farm Economic Techniques Advisor"
    },
    {
      "code" : "2213.014",
      "display" : "Floriculture Consultant",
      "definition" : "Floriculture Consultant"
    },
    {
      "code" : "2213.015",
      "display" : "Forest Advisor",
      "definition" : "Forest Advisor"
    },
    {
      "code" : "2213.016",
      "display" : "Forestry Advisor",
      "definition" : "Forestry Advisor"
    },
    {
      "code" : "2213.017",
      "display" : "Forestry Consultant",
      "definition" : "Forestry Consultant"
    },
    {
      "code" : "2213.018",
      "display" : "Forestry Field Officer",
      "definition" : "Forestry Field Officer"
    },
    {
      "code" : "2213.019",
      "display" : "Grain and Crops Advisor",
      "definition" : "Grain and Crops Advisor"
    },
    {
      "code" : "2213.020",
      "display" : "Horticultural Consultant",
      "definition" : "Horticultural Consultant"
    },
    {
      "code" : "2213.021",
      "display" : "Horticultural Field Consultant",
      "definition" : "Horticultural Field Consultant"
    },
    {
      "code" : "2213.022",
      "display" : "Horticulture Advisor",
      "definition" : "Horticulture Advisor"
    },
    {
      "code" : "2213.023",
      "display" : "Orchard Consultant",
      "definition" : "Orchard Consultant"
    },
    {
      "code" : "2213.024",
      "display" : "Pedologist",
      "definition" : "Pedologist"
    },
    {
      "code" : "2213.025",
      "display" : "Scientific Soil Tester",
      "definition" : "Scientific Soil Tester"
    },
    {
      "code" : "2213.026",
      "display" : "Soil Advisor",
      "definition" : "Soil Advisor"
    },
    {
      "code" : "2213.027",
      "display" : "Soil Chemist",
      "definition" : "Soil Chemist"
    },
    {
      "code" : "2213.028",
      "display" : "Soil Conservationist",
      "definition" : "Soil Conservationist"
    },
    {
      "code" : "2213.029",
      "display" : "Soil Ecologist",
      "definition" : "Soil Ecologist"
    },
    {
      "code" : "2213.030",
      "display" : "Soil Fertility Expert",
      "definition" : "Soil Fertility Expert"
    },
    {
      "code" : "2213.031",
      "display" : "Soil Physicist",
      "definition" : "Soil Physicist"
    },
    {
      "code" : "2213.032",
      "display" : "Soil Scientist",
      "definition" : "Soil Scientist"
    },
    {
      "code" : "2213.033",
      "display" : "Vegetable Consultant",
      "definition" : "Vegetable Consultant"
    },
    {
      "code" : "2221.001",
      "display" : "Anaesthesiologist",
      "definition" : "Anaesthesiologist"
    },
    {
      "code" : "2221.002",
      "display" : "Anaesthetist",
      "definition" : "Anaesthetist"
    },
    {
      "code" : "2221.003",
      "display" : "Cancer Specialist",
      "definition" : "Cancer Specialist"
    },
    {
      "code" : "2221.004",
      "display" : "Cardiologist",
      "definition" : "Cardiologist"
    },
    {
      "code" : "2221.005",
      "display" : "Cardiothoracic Surgeon",
      "definition" : "Cardiothoracic Surgeon"
    },
    {
      "code" : "2221.006",
      "display" : "Child Birth Specialist",
      "definition" : "Child Birth Specialist"
    },
    {
      "code" : "2221.007",
      "display" : "Clinical Oncologist",
      "definition" : "Clinical Oncologist"
    },
    {
      "code" : "2221.008",
      "display" : "Dermatologist",
      "definition" : "Dermatologist"
    },
    {
      "code" : "2221.009",
      "display" : "Diagnostic Radiologist",
      "definition" : "Diagnostic Radiologist"
    },
    {
      "code" : "2221.010",
      "display" : "Doctor General Practice",
      "definition" : "Doctor General Practice"
    },
    {
      "code" : "2221.011",
      "display" : "Doctor Specialised Practice",
      "definition" : "Doctor Specialised Practice"
    },
    {
      "code" : "2221.012",
      "display" : "Family Doctor",
      "definition" : "Family Doctor"
    },
    {
      "code" : "2221.013",
      "display" : "General Practitioner",
      "definition" : "General Practitioner"
    },
    {
      "code" : "2221.014",
      "display" : "General Surgeon",
      "definition" : "General Surgeon"
    },
    {
      "code" : "2221.015",
      "display" : "GP",
      "definition" : "GP"
    },
    {
      "code" : "2221.016",
      "display" : "Gynaecologist",
      "definition" : "Gynaecologist"
    },
    {
      "code" : "2221.017",
      "display" : "Hospital Doctor",
      "definition" : "Hospital Doctor"
    },
    {
      "code" : "2221.018",
      "display" : "Hospital Registrar",
      "definition" : "Hospital Registrar"
    },
    {
      "code" : "2221.019",
      "display" : "House Doctor",
      "definition" : "House Doctor"
    },
    {
      "code" : "2221.020",
      "display" : "House Surgeon",
      "definition" : "House Surgeon"
    },
    {
      "code" : "2221.021",
      "display" : "Infant Care Medical Specialist",
      "definition" : "Infant Care Medical Specialist"
    },
    {
      "code" : "2221.022",
      "display" : "Intensive Care Surgeon",
      "definition" : "Intensive Care Surgeon"
    },
    {
      "code" : "2221.023",
      "display" : "Medical Intern",
      "definition" : "Medical Intern"
    },
    {
      "code" : "2221.024",
      "display" : "Medical Officer",
      "definition" : "Medical Officer"
    },
    {
      "code" : "2221.025",
      "display" : "Medical Practitioner",
      "definition" : "Medical Practitioner"
    },
    {
      "code" : "2221.026",
      "display" : "Medical Sedation Specialist",
      "definition" : "Medical Sedation Specialist"
    },
    {
      "code" : "2221.027",
      "display" : "Medical Specialist",
      "definition" : "Medical Specialist"
    },
    {
      "code" : "2221.028",
      "display" : "Nephrologist",
      "definition" : "Nephrologist"
    },
    {
      "code" : "2221.029",
      "display" : "Neurologist",
      "definition" : "Neurologist"
    },
    {
      "code" : "2221.030",
      "display" : "Neurosurgeon",
      "definition" : "Neurosurgeon"
    },
    {
      "code" : "2221.031",
      "display" : "Obstetrician",
      "definition" : "Obstetrician"
    },
    {
      "code" : "2221.032",
      "display" : "Oncologist",
      "definition" : "Oncologist"
    },
    {
      "code" : "2221.033",
      "display" : "Ophthalmologist",
      "definition" : "Ophthalmologist"
    },
    {
      "code" : "2221.034",
      "display" : "Orthopaedic Surgeon",
      "definition" : "Orthopaedic Surgeon"
    },
    {
      "code" : "2221.035",
      "display" : "Otolaryngologist",
      "definition" : "Otolaryngologist"
    },
    {
      "code" : "2221.036",
      "display" : "Paediatrician",
      "definition" : "Paediatrician"
    },
    {
      "code" : "2221.037",
      "display" : "Pathologist",
      "definition" : "Pathologist"
    },
    {
      "code" : "2221.038",
      "display" : "Physician",
      "definition" : "Physician"
    },
    {
      "code" : "2221.039",
      "display" : "Plastic Surgeon",
      "definition" : "Plastic Surgeon"
    },
    {
      "code" : "2221.040",
      "display" : "Psychiatrist",
      "definition" : "Psychiatrist"
    },
    {
      "code" : "2221.041",
      "display" : "Psychogeriatrician",
      "definition" : "Psychogeriatrician"
    },
    {
      "code" : "2221.042",
      "display" : "Radiation Oncologist",
      "definition" : "Radiation Oncologist"
    },
    {
      "code" : "2221.043",
      "display" : "Radiologist",
      "definition" : "Radiologist"
    },
    {
      "code" : "2221.044",
      "display" : "Radiotherapist",
      "definition" : "Radiotherapist"
    },
    {
      "code" : "2221.045",
      "display" : "Resident Medical Officer",
      "definition" : "Resident Medical Officer"
    },
    {
      "code" : "2221.046",
      "display" : "School Doctor",
      "definition" : "School Doctor"
    },
    {
      "code" : "2221.047",
      "display" : "Sports Medicine Practitioner",
      "definition" : "Sports Medicine Practitioner"
    },
    {
      "code" : "2221.048",
      "display" : "Surgeon",
      "definition" : "Surgeon"
    },
    {
      "code" : "2221.049",
      "display" : "Urologist",
      "definition" : "Urologist"
    },
    {
      "code" : "2221.050",
      "display" : "Venereologist",
      "definition" : "Venereologist"
    },
    {
      "code" : "2222.001",
      "display" : "Dental Surgeon",
      "definition" : "Dental Surgeon"
    },
    {
      "code" : "2222.002",
      "display" : "Dentist",
      "definition" : "Dentist"
    },
    {
      "code" : "2222.003",
      "display" : "Oral Surgeon",
      "definition" : "Oral Surgeon"
    },
    {
      "code" : "2222.004",
      "display" : "Orthodontist",
      "definition" : "Orthodontist"
    },
    {
      "code" : "2222.005",
      "display" : "Paedodontist",
      "definition" : "Paedodontist"
    },
    {
      "code" : "2222.006",
      "display" : "Periodontist",
      "definition" : "Periodontist"
    },
    {
      "code" : "2222.007",
      "display" : "Prosthodontist",
      "definition" : "Prosthodontist"
    },
    {
      "code" : "2223.001",
      "display" : "Animal Doctor",
      "definition" : "Animal Doctor"
    },
    {
      "code" : "2223.002",
      "display" : "Meat Veterinarian",
      "definition" : "Meat Veterinarian"
    },
    {
      "code" : "2223.003",
      "display" : "Public Health Veterinarian",
      "definition" : "Public Health Veterinarian"
    },
    {
      "code" : "2223.004",
      "display" : "Veterinarian",
      "definition" : "Veterinarian"
    },
    {
      "code" : "2223.005",
      "display" : "Veterinary Diagnostic Officer",
      "definition" : "Veterinary Diagnostic Officer"
    },
    {
      "code" : "2223.006",
      "display" : "Veterinary Officer Agriculture",
      "definition" : "Veterinary Officer Agriculture"
    },
    {
      "code" : "2223.007",
      "display" : "Veterinary Pathologist",
      "definition" : "Veterinary Pathologist"
    },
    {
      "code" : "2223.008",
      "display" : "Veterinary Surgeon",
      "definition" : "Veterinary Surgeon"
    },
    {
      "code" : "2224.001",
      "display" : "Community Pharmacist",
      "definition" : "Community Pharmacist"
    },
    {
      "code" : "2224.002",
      "display" : "Health Service Pharmacist",
      "definition" : "Health Service Pharmacist"
    },
    {
      "code" : "2224.003",
      "display" : "Hospital Chemist",
      "definition" : "Hospital Chemist"
    },
    {
      "code" : "2224.004",
      "display" : "Hospital Dispensing Chemist",
      "definition" : "Hospital Dispensing Chemist"
    },
    {
      "code" : "2224.005",
      "display" : "Hospital Pharmacist",
      "definition" : "Hospital Pharmacist"
    },
    {
      "code" : "2224.006",
      "display" : "Retail Chemist",
      "definition" : "Retail Chemist"
    },
    {
      "code" : "2224.007",
      "display" : "Retail Dispensing Chemist",
      "definition" : "Retail Dispensing Chemist"
    },
    {
      "code" : "2224.008",
      "display" : "Retail Pharmacist",
      "definition" : "Retail Pharmacist"
    },
    {
      "code" : "2225.001",
      "display" : "Clinical Dietitian",
      "definition" : "Clinical Dietitian"
    },
    {
      "code" : "2225.002",
      "display" : "Community Dietitian",
      "definition" : "Community Dietitian"
    },
    {
      "code" : "2225.003",
      "display" : "Dietician",
      "definition" : "Dietician"
    },
    {
      "code" : "2225.004",
      "display" : "Dietitian",
      "definition" : "Dietitian"
    },
    {
      "code" : "2225.005",
      "display" : "Hospital Dietician",
      "definition" : "Hospital Dietician"
    },
    {
      "code" : "2225.006",
      "display" : "Hospital Dietitian",
      "definition" : "Hospital Dietitian"
    },
    {
      "code" : "2225.007",
      "display" : "Public Health Dietitian",
      "definition" : "Public Health Dietitian"
    },
    {
      "code" : "2225.008",
      "display" : "Public Health Nutritionist",
      "definition" : "Public Health Nutritionist"
    },
    {
      "code" : "2226.001",
      "display" : "Oculist",
      "definition" : "Oculist"
    },
    {
      "code" : "2226.002",
      "display" : "Opthalmic Optician",
      "definition" : "Opthalmic Optician"
    },
    {
      "code" : "2226.003",
      "display" : "Optometrist",
      "definition" : "Optometrist"
    },
    {
      "code" : "2226.004",
      "display" : "Orthoptist Squint Correction",
      "definition" : "Orthoptist Squint Correction"
    },
    {
      "code" : "2231.001",
      "display" : "Baby Health Nurse",
      "definition" : "Baby Health Nurse"
    },
    {
      "code" : "2231.002",
      "display" : "Charge Nurse",
      "definition" : "Charge Nurse"
    },
    {
      "code" : "2231.003",
      "display" : "Child Care Nurse",
      "definition" : "Child Care Nurse"
    },
    {
      "code" : "2231.004",
      "display" : "Child Health Nurse",
      "definition" : "Child Health Nurse"
    },
    {
      "code" : "2231.005",
      "display" : "Community Child and Family Nurse",
      "definition" : "Community Child and Family Nurse"
    },
    {
      "code" : "2231.006",
      "display" : "District Nurse",
      "definition" : "District Nurse"
    },
    {
      "code" : "2231.007",
      "display" : "Factory Nurse",
      "definition" : "Factory Nurse"
    },
    {
      "code" : "2231.008",
      "display" : "General Nurse",
      "definition" : "General Nurse"
    },
    {
      "code" : "2231.009",
      "display" : "General Registered Nurse",
      "definition" : "General Registered Nurse"
    },
    {
      "code" : "2231.010",
      "display" : "Hospital Matron",
      "definition" : "Hospital Matron"
    },
    {
      "code" : "2231.011",
      "display" : "Hospital Nurse",
      "definition" : "Hospital Nurse"
    },
    {
      "code" : "2231.012",
      "display" : "Industrial Nurse",
      "definition" : "Industrial Nurse"
    },
    {
      "code" : "2231.013",
      "display" : "Kumau Mahi Whaanui",
      "definition" : "Kumau Mahi Whaanui"
    },
    {
      "code" : "2231.014",
      "display" : "Kumau Mahi Whanui",
      "definition" : "Kumau Mahi Whanui"
    },
    {
      "code" : "2231.015",
      "display" : "Maternity Nurse",
      "definition" : "Maternity Nurse"
    },
    {
      "code" : "2231.016",
      "display" : "Mental Health Nurse",
      "definition" : "Mental Health Nurse"
    },
    {
      "code" : "2231.017",
      "display" : "Mid Wife",
      "definition" : "Mid Wife"
    },
    {
      "code" : "2231.018",
      "display" : "Midwife",
      "definition" : "Midwife"
    },
    {
      "code" : "2231.019",
      "display" : "Naahi Kua Reehitatia",
      "definition" : "Naahi Kua Reehitatia"
    },
    {
      "code" : "2231.020",
      "display" : "Naahi Mahi Whaanui",
      "definition" : "Naahi Mahi Whaanui"
    },
    {
      "code" : "2231.021",
      "display" : "Nahi Kua Rehitatia",
      "definition" : "Nahi Kua Rehitatia"
    },
    {
      "code" : "2231.022",
      "display" : "Nahi Mahi Whanui",
      "definition" : "Nahi Mahi Whanui"
    },
    {
      "code" : "2231.023",
      "display" : "Neehi Kua Reehitatia",
      "definition" : "Neehi Kua Reehitatia"
    },
    {
      "code" : "2231.024",
      "display" : "Neehi Mahi Whaanui",
      "definition" : "Neehi Mahi Whaanui"
    },
    {
      "code" : "2231.025",
      "display" : "Nehi Kua Rehitatia",
      "definition" : "Nehi Kua Rehitatia"
    },
    {
      "code" : "2231.026",
      "display" : "Nehi Mahi Whanui",
      "definition" : "Nehi Mahi Whanui"
    },
    {
      "code" : "2231.027",
      "display" : "Nurse Inspector",
      "definition" : "Nurse Inspector"
    },
    {
      "code" : "2231.028",
      "display" : "Nursing Sister",
      "definition" : "Nursing Sister"
    },
    {
      "code" : "2231.029",
      "display" : "Occupational Health Nurse",
      "definition" : "Occupational Health Nurse"
    },
    {
      "code" : "2231.030",
      "display" : "Operating Theatre Nurse",
      "definition" : "Operating Theatre Nurse"
    },
    {
      "code" : "2231.031",
      "display" : "Other Midwifery Personnel",
      "definition" : "Other Midwifery Personnel"
    },
    {
      "code" : "2231.032",
      "display" : "Plunket Nurse",
      "definition" : "Plunket Nurse"
    },
    {
      "code" : "2231.033",
      "display" : "Practice Nurse",
      "definition" : "Practice Nurse"
    },
    {
      "code" : "2231.034",
      "display" : "Principal Nurse",
      "definition" : "Principal Nurse"
    },
    {
      "code" : "2231.035",
      "display" : "Principal Nurse - Rest Home",
      "definition" : "Principal Nurse - Rest Home"
    },
    {
      "code" : "2231.036",
      "display" : "Professional Midwife",
      "definition" : "Professional Midwife"
    },
    {
      "code" : "2231.037",
      "display" : "Psychiatric Nurse",
      "definition" : "Psychiatric Nurse"
    },
    {
      "code" : "2231.038",
      "display" : "Psychopaedic Nurse",
      "definition" : "Psychopaedic Nurse"
    },
    {
      "code" : "2231.039",
      "display" : "Public Health Education Nurse",
      "definition" : "Public Health Education Nurse"
    },
    {
      "code" : "2231.040",
      "display" : "Public Health Nurse",
      "definition" : "Public Health Nurse"
    },
    {
      "code" : "2231.041",
      "display" : "Public Health Registered Nurse",
      "definition" : "Public Health Registered Nurse"
    },
    {
      "code" : "2231.042",
      "display" : "Registered Geriatric Nurse",
      "definition" : "Registered Geriatric Nurse"
    },
    {
      "code" : "2231.043",
      "display" : "Registered Hospital Nurse",
      "definition" : "Registered Hospital Nurse"
    },
    {
      "code" : "2231.044",
      "display" : "Registered Mental Nurse",
      "definition" : "Registered Mental Nurse"
    },
    {
      "code" : "2231.045",
      "display" : "Registered Midwife",
      "definition" : "Registered Midwife"
    },
    {
      "code" : "2231.046",
      "display" : "Registered Nurse",
      "definition" : "Registered Nurse"
    },
    {
      "code" : "2231.047",
      "display" : "Registered Practice Nurse",
      "definition" : "Registered Practice Nurse"
    },
    {
      "code" : "2231.048",
      "display" : "Registered Psychopaedic Nurse",
      "definition" : "Registered Psychopaedic Nurse"
    },
    {
      "code" : "2231.049",
      "display" : "School Health Nurse",
      "definition" : "School Health Nurse"
    },
    {
      "code" : "2231.050",
      "display" : "School Nurse",
      "definition" : "School Nurse"
    },
    {
      "code" : "2231.051",
      "display" : "Staff Nurse",
      "definition" : "Staff Nurse"
    },
    {
      "code" : "2231.052",
      "display" : "Tapuhi Kua Reehitatia",
      "definition" : "Tapuhi Kua Reehitatia"
    },
    {
      "code" : "2231.053",
      "display" : "Tapuhi Kua Rehitatia",
      "definition" : "Tapuhi Kua Rehitatia"
    },
    {
      "code" : "2231.054",
      "display" : "Tapuhi Mahi Whaanui",
      "definition" : "Tapuhi Mahi Whaanui"
    },
    {
      "code" : "2231.055",
      "display" : "Tapuhi Mahi Whanui",
      "definition" : "Tapuhi Mahi Whanui"
    },
    {
      "code" : "2311.001",
      "display" : "College of Education Lecturer",
      "definition" : "College of Education Lecturer"
    },
    {
      "code" : "2311.002",
      "display" : "Higher Education Lecturer",
      "definition" : "Higher Education Lecturer"
    },
    {
      "code" : "2311.003",
      "display" : "Nurse Tutor",
      "definition" : "Nurse Tutor"
    },
    {
      "code" : "2311.004",
      "display" : "Nursing Instructor",
      "definition" : "Nursing Instructor"
    },
    {
      "code" : "2311.005",
      "display" : "Nursing Tutor",
      "definition" : "Nursing Tutor"
    },
    {
      "code" : "2311.006",
      "display" : "Polytech Teacher",
      "definition" : "Polytech Teacher"
    },
    {
      "code" : "2311.007",
      "display" : "Polytechnic Lecturer",
      "definition" : "Polytechnic Lecturer"
    },
    {
      "code" : "2311.008",
      "display" : "Polytechnic Tutor",
      "definition" : "Polytechnic Tutor"
    },
    {
      "code" : "2311.009",
      "display" : "Technology Teacher",
      "definition" : "Technology Teacher"
    },
    {
      "code" : "2311.010",
      "display" : "Tertiary Education Teacher",
      "definition" : "Tertiary Education Teacher"
    },
    {
      "code" : "2311.011",
      "display" : "Tertiary Lecturer",
      "definition" : "Tertiary Lecturer"
    },
    {
      "code" : "2311.012",
      "display" : "Tertiary Teacher",
      "definition" : "Tertiary Teacher"
    },
    {
      "code" : "2311.013",
      "display" : "Training College Tutor",
      "definition" : "Training College Tutor"
    },
    {
      "code" : "2311.014",
      "display" : "Tutor in PTE",
      "definition" : "Tutor in PTE"
    },
    {
      "code" : "2311.015",
      "display" : "University Demonstrator",
      "definition" : "University Demonstrator"
    },
    {
      "code" : "2311.016",
      "display" : "University Lecturer",
      "definition" : "University Lecturer"
    },
    {
      "code" : "2311.017",
      "display" : "University Professor",
      "definition" : "University Professor"
    },
    {
      "code" : "2311.018",
      "display" : "University Reader",
      "definition" : "University Reader"
    },
    {
      "code" : "2311.019",
      "display" : "University Tutor",
      "definition" : "University Tutor"
    },
    {
      "code" : "2321.001",
      "display" : "High School Teacher",
      "definition" : "High School Teacher"
    },
    {
      "code" : "2321.002",
      "display" : "House Tutor Secondary School",
      "definition" : "House Tutor Secondary School"
    },
    {
      "code" : "2321.003",
      "display" : "Housemaster Secondary School",
      "definition" : "Housemaster Secondary School"
    },
    {
      "code" : "2321.004",
      "display" : "Kaiako Kura Tuarua",
      "definition" : "Kaiako Kura Tuarua"
    },
    {
      "code" : "2321.005",
      "display" : "Kaiwhakaako Kura Tuarua",
      "definition" : "Kaiwhakaako Kura Tuarua"
    },
    {
      "code" : "2321.006",
      "display" : "Mahita Kura Tuarua",
      "definition" : "Mahita Kura Tuarua"
    },
    {
      "code" : "2321.007",
      "display" : "Night School Teacher Secondary School",
      "definition" : "Night School Teacher Secondary School"
    },
    {
      "code" : "2321.008",
      "display" : "Secondary Correspondence School Teacher",
      "definition" : "Secondary Correspondence School Teacher"
    },
    {
      "code" : "2321.009",
      "display" : "Secondary School Teacher",
      "definition" : "Secondary School Teacher"
    },
    {
      "code" : "2331.001",
      "display" : "Housemaster Primary School",
      "definition" : "Housemaster Primary School"
    },
    {
      "code" : "2331.002",
      "display" : "Intermediate School Teacher",
      "definition" : "Intermediate School Teacher"
    },
    {
      "code" : "2331.003",
      "display" : "Intermediate Teacher",
      "definition" : "Intermediate Teacher"
    },
    {
      "code" : "2331.004",
      "display" : "Kaiako Kura Tuatahi",
      "definition" : "Kaiako Kura Tuatahi"
    },
    {
      "code" : "2331.005",
      "display" : "Kaiwhakaako Kura Tuatahi",
      "definition" : "Kaiwhakaako Kura Tuatahi"
    },
    {
      "code" : "2331.006",
      "display" : "Mahita Kura Tuatahi",
      "definition" : "Mahita Kura Tuatahi"
    },
    {
      "code" : "2331.007",
      "display" : "Night School Teacher Primary School",
      "definition" : "Night School Teacher Primary School"
    },
    {
      "code" : "2331.008",
      "display" : "Primary Correspondence School Teacher",
      "definition" : "Primary Correspondence School Teacher"
    },
    {
      "code" : "2331.009",
      "display" : "Primary School Teacher",
      "definition" : "Primary School Teacher"
    },
    {
      "code" : "2331.010",
      "display" : "Primary Teacher",
      "definition" : "Primary Teacher"
    },
    {
      "code" : "2332.001",
      "display" : "Bilingual Teacher",
      "definition" : "Bilingual Teacher"
    },
    {
      "code" : "2332.002",
      "display" : "Day Nursery Assistant",
      "definition" : "Day Nursery Assistant"
    },
    {
      "code" : "2332.003",
      "display" : "Early Childhood Teacher",
      "definition" : "Early Childhood Teacher"
    },
    {
      "code" : "2332.004",
      "display" : "Kaiako Kohanga Reo",
      "definition" : "Kaiako Kohanga Reo"
    },
    {
      "code" : "2332.005",
      "display" : "Kaiako Koohanga Reo",
      "definition" : "Kaiako Koohanga Reo"
    },
    {
      "code" : "2332.006",
      "display" : "Kaiako Reo Maaori",
      "definition" : "Kaiako Reo Maaori"
    },
    {
      "code" : "2332.007",
      "display" : "Kaiako TKR",
      "definition" : "Kaiako TKR"
    },
    {
      "code" : "2332.008",
      "display" : "Kaiwhakaako I Te Reo Maori",
      "definition" : "Kaiwhakaako I Te Reo Maori"
    },
    {
      "code" : "2332.009",
      "display" : "Kaiwhakaako Kohanga Reo",
      "definition" : "Kaiwhakaako Kohanga Reo"
    },
    {
      "code" : "2332.010",
      "display" : "Kaiwhakaako Koohanga Reo",
      "definition" : "Kaiwhakaako Koohanga Reo"
    },
    {
      "code" : "2332.011",
      "display" : "Kindergarten Teacher",
      "definition" : "Kindergarten Teacher"
    },
    {
      "code" : "2332.012",
      "display" : "Kohanga Reo Kaiako",
      "definition" : "Kohanga Reo Kaiako"
    },
    {
      "code" : "2332.013",
      "display" : "Kohanga Reo Kaiawhina",
      "definition" : "Kohanga Reo Kaiawhina"
    },
    {
      "code" : "2332.014",
      "display" : "Kohanga Reo Teacher",
      "definition" : "Kohanga Reo Teacher"
    },
    {
      "code" : "2332.015",
      "display" : "Kohanga Reo Worker",
      "definition" : "Kohanga Reo Worker"
    },
    {
      "code" : "2332.016",
      "display" : "Maori Language Nest Teacher",
      "definition" : "Maori Language Nest Teacher"
    },
    {
      "code" : "2332.017",
      "display" : "Montessori Teacher",
      "definition" : "Montessori Teacher"
    },
    {
      "code" : "2332.018",
      "display" : "Other Preprimary Teacher",
      "definition" : "Other Preprimary Teacher"
    },
    {
      "code" : "2332.019",
      "display" : "Play Centre or Playground Supervisor",
      "definition" : "Play Centre or Playground Supervisor"
    },
    {
      "code" : "2332.020",
      "display" : "Play Centre Supervisor",
      "definition" : "Play Centre Supervisor"
    },
    {
      "code" : "2332.021",
      "display" : "Playcentre Supervisor",
      "definition" : "Playcentre Supervisor"
    },
    {
      "code" : "2332.022",
      "display" : "Playground Supervisor",
      "definition" : "Playground Supervisor"
    },
    {
      "code" : "2332.023",
      "display" : "Playschool Teacher",
      "definition" : "Playschool Teacher"
    },
    {
      "code" : "2332.024",
      "display" : "Pre School Teacher",
      "definition" : "Pre School Teacher"
    },
    {
      "code" : "2332.025",
      "display" : "Preschool Coordinator",
      "definition" : "Preschool Coordinator"
    },
    {
      "code" : "2332.026",
      "display" : "Preschool Helper",
      "definition" : "Preschool Helper"
    },
    {
      "code" : "2332.027",
      "display" : "Preschool Supervisor Kindergarten",
      "definition" : "Preschool Supervisor Kindergarten"
    },
    {
      "code" : "2332.028",
      "display" : "Preschool Supervisor Play Centre",
      "definition" : "Preschool Supervisor Play Centre"
    },
    {
      "code" : "2332.029",
      "display" : "Supervisor Creche",
      "definition" : "Supervisor Creche"
    },
    {
      "code" : "2332.030",
      "display" : "Total Immersion Teacher",
      "definition" : "Total Immersion Teacher"
    },
    {
      "code" : "2341.001",
      "display" : "Audio Visual Teaching Specialist",
      "definition" : "Audio Visual Teaching Specialist"
    },
    {
      "code" : "2341.002",
      "display" : "Cerebral Palsy School Teacher",
      "definition" : "Cerebral Palsy School Teacher"
    },
    {
      "code" : "2341.003",
      "display" : "EFL Teacher",
      "definition" : "EFL Teacher"
    },
    {
      "code" : "2341.004",
      "display" : "Elocution Teacher",
      "definition" : "Elocution Teacher"
    },
    {
      "code" : "2341.005",
      "display" : "English Language Teacher",
      "definition" : "English Language Teacher"
    },
    {
      "code" : "2341.006",
      "display" : "ESL Teacher",
      "definition" : "ESL Teacher"
    },
    {
      "code" : "2341.007",
      "display" : "ESOL Teacher",
      "definition" : "ESOL Teacher"
    },
    {
      "code" : "2341.008",
      "display" : "Guidance Learning Teacher",
      "definition" : "Guidance Learning Teacher"
    },
    {
      "code" : "2341.009",
      "display" : "IHC Teacher",
      "definition" : "IHC Teacher"
    },
    {
      "code" : "2341.010",
      "display" : "Inclusive Education Coordinator",
      "definition" : "Inclusive Education Coordinator"
    },
    {
      "code" : "2341.011",
      "display" : "Itinerant Teacher (Special Needs)",
      "definition" : "Itinerant Teacher (Special Needs)"
    },
    {
      "code" : "2341.012",
      "display" : "Language Therapist",
      "definition" : "Language Therapist"
    },
    {
      "code" : "2341.013",
      "display" : "Rehabilitation Teacher",
      "definition" : "Rehabilitation Teacher"
    },
    {
      "code" : "2341.014",
      "display" : "Remedial Teacher",
      "definition" : "Remedial Teacher"
    },
    {
      "code" : "2341.015",
      "display" : "Resource Teacher (Special Needs)",
      "definition" : "Resource Teacher (Special Needs)"
    },
    {
      "code" : "2341.016",
      "display" : "Special Education Remedial Teacher",
      "definition" : "Special Education Remedial Teacher"
    },
    {
      "code" : "2341.017",
      "display" : "Special Education Teacher",
      "definition" : "Special Education Teacher"
    },
    {
      "code" : "2341.018",
      "display" : "Speech Clinician",
      "definition" : "Speech Clinician"
    },
    {
      "code" : "2341.019",
      "display" : "Speech Pathologist",
      "definition" : "Speech Pathologist"
    },
    {
      "code" : "2341.020",
      "display" : "Speech Therapist",
      "definition" : "Speech Therapist"
    },
    {
      "code" : "2341.021",
      "display" : "Speech-Language Therapist",
      "definition" : "Speech-Language Therapist"
    },
    {
      "code" : "2341.022",
      "display" : "Teacher of English as a Second Language",
      "definition" : "Teacher of English as a Second Language"
    },
    {
      "code" : "2341.023",
      "display" : "Teacher of the Blind",
      "definition" : "Teacher of the Blind"
    },
    {
      "code" : "2341.024",
      "display" : "Teacher of the Deaf and Dumb",
      "definition" : "Teacher of the Deaf and Dumb"
    },
    {
      "code" : "2351.001",
      "display" : "Arts and Craft Advisor",
      "definition" : "Arts and Craft Advisor"
    },
    {
      "code" : "2351.002",
      "display" : "Curriculum Facilitator",
      "definition" : "Curriculum Facilitator"
    },
    {
      "code" : "2351.003",
      "display" : "Education Consultant",
      "definition" : "Education Consultant"
    },
    {
      "code" : "2351.004",
      "display" : "Education Methods Specialist",
      "definition" : "Education Methods Specialist"
    },
    {
      "code" : "2351.005",
      "display" : "Educational Advisor",
      "definition" : "Educational Advisor"
    },
    {
      "code" : "2351.006",
      "display" : "Government Education Officer",
      "definition" : "Government Education Officer"
    },
    {
      "code" : "2351.007",
      "display" : "Preschool Advisor",
      "definition" : "Preschool Advisor"
    },
    {
      "code" : "2351.008",
      "display" : "School Advisor",
      "definition" : "School Advisor"
    },
    {
      "code" : "2352.001",
      "display" : "Education Review Officer",
      "definition" : "Education Review Officer"
    },
    {
      "code" : "2352.002",
      "display" : "Education Reviewer",
      "definition" : "Education Reviewer"
    },
    {
      "code" : "2352.003",
      "display" : "School Inspector",
      "definition" : "School Inspector"
    },
    {
      "code" : "2411.001",
      "display" : "Accountant",
      "definition" : "Accountant"
    },
    {
      "code" : "2411.002",
      "display" : "Audit Inspector",
      "definition" : "Audit Inspector"
    },
    {
      "code" : "2411.003",
      "display" : "Auditor",
      "definition" : "Auditor"
    },
    {
      "code" : "2411.004",
      "display" : "Bank Accountant",
      "definition" : "Bank Accountant"
    },
    {
      "code" : "2411.005",
      "display" : "Budgeting Accountant",
      "definition" : "Budgeting Accountant"
    },
    {
      "code" : "2411.006",
      "display" : "Chartered Accountant",
      "definition" : "Chartered Accountant"
    },
    {
      "code" : "2411.007",
      "display" : "Company Accountant",
      "definition" : "Company Accountant"
    },
    {
      "code" : "2411.008",
      "display" : "Cost Accountant",
      "definition" : "Cost Accountant"
    },
    {
      "code" : "2411.009",
      "display" : "Financial Accountant",
      "definition" : "Financial Accountant"
    },
    {
      "code" : "2411.010",
      "display" : "GST Auditor",
      "definition" : "GST Auditor"
    },
    {
      "code" : "2411.011",
      "display" : "Internal Auditor",
      "definition" : "Internal Auditor"
    },
    {
      "code" : "2411.012",
      "display" : "Investigating Accountant",
      "definition" : "Investigating Accountant"
    },
    {
      "code" : "2411.013",
      "display" : "Kaikaute",
      "definition" : "Kaikaute"
    },
    {
      "code" : "2411.014",
      "display" : "Kaiwhakahaere Kaute",
      "definition" : "Kaiwhakahaere Kaute"
    },
    {
      "code" : "2411.015",
      "display" : "Kaiwhakahaere Putea",
      "definition" : "Kaiwhakahaere Putea"
    },
    {
      "code" : "2411.016",
      "display" : "Kaiwhakahaere Puutea",
      "definition" : "Kaiwhakahaere Puutea"
    },
    {
      "code" : "2411.017",
      "display" : "Legal Accountant",
      "definition" : "Legal Accountant"
    },
    {
      "code" : "2411.018",
      "display" : "Management Accountant",
      "definition" : "Management Accountant"
    },
    {
      "code" : "2411.019",
      "display" : "Production Accountant",
      "definition" : "Production Accountant"
    },
    {
      "code" : "2411.020",
      "display" : "Production Management Accountant",
      "definition" : "Production Management Accountant"
    },
    {
      "code" : "2411.021",
      "display" : "Public Accountant",
      "definition" : "Public Accountant"
    },
    {
      "code" : "2411.022",
      "display" : "System Cost Accountant",
      "definition" : "System Cost Accountant"
    },
    {
      "code" : "2411.023",
      "display" : "Tax Accountant",
      "definition" : "Tax Accountant"
    },
    {
      "code" : "2411.024",
      "display" : "Taxation Consultant Economic",
      "definition" : "Taxation Consultant Economic"
    },
    {
      "code" : "2411.025",
      "display" : "Trainee Accountant",
      "definition" : "Trainee Accountant"
    },
    {
      "code" : "2412.001",
      "display" : "Consultant Trainer",
      "definition" : "Consultant Trainer"
    },
    {
      "code" : "2412.002",
      "display" : "EEO Advisor",
      "definition" : "EEO Advisor"
    },
    {
      "code" : "2412.003",
      "display" : "EEO Officer",
      "definition" : "EEO Officer"
    },
    {
      "code" : "2412.004",
      "display" : "EEO Practitioner",
      "definition" : "EEO Practitioner"
    },
    {
      "code" : "2412.005",
      "display" : "Employment Officer",
      "definition" : "Employment Officer"
    },
    {
      "code" : "2412.006",
      "display" : "Human Resources Advisor",
      "definition" : "Human Resources Advisor"
    },
    {
      "code" : "2412.007",
      "display" : "Human Resources Consultant",
      "definition" : "Human Resources Consultant"
    },
    {
      "code" : "2412.008",
      "display" : "Human Resources Officer",
      "definition" : "Human Resources Officer"
    },
    {
      "code" : "2412.009",
      "display" : "Industrial Education Officer",
      "definition" : "Industrial Education Officer"
    },
    {
      "code" : "2412.010",
      "display" : "Industrial Personnel Officer",
      "definition" : "Industrial Personnel Officer"
    },
    {
      "code" : "2412.011",
      "display" : "Industrial Relations Advisor",
      "definition" : "Industrial Relations Advisor"
    },
    {
      "code" : "2412.012",
      "display" : "Industrial Relations Consultant",
      "definition" : "Industrial Relations Consultant"
    },
    {
      "code" : "2412.013",
      "display" : "Industrial Relations Officer",
      "definition" : "Industrial Relations Officer"
    },
    {
      "code" : "2412.014",
      "display" : "Industrial Training Officer",
      "definition" : "Industrial Training Officer"
    },
    {
      "code" : "2412.015",
      "display" : "Liaison Officer",
      "definition" : "Liaison Officer"
    },
    {
      "code" : "2412.016",
      "display" : "Personnel Consultant",
      "definition" : "Personnel Consultant"
    },
    {
      "code" : "2412.017",
      "display" : "Personnel Officer",
      "definition" : "Personnel Officer"
    },
    {
      "code" : "2412.018",
      "display" : "Recruiting Officer",
      "definition" : "Recruiting Officer"
    },
    {
      "code" : "2412.019",
      "display" : "Staff Appointment Officer",
      "definition" : "Staff Appointment Officer"
    },
    {
      "code" : "2412.020",
      "display" : "Staff Development and Training Officer",
      "definition" : "Staff Development and Training Officer"
    },
    {
      "code" : "2412.021",
      "display" : "Staff Development Officer",
      "definition" : "Staff Development Officer"
    },
    {
      "code" : "2412.022",
      "display" : "Staff Officer",
      "definition" : "Staff Officer"
    },
    {
      "code" : "2412.023",
      "display" : "Staff Training Officer",
      "definition" : "Staff Training Officer"
    },
    {
      "code" : "2412.024",
      "display" : "Training and Development Officer",
      "definition" : "Training and Development Officer"
    },
    {
      "code" : "2412.025",
      "display" : "Training Consultant",
      "definition" : "Training Consultant"
    },
    {
      "code" : "2412.026",
      "display" : "Training Officer",
      "definition" : "Training Officer"
    },
    {
      "code" : "2413.001",
      "display" : "Business Analyst",
      "definition" : "Business Analyst"
    },
    {
      "code" : "2413.002",
      "display" : "Business Consultant",
      "definition" : "Business Consultant"
    },
    {
      "code" : "2413.003",
      "display" : "Business Forecaster",
      "definition" : "Business Forecaster"
    },
    {
      "code" : "2413.004",
      "display" : "Communications Advisor",
      "definition" : "Communications Advisor"
    },
    {
      "code" : "2413.005",
      "display" : "Communications Officer",
      "definition" : "Communications Officer"
    },
    {
      "code" : "2413.006",
      "display" : "Farm Management Consultant",
      "definition" : "Farm Management Consultant"
    },
    {
      "code" : "2413.007",
      "display" : "Finance Consultant",
      "definition" : "Finance Consultant"
    },
    {
      "code" : "2413.008",
      "display" : "Financial Advisor",
      "definition" : "Financial Advisor"
    },
    {
      "code" : "2413.009",
      "display" : "Financial Advisor Broker",
      "definition" : "Financial Advisor Broker"
    },
    {
      "code" : "2413.010",
      "display" : "Financial Analyst",
      "definition" : "Financial Analyst"
    },
    {
      "code" : "2413.011",
      "display" : "Financial Consultant",
      "definition" : "Financial Consultant"
    },
    {
      "code" : "2413.012",
      "display" : "Financial Planner",
      "definition" : "Financial Planner"
    },
    {
      "code" : "2413.013",
      "display" : "Fund Raiser",
      "definition" : "Fund Raiser"
    },
    {
      "code" : "2413.014",
      "display" : "Fundraiser",
      "definition" : "Fundraiser"
    },
    {
      "code" : "2413.015",
      "display" : "Immigration Consultant",
      "definition" : "Immigration Consultant"
    },
    {
      "code" : "2413.016",
      "display" : "Investment Advisor",
      "definition" : "Investment Advisor"
    },
    {
      "code" : "2413.017",
      "display" : "Investment Consultant",
      "definition" : "Investment Consultant"
    },
    {
      "code" : "2413.018",
      "display" : "Management Consultant",
      "definition" : "Management Consultant"
    },
    {
      "code" : "2413.019",
      "display" : "Market Analyst",
      "definition" : "Market Analyst"
    },
    {
      "code" : "2413.020",
      "display" : "Market Research Analyst",
      "definition" : "Market Research Analyst"
    },
    {
      "code" : "2413.021",
      "display" : "Market Research Project Leader",
      "definition" : "Market Research Project Leader"
    },
    {
      "code" : "2413.022",
      "display" : "Market Research Project Manager",
      "definition" : "Market Research Project Manager"
    },
    {
      "code" : "2413.023",
      "display" : "Market Researcher",
      "definition" : "Market Researcher"
    },
    {
      "code" : "2413.024",
      "display" : "Market Trends Consultant",
      "definition" : "Market Trends Consultant"
    },
    {
      "code" : "2413.025",
      "display" : "Marketing Officer",
      "definition" : "Marketing Officer"
    },
    {
      "code" : "2413.026",
      "display" : "Media Advisor",
      "definition" : "Media Advisor"
    },
    {
      "code" : "2413.027",
      "display" : "Press Officer",
      "definition" : "Press Officer"
    },
    {
      "code" : "2413.028",
      "display" : "Press Secretary",
      "definition" : "Press Secretary"
    },
    {
      "code" : "2413.029",
      "display" : "Public Affairs Officer",
      "definition" : "Public Affairs Officer"
    },
    {
      "code" : "2413.030",
      "display" : "Public Relations Officer",
      "definition" : "Public Relations Officer"
    },
    {
      "code" : "2413.031",
      "display" : "Publicity and Public Relations Officer",
      "definition" : "Publicity and Public Relations Officer"
    },
    {
      "code" : "2413.032",
      "display" : "Publicity Officer",
      "definition" : "Publicity Officer"
    },
    {
      "code" : "2413.033",
      "display" : "Taxation Consultant Accounting",
      "definition" : "Taxation Consultant Accounting"
    },
    {
      "code" : "2421.001",
      "display" : "Attorney",
      "definition" : "Attorney"
    },
    {
      "code" : "2421.002",
      "display" : "Barrister",
      "definition" : "Barrister"
    },
    {
      "code" : "2421.003",
      "display" : "Civil Lawyer",
      "definition" : "Civil Lawyer"
    },
    {
      "code" : "2421.004",
      "display" : "Commercial Corporate Solicitor",
      "definition" : "Commercial Corporate Solicitor"
    },
    {
      "code" : "2421.005",
      "display" : "Conveyancing Lawyer",
      "definition" : "Conveyancing Lawyer"
    },
    {
      "code" : "2421.006",
      "display" : "Criminal Lawyer",
      "definition" : "Criminal Lawyer"
    },
    {
      "code" : "2421.007",
      "display" : "Lawyer",
      "definition" : "Lawyer"
    },
    {
      "code" : "2421.008",
      "display" : "Legal Advisor",
      "definition" : "Legal Advisor"
    },
    {
      "code" : "2421.009",
      "display" : "Legal Advocate",
      "definition" : "Legal Advocate"
    },
    {
      "code" : "2421.010",
      "display" : "Notary",
      "definition" : "Notary"
    },
    {
      "code" : "2421.011",
      "display" : "Solicitor",
      "definition" : "Solicitor"
    },
    {
      "code" : "2421.012",
      "display" : "Trade Union Industrial Advocate",
      "definition" : "Trade Union Industrial Advocate"
    },
    {
      "code" : "2422.001",
      "display" : "Chief Justice",
      "definition" : "Chief Justice"
    },
    {
      "code" : "2422.002",
      "display" : "Court of Appeal Judge",
      "definition" : "Court of Appeal Judge"
    },
    {
      "code" : "2422.003",
      "display" : "District Court Judge",
      "definition" : "District Court Judge"
    },
    {
      "code" : "2422.004",
      "display" : "Employment Court Judge",
      "definition" : "Employment Court Judge"
    },
    {
      "code" : "2422.005",
      "display" : "Family Court Judge",
      "definition" : "Family Court Judge"
    },
    {
      "code" : "2422.006",
      "display" : "High Court Judge",
      "definition" : "High Court Judge"
    },
    {
      "code" : "2422.007",
      "display" : "Judge",
      "definition" : "Judge"
    },
    {
      "code" : "2422.008",
      "display" : "Maori Land Court Judge",
      "definition" : "Maori Land Court Judge"
    },
    {
      "code" : "2422.009",
      "display" : "Referee Small Claims",
      "definition" : "Referee Small Claims"
    },
    {
      "code" : "2422.010",
      "display" : "Tribunal Judge",
      "definition" : "Tribunal Judge"
    },
    {
      "code" : "2423.001",
      "display" : "Arbitrator",
      "definition" : "Arbitrator"
    },
    {
      "code" : "2423.002",
      "display" : "Coroner",
      "definition" : "Coroner"
    },
    {
      "code" : "2423.003",
      "display" : "Examiner Trade Marks",
      "definition" : "Examiner Trade Marks"
    },
    {
      "code" : "2423.004",
      "display" : "Facilitator",
      "definition" : "Facilitator"
    },
    {
      "code" : "2423.005",
      "display" : "Industrial Conciliator",
      "definition" : "Industrial Conciliator"
    },
    {
      "code" : "2423.006",
      "display" : "Jurist",
      "definition" : "Jurist"
    },
    {
      "code" : "2423.007",
      "display" : "Land Registrar",
      "definition" : "Land Registrar"
    },
    {
      "code" : "2423.008",
      "display" : "Mediator",
      "definition" : "Mediator"
    },
    {
      "code" : "2423.009",
      "display" : "Negotiator",
      "definition" : "Negotiator"
    },
    {
      "code" : "2423.010",
      "display" : "Official Assignee",
      "definition" : "Official Assignee"
    },
    {
      "code" : "2423.011",
      "display" : "Other Legal Professional",
      "definition" : "Other Legal Professional"
    },
    {
      "code" : "2423.012",
      "display" : "Parliamentary Draughtsman",
      "definition" : "Parliamentary Draughtsman"
    },
    {
      "code" : "2423.013",
      "display" : "Patent Attorney",
      "definition" : "Patent Attorney"
    },
    {
      "code" : "2423.014",
      "display" : "Patent Examiner",
      "definition" : "Patent Examiner"
    },
    {
      "code" : "2423.015",
      "display" : "Race Relations Concilliator",
      "definition" : "Race Relations Concilliator"
    },
    {
      "code" : "2423.016",
      "display" : "Registrar of Courts",
      "definition" : "Registrar of Courts"
    },
    {
      "code" : "2423.017",
      "display" : "Tenancy Mediator",
      "definition" : "Tenancy Mediator"
    },
    {
      "code" : "2423.018",
      "display" : "Trade Marks Examiner Justice",
      "definition" : "Trade Marks Examiner Justice"
    },
    {
      "code" : "2423.019",
      "display" : "University Proctor",
      "definition" : "University Proctor"
    },
    {
      "code" : "2431.001",
      "display" : "Archivist",
      "definition" : "Archivist"
    },
    {
      "code" : "2431.002",
      "display" : "Art Conservator",
      "definition" : "Art Conservator"
    },
    {
      "code" : "2431.003",
      "display" : "Art Gallery and Museum Curator",
      "definition" : "Art Gallery and Museum Curator"
    },
    {
      "code" : "2431.004",
      "display" : "Art Gallery Conservator",
      "definition" : "Art Gallery Conservator"
    },
    {
      "code" : "2431.005",
      "display" : "Curator",
      "definition" : "Curator"
    },
    {
      "code" : "2431.006",
      "display" : "Curator Art Gallery",
      "definition" : "Curator Art Gallery"
    },
    {
      "code" : "2431.007",
      "display" : "Curator Museum",
      "definition" : "Curator Museum"
    },
    {
      "code" : "2431.008",
      "display" : "Document Conservator",
      "definition" : "Document Conservator"
    },
    {
      "code" : "2431.009",
      "display" : "Document Restorer",
      "definition" : "Document Restorer"
    },
    {
      "code" : "2431.010",
      "display" : "Film Archivist",
      "definition" : "Film Archivist"
    },
    {
      "code" : "2431.011",
      "display" : "Information Archivist",
      "definition" : "Information Archivist"
    },
    {
      "code" : "2431.012",
      "display" : "Museum Conservator",
      "definition" : "Museum Conservator"
    },
    {
      "code" : "2431.013",
      "display" : "Museum Education Officer",
      "definition" : "Museum Education Officer"
    },
    {
      "code" : "2431.014",
      "display" : "Photographic Archivist",
      "definition" : "Photographic Archivist"
    },
    {
      "code" : "2431.015",
      "display" : "Reference Archivist",
      "definition" : "Reference Archivist"
    },
    {
      "code" : "2432.001",
      "display" : "Childrens Librarian",
      "definition" : "Childrens Librarian"
    },
    {
      "code" : "2432.002",
      "display" : "Information Services Administrator",
      "definition" : "Information Services Administrator"
    },
    {
      "code" : "2432.003",
      "display" : "Librarian",
      "definition" : "Librarian"
    },
    {
      "code" : "2432.004",
      "display" : "Mobile Librarian",
      "definition" : "Mobile Librarian"
    },
    {
      "code" : "2432.005",
      "display" : "Reference Librarian",
      "definition" : "Reference Librarian"
    },
    {
      "code" : "2441.001",
      "display" : "Development Finance Project Analyst",
      "definition" : "Development Finance Project Analyst"
    },
    {
      "code" : "2441.002",
      "display" : "Economic Forecaster",
      "definition" : "Economic Forecaster"
    },
    {
      "code" : "2441.003",
      "display" : "Economist",
      "definition" : "Economist"
    },
    {
      "code" : "2441.004",
      "display" : "Financial Analyst Broker",
      "definition" : "Financial Analyst Broker"
    },
    {
      "code" : "2441.005",
      "display" : "Research Economist",
      "definition" : "Research Economist"
    },
    {
      "code" : "2442.001",
      "display" : "Anthropologist",
      "definition" : "Anthropologist"
    },
    {
      "code" : "2442.002",
      "display" : "Archaeologist",
      "definition" : "Archaeologist"
    },
    {
      "code" : "2442.003",
      "display" : "Criminologist",
      "definition" : "Criminologist"
    },
    {
      "code" : "2442.004",
      "display" : "Demographer",
      "definition" : "Demographer"
    },
    {
      "code" : "2442.005",
      "display" : "Environmental Analyst",
      "definition" : "Environmental Analyst"
    },
    {
      "code" : "2442.006",
      "display" : "Environmental Statistics Analyst",
      "definition" : "Environmental Statistics Analyst"
    },
    {
      "code" : "2442.007",
      "display" : "Ethnologist",
      "definition" : "Ethnologist"
    },
    {
      "code" : "2442.008",
      "display" : "Genealogist",
      "definition" : "Genealogist"
    },
    {
      "code" : "2442.009",
      "display" : "Geographer",
      "definition" : "Geographer"
    },
    {
      "code" : "2442.010",
      "display" : "Historian",
      "definition" : "Historian"
    },
    {
      "code" : "2442.011",
      "display" : "Labour Market Analyst",
      "definition" : "Labour Market Analyst"
    },
    {
      "code" : "2442.012",
      "display" : "Policy Analyst",
      "definition" : "Policy Analyst"
    },
    {
      "code" : "2442.013",
      "display" : "Political Analyst",
      "definition" : "Political Analyst"
    },
    {
      "code" : "2442.014",
      "display" : "Political Scientist",
      "definition" : "Political Scientist"
    },
    {
      "code" : "2442.015",
      "display" : "Population Analyst",
      "definition" : "Population Analyst"
    },
    {
      "code" : "2442.016",
      "display" : "Research Officer Social Sciences",
      "definition" : "Research Officer Social Sciences"
    },
    {
      "code" : "2442.017",
      "display" : "Research Statistician",
      "definition" : "Research Statistician"
    },
    {
      "code" : "2442.018",
      "display" : "Social Researcher",
      "definition" : "Social Researcher"
    },
    {
      "code" : "2442.019",
      "display" : "Social Scientist",
      "definition" : "Social Scientist"
    },
    {
      "code" : "2442.020",
      "display" : "Social Statistics Analyst",
      "definition" : "Social Statistics Analyst"
    },
    {
      "code" : "2442.021",
      "display" : "Sociologist",
      "definition" : "Sociologist"
    },
    {
      "code" : "2443.001",
      "display" : "Braille Transcriber",
      "definition" : "Braille Transcriber"
    },
    {
      "code" : "2443.002",
      "display" : "Etymologist",
      "definition" : "Etymologist"
    },
    {
      "code" : "2443.003",
      "display" : "Interpreter",
      "definition" : "Interpreter"
    },
    {
      "code" : "2443.004",
      "display" : "Language Translator",
      "definition" : "Language Translator"
    },
    {
      "code" : "2443.005",
      "display" : "Linguist",
      "definition" : "Linguist"
    },
    {
      "code" : "2443.006",
      "display" : "Philologist",
      "definition" : "Philologist"
    },
    {
      "code" : "2443.007",
      "display" : "Sign Language Translator",
      "definition" : "Sign Language Translator"
    },
    {
      "code" : "2443.008",
      "display" : "Translator",
      "definition" : "Translator"
    },
    {
      "code" : "2444.001",
      "display" : "Behaviour Therapist",
      "definition" : "Behaviour Therapist"
    },
    {
      "code" : "2444.002",
      "display" : "Behavioural Researcher",
      "definition" : "Behavioural Researcher"
    },
    {
      "code" : "2444.003",
      "display" : "Child Development Psychologist",
      "definition" : "Child Development Psychologist"
    },
    {
      "code" : "2444.004",
      "display" : "Clinical Psychologist",
      "definition" : "Clinical Psychologist"
    },
    {
      "code" : "2444.005",
      "display" : "Cognitive Behavioural Therapist",
      "definition" : "Cognitive Behavioural Therapist"
    },
    {
      "code" : "2444.006",
      "display" : "Comparative Psychologist",
      "definition" : "Comparative Psychologist"
    },
    {
      "code" : "2444.007",
      "display" : "Counselling Psychologist",
      "definition" : "Counselling Psychologist"
    },
    {
      "code" : "2444.008",
      "display" : "Criminal Psychologist",
      "definition" : "Criminal Psychologist"
    },
    {
      "code" : "2444.009",
      "display" : "Educational Psychologist",
      "definition" : "Educational Psychologist"
    },
    {
      "code" : "2444.010",
      "display" : "Experimental Psychologist",
      "definition" : "Experimental Psychologist"
    },
    {
      "code" : "2444.011",
      "display" : "Family Counselling Psychologist",
      "definition" : "Family Counselling Psychologist"
    },
    {
      "code" : "2444.012",
      "display" : "Forensic Psychologist",
      "definition" : "Forensic Psychologist"
    },
    {
      "code" : "2444.013",
      "display" : "Occupational Psychologist",
      "definition" : "Occupational Psychologist"
    },
    {
      "code" : "2444.014",
      "display" : "Psychologist",
      "definition" : "Psychologist"
    },
    {
      "code" : "2444.015",
      "display" : "Psychology Administrator",
      "definition" : "Psychology Administrator"
    },
    {
      "code" : "2444.016",
      "display" : "Psychotherapist",
      "definition" : "Psychotherapist"
    },
    {
      "code" : "2444.017",
      "display" : "Research Psychologist",
      "definition" : "Research Psychologist"
    },
    {
      "code" : "2444.018",
      "display" : "Sports Psychologist",
      "definition" : "Sports Psychologist"
    },
    {
      "code" : "2445.001",
      "display" : "Alcohol Counsellor",
      "definition" : "Alcohol Counsellor"
    },
    {
      "code" : "2445.002",
      "display" : "Counsellor",
      "definition" : "Counsellor"
    },
    {
      "code" : "2445.003",
      "display" : "Counsellor Social Service",
      "definition" : "Counsellor Social Service"
    },
    {
      "code" : "2445.004",
      "display" : "Drug and Alcohol Counsellor",
      "definition" : "Drug and Alcohol Counsellor"
    },
    {
      "code" : "2445.005",
      "display" : "Family Counsellor",
      "definition" : "Family Counsellor"
    },
    {
      "code" : "2445.006",
      "display" : "Guidance Counsellor",
      "definition" : "Guidance Counsellor"
    },
    {
      "code" : "2445.007",
      "display" : "Marriage Guidance Counsellor",
      "definition" : "Marriage Guidance Counsellor"
    },
    {
      "code" : "2445.008",
      "display" : "Personal Counsellor",
      "definition" : "Personal Counsellor"
    },
    {
      "code" : "2445.009",
      "display" : "Relationship Counsellor",
      "definition" : "Relationship Counsellor"
    },
    {
      "code" : "2445.010",
      "display" : "School Counsellor",
      "definition" : "School Counsellor"
    },
    {
      "code" : "2445.011",
      "display" : "Sexual Abuse Counsellor",
      "definition" : "Sexual Abuse Counsellor"
    },
    {
      "code" : "2445.012",
      "display" : "Vocational Guidance Counsellor",
      "definition" : "Vocational Guidance Counsellor"
    },
    {
      "code" : "2446.001",
      "display" : "Consular Official",
      "definition" : "Consular Official"
    },
    {
      "code" : "2446.002",
      "display" : "Diplomatic Information Officer",
      "definition" : "Diplomatic Information Officer"
    },
    {
      "code" : "2446.003",
      "display" : "Diplomatic Officer",
      "definition" : "Diplomatic Officer"
    },
    {
      "code" : "2446.004",
      "display" : "Diplomatic Official",
      "definition" : "Diplomatic Official"
    },
    {
      "code" : "2446.005",
      "display" : "Diplomatic Secretary",
      "definition" : "Diplomatic Secretary"
    },
    {
      "code" : "2446.006",
      "display" : "Embassy Secretary",
      "definition" : "Embassy Secretary"
    },
    {
      "code" : "2446.007",
      "display" : "External Relations Policy Officer",
      "definition" : "External Relations Policy Officer"
    },
    {
      "code" : "2446.008",
      "display" : "Foreign Affairs and Trade Officer",
      "definition" : "Foreign Affairs and Trade Officer"
    },
    {
      "code" : "2446.009",
      "display" : "Mission Director Diplomatic",
      "definition" : "Mission Director Diplomatic"
    },
    {
      "code" : "2446.010",
      "display" : "Trade Commissioner Attache",
      "definition" : "Trade Commissioner Attache"
    },
    {
      "code" : "2451.001",
      "display" : "Anglican Minister",
      "definition" : "Anglican Minister"
    },
    {
      "code" : "2451.002",
      "display" : "Anglican Priest",
      "definition" : "Anglican Priest"
    },
    {
      "code" : "2451.003",
      "display" : "Catholic Priest",
      "definition" : "Catholic Priest"
    },
    {
      "code" : "2451.004",
      "display" : "Chaplain",
      "definition" : "Chaplain"
    },
    {
      "code" : "2451.005",
      "display" : "Clergyman",
      "definition" : "Clergyman"
    },
    {
      "code" : "2451.006",
      "display" : "Clergywoman",
      "definition" : "Clergywoman"
    },
    {
      "code" : "2451.007",
      "display" : "Hospital Chaplain",
      "definition" : "Hospital Chaplain"
    },
    {
      "code" : "2451.008",
      "display" : "Industrial Chaplain",
      "definition" : "Industrial Chaplain"
    },
    {
      "code" : "2451.009",
      "display" : "Minister of Religion",
      "definition" : "Minister of Religion"
    },
    {
      "code" : "2451.010",
      "display" : "Pastor",
      "definition" : "Pastor"
    },
    {
      "code" : "2451.011",
      "display" : "Priest",
      "definition" : "Priest"
    },
    {
      "code" : "2451.012",
      "display" : "Prison Chaplain",
      "definition" : "Prison Chaplain"
    },
    {
      "code" : "2451.013",
      "display" : "Rabbi",
      "definition" : "Rabbi"
    },
    {
      "code" : "2451.014",
      "display" : "Salvation Army Officer",
      "definition" : "Salvation Army Officer"
    },
    {
      "code" : "2451.015",
      "display" : "Vicar",
      "definition" : "Vicar"
    },
    {
      "code" : "3111.001",
      "display" : "Astronomy Technician",
      "definition" : "Astronomy Technician"
    },
    {
      "code" : "3111.002",
      "display" : "Chemical Manufacturing Technician",
      "definition" : "Chemical Manufacturing Technician"
    },
    {
      "code" : "3111.003",
      "display" : "Chemistry Technician",
      "definition" : "Chemistry Technician"
    },
    {
      "code" : "3111.004",
      "display" : "Field Trials Officer",
      "definition" : "Field Trials Officer"
    },
    {
      "code" : "3111.005",
      "display" : "Geological Technician",
      "definition" : "Geological Technician"
    },
    {
      "code" : "3111.006",
      "display" : "Geology Technician",
      "definition" : "Geology Technician"
    },
    {
      "code" : "3111.007",
      "display" : "Hydrological Field Technician",
      "definition" : "Hydrological Field Technician"
    },
    {
      "code" : "3111.008",
      "display" : "Hydrology Technician",
      "definition" : "Hydrology Technician"
    },
    {
      "code" : "3111.009",
      "display" : "Industrial Laboratory Technician",
      "definition" : "Industrial Laboratory Technician"
    },
    {
      "code" : "3111.010",
      "display" : "Industrial Research Technician",
      "definition" : "Industrial Research Technician"
    },
    {
      "code" : "3111.011",
      "display" : "Limnology Technician",
      "definition" : "Limnology Technician"
    },
    {
      "code" : "3111.012",
      "display" : "Meteorological Observer Technician",
      "definition" : "Meteorological Observer Technician"
    },
    {
      "code" : "3111.013",
      "display" : "Meteorological Technical Officer",
      "definition" : "Meteorological Technical Officer"
    },
    {
      "code" : "3111.014",
      "display" : "Meteorological Technician",
      "definition" : "Meteorological Technician"
    },
    {
      "code" : "3111.015",
      "display" : "Meteorology Technician",
      "definition" : "Meteorology Technician"
    },
    {
      "code" : "3111.016",
      "display" : "Physical Science Technician",
      "definition" : "Physical Science Technician"
    },
    {
      "code" : "3111.017",
      "display" : "Physical Sciences Field Station Observer",
      "definition" : "Physical Sciences Field Station Observer"
    },
    {
      "code" : "3111.018",
      "display" : "Physical Sciences Laboratory Technician",
      "definition" : "Physical Sciences Laboratory Technician"
    },
    {
      "code" : "3111.019",
      "display" : "Physical Sciences Research Laboratory Technician",
      "definition" : "Physical Sciences Research Laboratory Technician"
    },
    {
      "code" : "3111.020",
      "display" : "Physics Technician",
      "definition" : "Physics Technician"
    },
    {
      "code" : "3111.021",
      "display" : "Radiation Laboratory Technician",
      "definition" : "Radiation Laboratory Technician"
    },
    {
      "code" : "3111.022",
      "display" : "Research Technician Industrial Laboratory",
      "definition" : "Research Technician Industrial Laboratory"
    },
    {
      "code" : "3111.023",
      "display" : "School Laboratory Technician",
      "definition" : "School Laboratory Technician"
    },
    {
      "code" : "3111.024",
      "display" : "University Physical Sciences Workshop Technician",
      "definition" : "University Physical Sciences Workshop Technician"
    },
    {
      "code" : "3111.025",
      "display" : "University Research Technician",
      "definition" : "University Research Technician"
    },
    {
      "code" : "3111.026",
      "display" : "Wool Testing Technician",
      "definition" : "Wool Testing Technician"
    },
    {
      "code" : "3112.001",
      "display" : "Building Estimator",
      "definition" : "Building Estimator"
    },
    {
      "code" : "3112.002",
      "display" : "Cartographic Technician",
      "definition" : "Cartographic Technician"
    },
    {
      "code" : "3112.003",
      "display" : "Civil Engineering Assistant",
      "definition" : "Civil Engineering Assistant"
    },
    {
      "code" : "3112.004",
      "display" : "Clerk of Works",
      "definition" : "Clerk of Works"
    },
    {
      "code" : "3112.005",
      "display" : "Construction Design Technician",
      "definition" : "Construction Design Technician"
    },
    {
      "code" : "3112.006",
      "display" : "Construction Estimator",
      "definition" : "Construction Estimator"
    },
    {
      "code" : "3112.007",
      "display" : "Construction Supply Planner",
      "definition" : "Construction Supply Planner"
    },
    {
      "code" : "3112.008",
      "display" : "Hydrographic Technician",
      "definition" : "Hydrographic Technician"
    },
    {
      "code" : "3112.009",
      "display" : "Other Civil Engineering Technician",
      "definition" : "Other Civil Engineering Technician"
    },
    {
      "code" : "3112.010",
      "display" : "Quality Controller of Other Civil Engineering Technicians",
      "definition" : "Quality Controller of Other Civil Engineering Technicians"
    },
    {
      "code" : "3112.011",
      "display" : "Quality Controller Of Surveyors Technicians",
      "definition" : "Quality Controller Of Surveyors Technicians"
    },
    {
      "code" : "3112.012",
      "display" : "Quantity Surveyor",
      "definition" : "Quantity Surveyor"
    },
    {
      "code" : "3112.013",
      "display" : "Specification Writer Electrical",
      "definition" : "Specification Writer Electrical"
    },
    {
      "code" : "3112.014",
      "display" : "Surveyors Technician",
      "definition" : "Surveyors Technician"
    },
    {
      "code" : "3112.015",
      "display" : "Waste Water Treatment Officer",
      "definition" : "Waste Water Treatment Officer"
    },
    {
      "code" : "3112.016",
      "display" : "Work Site Engineering Technician",
      "definition" : "Work Site Engineering Technician"
    },
    {
      "code" : "3113.001",
      "display" : "Electrical Engineering Estimator",
      "definition" : "Electrical Engineering Estimator"
    },
    {
      "code" : "3113.002",
      "display" : "Electrical Engineering Technician",
      "definition" : "Electrical Engineering Technician"
    },
    {
      "code" : "3113.003",
      "display" : "Electrical Test Technician",
      "definition" : "Electrical Test Technician"
    },
    {
      "code" : "3113.004",
      "display" : "Electricity Test Room Technician",
      "definition" : "Electricity Test Room Technician"
    },
    {
      "code" : "3113.005",
      "display" : "Power Generation Transmission Technician",
      "definition" : "Power Generation Transmission Technician"
    },
    {
      "code" : "3113.006",
      "display" : "Quality Controller Of Electrical Engineering Technicians",
      "definition" : "Quality Controller Of Electrical Engineering Technicians"
    },
    {
      "code" : "3114.001",
      "display" : "Avionics Engineering Technician",
      "definition" : "Avionics Engineering Technician"
    },
    {
      "code" : "3114.002",
      "display" : "Avionics Technician",
      "definition" : "Avionics Technician"
    },
    {
      "code" : "3114.003",
      "display" : "Broadcasting Engineering Technician",
      "definition" : "Broadcasting Engineering Technician"
    },
    {
      "code" : "3114.004",
      "display" : "Broadcasting Technician",
      "definition" : "Broadcasting Technician"
    },
    {
      "code" : "3114.005",
      "display" : "Communications Technical Officer",
      "definition" : "Communications Technical Officer"
    },
    {
      "code" : "3114.006",
      "display" : "Communications Technician",
      "definition" : "Communications Technician"
    },
    {
      "code" : "3114.007",
      "display" : "Computer Services Technician",
      "definition" : "Computer Services Technician"
    },
    {
      "code" : "3114.008",
      "display" : "Computer Systems Technician",
      "definition" : "Computer Systems Technician"
    },
    {
      "code" : "3114.009",
      "display" : "Computer Technical Service Officer",
      "definition" : "Computer Technical Service Officer"
    },
    {
      "code" : "3114.010",
      "display" : "Electronic Engineering Estimator",
      "definition" : "Electronic Engineering Estimator"
    },
    {
      "code" : "3114.011",
      "display" : "Electronic Engineering Technician",
      "definition" : "Electronic Engineering Technician"
    },
    {
      "code" : "3114.012",
      "display" : "Electronic Instrument Technician",
      "definition" : "Electronic Instrument Technician"
    },
    {
      "code" : "3114.013",
      "display" : "Electronic Science Technician",
      "definition" : "Electronic Science Technician"
    },
    {
      "code" : "3114.014",
      "display" : "Electronic System Engineering Technician",
      "definition" : "Electronic System Engineering Technician"
    },
    {
      "code" : "3114.015",
      "display" : "Electronics Technician",
      "definition" : "Electronics Technician"
    },
    {
      "code" : "3114.016",
      "display" : "Information Systems Technician",
      "definition" : "Information Systems Technician"
    },
    {
      "code" : "3114.017",
      "display" : "Licensed Aircraft Maintenance Engineer (Avionics)",
      "definition" : "Licensed Aircraft Maintenance Engineer (Avionics)"
    },
    {
      "code" : "3114.018",
      "display" : "Other Electronics Engineering Technician",
      "definition" : "Other Electronics Engineering Technician"
    },
    {
      "code" : "3114.019",
      "display" : "Overseer Installation Communications",
      "definition" : "Overseer Installation Communications"
    },
    {
      "code" : "3114.020",
      "display" : "Quality Controller Of Computer Systems Technicians",
      "definition" : "Quality Controller Of Computer Systems Technicians"
    },
    {
      "code" : "3114.021",
      "display" : "Quality Controller Of Other Electronic Engineering Technicians",
      "definition" : "Quality Controller Of Other Electronic Engineering Technicians"
    },
    {
      "code" : "3114.022",
      "display" : "Quality Controller Of Telecommunications Technicians",
      "definition" : "Quality Controller Of Telecommunications Technicians"
    },
    {
      "code" : "3114.023",
      "display" : "Radar Technician",
      "definition" : "Radar Technician"
    },
    {
      "code" : "3114.024",
      "display" : "Radio Engineering Technician",
      "definition" : "Radio Engineering Technician"
    },
    {
      "code" : "3114.025",
      "display" : "Radio Technician",
      "definition" : "Radio Technician"
    },
    {
      "code" : "3114.026",
      "display" : "Scientific Electronics Technician",
      "definition" : "Scientific Electronics Technician"
    },
    {
      "code" : "3114.027",
      "display" : "Telecom Technician",
      "definition" : "Telecom Technician"
    },
    {
      "code" : "3114.028",
      "display" : "Telecommunication Engineering Technician",
      "definition" : "Telecommunication Engineering Technician"
    },
    {
      "code" : "3114.029",
      "display" : "Telecommunications Technical Officer",
      "definition" : "Telecommunications Technical Officer"
    },
    {
      "code" : "3114.030",
      "display" : "Telecommunications Technician",
      "definition" : "Telecommunications Technician"
    },
    {
      "code" : "3114.031",
      "display" : "Telephone Equipment Serviceman",
      "definition" : "Telephone Equipment Serviceman"
    },
    {
      "code" : "3114.032",
      "display" : "Telephone Equipment Technician",
      "definition" : "Telephone Equipment Technician"
    },
    {
      "code" : "3114.033",
      "display" : "Telephone Technician",
      "definition" : "Telephone Technician"
    },
    {
      "code" : "3114.034",
      "display" : "Television and Radio Systems Technician",
      "definition" : "Television and Radio Systems Technician"
    },
    {
      "code" : "3114.035",
      "display" : "Television Engineering Technician",
      "definition" : "Television Engineering Technician"
    },
    {
      "code" : "3115.001",
      "display" : "Aeronautical Engineering Technician",
      "definition" : "Aeronautical Engineering Technician"
    },
    {
      "code" : "3115.002",
      "display" : "Aeronautical Maintenance Instructor",
      "definition" : "Aeronautical Maintenance Instructor"
    },
    {
      "code" : "3115.003",
      "display" : "Aeronautical Technician",
      "definition" : "Aeronautical Technician"
    },
    {
      "code" : "3115.004",
      "display" : "Agricultural Engineering Technician",
      "definition" : "Agricultural Engineering Technician"
    },
    {
      "code" : "3115.005",
      "display" : "Air Conditioning Technician",
      "definition" : "Air Conditioning Technician"
    },
    {
      "code" : "3115.006",
      "display" : "Aircraft Engineering Technician",
      "definition" : "Aircraft Engineering Technician"
    },
    {
      "code" : "3115.007",
      "display" : "Automotive Engineering Technician",
      "definition" : "Automotive Engineering Technician"
    },
    {
      "code" : "3115.008",
      "display" : "Heating and Ventilation Technician",
      "definition" : "Heating and Ventilation Technician"
    },
    {
      "code" : "3115.009",
      "display" : "Marine Engineering Technician",
      "definition" : "Marine Engineering Technician"
    },
    {
      "code" : "3115.010",
      "display" : "Mechanical Engineering Estimator",
      "definition" : "Mechanical Engineering Estimator"
    },
    {
      "code" : "3115.011",
      "display" : "Mechanical Engineering Technician",
      "definition" : "Mechanical Engineering Technician"
    },
    {
      "code" : "3115.012",
      "display" : "Mechanical Instrument Technician",
      "definition" : "Mechanical Instrument Technician"
    },
    {
      "code" : "3115.013",
      "display" : "Nautical Engineering Techncian",
      "definition" : "Nautical Engineering Techncian"
    },
    {
      "code" : "3115.014",
      "display" : "Naval Technician",
      "definition" : "Naval Technician"
    },
    {
      "code" : "3115.015",
      "display" : "Quality Controller Of Mechanical Engineering Technicians",
      "definition" : "Quality Controller Of Mechanical Engineering Technicians"
    },
    {
      "code" : "3115.016",
      "display" : "Tool And Die Design Technician",
      "definition" : "Tool And Die Design Technician"
    },
    {
      "code" : "3116.001",
      "display" : "Chemical Engineering Technician",
      "definition" : "Chemical Engineering Technician"
    },
    {
      "code" : "3116.002",
      "display" : "Dairy Technician",
      "definition" : "Dairy Technician"
    },
    {
      "code" : "3116.003",
      "display" : "Food Engineering Technician",
      "definition" : "Food Engineering Technician"
    },
    {
      "code" : "3116.004",
      "display" : "Fuel Engineering Technician",
      "definition" : "Fuel Engineering Technician"
    },
    {
      "code" : "3116.005",
      "display" : "Gas Production and Distribution Technician",
      "definition" : "Gas Production and Distribution Technician"
    },
    {
      "code" : "3116.006",
      "display" : "Petroleum Engineering Technician",
      "definition" : "Petroleum Engineering Technician"
    },
    {
      "code" : "3116.007",
      "display" : "Wool Research Textile Engineering Technician",
      "definition" : "Wool Research Textile Engineering Technician"
    },
    {
      "code" : "3118.001",
      "display" : "Aeronautical Draughtsman",
      "definition" : "Aeronautical Draughtsman"
    },
    {
      "code" : "3118.002",
      "display" : "Architectural Draughting Technician",
      "definition" : "Architectural Draughting Technician"
    },
    {
      "code" : "3118.003",
      "display" : "Architectural Draughtsman",
      "definition" : "Architectural Draughtsman"
    },
    {
      "code" : "3118.004",
      "display" : "Architectural Draughtsperson",
      "definition" : "Architectural Draughtsperson"
    },
    {
      "code" : "3118.005",
      "display" : "Building Design Technician",
      "definition" : "Building Design Technician"
    },
    {
      "code" : "3118.006",
      "display" : "CAD Draughtsman",
      "definition" : "CAD Draughtsman"
    },
    {
      "code" : "3118.007",
      "display" : "Civil Design Draughting Technician",
      "definition" : "Civil Design Draughting Technician"
    },
    {
      "code" : "3118.008",
      "display" : "Civil Design Draughtsman",
      "definition" : "Civil Design Draughtsman"
    },
    {
      "code" : "3118.009",
      "display" : "Civil Engineering Draughting Technician",
      "definition" : "Civil Engineering Draughting Technician"
    },
    {
      "code" : "3118.010",
      "display" : "Civil Engineering Draughtsman",
      "definition" : "Civil Engineering Draughtsman"
    },
    {
      "code" : "3118.011",
      "display" : "Coal Technician",
      "definition" : "Coal Technician"
    },
    {
      "code" : "3118.012",
      "display" : "Coal Technologist",
      "definition" : "Coal Technologist"
    },
    {
      "code" : "3118.013",
      "display" : "Colliery Technician",
      "definition" : "Colliery Technician"
    },
    {
      "code" : "3118.014",
      "display" : "Computer Draughtsman",
      "definition" : "Computer Draughtsman"
    },
    {
      "code" : "3118.015",
      "display" : "Construction Draughting Technician",
      "definition" : "Construction Draughting Technician"
    },
    {
      "code" : "3118.016",
      "display" : "Construction Draughtsman",
      "definition" : "Construction Draughtsman"
    },
    {
      "code" : "3118.017",
      "display" : "Draughting Officer",
      "definition" : "Draughting Officer"
    },
    {
      "code" : "3118.018",
      "display" : "Draughting Technician",
      "definition" : "Draughting Technician"
    },
    {
      "code" : "3118.019",
      "display" : "Draughts Person",
      "definition" : "Draughts Person"
    },
    {
      "code" : "3118.020",
      "display" : "Draughtsman",
      "definition" : "Draughtsman"
    },
    {
      "code" : "3118.021",
      "display" : "Draughtsperson",
      "definition" : "Draughtsperson"
    },
    {
      "code" : "3118.022",
      "display" : "Draughtswoman",
      "definition" : "Draughtswoman"
    },
    {
      "code" : "3118.023",
      "display" : "Electrical Draughting Technician",
      "definition" : "Electrical Draughting Technician"
    },
    {
      "code" : "3118.024",
      "display" : "Electrical Draughtsman",
      "definition" : "Electrical Draughtsman"
    },
    {
      "code" : "3118.025",
      "display" : "Industrial Radiographer",
      "definition" : "Industrial Radiographer"
    },
    {
      "code" : "3118.026",
      "display" : "Manufacturing Draughtsperson",
      "definition" : "Manufacturing Draughtsperson"
    },
    {
      "code" : "3118.027",
      "display" : "Marine Draughting Technician",
      "definition" : "Marine Draughting Technician"
    },
    {
      "code" : "3118.028",
      "display" : "Marine Draughtsman",
      "definition" : "Marine Draughtsman"
    },
    {
      "code" : "3118.029",
      "display" : "Mechanical Draughting Technician",
      "definition" : "Mechanical Draughting Technician"
    },
    {
      "code" : "3118.030",
      "display" : "Mechanical Draughtsman",
      "definition" : "Mechanical Draughtsman"
    },
    {
      "code" : "3118.031",
      "display" : "Metallurgical Technician",
      "definition" : "Metallurgical Technician"
    },
    {
      "code" : "3118.032",
      "display" : "Mineral Analyst",
      "definition" : "Mineral Analyst"
    },
    {
      "code" : "3118.033",
      "display" : "Mineral Spectroscopist",
      "definition" : "Mineral Spectroscopist"
    },
    {
      "code" : "3118.034",
      "display" : "Mining Technician",
      "definition" : "Mining Technician"
    },
    {
      "code" : "3118.035",
      "display" : "Photographic Draughting Technician",
      "definition" : "Photographic Draughting Technician"
    },
    {
      "code" : "3118.036",
      "display" : "Photographic Draughtsman",
      "definition" : "Photographic Draughtsman"
    },
    {
      "code" : "3118.037",
      "display" : "Plan Tracer",
      "definition" : "Plan Tracer"
    },
    {
      "code" : "3118.038",
      "display" : "Structural Draughting Technician",
      "definition" : "Structural Draughting Technician"
    },
    {
      "code" : "3118.039",
      "display" : "Structural Draughtsman",
      "definition" : "Structural Draughtsman"
    },
    {
      "code" : "3118.040",
      "display" : "Structural Engineering Draughting Technician",
      "definition" : "Structural Engineering Draughting Technician"
    },
    {
      "code" : "3118.041",
      "display" : "Surveyors Draughtsman",
      "definition" : "Surveyors Draughtsman"
    },
    {
      "code" : "3118.042",
      "display" : "Technical Draughting Officer",
      "definition" : "Technical Draughting Officer"
    },
    {
      "code" : "3118.043",
      "display" : "Town Planning Research Technician",
      "definition" : "Town Planning Research Technician"
    },
    {
      "code" : "3118.044",
      "display" : "Yacht Designer",
      "definition" : "Yacht Designer"
    },
    {
      "code" : "3119.001",
      "display" : "Non Destructive Testing Technician",
      "definition" : "Non Destructive Testing Technician"
    },
    {
      "code" : "3119.002",
      "display" : "Other Engineering Technician",
      "definition" : "Other Engineering Technician"
    },
    {
      "code" : "3119.003",
      "display" : "Quality Controller Of Other Engineering Technicians",
      "definition" : "Quality Controller Of Other Engineering Technicians"
    },
    {
      "code" : "3119.004",
      "display" : "School Technician",
      "definition" : "School Technician"
    },
    {
      "code" : "3119.005",
      "display" : "Weights and Measures Inspector",
      "definition" : "Weights and Measures Inspector"
    },
    {
      "code" : "3121.001",
      "display" : "Applications Programmer",
      "definition" : "Applications Programmer"
    },
    {
      "code" : "3121.002",
      "display" : "Applications Tester",
      "definition" : "Applications Tester"
    },
    {
      "code" : "3121.003",
      "display" : "Computer Controller",
      "definition" : "Computer Controller"
    },
    {
      "code" : "3121.004",
      "display" : "Computer Coordinator",
      "definition" : "Computer Coordinator"
    },
    {
      "code" : "3121.005",
      "display" : "Computer Operator",
      "definition" : "Computer Operator"
    },
    {
      "code" : "3121.006",
      "display" : "Computer Programmer",
      "definition" : "Computer Programmer"
    },
    {
      "code" : "3121.007",
      "display" : "Computer Scheduler",
      "definition" : "Computer Scheduler"
    },
    {
      "code" : "3121.008",
      "display" : "Computer Support Technician",
      "definition" : "Computer Support Technician"
    },
    {
      "code" : "3121.009",
      "display" : "Desktop Support Specialist",
      "definition" : "Desktop Support Specialist"
    },
    {
      "code" : "3121.010",
      "display" : "EDP Data Controller",
      "definition" : "EDP Data Controller"
    },
    {
      "code" : "3121.011",
      "display" : "Information Systems Programmer",
      "definition" : "Information Systems Programmer"
    },
    {
      "code" : "3121.012",
      "display" : "Kaiwhakahaere Rorohiko",
      "definition" : "Kaiwhakahaere Rorohiko"
    },
    {
      "code" : "3121.013",
      "display" : "Systems Operator Mathematical",
      "definition" : "Systems Operator Mathematical"
    },
    {
      "code" : "3121.014",
      "display" : "Systems Programmer",
      "definition" : "Systems Programmer"
    },
    {
      "code" : "3121.015",
      "display" : "Systems Support Intranet",
      "definition" : "Systems Support Intranet"
    },
    {
      "code" : "3121.016",
      "display" : "Web Assistant",
      "definition" : "Web Assistant"
    },
    {
      "code" : "3121.017",
      "display" : "Web Support",
      "definition" : "Web Support"
    },
    {
      "code" : "3131.001",
      "display" : "Aerial Photographer",
      "definition" : "Aerial Photographer"
    },
    {
      "code" : "3131.002",
      "display" : "Camera Control Operator Television",
      "definition" : "Camera Control Operator Television"
    },
    {
      "code" : "3131.003",
      "display" : "Camera Operator",
      "definition" : "Camera Operator"
    },
    {
      "code" : "3131.004",
      "display" : "Cinetape Operator",
      "definition" : "Cinetape Operator"
    },
    {
      "code" : "3131.005",
      "display" : "Commercial Photographer",
      "definition" : "Commercial Photographer"
    },
    {
      "code" : "3131.006",
      "display" : "Fashion Photographer",
      "definition" : "Fashion Photographer"
    },
    {
      "code" : "3131.007",
      "display" : "Film Camera Operator",
      "definition" : "Film Camera Operator"
    },
    {
      "code" : "3131.008",
      "display" : "Kaimahi Kaamera",
      "definition" : "Kaimahi Kaamera"
    },
    {
      "code" : "3131.009",
      "display" : "Medical Photographer",
      "definition" : "Medical Photographer"
    },
    {
      "code" : "3131.010",
      "display" : "Microfilm Technician",
      "definition" : "Microfilm Technician"
    },
    {
      "code" : "3131.011",
      "display" : "Motion Picture Cameraman",
      "definition" : "Motion Picture Cameraman"
    },
    {
      "code" : "3131.012",
      "display" : "Photographer",
      "definition" : "Photographer"
    },
    {
      "code" : "3131.013",
      "display" : "Photographic Camera Operator",
      "definition" : "Photographic Camera Operator"
    },
    {
      "code" : "3131.014",
      "display" : "Photojournalist",
      "definition" : "Photojournalist"
    },
    {
      "code" : "3131.015",
      "display" : "Police Photographer",
      "definition" : "Police Photographer"
    },
    {
      "code" : "3131.016",
      "display" : "Portrait Photographer",
      "definition" : "Portrait Photographer"
    },
    {
      "code" : "3131.017",
      "display" : "Public Address Equipment Operator",
      "definition" : "Public Address Equipment Operator"
    },
    {
      "code" : "3131.018",
      "display" : "Sound Mixer",
      "definition" : "Sound Mixer"
    },
    {
      "code" : "3131.019",
      "display" : "Sound Operator",
      "definition" : "Sound Operator"
    },
    {
      "code" : "3131.020",
      "display" : "Sound Recording Equipment Controller",
      "definition" : "Sound Recording Equipment Controller"
    },
    {
      "code" : "3131.021",
      "display" : "Television Camera Operator",
      "definition" : "Television Camera Operator"
    },
    {
      "code" : "3131.022",
      "display" : "Television Cameraman",
      "definition" : "Television Cameraman"
    },
    {
      "code" : "3131.023",
      "display" : "Video Camera Operator",
      "definition" : "Video Camera Operator"
    },
    {
      "code" : "3131.024",
      "display" : "Videographer",
      "definition" : "Videographer"
    },
    {
      "code" : "3131.025",
      "display" : "Wedding Photographer",
      "definition" : "Wedding Photographer"
    },
    {
      "code" : "3132.001",
      "display" : "Broadcasting Operator",
      "definition" : "Broadcasting Operator"
    },
    {
      "code" : "3132.002",
      "display" : "Broadcasting Station Operator",
      "definition" : "Broadcasting Station Operator"
    },
    {
      "code" : "3132.003",
      "display" : "Broadcasting Transmitting and Studio Equipment Operator",
      "definition" : "Broadcasting Transmitting and Studio Equipment Operator"
    },
    {
      "code" : "3132.004",
      "display" : "Cinema Projectionist",
      "definition" : "Cinema Projectionist"
    },
    {
      "code" : "3132.005",
      "display" : "Communications Instrument Officer",
      "definition" : "Communications Instrument Officer"
    },
    {
      "code" : "3132.006",
      "display" : "Communications Operator",
      "definition" : "Communications Operator"
    },
    {
      "code" : "3132.007",
      "display" : "Film Editing Equipment Operator",
      "definition" : "Film Editing Equipment Operator"
    },
    {
      "code" : "3132.008",
      "display" : "Film Editor",
      "definition" : "Film Editor"
    },
    {
      "code" : "3132.009",
      "display" : "Film Projectionist",
      "definition" : "Film Projectionist"
    },
    {
      "code" : "3132.010",
      "display" : "Flight Radio Operator Operations",
      "definition" : "Flight Radio Operator Operations"
    },
    {
      "code" : "3132.011",
      "display" : "Harbour Communications Officer",
      "definition" : "Harbour Communications Officer"
    },
    {
      "code" : "3132.012",
      "display" : "Lighting Operator",
      "definition" : "Lighting Operator"
    },
    {
      "code" : "3132.013",
      "display" : "Lighting Technician (Studio)",
      "definition" : "Lighting Technician (Studio)"
    },
    {
      "code" : "3132.014",
      "display" : "Marine Radio Operator",
      "definition" : "Marine Radio Operator"
    },
    {
      "code" : "3132.015",
      "display" : "Motion Picture Film Projectionist",
      "definition" : "Motion Picture Film Projectionist"
    },
    {
      "code" : "3132.016",
      "display" : "Motion Picture Projectionist",
      "definition" : "Motion Picture Projectionist"
    },
    {
      "code" : "3132.017",
      "display" : "Movie Projectionist",
      "definition" : "Movie Projectionist"
    },
    {
      "code" : "3132.018",
      "display" : "Post-Production Editor",
      "definition" : "Post-Production Editor"
    },
    {
      "code" : "3132.019",
      "display" : "Radio Broadcasting Sound Technician",
      "definition" : "Radio Broadcasting Sound Technician"
    },
    {
      "code" : "3132.020",
      "display" : "Radio Communications Operator",
      "definition" : "Radio Communications Operator"
    },
    {
      "code" : "3132.021",
      "display" : "Radio Control Room Technician",
      "definition" : "Radio Control Room Technician"
    },
    {
      "code" : "3132.022",
      "display" : "Radio Inspector Officer",
      "definition" : "Radio Inspector Officer"
    },
    {
      "code" : "3132.023",
      "display" : "Radio Officer Ship",
      "definition" : "Radio Officer Ship"
    },
    {
      "code" : "3132.024",
      "display" : "Radio Operator",
      "definition" : "Radio Operator"
    },
    {
      "code" : "3132.025",
      "display" : "Radio Station Operator",
      "definition" : "Radio Station Operator"
    },
    {
      "code" : "3132.026",
      "display" : "Radio Telephone Communicator",
      "definition" : "Radio Telephone Communicator"
    },
    {
      "code" : "3132.027",
      "display" : "Radio Telephone Despatcher",
      "definition" : "Radio Telephone Despatcher"
    },
    {
      "code" : "3132.028",
      "display" : "Radio Telephone Operator",
      "definition" : "Radio Telephone Operator"
    },
    {
      "code" : "3132.029",
      "display" : "RT Operator",
      "definition" : "RT Operator"
    },
    {
      "code" : "3132.030",
      "display" : "Studio Equipment Operator",
      "definition" : "Studio Equipment Operator"
    },
    {
      "code" : "3132.031",
      "display" : "Taxi Despatcher",
      "definition" : "Taxi Despatcher"
    },
    {
      "code" : "3132.032",
      "display" : "Telecommunication Equipment Operator",
      "definition" : "Telecommunication Equipment Operator"
    },
    {
      "code" : "3132.033",
      "display" : "Television Broadcasting Sound Operator",
      "definition" : "Television Broadcasting Sound Operator"
    },
    {
      "code" : "3132.034",
      "display" : "Television Control Room Technician",
      "definition" : "Television Control Room Technician"
    },
    {
      "code" : "3132.035",
      "display" : "Television Station Operator",
      "definition" : "Television Station Operator"
    },
    {
      "code" : "3132.036",
      "display" : "Video Editor",
      "definition" : "Video Editor"
    },
    {
      "code" : "3132.037",
      "display" : "Video Tape Operator",
      "definition" : "Video Tape Operator"
    },
    {
      "code" : "3132.038",
      "display" : "Videotape Editor",
      "definition" : "Videotape Editor"
    },
    {
      "code" : "3132.039",
      "display" : "Vision Controller",
      "definition" : "Vision Controller"
    },
    {
      "code" : "3132.040",
      "display" : "VT Editor",
      "definition" : "VT Editor"
    },
    {
      "code" : "3133.001",
      "display" : "Anaesthetic Technician",
      "definition" : "Anaesthetic Technician"
    },
    {
      "code" : "3133.002",
      "display" : "Audio Visual Technician",
      "definition" : "Audio Visual Technician"
    },
    {
      "code" : "3133.003",
      "display" : "Audiometric Technician",
      "definition" : "Audiometric Technician"
    },
    {
      "code" : "3133.004",
      "display" : "Audiometrist",
      "definition" : "Audiometrist"
    },
    {
      "code" : "3133.005",
      "display" : "Cardia Ultrasound Technician",
      "definition" : "Cardia Ultrasound Technician"
    },
    {
      "code" : "3133.006",
      "display" : "Cardiac Monitoring Technician",
      "definition" : "Cardiac Monitoring Technician"
    },
    {
      "code" : "3133.007",
      "display" : "Cardiographer",
      "definition" : "Cardiographer"
    },
    {
      "code" : "3133.008",
      "display" : "Cardiology Technician",
      "definition" : "Cardiology Technician"
    },
    {
      "code" : "3133.009",
      "display" : "Diagnostic Medical Radiation Technician",
      "definition" : "Diagnostic Medical Radiation Technician"
    },
    {
      "code" : "3133.010",
      "display" : "Diagnostic Radiation Technologist",
      "definition" : "Diagnostic Radiation Technologist"
    },
    {
      "code" : "3133.011",
      "display" : "Diagnostic Radiographer",
      "definition" : "Diagnostic Radiographer"
    },
    {
      "code" : "3133.012",
      "display" : "ECG Technician",
      "definition" : "ECG Technician"
    },
    {
      "code" : "3133.013",
      "display" : "Echocardiographer",
      "definition" : "Echocardiographer"
    },
    {
      "code" : "3133.014",
      "display" : "Electrocardiograph Technician",
      "definition" : "Electrocardiograph Technician"
    },
    {
      "code" : "3133.015",
      "display" : "Electroencephalographic Technician",
      "definition" : "Electroencephalographic Technician"
    },
    {
      "code" : "3133.016",
      "display" : "Hospital Theatre Technician",
      "definition" : "Hospital Theatre Technician"
    },
    {
      "code" : "3133.017",
      "display" : "Medical Electronic Equipment Operator",
      "definition" : "Medical Electronic Equipment Operator"
    },
    {
      "code" : "3133.018",
      "display" : "Medical Radiation Technologist",
      "definition" : "Medical Radiation Technologist"
    },
    {
      "code" : "3133.019",
      "display" : "Medical Xray Technician",
      "definition" : "Medical Xray Technician"
    },
    {
      "code" : "3133.020",
      "display" : "MRT",
      "definition" : "MRT"
    },
    {
      "code" : "3133.021",
      "display" : "Neurophysiology Technician",
      "definition" : "Neurophysiology Technician"
    },
    {
      "code" : "3133.022",
      "display" : "Neurosciences Research Technician",
      "definition" : "Neurosciences Research Technician"
    },
    {
      "code" : "3133.023",
      "display" : "Nuclear Medicine Technologist",
      "definition" : "Nuclear Medicine Technologist"
    },
    {
      "code" : "3133.024",
      "display" : "Nuclear Radiographer",
      "definition" : "Nuclear Radiographer"
    },
    {
      "code" : "3133.025",
      "display" : "Other Medical Equipment Controller",
      "definition" : "Other Medical Equipment Controller"
    },
    {
      "code" : "3133.026",
      "display" : "Quality Controller Of Other Medical Equipment Controllers",
      "definition" : "Quality Controller Of Other Medical Equipment Controllers"
    },
    {
      "code" : "3133.027",
      "display" : "Quality Controller Of Radiographers",
      "definition" : "Quality Controller Of Radiographers"
    },
    {
      "code" : "3133.028",
      "display" : "Radiochemist",
      "definition" : "Radiochemist"
    },
    {
      "code" : "3133.029",
      "display" : "Radiographer",
      "definition" : "Radiographer"
    },
    {
      "code" : "3133.030",
      "display" : "Radioisotope Technician",
      "definition" : "Radioisotope Technician"
    },
    {
      "code" : "3133.031",
      "display" : "Radioisotope Technologist",
      "definition" : "Radioisotope Technologist"
    },
    {
      "code" : "3133.032",
      "display" : "Sonographer",
      "definition" : "Sonographer"
    },
    {
      "code" : "3133.033",
      "display" : "Therapeutic Radiographer",
      "definition" : "Therapeutic Radiographer"
    },
    {
      "code" : "3133.034",
      "display" : "Ultrasonographer",
      "definition" : "Ultrasonographer"
    },
    {
      "code" : "3133.035",
      "display" : "Xray Darkroom Technician",
      "definition" : "Xray Darkroom Technician"
    },
    {
      "code" : "3133.036",
      "display" : "Xray Operator",
      "definition" : "Xray Operator"
    },
    {
      "code" : "3141.001",
      "display" : "Chief Engineer Ship",
      "definition" : "Chief Engineer Ship"
    },
    {
      "code" : "3141.002",
      "display" : "Marine Engineer Ships",
      "definition" : "Marine Engineer Ships"
    },
    {
      "code" : "3141.003",
      "display" : "Ships Engineer",
      "definition" : "Ships Engineer"
    },
    {
      "code" : "3142.001",
      "display" : "Boatswain",
      "definition" : "Boatswain"
    },
    {
      "code" : "3142.002",
      "display" : "Bosun",
      "definition" : "Bosun"
    },
    {
      "code" : "3142.003",
      "display" : "Deck Officer Master",
      "definition" : "Deck Officer Master"
    },
    {
      "code" : "3142.004",
      "display" : "Dockmaster",
      "definition" : "Dockmaster"
    },
    {
      "code" : "3142.005",
      "display" : "Dredge Master",
      "definition" : "Dredge Master"
    },
    {
      "code" : "3142.006",
      "display" : "Harbour Master",
      "definition" : "Harbour Master"
    },
    {
      "code" : "3142.007",
      "display" : "Harbour Pilot",
      "definition" : "Harbour Pilot"
    },
    {
      "code" : "3142.008",
      "display" : "Hovercraft Operator",
      "definition" : "Hovercraft Operator"
    },
    {
      "code" : "3142.009",
      "display" : "Launch Master",
      "definition" : "Launch Master"
    },
    {
      "code" : "3142.010",
      "display" : "Master Mariner",
      "definition" : "Master Mariner"
    },
    {
      "code" : "3142.011",
      "display" : "Other Ships Deck Officer and Pilot",
      "definition" : "Other Ships Deck Officer and Pilot"
    },
    {
      "code" : "3142.012",
      "display" : "Ships Captain",
      "definition" : "Ships Captain"
    },
    {
      "code" : "3142.013",
      "display" : "Ships Master",
      "definition" : "Ships Master"
    },
    {
      "code" : "3142.014",
      "display" : "Ships Mate",
      "definition" : "Ships Mate"
    },
    {
      "code" : "3142.015",
      "display" : "Ships Navigating Officer",
      "definition" : "Ships Navigating Officer"
    },
    {
      "code" : "3142.016",
      "display" : "Ships Officer (Deck) Including Master",
      "definition" : "Ships Officer (Deck) Including Master"
    },
    {
      "code" : "3142.017",
      "display" : "Ships Officer Deck",
      "definition" : "Ships Officer Deck"
    },
    {
      "code" : "3142.018",
      "display" : "Ships Pilot",
      "definition" : "Ships Pilot"
    },
    {
      "code" : "3142.019",
      "display" : "Tug Master",
      "definition" : "Tug Master"
    },
    {
      "code" : "3143.001",
      "display" : "Aerial Spraying Contractor",
      "definition" : "Aerial Spraying Contractor"
    },
    {
      "code" : "3143.002",
      "display" : "Aerial Topdressing Contractor",
      "definition" : "Aerial Topdressing Contractor"
    },
    {
      "code" : "3143.003",
      "display" : "Aeroplane Pilot",
      "definition" : "Aeroplane Pilot"
    },
    {
      "code" : "3143.004",
      "display" : "Aeroplane Pilot and Flight Crew",
      "definition" : "Aeroplane Pilot and Flight Crew"
    },
    {
      "code" : "3143.005",
      "display" : "Agricultural Aeroplane Pilot",
      "definition" : "Agricultural Aeroplane Pilot"
    },
    {
      "code" : "3143.006",
      "display" : "Agricultural Topdressing Pilot",
      "definition" : "Agricultural Topdressing Pilot"
    },
    {
      "code" : "3143.007",
      "display" : "Agriculture Aeroplane Pilot",
      "definition" : "Agriculture Aeroplane Pilot"
    },
    {
      "code" : "3143.008",
      "display" : "Air Crew",
      "definition" : "Air Crew"
    },
    {
      "code" : "3143.009",
      "display" : "Air Transport Pilot",
      "definition" : "Air Transport Pilot"
    },
    {
      "code" : "3143.010",
      "display" : "Aircraft Captain",
      "definition" : "Aircraft Captain"
    },
    {
      "code" : "3143.011",
      "display" : "Aircraft Flight Engineer",
      "definition" : "Aircraft Flight Engineer"
    },
    {
      "code" : "3143.012",
      "display" : "Aircraft Navigator",
      "definition" : "Aircraft Navigator"
    },
    {
      "code" : "3143.013",
      "display" : "Aircraft Pilot",
      "definition" : "Aircraft Pilot"
    },
    {
      "code" : "3143.014",
      "display" : "Airline Captain",
      "definition" : "Airline Captain"
    },
    {
      "code" : "3143.015",
      "display" : "Airline Copilot",
      "definition" : "Airline Copilot"
    },
    {
      "code" : "3143.016",
      "display" : "Airline Pilot",
      "definition" : "Airline Pilot"
    },
    {
      "code" : "3143.017",
      "display" : "Balloonist Professional",
      "definition" : "Balloonist Professional"
    },
    {
      "code" : "3143.018",
      "display" : "Chopper Pilot",
      "definition" : "Chopper Pilot"
    },
    {
      "code" : "3143.019",
      "display" : "Commercial Pilot",
      "definition" : "Commercial Pilot"
    },
    {
      "code" : "3143.020",
      "display" : "Flight Crew",
      "definition" : "Flight Crew"
    },
    {
      "code" : "3143.021",
      "display" : "Flight Engineer",
      "definition" : "Flight Engineer"
    },
    {
      "code" : "3143.022",
      "display" : "Flight Instructor",
      "definition" : "Flight Instructor"
    },
    {
      "code" : "3143.023",
      "display" : "Flight Navigator",
      "definition" : "Flight Navigator"
    },
    {
      "code" : "3143.024",
      "display" : "Flight Simulator Instructor",
      "definition" : "Flight Simulator Instructor"
    },
    {
      "code" : "3143.025",
      "display" : "Flying Instructor",
      "definition" : "Flying Instructor"
    },
    {
      "code" : "3143.026",
      "display" : "Flying Instructor and Examiner",
      "definition" : "Flying Instructor and Examiner"
    },
    {
      "code" : "3143.027",
      "display" : "Helicopter Pilot",
      "definition" : "Helicopter Pilot"
    },
    {
      "code" : "3143.028",
      "display" : "Search & Rescue Helicopter Pilot",
      "definition" : "Search & Rescue Helicopter Pilot"
    },
    {
      "code" : "3143.029",
      "display" : "Top Dressing Pilot",
      "definition" : "Top Dressing Pilot"
    },
    {
      "code" : "3144.001",
      "display" : "Aerodrome Controller",
      "definition" : "Aerodrome Controller"
    },
    {
      "code" : "3144.002",
      "display" : "Air Traffic Controller",
      "definition" : "Air Traffic Controller"
    },
    {
      "code" : "3144.003",
      "display" : "Air Traffic Service Operator",
      "definition" : "Air Traffic Service Operator"
    },
    {
      "code" : "3144.004",
      "display" : "Airline Movements Control Officer",
      "definition" : "Airline Movements Control Officer"
    },
    {
      "code" : "3151.001",
      "display" : "Accident Prevention Safety Inspector",
      "definition" : "Accident Prevention Safety Inspector"
    },
    {
      "code" : "3151.002",
      "display" : "Agricultural Inspector",
      "definition" : "Agricultural Inspector"
    },
    {
      "code" : "3151.003",
      "display" : "Agricultural Instructor",
      "definition" : "Agricultural Instructor"
    },
    {
      "code" : "3151.004",
      "display" : "Agricultural Veterinary Inspector",
      "definition" : "Agricultural Veterinary Inspector"
    },
    {
      "code" : "3151.005",
      "display" : "Agriculture Inspector",
      "definition" : "Agriculture Inspector"
    },
    {
      "code" : "3151.006",
      "display" : "Air Accident Inspector",
      "definition" : "Air Accident Inspector"
    },
    {
      "code" : "3151.007",
      "display" : "Animal Health Officer",
      "definition" : "Animal Health Officer"
    },
    {
      "code" : "3151.008",
      "display" : "Bridge Inspector",
      "definition" : "Bridge Inspector"
    },
    {
      "code" : "3151.009",
      "display" : "Building Inspector",
      "definition" : "Building Inspector"
    },
    {
      "code" : "3151.010",
      "display" : "Building Site Inspector",
      "definition" : "Building Site Inspector"
    },
    {
      "code" : "3151.011",
      "display" : "Construction Inspector",
      "definition" : "Construction Inspector"
    },
    {
      "code" : "3151.012",
      "display" : "Electrical Inspector Construction",
      "definition" : "Electrical Inspector Construction"
    },
    {
      "code" : "3151.013",
      "display" : "Environmental Health Officer",
      "definition" : "Environmental Health Officer"
    },
    {
      "code" : "3151.014",
      "display" : "Explosives Inspector",
      "definition" : "Explosives Inspector"
    },
    {
      "code" : "3151.015",
      "display" : "Factory Inspector",
      "definition" : "Factory Inspector"
    },
    {
      "code" : "3151.016",
      "display" : "Farm Inspector",
      "definition" : "Farm Inspector"
    },
    {
      "code" : "3151.017",
      "display" : "Farm Instructor",
      "definition" : "Farm Instructor"
    },
    {
      "code" : "3151.018",
      "display" : "Fisheries Inspector",
      "definition" : "Fisheries Inspector"
    },
    {
      "code" : "3151.019",
      "display" : "Fisheries Officer",
      "definition" : "Fisheries Officer"
    },
    {
      "code" : "3151.020",
      "display" : "Fisheries Surveillance Officer",
      "definition" : "Fisheries Surveillance Officer"
    },
    {
      "code" : "3151.021",
      "display" : "Fishery Officer",
      "definition" : "Fishery Officer"
    },
    {
      "code" : "3151.022",
      "display" : "Forestry Inspector",
      "definition" : "Forestry Inspector"
    },
    {
      "code" : "3151.023",
      "display" : "Foundry Inspector",
      "definition" : "Foundry Inspector"
    },
    {
      "code" : "3151.024",
      "display" : "Health and Safety Inspector",
      "definition" : "Health and Safety Inspector"
    },
    {
      "code" : "3151.025",
      "display" : "Health Education Officer",
      "definition" : "Health Education Officer"
    },
    {
      "code" : "3151.026",
      "display" : "Health Inspector",
      "definition" : "Health Inspector"
    },
    {
      "code" : "3151.027",
      "display" : "Horticultural Inspector",
      "definition" : "Horticultural Inspector"
    },
    {
      "code" : "3151.028",
      "display" : "Housing Inspector",
      "definition" : "Housing Inspector"
    },
    {
      "code" : "3151.029",
      "display" : "Hygiene Officer Freezing Works",
      "definition" : "Hygiene Officer Freezing Works"
    },
    {
      "code" : "3151.030",
      "display" : "Industrial Safety Officer",
      "definition" : "Industrial Safety Officer"
    },
    {
      "code" : "3151.031",
      "display" : "Licensed Premises Inspector",
      "definition" : "Licensed Premises Inspector"
    },
    {
      "code" : "3151.032",
      "display" : "Lighthouse Inspector",
      "definition" : "Lighthouse Inspector"
    },
    {
      "code" : "3151.033",
      "display" : "Livestock Inspector",
      "definition" : "Livestock Inspector"
    },
    {
      "code" : "3151.034",
      "display" : "Livestock Instructor",
      "definition" : "Livestock Instructor"
    },
    {
      "code" : "3151.035",
      "display" : "Meat Inspector",
      "definition" : "Meat Inspector"
    },
    {
      "code" : "3151.036",
      "display" : "Meat Inspector Meat Products",
      "definition" : "Meat Inspector Meat Products"
    },
    {
      "code" : "3151.037",
      "display" : "Meat Inspector Veterinary",
      "definition" : "Meat Inspector Veterinary"
    },
    {
      "code" : "3151.038",
      "display" : "Noxious Animals Officer",
      "definition" : "Noxious Animals Officer"
    },
    {
      "code" : "3151.039",
      "display" : "Noxious Plants Officer",
      "definition" : "Noxious Plants Officer"
    },
    {
      "code" : "3151.040",
      "display" : "Noxious Weeds and Pests Inspector",
      "definition" : "Noxious Weeds and Pests Inspector"
    },
    {
      "code" : "3151.041",
      "display" : "Occupational Safety Inspector",
      "definition" : "Occupational Safety Inspector"
    },
    {
      "code" : "3151.042",
      "display" : "Pest and Weed Control Officer",
      "definition" : "Pest and Weed Control Officer"
    },
    {
      "code" : "3151.043",
      "display" : "Pest Destruction Technical Advisor",
      "definition" : "Pest Destruction Technical Advisor"
    },
    {
      "code" : "3151.044",
      "display" : "Pest Inspector",
      "definition" : "Pest Inspector"
    },
    {
      "code" : "3151.045",
      "display" : "Pest Management Officer",
      "definition" : "Pest Management Officer"
    },
    {
      "code" : "3151.046",
      "display" : "Port Safety Officer",
      "definition" : "Port Safety Officer"
    },
    {
      "code" : "3151.047",
      "display" : "Poultry Inspector",
      "definition" : "Poultry Inspector"
    },
    {
      "code" : "3151.048",
      "display" : "Poultry Instructor",
      "definition" : "Poultry Instructor"
    },
    {
      "code" : "3151.049",
      "display" : "Public Health Officer",
      "definition" : "Public Health Officer"
    },
    {
      "code" : "3151.050",
      "display" : "Quality Controller Of Agricultural Regulatory Inspectors",
      "definition" : "Quality Controller Of Agricultural Regulatory Inspectors"
    },
    {
      "code" : "3151.051",
      "display" : "Quality Controller Of Health Regulatory Inspectors",
      "definition" : "Quality Controller Of Health Regulatory Inspectors"
    },
    {
      "code" : "3151.052",
      "display" : "Quality Controller Of Meat Regulatory Inspectors",
      "definition" : "Quality Controller Of Meat Regulatory Inspectors"
    },
    {
      "code" : "3151.053",
      "display" : "Quality Controller of Safety Regulations",
      "definition" : "Quality Controller of Safety Regulations"
    },
    {
      "code" : "3151.054",
      "display" : "Quality Inspector",
      "definition" : "Quality Inspector"
    },
    {
      "code" : "3151.055",
      "display" : "Road Bridge Inspector",
      "definition" : "Road Bridge Inspector"
    },
    {
      "code" : "3151.056",
      "display" : "Safety Inspector",
      "definition" : "Safety Inspector"
    },
    {
      "code" : "3151.057",
      "display" : "Sanitary Inspector",
      "definition" : "Sanitary Inspector"
    },
    {
      "code" : "3151.058",
      "display" : "Scaffolding Inspector",
      "definition" : "Scaffolding Inspector"
    },
    {
      "code" : "3151.059",
      "display" : "SPCA Inspector",
      "definition" : "SPCA Inspector"
    },
    {
      "code" : "3151.060",
      "display" : "Works Inspector",
      "definition" : "Works Inspector"
    },
    {
      "code" : "3211.001",
      "display" : "Artificial Inseminator",
      "definition" : "Artificial Inseminator"
    },
    {
      "code" : "3211.002",
      "display" : "Biochemistry Technician",
      "definition" : "Biochemistry Technician"
    },
    {
      "code" : "3211.003",
      "display" : "Biological Technician",
      "definition" : "Biological Technician"
    },
    {
      "code" : "3211.004",
      "display" : "Biology Technician",
      "definition" : "Biology Technician"
    },
    {
      "code" : "3211.005",
      "display" : "Botanical Technician",
      "definition" : "Botanical Technician"
    },
    {
      "code" : "3211.006",
      "display" : "Ecology Technician",
      "definition" : "Ecology Technician"
    },
    {
      "code" : "3211.007",
      "display" : "Environmental Technician",
      "definition" : "Environmental Technician"
    },
    {
      "code" : "3211.008",
      "display" : "Haematology Technician",
      "definition" : "Haematology Technician"
    },
    {
      "code" : "3211.009",
      "display" : "Hospital Laboratory Technician",
      "definition" : "Hospital Laboratory Technician"
    },
    {
      "code" : "3211.010",
      "display" : "Hospital Research Laboratory Technician",
      "definition" : "Hospital Research Laboratory Technician"
    },
    {
      "code" : "3211.011",
      "display" : "Life Science Technician",
      "definition" : "Life Science Technician"
    },
    {
      "code" : "3211.012",
      "display" : "Life Sciences Laboratory Technician",
      "definition" : "Life Sciences Laboratory Technician"
    },
    {
      "code" : "3211.013",
      "display" : "Maxillo Facial Technician",
      "definition" : "Maxillo Facial Technician"
    },
    {
      "code" : "3211.014",
      "display" : "Meatworks Laboratory Technician",
      "definition" : "Meatworks Laboratory Technician"
    },
    {
      "code" : "3211.015",
      "display" : "Meatworks Technologist",
      "definition" : "Meatworks Technologist"
    },
    {
      "code" : "3211.016",
      "display" : "Medical Bloodbank Technician",
      "definition" : "Medical Bloodbank Technician"
    },
    {
      "code" : "3211.017",
      "display" : "Medical Laboratory Assistant",
      "definition" : "Medical Laboratory Assistant"
    },
    {
      "code" : "3211.018",
      "display" : "Medical Laboratory Technician",
      "definition" : "Medical Laboratory Technician"
    },
    {
      "code" : "3211.019",
      "display" : "Medical Laboratory Technologist",
      "definition" : "Medical Laboratory Technologist"
    },
    {
      "code" : "3211.020",
      "display" : "Medical Research Officer",
      "definition" : "Medical Research Officer"
    },
    {
      "code" : "3211.021",
      "display" : "Medical Science Technician",
      "definition" : "Medical Science Technician"
    },
    {
      "code" : "3211.022",
      "display" : "Naturalist",
      "definition" : "Naturalist"
    },
    {
      "code" : "3211.023",
      "display" : "Phlebotomist",
      "definition" : "Phlebotomist"
    },
    {
      "code" : "3211.024",
      "display" : "Quality Controller Of Life Science Technicians",
      "definition" : "Quality Controller Of Life Science Technicians"
    },
    {
      "code" : "3211.025",
      "display" : "Taxidermist",
      "definition" : "Taxidermist"
    },
    {
      "code" : "3211.026",
      "display" : "Venepuncturist",
      "definition" : "Venepuncturist"
    },
    {
      "code" : "3211.027",
      "display" : "Veterinary Laboratory Technician",
      "definition" : "Veterinary Laboratory Technician"
    },
    {
      "code" : "3211.028",
      "display" : "Veterinary Technician",
      "definition" : "Veterinary Technician"
    },
    {
      "code" : "3211.029",
      "display" : "Water and Soil Technician",
      "definition" : "Water and Soil Technician"
    },
    {
      "code" : "3212.001",
      "display" : "Agricultural Research Technician",
      "definition" : "Agricultural Research Technician"
    },
    {
      "code" : "3212.002",
      "display" : "Agricultural Technician",
      "definition" : "Agricultural Technician"
    },
    {
      "code" : "3212.003",
      "display" : "Agronomy Technician",
      "definition" : "Agronomy Technician"
    },
    {
      "code" : "3212.004",
      "display" : "Animal Agricultural Technician",
      "definition" : "Animal Agricultural Technician"
    },
    {
      "code" : "3212.005",
      "display" : "Animal Breeding Technician",
      "definition" : "Animal Breeding Technician"
    },
    {
      "code" : "3212.006",
      "display" : "Animal Technician",
      "definition" : "Animal Technician"
    },
    {
      "code" : "3212.007",
      "display" : "Botany Technician",
      "definition" : "Botany Technician"
    },
    {
      "code" : "3212.008",
      "display" : "Forest Products Development Technician",
      "definition" : "Forest Products Development Technician"
    },
    {
      "code" : "3212.009",
      "display" : "Forest Technical Officer",
      "definition" : "Forest Technical Officer"
    },
    {
      "code" : "3212.010",
      "display" : "Forest Technician",
      "definition" : "Forest Technician"
    },
    {
      "code" : "3212.011",
      "display" : "Forest Technician Observer",
      "definition" : "Forest Technician Observer"
    },
    {
      "code" : "3212.012",
      "display" : "Forestry Science Technician",
      "definition" : "Forestry Science Technician"
    },
    {
      "code" : "3212.013",
      "display" : "Forestry Technician",
      "definition" : "Forestry Technician"
    },
    {
      "code" : "3212.014",
      "display" : "Laboratory Seed Grader",
      "definition" : "Laboratory Seed Grader"
    },
    {
      "code" : "3212.015",
      "display" : "Laboratory Seed Tester",
      "definition" : "Laboratory Seed Tester"
    },
    {
      "code" : "3212.016",
      "display" : "Parks and Reserve Technical Officer",
      "definition" : "Parks and Reserve Technical Officer"
    },
    {
      "code" : "3212.017",
      "display" : "Plant Research Laboratory Technician",
      "definition" : "Plant Research Laboratory Technician"
    },
    {
      "code" : "3212.018",
      "display" : "Quality Controller Of Agricultural Technicians",
      "definition" : "Quality Controller Of Agricultural Technicians"
    },
    {
      "code" : "3212.019",
      "display" : "Quality Controller Of Forest Technicians",
      "definition" : "Quality Controller Of Forest Technicians"
    },
    {
      "code" : "3212.020",
      "display" : "Seed Analyst",
      "definition" : "Seed Analyst"
    },
    {
      "code" : "3212.021",
      "display" : "Seed Certificate Technician",
      "definition" : "Seed Certificate Technician"
    },
    {
      "code" : "3212.022",
      "display" : "Soil Mechanic Technician",
      "definition" : "Soil Mechanic Technician"
    },
    {
      "code" : "3212.023",
      "display" : "Test Baker Wheat Research",
      "definition" : "Test Baker Wheat Research"
    },
    {
      "code" : "3221.001",
      "display" : "Dispensing Optician",
      "definition" : "Dispensing Optician"
    },
    {
      "code" : "3221.002",
      "display" : "Optical Assistant",
      "definition" : "Optical Assistant"
    },
    {
      "code" : "3221.003",
      "display" : "Optical Dispenser",
      "definition" : "Optical Dispenser"
    },
    {
      "code" : "3221.004",
      "display" : "Spectacles Dispenser",
      "definition" : "Spectacles Dispenser"
    },
    {
      "code" : "3222.001",
      "display" : "Dental Attendant",
      "definition" : "Dental Attendant"
    },
    {
      "code" : "3222.002",
      "display" : "Dental Health Advisor",
      "definition" : "Dental Health Advisor"
    },
    {
      "code" : "3222.003",
      "display" : "Dental Hygienist",
      "definition" : "Dental Hygienist"
    },
    {
      "code" : "3222.004",
      "display" : "Dental Therapist",
      "definition" : "Dental Therapist"
    },
    {
      "code" : "3222.005",
      "display" : "Dental Tutor Sister",
      "definition" : "Dental Tutor Sister"
    },
    {
      "code" : "3222.006",
      "display" : "Gum Therapist",
      "definition" : "Gum Therapist"
    },
    {
      "code" : "3222.007",
      "display" : "Oral Hygienist",
      "definition" : "Oral Hygienist"
    },
    {
      "code" : "3222.008",
      "display" : "School Dental Nurse",
      "definition" : "School Dental Nurse"
    },
    {
      "code" : "3223.001",
      "display" : "Artificial Limb Fitter Technician",
      "definition" : "Artificial Limb Fitter Technician"
    },
    {
      "code" : "3223.002",
      "display" : "Artificial Limb Maker",
      "definition" : "Artificial Limb Maker"
    },
    {
      "code" : "3223.003",
      "display" : "Back or Spine Manipulation Specialist",
      "definition" : "Back or Spine Manipulation Specialist"
    },
    {
      "code" : "3223.004",
      "display" : "Chiropodist",
      "definition" : "Chiropodist"
    },
    {
      "code" : "3223.005",
      "display" : "Chiropractor",
      "definition" : "Chiropractor"
    },
    {
      "code" : "3223.006",
      "display" : "Clincial Orthotist",
      "definition" : "Clincial Orthotist"
    },
    {
      "code" : "3223.007",
      "display" : "Ergotherapist",
      "definition" : "Ergotherapist"
    },
    {
      "code" : "3223.008",
      "display" : "Manipulation Therapist",
      "definition" : "Manipulation Therapist"
    },
    {
      "code" : "3223.009",
      "display" : "Occupational Therapist",
      "definition" : "Occupational Therapist"
    },
    {
      "code" : "3223.010",
      "display" : "Occupational Therapy Assistant",
      "definition" : "Occupational Therapy Assistant"
    },
    {
      "code" : "3223.011",
      "display" : "Occupational Therapy Teacher",
      "definition" : "Occupational Therapy Teacher"
    },
    {
      "code" : "3223.012",
      "display" : "Orthopaedic Appliance Maker",
      "definition" : "Orthopaedic Appliance Maker"
    },
    {
      "code" : "3223.013",
      "display" : "Orthopaedic Appliances Repairer",
      "definition" : "Orthopaedic Appliances Repairer"
    },
    {
      "code" : "3223.014",
      "display" : "Orthopaedic Footwear Maker",
      "definition" : "Orthopaedic Footwear Maker"
    },
    {
      "code" : "3223.015",
      "display" : "Orthopaedic Technician",
      "definition" : "Orthopaedic Technician"
    },
    {
      "code" : "3223.016",
      "display" : "Orthotist",
      "definition" : "Orthotist"
    },
    {
      "code" : "3223.017",
      "display" : "Orthotist Technician",
      "definition" : "Orthotist Technician"
    },
    {
      "code" : "3223.018",
      "display" : "Orthotist Tradesman",
      "definition" : "Orthotist Tradesman"
    },
    {
      "code" : "3223.019",
      "display" : "Osteopath",
      "definition" : "Osteopath"
    },
    {
      "code" : "3223.020",
      "display" : "Physical Therapist",
      "definition" : "Physical Therapist"
    },
    {
      "code" : "3223.021",
      "display" : "Physiotherapist",
      "definition" : "Physiotherapist"
    },
    {
      "code" : "3223.022",
      "display" : "Podiatrist",
      "definition" : "Podiatrist"
    },
    {
      "code" : "3223.023",
      "display" : "Prosthetist",
      "definition" : "Prosthetist"
    },
    {
      "code" : "3223.024",
      "display" : "Recreation Therapist",
      "definition" : "Recreation Therapist"
    },
    {
      "code" : "3223.025",
      "display" : "Spinal Health Specialist",
      "definition" : "Spinal Health Specialist"
    },
    {
      "code" : "3223.026",
      "display" : "Vocational Therapist",
      "definition" : "Vocational Therapist"
    },
    {
      "code" : "3223.027",
      "display" : "Work Rehabilitation Therapist",
      "definition" : "Work Rehabilitation Therapist"
    },
    {
      "code" : "3224.001",
      "display" : "Animal Attendant Vaccine Laboratory",
      "definition" : "Animal Attendant Vaccine Laboratory"
    },
    {
      "code" : "3224.002",
      "display" : "Animal Health Nurse",
      "definition" : "Animal Health Nurse"
    },
    {
      "code" : "3224.003",
      "display" : "Brucellosis Testing Assistant",
      "definition" : "Brucellosis Testing Assistant"
    },
    {
      "code" : "3224.004",
      "display" : "Herd Testing Technician",
      "definition" : "Herd Testing Technician"
    },
    {
      "code" : "3224.005",
      "display" : "Veterinary Assistant",
      "definition" : "Veterinary Assistant"
    },
    {
      "code" : "3224.006",
      "display" : "Veterinary Nurse",
      "definition" : "Veterinary Nurse"
    },
    {
      "code" : "3224.007",
      "display" : "Veterinary Receptionist",
      "definition" : "Veterinary Receptionist"
    },
    {
      "code" : "3225.001",
      "display" : "Community Pharmacy Technician",
      "definition" : "Community Pharmacy Technician"
    },
    {
      "code" : "3225.002",
      "display" : "Dispenser Pharmaceutical Hospital",
      "definition" : "Dispenser Pharmaceutical Hospital"
    },
    {
      "code" : "3225.003",
      "display" : "Dispenser Pharmaceutical Retail",
      "definition" : "Dispenser Pharmaceutical Retail"
    },
    {
      "code" : "3225.004",
      "display" : "Hospital Dispensary Assistant",
      "definition" : "Hospital Dispensary Assistant"
    },
    {
      "code" : "3225.005",
      "display" : "Hospital Pharmacy Assistant",
      "definition" : "Hospital Pharmacy Assistant"
    },
    {
      "code" : "3225.006",
      "display" : "Pharmacy Dispensing Technician",
      "definition" : "Pharmacy Dispensing Technician"
    },
    {
      "code" : "3225.007",
      "display" : "Retail Dispensary Assistant",
      "definition" : "Retail Dispensary Assistant"
    },
    {
      "code" : "3226.001",
      "display" : "Acupuncturist",
      "definition" : "Acupuncturist"
    },
    {
      "code" : "3226.002",
      "display" : "Alternative Health Practitioner",
      "definition" : "Alternative Health Practitioner"
    },
    {
      "code" : "3226.003",
      "display" : "Aromatherapist",
      "definition" : "Aromatherapist"
    },
    {
      "code" : "3226.004",
      "display" : "Audio Vision Tester",
      "definition" : "Audio Vision Tester"
    },
    {
      "code" : "3226.005",
      "display" : "Audiologist",
      "definition" : "Audiologist"
    },
    {
      "code" : "3226.006",
      "display" : "Chinese Medicine Practitioner",
      "definition" : "Chinese Medicine Practitioner"
    },
    {
      "code" : "3226.007",
      "display" : "Dental Ceramicist",
      "definition" : "Dental Ceramicist"
    },
    {
      "code" : "3226.008",
      "display" : "Dental Form Caster",
      "definition" : "Dental Form Caster"
    },
    {
      "code" : "3226.009",
      "display" : "Dental Laboratory Technician",
      "definition" : "Dental Laboratory Technician"
    },
    {
      "code" : "3226.010",
      "display" : "Dental Mechanic Technician",
      "definition" : "Dental Mechanic Technician"
    },
    {
      "code" : "3226.011",
      "display" : "Dental Prothesis Maker Repairer",
      "definition" : "Dental Prothesis Maker Repairer"
    },
    {
      "code" : "3226.012",
      "display" : "Dental Technician",
      "definition" : "Dental Technician"
    },
    {
      "code" : "3226.013",
      "display" : "Dental Technologist",
      "definition" : "Dental Technologist"
    },
    {
      "code" : "3226.014",
      "display" : "Diversional Therapist",
      "definition" : "Diversional Therapist"
    },
    {
      "code" : "3226.015",
      "display" : "Family Planning Advisor",
      "definition" : "Family Planning Advisor"
    },
    {
      "code" : "3226.016",
      "display" : "Health Needs Assessor",
      "definition" : "Health Needs Assessor"
    },
    {
      "code" : "3226.017",
      "display" : "Hearing Aid Fitter",
      "definition" : "Hearing Aid Fitter"
    },
    {
      "code" : "3226.018",
      "display" : "Herbalist",
      "definition" : "Herbalist"
    },
    {
      "code" : "3226.019",
      "display" : "Holistic Massage Therapist",
      "definition" : "Holistic Massage Therapist"
    },
    {
      "code" : "3226.020",
      "display" : "Homeopath",
      "definition" : "Homeopath"
    },
    {
      "code" : "3226.021",
      "display" : "Hydrotherapist",
      "definition" : "Hydrotherapist"
    },
    {
      "code" : "3226.022",
      "display" : "Hypnotherapist",
      "definition" : "Hypnotherapist"
    },
    {
      "code" : "3226.023",
      "display" : "Iridologist",
      "definition" : "Iridologist"
    },
    {
      "code" : "3226.024",
      "display" : "Medical Assistant",
      "definition" : "Medical Assistant"
    },
    {
      "code" : "3226.025",
      "display" : "Medical Herbalist",
      "definition" : "Medical Herbalist"
    },
    {
      "code" : "3226.026",
      "display" : "Natural Health Therapist",
      "definition" : "Natural Health Therapist"
    },
    {
      "code" : "3226.027",
      "display" : "Naturopath",
      "definition" : "Naturopath"
    },
    {
      "code" : "3226.028",
      "display" : "Other Health Associate Professional",
      "definition" : "Other Health Associate Professional"
    },
    {
      "code" : "3226.029",
      "display" : "Reflexologist",
      "definition" : "Reflexologist"
    },
    {
      "code" : "3226.030",
      "display" : "Vision and Hearing Tester",
      "definition" : "Vision and Hearing Tester"
    },
    {
      "code" : "3231.001",
      "display" : "Community Nurse",
      "definition" : "Community Nurse"
    },
    {
      "code" : "3231.002",
      "display" : "Comprehensive Nurse Trainee",
      "definition" : "Comprehensive Nurse Trainee"
    },
    {
      "code" : "3231.003",
      "display" : "Enrolled Nurse",
      "definition" : "Enrolled Nurse"
    },
    {
      "code" : "3231.004",
      "display" : "Health Camp Nurse",
      "definition" : "Health Camp Nurse"
    },
    {
      "code" : "3231.005",
      "display" : "Kaimahi Whakawhaanau",
      "definition" : "Kaimahi Whakawhaanau"
    },
    {
      "code" : "3231.006",
      "display" : "Karitane Nurse",
      "definition" : "Karitane Nurse"
    },
    {
      "code" : "3231.007",
      "display" : "Physiotherapy Nurse",
      "definition" : "Physiotherapy Nurse"
    },
    {
      "code" : "3231.008",
      "display" : "Psychiatric Assistant",
      "definition" : "Psychiatric Assistant"
    },
    {
      "code" : "3231.009",
      "display" : "Unregistered Mental Hospital Nurse",
      "definition" : "Unregistered Mental Hospital Nurse"
    },
    {
      "code" : "3231.010",
      "display" : "Unregistered Nurse Male or Female",
      "definition" : "Unregistered Nurse Male or Female"
    },
    {
      "code" : "3231.011",
      "display" : "Unregistered Private Nurse",
      "definition" : "Unregistered Private Nurse"
    },
    {
      "code" : "3231.012",
      "display" : "Unregistered Psychiatric Nurse",
      "definition" : "Unregistered Psychiatric Nurse"
    },
    {
      "code" : "3311.001",
      "display" : "Assurance Broker",
      "definition" : "Assurance Broker"
    },
    {
      "code" : "3311.002",
      "display" : "Bond Salesman",
      "definition" : "Bond Salesman"
    },
    {
      "code" : "3311.003",
      "display" : "Broker Stocks and Shares",
      "definition" : "Broker Stocks and Shares"
    },
    {
      "code" : "3311.004",
      "display" : "Building Society Salesman",
      "definition" : "Building Society Salesman"
    },
    {
      "code" : "3311.005",
      "display" : "Commodity Broker",
      "definition" : "Commodity Broker"
    },
    {
      "code" : "3311.006",
      "display" : "Equity Dealer",
      "definition" : "Equity Dealer"
    },
    {
      "code" : "3311.007",
      "display" : "Finance Broker",
      "definition" : "Finance Broker"
    },
    {
      "code" : "3311.008",
      "display" : "Financial Agent",
      "definition" : "Financial Agent"
    },
    {
      "code" : "3311.009",
      "display" : "Financial Dealer",
      "definition" : "Financial Dealer"
    },
    {
      "code" : "3311.010",
      "display" : "Futures Manager",
      "definition" : "Futures Manager"
    },
    {
      "code" : "3311.011",
      "display" : "Futures Salesman",
      "definition" : "Futures Salesman"
    },
    {
      "code" : "3311.012",
      "display" : "Insurance Broker",
      "definition" : "Insurance Broker"
    },
    {
      "code" : "3311.013",
      "display" : "Life Insurance Broker",
      "definition" : "Life Insurance Broker"
    },
    {
      "code" : "3311.014",
      "display" : "Money Marketer",
      "definition" : "Money Marketer"
    },
    {
      "code" : "3311.015",
      "display" : "Securities Dealer",
      "definition" : "Securities Dealer"
    },
    {
      "code" : "3311.016",
      "display" : "Securities Salesman",
      "definition" : "Securities Salesman"
    },
    {
      "code" : "3311.017",
      "display" : "Share Advisor",
      "definition" : "Share Advisor"
    },
    {
      "code" : "3311.018",
      "display" : "Share Registrar",
      "definition" : "Share Registrar"
    },
    {
      "code" : "3311.019",
      "display" : "Sharebroker",
      "definition" : "Sharebroker"
    },
    {
      "code" : "3311.020",
      "display" : "Stockbroker",
      "definition" : "Stockbroker"
    },
    {
      "code" : "3312.001",
      "display" : "ACC Assessor",
      "definition" : "ACC Assessor"
    },
    {
      "code" : "3312.002",
      "display" : "Accident Claims Officer",
      "definition" : "Accident Claims Officer"
    },
    {
      "code" : "3312.003",
      "display" : "Accident Compensation Assessor",
      "definition" : "Accident Compensation Assessor"
    },
    {
      "code" : "3312.004",
      "display" : "Apihaa Inihua",
      "definition" : "Apihaa Inihua"
    },
    {
      "code" : "3312.005",
      "display" : "Assurance Salesman",
      "definition" : "Assurance Salesman"
    },
    {
      "code" : "3312.006",
      "display" : "Brokers Clerk Insurance",
      "definition" : "Brokers Clerk Insurance"
    },
    {
      "code" : "3312.007",
      "display" : "Claims Assessor",
      "definition" : "Claims Assessor"
    },
    {
      "code" : "3312.008",
      "display" : "Claims Insurance Clerk",
      "definition" : "Claims Insurance Clerk"
    },
    {
      "code" : "3312.009",
      "display" : "Claims Investigator",
      "definition" : "Claims Investigator"
    },
    {
      "code" : "3312.010",
      "display" : "Commercial Underwriter",
      "definition" : "Commercial Underwriter"
    },
    {
      "code" : "3312.011",
      "display" : "Examiner Pension Claims",
      "definition" : "Examiner Pension Claims"
    },
    {
      "code" : "3312.012",
      "display" : "Insurance Agent",
      "definition" : "Insurance Agent"
    },
    {
      "code" : "3312.013",
      "display" : "Insurance Assessor",
      "definition" : "Insurance Assessor"
    },
    {
      "code" : "3312.014",
      "display" : "Insurance Canvasser",
      "definition" : "Insurance Canvasser"
    },
    {
      "code" : "3312.015",
      "display" : "Insurance Claims Adjuster",
      "definition" : "Insurance Claims Adjuster"
    },
    {
      "code" : "3312.016",
      "display" : "Insurance Claims Officer",
      "definition" : "Insurance Claims Officer"
    },
    {
      "code" : "3312.017",
      "display" : "Insurance Clerk",
      "definition" : "Insurance Clerk"
    },
    {
      "code" : "3312.018",
      "display" : "Insurance Consultant",
      "definition" : "Insurance Consultant"
    },
    {
      "code" : "3312.019",
      "display" : "Insurance Officer",
      "definition" : "Insurance Officer"
    },
    {
      "code" : "3312.020",
      "display" : "Insurance Representative",
      "definition" : "Insurance Representative"
    },
    {
      "code" : "3312.021",
      "display" : "Insurance Salesman",
      "definition" : "Insurance Salesman"
    },
    {
      "code" : "3312.022",
      "display" : "Insurance Settlement Clerk",
      "definition" : "Insurance Settlement Clerk"
    },
    {
      "code" : "3312.023",
      "display" : "Insurance Surveyor",
      "definition" : "Insurance Surveyor"
    },
    {
      "code" : "3312.024",
      "display" : "Insurance Underwriter",
      "definition" : "Insurance Underwriter"
    },
    {
      "code" : "3312.025",
      "display" : "Life Insurance Agent",
      "definition" : "Life Insurance Agent"
    },
    {
      "code" : "3312.026",
      "display" : "Life Insurance Salesman",
      "definition" : "Life Insurance Salesman"
    },
    {
      "code" : "3312.027",
      "display" : "Life Insurance Underwriter",
      "definition" : "Life Insurance Underwriter"
    },
    {
      "code" : "3312.028",
      "display" : "Loss Adjuster",
      "definition" : "Loss Adjuster"
    },
    {
      "code" : "3312.029",
      "display" : "Marine Insurance Underwriter",
      "definition" : "Marine Insurance Underwriter"
    },
    {
      "code" : "3312.030",
      "display" : "Motor Claims Assessor",
      "definition" : "Motor Claims Assessor"
    },
    {
      "code" : "3312.031",
      "display" : "Personal Insurance Advisor",
      "definition" : "Personal Insurance Advisor"
    },
    {
      "code" : "3312.032",
      "display" : "Personal Insurance Underwriter",
      "definition" : "Personal Insurance Underwriter"
    },
    {
      "code" : "3313.001",
      "display" : "Leasing Agent (Buildings)",
      "definition" : "Leasing Agent (Buildings)"
    },
    {
      "code" : "3313.002",
      "display" : "Property Consultant",
      "definition" : "Property Consultant"
    },
    {
      "code" : "3313.003",
      "display" : "Property Developer",
      "definition" : "Property Developer"
    },
    {
      "code" : "3313.004",
      "display" : "Property Development Manager",
      "definition" : "Property Development Manager"
    },
    {
      "code" : "3313.005",
      "display" : "Property Salesperson",
      "definition" : "Property Salesperson"
    },
    {
      "code" : "3313.006",
      "display" : "Real Estate Agent",
      "definition" : "Real Estate Agent"
    },
    {
      "code" : "3313.007",
      "display" : "Real Estate Consultant",
      "definition" : "Real Estate Consultant"
    },
    {
      "code" : "3313.008",
      "display" : "Real Estate Sales Person",
      "definition" : "Real Estate Sales Person"
    },
    {
      "code" : "3313.009",
      "display" : "Real Estate Salesman",
      "definition" : "Real Estate Salesman"
    },
    {
      "code" : "3313.010",
      "display" : "Real Estate Salesperson",
      "definition" : "Real Estate Salesperson"
    },
    {
      "code" : "3313.011",
      "display" : "Residential Salesperson",
      "definition" : "Residential Salesperson"
    },
    {
      "code" : "3314.001",
      "display" : "Airline Clerk",
      "definition" : "Airline Clerk"
    },
    {
      "code" : "3314.002",
      "display" : "Airline Reservations Agent",
      "definition" : "Airline Reservations Agent"
    },
    {
      "code" : "3314.003",
      "display" : "Booking Travel Clerk",
      "definition" : "Booking Travel Clerk"
    },
    {
      "code" : "3314.004",
      "display" : "Travel Agent",
      "definition" : "Travel Agent"
    },
    {
      "code" : "3314.005",
      "display" : "Travel Agent (Corporate)",
      "definition" : "Travel Agent (Corporate)"
    },
    {
      "code" : "3314.006",
      "display" : "Travel Agent Representative",
      "definition" : "Travel Agent Representative"
    },
    {
      "code" : "3314.007",
      "display" : "Travel Consolidator",
      "definition" : "Travel Consolidator"
    },
    {
      "code" : "3314.008",
      "display" : "Travel Consultant",
      "definition" : "Travel Consultant"
    },
    {
      "code" : "3314.009",
      "display" : "Travel Consultant (Corporate)",
      "definition" : "Travel Consultant (Corporate)"
    },
    {
      "code" : "3314.010",
      "display" : "Travel Reservation Clerk",
      "definition" : "Travel Reservation Clerk"
    },
    {
      "code" : "3314.011",
      "display" : "Travel Wholesaler",
      "definition" : "Travel Wholesaler"
    },
    {
      "code" : "3315.001",
      "display" : "Advertising Agent Representative",
      "definition" : "Advertising Agent Representative"
    },
    {
      "code" : "3315.002",
      "display" : "Advertising Consultant",
      "definition" : "Advertising Consultant"
    },
    {
      "code" : "3315.003",
      "display" : "Advertising Representative",
      "definition" : "Advertising Representative"
    },
    {
      "code" : "3315.004",
      "display" : "Advertising Sales Representative",
      "definition" : "Advertising Sales Representative"
    },
    {
      "code" : "3315.005",
      "display" : "Advertising Salesman",
      "definition" : "Advertising Salesman"
    },
    {
      "code" : "3315.006",
      "display" : "Avon Rep",
      "definition" : "Avon Rep"
    },
    {
      "code" : "3315.007",
      "display" : "Business Services Representative",
      "definition" : "Business Services Representative"
    },
    {
      "code" : "3315.008",
      "display" : "Business Services Salesman",
      "definition" : "Business Services Salesman"
    },
    {
      "code" : "3315.009",
      "display" : "Commercial Sales Agent",
      "definition" : "Commercial Sales Agent"
    },
    {
      "code" : "3315.010",
      "display" : "Commercial Traveller",
      "definition" : "Commercial Traveller"
    },
    {
      "code" : "3315.011",
      "display" : "Commission Agent",
      "definition" : "Commission Agent"
    },
    {
      "code" : "3315.012",
      "display" : "Company Rep",
      "definition" : "Company Rep"
    },
    {
      "code" : "3315.013",
      "display" : "Company Representative",
      "definition" : "Company Representative"
    },
    {
      "code" : "3315.014",
      "display" : "Computer Consultant",
      "definition" : "Computer Consultant"
    },
    {
      "code" : "3315.015",
      "display" : "Computer Sales Consultant",
      "definition" : "Computer Sales Consultant"
    },
    {
      "code" : "3315.016",
      "display" : "Computer Sales Representative",
      "definition" : "Computer Sales Representative"
    },
    {
      "code" : "3315.017",
      "display" : "Computer Salesman",
      "definition" : "Computer Salesman"
    },
    {
      "code" : "3315.018",
      "display" : "Computer Software Support Consultant",
      "definition" : "Computer Software Support Consultant"
    },
    {
      "code" : "3315.019",
      "display" : "Computer Systems Consultant",
      "definition" : "Computer Systems Consultant"
    },
    {
      "code" : "3315.020",
      "display" : "Computer Systems Salesman",
      "definition" : "Computer Systems Salesman"
    },
    {
      "code" : "3315.021",
      "display" : "Customer Service Engineer",
      "definition" : "Customer Service Engineer"
    },
    {
      "code" : "3315.022",
      "display" : "Customer Service Representative (Telemarketing)",
      "definition" : "Customer Service Representative (Telemarketing)"
    },
    {
      "code" : "3315.023",
      "display" : "Engineering Salesman",
      "definition" : "Engineering Salesman"
    },
    {
      "code" : "3315.024",
      "display" : "Export Agent",
      "definition" : "Export Agent"
    },
    {
      "code" : "3315.025",
      "display" : "Export Representative",
      "definition" : "Export Representative"
    },
    {
      "code" : "3315.026",
      "display" : "Indent Agent",
      "definition" : "Indent Agent"
    },
    {
      "code" : "3315.027",
      "display" : "Kaihaere Hokohoko Taonga",
      "definition" : "Kaihaere Hokohoko Taonga"
    },
    {
      "code" : "3315.028",
      "display" : "Kaihoko Haerere",
      "definition" : "Kaihoko Haerere"
    },
    {
      "code" : "3315.029",
      "display" : "Kaihoko Taonga",
      "definition" : "Kaihoko Taonga"
    },
    {
      "code" : "3315.030",
      "display" : "Manufacturers Representative",
      "definition" : "Manufacturers Representative"
    },
    {
      "code" : "3315.031",
      "display" : "Manufacturers Sales Agent",
      "definition" : "Manufacturers Sales Agent"
    },
    {
      "code" : "3315.032",
      "display" : "Marketing Representative",
      "definition" : "Marketing Representative"
    },
    {
      "code" : "3315.033",
      "display" : "Medical Detailer",
      "definition" : "Medical Detailer"
    },
    {
      "code" : "3315.034",
      "display" : "Medical Sales Representative",
      "definition" : "Medical Sales Representative"
    },
    {
      "code" : "3315.035",
      "display" : "Model Agent",
      "definition" : "Model Agent"
    },
    {
      "code" : "3315.036",
      "display" : "Motor Vehicle Sales Rep",
      "definition" : "Motor Vehicle Sales Rep"
    },
    {
      "code" : "3315.037",
      "display" : "Patent Agent",
      "definition" : "Patent Agent"
    },
    {
      "code" : "3315.038",
      "display" : "Publishers Representative",
      "definition" : "Publishers Representative"
    },
    {
      "code" : "3315.039",
      "display" : "Publishing Consultant",
      "definition" : "Publishing Consultant"
    },
    {
      "code" : "3315.040",
      "display" : "Rawleighs Agent",
      "definition" : "Rawleighs Agent"
    },
    {
      "code" : "3315.041",
      "display" : "Sales Rep",
      "definition" : "Sales Rep"
    },
    {
      "code" : "3315.042",
      "display" : "Sales Representative",
      "definition" : "Sales Representative"
    },
    {
      "code" : "3315.043",
      "display" : "Salesman Technical",
      "definition" : "Salesman Technical"
    },
    {
      "code" : "3315.044",
      "display" : "Service Manager",
      "definition" : "Service Manager"
    },
    {
      "code" : "3315.045",
      "display" : "Service Manager Software Supply",
      "definition" : "Service Manager Software Supply"
    },
    {
      "code" : "3315.046",
      "display" : "Technical Representative",
      "definition" : "Technical Representative"
    },
    {
      "code" : "3315.047",
      "display" : "Technical Sales Coordinator",
      "definition" : "Technical Sales Coordinator"
    },
    {
      "code" : "3315.048",
      "display" : "Technical Service Advisor",
      "definition" : "Technical Service Advisor"
    },
    {
      "code" : "3315.049",
      "display" : "Technical Services Salesman",
      "definition" : "Technical Services Salesman"
    },
    {
      "code" : "3315.050",
      "display" : "Telemarketing Representative",
      "definition" : "Telemarketing Representative"
    },
    {
      "code" : "3315.051",
      "display" : "Theatrical Agent",
      "definition" : "Theatrical Agent"
    },
    {
      "code" : "3315.052",
      "display" : "Trade Representative",
      "definition" : "Trade Representative"
    },
    {
      "code" : "3315.053",
      "display" : "Transport Consultant",
      "definition" : "Transport Consultant"
    },
    {
      "code" : "3316.001",
      "display" : "Buyer General",
      "definition" : "Buyer General"
    },
    {
      "code" : "3316.002",
      "display" : "Company Buyer",
      "definition" : "Company Buyer"
    },
    {
      "code" : "3316.003",
      "display" : "Farm Stock Buyer",
      "definition" : "Farm Stock Buyer"
    },
    {
      "code" : "3316.004",
      "display" : "Furniture Buyer",
      "definition" : "Furniture Buyer"
    },
    {
      "code" : "3316.005",
      "display" : "Gold Buyer",
      "definition" : "Gold Buyer"
    },
    {
      "code" : "3316.006",
      "display" : "Grain and Produce Buyer",
      "definition" : "Grain and Produce Buyer"
    },
    {
      "code" : "3316.007",
      "display" : "Livestock Agent",
      "definition" : "Livestock Agent"
    },
    {
      "code" : "3316.008",
      "display" : "Livestock Buyer",
      "definition" : "Livestock Buyer"
    },
    {
      "code" : "3316.009",
      "display" : "Log Buyer",
      "definition" : "Log Buyer"
    },
    {
      "code" : "3316.010",
      "display" : "Print Buyer",
      "definition" : "Print Buyer"
    },
    {
      "code" : "3316.011",
      "display" : "Produce Agent",
      "definition" : "Produce Agent"
    },
    {
      "code" : "3316.012",
      "display" : "Purchasing Agent",
      "definition" : "Purchasing Agent"
    },
    {
      "code" : "3316.013",
      "display" : "Purchasing Buyer",
      "definition" : "Purchasing Buyer"
    },
    {
      "code" : "3316.014",
      "display" : "Purchasing Officer",
      "definition" : "Purchasing Officer"
    },
    {
      "code" : "3316.015",
      "display" : "Retail Buyer",
      "definition" : "Retail Buyer"
    },
    {
      "code" : "3316.016",
      "display" : "Skin Buyer",
      "definition" : "Skin Buyer"
    },
    {
      "code" : "3316.017",
      "display" : "Wholesale Buyer",
      "definition" : "Wholesale Buyer"
    },
    {
      "code" : "3316.018",
      "display" : "Wholesale or Retail Buyer",
      "definition" : "Wholesale or Retail Buyer"
    },
    {
      "code" : "3316.019",
      "display" : "Wool Broker",
      "definition" : "Wool Broker"
    },
    {
      "code" : "3316.020",
      "display" : "Wool Buyer",
      "definition" : "Wool Buyer"
    },
    {
      "code" : "3316.021",
      "display" : "Wool Dealer",
      "definition" : "Wool Dealer"
    },
    {
      "code" : "3316.022",
      "display" : "Wool Merchant",
      "definition" : "Wool Merchant"
    },
    {
      "code" : "3316.023",
      "display" : "Yacht Broker",
      "definition" : "Yacht Broker"
    },
    {
      "code" : "3317.001",
      "display" : "Antique Valuer",
      "definition" : "Antique Valuer"
    },
    {
      "code" : "3317.002",
      "display" : "Appraiser",
      "definition" : "Appraiser"
    },
    {
      "code" : "3317.003",
      "display" : "Commercial Valuer",
      "definition" : "Commercial Valuer"
    },
    {
      "code" : "3317.004",
      "display" : "Farm Appraiser",
      "definition" : "Farm Appraiser"
    },
    {
      "code" : "3317.005",
      "display" : "Land Valuer",
      "definition" : "Land Valuer"
    },
    {
      "code" : "3317.006",
      "display" : "Property Valuer",
      "definition" : "Property Valuer"
    },
    {
      "code" : "3317.007",
      "display" : "Registered Valuer",
      "definition" : "Registered Valuer"
    },
    {
      "code" : "3317.008",
      "display" : "Rural Valuer",
      "definition" : "Rural Valuer"
    },
    {
      "code" : "3317.009",
      "display" : "Urban Valuer",
      "definition" : "Urban Valuer"
    },
    {
      "code" : "3317.010",
      "display" : "Valuation Officer",
      "definition" : "Valuation Officer"
    },
    {
      "code" : "3317.011",
      "display" : "Valuer",
      "definition" : "Valuer"
    },
    {
      "code" : "3318.001",
      "display" : "Auctioneer",
      "definition" : "Auctioneer"
    },
    {
      "code" : "3318.002",
      "display" : "Furniture Auctioneer",
      "definition" : "Furniture Auctioneer"
    },
    {
      "code" : "3318.003",
      "display" : "Livestock Auctioneer",
      "definition" : "Livestock Auctioneer"
    },
    {
      "code" : "3318.004",
      "display" : "Real Estate Auctioneer",
      "definition" : "Real Estate Auctioneer"
    },
    {
      "code" : "3318.005",
      "display" : "Stock Auctioneer",
      "definition" : "Stock Auctioneer"
    },
    {
      "code" : "3318.006",
      "display" : "Wool Auctioneer",
      "definition" : "Wool Auctioneer"
    },
    {
      "code" : "3319.001",
      "display" : "Stock and Station Agent",
      "definition" : "Stock and Station Agent"
    },
    {
      "code" : "3321.001",
      "display" : "Aapiha Whakahaere Mahi",
      "definition" : "Aapiha Whakahaere Mahi"
    },
    {
      "code" : "3321.002",
      "display" : "Administration Officer",
      "definition" : "Administration Officer"
    },
    {
      "code" : "3321.003",
      "display" : "Apiha Whakahaere Mahi",
      "definition" : "Apiha Whakahaere Mahi"
    },
    {
      "code" : "3321.004",
      "display" : "Conference Organiser",
      "definition" : "Conference Organiser"
    },
    {
      "code" : "3321.005",
      "display" : "Event Manager",
      "definition" : "Event Manager"
    },
    {
      "code" : "3321.006",
      "display" : "Office Facilities Manager",
      "definition" : "Office Facilities Manager"
    },
    {
      "code" : "3321.007",
      "display" : "Function Organiser",
      "definition" : "Function Organiser"
    },
    {
      "code" : "3321.008",
      "display" : "Functions Coordinator (Catering)",
      "definition" : "Functions Coordinator (Catering)"
    },
    {
      "code" : "3321.009",
      "display" : "Functions Manager (Catering)",
      "definition" : "Functions Manager (Catering)"
    },
    {
      "code" : "3321.010",
      "display" : "Kaiwhakahaere Mahi",
      "definition" : "Kaiwhakahaere Mahi"
    },
    {
      "code" : "3321.011",
      "display" : "Sales Administration Officer",
      "definition" : "Sales Administration Officer"
    },
    {
      "code" : "3321.012",
      "display" : "Tangata Whakahaere Mahi",
      "definition" : "Tangata Whakahaere Mahi"
    },
    {
      "code" : "3321.013",
      "display" : "Wedding Coordinator",
      "definition" : "Wedding Coordinator"
    },
    {
      "code" : "3322.001",
      "display" : "Articled Clerk",
      "definition" : "Articled Clerk"
    },
    {
      "code" : "3322.002",
      "display" : "Clerk of Court",
      "definition" : "Clerk of Court"
    },
    {
      "code" : "3322.003",
      "display" : "Conveyancing Clerk",
      "definition" : "Conveyancing Clerk"
    },
    {
      "code" : "3322.004",
      "display" : "Court Clerk",
      "definition" : "Court Clerk"
    },
    {
      "code" : "3322.005",
      "display" : "Estate Officer Public Trust",
      "definition" : "Estate Officer Public Trust"
    },
    {
      "code" : "3322.006",
      "display" : "Kaimahi Ture",
      "definition" : "Kaimahi Ture"
    },
    {
      "code" : "3322.007",
      "display" : "Law Clerk",
      "definition" : "Law Clerk"
    },
    {
      "code" : "3322.008",
      "display" : "Legal Clerk",
      "definition" : "Legal Clerk"
    },
    {
      "code" : "3322.009",
      "display" : "Legal Executive",
      "definition" : "Legal Executive"
    },
    {
      "code" : "3322.010",
      "display" : "Legal Search Clerk",
      "definition" : "Legal Search Clerk"
    },
    {
      "code" : "3322.011",
      "display" : "Trust Officer",
      "definition" : "Trust Officer"
    },
    {
      "code" : "3323.001",
      "display" : "Accounts Bookkeeper",
      "definition" : "Accounts Bookkeeper"
    },
    {
      "code" : "3323.002",
      "display" : "Book Keeper",
      "definition" : "Book Keeper"
    },
    {
      "code" : "3323.003",
      "display" : "Bookkeeper",
      "definition" : "Bookkeeper"
    },
    {
      "code" : "3323.004",
      "display" : "Ledger Keeper",
      "definition" : "Ledger Keeper"
    },
    {
      "code" : "3324.001",
      "display" : "Building Consents Officer",
      "definition" : "Building Consents Officer"
    },
    {
      "code" : "3324.002",
      "display" : "Building Control Officer",
      "definition" : "Building Control Officer"
    },
    {
      "code" : "3324.003",
      "display" : "Contracts Manager",
      "definition" : "Contracts Manager"
    },
    {
      "code" : "3324.004",
      "display" : "Efficiency Engineer",
      "definition" : "Efficiency Engineer"
    },
    {
      "code" : "3324.005",
      "display" : "Ergonomist",
      "definition" : "Ergonomist"
    },
    {
      "code" : "3324.006",
      "display" : "Industrial Planning Officer",
      "definition" : "Industrial Planning Officer"
    },
    {
      "code" : "3324.007",
      "display" : "Management Engineer",
      "definition" : "Management Engineer"
    },
    {
      "code" : "3324.008",
      "display" : "Management Services Officer",
      "definition" : "Management Services Officer"
    },
    {
      "code" : "3324.009",
      "display" : "Methods Engineer",
      "definition" : "Methods Engineer"
    },
    {
      "code" : "3324.010",
      "display" : "Organisation and Methods Analyst",
      "definition" : "Organisation and Methods Analyst"
    },
    {
      "code" : "3324.011",
      "display" : "Organisation and Methods Engineer",
      "definition" : "Organisation and Methods Engineer"
    },
    {
      "code" : "3324.012",
      "display" : "Process Improvement Coordinator",
      "definition" : "Process Improvement Coordinator"
    },
    {
      "code" : "3324.013",
      "display" : "Safety Consultant",
      "definition" : "Safety Consultant"
    },
    {
      "code" : "3324.014",
      "display" : "Time and Motion Study Officer",
      "definition" : "Time and Motion Study Officer"
    },
    {
      "code" : "3324.015",
      "display" : "Work Study and Methods Officer",
      "definition" : "Work Study and Methods Officer"
    },
    {
      "code" : "3324.016",
      "display" : "Work Study Observer",
      "definition" : "Work Study Observer"
    },
    {
      "code" : "3324.017",
      "display" : "Work Study Officer",
      "definition" : "Work Study Officer"
    },
    {
      "code" : "3324.018",
      "display" : "Works Measurement and Method Officer",
      "definition" : "Works Measurement and Method Officer"
    },
    {
      "code" : "3331.001",
      "display" : "Agricultural Port Officer",
      "definition" : "Agricultural Port Officer"
    },
    {
      "code" : "3331.002",
      "display" : "Biosecurity Officer",
      "definition" : "Biosecurity Officer"
    },
    {
      "code" : "3331.003",
      "display" : "Border Protection Officer",
      "definition" : "Border Protection Officer"
    },
    {
      "code" : "3331.004",
      "display" : "Customs Advisory Officer",
      "definition" : "Customs Advisory Officer"
    },
    {
      "code" : "3331.005",
      "display" : "Customs and Excise Officer",
      "definition" : "Customs and Excise Officer"
    },
    {
      "code" : "3331.006",
      "display" : "Customs Bond Agent",
      "definition" : "Customs Bond Agent"
    },
    {
      "code" : "3331.007",
      "display" : "Customs Bond Officer",
      "definition" : "Customs Bond Officer"
    },
    {
      "code" : "3331.008",
      "display" : "Customs Examiner",
      "definition" : "Customs Examiner"
    },
    {
      "code" : "3331.009",
      "display" : "Customs Inspector",
      "definition" : "Customs Inspector"
    },
    {
      "code" : "3331.010",
      "display" : "Customs Officer",
      "definition" : "Customs Officer"
    },
    {
      "code" : "3331.011",
      "display" : "Customs Prevention Officer",
      "definition" : "Customs Prevention Officer"
    },
    {
      "code" : "3331.012",
      "display" : "Immigration Officer",
      "definition" : "Immigration Officer"
    },
    {
      "code" : "3331.013",
      "display" : "Quarantine and Agriculture Ports Officer",
      "definition" : "Quarantine and Agriculture Ports Officer"
    },
    {
      "code" : "3331.014",
      "display" : "Quarantine Officer",
      "definition" : "Quarantine Officer"
    },
    {
      "code" : "3331.015",
      "display" : "Quarantine Officer Ports",
      "definition" : "Quarantine Officer Ports"
    },
    {
      "code" : "3341.001",
      "display" : "Care and Protection Social Worker",
      "definition" : "Care and Protection Social Worker"
    },
    {
      "code" : "3341.002",
      "display" : "Case Worker",
      "definition" : "Case Worker"
    },
    {
      "code" : "3341.003",
      "display" : "Child Welfare Officer",
      "definition" : "Child Welfare Officer"
    },
    {
      "code" : "3341.004",
      "display" : "Community Activities Officer",
      "definition" : "Community Activities Officer"
    },
    {
      "code" : "3341.005",
      "display" : "Community Centre Coordinator",
      "definition" : "Community Centre Coordinator"
    },
    {
      "code" : "3341.006",
      "display" : "Community Corrections Officer",
      "definition" : "Community Corrections Officer"
    },
    {
      "code" : "3341.007",
      "display" : "Community Health Worker",
      "definition" : "Community Health Worker"
    },
    {
      "code" : "3341.008",
      "display" : "Community Service Worker",
      "definition" : "Community Service Worker"
    },
    {
      "code" : "3341.009",
      "display" : "Community Services Advisor (Local Authority)",
      "definition" : "Community Services Advisor (Local Authority)"
    },
    {
      "code" : "3341.010",
      "display" : "Community Social Worker",
      "definition" : "Community Social Worker"
    },
    {
      "code" : "3341.011",
      "display" : "Community Worker",
      "definition" : "Community Worker"
    },
    {
      "code" : "3341.012",
      "display" : "Family Support Worker",
      "definition" : "Family Support Worker"
    },
    {
      "code" : "3341.013",
      "display" : "Health Social Worker",
      "definition" : "Health Social Worker"
    },
    {
      "code" : "3341.014",
      "display" : "Kaimahi a Iwi",
      "definition" : "Kaimahi a Iwi"
    },
    {
      "code" : "3341.015",
      "display" : "Kaimahi a Rohe",
      "definition" : "Kaimahi a Rohe"
    },
    {
      "code" : "3341.016",
      "display" : "Kaimahi aa Iwi",
      "definition" : "Kaimahi aa Iwi"
    },
    {
      "code" : "3341.017",
      "display" : "Kaimahi aa Roohe",
      "definition" : "Kaimahi aa Roohe"
    },
    {
      "code" : "3341.018",
      "display" : "Kaimahi Awhina Taangata",
      "definition" : "Kaimahi Awhina Taangata"
    },
    {
      "code" : "3341.019",
      "display" : "Kaimahi Awhina Tangata",
      "definition" : "Kaimahi Awhina Tangata"
    },
    {
      "code" : "3341.020",
      "display" : "Kaimahi Manaaki Taangata",
      "definition" : "Kaimahi Manaaki Taangata"
    },
    {
      "code" : "3341.021",
      "display" : "Kaimahi Manaaki Tangata",
      "definition" : "Kaimahi Manaaki Tangata"
    },
    {
      "code" : "3341.022",
      "display" : "Kaimahi Tiaki Taangata",
      "definition" : "Kaimahi Tiaki Taangata"
    },
    {
      "code" : "3341.023",
      "display" : "Kaimahi Tiaki Tangata",
      "definition" : "Kaimahi Tiaki Tangata"
    },
    {
      "code" : "3341.024",
      "display" : "Kaimahi Toko i te Ora",
      "definition" : "Kaimahi Toko i te Ora"
    },
    {
      "code" : "3341.025",
      "display" : "Maori Welfare Officer",
      "definition" : "Maori Welfare Officer"
    },
    {
      "code" : "3341.026",
      "display" : "Medical Psychiatric Social Worker",
      "definition" : "Medical Psychiatric Social Worker"
    },
    {
      "code" : "3341.027",
      "display" : "Mental Welfare Worker",
      "definition" : "Mental Welfare Worker"
    },
    {
      "code" : "3341.028",
      "display" : "Parole Officer",
      "definition" : "Parole Officer"
    },
    {
      "code" : "3341.029",
      "display" : "Police Welfare Officer",
      "definition" : "Police Welfare Officer"
    },
    {
      "code" : "3341.030",
      "display" : "Prison Programme Coordinator",
      "definition" : "Prison Programme Coordinator"
    },
    {
      "code" : "3341.031",
      "display" : "Prison Welfare Worker",
      "definition" : "Prison Welfare Worker"
    },
    {
      "code" : "3341.032",
      "display" : "Probation Officer",
      "definition" : "Probation Officer"
    },
    {
      "code" : "3341.033",
      "display" : "Probation Worker",
      "definition" : "Probation Worker"
    },
    {
      "code" : "3341.034",
      "display" : "Rehabilitation Field Officer",
      "definition" : "Rehabilitation Field Officer"
    },
    {
      "code" : "3341.035",
      "display" : "Residential Social Worker",
      "definition" : "Residential Social Worker"
    },
    {
      "code" : "3341.036",
      "display" : "Resource Centre Community Worker",
      "definition" : "Resource Centre Community Worker"
    },
    {
      "code" : "3341.037",
      "display" : "School Social Worker",
      "definition" : "School Social Worker"
    },
    {
      "code" : "3341.038",
      "display" : "Social Case Worker",
      "definition" : "Social Case Worker"
    },
    {
      "code" : "3341.039",
      "display" : "Social Welfare Caseworker",
      "definition" : "Social Welfare Caseworker"
    },
    {
      "code" : "3341.040",
      "display" : "Social Welfare Officer",
      "definition" : "Social Welfare Officer"
    },
    {
      "code" : "3341.041",
      "display" : "Social Worker",
      "definition" : "Social Worker"
    },
    {
      "code" : "3341.042",
      "display" : "Voluntary Worker",
      "definition" : "Voluntary Worker"
    },
    {
      "code" : "3341.043",
      "display" : "Whanau Support Worker",
      "definition" : "Whanau Support Worker"
    },
    {
      "code" : "3341.044",
      "display" : "Youth Activities Officer",
      "definition" : "Youth Activities Officer"
    },
    {
      "code" : "3341.045",
      "display" : "Youth Justice Social Worker",
      "definition" : "Youth Justice Social Worker"
    },
    {
      "code" : "3341.046",
      "display" : "Youth Worker",
      "definition" : "Youth Worker"
    },
    {
      "code" : "3342.001",
      "display" : "Access Teacher",
      "definition" : "Access Teacher"
    },
    {
      "code" : "3342.002",
      "display" : "Access Tutor",
      "definition" : "Access Tutor"
    },
    {
      "code" : "3342.003",
      "display" : "Employment Programme Teaching Associate Professional",
      "definition" : "Employment Programme Teaching Associate Professional"
    },
    {
      "code" : "3342.004",
      "display" : "Kaiaawhina Kaiako",
      "definition" : "Kaiaawhina Kaiako"
    },
    {
      "code" : "3342.005",
      "display" : "Kaiawhina Kura Tuatahi",
      "definition" : "Kaiawhina Kura Tuatahi"
    },
    {
      "code" : "3342.006",
      "display" : "Teacher Aide",
      "definition" : "Teacher Aide"
    },
    {
      "code" : "3342.007",
      "display" : "Teacher Aide Primary School",
      "definition" : "Teacher Aide Primary School"
    },
    {
      "code" : "3342.008",
      "display" : "Teacher Aide Secondary School",
      "definition" : "Teacher Aide Secondary School"
    },
    {
      "code" : "3342.009",
      "display" : "Teachers Assistant",
      "definition" : "Teachers Assistant"
    },
    {
      "code" : "3342.010",
      "display" : "Technical Assistant Education",
      "definition" : "Technical Assistant Education"
    },
    {
      "code" : "3351.001",
      "display" : "Career Counsellor",
      "definition" : "Career Counsellor"
    },
    {
      "code" : "3351.002",
      "display" : "Career Practitioner",
      "definition" : "Career Practitioner"
    },
    {
      "code" : "3351.003",
      "display" : "Careers Advisor",
      "definition" : "Careers Advisor"
    },
    {
      "code" : "3351.004",
      "display" : "Careers Transition Employment Advisor",
      "definition" : "Careers Transition Employment Advisor"
    },
    {
      "code" : "3351.005",
      "display" : "Employment Advisor",
      "definition" : "Employment Advisor"
    },
    {
      "code" : "3351.006",
      "display" : "Employment Agency Consultant",
      "definition" : "Employment Agency Consultant"
    },
    {
      "code" : "3351.007",
      "display" : "Employment Interviewer",
      "definition" : "Employment Interviewer"
    },
    {
      "code" : "3351.008",
      "display" : "Employment Placement Officer",
      "definition" : "Employment Placement Officer"
    },
    {
      "code" : "3351.009",
      "display" : "Occupational Guidance Officer",
      "definition" : "Occupational Guidance Officer"
    },
    {
      "code" : "3351.010",
      "display" : "Placement Officer",
      "definition" : "Placement Officer"
    },
    {
      "code" : "3351.011",
      "display" : "Vocational Guidance Officer",
      "definition" : "Vocational Guidance Officer"
    },
    {
      "code" : "3361.001",
      "display" : "Advertising Copywriter",
      "definition" : "Advertising Copywriter"
    },
    {
      "code" : "3361.002",
      "display" : "Art Critic",
      "definition" : "Art Critic"
    },
    {
      "code" : "3361.003",
      "display" : "Author",
      "definition" : "Author"
    },
    {
      "code" : "3361.004",
      "display" : "Author and Critic",
      "definition" : "Author and Critic"
    },
    {
      "code" : "3361.005",
      "display" : "Book Editor",
      "definition" : "Book Editor"
    },
    {
      "code" : "3361.006",
      "display" : "Book Reviewer",
      "definition" : "Book Reviewer"
    },
    {
      "code" : "3361.007",
      "display" : "Broadcasting Journalist",
      "definition" : "Broadcasting Journalist"
    },
    {
      "code" : "3361.008",
      "display" : "Columnist",
      "definition" : "Columnist"
    },
    {
      "code" : "3361.009",
      "display" : "Commercial Writer",
      "definition" : "Commercial Writer"
    },
    {
      "code" : "3361.010",
      "display" : "Continuity Editor",
      "definition" : "Continuity Editor"
    },
    {
      "code" : "3361.011",
      "display" : "Copy Editor",
      "definition" : "Copy Editor"
    },
    {
      "code" : "3361.012",
      "display" : "Copywriter",
      "definition" : "Copywriter"
    },
    {
      "code" : "3361.013",
      "display" : "Critic",
      "definition" : "Critic"
    },
    {
      "code" : "3361.014",
      "display" : "Dramatist",
      "definition" : "Dramatist"
    },
    {
      "code" : "3361.015",
      "display" : "Economic Journalist",
      "definition" : "Economic Journalist"
    },
    {
      "code" : "3361.016",
      "display" : "Editor",
      "definition" : "Editor"
    },
    {
      "code" : "3361.017",
      "display" : "Editorial Assistant",
      "definition" : "Editorial Assistant"
    },
    {
      "code" : "3361.018",
      "display" : "Film Assessor",
      "definition" : "Film Assessor"
    },
    {
      "code" : "3361.019",
      "display" : "Foreign Correspondent",
      "definition" : "Foreign Correspondent"
    },
    {
      "code" : "3361.020",
      "display" : "Journalist",
      "definition" : "Journalist"
    },
    {
      "code" : "3361.021",
      "display" : "Literary Commentator",
      "definition" : "Literary Commentator"
    },
    {
      "code" : "3361.022",
      "display" : "Literary Critic",
      "definition" : "Literary Critic"
    },
    {
      "code" : "3361.023",
      "display" : "Magazine Editor",
      "definition" : "Magazine Editor"
    },
    {
      "code" : "3361.024",
      "display" : "Manuals Editor",
      "definition" : "Manuals Editor"
    },
    {
      "code" : "3361.025",
      "display" : "Manuscript Editor",
      "definition" : "Manuscript Editor"
    },
    {
      "code" : "3361.026",
      "display" : "Media Writer Reporter",
      "definition" : "Media Writer Reporter"
    },
    {
      "code" : "3361.027",
      "display" : "Music Reviewer",
      "definition" : "Music Reviewer"
    },
    {
      "code" : "3361.028",
      "display" : "News Commentator Broadcasting",
      "definition" : "News Commentator Broadcasting"
    },
    {
      "code" : "3361.029",
      "display" : "Newspaper Copywriter",
      "definition" : "Newspaper Copywriter"
    },
    {
      "code" : "3361.030",
      "display" : "Newspaper Correspondent",
      "definition" : "Newspaper Correspondent"
    },
    {
      "code" : "3361.031",
      "display" : "Newspaper Editor",
      "definition" : "Newspaper Editor"
    },
    {
      "code" : "3361.032",
      "display" : "Newspapers Periodicals Editor",
      "definition" : "Newspapers Periodicals Editor"
    },
    {
      "code" : "3361.033",
      "display" : "Novelist",
      "definition" : "Novelist"
    },
    {
      "code" : "3361.034",
      "display" : "Playwright",
      "definition" : "Playwright"
    },
    {
      "code" : "3361.035",
      "display" : "Poet",
      "definition" : "Poet"
    },
    {
      "code" : "3361.036",
      "display" : "Press Reporter",
      "definition" : "Press Reporter"
    },
    {
      "code" : "3361.037",
      "display" : "Pressman",
      "definition" : "Pressman"
    },
    {
      "code" : "3361.038",
      "display" : "Print Journalist",
      "definition" : "Print Journalist"
    },
    {
      "code" : "3361.039",
      "display" : "Publications Editor",
      "definition" : "Publications Editor"
    },
    {
      "code" : "3361.040",
      "display" : "Publicity Writer",
      "definition" : "Publicity Writer"
    },
    {
      "code" : "3361.041",
      "display" : "Radio Journalist",
      "definition" : "Radio Journalist"
    },
    {
      "code" : "3361.042",
      "display" : "Reporter",
      "definition" : "Reporter"
    },
    {
      "code" : "3361.043",
      "display" : "Script Editor",
      "definition" : "Script Editor"
    },
    {
      "code" : "3361.044",
      "display" : "Script Writer",
      "definition" : "Script Writer"
    },
    {
      "code" : "3361.045",
      "display" : "Sports Journalist",
      "definition" : "Sports Journalist"
    },
    {
      "code" : "3361.046",
      "display" : "Sub-Editor",
      "definition" : "Sub-Editor"
    },
    {
      "code" : "3361.047",
      "display" : "Television Journalist",
      "definition" : "Television Journalist"
    },
    {
      "code" : "3361.048",
      "display" : "Textbook Writer",
      "definition" : "Textbook Writer"
    },
    {
      "code" : "3361.049",
      "display" : "Works Publication Editor",
      "definition" : "Works Publication Editor"
    },
    {
      "code" : "3361.050",
      "display" : "Writer",
      "definition" : "Writer"
    },
    {
      "code" : "3361.051",
      "display" : "Writer Literary Works",
      "definition" : "Writer Literary Works"
    },
    {
      "code" : "3362.001",
      "display" : "Air Brush Artist",
      "definition" : "Air Brush Artist"
    },
    {
      "code" : "3362.002",
      "display" : "Art Enameller",
      "definition" : "Art Enameller"
    },
    {
      "code" : "3362.003",
      "display" : "Art Restorer Paintings",
      "definition" : "Art Restorer Paintings"
    },
    {
      "code" : "3362.004",
      "display" : "Art Teacher Private",
      "definition" : "Art Teacher Private"
    },
    {
      "code" : "3362.005",
      "display" : "Artist",
      "definition" : "Artist"
    },
    {
      "code" : "3362.006",
      "display" : "Artist Painter",
      "definition" : "Artist Painter"
    },
    {
      "code" : "3362.007",
      "display" : "Artistic Etcher Engraver",
      "definition" : "Artistic Etcher Engraver"
    },
    {
      "code" : "3362.008",
      "display" : "Artistic Printmaker",
      "definition" : "Artistic Printmaker"
    },
    {
      "code" : "3362.009",
      "display" : "Bone Carver",
      "definition" : "Bone Carver"
    },
    {
      "code" : "3362.010",
      "display" : "Caricaturist",
      "definition" : "Caricaturist"
    },
    {
      "code" : "3362.011",
      "display" : "Cartoonist",
      "definition" : "Cartoonist"
    },
    {
      "code" : "3362.012",
      "display" : "Carver",
      "definition" : "Carver"
    },
    {
      "code" : "3362.013",
      "display" : "Chalkboard Artist",
      "definition" : "Chalkboard Artist"
    },
    {
      "code" : "3362.014",
      "display" : "Community Artist",
      "definition" : "Community Artist"
    },
    {
      "code" : "3362.015",
      "display" : "Craftsperson",
      "definition" : "Craftsperson"
    },
    {
      "code" : "3362.016",
      "display" : "Maori Carver",
      "definition" : "Maori Carver"
    },
    {
      "code" : "3362.017",
      "display" : "Mural Artist",
      "definition" : "Mural Artist"
    },
    {
      "code" : "3362.018",
      "display" : "Muralist",
      "definition" : "Muralist"
    },
    {
      "code" : "3362.019",
      "display" : "Photo Colourer",
      "definition" : "Photo Colourer"
    },
    {
      "code" : "3362.020",
      "display" : "Portrait Painter",
      "definition" : "Portrait Painter"
    },
    {
      "code" : "3362.021",
      "display" : "Sculptor",
      "definition" : "Sculptor"
    },
    {
      "code" : "3362.022",
      "display" : "Stone Carver",
      "definition" : "Stone Carver"
    },
    {
      "code" : "3362.023",
      "display" : "Tattooist",
      "definition" : "Tattooist"
    },
    {
      "code" : "3362.024",
      "display" : "Wood Carver",
      "definition" : "Wood Carver"
    },
    {
      "code" : "3362.025",
      "display" : "Wood Carver Creative",
      "definition" : "Wood Carver Creative"
    },
    {
      "code" : "3363.001",
      "display" : "Advertising Artist",
      "definition" : "Advertising Artist"
    },
    {
      "code" : "3363.002",
      "display" : "Advertising Illustrator",
      "definition" : "Advertising Illustrator"
    },
    {
      "code" : "3363.003",
      "display" : "Advertising Visible Artist",
      "definition" : "Advertising Visible Artist"
    },
    {
      "code" : "3363.004",
      "display" : "Animator",
      "definition" : "Animator"
    },
    {
      "code" : "3363.005",
      "display" : "Animator Commercial Television",
      "definition" : "Animator Commercial Television"
    },
    {
      "code" : "3363.006",
      "display" : "Art Director",
      "definition" : "Art Director"
    },
    {
      "code" : "3363.007",
      "display" : "Art Illustrator",
      "definition" : "Art Illustrator"
    },
    {
      "code" : "3363.008",
      "display" : "Book Illustrator",
      "definition" : "Book Illustrator"
    },
    {
      "code" : "3363.009",
      "display" : "Calligrapher",
      "definition" : "Calligrapher"
    },
    {
      "code" : "3363.010",
      "display" : "Carpet Copyist Planner",
      "definition" : "Carpet Copyist Planner"
    },
    {
      "code" : "3363.011",
      "display" : "Carpet Designer",
      "definition" : "Carpet Designer"
    },
    {
      "code" : "3363.012",
      "display" : "Ceramic Designer",
      "definition" : "Ceramic Designer"
    },
    {
      "code" : "3363.013",
      "display" : "Childrens Book Illustrator",
      "definition" : "Childrens Book Illustrator"
    },
    {
      "code" : "3363.014",
      "display" : "China Designer",
      "definition" : "China Designer"
    },
    {
      "code" : "3363.015",
      "display" : "Clothing (Textiles) Designer",
      "definition" : "Clothing (Textiles) Designer"
    },
    {
      "code" : "3363.016",
      "display" : "Clothing Designer",
      "definition" : "Clothing Designer"
    },
    {
      "code" : "3363.017",
      "display" : "Commercial Artist",
      "definition" : "Commercial Artist"
    },
    {
      "code" : "3363.018",
      "display" : "Commercial Designer",
      "definition" : "Commercial Designer"
    },
    {
      "code" : "3363.019",
      "display" : "Commercial Product Designer",
      "definition" : "Commercial Product Designer"
    },
    {
      "code" : "3363.020",
      "display" : "Display and Window Dresser",
      "definition" : "Display and Window Dresser"
    },
    {
      "code" : "3363.021",
      "display" : "Display Artist",
      "definition" : "Display Artist"
    },
    {
      "code" : "3363.022",
      "display" : "Display Dresser",
      "definition" : "Display Dresser"
    },
    {
      "code" : "3363.023",
      "display" : "Dress Designer",
      "definition" : "Dress Designer"
    },
    {
      "code" : "3363.024",
      "display" : "Engineering Illustrator",
      "definition" : "Engineering Illustrator"
    },
    {
      "code" : "3363.025",
      "display" : "Fashion Designer",
      "definition" : "Fashion Designer"
    },
    {
      "code" : "3363.026",
      "display" : "Footwear Designer",
      "definition" : "Footwear Designer"
    },
    {
      "code" : "3363.027",
      "display" : "Graphic Artist",
      "definition" : "Graphic Artist"
    },
    {
      "code" : "3363.028",
      "display" : "Graphic Designer",
      "definition" : "Graphic Designer"
    },
    {
      "code" : "3363.029",
      "display" : "Illustrator",
      "definition" : "Illustrator"
    },
    {
      "code" : "3363.030",
      "display" : "Illustrator Display",
      "definition" : "Illustrator Display"
    },
    {
      "code" : "3363.031",
      "display" : "Industrial Designer",
      "definition" : "Industrial Designer"
    },
    {
      "code" : "3363.032",
      "display" : "Interior Decorator",
      "definition" : "Interior Decorator"
    },
    {
      "code" : "3363.033",
      "display" : "Interior Designer",
      "definition" : "Interior Designer"
    },
    {
      "code" : "3363.034",
      "display" : "Kitchen Designer",
      "definition" : "Kitchen Designer"
    },
    {
      "code" : "3363.035",
      "display" : "Lettering Designer",
      "definition" : "Lettering Designer"
    },
    {
      "code" : "3363.036",
      "display" : "Lithographic Artist",
      "definition" : "Lithographic Artist"
    },
    {
      "code" : "3363.037",
      "display" : "Medical Artist",
      "definition" : "Medical Artist"
    },
    {
      "code" : "3363.038",
      "display" : "Medical Illustrator",
      "definition" : "Medical Illustrator"
    },
    {
      "code" : "3363.039",
      "display" : "Paste Up Artist",
      "definition" : "Paste Up Artist"
    },
    {
      "code" : "3363.040",
      "display" : "Quality Controller Of Clothing Designers",
      "definition" : "Quality Controller Of Clothing Designers"
    },
    {
      "code" : "3363.041",
      "display" : "Stage Scenery Designer",
      "definition" : "Stage Scenery Designer"
    },
    {
      "code" : "3363.042",
      "display" : "Technical Illustrator Artist",
      "definition" : "Technical Illustrator Artist"
    },
    {
      "code" : "3363.043",
      "display" : "Technical Lithographic Artist",
      "definition" : "Technical Lithographic Artist"
    },
    {
      "code" : "3363.044",
      "display" : "Textile Designing Worker",
      "definition" : "Textile Designing Worker"
    },
    {
      "code" : "3363.045",
      "display" : "Textile Product Designer",
      "definition" : "Textile Product Designer"
    },
    {
      "code" : "3363.046",
      "display" : "Theatre Lighting Designer",
      "definition" : "Theatre Lighting Designer"
    },
    {
      "code" : "3363.047",
      "display" : "Ticket Writer",
      "definition" : "Ticket Writer"
    },
    {
      "code" : "3363.048",
      "display" : "Wallpaper Designer",
      "definition" : "Wallpaper Designer"
    },
    {
      "code" : "3363.049",
      "display" : "Weaving Pattern Card Preparer",
      "definition" : "Weaving Pattern Card Preparer"
    },
    {
      "code" : "3363.050",
      "display" : "Web Graphic Designer",
      "definition" : "Web Graphic Designer"
    },
    {
      "code" : "3363.051",
      "display" : "Window Dresser",
      "definition" : "Window Dresser"
    },
    {
      "code" : "3364.001",
      "display" : "Accompanist",
      "definition" : "Accompanist"
    },
    {
      "code" : "3364.002",
      "display" : "Arranger",
      "definition" : "Arranger"
    },
    {
      "code" : "3364.003",
      "display" : "Band Conductor",
      "definition" : "Band Conductor"
    },
    {
      "code" : "3364.004",
      "display" : "Band Leader",
      "definition" : "Band Leader"
    },
    {
      "code" : "3364.005",
      "display" : "Bandsman",
      "definition" : "Bandsman"
    },
    {
      "code" : "3364.006",
      "display" : "Busker",
      "definition" : "Busker"
    },
    {
      "code" : "3364.007",
      "display" : "Choirmaster",
      "definition" : "Choirmaster"
    },
    {
      "code" : "3364.008",
      "display" : "Choral Director",
      "definition" : "Choral Director"
    },
    {
      "code" : "3364.009",
      "display" : "Composer",
      "definition" : "Composer"
    },
    {
      "code" : "3364.010",
      "display" : "Conductor",
      "definition" : "Conductor"
    },
    {
      "code" : "3364.011",
      "display" : "Instrumentalist",
      "definition" : "Instrumentalist"
    },
    {
      "code" : "3364.012",
      "display" : "Lyric Writer",
      "definition" : "Lyric Writer"
    },
    {
      "code" : "3364.013",
      "display" : "Music Arranger",
      "definition" : "Music Arranger"
    },
    {
      "code" : "3364.014",
      "display" : "Music Composer",
      "definition" : "Music Composer"
    },
    {
      "code" : "3364.015",
      "display" : "Music Director",
      "definition" : "Music Director"
    },
    {
      "code" : "3364.016",
      "display" : "Music Teacher",
      "definition" : "Music Teacher"
    },
    {
      "code" : "3364.017",
      "display" : "Musician",
      "definition" : "Musician"
    },
    {
      "code" : "3364.018",
      "display" : "Orchestra Conductor",
      "definition" : "Orchestra Conductor"
    },
    {
      "code" : "3364.019",
      "display" : "Orchestra Leader",
      "definition" : "Orchestra Leader"
    },
    {
      "code" : "3364.020",
      "display" : "Orchestral Musician",
      "definition" : "Orchestral Musician"
    },
    {
      "code" : "3364.021",
      "display" : "Orchestrator",
      "definition" : "Orchestrator"
    },
    {
      "code" : "3364.022",
      "display" : "Organist",
      "definition" : "Organist"
    },
    {
      "code" : "3364.023",
      "display" : "Pianist",
      "definition" : "Pianist"
    },
    {
      "code" : "3364.024",
      "display" : "Piano Teacher",
      "definition" : "Piano Teacher"
    },
    {
      "code" : "3364.025",
      "display" : "Programme Selector Music",
      "definition" : "Programme Selector Music"
    },
    {
      "code" : "3364.026",
      "display" : "Singer",
      "definition" : "Singer"
    },
    {
      "code" : "3364.027",
      "display" : "Singing and Music Teacher",
      "definition" : "Singing and Music Teacher"
    },
    {
      "code" : "3364.028",
      "display" : "Singing Teacher",
      "definition" : "Singing Teacher"
    },
    {
      "code" : "3364.029",
      "display" : "Song Writer",
      "definition" : "Song Writer"
    },
    {
      "code" : "3364.030",
      "display" : "Vocalist",
      "definition" : "Vocalist"
    },
    {
      "code" : "3365.001",
      "display" : "Ballet Dancer",
      "definition" : "Ballet Dancer"
    },
    {
      "code" : "3365.002",
      "display" : "Ballet Teacher",
      "definition" : "Ballet Teacher"
    },
    {
      "code" : "3365.003",
      "display" : "Ballroom Dancer",
      "definition" : "Ballroom Dancer"
    },
    {
      "code" : "3365.004",
      "display" : "Choreographer",
      "definition" : "Choreographer"
    },
    {
      "code" : "3365.005",
      "display" : "Classical Dancer",
      "definition" : "Classical Dancer"
    },
    {
      "code" : "3365.006",
      "display" : "Dance Teacher",
      "definition" : "Dance Teacher"
    },
    {
      "code" : "3365.007",
      "display" : "Dancer",
      "definition" : "Dancer"
    },
    {
      "code" : "3365.008",
      "display" : "Dancing Teacher",
      "definition" : "Dancing Teacher"
    },
    {
      "code" : "3365.009",
      "display" : "Modern Dancer",
      "definition" : "Modern Dancer"
    },
    {
      "code" : "3366.001",
      "display" : "Actor",
      "definition" : "Actor"
    },
    {
      "code" : "3366.002",
      "display" : "Actress",
      "definition" : "Actress"
    },
    {
      "code" : "3366.003",
      "display" : "Artistic Director",
      "definition" : "Artistic Director"
    },
    {
      "code" : "3366.004",
      "display" : "Broadcasting Designer",
      "definition" : "Broadcasting Designer"
    },
    {
      "code" : "3366.005",
      "display" : "Director of Photography Film Television",
      "definition" : "Director of Photography Film Television"
    },
    {
      "code" : "3366.006",
      "display" : "Directors Assistant",
      "definition" : "Directors Assistant"
    },
    {
      "code" : "3366.007",
      "display" : "Film Director",
      "definition" : "Film Director"
    },
    {
      "code" : "3366.008",
      "display" : "Location Director",
      "definition" : "Location Director"
    },
    {
      "code" : "3366.009",
      "display" : "Motion Picture Director",
      "definition" : "Motion Picture Director"
    },
    {
      "code" : "3366.010",
      "display" : "Production Assistant (Film)",
      "definition" : "Production Assistant (Film)"
    },
    {
      "code" : "3366.011",
      "display" : "Production Assistant (Radio)",
      "definition" : "Production Assistant (Radio)"
    },
    {
      "code" : "3366.012",
      "display" : "Production Assistant (TV)",
      "definition" : "Production Assistant (TV)"
    },
    {
      "code" : "3366.013",
      "display" : "Production Runner (Radio and TV)",
      "definition" : "Production Runner (Radio and TV)"
    },
    {
      "code" : "3366.014",
      "display" : "Radio Director",
      "definition" : "Radio Director"
    },
    {
      "code" : "3366.015",
      "display" : "Stage Director",
      "definition" : "Stage Director"
    },
    {
      "code" : "3366.016",
      "display" : "Stage Manager",
      "definition" : "Stage Manager"
    },
    {
      "code" : "3366.017",
      "display" : "Studio Director",
      "definition" : "Studio Director"
    },
    {
      "code" : "3366.018",
      "display" : "Stunt Coordinator",
      "definition" : "Stunt Coordinator"
    },
    {
      "code" : "3366.019",
      "display" : "Stuntman",
      "definition" : "Stuntman"
    },
    {
      "code" : "3366.020",
      "display" : "Stuntperson",
      "definition" : "Stuntperson"
    },
    {
      "code" : "3366.021",
      "display" : "Television Director",
      "definition" : "Television Director"
    },
    {
      "code" : "3366.022",
      "display" : "Theatre Director",
      "definition" : "Theatre Director"
    },
    {
      "code" : "3366.023",
      "display" : "Theatrical Director",
      "definition" : "Theatrical Director"
    },
    {
      "code" : "3366.024",
      "display" : "TV Floor Manager",
      "definition" : "TV Floor Manager"
    },
    {
      "code" : "3366.025",
      "display" : "TV Producers Assistant",
      "definition" : "TV Producers Assistant"
    },
    {
      "code" : "3367.001",
      "display" : "Broadcaster",
      "definition" : "Broadcaster"
    },
    {
      "code" : "3367.002",
      "display" : "Compere",
      "definition" : "Compere"
    },
    {
      "code" : "3367.003",
      "display" : "Disc Jockey",
      "definition" : "Disc Jockey"
    },
    {
      "code" : "3367.004",
      "display" : "DJ",
      "definition" : "DJ"
    },
    {
      "code" : "3367.005",
      "display" : "Newscaster",
      "definition" : "Newscaster"
    },
    {
      "code" : "3367.006",
      "display" : "Newsreader",
      "definition" : "Newsreader"
    },
    {
      "code" : "3367.007",
      "display" : "Radio Announcer",
      "definition" : "Radio Announcer"
    },
    {
      "code" : "3367.008",
      "display" : "Radio Broadcaster",
      "definition" : "Radio Broadcaster"
    },
    {
      "code" : "3367.009",
      "display" : "Radio Presenter",
      "definition" : "Radio Presenter"
    },
    {
      "code" : "3367.010",
      "display" : "Sports Commentator",
      "definition" : "Sports Commentator"
    },
    {
      "code" : "3367.011",
      "display" : "Television Announcer",
      "definition" : "Television Announcer"
    },
    {
      "code" : "3367.012",
      "display" : "Television Broadcaster",
      "definition" : "Television Broadcaster"
    },
    {
      "code" : "3367.013",
      "display" : "Television Presenter",
      "definition" : "Television Presenter"
    },
    {
      "code" : "3367.014",
      "display" : "TV Presenter",
      "definition" : "TV Presenter"
    },
    {
      "code" : "3368.001",
      "display" : "Acrobat",
      "definition" : "Acrobat"
    },
    {
      "code" : "3368.002",
      "display" : "Astrologer",
      "definition" : "Astrologer"
    },
    {
      "code" : "3368.003",
      "display" : "Circus Performer",
      "definition" : "Circus Performer"
    },
    {
      "code" : "3368.004",
      "display" : "Clown",
      "definition" : "Clown"
    },
    {
      "code" : "3368.005",
      "display" : "Comedian",
      "definition" : "Comedian"
    },
    {
      "code" : "3368.006",
      "display" : "Entertainer",
      "definition" : "Entertainer"
    },
    {
      "code" : "3368.007",
      "display" : "Female Impersonator",
      "definition" : "Female Impersonator"
    },
    {
      "code" : "3368.008",
      "display" : "Fortune Teller",
      "definition" : "Fortune Teller"
    },
    {
      "code" : "3368.009",
      "display" : "Handwriting Expert",
      "definition" : "Handwriting Expert"
    },
    {
      "code" : "3368.010",
      "display" : "Hypnotist",
      "definition" : "Hypnotist"
    },
    {
      "code" : "3368.011",
      "display" : "Magician",
      "definition" : "Magician"
    },
    {
      "code" : "3368.012",
      "display" : "Puppet Showman",
      "definition" : "Puppet Showman"
    },
    {
      "code" : "3368.013",
      "display" : "Showman",
      "definition" : "Showman"
    },
    {
      "code" : "3368.014",
      "display" : "Side Show Performer",
      "definition" : "Side Show Performer"
    },
    {
      "code" : "3368.015",
      "display" : "Strip Tease Artist",
      "definition" : "Strip Tease Artist"
    },
    {
      "code" : "3368.016",
      "display" : "Vaudeville Performer",
      "definition" : "Vaudeville Performer"
    },
    {
      "code" : "3368.017",
      "display" : "Ventriloquist",
      "definition" : "Ventriloquist"
    },
    {
      "code" : "3369.001",
      "display" : "Aerobics Instructor",
      "definition" : "Aerobics Instructor"
    },
    {
      "code" : "3369.002",
      "display" : "Aquafitness Instructor",
      "definition" : "Aquafitness Instructor"
    },
    {
      "code" : "3369.003",
      "display" : "Athlete",
      "definition" : "Athlete"
    },
    {
      "code" : "3369.004",
      "display" : "Athletic Coach",
      "definition" : "Athletic Coach"
    },
    {
      "code" : "3369.005",
      "display" : "Boxer",
      "definition" : "Boxer"
    },
    {
      "code" : "3369.006",
      "display" : "Coach",
      "definition" : "Coach"
    },
    {
      "code" : "3369.007",
      "display" : "Cricketer",
      "definition" : "Cricketer"
    },
    {
      "code" : "3369.008",
      "display" : "Fitness Centre Worker",
      "definition" : "Fitness Centre Worker"
    },
    {
      "code" : "3369.009",
      "display" : "Fitness Consultant",
      "definition" : "Fitness Consultant"
    },
    {
      "code" : "3369.010",
      "display" : "Fitness Inspector",
      "definition" : "Fitness Inspector"
    },
    {
      "code" : "3369.011",
      "display" : "Fitness Instructor",
      "definition" : "Fitness Instructor"
    },
    {
      "code" : "3369.012",
      "display" : "Golfer",
      "definition" : "Golfer"
    },
    {
      "code" : "3369.013",
      "display" : "Gym Instructor",
      "definition" : "Gym Instructor"
    },
    {
      "code" : "3369.014",
      "display" : "Gym Trainer",
      "definition" : "Gym Trainer"
    },
    {
      "code" : "3369.015",
      "display" : "Harness Racing Driver",
      "definition" : "Harness Racing Driver"
    },
    {
      "code" : "3369.016",
      "display" : "Health and Fitness Instructor",
      "definition" : "Health and Fitness Instructor"
    },
    {
      "code" : "3369.017",
      "display" : "Jockey",
      "definition" : "Jockey"
    },
    {
      "code" : "3369.018",
      "display" : "Judo Instructor",
      "definition" : "Judo Instructor"
    },
    {
      "code" : "3369.019",
      "display" : "Martial Arts Instructor",
      "definition" : "Martial Arts Instructor"
    },
    {
      "code" : "3369.020",
      "display" : "Outdoor Instructor",
      "definition" : "Outdoor Instructor"
    },
    {
      "code" : "3369.021",
      "display" : "Physical Training Instructor",
      "definition" : "Physical Training Instructor"
    },
    {
      "code" : "3369.022",
      "display" : "Professional Sports Coach",
      "definition" : "Professional Sports Coach"
    },
    {
      "code" : "3369.023",
      "display" : "Professional Sportsperson",
      "definition" : "Professional Sportsperson"
    },
    {
      "code" : "3369.024",
      "display" : "Racecourse Official",
      "definition" : "Racecourse Official"
    },
    {
      "code" : "3369.025",
      "display" : "Racecourse Starter",
      "definition" : "Racecourse Starter"
    },
    {
      "code" : "3369.026",
      "display" : "Racecourse Steward",
      "definition" : "Racecourse Steward"
    },
    {
      "code" : "3369.027",
      "display" : "Racecourse Timekeeper",
      "definition" : "Racecourse Timekeeper"
    },
    {
      "code" : "3369.028",
      "display" : "Referee",
      "definition" : "Referee"
    },
    {
      "code" : "3369.029",
      "display" : "Riding School Instructor",
      "definition" : "Riding School Instructor"
    },
    {
      "code" : "3369.030",
      "display" : "Rugby League Player",
      "definition" : "Rugby League Player"
    },
    {
      "code" : "3369.031",
      "display" : "Rugby Player",
      "definition" : "Rugby Player"
    },
    {
      "code" : "3369.032",
      "display" : "Ski Coach",
      "definition" : "Ski Coach"
    },
    {
      "code" : "3369.033",
      "display" : "Ski Instructor",
      "definition" : "Ski Instructor"
    },
    {
      "code" : "3369.034",
      "display" : "Ski Patrol Director",
      "definition" : "Ski Patrol Director"
    },
    {
      "code" : "3369.035",
      "display" : "Ski Tutor",
      "definition" : "Ski Tutor"
    },
    {
      "code" : "3369.036",
      "display" : "Snowboard Instructor",
      "definition" : "Snowboard Instructor"
    },
    {
      "code" : "3369.037",
      "display" : "Sports Coach",
      "definition" : "Sports Coach"
    },
    {
      "code" : "3369.038",
      "display" : "Sports Coach and Trainer",
      "definition" : "Sports Coach and Trainer"
    },
    {
      "code" : "3369.039",
      "display" : "Sports Official",
      "definition" : "Sports Official"
    },
    {
      "code" : "3369.040",
      "display" : "Sports Trainer",
      "definition" : "Sports Trainer"
    },
    {
      "code" : "3369.041",
      "display" : "Sportsman",
      "definition" : "Sportsman"
    },
    {
      "code" : "3369.042",
      "display" : "Sportsperson",
      "definition" : "Sportsperson"
    },
    {
      "code" : "3369.043",
      "display" : "Sportswoman",
      "definition" : "Sportswoman"
    },
    {
      "code" : "3369.044",
      "display" : "Stipendiary Steward",
      "definition" : "Stipendiary Steward"
    },
    {
      "code" : "3369.045",
      "display" : "Surf Patrolman",
      "definition" : "Surf Patrolman"
    },
    {
      "code" : "3369.046",
      "display" : "Swimming Instructor",
      "definition" : "Swimming Instructor"
    },
    {
      "code" : "3369.047",
      "display" : "Swimming Teacher",
      "definition" : "Swimming Teacher"
    },
    {
      "code" : "3369.048",
      "display" : "Tennis Coach",
      "definition" : "Tennis Coach"
    },
    {
      "code" : "3369.049",
      "display" : "Timekeeper",
      "definition" : "Timekeeper"
    },
    {
      "code" : "3369.050",
      "display" : "Trainer",
      "definition" : "Trainer"
    },
    {
      "code" : "3369.051",
      "display" : "Umpire",
      "definition" : "Umpire"
    },
    {
      "code" : "3369.052",
      "display" : "Wrestler",
      "definition" : "Wrestler"
    },
    {
      "code" : "3369.053",
      "display" : "Yachtsman",
      "definition" : "Yachtsman"
    },
    {
      "code" : "3371.001",
      "display" : "Bible Teacher",
      "definition" : "Bible Teacher"
    },
    {
      "code" : "3371.002",
      "display" : "Christian Mission Worker",
      "definition" : "Christian Mission Worker"
    },
    {
      "code" : "3371.003",
      "display" : "Christian Science Practitioner",
      "definition" : "Christian Science Practitioner"
    },
    {
      "code" : "3371.004",
      "display" : "Church Worker",
      "definition" : "Church Worker"
    },
    {
      "code" : "3371.005",
      "display" : "Evangelist",
      "definition" : "Evangelist"
    },
    {
      "code" : "3371.006",
      "display" : "Member of Religious Order",
      "definition" : "Member of Religious Order"
    },
    {
      "code" : "3371.007",
      "display" : "Missionary",
      "definition" : "Missionary"
    },
    {
      "code" : "3371.008",
      "display" : "Missionary Non-Ordained",
      "definition" : "Missionary Non-Ordained"
    },
    {
      "code" : "3371.009",
      "display" : "Non-Ordained Religious Assistant",
      "definition" : "Non-Ordained Religious Assistant"
    },
    {
      "code" : "3371.010",
      "display" : "Nun",
      "definition" : "Nun"
    },
    {
      "code" : "3371.011",
      "display" : "Psychic Healer",
      "definition" : "Psychic Healer"
    },
    {
      "code" : "3371.012",
      "display" : "Religious Layman",
      "definition" : "Religious Layman"
    },
    {
      "code" : "3371.013",
      "display" : "Religious Sister",
      "definition" : "Religious Sister"
    },
    {
      "code" : "3371.014",
      "display" : "Religious Worker",
      "definition" : "Religious Worker"
    },
    {
      "code" : "3371.015",
      "display" : "Theologian",
      "definition" : "Theologian"
    },
    {
      "code" : "3371.016",
      "display" : "Transcendental Meditation Practitioner",
      "definition" : "Transcendental Meditation Practitioner"
    },
    {
      "code" : "3371.017",
      "display" : "Yoga Teacher",
      "definition" : "Yoga Teacher"
    },
    {
      "code" : "3381.001",
      "display" : "Acclimatisation Field Officer",
      "definition" : "Acclimatisation Field Officer"
    },
    {
      "code" : "3381.002",
      "display" : "Acclimatisation Ranger",
      "definition" : "Acclimatisation Ranger"
    },
    {
      "code" : "3381.003",
      "display" : "Beach and Estuary Warden",
      "definition" : "Beach and Estuary Warden"
    },
    {
      "code" : "3381.004",
      "display" : "Fish and Game Warden",
      "definition" : "Fish and Game Warden"
    },
    {
      "code" : "3381.005",
      "display" : "National Park Ranger",
      "definition" : "National Park Ranger"
    },
    {
      "code" : "3381.006",
      "display" : "Park Ranger",
      "definition" : "Park Ranger"
    },
    {
      "code" : "3381.007",
      "display" : "Wildlife Officer",
      "definition" : "Wildlife Officer"
    },
    {
      "code" : "4111.001",
      "display" : "Audio Typist",
      "definition" : "Audio Typist"
    },
    {
      "code" : "4111.002",
      "display" : "Bank Typist",
      "definition" : "Bank Typist"
    },
    {
      "code" : "4111.003",
      "display" : "Computer Assisted Transcript Operator",
      "definition" : "Computer Assisted Transcript Operator"
    },
    {
      "code" : "4111.004",
      "display" : "Dictaphone Typist",
      "definition" : "Dictaphone Typist"
    },
    {
      "code" : "4111.005",
      "display" : "Hansard Reporter",
      "definition" : "Hansard Reporter"
    },
    {
      "code" : "4111.006",
      "display" : "Medical Typist",
      "definition" : "Medical Typist"
    },
    {
      "code" : "4111.007",
      "display" : "Public Typist",
      "definition" : "Public Typist"
    },
    {
      "code" : "4111.008",
      "display" : "Shorthand Typist",
      "definition" : "Shorthand Typist"
    },
    {
      "code" : "4111.009",
      "display" : "Staff Typist",
      "definition" : "Staff Typist"
    },
    {
      "code" : "4111.010",
      "display" : "Stenographer",
      "definition" : "Stenographer"
    },
    {
      "code" : "4111.011",
      "display" : "Typist",
      "definition" : "Typist"
    },
    {
      "code" : "4111.012",
      "display" : "Typist and Word Processor Operator",
      "definition" : "Typist and Word Processor Operator"
    },
    {
      "code" : "4111.013",
      "display" : "Typist Clerk",
      "definition" : "Typist Clerk"
    },
    {
      "code" : "4111.014",
      "display" : "Typist Secretary",
      "definition" : "Typist Secretary"
    },
    {
      "code" : "4111.015",
      "display" : "Verbatim Reporter",
      "definition" : "Verbatim Reporter"
    },
    {
      "code" : "4111.016",
      "display" : "Word Processing Operator",
      "definition" : "Word Processing Operator"
    },
    {
      "code" : "4111.017",
      "display" : "Word Processor",
      "definition" : "Word Processor"
    },
    {
      "code" : "4111.018",
      "display" : "Word Processor Operator",
      "definition" : "Word Processor Operator"
    },
    {
      "code" : "4111.019",
      "display" : "WP Operator",
      "definition" : "WP Operator"
    },
    {
      "code" : "4112.001",
      "display" : "Coding Clerk",
      "definition" : "Coding Clerk"
    },
    {
      "code" : "4112.002",
      "display" : "Coding Data Processing Clerk",
      "definition" : "Coding Data Processing Clerk"
    },
    {
      "code" : "4112.003",
      "display" : "Data Control Clerk",
      "definition" : "Data Control Clerk"
    },
    {
      "code" : "4112.004",
      "display" : "Data Entry Clerk",
      "definition" : "Data Entry Clerk"
    },
    {
      "code" : "4112.005",
      "display" : "Data Entry Operator",
      "definition" : "Data Entry Operator"
    },
    {
      "code" : "4112.006",
      "display" : "Data Entry Supervisor",
      "definition" : "Data Entry Supervisor"
    },
    {
      "code" : "4112.007",
      "display" : "Data Processing Machine Operator",
      "definition" : "Data Processing Machine Operator"
    },
    {
      "code" : "4112.008",
      "display" : "Electronic Data Processor",
      "definition" : "Electronic Data Processor"
    },
    {
      "code" : "4112.009",
      "display" : "Flexowriter Printer",
      "definition" : "Flexowriter Printer"
    },
    {
      "code" : "4112.010",
      "display" : "Kaiwhakauru Hotuku",
      "definition" : "Kaiwhakauru Hotuku"
    },
    {
      "code" : "4112.011",
      "display" : "Kaiwhakauru Tatai",
      "definition" : "Kaiwhakauru Tatai"
    },
    {
      "code" : "4112.012",
      "display" : "Kaiwhakaurunga Tatai",
      "definition" : "Kaiwhakaurunga Tatai"
    },
    {
      "code" : "4112.013",
      "display" : "Kaiwhakuru Hootuku",
      "definition" : "Kaiwhakuru Hootuku"
    },
    {
      "code" : "4112.014",
      "display" : "Key Punch Operator",
      "definition" : "Key Punch Operator"
    },
    {
      "code" : "4112.015",
      "display" : "Keyboard Operator",
      "definition" : "Keyboard Operator"
    },
    {
      "code" : "4112.016",
      "display" : "Punched Card Machine Operator",
      "definition" : "Punched Card Machine Operator"
    },
    {
      "code" : "4112.017",
      "display" : "Quality Controller Of Data Entry Operators",
      "definition" : "Quality Controller Of Data Entry Operators"
    },
    {
      "code" : "4112.018",
      "display" : "Teleprompt Operator",
      "definition" : "Teleprompt Operator"
    },
    {
      "code" : "4112.019",
      "display" : "VDU Operator",
      "definition" : "VDU Operator"
    },
    {
      "code" : "4112.020",
      "display" : "Visual Display Unit Operator",
      "definition" : "Visual Display Unit Operator"
    },
    {
      "code" : "4114.001",
      "display" : "Company Secretary Clerical",
      "definition" : "Company Secretary Clerical"
    },
    {
      "code" : "4114.002",
      "display" : "Correspondence Clerk",
      "definition" : "Correspondence Clerk"
    },
    {
      "code" : "4114.003",
      "display" : "Executive Assistant",
      "definition" : "Executive Assistant"
    },
    {
      "code" : "4114.004",
      "display" : "Farm Secretary",
      "definition" : "Farm Secretary"
    },
    {
      "code" : "4114.005",
      "display" : "Hekeretari",
      "definition" : "Hekeretari"
    },
    {
      "code" : "4114.006",
      "display" : "Kaiawhina Tumuaki",
      "definition" : "Kaiawhina Tumuaki"
    },
    {
      "code" : "4114.007",
      "display" : "Legal Secretary",
      "definition" : "Legal Secretary"
    },
    {
      "code" : "4114.008",
      "display" : "Office Secretary",
      "definition" : "Office Secretary"
    },
    {
      "code" : "4114.009",
      "display" : "PA Secretary",
      "definition" : "PA Secretary"
    },
    {
      "code" : "4114.010",
      "display" : "Personal Assistant",
      "definition" : "Personal Assistant"
    },
    {
      "code" : "4114.011",
      "display" : "Personal Secretary",
      "definition" : "Personal Secretary"
    },
    {
      "code" : "4114.012",
      "display" : "Private Secretary",
      "definition" : "Private Secretary"
    },
    {
      "code" : "4114.013",
      "display" : "Quality Controller Of Secretarys",
      "definition" : "Quality Controller Of Secretarys"
    },
    {
      "code" : "4114.014",
      "display" : "School Secretary",
      "definition" : "School Secretary"
    },
    {
      "code" : "4114.015",
      "display" : "Secretary",
      "definition" : "Secretary"
    },
    {
      "code" : "4121.001",
      "display" : "Accountancy Clerk",
      "definition" : "Accountancy Clerk"
    },
    {
      "code" : "4121.002",
      "display" : "Accounting Clerk",
      "definition" : "Accounting Clerk"
    },
    {
      "code" : "4121.003",
      "display" : "Accounting Machinist",
      "definition" : "Accounting Machinist"
    },
    {
      "code" : "4121.004",
      "display" : "Accounts Administrator",
      "definition" : "Accounts Administrator"
    },
    {
      "code" : "4121.005",
      "display" : "Accounts Clerk",
      "definition" : "Accounts Clerk"
    },
    {
      "code" : "4121.006",
      "display" : "Accounts Controller",
      "definition" : "Accounts Controller"
    },
    {
      "code" : "4121.007",
      "display" : "Accounts Officer",
      "definition" : "Accounts Officer"
    },
    {
      "code" : "4121.008",
      "display" : "Accounts Payable Clerk",
      "definition" : "Accounts Payable Clerk"
    },
    {
      "code" : "4121.009",
      "display" : "Accounts Receivable Clerk",
      "definition" : "Accounts Receivable Clerk"
    },
    {
      "code" : "4121.010",
      "display" : "Adding Machine Operator",
      "definition" : "Adding Machine Operator"
    },
    {
      "code" : "4121.011",
      "display" : "Audit Assistant",
      "definition" : "Audit Assistant"
    },
    {
      "code" : "4121.012",
      "display" : "Audit Clerk",
      "definition" : "Audit Clerk"
    },
    {
      "code" : "4121.013",
      "display" : "Bookkeeping Clerk",
      "definition" : "Bookkeeping Clerk"
    },
    {
      "code" : "4121.014",
      "display" : "Bookkeeping Machine Operator",
      "definition" : "Bookkeeping Machine Operator"
    },
    {
      "code" : "4121.015",
      "display" : "Burroughs Machine Operator",
      "definition" : "Burroughs Machine Operator"
    },
    {
      "code" : "4121.016",
      "display" : "Calculating Machine Operator",
      "definition" : "Calculating Machine Operator"
    },
    {
      "code" : "4121.017",
      "display" : "Calculation Clerk",
      "definition" : "Calculation Clerk"
    },
    {
      "code" : "4121.018",
      "display" : "Costing Clerk",
      "definition" : "Costing Clerk"
    },
    {
      "code" : "4121.019",
      "display" : "Costing Estimator",
      "definition" : "Costing Estimator"
    },
    {
      "code" : "4121.020",
      "display" : "Debtors Clerk",
      "definition" : "Debtors Clerk"
    },
    {
      "code" : "4121.021",
      "display" : "Invoicing Machine Operator",
      "definition" : "Invoicing Machine Operator"
    },
    {
      "code" : "4121.022",
      "display" : "Kairekoata Moni",
      "definition" : "Kairekoata Moni"
    },
    {
      "code" : "4121.023",
      "display" : "Kaiutuutu Kaute",
      "definition" : "Kaiutuutu Kaute"
    },
    {
      "code" : "4121.024",
      "display" : "Karaka Utuutu Kaute",
      "definition" : "Karaka Utuutu Kaute"
    },
    {
      "code" : "4121.025",
      "display" : "Ledger Keeping Machinist",
      "definition" : "Ledger Keeping Machinist"
    },
    {
      "code" : "4121.026",
      "display" : "Legal Accounts Clerk",
      "definition" : "Legal Accounts Clerk"
    },
    {
      "code" : "4121.027",
      "display" : "Meter Reader Electric",
      "definition" : "Meter Reader Electric"
    },
    {
      "code" : "4121.028",
      "display" : "Payments Clerk",
      "definition" : "Payments Clerk"
    },
    {
      "code" : "4121.029",
      "display" : "Pricing Clerk",
      "definition" : "Pricing Clerk"
    },
    {
      "code" : "4121.030",
      "display" : "Quality Controller Of Audit Clerks",
      "definition" : "Quality Controller Of Audit Clerks"
    },
    {
      "code" : "4121.031",
      "display" : "Rates Clerk",
      "definition" : "Rates Clerk"
    },
    {
      "code" : "4121.032",
      "display" : "Rating Officer",
      "definition" : "Rating Officer"
    },
    {
      "code" : "4121.033",
      "display" : "Royalties Clerk",
      "definition" : "Royalties Clerk"
    },
    {
      "code" : "4122.001",
      "display" : "Assistant Regional Field Supervisor",
      "definition" : "Assistant Regional Field Supervisor"
    },
    {
      "code" : "4122.002",
      "display" : "Brokerage Clerk",
      "definition" : "Brokerage Clerk"
    },
    {
      "code" : "4122.003",
      "display" : "Canvasser",
      "definition" : "Canvasser"
    },
    {
      "code" : "4122.004",
      "display" : "Census Area Supervisor",
      "definition" : "Census Area Supervisor"
    },
    {
      "code" : "4122.005",
      "display" : "Census Clerk",
      "definition" : "Census Clerk"
    },
    {
      "code" : "4122.006",
      "display" : "Census Enumerator",
      "definition" : "Census Enumerator"
    },
    {
      "code" : "4122.007",
      "display" : "Census Field Supervisor",
      "definition" : "Census Field Supervisor"
    },
    {
      "code" : "4122.008",
      "display" : "Census Processing Manager",
      "definition" : "Census Processing Manager"
    },
    {
      "code" : "4122.009",
      "display" : "Clerk Field Collections",
      "definition" : "Clerk Field Collections"
    },
    {
      "code" : "4122.010",
      "display" : "Credit Clerk",
      "definition" : "Credit Clerk"
    },
    {
      "code" : "4122.011",
      "display" : "Data Capture and Edit Team Leader",
      "definition" : "Data Capture and Edit Team Leader"
    },
    {
      "code" : "4122.012",
      "display" : "Deputy Census Coordinator",
      "definition" : "Deputy Census Coordinator"
    },
    {
      "code" : "4122.013",
      "display" : "Enumerator",
      "definition" : "Enumerator"
    },
    {
      "code" : "4122.014",
      "display" : "Field Officer Clerical",
      "definition" : "Field Officer Clerical"
    },
    {
      "code" : "4122.015",
      "display" : "Finance Clerk",
      "definition" : "Finance Clerk"
    },
    {
      "code" : "4122.016",
      "display" : "Finance Officer",
      "definition" : "Finance Officer"
    },
    {
      "code" : "4122.017",
      "display" : "Interviewer",
      "definition" : "Interviewer"
    },
    {
      "code" : "4122.018",
      "display" : "Loans Officer",
      "definition" : "Loans Officer"
    },
    {
      "code" : "4122.019",
      "display" : "Market Research Interviewer",
      "definition" : "Market Research Interviewer"
    },
    {
      "code" : "4122.020",
      "display" : "Market Research Reporter",
      "definition" : "Market Research Reporter"
    },
    {
      "code" : "4122.021",
      "display" : "Market Survey Interviewer",
      "definition" : "Market Survey Interviewer"
    },
    {
      "code" : "4122.022",
      "display" : "Mortgage Clerk",
      "definition" : "Mortgage Clerk"
    },
    {
      "code" : "4122.023",
      "display" : "Phone Surveyor",
      "definition" : "Phone Surveyor"
    },
    {
      "code" : "4122.024",
      "display" : "Poll Interviewer",
      "definition" : "Poll Interviewer"
    },
    {
      "code" : "4122.025",
      "display" : "Research Interviewer",
      "definition" : "Research Interviewer"
    },
    {
      "code" : "4122.026",
      "display" : "Sales Canvasser",
      "definition" : "Sales Canvasser"
    },
    {
      "code" : "4122.027",
      "display" : "Statistical Clerk",
      "definition" : "Statistical Clerk"
    },
    {
      "code" : "4122.028",
      "display" : "Statistics Clerk",
      "definition" : "Statistics Clerk"
    },
    {
      "code" : "4122.029",
      "display" : "Survey Design Statistician",
      "definition" : "Survey Design Statistician"
    },
    {
      "code" : "4122.030",
      "display" : "Survey Interviewer",
      "definition" : "Survey Interviewer"
    },
    {
      "code" : "4122.031",
      "display" : "Survey Statistician",
      "definition" : "Survey Statistician"
    },
    {
      "code" : "4122.032",
      "display" : "Telemarketer",
      "definition" : "Telemarketer"
    },
    {
      "code" : "4122.033",
      "display" : "Telephone Canvasser",
      "definition" : "Telephone Canvasser"
    },
    {
      "code" : "4122.034",
      "display" : "Telephone Sales Person",
      "definition" : "Telephone Sales Person"
    },
    {
      "code" : "4122.035",
      "display" : "Telephone Salesperson",
      "definition" : "Telephone Salesperson"
    },
    {
      "code" : "4122.036",
      "display" : "Telephone Surveyor",
      "definition" : "Telephone Surveyor"
    },
    {
      "code" : "4131.001",
      "display" : "Bulk Store Supervisor",
      "definition" : "Bulk Store Supervisor"
    },
    {
      "code" : "4131.002",
      "display" : "Cargo Agent",
      "definition" : "Cargo Agent"
    },
    {
      "code" : "4131.003",
      "display" : "Check Weighman",
      "definition" : "Check Weighman"
    },
    {
      "code" : "4131.004",
      "display" : "Customs Agent",
      "definition" : "Customs Agent"
    },
    {
      "code" : "4131.005",
      "display" : "Customs Agents Clerk",
      "definition" : "Customs Agents Clerk"
    },
    {
      "code" : "4131.006",
      "display" : "Customs Broker",
      "definition" : "Customs Broker"
    },
    {
      "code" : "4131.007",
      "display" : "Customs Clerk",
      "definition" : "Customs Clerk"
    },
    {
      "code" : "4131.008",
      "display" : "Despatch Clerk",
      "definition" : "Despatch Clerk"
    },
    {
      "code" : "4131.009",
      "display" : "Dispatch and Receiving Clerk",
      "definition" : "Dispatch and Receiving Clerk"
    },
    {
      "code" : "4131.010",
      "display" : "Dispatch Clerk",
      "definition" : "Dispatch Clerk"
    },
    {
      "code" : "4131.011",
      "display" : "Dispatch Storeman",
      "definition" : "Dispatch Storeman"
    },
    {
      "code" : "4131.012",
      "display" : "Dispatch Storeperson",
      "definition" : "Dispatch Storeperson"
    },
    {
      "code" : "4131.013",
      "display" : "Dispatch Supervisor",
      "definition" : "Dispatch Supervisor"
    },
    {
      "code" : "4131.014",
      "display" : "Distribution Officer",
      "definition" : "Distribution Officer"
    },
    {
      "code" : "4131.015",
      "display" : "Export Clerk",
      "definition" : "Export Clerk"
    },
    {
      "code" : "4131.016",
      "display" : "Forwarding Agent",
      "definition" : "Forwarding Agent"
    },
    {
      "code" : "4131.017",
      "display" : "Freight Forwarder",
      "definition" : "Freight Forwarder"
    },
    {
      "code" : "4131.018",
      "display" : "Import and Export Clerk",
      "definition" : "Import and Export Clerk"
    },
    {
      "code" : "4131.019",
      "display" : "Inventory Clerk",
      "definition" : "Inventory Clerk"
    },
    {
      "code" : "4131.020",
      "display" : "Inventory Officer",
      "definition" : "Inventory Officer"
    },
    {
      "code" : "4131.021",
      "display" : "Invoice Clerk",
      "definition" : "Invoice Clerk"
    },
    {
      "code" : "4131.022",
      "display" : "Invoicing Clerk",
      "definition" : "Invoicing Clerk"
    },
    {
      "code" : "4131.023",
      "display" : "Inwards Goods Clerk",
      "definition" : "Inwards Goods Clerk"
    },
    {
      "code" : "4131.024",
      "display" : "Kaimahi Whare Putunga",
      "definition" : "Kaimahi Whare Putunga"
    },
    {
      "code" : "4131.025",
      "display" : "Kaimahi Wharerangi",
      "definition" : "Kaimahi Wharerangi"
    },
    {
      "code" : "4131.026",
      "display" : "Kaituku",
      "definition" : "Kaituku"
    },
    {
      "code" : "4131.027",
      "display" : "Kaituku Taonga",
      "definition" : "Kaituku Taonga"
    },
    {
      "code" : "4131.028",
      "display" : "Kaiwhakahaere Mau Mai Tuku Atu Taonga",
      "definition" : "Kaiwhakahaere Mau Mai Tuku Atu Taonga"
    },
    {
      "code" : "4131.029",
      "display" : "Kaiwhakahaere Rekoata",
      "definition" : "Kaiwhakahaere Rekoata"
    },
    {
      "code" : "4131.030",
      "display" : "Manufacturing Distributor",
      "definition" : "Manufacturing Distributor"
    },
    {
      "code" : "4131.031",
      "display" : "Parts Warehouse Clerk",
      "definition" : "Parts Warehouse Clerk"
    },
    {
      "code" : "4131.032",
      "display" : "Produce Tally Clerk",
      "definition" : "Produce Tally Clerk"
    },
    {
      "code" : "4131.033",
      "display" : "Property Man Theatre",
      "definition" : "Property Man Theatre"
    },
    {
      "code" : "4131.034",
      "display" : "Purchasing and Inventory Officer",
      "definition" : "Purchasing and Inventory Officer"
    },
    {
      "code" : "4131.035",
      "display" : "Purchasing Clerk",
      "definition" : "Purchasing Clerk"
    },
    {
      "code" : "4131.036",
      "display" : "Receiving Clerk",
      "definition" : "Receiving Clerk"
    },
    {
      "code" : "4131.037",
      "display" : "Sales Clerk Engineering",
      "definition" : "Sales Clerk Engineering"
    },
    {
      "code" : "4131.038",
      "display" : "Shipping Freight Clerk",
      "definition" : "Shipping Freight Clerk"
    },
    {
      "code" : "4131.039",
      "display" : "Shipping Officer",
      "definition" : "Shipping Officer"
    },
    {
      "code" : "4131.040",
      "display" : "Shipping Tally Clerk",
      "definition" : "Shipping Tally Clerk"
    },
    {
      "code" : "4131.041",
      "display" : "Ships Providore",
      "definition" : "Ships Providore"
    },
    {
      "code" : "4131.042",
      "display" : "Stock Clerk",
      "definition" : "Stock Clerk"
    },
    {
      "code" : "4131.043",
      "display" : "Stock Control Clerk",
      "definition" : "Stock Control Clerk"
    },
    {
      "code" : "4131.044",
      "display" : "Stock Controller",
      "definition" : "Stock Controller"
    },
    {
      "code" : "4131.045",
      "display" : "Stock Officer",
      "definition" : "Stock Officer"
    },
    {
      "code" : "4131.046",
      "display" : "Stockroom Controller",
      "definition" : "Stockroom Controller"
    },
    {
      "code" : "4131.047",
      "display" : "Storage Clerk",
      "definition" : "Storage Clerk"
    },
    {
      "code" : "4131.048",
      "display" : "Store Enquiries Clerk",
      "definition" : "Store Enquiries Clerk"
    },
    {
      "code" : "4131.049",
      "display" : "Storekeeping Officer",
      "definition" : "Storekeeping Officer"
    },
    {
      "code" : "4131.050",
      "display" : "Storeperson Enquiries",
      "definition" : "Storeperson Enquiries"
    },
    {
      "code" : "4131.051",
      "display" : "Storeperson General",
      "definition" : "Storeperson General"
    },
    {
      "code" : "4131.052",
      "display" : "Storeperson General Assistant",
      "definition" : "Storeperson General Assistant"
    },
    {
      "code" : "4131.053",
      "display" : "Storeroom Clerk",
      "definition" : "Storeroom Clerk"
    },
    {
      "code" : "4131.054",
      "display" : "Stores Assistant",
      "definition" : "Stores Assistant"
    },
    {
      "code" : "4131.055",
      "display" : "Supervisor Supplies",
      "definition" : "Supervisor Supplies"
    },
    {
      "code" : "4131.056",
      "display" : "Tally Clerk",
      "definition" : "Tally Clerk"
    },
    {
      "code" : "4131.057",
      "display" : "Taonga Wheketere",
      "definition" : "Taonga Wheketere"
    },
    {
      "code" : "4131.058",
      "display" : "Warehouse Clerk",
      "definition" : "Warehouse Clerk"
    },
    {
      "code" : "4131.059",
      "display" : "Warehouse Storeman",
      "definition" : "Warehouse Storeman"
    },
    {
      "code" : "4131.060",
      "display" : "Warehouse Storeperson",
      "definition" : "Warehouse Storeperson"
    },
    {
      "code" : "4131.061",
      "display" : "Warehouse Supervisor Clerical",
      "definition" : "Warehouse Supervisor Clerical"
    },
    {
      "code" : "4131.062",
      "display" : "Weighbridge Attendant",
      "definition" : "Weighbridge Attendant"
    },
    {
      "code" : "4131.063",
      "display" : "Weighing and Tally Clerk",
      "definition" : "Weighing and Tally Clerk"
    },
    {
      "code" : "4131.064",
      "display" : "Weighing Clerk",
      "definition" : "Weighing Clerk"
    },
    {
      "code" : "4131.065",
      "display" : "Weighmaster",
      "definition" : "Weighmaster"
    },
    {
      "code" : "4132.001",
      "display" : "Coordinating Clerk",
      "definition" : "Coordinating Clerk"
    },
    {
      "code" : "4132.002",
      "display" : "Material and Production Planning Clerk",
      "definition" : "Material and Production Planning Clerk"
    },
    {
      "code" : "4132.003",
      "display" : "Material Planning Clerk",
      "definition" : "Material Planning Clerk"
    },
    {
      "code" : "4132.004",
      "display" : "Materials Planner",
      "definition" : "Materials Planner"
    },
    {
      "code" : "4132.005",
      "display" : "Production Clerk Officer",
      "definition" : "Production Clerk Officer"
    },
    {
      "code" : "4132.006",
      "display" : "Production Controller",
      "definition" : "Production Controller"
    },
    {
      "code" : "4132.007",
      "display" : "Production Planner",
      "definition" : "Production Planner"
    },
    {
      "code" : "4132.008",
      "display" : "Production Planning Clerk",
      "definition" : "Production Planning Clerk"
    },
    {
      "code" : "4132.009",
      "display" : "Production Planning Supervisor",
      "definition" : "Production Planning Supervisor"
    },
    {
      "code" : "4132.010",
      "display" : "Production Scheduler",
      "definition" : "Production Scheduler"
    },
    {
      "code" : "4132.011",
      "display" : "Quality Controller Of Material And Production Clerks",
      "definition" : "Quality Controller Of Material And Production Clerks"
    },
    {
      "code" : "4132.012",
      "display" : "Schedule Clerk",
      "definition" : "Schedule Clerk"
    },
    {
      "code" : "4133.001",
      "display" : "Air Transport Supervisor",
      "definition" : "Air Transport Supervisor"
    },
    {
      "code" : "4133.002",
      "display" : "Boat Dispatcher",
      "definition" : "Boat Dispatcher"
    },
    {
      "code" : "4133.003",
      "display" : "Bus Ticket Inspector",
      "definition" : "Bus Ticket Inspector"
    },
    {
      "code" : "4133.004",
      "display" : "Bus Tram Conductor",
      "definition" : "Bus Tram Conductor"
    },
    {
      "code" : "4133.005",
      "display" : "Cable Car Conductor",
      "definition" : "Cable Car Conductor"
    },
    {
      "code" : "4133.006",
      "display" : "Railway Guard",
      "definition" : "Railway Guard"
    },
    {
      "code" : "4133.007",
      "display" : "Railway Ticket Inspector",
      "definition" : "Railway Ticket Inspector"
    },
    {
      "code" : "4133.008",
      "display" : "Railway Traffic Dispatcher",
      "definition" : "Railway Traffic Dispatcher"
    },
    {
      "code" : "4133.009",
      "display" : "Railway Traffic Inspector",
      "definition" : "Railway Traffic Inspector"
    },
    {
      "code" : "4133.010",
      "display" : "Railway Transport Clerk",
      "definition" : "Railway Transport Clerk"
    },
    {
      "code" : "4133.011",
      "display" : "Railway Transport Service Inspector",
      "definition" : "Railway Transport Service Inspector"
    },
    {
      "code" : "4133.012",
      "display" : "Railways Traffic Foreman",
      "definition" : "Railways Traffic Foreman"
    },
    {
      "code" : "4133.013",
      "display" : "Railways Yard Foreman",
      "definition" : "Railways Yard Foreman"
    },
    {
      "code" : "4133.014",
      "display" : "Railways Yard Master",
      "definition" : "Railways Yard Master"
    },
    {
      "code" : "4133.015",
      "display" : "Road Passenger Transport Inspector",
      "definition" : "Road Passenger Transport Inspector"
    },
    {
      "code" : "4133.016",
      "display" : "Road Traffic Controller",
      "definition" : "Road Traffic Controller"
    },
    {
      "code" : "4133.017",
      "display" : "Road Transport Dispatcher",
      "definition" : "Road Transport Dispatcher"
    },
    {
      "code" : "4133.018",
      "display" : "Shipping Clerk",
      "definition" : "Shipping Clerk"
    },
    {
      "code" : "4133.019",
      "display" : "Supervisor Locomotives",
      "definition" : "Supervisor Locomotives"
    },
    {
      "code" : "4133.020",
      "display" : "Supervisor Other Transport and Communications",
      "definition" : "Supervisor Other Transport and Communications"
    },
    {
      "code" : "4133.021",
      "display" : "Supervisor Railway Goods",
      "definition" : "Supervisor Railway Goods"
    },
    {
      "code" : "4133.022",
      "display" : "Supervisor Railways",
      "definition" : "Supervisor Railways"
    },
    {
      "code" : "4133.023",
      "display" : "Supervisor Road Transport",
      "definition" : "Supervisor Road Transport"
    },
    {
      "code" : "4133.024",
      "display" : "Ticket Collector Railway",
      "definition" : "Ticket Collector Railway"
    },
    {
      "code" : "4133.025",
      "display" : "Traffic Supervisor Airport Airlines",
      "definition" : "Traffic Supervisor Airport Airlines"
    },
    {
      "code" : "4133.026",
      "display" : "Train Control Operator",
      "definition" : "Train Control Operator"
    },
    {
      "code" : "4133.027",
      "display" : "Train Examiner",
      "definition" : "Train Examiner"
    },
    {
      "code" : "4133.028",
      "display" : "Train Guard",
      "definition" : "Train Guard"
    },
    {
      "code" : "4133.029",
      "display" : "Transport Clerk",
      "definition" : "Transport Clerk"
    },
    {
      "code" : "4133.030",
      "display" : "Transport Department Inspector",
      "definition" : "Transport Department Inspector"
    },
    {
      "code" : "4133.031",
      "display" : "Transport Depot Superintendent",
      "definition" : "Transport Depot Superintendent"
    },
    {
      "code" : "4133.032",
      "display" : "Wagon Recorder",
      "definition" : "Wagon Recorder"
    },
    {
      "code" : "4133.033",
      "display" : "Wharfinger",
      "definition" : "Wharfinger"
    },
    {
      "code" : "4141.001",
      "display" : "Cataloguing Clerk",
      "definition" : "Cataloguing Clerk"
    },
    {
      "code" : "4141.002",
      "display" : "Childrens Library Assistant",
      "definition" : "Childrens Library Assistant"
    },
    {
      "code" : "4141.003",
      "display" : "Circulation Desk Assistant",
      "definition" : "Circulation Desk Assistant"
    },
    {
      "code" : "4141.004",
      "display" : "Compiler",
      "definition" : "Compiler"
    },
    {
      "code" : "4141.005",
      "display" : "Directory Compiler",
      "definition" : "Directory Compiler"
    },
    {
      "code" : "4141.006",
      "display" : "Documentation Clerk Officer",
      "definition" : "Documentation Clerk Officer"
    },
    {
      "code" : "4141.007",
      "display" : "Filing Clerk",
      "definition" : "Filing Clerk"
    },
    {
      "code" : "4141.008",
      "display" : "Film Library Clerk",
      "definition" : "Film Library Clerk"
    },
    {
      "code" : "4141.009",
      "display" : "Index Clerk",
      "definition" : "Index Clerk"
    },
    {
      "code" : "4141.010",
      "display" : "Library Assistant",
      "definition" : "Library Assistant"
    },
    {
      "code" : "4141.011",
      "display" : "Listing Clerk",
      "definition" : "Listing Clerk"
    },
    {
      "code" : "4141.012",
      "display" : "Mobile Library Assistant",
      "definition" : "Mobile Library Assistant"
    },
    {
      "code" : "4141.013",
      "display" : "Plan Records Officer",
      "definition" : "Plan Records Officer"
    },
    {
      "code" : "4141.014",
      "display" : "Quality Controller Of Library Assistants",
      "definition" : "Quality Controller Of Library Assistants"
    },
    {
      "code" : "4141.015",
      "display" : "Quality Controller Of Record And Filing Clerk",
      "definition" : "Quality Controller Of Record And Filing Clerk"
    },
    {
      "code" : "4141.016",
      "display" : "Record and Filing Clerk",
      "definition" : "Record and Filing Clerk"
    },
    {
      "code" : "4141.017",
      "display" : "Records Clerk",
      "definition" : "Records Clerk"
    },
    {
      "code" : "4141.018",
      "display" : "Records Officer",
      "definition" : "Records Officer"
    },
    {
      "code" : "4141.019",
      "display" : "Registry Office Keeper",
      "definition" : "Registry Office Keeper"
    },
    {
      "code" : "4141.020",
      "display" : "School Library Assistant",
      "definition" : "School Library Assistant"
    },
    {
      "code" : "4141.021",
      "display" : "Ward Clerk",
      "definition" : "Ward Clerk"
    },
    {
      "code" : "4142.001",
      "display" : "Kaikomiri Mera",
      "definition" : "Kaikomiri Mera"
    },
    {
      "code" : "4142.002",
      "display" : "Kaikomiri Reta",
      "definition" : "Kaikomiri Reta"
    },
    {
      "code" : "4142.003",
      "display" : "Kaikoomiri Meera",
      "definition" : "Kaikoomiri Meera"
    },
    {
      "code" : "4142.004",
      "display" : "Kaikoomiri Reta",
      "definition" : "Kaikoomiri Reta"
    },
    {
      "code" : "4142.005",
      "display" : "Kaikoowhiri Kopaki",
      "definition" : "Kaikoowhiri Kopaki"
    },
    {
      "code" : "4142.006",
      "display" : "Kaikoowhiri Meera",
      "definition" : "Kaikoowhiri Meera"
    },
    {
      "code" : "4142.007",
      "display" : "Kaikoowhiri Reta",
      "definition" : "Kaikoowhiri Reta"
    },
    {
      "code" : "4142.008",
      "display" : "Kaikowhiri Kopaki",
      "definition" : "Kaikowhiri Kopaki"
    },
    {
      "code" : "4142.009",
      "display" : "Kaikowhiri Mera",
      "definition" : "Kaikowhiri Mera"
    },
    {
      "code" : "4142.010",
      "display" : "Kaikowhiri Reta",
      "definition" : "Kaikowhiri Reta"
    },
    {
      "code" : "4142.011",
      "display" : "Mail Carrier",
      "definition" : "Mail Carrier"
    },
    {
      "code" : "4142.012",
      "display" : "Mail Clerk",
      "definition" : "Mail Clerk"
    },
    {
      "code" : "4142.013",
      "display" : "Mail Contractor",
      "definition" : "Mail Contractor"
    },
    {
      "code" : "4142.014",
      "display" : "Mail Delivery Contractor",
      "definition" : "Mail Delivery Contractor"
    },
    {
      "code" : "4142.015",
      "display" : "Mail Dispatch Clerk Office",
      "definition" : "Mail Dispatch Clerk Office"
    },
    {
      "code" : "4142.016",
      "display" : "Mail Dispatch Clerk Post Office",
      "definition" : "Mail Dispatch Clerk Post Office"
    },
    {
      "code" : "4142.017",
      "display" : "Mail Distribution Clerk",
      "definition" : "Mail Distribution Clerk"
    },
    {
      "code" : "4142.018",
      "display" : "Mail Sorter",
      "definition" : "Mail Sorter"
    },
    {
      "code" : "4142.019",
      "display" : "Mail Sorting Clerk",
      "definition" : "Mail Sorting Clerk"
    },
    {
      "code" : "4142.020",
      "display" : "Mailman",
      "definition" : "Mailman"
    },
    {
      "code" : "4142.021",
      "display" : "Post Office Clerk",
      "definition" : "Post Office Clerk"
    },
    {
      "code" : "4142.022",
      "display" : "Post Office Mail Clerk",
      "definition" : "Post Office Mail Clerk"
    },
    {
      "code" : "4142.023",
      "display" : "Post Office Mail Sorter",
      "definition" : "Post Office Mail Sorter"
    },
    {
      "code" : "4142.024",
      "display" : "Post Office Supervisor",
      "definition" : "Post Office Supervisor"
    },
    {
      "code" : "4142.025",
      "display" : "Post Woman",
      "definition" : "Post Woman"
    },
    {
      "code" : "4142.026",
      "display" : "Postal Clerk",
      "definition" : "Postal Clerk"
    },
    {
      "code" : "4142.027",
      "display" : "Postal Deliverer",
      "definition" : "Postal Deliverer"
    },
    {
      "code" : "4142.028",
      "display" : "Postal Services Supervisor Other",
      "definition" : "Postal Services Supervisor Other"
    },
    {
      "code" : "4142.029",
      "display" : "Postal Services Supervisor Post Office",
      "definition" : "Postal Services Supervisor Post Office"
    },
    {
      "code" : "4142.030",
      "display" : "Postal Sorter",
      "definition" : "Postal Sorter"
    },
    {
      "code" : "4142.031",
      "display" : "Postie",
      "definition" : "Postie"
    },
    {
      "code" : "4142.032",
      "display" : "Postman",
      "definition" : "Postman"
    },
    {
      "code" : "4142.033",
      "display" : "Postwoman",
      "definition" : "Postwoman"
    },
    {
      "code" : "4142.034",
      "display" : "Quality Controller Of Mail Clerks",
      "definition" : "Quality Controller Of Mail Clerks"
    },
    {
      "code" : "4142.035",
      "display" : "Quality Controller Of Mail Delivery Contractors",
      "definition" : "Quality Controller Of Mail Delivery Contractors"
    },
    {
      "code" : "4142.036",
      "display" : "Quality Controller Of Mail Sorting Clerks",
      "definition" : "Quality Controller Of Mail Sorting Clerks"
    },
    {
      "code" : "4142.037",
      "display" : "Quality Controller Of Postal Deliverers",
      "definition" : "Quality Controller Of Postal Deliverers"
    },
    {
      "code" : "4142.038",
      "display" : "Rural Delivery Contractor",
      "definition" : "Rural Delivery Contractor"
    },
    {
      "code" : "4142.039",
      "display" : "Rural Mail Contractor",
      "definition" : "Rural Mail Contractor"
    },
    {
      "code" : "4142.040",
      "display" : "Rural Mail Deliverer",
      "definition" : "Rural Mail Deliverer"
    },
    {
      "code" : "4142.041",
      "display" : "Rural Mail Delivery Contractor",
      "definition" : "Rural Mail Delivery Contractor"
    },
    {
      "code" : "4143.001",
      "display" : "Proof Machine Operator",
      "definition" : "Proof Machine Operator"
    },
    {
      "code" : "4143.002",
      "display" : "Proof Reader",
      "definition" : "Proof Reader"
    },
    {
      "code" : "4143.003",
      "display" : "Readers Assistant",
      "definition" : "Readers Assistant"
    },
    {
      "code" : "4144.001",
      "display" : "Accommodation Officer University Hostels",
      "definition" : "Accommodation Officer University Hostels"
    },
    {
      "code" : "4144.002",
      "display" : "Addressing Machine Operator",
      "definition" : "Addressing Machine Operator"
    },
    {
      "code" : "4144.003",
      "display" : "Apihaa rangahau korero",
      "definition" : "Apihaa rangahau korero"
    },
    {
      "code" : "4144.004",
      "display" : "Clerical Assistant",
      "definition" : "Clerical Assistant"
    },
    {
      "code" : "4144.005",
      "display" : "Clerical Supervisor",
      "definition" : "Clerical Supervisor"
    },
    {
      "code" : "4144.006",
      "display" : "Clerical Worker",
      "definition" : "Clerical Worker"
    },
    {
      "code" : "4144.007",
      "display" : "Document Shredder",
      "definition" : "Document Shredder"
    },
    {
      "code" : "4144.008",
      "display" : "Duplicating Machinist",
      "definition" : "Duplicating Machinist"
    },
    {
      "code" : "4144.009",
      "display" : "General Clerk",
      "definition" : "General Clerk"
    },
    {
      "code" : "4144.010",
      "display" : "General Office Clerk",
      "definition" : "General Office Clerk"
    },
    {
      "code" : "4144.011",
      "display" : "Girl Friday",
      "definition" : "Girl Friday"
    },
    {
      "code" : "4144.012",
      "display" : "Government Department Clerk",
      "definition" : "Government Department Clerk"
    },
    {
      "code" : "4144.013",
      "display" : "Human Resources Clerk",
      "definition" : "Human Resources Clerk"
    },
    {
      "code" : "4144.014",
      "display" : "Junior Clerk",
      "definition" : "Junior Clerk"
    },
    {
      "code" : "4144.015",
      "display" : "Kaaraka",
      "definition" : "Kaaraka"
    },
    {
      "code" : "4144.016",
      "display" : "Kaaraka o te Tari",
      "definition" : "Kaaraka o te Tari"
    },
    {
      "code" : "4144.017",
      "display" : "Kaiawhina Mahi Tari",
      "definition" : "Kaiawhina Mahi Tari"
    },
    {
      "code" : "4144.018",
      "display" : "Kaimahi Tari",
      "definition" : "Kaimahi Tari"
    },
    {
      "code" : "4144.019",
      "display" : "Kaitautoko Tauira Maaori",
      "definition" : "Kaitautoko Tauira Maaori"
    },
    {
      "code" : "4144.020",
      "display" : "Kaitiaki Putea",
      "definition" : "Kaitiaki Putea"
    },
    {
      "code" : "4144.021",
      "display" : "Kaitiaki Puutea",
      "definition" : "Kaitiaki Puutea"
    },
    {
      "code" : "4144.022",
      "display" : "Kaitiaki Tari",
      "definition" : "Kaitiaki Tari"
    },
    {
      "code" : "4144.023",
      "display" : "Karaka",
      "definition" : "Karaka"
    },
    {
      "code" : "4144.024",
      "display" : "Karaka o te Tari",
      "definition" : "Karaka o te Tari"
    },
    {
      "code" : "4144.025",
      "display" : "Local Body Clerk",
      "definition" : "Local Body Clerk"
    },
    {
      "code" : "4144.026",
      "display" : "Local Body Officer",
      "definition" : "Local Body Officer"
    },
    {
      "code" : "4144.027",
      "display" : "Newspaper Clerk",
      "definition" : "Newspaper Clerk"
    },
    {
      "code" : "4144.028",
      "display" : "Office Assistant",
      "definition" : "Office Assistant"
    },
    {
      "code" : "4144.029",
      "display" : "Office Boy",
      "definition" : "Office Boy"
    },
    {
      "code" : "4144.030",
      "display" : "Office Clerk",
      "definition" : "Office Clerk"
    },
    {
      "code" : "4144.031",
      "display" : "Office Junior",
      "definition" : "Office Junior"
    },
    {
      "code" : "4144.032",
      "display" : "Office Junior Clerk",
      "definition" : "Office Junior Clerk"
    },
    {
      "code" : "4144.033",
      "display" : "Office Machine Operator",
      "definition" : "Office Machine Operator"
    },
    {
      "code" : "4144.034",
      "display" : "Office Machinist",
      "definition" : "Office Machinist"
    },
    {
      "code" : "4144.035",
      "display" : "Office Worker",
      "definition" : "Office Worker"
    },
    {
      "code" : "4144.036",
      "display" : "Pay Clerk",
      "definition" : "Pay Clerk"
    },
    {
      "code" : "4144.037",
      "display" : "Pay Officer",
      "definition" : "Pay Officer"
    },
    {
      "code" : "4144.038",
      "display" : "Paymaster",
      "definition" : "Paymaster"
    },
    {
      "code" : "4144.039",
      "display" : "Payroll Clerk",
      "definition" : "Payroll Clerk"
    },
    {
      "code" : "4144.040",
      "display" : "Payroll Officer",
      "definition" : "Payroll Officer"
    },
    {
      "code" : "4144.041",
      "display" : "Personal Records Clerk",
      "definition" : "Personal Records Clerk"
    },
    {
      "code" : "4144.042",
      "display" : "Photocopier Operator",
      "definition" : "Photocopier Operator"
    },
    {
      "code" : "4144.043",
      "display" : "Photocopying Machine Operator",
      "definition" : "Photocopying Machine Operator"
    },
    {
      "code" : "4144.044",
      "display" : "Photographic Machine Operator",
      "definition" : "Photographic Machine Operator"
    },
    {
      "code" : "4144.045",
      "display" : "Plan Printer",
      "definition" : "Plan Printer"
    },
    {
      "code" : "4144.046",
      "display" : "Quality Controller Of General Clerks",
      "definition" : "Quality Controller Of General Clerks"
    },
    {
      "code" : "4144.047",
      "display" : "Quality Controller Of Office Machine Operator",
      "definition" : "Quality Controller Of Office Machine Operator"
    },
    {
      "code" : "4144.048",
      "display" : "Railway Clerk",
      "definition" : "Railway Clerk"
    },
    {
      "code" : "4144.049",
      "display" : "Recreation Clerk Officer",
      "definition" : "Recreation Clerk Officer"
    },
    {
      "code" : "4144.050",
      "display" : "Research Assistant",
      "definition" : "Research Assistant"
    },
    {
      "code" : "4144.051",
      "display" : "Research Worker",
      "definition" : "Research Worker"
    },
    {
      "code" : "4144.052",
      "display" : "Researcher",
      "definition" : "Researcher"
    },
    {
      "code" : "4144.053",
      "display" : "Salaries Clerk",
      "definition" : "Salaries Clerk"
    },
    {
      "code" : "4144.054",
      "display" : "Salaries Officer",
      "definition" : "Salaries Officer"
    },
    {
      "code" : "4144.055",
      "display" : "Staff Clerk",
      "definition" : "Staff Clerk"
    },
    {
      "code" : "4144.056",
      "display" : "Telex Operator",
      "definition" : "Telex Operator"
    },
    {
      "code" : "4144.057",
      "display" : "Timekeeper Employees",
      "definition" : "Timekeeper Employees"
    },
    {
      "code" : "4144.058",
      "display" : "Veterinary Clerk",
      "definition" : "Veterinary Clerk"
    },
    {
      "code" : "4144.059",
      "display" : "Wages Clerk",
      "definition" : "Wages Clerk"
    },
    {
      "code" : "4144.060",
      "display" : "Xerox Operator",
      "definition" : "Xerox Operator"
    },
    {
      "code" : "4211.001",
      "display" : "Betting Operator",
      "definition" : "Betting Operator"
    },
    {
      "code" : "4211.002",
      "display" : "Booking Clerk",
      "definition" : "Booking Clerk"
    },
    {
      "code" : "4211.003",
      "display" : "Car Park Attendant",
      "definition" : "Car Park Attendant"
    },
    {
      "code" : "4211.004",
      "display" : "Caretaker Rubbish Tip",
      "definition" : "Caretaker Rubbish Tip"
    },
    {
      "code" : "4211.005",
      "display" : "Cash Clerk",
      "definition" : "Cash Clerk"
    },
    {
      "code" : "4211.006",
      "display" : "Cash Register Operator",
      "definition" : "Cash Register Operator"
    },
    {
      "code" : "4211.007",
      "display" : "Cashier",
      "definition" : "Cashier"
    },
    {
      "code" : "4211.008",
      "display" : "Cashier Clerk",
      "definition" : "Cashier Clerk"
    },
    {
      "code" : "4211.009",
      "display" : "Check Out Operator",
      "definition" : "Check Out Operator"
    },
    {
      "code" : "4211.010",
      "display" : "Checkout Operator",
      "definition" : "Checkout Operator"
    },
    {
      "code" : "4211.011",
      "display" : "Checkout Operators Supervisor",
      "definition" : "Checkout Operators Supervisor"
    },
    {
      "code" : "4211.012",
      "display" : "Collector Machines and Meters",
      "definition" : "Collector Machines and Meters"
    },
    {
      "code" : "4211.013",
      "display" : "Gatekeeper",
      "definition" : "Gatekeeper"
    },
    {
      "code" : "4211.014",
      "display" : "General Cashier",
      "definition" : "General Cashier"
    },
    {
      "code" : "4211.015",
      "display" : "Grocery Checkout Operator",
      "definition" : "Grocery Checkout Operator"
    },
    {
      "code" : "4211.016",
      "display" : "Kaiwhakarite Utu",
      "definition" : "Kaiwhakarite Utu"
    },
    {
      "code" : "4211.017",
      "display" : "Lottery Seller Agent",
      "definition" : "Lottery Seller Agent"
    },
    {
      "code" : "4211.018",
      "display" : "Lotto Seller Agent",
      "definition" : "Lotto Seller Agent"
    },
    {
      "code" : "4211.019",
      "display" : "Parking Lot Attendant",
      "definition" : "Parking Lot Attendant"
    },
    {
      "code" : "4211.020",
      "display" : "Parking Officer Car Park Building",
      "definition" : "Parking Officer Car Park Building"
    },
    {
      "code" : "4211.021",
      "display" : "Pool Attendant",
      "definition" : "Pool Attendant"
    },
    {
      "code" : "4211.022",
      "display" : "Pool Supervisor",
      "definition" : "Pool Supervisor"
    },
    {
      "code" : "4211.023",
      "display" : "Quality Controller Of Cashiers",
      "definition" : "Quality Controller Of Cashiers"
    },
    {
      "code" : "4211.024",
      "display" : "Quality Controller Of Ticket Seller Cashiers",
      "definition" : "Quality Controller Of Ticket Seller Cashiers"
    },
    {
      "code" : "4211.025",
      "display" : "Skating Rink Attendant",
      "definition" : "Skating Rink Attendant"
    },
    {
      "code" : "4211.026",
      "display" : "Swimming Pool Attendant",
      "definition" : "Swimming Pool Attendant"
    },
    {
      "code" : "4211.027",
      "display" : "TAB Cashier Clerk",
      "definition" : "TAB Cashier Clerk"
    },
    {
      "code" : "4211.028",
      "display" : "TAB Clerk",
      "definition" : "TAB Clerk"
    },
    {
      "code" : "4211.029",
      "display" : "TAB Operator",
      "definition" : "TAB Operator"
    },
    {
      "code" : "4211.030",
      "display" : "TAB Worker",
      "definition" : "TAB Worker"
    },
    {
      "code" : "4211.031",
      "display" : "Tele-Betting Operator",
      "definition" : "Tele-Betting Operator"
    },
    {
      "code" : "4211.032",
      "display" : "Ticket-Seller Cashier",
      "definition" : "Ticket-Seller Cashier"
    },
    {
      "code" : "4211.033",
      "display" : "Till Operator",
      "definition" : "Till Operator"
    },
    {
      "code" : "4211.034",
      "display" : "Toll Gate Keeper",
      "definition" : "Toll Gate Keeper"
    },
    {
      "code" : "4211.035",
      "display" : "Totalisator Agency Board Worker",
      "definition" : "Totalisator Agency Board Worker"
    },
    {
      "code" : "4211.036",
      "display" : "Tunnel Officer Tolls",
      "definition" : "Tunnel Officer Tolls"
    },
    {
      "code" : "4212.001",
      "display" : "Bank Clerk",
      "definition" : "Bank Clerk"
    },
    {
      "code" : "4212.002",
      "display" : "Bank Customer Services Clerk",
      "definition" : "Bank Customer Services Clerk"
    },
    {
      "code" : "4212.003",
      "display" : "Bank Customer Services Officer",
      "definition" : "Bank Customer Services Officer"
    },
    {
      "code" : "4212.004",
      "display" : "Bank Officer",
      "definition" : "Bank Officer"
    },
    {
      "code" : "4212.005",
      "display" : "Bank Teller",
      "definition" : "Bank Teller"
    },
    {
      "code" : "4212.006",
      "display" : "Credit Support Officer",
      "definition" : "Credit Support Officer"
    },
    {
      "code" : "4212.007",
      "display" : "Currency Exchange Officer",
      "definition" : "Currency Exchange Officer"
    },
    {
      "code" : "4212.008",
      "display" : "Foreign Exchange Officer",
      "definition" : "Foreign Exchange Officer"
    },
    {
      "code" : "4212.009",
      "display" : "Foreign Exchange Teller",
      "definition" : "Foreign Exchange Teller"
    },
    {
      "code" : "4212.010",
      "display" : "Kaimahi Peke",
      "definition" : "Kaimahi Peke"
    },
    {
      "code" : "4212.011",
      "display" : "Kaitaatai Moni",
      "definition" : "Kaitaatai Moni"
    },
    {
      "code" : "4212.012",
      "display" : "Kaitatai Moni",
      "definition" : "Kaitatai Moni"
    },
    {
      "code" : "4212.013",
      "display" : "Personal Banker",
      "definition" : "Personal Banker"
    },
    {
      "code" : "4212.014",
      "display" : "Personal Teller",
      "definition" : "Personal Teller"
    },
    {
      "code" : "4212.015",
      "display" : "Quality Controller Of Bank Officers",
      "definition" : "Quality Controller Of Bank Officers"
    },
    {
      "code" : "4213.001",
      "display" : "Casino Supervisor",
      "definition" : "Casino Supervisor"
    },
    {
      "code" : "4213.002",
      "display" : "Croupier",
      "definition" : "Croupier"
    },
    {
      "code" : "4213.003",
      "display" : "Gaming Dealer",
      "definition" : "Gaming Dealer"
    },
    {
      "code" : "4213.004",
      "display" : "Gaming Table Pit Boss",
      "definition" : "Gaming Table Pit Boss"
    },
    {
      "code" : "4213.005",
      "display" : "Gaming Table Supervisor",
      "definition" : "Gaming Table Supervisor"
    },
    {
      "code" : "4215.001",
      "display" : "Bailiff",
      "definition" : "Bailiff"
    },
    {
      "code" : "4215.002",
      "display" : "Bill and Debt Collector",
      "definition" : "Bill and Debt Collector"
    },
    {
      "code" : "4215.003",
      "display" : "Bill Collector",
      "definition" : "Bill Collector"
    },
    {
      "code" : "4215.004",
      "display" : "Debt Collector",
      "definition" : "Debt Collector"
    },
    {
      "code" : "4215.005",
      "display" : "Rate Rent Collector",
      "definition" : "Rate Rent Collector"
    },
    {
      "code" : "4215.006",
      "display" : "Repossesion Agent",
      "definition" : "Repossesion Agent"
    },
    {
      "code" : "4215.007",
      "display" : "Repossessor",
      "definition" : "Repossessor"
    },
    {
      "code" : "4221.001",
      "display" : "Aapiha Tuku Moohiotanga",
      "definition" : "Aapiha Tuku Moohiotanga"
    },
    {
      "code" : "4221.002",
      "display" : "Aapiha Tuku Whakaaturanga",
      "definition" : "Aapiha Tuku Whakaaturanga"
    },
    {
      "code" : "4221.003",
      "display" : "Apiha Tuku Mohiotanga",
      "definition" : "Apiha Tuku Mohiotanga"
    },
    {
      "code" : "4221.004",
      "display" : "Apiha Tuku Whakaaturanga",
      "definition" : "Apiha Tuku Whakaaturanga"
    },
    {
      "code" : "4221.005",
      "display" : "Dental Receptionist",
      "definition" : "Dental Receptionist"
    },
    {
      "code" : "4221.006",
      "display" : "Dentists Receptionist",
      "definition" : "Dentists Receptionist"
    },
    {
      "code" : "4221.007",
      "display" : "Doctors Receptionist",
      "definition" : "Doctors Receptionist"
    },
    {
      "code" : "4221.008",
      "display" : "Hospital Admissions Clerk",
      "definition" : "Hospital Admissions Clerk"
    },
    {
      "code" : "4221.009",
      "display" : "Hospital Hostess",
      "definition" : "Hospital Hostess"
    },
    {
      "code" : "4221.010",
      "display" : "Hospital Receptionist",
      "definition" : "Hospital Receptionist"
    },
    {
      "code" : "4221.011",
      "display" : "Hotel Clerk",
      "definition" : "Hotel Clerk"
    },
    {
      "code" : "4221.012",
      "display" : "Hotel or Motel Receptionist",
      "definition" : "Hotel or Motel Receptionist"
    },
    {
      "code" : "4221.013",
      "display" : "Hotel Receptionist",
      "definition" : "Hotel Receptionist"
    },
    {
      "code" : "4221.014",
      "display" : "Information Clerk and Other Receptionist",
      "definition" : "Information Clerk and Other Receptionist"
    },
    {
      "code" : "4221.015",
      "display" : "Information Officer",
      "definition" : "Information Officer"
    },
    {
      "code" : "4221.016",
      "display" : "Inland Revenue Customer Services Officer",
      "definition" : "Inland Revenue Customer Services Officer"
    },
    {
      "code" : "4221.017",
      "display" : "IRD Customer Services Officer",
      "definition" : "IRD Customer Services Officer"
    },
    {
      "code" : "4221.018",
      "display" : "Kaiwhakatau Manuhiri",
      "definition" : "Kaiwhakatau Manuhiri"
    },
    {
      "code" : "4221.019",
      "display" : "Medical Receptionist",
      "definition" : "Medical Receptionist"
    },
    {
      "code" : "4221.020",
      "display" : "Motel Receptionist",
      "definition" : "Motel Receptionist"
    },
    {
      "code" : "4221.021",
      "display" : "Motor Lodge Clerk",
      "definition" : "Motor Lodge Clerk"
    },
    {
      "code" : "4221.022",
      "display" : "Patient Information Officer",
      "definition" : "Patient Information Officer"
    },
    {
      "code" : "4221.023",
      "display" : "Patient Receptionist",
      "definition" : "Patient Receptionist"
    },
    {
      "code" : "4221.024",
      "display" : "Receptionist",
      "definition" : "Receptionist"
    },
    {
      "code" : "4221.025",
      "display" : "Tourist Information Officer",
      "definition" : "Tourist Information Officer"
    },
    {
      "code" : "4221.026",
      "display" : "Travel Reception Clerk",
      "definition" : "Travel Reception Clerk"
    },
    {
      "code" : "4222.001",
      "display" : "Answering Service Operator",
      "definition" : "Answering Service Operator"
    },
    {
      "code" : "4222.002",
      "display" : "Call Centre Manager",
      "definition" : "Call Centre Manager"
    },
    {
      "code" : "4222.003",
      "display" : "Call Centre Operator",
      "definition" : "Call Centre Operator"
    },
    {
      "code" : "4222.004",
      "display" : "PABX Operator",
      "definition" : "PABX Operator"
    },
    {
      "code" : "4222.005",
      "display" : "Public Exchange Operator Telephone",
      "definition" : "Public Exchange Operator Telephone"
    },
    {
      "code" : "4222.006",
      "display" : "Telephone Attendant",
      "definition" : "Telephone Attendant"
    },
    {
      "code" : "4222.007",
      "display" : "Telephone Operator",
      "definition" : "Telephone Operator"
    },
    {
      "code" : "4222.008",
      "display" : "Telephone Receptionist",
      "definition" : "Telephone Receptionist"
    },
    {
      "code" : "4222.009",
      "display" : "Telephone Services Officer",
      "definition" : "Telephone Services Officer"
    },
    {
      "code" : "4222.010",
      "display" : "Telephone Switchboard Operator",
      "definition" : "Telephone Switchboard Operator"
    },
    {
      "code" : "4222.011",
      "display" : "Telephone Switchboard Supervisor",
      "definition" : "Telephone Switchboard Supervisor"
    },
    {
      "code" : "4222.012",
      "display" : "Telephonist",
      "definition" : "Telephonist"
    },
    {
      "code" : "4222.013",
      "display" : "Telephonist Answering Service",
      "definition" : "Telephonist Answering Service"
    },
    {
      "code" : "4222.014",
      "display" : "Tolls Operator",
      "definition" : "Tolls Operator"
    },
    {
      "code" : "4222.015",
      "display" : "Tolls Supervisor",
      "definition" : "Tolls Supervisor"
    },
    {
      "code" : "5111.001",
      "display" : "Air Hostess",
      "definition" : "Air Hostess"
    },
    {
      "code" : "5111.002",
      "display" : "Airline Steward",
      "definition" : "Airline Steward"
    },
    {
      "code" : "5111.003",
      "display" : "Bus Hostess",
      "definition" : "Bus Hostess"
    },
    {
      "code" : "5111.004",
      "display" : "Cabin Crew",
      "definition" : "Cabin Crew"
    },
    {
      "code" : "5111.005",
      "display" : "Cabin Flight Steward",
      "definition" : "Cabin Flight Steward"
    },
    {
      "code" : "5111.006",
      "display" : "Cabin Flight Stewardess",
      "definition" : "Cabin Flight Stewardess"
    },
    {
      "code" : "5111.007",
      "display" : "Flight Attendant",
      "definition" : "Flight Attendant"
    },
    {
      "code" : "5111.008",
      "display" : "Flight Purser",
      "definition" : "Flight Purser"
    },
    {
      "code" : "5111.009",
      "display" : "Flight Steward",
      "definition" : "Flight Steward"
    },
    {
      "code" : "5111.010",
      "display" : "Ground Steward Airline",
      "definition" : "Ground Steward Airline"
    },
    {
      "code" : "5111.011",
      "display" : "Ground Stewardess Airline",
      "definition" : "Ground Stewardess Airline"
    },
    {
      "code" : "5111.012",
      "display" : "Launch Hostess",
      "definition" : "Launch Hostess"
    },
    {
      "code" : "5111.013",
      "display" : "Marine Steward",
      "definition" : "Marine Steward"
    },
    {
      "code" : "5111.014",
      "display" : "Rail Steward",
      "definition" : "Rail Steward"
    },
    {
      "code" : "5111.015",
      "display" : "Rail Stewardess",
      "definition" : "Rail Stewardess"
    },
    {
      "code" : "5111.016",
      "display" : "Ship Cabin Steward",
      "definition" : "Ship Cabin Steward"
    },
    {
      "code" : "5111.017",
      "display" : "Ships Chief Steward",
      "definition" : "Ships Chief Steward"
    },
    {
      "code" : "5111.018",
      "display" : "Ships Purser",
      "definition" : "Ships Purser"
    },
    {
      "code" : "5111.019",
      "display" : "Ships Steward",
      "definition" : "Ships Steward"
    },
    {
      "code" : "5111.020",
      "display" : "Ships Stewardess",
      "definition" : "Ships Stewardess"
    },
    {
      "code" : "5111.021",
      "display" : "Train Hostess",
      "definition" : "Train Hostess"
    },
    {
      "code" : "5111.022",
      "display" : "Travel Attendant",
      "definition" : "Travel Attendant"
    },
    {
      "code" : "5111.023",
      "display" : "Travel Attendant Airline",
      "definition" : "Travel Attendant Airline"
    },
    {
      "code" : "5111.024",
      "display" : "Travel Attendant Train",
      "definition" : "Travel Attendant Train"
    },
    {
      "code" : "5112.001",
      "display" : "Adventure Safari Guide",
      "definition" : "Adventure Safari Guide"
    },
    {
      "code" : "5112.002",
      "display" : "Adventure Tourism Operator",
      "definition" : "Adventure Tourism Operator"
    },
    {
      "code" : "5112.003",
      "display" : "Alpine Fishing Hunting Guide",
      "definition" : "Alpine Fishing Hunting Guide"
    },
    {
      "code" : "5112.004",
      "display" : "Animal Drawn Vehicle Operator",
      "definition" : "Animal Drawn Vehicle Operator"
    },
    {
      "code" : "5112.005",
      "display" : "Art Gallery Attendant",
      "definition" : "Art Gallery Attendant"
    },
    {
      "code" : "5112.006",
      "display" : "Art Gallery Guide",
      "definition" : "Art Gallery Guide"
    },
    {
      "code" : "5112.007",
      "display" : "Dive Master",
      "definition" : "Dive Master"
    },
    {
      "code" : "5112.008",
      "display" : "Horse Trekking Guide",
      "definition" : "Horse Trekking Guide"
    },
    {
      "code" : "5112.009",
      "display" : "Mountain Guide",
      "definition" : "Mountain Guide"
    },
    {
      "code" : "5112.010",
      "display" : "Museum Attendant",
      "definition" : "Museum Attendant"
    },
    {
      "code" : "5112.011",
      "display" : "Museum Guide",
      "definition" : "Museum Guide"
    },
    {
      "code" : "5112.012",
      "display" : "Outdoor Recreation Guide",
      "definition" : "Outdoor Recreation Guide"
    },
    {
      "code" : "5112.013",
      "display" : "Recreation Guide",
      "definition" : "Recreation Guide"
    },
    {
      "code" : "5112.014",
      "display" : "River Rafting Guide",
      "definition" : "River Rafting Guide"
    },
    {
      "code" : "5112.015",
      "display" : "Scenic Tour Guide",
      "definition" : "Scenic Tour Guide"
    },
    {
      "code" : "5112.016",
      "display" : "Sightseeing Guide",
      "definition" : "Sightseeing Guide"
    },
    {
      "code" : "5112.017",
      "display" : "Tour and Travel Guide",
      "definition" : "Tour and Travel Guide"
    },
    {
      "code" : "5112.018",
      "display" : "Tour Controller",
      "definition" : "Tour Controller"
    },
    {
      "code" : "5112.019",
      "display" : "Tour Guide",
      "definition" : "Tour Guide"
    },
    {
      "code" : "5112.020",
      "display" : "Travel Guide",
      "definition" : "Travel Guide"
    },
    {
      "code" : "5121.001",
      "display" : "Boarding School Hostel Matron",
      "definition" : "Boarding School Hostel Matron"
    },
    {
      "code" : "5121.002",
      "display" : "Butler",
      "definition" : "Butler"
    },
    {
      "code" : "5121.003",
      "display" : "Camp Hostel Matron",
      "definition" : "Camp Hostel Matron"
    },
    {
      "code" : "5121.004",
      "display" : "Chambermaid",
      "definition" : "Chambermaid"
    },
    {
      "code" : "5121.005",
      "display" : "Domestic House Staff",
      "definition" : "Domestic House Staff"
    },
    {
      "code" : "5121.006",
      "display" : "Domestic Servant",
      "definition" : "Domestic Servant"
    },
    {
      "code" : "5121.007",
      "display" : "Dormitory Supervisor",
      "definition" : "Dormitory Supervisor"
    },
    {
      "code" : "5121.008",
      "display" : "Executive Housekeeper",
      "definition" : "Executive Housekeeper"
    },
    {
      "code" : "5121.009",
      "display" : "Hospital Housekeeper",
      "definition" : "Hospital Housekeeper"
    },
    {
      "code" : "5121.010",
      "display" : "Hostel Supervisor",
      "definition" : "Hostel Supervisor"
    },
    {
      "code" : "5121.011",
      "display" : "Hotel Chief Steward",
      "definition" : "Hotel Chief Steward"
    },
    {
      "code" : "5121.012",
      "display" : "Hotel Housekeeper",
      "definition" : "Hotel Housekeeper"
    },
    {
      "code" : "5121.013",
      "display" : "House Staff Accommodation Services",
      "definition" : "House Staff Accommodation Services"
    },
    {
      "code" : "5121.014",
      "display" : "House Steward Non Private",
      "definition" : "House Steward Non Private"
    },
    {
      "code" : "5121.015",
      "display" : "House Steward Private",
      "definition" : "House Steward Private"
    },
    {
      "code" : "5121.016",
      "display" : "House Stewardess Non Private",
      "definition" : "House Stewardess Non Private"
    },
    {
      "code" : "5121.017",
      "display" : "House Stewardess Private",
      "definition" : "House Stewardess Private"
    },
    {
      "code" : "5121.018",
      "display" : "Household Help",
      "definition" : "Household Help"
    },
    {
      "code" : "5121.019",
      "display" : "Housekeeper (Not Private)",
      "definition" : "Housekeeper (Not Private)"
    },
    {
      "code" : "5121.020",
      "display" : "Housekeeper (Private Service)",
      "definition" : "Housekeeper (Private Service)"
    },
    {
      "code" : "5121.021",
      "display" : "Housekeeper Supervisor Hotels Or Similar Institution",
      "definition" : "Housekeeper Supervisor Hotels Or Similar Institution"
    },
    {
      "code" : "5121.022",
      "display" : "Housekeeper Supervisor not Private",
      "definition" : "Housekeeper Supervisor not Private"
    },
    {
      "code" : "5121.023",
      "display" : "Housekeeper Supervisor Private",
      "definition" : "Housekeeper Supervisor Private"
    },
    {
      "code" : "5121.024",
      "display" : "Housekeeper Supervisor Residential Institution",
      "definition" : "Housekeeper Supervisor Residential Institution"
    },
    {
      "code" : "5121.025",
      "display" : "Housekeeping Matron Residential Institution",
      "definition" : "Housekeeping Matron Residential Institution"
    },
    {
      "code" : "5121.026",
      "display" : "Housemaid",
      "definition" : "Housemaid"
    },
    {
      "code" : "5121.027",
      "display" : "Linen Keeper Hospital",
      "definition" : "Linen Keeper Hospital"
    },
    {
      "code" : "5121.028",
      "display" : "Maid Private Service",
      "definition" : "Maid Private Service"
    },
    {
      "code" : "5121.029",
      "display" : "Nursing Home Housekeeper",
      "definition" : "Nursing Home Housekeeper"
    },
    {
      "code" : "5121.030",
      "display" : "Personal Maid Valet",
      "definition" : "Personal Maid Valet"
    },
    {
      "code" : "5121.031",
      "display" : "Prison Matron",
      "definition" : "Prison Matron"
    },
    {
      "code" : "5121.032",
      "display" : "Valet",
      "definition" : "Valet"
    },
    {
      "code" : "5122.001",
      "display" : "Cafeteria Cook",
      "definition" : "Cafeteria Cook"
    },
    {
      "code" : "5122.002",
      "display" : "Chef",
      "definition" : "Chef"
    },
    {
      "code" : "5122.003",
      "display" : "Cook",
      "definition" : "Cook"
    },
    {
      "code" : "5122.004",
      "display" : "Cook Camp Construction Farm Shearing",
      "definition" : "Cook Camp Construction Farm Shearing"
    },
    {
      "code" : "5122.005",
      "display" : "Cook Hotel",
      "definition" : "Cook Hotel"
    },
    {
      "code" : "5122.006",
      "display" : "Cook Restaurant",
      "definition" : "Cook Restaurant"
    },
    {
      "code" : "5122.007",
      "display" : "Cook Tavern",
      "definition" : "Cook Tavern"
    },
    {
      "code" : "5122.008",
      "display" : "Fast Food Cook",
      "definition" : "Fast Food Cook"
    },
    {
      "code" : "5122.009",
      "display" : "Food Supervisor Hospital Cook",
      "definition" : "Food Supervisor Hospital Cook"
    },
    {
      "code" : "5122.010",
      "display" : "Head Chef",
      "definition" : "Head Chef"
    },
    {
      "code" : "5122.011",
      "display" : "Kuki",
      "definition" : "Kuki"
    },
    {
      "code" : "5122.012",
      "display" : "Rangatira Mahi Kai",
      "definition" : "Rangatira Mahi Kai"
    },
    {
      "code" : "5122.013",
      "display" : "Ships Cook",
      "definition" : "Ships Cook"
    },
    {
      "code" : "5122.014",
      "display" : "Short Order Cook",
      "definition" : "Short Order Cook"
    },
    {
      "code" : "5122.015",
      "display" : "Sous Chef",
      "definition" : "Sous Chef"
    },
    {
      "code" : "5122.016",
      "display" : "Takeaway Cook",
      "definition" : "Takeaway Cook"
    },
    {
      "code" : "5122.017",
      "display" : "Trainee Cook",
      "definition" : "Trainee Cook"
    },
    {
      "code" : "5123.001",
      "display" : "Bar Attendant",
      "definition" : "Bar Attendant"
    },
    {
      "code" : "5123.002",
      "display" : "Bar Hostess",
      "definition" : "Bar Hostess"
    },
    {
      "code" : "5123.003",
      "display" : "Bar Maid",
      "definition" : "Bar Maid"
    },
    {
      "code" : "5123.004",
      "display" : "Bar Person",
      "definition" : "Bar Person"
    },
    {
      "code" : "5123.005",
      "display" : "Bar Steward",
      "definition" : "Bar Steward"
    },
    {
      "code" : "5123.006",
      "display" : "Bar Tender",
      "definition" : "Bar Tender"
    },
    {
      "code" : "5123.007",
      "display" : "Barmaid",
      "definition" : "Barmaid"
    },
    {
      "code" : "5123.008",
      "display" : "Barman",
      "definition" : "Barman"
    },
    {
      "code" : "5123.009",
      "display" : "Barperson",
      "definition" : "Barperson"
    },
    {
      "code" : "5123.010",
      "display" : "Bartender",
      "definition" : "Bartender"
    },
    {
      "code" : "5123.011",
      "display" : "Cafe Assistant",
      "definition" : "Cafe Assistant"
    },
    {
      "code" : "5123.012",
      "display" : "Caf� Waiter",
      "definition" : "Caf� Waiter"
    },
    {
      "code" : "5123.013",
      "display" : "Caf� Waitress",
      "definition" : "Caf� Waitress"
    },
    {
      "code" : "5123.014",
      "display" : "Cafe Worker",
      "definition" : "Cafe Worker"
    },
    {
      "code" : "5123.015",
      "display" : "Cafeteria Assistant",
      "definition" : "Cafeteria Assistant"
    },
    {
      "code" : "5123.016",
      "display" : "Cafeteria Worker",
      "definition" : "Cafeteria Worker"
    },
    {
      "code" : "5123.017",
      "display" : "Canteen Assistant",
      "definition" : "Canteen Assistant"
    },
    {
      "code" : "5123.018",
      "display" : "Canteen Worker",
      "definition" : "Canteen Worker"
    },
    {
      "code" : "5123.019",
      "display" : "Catering Assistant",
      "definition" : "Catering Assistant"
    },
    {
      "code" : "5123.020",
      "display" : "Catering Counter Assistant",
      "definition" : "Catering Counter Assistant"
    },
    {
      "code" : "5123.021",
      "display" : "Catering Counter Supervisor",
      "definition" : "Catering Counter Supervisor"
    },
    {
      "code" : "5123.022",
      "display" : "Cellar Person",
      "definition" : "Cellar Person"
    },
    {
      "code" : "5123.023",
      "display" : "Cellarman",
      "definition" : "Cellarman"
    },
    {
      "code" : "5123.024",
      "display" : "Cinema Attendant",
      "definition" : "Cinema Attendant"
    },
    {
      "code" : "5123.025",
      "display" : "Cinema Usher",
      "definition" : "Cinema Usher"
    },
    {
      "code" : "5123.026",
      "display" : "Cloakroom Attendant",
      "definition" : "Cloakroom Attendant"
    },
    {
      "code" : "5123.027",
      "display" : "Club Steward",
      "definition" : "Club Steward"
    },
    {
      "code" : "5123.028",
      "display" : "Club Stewardess",
      "definition" : "Club Stewardess"
    },
    {
      "code" : "5123.029",
      "display" : "Coffee Bar Assistant",
      "definition" : "Coffee Bar Assistant"
    },
    {
      "code" : "5123.030",
      "display" : "Coffee Lounge Assistant",
      "definition" : "Coffee Lounge Assistant"
    },
    {
      "code" : "5123.031",
      "display" : "Coffee Shop Assistant",
      "definition" : "Coffee Shop Assistant"
    },
    {
      "code" : "5123.032",
      "display" : "Counterhand",
      "definition" : "Counterhand"
    },
    {
      "code" : "5123.033",
      "display" : "Court Bailiff",
      "definition" : "Court Bailiff"
    },
    {
      "code" : "5123.034",
      "display" : "Crew Member McDonalds",
      "definition" : "Crew Member McDonalds"
    },
    {
      "code" : "5123.035",
      "display" : "Crier Custodian Law Courts",
      "definition" : "Crier Custodian Law Courts"
    },
    {
      "code" : "5123.036",
      "display" : "Dining Room Supervisor",
      "definition" : "Dining Room Supervisor"
    },
    {
      "code" : "5123.037",
      "display" : "Dishwasher Restaurant",
      "definition" : "Dishwasher Restaurant"
    },
    {
      "code" : "5123.038",
      "display" : "Doorkeeper",
      "definition" : "Doorkeeper"
    },
    {
      "code" : "5123.039",
      "display" : "Doorman",
      "definition" : "Doorman"
    },
    {
      "code" : "5123.040",
      "display" : "Fast Food Assistant",
      "definition" : "Fast Food Assistant"
    },
    {
      "code" : "5123.041",
      "display" : "Fast Food Server",
      "definition" : "Fast Food Server"
    },
    {
      "code" : "5123.042",
      "display" : "Fish and Chip Shop Worker",
      "definition" : "Fish and Chip Shop Worker"
    },
    {
      "code" : "5123.043",
      "display" : "Food Counter Assistant",
      "definition" : "Food Counter Assistant"
    },
    {
      "code" : "5123.044",
      "display" : "Head Bartender",
      "definition" : "Head Bartender"
    },
    {
      "code" : "5123.045",
      "display" : "Head Waiter",
      "definition" : "Head Waiter"
    },
    {
      "code" : "5123.046",
      "display" : "Head Waitress",
      "definition" : "Head Waitress"
    },
    {
      "code" : "5123.047",
      "display" : "Kaiawhina Mahi Kai Tere te Maoa",
      "definition" : "Kaiawhina Mahi Kai Tere te Maoa"
    },
    {
      "code" : "5123.048",
      "display" : "Kaiawhina Mahi Toha Kai",
      "definition" : "Kaiawhina Mahi Toha Kai"
    },
    {
      "code" : "5123.049",
      "display" : "Kaihokohoko Inu",
      "definition" : "Kaihokohoko Inu"
    },
    {
      "code" : "5123.050",
      "display" : "Kaihokohoko Waipiro",
      "definition" : "Kaihokohoko Waipiro"
    },
    {
      "code" : "5123.051",
      "display" : "Kaimahi Kawhe",
      "definition" : "Kaimahi Kawhe"
    },
    {
      "code" : "5123.052",
      "display" : "Kaimahi Paparaakauta",
      "definition" : "Kaimahi Paparaakauta"
    },
    {
      "code" : "5123.053",
      "display" : "Kaimahi Paparakauta",
      "definition" : "Kaimahi Paparakauta"
    },
    {
      "code" : "5123.054",
      "display" : "Kaimahi Waahi Kai",
      "definition" : "Kaimahi Waahi Kai"
    },
    {
      "code" : "5123.055",
      "display" : "Kaimahi Wahi Kai",
      "definition" : "Kaimahi Wahi Kai"
    },
    {
      "code" : "5123.056",
      "display" : "Kaimahi Whareumu",
      "definition" : "Kaimahi Whareumu"
    },
    {
      "code" : "5123.057",
      "display" : "Kaitohatoha Kai Inu",
      "definition" : "Kaitohatoha Kai Inu"
    },
    {
      "code" : "5123.058",
      "display" : "Kaitohu Whakataka Kai",
      "definition" : "Kaitohu Whakataka Kai"
    },
    {
      "code" : "5123.059",
      "display" : "Kitchen Assistant",
      "definition" : "Kitchen Assistant"
    },
    {
      "code" : "5123.060",
      "display" : "Kitchen Dishwasher",
      "definition" : "Kitchen Dishwasher"
    },
    {
      "code" : "5123.061",
      "display" : "Kitchen Hand",
      "definition" : "Kitchen Hand"
    },
    {
      "code" : "5123.062",
      "display" : "Kitchenhand",
      "definition" : "Kitchenhand"
    },
    {
      "code" : "5123.063",
      "display" : "Lavatory Attendant",
      "definition" : "Lavatory Attendant"
    },
    {
      "code" : "5123.064",
      "display" : "Lounge Assistant",
      "definition" : "Lounge Assistant"
    },
    {
      "code" : "5123.065",
      "display" : "Lunch Bar Assistant",
      "definition" : "Lunch Bar Assistant"
    },
    {
      "code" : "5123.066",
      "display" : "Lunch Bar Worker",
      "definition" : "Lunch Bar Worker"
    },
    {
      "code" : "5123.067",
      "display" : "Lunchbar Assistant",
      "definition" : "Lunchbar Assistant"
    },
    {
      "code" : "5123.068",
      "display" : "Maitre d",
      "definition" : "Maitre d"
    },
    {
      "code" : "5123.069",
      "display" : "Maitre dHotel",
      "definition" : "Maitre dHotel"
    },
    {
      "code" : "5123.070",
      "display" : "Maitre dRestaurant",
      "definition" : "Maitre dRestaurant"
    },
    {
      "code" : "5123.071",
      "display" : "Maitred",
      "definition" : "Maitred"
    },
    {
      "code" : "5123.072",
      "display" : "Night Club Hostess",
      "definition" : "Night Club Hostess"
    },
    {
      "code" : "5123.073",
      "display" : "Parcels Attendant",
      "definition" : "Parcels Attendant"
    },
    {
      "code" : "5123.074",
      "display" : "Potato Chipper",
      "definition" : "Potato Chipper"
    },
    {
      "code" : "5123.075",
      "display" : "Restaurant Hostess",
      "definition" : "Restaurant Hostess"
    },
    {
      "code" : "5123.076",
      "display" : "Restaurant Worker",
      "definition" : "Restaurant Worker"
    },
    {
      "code" : "5123.077",
      "display" : "Restroom Attendant",
      "definition" : "Restroom Attendant"
    },
    {
      "code" : "5123.078",
      "display" : "Salad Worker",
      "definition" : "Salad Worker"
    },
    {
      "code" : "5123.079",
      "display" : "Sandwich Hand",
      "definition" : "Sandwich Hand"
    },
    {
      "code" : "5123.080",
      "display" : "Snack Bar Attendant",
      "definition" : "Snack Bar Attendant"
    },
    {
      "code" : "5123.081",
      "display" : "Sommelier",
      "definition" : "Sommelier"
    },
    {
      "code" : "5123.082",
      "display" : "Supervisor Cafeteria Coffee Bar",
      "definition" : "Supervisor Cafeteria Coffee Bar"
    },
    {
      "code" : "5123.083",
      "display" : "Take Away Food Assistant",
      "definition" : "Take Away Food Assistant"
    },
    {
      "code" : "5123.084",
      "display" : "Take Away Lunch Bar Assistant",
      "definition" : "Take Away Lunch Bar Assistant"
    },
    {
      "code" : "5123.085",
      "display" : "Take Away Lunchbar Assistant",
      "definition" : "Take Away Lunchbar Assistant"
    },
    {
      "code" : "5123.086",
      "display" : "Takeaway Lunch Bar Assistant",
      "definition" : "Takeaway Lunch Bar Assistant"
    },
    {
      "code" : "5123.087",
      "display" : "Takeaway Lunchbar Assistant",
      "definition" : "Takeaway Lunchbar Assistant"
    },
    {
      "code" : "5123.088",
      "display" : "Takeaways Assistant",
      "definition" : "Takeaways Assistant"
    },
    {
      "code" : "5123.089",
      "display" : "Tangata Hokohoko Inu",
      "definition" : "Tangata Hokohoko Inu"
    },
    {
      "code" : "5123.090",
      "display" : "Tangata Hokohoko Waipiro",
      "definition" : "Tangata Hokohoko Waipiro"
    },
    {
      "code" : "5123.091",
      "display" : "Tangata Tohatoha Kai Inu",
      "definition" : "Tangata Tohatoha Kai Inu"
    },
    {
      "code" : "5123.092",
      "display" : "Tea Attendant",
      "definition" : "Tea Attendant"
    },
    {
      "code" : "5123.093",
      "display" : "Tea Lady",
      "definition" : "Tea Lady"
    },
    {
      "code" : "5123.094",
      "display" : "Tea Person",
      "definition" : "Tea Person"
    },
    {
      "code" : "5123.095",
      "display" : "Teaperson",
      "definition" : "Teaperson"
    },
    {
      "code" : "5123.096",
      "display" : "Theatre Cloakroom Attendant",
      "definition" : "Theatre Cloakroom Attendant"
    },
    {
      "code" : "5123.097",
      "display" : "Theatre Usher",
      "definition" : "Theatre Usher"
    },
    {
      "code" : "5123.098",
      "display" : "Ticket Taker",
      "definition" : "Ticket Taker"
    },
    {
      "code" : "5123.099",
      "display" : "Toilet Attendant",
      "definition" : "Toilet Attendant"
    },
    {
      "code" : "5123.100",
      "display" : "Usher and Cloakroom Attendant",
      "definition" : "Usher and Cloakroom Attendant"
    },
    {
      "code" : "5123.101",
      "display" : "Usher Orderly Law Courts",
      "definition" : "Usher Orderly Law Courts"
    },
    {
      "code" : "5123.102",
      "display" : "Wait Person",
      "definition" : "Wait Person"
    },
    {
      "code" : "5123.103",
      "display" : "Waiter",
      "definition" : "Waiter"
    },
    {
      "code" : "5123.104",
      "display" : "Waitress",
      "definition" : "Waitress"
    },
    {
      "code" : "5123.105",
      "display" : "Wine Steward",
      "definition" : "Wine Steward"
    },
    {
      "code" : "5123.106",
      "display" : "Wine Stewardess",
      "definition" : "Wine Stewardess"
    },
    {
      "code" : "5131.001",
      "display" : "Ambulance Officer",
      "definition" : "Ambulance Officer"
    },
    {
      "code" : "5131.002",
      "display" : "Ambulance Paramedic",
      "definition" : "Ambulance Paramedic"
    },
    {
      "code" : "5131.003",
      "display" : "Caregiver",
      "definition" : "Caregiver"
    },
    {
      "code" : "5131.004",
      "display" : "Chairside Assistant",
      "definition" : "Chairside Assistant"
    },
    {
      "code" : "5131.005",
      "display" : "Child Care Giver",
      "definition" : "Child Care Giver"
    },
    {
      "code" : "5131.006",
      "display" : "Childcare Giver",
      "definition" : "Childcare Giver"
    },
    {
      "code" : "5131.007",
      "display" : "Dental Assistant Chairside",
      "definition" : "Dental Assistant Chairside"
    },
    {
      "code" : "5131.008",
      "display" : "Dental Surgery Assistant",
      "definition" : "Dental Surgery Assistant"
    },
    {
      "code" : "5131.009",
      "display" : "Dentists Nurse",
      "definition" : "Dentists Nurse"
    },
    {
      "code" : "5131.010",
      "display" : "Elderly Care Giver",
      "definition" : "Elderly Care Giver"
    },
    {
      "code" : "5131.011",
      "display" : "Elderly Home Carer",
      "definition" : "Elderly Home Carer"
    },
    {
      "code" : "5131.012",
      "display" : "First Aid Instructor",
      "definition" : "First Aid Instructor"
    },
    {
      "code" : "5131.013",
      "display" : "Geriatric Care Giver",
      "definition" : "Geriatric Care Giver"
    },
    {
      "code" : "5131.014",
      "display" : "Geriatric Home Carer",
      "definition" : "Geriatric Home Carer"
    },
    {
      "code" : "5131.015",
      "display" : "Health Assistant",
      "definition" : "Health Assistant"
    },
    {
      "code" : "5131.016",
      "display" : "Home Aide Assistant",
      "definition" : "Home Aide Assistant"
    },
    {
      "code" : "5131.017",
      "display" : "Home Aide Nursing",
      "definition" : "Home Aide Nursing"
    },
    {
      "code" : "5131.018",
      "display" : "Home Aide or Health Assistant",
      "definition" : "Home Aide or Health Assistant"
    },
    {
      "code" : "5131.019",
      "display" : "Home Aide Registered",
      "definition" : "Home Aide Registered"
    },
    {
      "code" : "5131.020",
      "display" : "Home Help",
      "definition" : "Home Help"
    },
    {
      "code" : "5131.021",
      "display" : "Hospital Aid",
      "definition" : "Hospital Aid"
    },
    {
      "code" : "5131.022",
      "display" : "Hospital Aide",
      "definition" : "Hospital Aide"
    },
    {
      "code" : "5131.023",
      "display" : "Hospital Clothing Assistant",
      "definition" : "Hospital Clothing Assistant"
    },
    {
      "code" : "5131.024",
      "display" : "Hospital Domestic",
      "definition" : "Hospital Domestic"
    },
    {
      "code" : "5131.025",
      "display" : "Hospital Orderly",
      "definition" : "Hospital Orderly"
    },
    {
      "code" : "5131.026",
      "display" : "Hospital Porter",
      "definition" : "Hospital Porter"
    },
    {
      "code" : "5131.027",
      "display" : "Hospital Ward Assistant",
      "definition" : "Hospital Ward Assistant"
    },
    {
      "code" : "5131.028",
      "display" : "Kaiawhina Mahi Naahi",
      "definition" : "Kaiawhina Mahi Naahi"
    },
    {
      "code" : "5131.029",
      "display" : "Kaiawhina Mahi Nahi",
      "definition" : "Kaiawhina Mahi Nahi"
    },
    {
      "code" : "5131.030",
      "display" : "Kaiawhina Mahi Neehi",
      "definition" : "Kaiawhina Mahi Neehi"
    },
    {
      "code" : "5131.031",
      "display" : "Kaiawhina Mahi Nehi",
      "definition" : "Kaiawhina Mahi Nehi"
    },
    {
      "code" : "5131.032",
      "display" : "Kaiawhina Mahi Tapuhi",
      "definition" : "Kaiawhina Mahi Tapuhi"
    },
    {
      "code" : "5131.033",
      "display" : "Kaiawhina Neehi",
      "definition" : "Kaiawhina Neehi"
    },
    {
      "code" : "5131.034",
      "display" : "Kaiawhina Nehi",
      "definition" : "Kaiawhina Nehi"
    },
    {
      "code" : "5131.035",
      "display" : "Kaiawhina Tapuhi",
      "definition" : "Kaiawhina Tapuhi"
    },
    {
      "code" : "5131.036",
      "display" : "Kaiawhina Turoro",
      "definition" : "Kaiawhina Turoro"
    },
    {
      "code" : "5131.037",
      "display" : "Kaiawhina Tuuroro",
      "definition" : "Kaiawhina Tuuroro"
    },
    {
      "code" : "5131.038",
      "display" : "Naahi Awhina",
      "definition" : "Naahi Awhina"
    },
    {
      "code" : "5131.039",
      "display" : "Nahi Awhina",
      "definition" : "Nahi Awhina"
    },
    {
      "code" : "5131.040",
      "display" : "Neehi Awhina",
      "definition" : "Neehi Awhina"
    },
    {
      "code" : "5131.041",
      "display" : "Nehi Awhina",
      "definition" : "Nehi Awhina"
    },
    {
      "code" : "5131.042",
      "display" : "Nurse Aide",
      "definition" : "Nurse Aide"
    },
    {
      "code" : "5131.043",
      "display" : "Nurse Assistant",
      "definition" : "Nurse Assistant"
    },
    {
      "code" : "5131.044",
      "display" : "Paramedic",
      "definition" : "Paramedic"
    },
    {
      "code" : "5131.045",
      "display" : "Physiotherapists Aide",
      "definition" : "Physiotherapists Aide"
    },
    {
      "code" : "5131.046",
      "display" : "Psychiatric Aide",
      "definition" : "Psychiatric Aide"
    },
    {
      "code" : "5131.047",
      "display" : "Psychopaedic Assistant",
      "definition" : "Psychopaedic Assistant"
    },
    {
      "code" : "5131.048",
      "display" : "Psychopeadic Assistant",
      "definition" : "Psychopeadic Assistant"
    },
    {
      "code" : "5131.049",
      "display" : "Quality Controller Of Hospital Orderlies",
      "definition" : "Quality Controller Of Hospital Orderlies"
    },
    {
      "code" : "5131.050",
      "display" : "Residential Care Giver",
      "definition" : "Residential Care Giver"
    },
    {
      "code" : "5131.051",
      "display" : "Rest Home Worker",
      "definition" : "Rest Home Worker"
    },
    {
      "code" : "5131.052",
      "display" : "Supervisor St Johns Ambulance",
      "definition" : "Supervisor St Johns Ambulance"
    },
    {
      "code" : "5131.053",
      "display" : "Tapuhi Awhina",
      "definition" : "Tapuhi Awhina"
    },
    {
      "code" : "5131.054",
      "display" : "Unregistered Geriatric Nurse",
      "definition" : "Unregistered Geriatric Nurse"
    },
    {
      "code" : "5131.055",
      "display" : "Unregistered Nurse Aide",
      "definition" : "Unregistered Nurse Aide"
    },
    {
      "code" : "5141.001",
      "display" : "Aesthetician",
      "definition" : "Aesthetician"
    },
    {
      "code" : "5141.002",
      "display" : "Barber",
      "definition" : "Barber"
    },
    {
      "code" : "5141.003",
      "display" : "Beautician",
      "definition" : "Beautician"
    },
    {
      "code" : "5141.004",
      "display" : "Beauty Consultant",
      "definition" : "Beauty Consultant"
    },
    {
      "code" : "5141.005",
      "display" : "Beauty Therapist",
      "definition" : "Beauty Therapist"
    },
    {
      "code" : "5141.006",
      "display" : "Colour Therapist",
      "definition" : "Colour Therapist"
    },
    {
      "code" : "5141.007",
      "display" : "Cosmetic Consultant",
      "definition" : "Cosmetic Consultant"
    },
    {
      "code" : "5141.008",
      "display" : "Cosmetician",
      "definition" : "Cosmetician"
    },
    {
      "code" : "5141.009",
      "display" : "Cosmeticist",
      "definition" : "Cosmeticist"
    },
    {
      "code" : "5141.010",
      "display" : "Electrolysis Assistant",
      "definition" : "Electrolysis Assistant"
    },
    {
      "code" : "5141.011",
      "display" : "Electrolysist",
      "definition" : "Electrolysist"
    },
    {
      "code" : "5141.012",
      "display" : "Epilationist",
      "definition" : "Epilationist"
    },
    {
      "code" : "5141.013",
      "display" : "Hair Dresser Ladies",
      "definition" : "Hair Dresser Ladies"
    },
    {
      "code" : "5141.014",
      "display" : "Hair Dresser Mens",
      "definition" : "Hair Dresser Mens"
    },
    {
      "code" : "5141.015",
      "display" : "Hair Stylist",
      "definition" : "Hair Stylist"
    },
    {
      "code" : "5141.016",
      "display" : "Hair Stylist Ladies",
      "definition" : "Hair Stylist Ladies"
    },
    {
      "code" : "5141.017",
      "display" : "Hair Stylist Mens",
      "definition" : "Hair Stylist Mens"
    },
    {
      "code" : "5141.018",
      "display" : "Hairdresser",
      "definition" : "Hairdresser"
    },
    {
      "code" : "5141.019",
      "display" : "Hairdressers Assistant",
      "definition" : "Hairdressers Assistant"
    },
    {
      "code" : "5141.020",
      "display" : "Hairstylist Ladies",
      "definition" : "Hairstylist Ladies"
    },
    {
      "code" : "5141.021",
      "display" : "Hairstylist Mens",
      "definition" : "Hairstylist Mens"
    },
    {
      "code" : "5141.022",
      "display" : "Holistic Massage Therapy Masseur",
      "definition" : "Holistic Massage Therapy Masseur"
    },
    {
      "code" : "5141.023",
      "display" : "Holistic Massage Therapy Masseuse",
      "definition" : "Holistic Massage Therapy Masseuse"
    },
    {
      "code" : "5141.024",
      "display" : "Kaihakari Makawe",
      "definition" : "Kaihakari Makawe"
    },
    {
      "code" : "5141.025",
      "display" : "Kairaakai Makawe",
      "definition" : "Kairaakai Makawe"
    },
    {
      "code" : "5141.026",
      "display" : "Kairakai Makawe",
      "definition" : "Kairakai Makawe"
    },
    {
      "code" : "5141.027",
      "display" : "Kaitapahi Makawe",
      "definition" : "Kaitapahi Makawe"
    },
    {
      "code" : "5141.028",
      "display" : "Kaiwhakapaipai Makawe",
      "definition" : "Kaiwhakapaipai Makawe"
    },
    {
      "code" : "5141.029",
      "display" : "Ladies Hairdresser",
      "definition" : "Ladies Hairdresser"
    },
    {
      "code" : "5141.030",
      "display" : "Make Up Artist Stage Studio",
      "definition" : "Make Up Artist Stage Studio"
    },
    {
      "code" : "5141.031",
      "display" : "Make Up Consultant",
      "definition" : "Make Up Consultant"
    },
    {
      "code" : "5141.032",
      "display" : "Makeup Artist",
      "definition" : "Makeup Artist"
    },
    {
      "code" : "5141.033",
      "display" : "Manicurist",
      "definition" : "Manicurist"
    },
    {
      "code" : "5141.034",
      "display" : "Massage Practitioner",
      "definition" : "Massage Practitioner"
    },
    {
      "code" : "5141.035",
      "display" : "Massage Therapist",
      "definition" : "Massage Therapist"
    },
    {
      "code" : "5141.036",
      "display" : "Masseur",
      "definition" : "Masseur"
    },
    {
      "code" : "5141.037",
      "display" : "Masseuse",
      "definition" : "Masseuse"
    },
    {
      "code" : "5141.038",
      "display" : "Mens Hairdresser",
      "definition" : "Mens Hairdresser"
    },
    {
      "code" : "5141.039",
      "display" : "Nail Technician",
      "definition" : "Nail Technician"
    },
    {
      "code" : "5141.040",
      "display" : "Physical Therapy Assistant",
      "definition" : "Physical Therapy Assistant"
    },
    {
      "code" : "5141.041",
      "display" : "Sauna Bath Attendant",
      "definition" : "Sauna Bath Attendant"
    },
    {
      "code" : "5141.042",
      "display" : "Trichologist",
      "definition" : "Trichologist"
    },
    {
      "code" : "5141.043",
      "display" : "Unisex Hairdresser",
      "definition" : "Unisex Hairdresser"
    },
    {
      "code" : "5141.044",
      "display" : "Unisex Stylist",
      "definition" : "Unisex Stylist"
    },
    {
      "code" : "5141.045",
      "display" : "Weight Loss Consultant",
      "definition" : "Weight Loss Consultant"
    },
    {
      "code" : "5141.046",
      "display" : "Wig Maker Supplier",
      "definition" : "Wig Maker Supplier"
    },
    {
      "code" : "5142.001",
      "display" : "Babysitter",
      "definition" : "Babysitter"
    },
    {
      "code" : "5142.002",
      "display" : "Car Seat Coordinator",
      "definition" : "Car Seat Coordinator"
    },
    {
      "code" : "5142.003",
      "display" : "Child Assistant",
      "definition" : "Child Assistant"
    },
    {
      "code" : "5142.004",
      "display" : "Child Car Seat Coordinator",
      "definition" : "Child Car Seat Coordinator"
    },
    {
      "code" : "5142.005",
      "display" : "Child Care Assistant",
      "definition" : "Child Care Assistant"
    },
    {
      "code" : "5142.006",
      "display" : "Child Care Worker",
      "definition" : "Child Care Worker"
    },
    {
      "code" : "5142.007",
      "display" : "Child Minder",
      "definition" : "Child Minder"
    },
    {
      "code" : "5142.008",
      "display" : "Childcare Assistant",
      "definition" : "Childcare Assistant"
    },
    {
      "code" : "5142.009",
      "display" : "Childcare Worker",
      "definition" : "Childcare Worker"
    },
    {
      "code" : "5142.010",
      "display" : "Creche Worker",
      "definition" : "Creche Worker"
    },
    {
      "code" : "5142.011",
      "display" : "Kaiawhina Kohanga Reo",
      "definition" : "Kaiawhina Kohanga Reo"
    },
    {
      "code" : "5142.012",
      "display" : "Kaiawhina Koohanga Reo",
      "definition" : "Kaiawhina Koohanga Reo"
    },
    {
      "code" : "5142.013",
      "display" : "Mothers Help",
      "definition" : "Mothers Help"
    },
    {
      "code" : "5142.014",
      "display" : "Nanny",
      "definition" : "Nanny"
    },
    {
      "code" : "5142.015",
      "display" : "Nursemaid",
      "definition" : "Nursemaid"
    },
    {
      "code" : "5142.016",
      "display" : "Nursery Attendant",
      "definition" : "Nursery Attendant"
    },
    {
      "code" : "5143.001",
      "display" : "Crematorium Worker",
      "definition" : "Crematorium Worker"
    },
    {
      "code" : "5143.002",
      "display" : "Embalmer",
      "definition" : "Embalmer"
    },
    {
      "code" : "5143.003",
      "display" : "Funeral Attendant",
      "definition" : "Funeral Attendant"
    },
    {
      "code" : "5143.004",
      "display" : "Funeral Director",
      "definition" : "Funeral Director"
    },
    {
      "code" : "5143.005",
      "display" : "Mortician",
      "definition" : "Mortician"
    },
    {
      "code" : "5143.006",
      "display" : "Undertaker",
      "definition" : "Undertaker"
    },
    {
      "code" : "5143.007",
      "display" : "Undertakers Assistant",
      "definition" : "Undertakers Assistant"
    },
    {
      "code" : "5151.001",
      "display" : "Aircraft Accident Firefighter",
      "definition" : "Aircraft Accident Firefighter"
    },
    {
      "code" : "5151.002",
      "display" : "Aircraft Crash Firefighter",
      "definition" : "Aircraft Crash Firefighter"
    },
    {
      "code" : "5151.003",
      "display" : "Airport Firefighter",
      "definition" : "Airport Firefighter"
    },
    {
      "code" : "5151.004",
      "display" : "Crash Fireman Officer Aircraft",
      "definition" : "Crash Fireman Officer Aircraft"
    },
    {
      "code" : "5151.005",
      "display" : "Fire Brigade Officer",
      "definition" : "Fire Brigade Officer"
    },
    {
      "code" : "5151.006",
      "display" : "Fire Equipment Officer Forest",
      "definition" : "Fire Equipment Officer Forest"
    },
    {
      "code" : "5151.007",
      "display" : "Fire Fighter",
      "definition" : "Fire Fighter"
    },
    {
      "code" : "5151.008",
      "display" : "Fire Fighter Forest",
      "definition" : "Fire Fighter Forest"
    },
    {
      "code" : "5151.009",
      "display" : "Fire Prevention Officer",
      "definition" : "Fire Prevention Officer"
    },
    {
      "code" : "5151.010",
      "display" : "Fire Protection Officer Forest",
      "definition" : "Fire Protection Officer Forest"
    },
    {
      "code" : "5151.011",
      "display" : "Firefighter",
      "definition" : "Firefighter"
    },
    {
      "code" : "5151.012",
      "display" : "Firefighter Forest",
      "definition" : "Firefighter Forest"
    },
    {
      "code" : "5151.013",
      "display" : "Fireman General",
      "definition" : "Fireman General"
    },
    {
      "code" : "5151.014",
      "display" : "Rescue Fire Fighter",
      "definition" : "Rescue Fire Fighter"
    },
    {
      "code" : "5151.015",
      "display" : "Rural Fire Fighter",
      "definition" : "Rural Fire Fighter"
    },
    {
      "code" : "5152.001",
      "display" : "Community Constable",
      "definition" : "Community Constable"
    },
    {
      "code" : "5152.002",
      "display" : "Constable",
      "definition" : "Constable"
    },
    {
      "code" : "5152.003",
      "display" : "Detective",
      "definition" : "Detective"
    },
    {
      "code" : "5152.004",
      "display" : "Ministry Of Transport Traffic Officer",
      "definition" : "Ministry Of Transport Traffic Officer"
    },
    {
      "code" : "5152.005",
      "display" : "Parking Meter Reader",
      "definition" : "Parking Meter Reader"
    },
    {
      "code" : "5152.006",
      "display" : "Parking Warden",
      "definition" : "Parking Warden"
    },
    {
      "code" : "5152.007",
      "display" : "Personal Protection Officer",
      "definition" : "Personal Protection Officer"
    },
    {
      "code" : "5152.008",
      "display" : "Police Commissioned Officer",
      "definition" : "Police Commissioned Officer"
    },
    {
      "code" : "5152.009",
      "display" : "Police Constable",
      "definition" : "Police Constable"
    },
    {
      "code" : "5152.010",
      "display" : "Police Detective",
      "definition" : "Police Detective"
    },
    {
      "code" : "5152.011",
      "display" : "Police Dog Handler",
      "definition" : "Police Dog Handler"
    },
    {
      "code" : "5152.012",
      "display" : "Police Officer",
      "definition" : "Police Officer"
    },
    {
      "code" : "5152.013",
      "display" : "Police Recruit",
      "definition" : "Police Recruit"
    },
    {
      "code" : "5152.014",
      "display" : "Police Sergeant",
      "definition" : "Police Sergeant"
    },
    {
      "code" : "5152.015",
      "display" : "Police Superintendent",
      "definition" : "Police Superintendent"
    },
    {
      "code" : "5152.016",
      "display" : "Police Trainee",
      "definition" : "Police Trainee"
    },
    {
      "code" : "5152.017",
      "display" : "Police Watchouse Officer",
      "definition" : "Police Watchouse Officer"
    },
    {
      "code" : "5152.018",
      "display" : "Police Woman",
      "definition" : "Police Woman"
    },
    {
      "code" : "5152.019",
      "display" : "Policeman",
      "definition" : "Policeman"
    },
    {
      "code" : "5152.020",
      "display" : "Policewoman",
      "definition" : "Policewoman"
    },
    {
      "code" : "5152.021",
      "display" : "Road Safety Officer",
      "definition" : "Road Safety Officer"
    },
    {
      "code" : "5152.022",
      "display" : "Traffic Inspector Road",
      "definition" : "Traffic Inspector Road"
    },
    {
      "code" : "5152.023",
      "display" : "Traffic Officer",
      "definition" : "Traffic Officer"
    },
    {
      "code" : "5152.024",
      "display" : "Traffic Warden",
      "definition" : "Traffic Warden"
    },
    {
      "code" : "5152.025",
      "display" : "Tunnel Officer Traffic",
      "definition" : "Tunnel Officer Traffic"
    },
    {
      "code" : "5153.001",
      "display" : "Aapiha Whakahaere Herehere",
      "definition" : "Aapiha Whakahaere Herehere"
    },
    {
      "code" : "5153.002",
      "display" : "Aapiha Whakatika Whakaora Mauhere",
      "definition" : "Aapiha Whakatika Whakaora Mauhere"
    },
    {
      "code" : "5153.003",
      "display" : "Apiha Whakahaere Herehere",
      "definition" : "Apiha Whakahaere Herehere"
    },
    {
      "code" : "5153.004",
      "display" : "Apiha Whakatika Whakaora Mauhere",
      "definition" : "Apiha Whakatika Whakaora Mauhere"
    },
    {
      "code" : "5153.005",
      "display" : "Correction Facility Worker",
      "definition" : "Correction Facility Worker"
    },
    {
      "code" : "5153.006",
      "display" : "Pouawhi",
      "definition" : "Pouawhi"
    },
    {
      "code" : "5153.007",
      "display" : "Prison Guard",
      "definition" : "Prison Guard"
    },
    {
      "code" : "5153.008",
      "display" : "Prison Officer",
      "definition" : "Prison Officer"
    },
    {
      "code" : "5153.009",
      "display" : "Prison Warden",
      "definition" : "Prison Warden"
    },
    {
      "code" : "5153.010",
      "display" : "Warden (Prison)",
      "definition" : "Warden (Prison)"
    },
    {
      "code" : "5153.011",
      "display" : "Warder",
      "definition" : "Warder"
    },
    {
      "code" : "5154.001",
      "display" : "Aapiha Marumaru",
      "definition" : "Aapiha Marumaru"
    },
    {
      "code" : "5154.002",
      "display" : "Aapiha Mataara",
      "definition" : "Aapiha Mataara"
    },
    {
      "code" : "5154.003",
      "display" : "Apiha Marumaru",
      "definition" : "Apiha Marumaru"
    },
    {
      "code" : "5154.004",
      "display" : "Apiha Mataara",
      "definition" : "Apiha Mataara"
    },
    {
      "code" : "5154.005",
      "display" : "Armoured Car Driver Security",
      "definition" : "Armoured Car Driver Security"
    },
    {
      "code" : "5154.006",
      "display" : "Aviation Security Officer",
      "definition" : "Aviation Security Officer"
    },
    {
      "code" : "5154.007",
      "display" : "Bank Escort",
      "definition" : "Bank Escort"
    },
    {
      "code" : "5154.008",
      "display" : "Bouncer",
      "definition" : "Bouncer"
    },
    {
      "code" : "5154.009",
      "display" : "Commissionaire Security",
      "definition" : "Commissionaire Security"
    },
    {
      "code" : "5154.010",
      "display" : "Egress Officer",
      "definition" : "Egress Officer"
    },
    {
      "code" : "5154.011",
      "display" : "Forest Guard",
      "definition" : "Forest Guard"
    },
    {
      "code" : "5154.012",
      "display" : "Museum Guard",
      "definition" : "Museum Guard"
    },
    {
      "code" : "5154.013",
      "display" : "Night Watchman",
      "definition" : "Night Watchman"
    },
    {
      "code" : "5154.014",
      "display" : "Park Warden",
      "definition" : "Park Warden"
    },
    {
      "code" : "5154.015",
      "display" : "Patrolman",
      "definition" : "Patrolman"
    },
    {
      "code" : "5154.016",
      "display" : "Port Security Officer",
      "definition" : "Port Security Officer"
    },
    {
      "code" : "5154.017",
      "display" : "Private Detective",
      "definition" : "Private Detective"
    },
    {
      "code" : "5154.018",
      "display" : "Private Enquiry Agent",
      "definition" : "Private Enquiry Agent"
    },
    {
      "code" : "5154.019",
      "display" : "Private Guard",
      "definition" : "Private Guard"
    },
    {
      "code" : "5154.020",
      "display" : "Private Investigator",
      "definition" : "Private Investigator"
    },
    {
      "code" : "5154.021",
      "display" : "Security Advisor",
      "definition" : "Security Advisor"
    },
    {
      "code" : "5154.022",
      "display" : "Security Agent",
      "definition" : "Security Agent"
    },
    {
      "code" : "5154.023",
      "display" : "Security Consultant",
      "definition" : "Security Consultant"
    },
    {
      "code" : "5154.024",
      "display" : "Security Courier",
      "definition" : "Security Courier"
    },
    {
      "code" : "5154.025",
      "display" : "Security Guard",
      "definition" : "Security Guard"
    },
    {
      "code" : "5154.026",
      "display" : "Security Officer",
      "definition" : "Security Officer"
    },
    {
      "code" : "5154.027",
      "display" : "Shop Floor Walker",
      "definition" : "Shop Floor Walker"
    },
    {
      "code" : "5154.028",
      "display" : "Store Detective",
      "definition" : "Store Detective"
    },
    {
      "code" : "5154.029",
      "display" : "Taituara",
      "definition" : "Taituara"
    },
    {
      "code" : "5154.030",
      "display" : "Taituaraa",
      "definition" : "Taituaraa"
    },
    {
      "code" : "5154.031",
      "display" : "Tangata Mataara",
      "definition" : "Tangata Mataara"
    },
    {
      "code" : "5155.001",
      "display" : "Air Force Navigator",
      "definition" : "Air Force Navigator"
    },
    {
      "code" : "5155.002",
      "display" : "Airforce Pilot",
      "definition" : "Airforce Pilot"
    },
    {
      "code" : "5155.003",
      "display" : "Airman",
      "definition" : "Airman"
    },
    {
      "code" : "5155.004",
      "display" : "Airwoman",
      "definition" : "Airwoman"
    },
    {
      "code" : "5155.005",
      "display" : "Armed Forces",
      "definition" : "Armed Forces"
    },
    {
      "code" : "5155.006",
      "display" : "Army Armoured Vehicle Crew",
      "definition" : "Army Armoured Vehicle Crew"
    },
    {
      "code" : "5155.007",
      "display" : "Army Officer",
      "definition" : "Army Officer"
    },
    {
      "code" : "5155.008",
      "display" : "Artillery Signaller",
      "definition" : "Artillery Signaller"
    },
    {
      "code" : "5155.009",
      "display" : "Hoia",
      "definition" : "Hoia"
    },
    {
      "code" : "5155.010",
      "display" : "Military Policeman",
      "definition" : "Military Policeman"
    },
    {
      "code" : "5155.011",
      "display" : "Naval Officer",
      "definition" : "Naval Officer"
    },
    {
      "code" : "5155.012",
      "display" : "Naval Rater",
      "definition" : "Naval Rater"
    },
    {
      "code" : "5155.013",
      "display" : "Naval Rating",
      "definition" : "Naval Rating"
    },
    {
      "code" : "5155.014",
      "display" : "Navy Officer",
      "definition" : "Navy Officer"
    },
    {
      "code" : "5155.015",
      "display" : "Navy Rating",
      "definition" : "Navy Rating"
    },
    {
      "code" : "5155.016",
      "display" : "Navy Seaman",
      "definition" : "Navy Seaman"
    },
    {
      "code" : "5155.017",
      "display" : "Petty Officer Navy",
      "definition" : "Petty Officer Navy"
    },
    {
      "code" : "5155.018",
      "display" : "RNZAF Pilot",
      "definition" : "RNZAF Pilot"
    },
    {
      "code" : "5155.019",
      "display" : "Sailor Navy",
      "definition" : "Sailor Navy"
    },
    {
      "code" : "5155.020",
      "display" : "Soldier",
      "definition" : "Soldier"
    },
    {
      "code" : "5211.001",
      "display" : "Agricultural Equipment Parts Salesperson",
      "definition" : "Agricultural Equipment Parts Salesperson"
    },
    {
      "code" : "5211.002",
      "display" : "Amway Distributor",
      "definition" : "Amway Distributor"
    },
    {
      "code" : "5211.003",
      "display" : "Amway Seller",
      "definition" : "Amway Seller"
    },
    {
      "code" : "5211.004",
      "display" : "Auto Parts Salesman",
      "definition" : "Auto Parts Salesman"
    },
    {
      "code" : "5211.005",
      "display" : "Automobile Saleperson",
      "definition" : "Automobile Saleperson"
    },
    {
      "code" : "5211.006",
      "display" : "Automotive Parts Salesperson",
      "definition" : "Automotive Parts Salesperson"
    },
    {
      "code" : "5211.007",
      "display" : "Bicycle Salesperson",
      "definition" : "Bicycle Salesperson"
    },
    {
      "code" : "5211.008",
      "display" : "Book Shop Assistant",
      "definition" : "Book Shop Assistant"
    },
    {
      "code" : "5211.009",
      "display" : "Bottle Store Assistant",
      "definition" : "Bottle Store Assistant"
    },
    {
      "code" : "5211.010",
      "display" : "Bottle Store Attendant",
      "definition" : "Bottle Store Attendant"
    },
    {
      "code" : "5211.011",
      "display" : "Boutique Sales Assistant",
      "definition" : "Boutique Sales Assistant"
    },
    {
      "code" : "5211.012",
      "display" : "Car Parts Salesman",
      "definition" : "Car Parts Salesman"
    },
    {
      "code" : "5211.013",
      "display" : "Car Parts Salesperson",
      "definition" : "Car Parts Salesperson"
    },
    {
      "code" : "5211.014",
      "display" : "Car Salesman",
      "definition" : "Car Salesman"
    },
    {
      "code" : "5211.015",
      "display" : "Car Salesperson",
      "definition" : "Car Salesperson"
    },
    {
      "code" : "5211.016",
      "display" : "Checkout Assistant",
      "definition" : "Checkout Assistant"
    },
    {
      "code" : "5211.017",
      "display" : "Clothing Sales Consultant",
      "definition" : "Clothing Sales Consultant"
    },
    {
      "code" : "5211.018",
      "display" : "Corsetiere",
      "definition" : "Corsetiere"
    },
    {
      "code" : "5211.019",
      "display" : "Cycle Salesperson",
      "definition" : "Cycle Salesperson"
    },
    {
      "code" : "5211.020",
      "display" : "Deli Assistant",
      "definition" : "Deli Assistant"
    },
    {
      "code" : "5211.021",
      "display" : "Delicatessan Assistant",
      "definition" : "Delicatessan Assistant"
    },
    {
      "code" : "5211.022",
      "display" : "Demonstrator",
      "definition" : "Demonstrator"
    },
    {
      "code" : "5211.023",
      "display" : "Fashion Sales Assistant",
      "definition" : "Fashion Sales Assistant"
    },
    {
      "code" : "5211.024",
      "display" : "Florist",
      "definition" : "Florist"
    },
    {
      "code" : "5211.025",
      "display" : "Florists Assistant",
      "definition" : "Florists Assistant"
    },
    {
      "code" : "5211.026",
      "display" : "Food Demonstrator",
      "definition" : "Food Demonstrator"
    },
    {
      "code" : "5211.027",
      "display" : "Forecourt Attendant",
      "definition" : "Forecourt Attendant"
    },
    {
      "code" : "5211.028",
      "display" : "Garage Attendant",
      "definition" : "Garage Attendant"
    },
    {
      "code" : "5211.029",
      "display" : "Gas Station Attendant",
      "definition" : "Gas Station Attendant"
    },
    {
      "code" : "5211.030",
      "display" : "Grocery Assistant",
      "definition" : "Grocery Assistant"
    },
    {
      "code" : "5211.031",
      "display" : "Grocery Worker",
      "definition" : "Grocery Worker"
    },
    {
      "code" : "5211.032",
      "display" : "Hardware Sales Assistant",
      "definition" : "Hardware Sales Assistant"
    },
    {
      "code" : "5211.033",
      "display" : "Home Appliance Salesperson",
      "definition" : "Home Appliance Salesperson"
    },
    {
      "code" : "5211.034",
      "display" : "Installer Blinds Luxaflex Holland",
      "definition" : "Installer Blinds Luxaflex Holland"
    },
    {
      "code" : "5211.035",
      "display" : "Kaiawhina Hokohoko",
      "definition" : "Kaiawhina Hokohoko"
    },
    {
      "code" : "5211.036",
      "display" : "Kaiawhina Kaihokohoko",
      "definition" : "Kaiawhina Kaihokohoko"
    },
    {
      "code" : "5211.037",
      "display" : "Kaiawhina Toa",
      "definition" : "Kaiawhina Toa"
    },
    {
      "code" : "5211.038",
      "display" : "Kaiawhina Toa Hokohoko",
      "definition" : "Kaiawhina Toa Hokohoko"
    },
    {
      "code" : "5211.039",
      "display" : "Kaihoko",
      "definition" : "Kaihoko"
    },
    {
      "code" : "5211.040",
      "display" : "Kaihokohoko",
      "definition" : "Kaihokohoko"
    },
    {
      "code" : "5211.041",
      "display" : "Kaimahi Whare Penehiini",
      "definition" : "Kaimahi Whare Penehiini"
    },
    {
      "code" : "5211.042",
      "display" : "Kaimahi Whare Penehini",
      "definition" : "Kaimahi Whare Penehini"
    },
    {
      "code" : "5211.043",
      "display" : "Mail Order Salesman",
      "definition" : "Mail Order Salesman"
    },
    {
      "code" : "5211.044",
      "display" : "Merchandiser",
      "definition" : "Merchandiser"
    },
    {
      "code" : "5211.045",
      "display" : "Motor Vehicle Salesman",
      "definition" : "Motor Vehicle Salesman"
    },
    {
      "code" : "5211.046",
      "display" : "Motor Vehicle Salesperson",
      "definition" : "Motor Vehicle Salesperson"
    },
    {
      "code" : "5211.047",
      "display" : "Night Filler",
      "definition" : "Night Filler"
    },
    {
      "code" : "5211.048",
      "display" : "Orderman Wholesale or Retail",
      "definition" : "Orderman Wholesale or Retail"
    },
    {
      "code" : "5211.049",
      "display" : "Party Plan Seller",
      "definition" : "Party Plan Seller"
    },
    {
      "code" : "5211.050",
      "display" : "Petrol Attendant",
      "definition" : "Petrol Attendant"
    },
    {
      "code" : "5211.051",
      "display" : "Petrol Pump Attendant",
      "definition" : "Petrol Pump Attendant"
    },
    {
      "code" : "5211.052",
      "display" : "Petroleum Distribution Agent",
      "definition" : "Petroleum Distribution Agent"
    },
    {
      "code" : "5211.053",
      "display" : "Petroleum Transfer Technician",
      "definition" : "Petroleum Transfer Technician"
    },
    {
      "code" : "5211.054",
      "display" : "Pharmacy Salesperson",
      "definition" : "Pharmacy Salesperson"
    },
    {
      "code" : "5211.055",
      "display" : "Promotion Salesperson",
      "definition" : "Promotion Salesperson"
    },
    {
      "code" : "5211.056",
      "display" : "Retail Assistant",
      "definition" : "Retail Assistant"
    },
    {
      "code" : "5211.057",
      "display" : "Retail Officer",
      "definition" : "Retail Officer"
    },
    {
      "code" : "5211.058",
      "display" : "Retail Pharmacy Assistant",
      "definition" : "Retail Pharmacy Assistant"
    },
    {
      "code" : "5211.059",
      "display" : "Retail Sales Consultant",
      "definition" : "Retail Sales Consultant"
    },
    {
      "code" : "5211.060",
      "display" : "Retail Salesman",
      "definition" : "Retail Salesman"
    },
    {
      "code" : "5211.061",
      "display" : "Retail Salesperson",
      "definition" : "Retail Salesperson"
    },
    {
      "code" : "5211.062",
      "display" : "Sales Assistant",
      "definition" : "Sales Assistant"
    },
    {
      "code" : "5211.063",
      "display" : "Sales Consultant",
      "definition" : "Sales Consultant"
    },
    {
      "code" : "5211.064",
      "display" : "Sales Demonstrator",
      "definition" : "Sales Demonstrator"
    },
    {
      "code" : "5211.065",
      "display" : "Sales Man",
      "definition" : "Sales Man"
    },
    {
      "code" : "5211.066",
      "display" : "Sales Merchandiser",
      "definition" : "Sales Merchandiser"
    },
    {
      "code" : "5211.067",
      "display" : "Sales Person",
      "definition" : "Sales Person"
    },
    {
      "code" : "5211.068",
      "display" : "Sales Promotions Supervisor",
      "definition" : "Sales Promotions Supervisor"
    },
    {
      "code" : "5211.069",
      "display" : "Sales Supervisor",
      "definition" : "Sales Supervisor"
    },
    {
      "code" : "5211.070",
      "display" : "Sales Supervisor Retail",
      "definition" : "Sales Supervisor Retail"
    },
    {
      "code" : "5211.071",
      "display" : "Sales Supervisor Wholesale",
      "definition" : "Sales Supervisor Wholesale"
    },
    {
      "code" : "5211.072",
      "display" : "Sales Worker",
      "definition" : "Sales Worker"
    },
    {
      "code" : "5211.073",
      "display" : "Salesman",
      "definition" : "Salesman"
    },
    {
      "code" : "5211.074",
      "display" : "Salesman Automotive Parts Retail",
      "definition" : "Salesman Automotive Parts Retail"
    },
    {
      "code" : "5211.075",
      "display" : "Salesperson",
      "definition" : "Salesperson"
    },
    {
      "code" : "5211.076",
      "display" : "Salesperson Educational Aid",
      "definition" : "Salesperson Educational Aid"
    },
    {
      "code" : "5211.077",
      "display" : "Saleswoman",
      "definition" : "Saleswoman"
    },
    {
      "code" : "5211.078",
      "display" : "Service Station Attendant",
      "definition" : "Service Station Attendant"
    },
    {
      "code" : "5211.079",
      "display" : "Shop Assistant",
      "definition" : "Shop Assistant"
    },
    {
      "code" : "5211.080",
      "display" : "Shop Shelf Filler",
      "definition" : "Shop Shelf Filler"
    },
    {
      "code" : "5211.081",
      "display" : "Shop Shelf Stacker",
      "definition" : "Shop Shelf Stacker"
    },
    {
      "code" : "5211.082",
      "display" : "Shop Shelver",
      "definition" : "Shop Shelver"
    },
    {
      "code" : "5211.083",
      "display" : "Spare Parts Salesman",
      "definition" : "Spare Parts Salesman"
    },
    {
      "code" : "5211.084",
      "display" : "Sports Goods Salesman",
      "definition" : "Sports Goods Salesman"
    },
    {
      "code" : "5211.085",
      "display" : "Stamp Dealer",
      "definition" : "Stamp Dealer"
    },
    {
      "code" : "5211.086",
      "display" : "Store Assistant",
      "definition" : "Store Assistant"
    },
    {
      "code" : "5211.087",
      "display" : "Supermarket Shelf Stacker",
      "definition" : "Supermarket Shelf Stacker"
    },
    {
      "code" : "5211.088",
      "display" : "Tangata Hokohoko",
      "definition" : "Tangata Hokohoko"
    },
    {
      "code" : "5211.089",
      "display" : "Timber Sales Officer Forestry",
      "definition" : "Timber Sales Officer Forestry"
    },
    {
      "code" : "5211.090",
      "display" : "Truck Parts Salesperson",
      "definition" : "Truck Parts Salesperson"
    },
    {
      "code" : "5211.091",
      "display" : "Tupperware Dealer",
      "definition" : "Tupperware Dealer"
    },
    {
      "code" : "5211.092",
      "display" : "Tyre Repairer Garage",
      "definition" : "Tyre Repairer Garage"
    },
    {
      "code" : "5211.093",
      "display" : "Tyre Salesman",
      "definition" : "Tyre Salesman"
    },
    {
      "code" : "5211.094",
      "display" : "Used Car Salesperson",
      "definition" : "Used Car Salesperson"
    },
    {
      "code" : "5211.095",
      "display" : "Vehicle Salesman",
      "definition" : "Vehicle Salesman"
    },
    {
      "code" : "5211.096",
      "display" : "Vehicle Salesperson",
      "definition" : "Vehicle Salesperson"
    },
    {
      "code" : "5211.097",
      "display" : "Video Shop Assistant",
      "definition" : "Video Shop Assistant"
    },
    {
      "code" : "5211.098",
      "display" : "Warehouse Salesman",
      "definition" : "Warehouse Salesman"
    },
    {
      "code" : "5221.001",
      "display" : "Amusement Fairground Attendant",
      "definition" : "Amusement Fairground Attendant"
    },
    {
      "code" : "5221.002",
      "display" : "Bread Contractor",
      "definition" : "Bread Contractor"
    },
    {
      "code" : "5221.003",
      "display" : "Bread Contractor Vendor",
      "definition" : "Bread Contractor Vendor"
    },
    {
      "code" : "5221.004",
      "display" : "Hawker",
      "definition" : "Hawker"
    },
    {
      "code" : "5221.005",
      "display" : "Ice Cream Vendor",
      "definition" : "Ice Cream Vendor"
    },
    {
      "code" : "5221.006",
      "display" : "Milk Man",
      "definition" : "Milk Man"
    },
    {
      "code" : "5221.007",
      "display" : "Milk Vendor",
      "definition" : "Milk Vendor"
    },
    {
      "code" : "5221.008",
      "display" : "Milkman",
      "definition" : "Milkman"
    },
    {
      "code" : "5221.009",
      "display" : "Newsagent Vendor Street",
      "definition" : "Newsagent Vendor Street"
    },
    {
      "code" : "5221.010",
      "display" : "Salesman Driver",
      "definition" : "Salesman Driver"
    },
    {
      "code" : "5221.011",
      "display" : "Side Show Worker",
      "definition" : "Side Show Worker"
    },
    {
      "code" : "5221.012",
      "display" : "Street Vendor",
      "definition" : "Street Vendor"
    },
    {
      "code" : "5221.013",
      "display" : "Street Vendor and Related Worker",
      "definition" : "Street Vendor and Related Worker"
    },
    {
      "code" : "5221.014",
      "display" : "Van Salesman",
      "definition" : "Van Salesman"
    },
    {
      "code" : "5231.001",
      "display" : "Artists Model",
      "definition" : "Artists Model"
    },
    {
      "code" : "5231.002",
      "display" : "Fashion and Other Model",
      "definition" : "Fashion and Other Model"
    },
    {
      "code" : "5231.003",
      "display" : "Fashion Model",
      "definition" : "Fashion Model"
    },
    {
      "code" : "5231.004",
      "display" : "Model",
      "definition" : "Model"
    },
    {
      "code" : "5231.005",
      "display" : "Modelling Instructor",
      "definition" : "Modelling Instructor"
    },
    {
      "code" : "5231.006",
      "display" : "Photographic Model",
      "definition" : "Photographic Model"
    },
    {
      "code" : "6111.001",
      "display" : "Arable Farmer",
      "definition" : "Arable Farmer"
    },
    {
      "code" : "6111.002",
      "display" : "Crop Farmer",
      "definition" : "Crop Farmer"
    },
    {
      "code" : "6111.003",
      "display" : "Crop Grower",
      "definition" : "Crop Grower"
    },
    {
      "code" : "6111.004",
      "display" : "Crop Worker",
      "definition" : "Crop Worker"
    },
    {
      "code" : "6111.005",
      "display" : "Field Crop Farm Cadet",
      "definition" : "Field Crop Farm Cadet"
    },
    {
      "code" : "6111.006",
      "display" : "Field Crop Farm Manager",
      "definition" : "Field Crop Farm Manager"
    },
    {
      "code" : "6111.007",
      "display" : "Field Crop Farm Supervisor",
      "definition" : "Field Crop Farm Supervisor"
    },
    {
      "code" : "6111.008",
      "display" : "Field Crop Farmer",
      "definition" : "Field Crop Farmer"
    },
    {
      "code" : "6111.009",
      "display" : "Field Crop Grower",
      "definition" : "Field Crop Grower"
    },
    {
      "code" : "6111.010",
      "display" : "Field Crop Grower and Related Worker",
      "definition" : "Field Crop Grower and Related Worker"
    },
    {
      "code" : "6111.011",
      "display" : "Field Crop Worker",
      "definition" : "Field Crop Worker"
    },
    {
      "code" : "6111.012",
      "display" : "Flax Cutter",
      "definition" : "Flax Cutter"
    },
    {
      "code" : "6111.013",
      "display" : "Flax Farm Manager",
      "definition" : "Flax Farm Manager"
    },
    {
      "code" : "6111.014",
      "display" : "Flax Farm Worker",
      "definition" : "Flax Farm Worker"
    },
    {
      "code" : "6111.015",
      "display" : "Glasshouse Worker",
      "definition" : "Glasshouse Worker"
    },
    {
      "code" : "6111.016",
      "display" : "Greenhouse Worker Market Garden",
      "definition" : "Greenhouse Worker Market Garden"
    },
    {
      "code" : "6111.017",
      "display" : "Hop Farmer",
      "definition" : "Hop Farmer"
    },
    {
      "code" : "6111.018",
      "display" : "Hop Grower",
      "definition" : "Hop Grower"
    },
    {
      "code" : "6111.019",
      "display" : "Hop Picker",
      "definition" : "Hop Picker"
    },
    {
      "code" : "6111.020",
      "display" : "Kumara Grower",
      "definition" : "Kumara Grower"
    },
    {
      "code" : "6111.021",
      "display" : "Maize Farmer",
      "definition" : "Maize Farmer"
    },
    {
      "code" : "6111.022",
      "display" : "Market Garden Manager",
      "definition" : "Market Garden Manager"
    },
    {
      "code" : "6111.023",
      "display" : "Market Garden Worker",
      "definition" : "Market Garden Worker"
    },
    {
      "code" : "6111.024",
      "display" : "Market Gardener",
      "definition" : "Market Gardener"
    },
    {
      "code" : "6111.025",
      "display" : "Market Gardener and Related Worker",
      "definition" : "Market Gardener and Related Worker"
    },
    {
      "code" : "6111.026",
      "display" : "Market Gardener Glass House",
      "definition" : "Market Gardener Glass House"
    },
    {
      "code" : "6111.027",
      "display" : "Market Gardening Cadet",
      "definition" : "Market Gardening Cadet"
    },
    {
      "code" : "6111.028",
      "display" : "Market Gardening Farmer",
      "definition" : "Market Gardening Farmer"
    },
    {
      "code" : "6111.029",
      "display" : "Market Gardening Supervisor",
      "definition" : "Market Gardening Supervisor"
    },
    {
      "code" : "6111.030",
      "display" : "Mushroom Grower",
      "definition" : "Mushroom Grower"
    },
    {
      "code" : "6111.031",
      "display" : "Mushroom Grower Farmer",
      "definition" : "Mushroom Grower Farmer"
    },
    {
      "code" : "6111.032",
      "display" : "Mushroom Hand",
      "definition" : "Mushroom Hand"
    },
    {
      "code" : "6111.033",
      "display" : "Mushroom Picker",
      "definition" : "Mushroom Picker"
    },
    {
      "code" : "6111.034",
      "display" : "Organic Crop Grower",
      "definition" : "Organic Crop Grower"
    },
    {
      "code" : "6111.035",
      "display" : "Other Field Crop Farmer",
      "definition" : "Other Field Crop Farmer"
    },
    {
      "code" : "6111.036",
      "display" : "Potato Farmer",
      "definition" : "Potato Farmer"
    },
    {
      "code" : "6111.037",
      "display" : "Potato Grower",
      "definition" : "Potato Grower"
    },
    {
      "code" : "6111.038",
      "display" : "Quality Controller Of Market Gardeners And Workers",
      "definition" : "Quality Controller Of Market Gardeners And Workers"
    },
    {
      "code" : "6111.039",
      "display" : "Tobacco Crop Hand",
      "definition" : "Tobacco Crop Hand"
    },
    {
      "code" : "6111.040",
      "display" : "Tobacco Grower",
      "definition" : "Tobacco Grower"
    },
    {
      "code" : "6111.041",
      "display" : "Tobacco Picker",
      "definition" : "Tobacco Picker"
    },
    {
      "code" : "6111.042",
      "display" : "Tomato Farm Worker",
      "definition" : "Tomato Farm Worker"
    },
    {
      "code" : "6111.043",
      "display" : "Tomato Farmer",
      "definition" : "Tomato Farmer"
    },
    {
      "code" : "6111.044",
      "display" : "Tomato Grower",
      "definition" : "Tomato Grower"
    },
    {
      "code" : "6111.045",
      "display" : "Tomato Picker",
      "definition" : "Tomato Picker"
    },
    {
      "code" : "6111.046",
      "display" : "Vegetable Farm Worker",
      "definition" : "Vegetable Farm Worker"
    },
    {
      "code" : "6111.047",
      "display" : "Vegetable Farmer",
      "definition" : "Vegetable Farmer"
    },
    {
      "code" : "6111.048",
      "display" : "Vegetable Grower",
      "definition" : "Vegetable Grower"
    },
    {
      "code" : "6111.049",
      "display" : "Vegetable Picker Grader",
      "definition" : "Vegetable Picker Grader"
    },
    {
      "code" : "6112.001",
      "display" : "Apple Orchardist",
      "definition" : "Apple Orchardist"
    },
    {
      "code" : "6112.002",
      "display" : "Apple Picker",
      "definition" : "Apple Picker"
    },
    {
      "code" : "6112.003",
      "display" : "Berry Fruit Grower",
      "definition" : "Berry Fruit Grower"
    },
    {
      "code" : "6112.004",
      "display" : "Berry Fruit Worker",
      "definition" : "Berry Fruit Worker"
    },
    {
      "code" : "6112.005",
      "display" : "Berry Picker",
      "definition" : "Berry Picker"
    },
    {
      "code" : "6112.006",
      "display" : "Berryfruit Farm Manager",
      "definition" : "Berryfruit Farm Manager"
    },
    {
      "code" : "6112.007",
      "display" : "Berryfruit Farm Supervisor",
      "definition" : "Berryfruit Farm Supervisor"
    },
    {
      "code" : "6112.008",
      "display" : "Berryfruit Farmer",
      "definition" : "Berryfruit Farmer"
    },
    {
      "code" : "6112.009",
      "display" : "Berryfruit Grower",
      "definition" : "Berryfruit Grower"
    },
    {
      "code" : "6112.010",
      "display" : "Berryfruit Worker",
      "definition" : "Berryfruit Worker"
    },
    {
      "code" : "6112.011",
      "display" : "Citrus Fruit Farmer",
      "definition" : "Citrus Fruit Farmer"
    },
    {
      "code" : "6112.012",
      "display" : "Currant Grower",
      "definition" : "Currant Grower"
    },
    {
      "code" : "6112.013",
      "display" : "Farmer Orchardist",
      "definition" : "Farmer Orchardist"
    },
    {
      "code" : "6112.014",
      "display" : "Fruit Farm Hand",
      "definition" : "Fruit Farm Hand"
    },
    {
      "code" : "6112.015",
      "display" : "Fruit Farm Manager Orchard",
      "definition" : "Fruit Farm Manager Orchard"
    },
    {
      "code" : "6112.016",
      "display" : "Fruit Farm Supervisor Orchard",
      "definition" : "Fruit Farm Supervisor Orchard"
    },
    {
      "code" : "6112.017",
      "display" : "Fruit Grader Packer in Orchard",
      "definition" : "Fruit Grader Packer in Orchard"
    },
    {
      "code" : "6112.018",
      "display" : "Fruit Grower",
      "definition" : "Fruit Grower"
    },
    {
      "code" : "6112.019",
      "display" : "Fruit Grower Orchard",
      "definition" : "Fruit Grower Orchard"
    },
    {
      "code" : "6112.020",
      "display" : "Fruit Grower Worker Orchard",
      "definition" : "Fruit Grower Worker Orchard"
    },
    {
      "code" : "6112.021",
      "display" : "Fruit Picker",
      "definition" : "Fruit Picker"
    },
    {
      "code" : "6112.022",
      "display" : "Grape Grower",
      "definition" : "Grape Grower"
    },
    {
      "code" : "6112.023",
      "display" : "Grape Grower Or Wine Maker",
      "definition" : "Grape Grower Or Wine Maker"
    },
    {
      "code" : "6112.024",
      "display" : "Grape Growing Vineyard Worker",
      "definition" : "Grape Growing Vineyard Worker"
    },
    {
      "code" : "6112.025",
      "display" : "Kaikohi AAporo",
      "definition" : "Kaikohi AAporo"
    },
    {
      "code" : "6112.026",
      "display" : "Kaikohi Aporo",
      "definition" : "Kaikohi Aporo"
    },
    {
      "code" : "6112.027",
      "display" : "Kaikohi Hua Raakau",
      "definition" : "Kaikohi Hua Raakau"
    },
    {
      "code" : "6112.028",
      "display" : "Kaikohi Hua Rakau",
      "definition" : "Kaikohi Hua Rakau"
    },
    {
      "code" : "6112.029",
      "display" : "Kaimahi Waahi Whakatipu Hua Raakau",
      "definition" : "Kaimahi Waahi Whakatipu Hua Raakau"
    },
    {
      "code" : "6112.030",
      "display" : "Kaimahi Wahi Whakatipu Hua Rakau",
      "definition" : "Kaimahi Wahi Whakatipu Hua Rakau"
    },
    {
      "code" : "6112.031",
      "display" : "Kaitiaki Hua Raakau",
      "definition" : "Kaitiaki Hua Raakau"
    },
    {
      "code" : "6112.032",
      "display" : "Kaitiaki Hua Rakau",
      "definition" : "Kaitiaki Hua Rakau"
    },
    {
      "code" : "6112.033",
      "display" : "Kaiwehewehe Hua Raakau",
      "definition" : "Kaiwehewehe Hua Raakau"
    },
    {
      "code" : "6112.034",
      "display" : "Kaiwehewehe Hua Rakau",
      "definition" : "Kaiwehewehe Hua Rakau"
    },
    {
      "code" : "6112.035",
      "display" : "Kaiwhakahaere Uru Hua Raakau",
      "definition" : "Kaiwhakahaere Uru Hua Raakau"
    },
    {
      "code" : "6112.036",
      "display" : "Kaiwhakahaere Uru Hua Rakau",
      "definition" : "Kaiwhakahaere Uru Hua Rakau"
    },
    {
      "code" : "6112.037",
      "display" : "Kaiwhakahaere Waahi Whakatipu Hua Raakau",
      "definition" : "Kaiwhakahaere Waahi Whakatipu Hua Raakau"
    },
    {
      "code" : "6112.038",
      "display" : "Kaiwhakahaere Wahi Whakatipu Hua Rakau",
      "definition" : "Kaiwhakahaere Wahi Whakatipu Hua Rakau"
    },
    {
      "code" : "6112.039",
      "display" : "Kiwifruit Grower",
      "definition" : "Kiwifruit Grower"
    },
    {
      "code" : "6112.040",
      "display" : "Kiwifruit Orchardist",
      "definition" : "Kiwifruit Orchardist"
    },
    {
      "code" : "6112.041",
      "display" : "Oenologist",
      "definition" : "Oenologist"
    },
    {
      "code" : "6112.042",
      "display" : "Orchard Hand",
      "definition" : "Orchard Hand"
    },
    {
      "code" : "6112.043",
      "display" : "Orchard Labourer",
      "definition" : "Orchard Labourer"
    },
    {
      "code" : "6112.044",
      "display" : "Orchard Manager",
      "definition" : "Orchard Manager"
    },
    {
      "code" : "6112.045",
      "display" : "Orchard Supervisor",
      "definition" : "Orchard Supervisor"
    },
    {
      "code" : "6112.046",
      "display" : "Orchard Worker",
      "definition" : "Orchard Worker"
    },
    {
      "code" : "6112.047",
      "display" : "Orchardist",
      "definition" : "Orchardist"
    },
    {
      "code" : "6112.048",
      "display" : "Orchardist Cadet",
      "definition" : "Orchardist Cadet"
    },
    {
      "code" : "6112.049",
      "display" : "Pipfruit Grower",
      "definition" : "Pipfruit Grower"
    },
    {
      "code" : "6112.050",
      "display" : "Quality Controller Of Fruit Grower Workers",
      "definition" : "Quality Controller Of Fruit Grower Workers"
    },
    {
      "code" : "6112.051",
      "display" : "Raspberry Grower",
      "definition" : "Raspberry Grower"
    },
    {
      "code" : "6112.052",
      "display" : "Stone Fruit Grower",
      "definition" : "Stone Fruit Grower"
    },
    {
      "code" : "6112.053",
      "display" : "Strawberry Grower",
      "definition" : "Strawberry Grower"
    },
    {
      "code" : "6112.054",
      "display" : "Subtropical Fruit Grower",
      "definition" : "Subtropical Fruit Grower"
    },
    {
      "code" : "6112.055",
      "display" : "Vigneron",
      "definition" : "Vigneron"
    },
    {
      "code" : "6112.056",
      "display" : "Vineyard Hand",
      "definition" : "Vineyard Hand"
    },
    {
      "code" : "6112.057",
      "display" : "Vineyard Manager",
      "definition" : "Vineyard Manager"
    },
    {
      "code" : "6112.058",
      "display" : "Vineyard Supervisor",
      "definition" : "Vineyard Supervisor"
    },
    {
      "code" : "6112.059",
      "display" : "Vineyard Worker",
      "definition" : "Vineyard Worker"
    },
    {
      "code" : "6112.060",
      "display" : "Viticulturist",
      "definition" : "Viticulturist"
    },
    {
      "code" : "6112.061",
      "display" : "Wine Blender",
      "definition" : "Wine Blender"
    },
    {
      "code" : "6112.062",
      "display" : "Wine Maker",
      "definition" : "Wine Maker"
    },
    {
      "code" : "6112.063",
      "display" : "Wine Making Worker",
      "definition" : "Wine Making Worker"
    },
    {
      "code" : "6112.064",
      "display" : "Winemaker",
      "definition" : "Winemaker"
    },
    {
      "code" : "6113.001",
      "display" : "Agricultural Horticulture Worker",
      "definition" : "Agricultural Horticulture Worker"
    },
    {
      "code" : "6113.002",
      "display" : "Arborist",
      "definition" : "Arborist"
    },
    {
      "code" : "6113.003",
      "display" : "Bulb Grower",
      "definition" : "Bulb Grower"
    },
    {
      "code" : "6113.004",
      "display" : "Caretaker Parks",
      "definition" : "Caretaker Parks"
    },
    {
      "code" : "6113.005",
      "display" : "Floraculturist",
      "definition" : "Floraculturist"
    },
    {
      "code" : "6113.006",
      "display" : "Flower Grower",
      "definition" : "Flower Grower"
    },
    {
      "code" : "6113.007",
      "display" : "Gardener",
      "definition" : "Gardener"
    },
    {
      "code" : "6113.008",
      "display" : "Green Keeper",
      "definition" : "Green Keeper"
    },
    {
      "code" : "6113.009",
      "display" : "Greenhouse Worker Nursery",
      "definition" : "Greenhouse Worker Nursery"
    },
    {
      "code" : "6113.010",
      "display" : "Greenkeeper",
      "definition" : "Greenkeeper"
    },
    {
      "code" : "6113.011",
      "display" : "Greenkeeper Sport and Recreation Grounds",
      "definition" : "Greenkeeper Sport and Recreation Grounds"
    },
    {
      "code" : "6113.012",
      "display" : "Greens Superintendent",
      "definition" : "Greens Superintendent"
    },
    {
      "code" : "6113.013",
      "display" : "Grounds or Green Keeper",
      "definition" : "Grounds or Green Keeper"
    },
    {
      "code" : "6113.014",
      "display" : "Groundsman",
      "definition" : "Groundsman"
    },
    {
      "code" : "6113.015",
      "display" : "Groundsman Sports and Recreation",
      "definition" : "Groundsman Sports and Recreation"
    },
    {
      "code" : "6113.016",
      "display" : "Groundsperson",
      "definition" : "Groundsperson"
    },
    {
      "code" : "6113.017",
      "display" : "Hedge Cutting Contractor",
      "definition" : "Hedge Cutting Contractor"
    },
    {
      "code" : "6113.018",
      "display" : "Horticultural Assistant",
      "definition" : "Horticultural Assistant"
    },
    {
      "code" : "6113.019",
      "display" : "Horticultural Nursery Advisor",
      "definition" : "Horticultural Nursery Advisor"
    },
    {
      "code" : "6113.020",
      "display" : "Horticultural Superintendent",
      "definition" : "Horticultural Superintendent"
    },
    {
      "code" : "6113.021",
      "display" : "Horticultural Worker",
      "definition" : "Horticultural Worker"
    },
    {
      "code" : "6113.022",
      "display" : "Horticulturalist",
      "definition" : "Horticulturalist"
    },
    {
      "code" : "6113.023",
      "display" : "Horticulture Worker",
      "definition" : "Horticulture Worker"
    },
    {
      "code" : "6113.024",
      "display" : "Horticulturist",
      "definition" : "Horticulturist"
    },
    {
      "code" : "6113.025",
      "display" : "Jobbing Gardener",
      "definition" : "Jobbing Gardener"
    },
    {
      "code" : "6113.026",
      "display" : "Kaimahi Kaari",
      "definition" : "Kaimahi Kaari"
    },
    {
      "code" : "6113.027",
      "display" : "Kaimahi Kari",
      "definition" : "Kaimahi Kari"
    },
    {
      "code" : "6113.028",
      "display" : "Kaimahi Whenua",
      "definition" : "Kaimahi Whenua"
    },
    {
      "code" : "6113.029",
      "display" : "Kaitiaki Mahinga Kaari",
      "definition" : "Kaitiaki Mahinga Kaari"
    },
    {
      "code" : "6113.030",
      "display" : "Kaitiaki Mahinga Kari",
      "definition" : "Kaitiaki Mahinga Kari"
    },
    {
      "code" : "6113.031",
      "display" : "Landscape Contractor",
      "definition" : "Landscape Contractor"
    },
    {
      "code" : "6113.032",
      "display" : "Landscape Gardener",
      "definition" : "Landscape Gardener"
    },
    {
      "code" : "6113.033",
      "display" : "Landscaping Gardening Worker",
      "definition" : "Landscaping Gardening Worker"
    },
    {
      "code" : "6113.034",
      "display" : "Lawn Mowing Contractor",
      "definition" : "Lawn Mowing Contractor"
    },
    {
      "code" : "6113.035",
      "display" : "Lawnmowing Contractor",
      "definition" : "Lawnmowing Contractor"
    },
    {
      "code" : "6113.036",
      "display" : "Medicinal Plant Grower",
      "definition" : "Medicinal Plant Grower"
    },
    {
      "code" : "6113.037",
      "display" : "Nursery Assistant",
      "definition" : "Nursery Assistant"
    },
    {
      "code" : "6113.038",
      "display" : "Nursery Farmer",
      "definition" : "Nursery Farmer"
    },
    {
      "code" : "6113.039",
      "display" : "Nursery Grower",
      "definition" : "Nursery Grower"
    },
    {
      "code" : "6113.040",
      "display" : "Nursery Labourer",
      "definition" : "Nursery Labourer"
    },
    {
      "code" : "6113.041",
      "display" : "Nursery Manager",
      "definition" : "Nursery Manager"
    },
    {
      "code" : "6113.042",
      "display" : "Nursery Worker",
      "definition" : "Nursery Worker"
    },
    {
      "code" : "6113.043",
      "display" : "Nurseryman",
      "definition" : "Nurseryman"
    },
    {
      "code" : "6113.044",
      "display" : "Orchid Grower",
      "definition" : "Orchid Grower"
    },
    {
      "code" : "6113.045",
      "display" : "Quality Controller Of Gardeners",
      "definition" : "Quality Controller Of Gardeners"
    },
    {
      "code" : "6113.046",
      "display" : "Quality Controller Of Grounds Or Green Keeper",
      "definition" : "Quality Controller Of Grounds Or Green Keeper"
    },
    {
      "code" : "6113.047",
      "display" : "Quality Controller Of Landscape Gardeners",
      "definition" : "Quality Controller Of Landscape Gardeners"
    },
    {
      "code" : "6113.048",
      "display" : "Racecourse Groundsperson",
      "definition" : "Racecourse Groundsperson"
    },
    {
      "code" : "6113.049",
      "display" : "Racecourse Maintenance Worker",
      "definition" : "Racecourse Maintenance Worker"
    },
    {
      "code" : "6113.050",
      "display" : "School Groundsperson",
      "definition" : "School Groundsperson"
    },
    {
      "code" : "6113.051",
      "display" : "Seed Grower",
      "definition" : "Seed Grower"
    },
    {
      "code" : "6113.052",
      "display" : "Tree Doctor",
      "definition" : "Tree Doctor"
    },
    {
      "code" : "6113.053",
      "display" : "Tree Surgeon",
      "definition" : "Tree Surgeon"
    },
    {
      "code" : "6113.054",
      "display" : "Tropical Plant Grower",
      "definition" : "Tropical Plant Grower"
    },
    {
      "code" : "6113.055",
      "display" : "Turf Layer",
      "definition" : "Turf Layer"
    },
    {
      "code" : "6121.001",
      "display" : "Beef Farm Worker",
      "definition" : "Beef Farm Worker"
    },
    {
      "code" : "6121.002",
      "display" : "Beef Farmer",
      "definition" : "Beef Farmer"
    },
    {
      "code" : "6121.003",
      "display" : "Bull Farmer",
      "definition" : "Bull Farmer"
    },
    {
      "code" : "6121.004",
      "display" : "Cat Breeder",
      "definition" : "Cat Breeder"
    },
    {
      "code" : "6121.005",
      "display" : "Cattle Breeder",
      "definition" : "Cattle Breeder"
    },
    {
      "code" : "6121.006",
      "display" : "Cattle Farm Manager",
      "definition" : "Cattle Farm Manager"
    },
    {
      "code" : "6121.007",
      "display" : "Cattle Farm Supervisor",
      "definition" : "Cattle Farm Supervisor"
    },
    {
      "code" : "6121.008",
      "display" : "Cattle Farm Worker",
      "definition" : "Cattle Farm Worker"
    },
    {
      "code" : "6121.009",
      "display" : "Cattle Farmer",
      "definition" : "Cattle Farmer"
    },
    {
      "code" : "6121.010",
      "display" : "Cattle Station Worker",
      "definition" : "Cattle Station Worker"
    },
    {
      "code" : "6121.011",
      "display" : "Cattle Stud Farmer",
      "definition" : "Cattle Stud Farmer"
    },
    {
      "code" : "6121.012",
      "display" : "Dairy Farm Cadet",
      "definition" : "Dairy Farm Cadet"
    },
    {
      "code" : "6121.013",
      "display" : "Dairy Farm Hand",
      "definition" : "Dairy Farm Hand"
    },
    {
      "code" : "6121.014",
      "display" : "Dairy Farm Manager",
      "definition" : "Dairy Farm Manager"
    },
    {
      "code" : "6121.015",
      "display" : "Dairy Farm Supervisor",
      "definition" : "Dairy Farm Supervisor"
    },
    {
      "code" : "6121.016",
      "display" : "Dairy Farm Worker",
      "definition" : "Dairy Farm Worker"
    },
    {
      "code" : "6121.017",
      "display" : "Dairy Farmer",
      "definition" : "Dairy Farmer"
    },
    {
      "code" : "6121.018",
      "display" : "Dairy Stud Farmer",
      "definition" : "Dairy Stud Farmer"
    },
    {
      "code" : "6121.019",
      "display" : "Deer Farm Manager",
      "definition" : "Deer Farm Manager"
    },
    {
      "code" : "6121.020",
      "display" : "Deer Farm Supervisor",
      "definition" : "Deer Farm Supervisor"
    },
    {
      "code" : "6121.021",
      "display" : "Deer Farm Worker",
      "definition" : "Deer Farm Worker"
    },
    {
      "code" : "6121.022",
      "display" : "Deer Farmer",
      "definition" : "Deer Farmer"
    },
    {
      "code" : "6121.023",
      "display" : "Deer Stud Farmer",
      "definition" : "Deer Stud Farmer"
    },
    {
      "code" : "6121.024",
      "display" : "Dog Breeder",
      "definition" : "Dog Breeder"
    },
    {
      "code" : "6121.025",
      "display" : "Fitch Farmer",
      "definition" : "Fitch Farmer"
    },
    {
      "code" : "6121.026",
      "display" : "Goat Breeder",
      "definition" : "Goat Breeder"
    },
    {
      "code" : "6121.027",
      "display" : "Goat Farm Manager",
      "definition" : "Goat Farm Manager"
    },
    {
      "code" : "6121.028",
      "display" : "Goat Farm Supervisor",
      "definition" : "Goat Farm Supervisor"
    },
    {
      "code" : "6121.029",
      "display" : "Goat Farm Worker",
      "definition" : "Goat Farm Worker"
    },
    {
      "code" : "6121.030",
      "display" : "Goat Farmer",
      "definition" : "Goat Farmer"
    },
    {
      "code" : "6121.031",
      "display" : "Goat Stud Farmer",
      "definition" : "Goat Stud Farmer"
    },
    {
      "code" : "6121.032",
      "display" : "Grazier",
      "definition" : "Grazier"
    },
    {
      "code" : "6121.033",
      "display" : "Horse Breeder",
      "definition" : "Horse Breeder"
    },
    {
      "code" : "6121.034",
      "display" : "Horse Breeder Worker",
      "definition" : "Horse Breeder Worker"
    },
    {
      "code" : "6121.035",
      "display" : "Horse Stud Farmer",
      "definition" : "Horse Stud Farmer"
    },
    {
      "code" : "6121.036",
      "display" : "Kaimiraka Kau",
      "definition" : "Kaimiraka Kau"
    },
    {
      "code" : "6121.037",
      "display" : "Kaipaamu Hipi",
      "definition" : "Kaipaamu Hipi"
    },
    {
      "code" : "6121.038",
      "display" : "Kaipamu Hipi",
      "definition" : "Kaipamu Hipi"
    },
    {
      "code" : "6121.039",
      "display" : "Kaitiaki Paamu Hipi",
      "definition" : "Kaitiaki Paamu Hipi"
    },
    {
      "code" : "6121.040",
      "display" : "Kaitiaki Pamu Hipi",
      "definition" : "Kaitiaki Pamu Hipi"
    },
    {
      "code" : "6121.041",
      "display" : "Kaiwhakahaere Paamu Hipi",
      "definition" : "Kaiwhakahaere Paamu Hipi"
    },
    {
      "code" : "6121.042",
      "display" : "Kaiwhakahaere Pamu Hipi",
      "definition" : "Kaiwhakahaere Pamu Hipi"
    },
    {
      "code" : "6121.043",
      "display" : "Livestock Farmer",
      "definition" : "Livestock Farmer"
    },
    {
      "code" : "6121.044",
      "display" : "Llama Farmer",
      "definition" : "Llama Farmer"
    },
    {
      "code" : "6121.045",
      "display" : "Milking Equipment Operator",
      "definition" : "Milking Equipment Operator"
    },
    {
      "code" : "6121.046",
      "display" : "Ostrich Farmer",
      "definition" : "Ostrich Farmer"
    },
    {
      "code" : "6121.047",
      "display" : "Other Livestock Farm Manager",
      "definition" : "Other Livestock Farm Manager"
    },
    {
      "code" : "6121.048",
      "display" : "Other Livestock Farm Supervisor",
      "definition" : "Other Livestock Farm Supervisor"
    },
    {
      "code" : "6121.049",
      "display" : "Other Livestock Farm Worker",
      "definition" : "Other Livestock Farm Worker"
    },
    {
      "code" : "6121.050",
      "display" : "Other Livestock Farmer",
      "definition" : "Other Livestock Farmer"
    },
    {
      "code" : "6121.051",
      "display" : "Pig Farm Manager",
      "definition" : "Pig Farm Manager"
    },
    {
      "code" : "6121.052",
      "display" : "Pig Farm Supervisor",
      "definition" : "Pig Farm Supervisor"
    },
    {
      "code" : "6121.053",
      "display" : "Pig Farm Worker",
      "definition" : "Pig Farm Worker"
    },
    {
      "code" : "6121.054",
      "display" : "Pig Farmer",
      "definition" : "Pig Farmer"
    },
    {
      "code" : "6121.055",
      "display" : "Pig Stud Farmer",
      "definition" : "Pig Stud Farmer"
    },
    {
      "code" : "6121.056",
      "display" : "Possum Farmer",
      "definition" : "Possum Farmer"
    },
    {
      "code" : "6121.057",
      "display" : "Rabbit Farmer",
      "definition" : "Rabbit Farmer"
    },
    {
      "code" : "6121.058",
      "display" : "Racehorse Stud Worker",
      "definition" : "Racehorse Stud Worker"
    },
    {
      "code" : "6121.059",
      "display" : "Share Milker",
      "definition" : "Share Milker"
    },
    {
      "code" : "6121.060",
      "display" : "Sharemilker",
      "definition" : "Sharemilker"
    },
    {
      "code" : "6121.061",
      "display" : "Sheep Dipping Contractor",
      "definition" : "Sheep Dipping Contractor"
    },
    {
      "code" : "6121.062",
      "display" : "Sheep Farm Cadet",
      "definition" : "Sheep Farm Cadet"
    },
    {
      "code" : "6121.063",
      "display" : "Sheep Farm Hand",
      "definition" : "Sheep Farm Hand"
    },
    {
      "code" : "6121.064",
      "display" : "Sheep Farm Manager",
      "definition" : "Sheep Farm Manager"
    },
    {
      "code" : "6121.065",
      "display" : "Sheep Farm Supervisor",
      "definition" : "Sheep Farm Supervisor"
    },
    {
      "code" : "6121.066",
      "display" : "Sheep Farm Worker",
      "definition" : "Sheep Farm Worker"
    },
    {
      "code" : "6121.067",
      "display" : "Sheep Farmer",
      "definition" : "Sheep Farmer"
    },
    {
      "code" : "6121.068",
      "display" : "Sheep Runholder",
      "definition" : "Sheep Runholder"
    },
    {
      "code" : "6121.069",
      "display" : "Sheep Station Hand",
      "definition" : "Sheep Station Hand"
    },
    {
      "code" : "6121.070",
      "display" : "Sheep Station Manager",
      "definition" : "Sheep Station Manager"
    },
    {
      "code" : "6121.071",
      "display" : "Sheep Station Owner",
      "definition" : "Sheep Station Owner"
    },
    {
      "code" : "6121.072",
      "display" : "Sheep Station Supervisor",
      "definition" : "Sheep Station Supervisor"
    },
    {
      "code" : "6121.073",
      "display" : "Sheep Stud Farmer",
      "definition" : "Sheep Stud Farmer"
    },
    {
      "code" : "6121.074",
      "display" : "Stud Groom",
      "definition" : "Stud Groom"
    },
    {
      "code" : "6121.075",
      "display" : "Stud Racehorse Breeder",
      "definition" : "Stud Racehorse Breeder"
    },
    {
      "code" : "6121.076",
      "display" : "Stud Racehorse Farm Manager",
      "definition" : "Stud Racehorse Farm Manager"
    },
    {
      "code" : "6121.077",
      "display" : "Stud Racehorse Farm Supervisor",
      "definition" : "Stud Racehorse Farm Supervisor"
    },
    {
      "code" : "6121.078",
      "display" : "Town Milk Supplier",
      "definition" : "Town Milk Supplier"
    },
    {
      "code" : "6121.079",
      "display" : "Water Buffalo Farmer",
      "definition" : "Water Buffalo Farmer"
    },
    {
      "code" : "6121.080",
      "display" : "Yak Farmer",
      "definition" : "Yak Farmer"
    },
    {
      "code" : "6122.001",
      "display" : "Mixed Livestock Farm Manager",
      "definition" : "Mixed Livestock Farm Manager"
    },
    {
      "code" : "6122.002",
      "display" : "Mixed Livestock Farm Supervisor",
      "definition" : "Mixed Livestock Farm Supervisor"
    },
    {
      "code" : "6122.003",
      "display" : "Mixed Livestock Farm Worker",
      "definition" : "Mixed Livestock Farm Worker"
    },
    {
      "code" : "6122.004",
      "display" : "Mixed Livestock Farmer",
      "definition" : "Mixed Livestock Farmer"
    },
    {
      "code" : "6123.001",
      "display" : "Chicken Catcher",
      "definition" : "Chicken Catcher"
    },
    {
      "code" : "6123.002",
      "display" : "Chicken Farmer",
      "definition" : "Chicken Farmer"
    },
    {
      "code" : "6123.003",
      "display" : "Chicken Hatchery Assistant",
      "definition" : "Chicken Hatchery Assistant"
    },
    {
      "code" : "6123.004",
      "display" : "Chicken Poultry Farm Worker",
      "definition" : "Chicken Poultry Farm Worker"
    },
    {
      "code" : "6123.005",
      "display" : "Chicken Sexer",
      "definition" : "Chicken Sexer"
    },
    {
      "code" : "6123.006",
      "display" : "Duck Farmer",
      "definition" : "Duck Farmer"
    },
    {
      "code" : "6123.007",
      "display" : "Egg Collector",
      "definition" : "Egg Collector"
    },
    {
      "code" : "6123.008",
      "display" : "Egg Producer",
      "definition" : "Egg Producer"
    },
    {
      "code" : "6123.009",
      "display" : "Goose Farmer",
      "definition" : "Goose Farmer"
    },
    {
      "code" : "6123.010",
      "display" : "Pheasant Farmer",
      "definition" : "Pheasant Farmer"
    },
    {
      "code" : "6123.011",
      "display" : "Poultry Farm Hand",
      "definition" : "Poultry Farm Hand"
    },
    {
      "code" : "6123.012",
      "display" : "Poultry Farm Manager",
      "definition" : "Poultry Farm Manager"
    },
    {
      "code" : "6123.013",
      "display" : "Poultry Farm Supervisor",
      "definition" : "Poultry Farm Supervisor"
    },
    {
      "code" : "6123.014",
      "display" : "Poultry Farm Worker",
      "definition" : "Poultry Farm Worker"
    },
    {
      "code" : "6123.015",
      "display" : "Poultry Farmer",
      "definition" : "Poultry Farmer"
    },
    {
      "code" : "6123.016",
      "display" : "Poultry Hatcher Breeder",
      "definition" : "Poultry Hatcher Breeder"
    },
    {
      "code" : "6123.017",
      "display" : "Poultry Hatchery Manager",
      "definition" : "Poultry Hatchery Manager"
    },
    {
      "code" : "6123.018",
      "display" : "Poultry Hatchery Supervisor",
      "definition" : "Poultry Hatchery Supervisor"
    },
    {
      "code" : "6123.019",
      "display" : "Poultry Hatchery Worker",
      "definition" : "Poultry Hatchery Worker"
    },
    {
      "code" : "6123.020",
      "display" : "Poultry Worker Factory",
      "definition" : "Poultry Worker Factory"
    },
    {
      "code" : "6123.021",
      "display" : "Turkey Farmer",
      "definition" : "Turkey Farmer"
    },
    {
      "code" : "6124.001",
      "display" : "Apiarist",
      "definition" : "Apiarist"
    },
    {
      "code" : "6124.002",
      "display" : "Apiarist and Apiary Worker",
      "definition" : "Apiarist and Apiary Worker"
    },
    {
      "code" : "6124.003",
      "display" : "Apiary Cadet",
      "definition" : "Apiary Cadet"
    },
    {
      "code" : "6124.004",
      "display" : "Apiary Manager",
      "definition" : "Apiary Manager"
    },
    {
      "code" : "6124.005",
      "display" : "Apiary Supervisor",
      "definition" : "Apiary Supervisor"
    },
    {
      "code" : "6124.006",
      "display" : "Apiary Worker",
      "definition" : "Apiary Worker"
    },
    {
      "code" : "6124.007",
      "display" : "Bee Keeper",
      "definition" : "Bee Keeper"
    },
    {
      "code" : "6124.008",
      "display" : "Beekeeper",
      "definition" : "Beekeeper"
    },
    {
      "code" : "6124.009",
      "display" : "Beekeeping Worker",
      "definition" : "Beekeeping Worker"
    },
    {
      "code" : "6124.010",
      "display" : "Honey Grader",
      "definition" : "Honey Grader"
    },
    {
      "code" : "6124.011",
      "display" : "Worker Bee Farm",
      "definition" : "Worker Bee Farm"
    },
    {
      "code" : "6125.001",
      "display" : "Agricultural Worker",
      "definition" : "Agricultural Worker"
    },
    {
      "code" : "6125.002",
      "display" : "Animal Attendant Farm",
      "definition" : "Animal Attendant Farm"
    },
    {
      "code" : "6125.003",
      "display" : "Bush Clearer Scrub Cutter",
      "definition" : "Bush Clearer Scrub Cutter"
    },
    {
      "code" : "6125.004",
      "display" : "Crop and Livestock Farm Manager",
      "definition" : "Crop and Livestock Farm Manager"
    },
    {
      "code" : "6125.005",
      "display" : "Crop and Livestock Farm Supervisor",
      "definition" : "Crop and Livestock Farm Supervisor"
    },
    {
      "code" : "6125.006",
      "display" : "Crop and Livestock Farmer",
      "definition" : "Crop and Livestock Farmer"
    },
    {
      "code" : "6125.007",
      "display" : "Crop and Livestock Worker",
      "definition" : "Crop and Livestock Worker"
    },
    {
      "code" : "6125.008",
      "display" : "Crop Hand",
      "definition" : "Crop Hand"
    },
    {
      "code" : "6125.009",
      "display" : "Farm Assistant",
      "definition" : "Farm Assistant"
    },
    {
      "code" : "6125.010",
      "display" : "Farm Hand",
      "definition" : "Farm Hand"
    },
    {
      "code" : "6125.011",
      "display" : "Farm Labourer",
      "definition" : "Farm Labourer"
    },
    {
      "code" : "6125.012",
      "display" : "Farm Worker",
      "definition" : "Farm Worker"
    },
    {
      "code" : "6125.013",
      "display" : "Farmer (nod)",
      "definition" : "Farmer (nod)"
    },
    {
      "code" : "6125.014",
      "display" : "General Farm Manager",
      "definition" : "General Farm Manager"
    },
    {
      "code" : "6125.015",
      "display" : "General Farm Supervisor",
      "definition" : "General Farm Supervisor"
    },
    {
      "code" : "6125.016",
      "display" : "General Farmer",
      "definition" : "General Farmer"
    },
    {
      "code" : "6125.017",
      "display" : "Grubber and Clearer Land",
      "definition" : "Grubber and Clearer Land"
    },
    {
      "code" : "6125.018",
      "display" : "Haymaker",
      "definition" : "Haymaker"
    },
    {
      "code" : "6125.019",
      "display" : "Kaiahuwhenua",
      "definition" : "Kaiahuwhenua"
    },
    {
      "code" : "6125.020",
      "display" : "Kaiawhina Ahuwhenua",
      "definition" : "Kaiawhina Ahuwhenua"
    },
    {
      "code" : "6125.021",
      "display" : "Kaiawhina Mahi Paamu",
      "definition" : "Kaiawhina Mahi Paamu"
    },
    {
      "code" : "6125.022",
      "display" : "Kaiawhina Mahi Pamu",
      "definition" : "Kaiawhina Mahi Pamu"
    },
    {
      "code" : "6125.023",
      "display" : "Kaiawhina Paamu",
      "definition" : "Kaiawhina Paamu"
    },
    {
      "code" : "6125.024",
      "display" : "Kaiawhina Pamu",
      "definition" : "Kaiawhina Pamu"
    },
    {
      "code" : "6125.025",
      "display" : "Kaimahi Ahuwhenua",
      "definition" : "Kaimahi Ahuwhenua"
    },
    {
      "code" : "6125.026",
      "display" : "Kaimahi Paamu",
      "definition" : "Kaimahi Paamu"
    },
    {
      "code" : "6125.027",
      "display" : "Kaimahi Pamu",
      "definition" : "Kaimahi Pamu"
    },
    {
      "code" : "6125.028",
      "display" : "Kaipaamu",
      "definition" : "Kaipaamu"
    },
    {
      "code" : "6125.029",
      "display" : "Kaipamu",
      "definition" : "Kaipamu"
    },
    {
      "code" : "6125.030",
      "display" : "Kaitautoko Mahi Paamu",
      "definition" : "Kaitautoko Mahi Paamu"
    },
    {
      "code" : "6125.031",
      "display" : "Kaitautoko Mahi Pamu",
      "definition" : "Kaitautoko Mahi Pamu"
    },
    {
      "code" : "6125.032",
      "display" : "Landgirl",
      "definition" : "Landgirl"
    },
    {
      "code" : "6125.033",
      "display" : "Mixed Farm Manager",
      "definition" : "Mixed Farm Manager"
    },
    {
      "code" : "6125.034",
      "display" : "Mixed Farm Supervisor",
      "definition" : "Mixed Farm Supervisor"
    },
    {
      "code" : "6125.035",
      "display" : "Mixed Farmer",
      "definition" : "Mixed Farmer"
    },
    {
      "code" : "6125.036",
      "display" : "Station Hand",
      "definition" : "Station Hand"
    },
    {
      "code" : "6125.037",
      "display" : "Tussock Worker",
      "definition" : "Tussock Worker"
    },
    {
      "code" : "6125.038",
      "display" : "Willow Cutter",
      "definition" : "Willow Cutter"
    },
    {
      "code" : "6126.001",
      "display" : "Cattle Drover",
      "definition" : "Cattle Drover"
    },
    {
      "code" : "6126.002",
      "display" : "Dairy Herd Milk Tester",
      "definition" : "Dairy Herd Milk Tester"
    },
    {
      "code" : "6126.003",
      "display" : "Drover",
      "definition" : "Drover"
    },
    {
      "code" : "6126.004",
      "display" : "Farm Stablehand",
      "definition" : "Farm Stablehand"
    },
    {
      "code" : "6126.005",
      "display" : "Fleece Classer",
      "definition" : "Fleece Classer"
    },
    {
      "code" : "6126.006",
      "display" : "Groom Stable Hand",
      "definition" : "Groom Stable Hand"
    },
    {
      "code" : "6126.007",
      "display" : "Head Shepherd",
      "definition" : "Head Shepherd"
    },
    {
      "code" : "6126.008",
      "display" : "Herdsman",
      "definition" : "Herdsman"
    },
    {
      "code" : "6126.009",
      "display" : "Horse Box Attendant",
      "definition" : "Horse Box Attendant"
    },
    {
      "code" : "6126.010",
      "display" : "Horse Breaker",
      "definition" : "Horse Breaker"
    },
    {
      "code" : "6126.011",
      "display" : "Horse Trainer",
      "definition" : "Horse Trainer"
    },
    {
      "code" : "6126.012",
      "display" : "Horse Trainer Cadet",
      "definition" : "Horse Trainer Cadet"
    },
    {
      "code" : "6126.013",
      "display" : "Kaikuti Hipi",
      "definition" : "Kaikuti Hipi"
    },
    {
      "code" : "6126.014",
      "display" : "Kaipoipoi Huruhuru Hipi",
      "definition" : "Kaipoipoi Huruhuru Hipi"
    },
    {
      "code" : "6126.015",
      "display" : "Kaipoipoi Wuru",
      "definition" : "Kaipoipoi Wuru"
    },
    {
      "code" : "6126.016",
      "display" : "Kaipoipoi Wuuru",
      "definition" : "Kaipoipoi Wuuru"
    },
    {
      "code" : "6126.017",
      "display" : "Milk Sample Collector",
      "definition" : "Milk Sample Collector"
    },
    {
      "code" : "6126.018",
      "display" : "Musterer",
      "definition" : "Musterer"
    },
    {
      "code" : "6126.019",
      "display" : "Quality Controller Of Horse Trainer Groom Or Stablehands",
      "definition" : "Quality Controller Of Horse Trainer Groom Or Stablehands"
    },
    {
      "code" : "6126.020",
      "display" : "Quality Controller Of Wool Classers",
      "definition" : "Quality Controller Of Wool Classers"
    },
    {
      "code" : "6126.021",
      "display" : "Race Horse Trainer",
      "definition" : "Race Horse Trainer"
    },
    {
      "code" : "6126.022",
      "display" : "Racing Dog Trainer",
      "definition" : "Racing Dog Trainer"
    },
    {
      "code" : "6126.023",
      "display" : "Sampling Officer",
      "definition" : "Sampling Officer"
    },
    {
      "code" : "6126.024",
      "display" : "Shearer",
      "definition" : "Shearer"
    },
    {
      "code" : "6126.025",
      "display" : "Shearing Contractor",
      "definition" : "Shearing Contractor"
    },
    {
      "code" : "6126.026",
      "display" : "Shearing Shed Hand",
      "definition" : "Shearing Shed Hand"
    },
    {
      "code" : "6126.027",
      "display" : "Shearing Shed Overseer",
      "definition" : "Shearing Shed Overseer"
    },
    {
      "code" : "6126.028",
      "display" : "Shearing Shed Wool Presser",
      "definition" : "Shearing Shed Wool Presser"
    },
    {
      "code" : "6126.029",
      "display" : "Shearing Shed Worker",
      "definition" : "Shearing Shed Worker"
    },
    {
      "code" : "6126.030",
      "display" : "Sheep Shearer",
      "definition" : "Sheep Shearer"
    },
    {
      "code" : "6126.031",
      "display" : "Shepherd",
      "definition" : "Shepherd"
    },
    {
      "code" : "6126.032",
      "display" : "Stable Hand",
      "definition" : "Stable Hand"
    },
    {
      "code" : "6126.033",
      "display" : "Stablehand",
      "definition" : "Stablehand"
    },
    {
      "code" : "6126.034",
      "display" : "Stock Drafter Farm",
      "definition" : "Stock Drafter Farm"
    },
    {
      "code" : "6126.035",
      "display" : "Stockman",
      "definition" : "Stockman"
    },
    {
      "code" : "6126.036",
      "display" : "Strapper",
      "definition" : "Strapper"
    },
    {
      "code" : "6126.037",
      "display" : "Wool Baler",
      "definition" : "Wool Baler"
    },
    {
      "code" : "6126.038",
      "display" : "Wool Classer",
      "definition" : "Wool Classer"
    },
    {
      "code" : "6126.039",
      "display" : "Wool Classer Grader",
      "definition" : "Wool Classer Grader"
    },
    {
      "code" : "6126.040",
      "display" : "Wool Classer Shearing Shed",
      "definition" : "Wool Classer Shearing Shed"
    },
    {
      "code" : "6126.041",
      "display" : "Wool Grader Shearing Shed",
      "definition" : "Wool Grader Shearing Shed"
    },
    {
      "code" : "6126.042",
      "display" : "Wool Hand",
      "definition" : "Wool Hand"
    },
    {
      "code" : "6126.043",
      "display" : "Wool Handler",
      "definition" : "Wool Handler"
    },
    {
      "code" : "6126.044",
      "display" : "Wool Labourer",
      "definition" : "Wool Labourer"
    },
    {
      "code" : "6126.045",
      "display" : "Wool Sorter",
      "definition" : "Wool Sorter"
    },
    {
      "code" : "6126.046",
      "display" : "Woolclasser",
      "definition" : "Woolclasser"
    },
    {
      "code" : "6131.001",
      "display" : "Axeman Forest",
      "definition" : "Axeman Forest"
    },
    {
      "code" : "6131.002",
      "display" : "Bush Clearer Cutter",
      "definition" : "Bush Clearer Cutter"
    },
    {
      "code" : "6131.003",
      "display" : "Bush Clearing Contractor",
      "definition" : "Bush Clearing Contractor"
    },
    {
      "code" : "6131.004",
      "display" : "Bush Clearing Scrub Cutter Forest",
      "definition" : "Bush Clearing Scrub Cutter Forest"
    },
    {
      "code" : "6131.005",
      "display" : "Bush Man",
      "definition" : "Bush Man"
    },
    {
      "code" : "6131.006",
      "display" : "Bush Worker",
      "definition" : "Bush Worker"
    },
    {
      "code" : "6131.007",
      "display" : "Bushman",
      "definition" : "Bushman"
    },
    {
      "code" : "6131.008",
      "display" : "Cross Cut Sawyer Forest",
      "definition" : "Cross Cut Sawyer Forest"
    },
    {
      "code" : "6131.009",
      "display" : "Feller and Crosscutter Forestry",
      "definition" : "Feller and Crosscutter Forestry"
    },
    {
      "code" : "6131.010",
      "display" : "Firewood Cutter",
      "definition" : "Firewood Cutter"
    },
    {
      "code" : "6131.011",
      "display" : "Forest Foreman Overseer Logging",
      "definition" : "Forest Foreman Overseer Logging"
    },
    {
      "code" : "6131.012",
      "display" : "Forest Hand",
      "definition" : "Forest Hand"
    },
    {
      "code" : "6131.013",
      "display" : "Forest Labourer",
      "definition" : "Forest Labourer"
    },
    {
      "code" : "6131.014",
      "display" : "Forest Supervisor",
      "definition" : "Forest Supervisor"
    },
    {
      "code" : "6131.015",
      "display" : "Forestry Contractor",
      "definition" : "Forestry Contractor"
    },
    {
      "code" : "6131.016",
      "display" : "Forestry Field Assistant",
      "definition" : "Forestry Field Assistant"
    },
    {
      "code" : "6131.017",
      "display" : "Forestry Foreman Overseer",
      "definition" : "Forestry Foreman Overseer"
    },
    {
      "code" : "6131.018",
      "display" : "Forestry Gang Supervisor",
      "definition" : "Forestry Gang Supervisor"
    },
    {
      "code" : "6131.019",
      "display" : "Forestry Labourer",
      "definition" : "Forestry Labourer"
    },
    {
      "code" : "6131.020",
      "display" : "Forestry Protection Officer",
      "definition" : "Forestry Protection Officer"
    },
    {
      "code" : "6131.021",
      "display" : "Forestry Worker",
      "definition" : "Forestry Worker"
    },
    {
      "code" : "6131.022",
      "display" : "Hauling Engine Contractor Logging",
      "definition" : "Hauling Engine Contractor Logging"
    },
    {
      "code" : "6131.023",
      "display" : "Hauling Engine Driver Logging",
      "definition" : "Hauling Engine Driver Logging"
    },
    {
      "code" : "6131.024",
      "display" : "Kaiawhina Mahi Whakato Tiaki Rakau Ngahere",
      "definition" : "Kaiawhina Mahi Whakato Tiaki Rakau Ngahere"
    },
    {
      "code" : "6131.025",
      "display" : "Kaiawhina Mahi Whakatoo Tiaki Raakau Ngahere",
      "definition" : "Kaiawhina Mahi Whakatoo Tiaki Raakau Ngahere"
    },
    {
      "code" : "6131.026",
      "display" : "Kaimahi Ngahere",
      "definition" : "Kaimahi Ngahere"
    },
    {
      "code" : "6131.027",
      "display" : "Kaimahi Puihi",
      "definition" : "Kaimahi Puihi"
    },
    {
      "code" : "6131.028",
      "display" : "Leading Bushman Logging",
      "definition" : "Leading Bushman Logging"
    },
    {
      "code" : "6131.029",
      "display" : "Leading Forest Hand",
      "definition" : "Leading Forest Hand"
    },
    {
      "code" : "6131.030",
      "display" : "Leading Hand Logging",
      "definition" : "Leading Hand Logging"
    },
    {
      "code" : "6131.031",
      "display" : "Log Assessor",
      "definition" : "Log Assessor"
    },
    {
      "code" : "6131.032",
      "display" : "Log Hauler Bush",
      "definition" : "Log Hauler Bush"
    },
    {
      "code" : "6131.033",
      "display" : "Log Raft Maker",
      "definition" : "Log Raft Maker"
    },
    {
      "code" : "6131.034",
      "display" : "Logger",
      "definition" : "Logger"
    },
    {
      "code" : "6131.035",
      "display" : "Logging Contractor",
      "definition" : "Logging Contractor"
    },
    {
      "code" : "6131.036",
      "display" : "Logging Operator",
      "definition" : "Logging Operator"
    },
    {
      "code" : "6131.037",
      "display" : "Logging Pruner Tree",
      "definition" : "Logging Pruner Tree"
    },
    {
      "code" : "6131.038",
      "display" : "Logging Supervisor",
      "definition" : "Logging Supervisor"
    },
    {
      "code" : "6131.039",
      "display" : "Logging Topper",
      "definition" : "Logging Topper"
    },
    {
      "code" : "6131.040",
      "display" : "Lumberjack",
      "definition" : "Lumberjack"
    },
    {
      "code" : "6131.041",
      "display" : "Moss Gatherer",
      "definition" : "Moss Gatherer"
    },
    {
      "code" : "6131.042",
      "display" : "Plantation Worker Forestry",
      "definition" : "Plantation Worker Forestry"
    },
    {
      "code" : "6131.043",
      "display" : "Planter Trees Forestry",
      "definition" : "Planter Trees Forestry"
    },
    {
      "code" : "6131.044",
      "display" : "Prop Cutter",
      "definition" : "Prop Cutter"
    },
    {
      "code" : "6131.045",
      "display" : "Pruner Forest",
      "definition" : "Pruner Forest"
    },
    {
      "code" : "6131.046",
      "display" : "Quality Controller Of Forestry Contractors",
      "definition" : "Quality Controller Of Forestry Contractors"
    },
    {
      "code" : "6131.047",
      "display" : "Quality Controller Of Loggers",
      "definition" : "Quality Controller Of Loggers"
    },
    {
      "code" : "6131.048",
      "display" : "Scrub Cutter",
      "definition" : "Scrub Cutter"
    },
    {
      "code" : "6131.049",
      "display" : "Scrub Cutting Contractor",
      "definition" : "Scrub Cutting Contractor"
    },
    {
      "code" : "6131.050",
      "display" : "Skiddy Forest",
      "definition" : "Skiddy Forest"
    },
    {
      "code" : "6131.051",
      "display" : "Sniper Forest",
      "definition" : "Sniper Forest"
    },
    {
      "code" : "6131.052",
      "display" : "Spaghnum Moss Gatherer",
      "definition" : "Spaghnum Moss Gatherer"
    },
    {
      "code" : "6131.053",
      "display" : "Timber Getter",
      "definition" : "Timber Getter"
    },
    {
      "code" : "6131.054",
      "display" : "Tree Feller",
      "definition" : "Tree Feller"
    },
    {
      "code" : "6131.055",
      "display" : "Tree Planter",
      "definition" : "Tree Planter"
    },
    {
      "code" : "6131.056",
      "display" : "Tree Topper",
      "definition" : "Tree Topper"
    },
    {
      "code" : "6131.057",
      "display" : "Waoko",
      "definition" : "Waoko"
    },
    {
      "code" : "6131.058",
      "display" : "Woodsman Foreman",
      "definition" : "Woodsman Foreman"
    },
    {
      "code" : "6141.001",
      "display" : "Crayfisher",
      "definition" : "Crayfisher"
    },
    {
      "code" : "6141.002",
      "display" : "Deep Sea Fishing Boat Skipper",
      "definition" : "Deep Sea Fishing Boat Skipper"
    },
    {
      "code" : "6141.003",
      "display" : "Diver Fishing",
      "definition" : "Diver Fishing"
    },
    {
      "code" : "6141.004",
      "display" : "Fish Baiter",
      "definition" : "Fish Baiter"
    },
    {
      "code" : "6141.005",
      "display" : "Fisherman",
      "definition" : "Fisherman"
    },
    {
      "code" : "6141.006",
      "display" : "Fisherperson",
      "definition" : "Fisherperson"
    },
    {
      "code" : "6141.007",
      "display" : "Fishing Boat Captain",
      "definition" : "Fishing Boat Captain"
    },
    {
      "code" : "6141.008",
      "display" : "Fishing Boat Skipper",
      "definition" : "Fishing Boat Skipper"
    },
    {
      "code" : "6141.009",
      "display" : "Fishing Launch Proprietor",
      "definition" : "Fishing Launch Proprietor"
    },
    {
      "code" : "6141.010",
      "display" : "Fishing Skipper",
      "definition" : "Fishing Skipper"
    },
    {
      "code" : "6141.011",
      "display" : "Kaihi Ika",
      "definition" : "Kaihi Ika"
    },
    {
      "code" : "6141.012",
      "display" : "Kaihii Ika",
      "definition" : "Kaihii Ika"
    },
    {
      "code" : "6141.013",
      "display" : "Kaihopu Ika",
      "definition" : "Kaihopu Ika"
    },
    {
      "code" : "6141.014",
      "display" : "Oyster Fisher",
      "definition" : "Oyster Fisher"
    },
    {
      "code" : "6141.015",
      "display" : "Paua Gatherer",
      "definition" : "Paua Gatherer"
    },
    {
      "code" : "6141.016",
      "display" : "Paua Gatherer Diver",
      "definition" : "Paua Gatherer Diver"
    },
    {
      "code" : "6141.017",
      "display" : "Rock Lobster Fisher",
      "definition" : "Rock Lobster Fisher"
    },
    {
      "code" : "6141.018",
      "display" : "Seaweed Gatherer",
      "definition" : "Seaweed Gatherer"
    },
    {
      "code" : "6141.019",
      "display" : "Shell Fish Gatherer",
      "definition" : "Shell Fish Gatherer"
    },
    {
      "code" : "6141.020",
      "display" : "Shell Fisher",
      "definition" : "Shell Fisher"
    },
    {
      "code" : "6141.021",
      "display" : "Shellfish Gatherer",
      "definition" : "Shellfish Gatherer"
    },
    {
      "code" : "6141.022",
      "display" : "Tangata Hi Ika",
      "definition" : "Tangata Hi Ika"
    },
    {
      "code" : "6141.023",
      "display" : "Tangata Hii Ika",
      "definition" : "Tangata Hii Ika"
    },
    {
      "code" : "6141.024",
      "display" : "Tangata Hopu Ika",
      "definition" : "Tangata Hopu Ika"
    },
    {
      "code" : "6141.025",
      "display" : "Trawler Hand",
      "definition" : "Trawler Hand"
    },
    {
      "code" : "6141.026",
      "display" : "Trawlerman",
      "definition" : "Trawlerman"
    },
    {
      "code" : "6141.027",
      "display" : "Whitebaiter",
      "definition" : "Whitebaiter"
    },
    {
      "code" : "6142.001",
      "display" : "Fish Farm Manager",
      "definition" : "Fish Farm Manager"
    },
    {
      "code" : "6142.002",
      "display" : "Fish Farm Worker",
      "definition" : "Fish Farm Worker"
    },
    {
      "code" : "6142.003",
      "display" : "Fish Farmer",
      "definition" : "Fish Farmer"
    },
    {
      "code" : "6142.004",
      "display" : "Fish Hatchery Manager",
      "definition" : "Fish Hatchery Manager"
    },
    {
      "code" : "6142.005",
      "display" : "Fish Hatchery Worker",
      "definition" : "Fish Hatchery Worker"
    },
    {
      "code" : "6142.006",
      "display" : "Marine Farm Supervisor",
      "definition" : "Marine Farm Supervisor"
    },
    {
      "code" : "6142.007",
      "display" : "Marine Farmer",
      "definition" : "Marine Farmer"
    },
    {
      "code" : "6142.008",
      "display" : "Mussel Farm Manager",
      "definition" : "Mussel Farm Manager"
    },
    {
      "code" : "6142.009",
      "display" : "Mussel Oyster Farm Worker",
      "definition" : "Mussel Oyster Farm Worker"
    },
    {
      "code" : "6142.010",
      "display" : "Mussel Oyster Farmer",
      "definition" : "Mussel Oyster Farmer"
    },
    {
      "code" : "6142.011",
      "display" : "Oyster Farm Manager",
      "definition" : "Oyster Farm Manager"
    },
    {
      "code" : "6142.012",
      "display" : "Quality Controller Of Mussel Oyster Farmer And Worker",
      "definition" : "Quality Controller Of Mussel Oyster Farmer And Worker"
    },
    {
      "code" : "6142.013",
      "display" : "Salmon Farm Manager",
      "definition" : "Salmon Farm Manager"
    },
    {
      "code" : "6142.014",
      "display" : "Salmon Farm Worker",
      "definition" : "Salmon Farm Worker"
    },
    {
      "code" : "6142.015",
      "display" : "Salmon Farmer",
      "definition" : "Salmon Farmer"
    },
    {
      "code" : "6142.016",
      "display" : "Shellfish Farm Manager",
      "definition" : "Shellfish Farm Manager"
    },
    {
      "code" : "6142.017",
      "display" : "Shellfish Farm Worker",
      "definition" : "Shellfish Farm Worker"
    },
    {
      "code" : "6142.018",
      "display" : "Shellfish Farmer",
      "definition" : "Shellfish Farmer"
    },
    {
      "code" : "6143.001",
      "display" : "Commercial Shooter",
      "definition" : "Commercial Shooter"
    },
    {
      "code" : "6143.002",
      "display" : "Deer Culler",
      "definition" : "Deer Culler"
    },
    {
      "code" : "6143.003",
      "display" : "Deer Hunter",
      "definition" : "Deer Hunter"
    },
    {
      "code" : "6143.004",
      "display" : "Deer Recoverer",
      "definition" : "Deer Recoverer"
    },
    {
      "code" : "6143.005",
      "display" : "Deer Shooter Commercial",
      "definition" : "Deer Shooter Commercial"
    },
    {
      "code" : "6143.006",
      "display" : "Hunter and Trapper",
      "definition" : "Hunter and Trapper"
    },
    {
      "code" : "6143.007",
      "display" : "Muttonbirder",
      "definition" : "Muttonbirder"
    },
    {
      "code" : "6143.008",
      "display" : "Pest Destruction Worker",
      "definition" : "Pest Destruction Worker"
    },
    {
      "code" : "6143.009",
      "display" : "Possum Trapper",
      "definition" : "Possum Trapper"
    },
    {
      "code" : "6143.010",
      "display" : "Rabbiter",
      "definition" : "Rabbiter"
    },
    {
      "code" : "6143.011",
      "display" : "Shooter",
      "definition" : "Shooter"
    },
    {
      "code" : "6143.012",
      "display" : "Trapper",
      "definition" : "Trapper"
    },
    {
      "code" : "6144.001",
      "display" : "Animal Assistant",
      "definition" : "Animal Assistant"
    },
    {
      "code" : "6144.002",
      "display" : "Animal Attendant",
      "definition" : "Animal Attendant"
    },
    {
      "code" : "6144.003",
      "display" : "Animal Control Officer",
      "definition" : "Animal Control Officer"
    },
    {
      "code" : "6144.004",
      "display" : "Animal Keeper",
      "definition" : "Animal Keeper"
    },
    {
      "code" : "6144.005",
      "display" : "Animal Welfare Worker",
      "definition" : "Animal Welfare Worker"
    },
    {
      "code" : "6144.006",
      "display" : "Aquarium Worker",
      "definition" : "Aquarium Worker"
    },
    {
      "code" : "6144.007",
      "display" : "Aviary Keeper",
      "definition" : "Aviary Keeper"
    },
    {
      "code" : "6144.008",
      "display" : "Boarding Kennel Attendant",
      "definition" : "Boarding Kennel Attendant"
    },
    {
      "code" : "6144.009",
      "display" : "Boarding Kennel Proprietor",
      "definition" : "Boarding Kennel Proprietor"
    },
    {
      "code" : "6144.010",
      "display" : "Cattery Attendant",
      "definition" : "Cattery Attendant"
    },
    {
      "code" : "6144.011",
      "display" : "Cattery Proprietor",
      "definition" : "Cattery Proprietor"
    },
    {
      "code" : "6144.012",
      "display" : "Dog Beautician Groomer",
      "definition" : "Dog Beautician Groomer"
    },
    {
      "code" : "6144.013",
      "display" : "Dog Control Officer",
      "definition" : "Dog Control Officer"
    },
    {
      "code" : "6144.014",
      "display" : "Dog Kennel Boarding Proprietor",
      "definition" : "Dog Kennel Boarding Proprietor"
    },
    {
      "code" : "6144.015",
      "display" : "Dog Ranger",
      "definition" : "Dog Ranger"
    },
    {
      "code" : "6144.016",
      "display" : "Game Warden",
      "definition" : "Game Warden"
    },
    {
      "code" : "6144.017",
      "display" : "Guide Dog Trainer",
      "definition" : "Guide Dog Trainer"
    },
    {
      "code" : "6144.018",
      "display" : "Humane Officer",
      "definition" : "Humane Officer"
    },
    {
      "code" : "6144.019",
      "display" : "Hydatids Officer",
      "definition" : "Hydatids Officer"
    },
    {
      "code" : "6144.020",
      "display" : "Kennels Assistant",
      "definition" : "Kennels Assistant"
    },
    {
      "code" : "6144.021",
      "display" : "Pet Groomer",
      "definition" : "Pet Groomer"
    },
    {
      "code" : "6144.022",
      "display" : "Pound Keeper",
      "definition" : "Pound Keeper"
    },
    {
      "code" : "6144.023",
      "display" : "SPCA Worker",
      "definition" : "SPCA Worker"
    },
    {
      "code" : "6144.024",
      "display" : "Zoo Attendant",
      "definition" : "Zoo Attendant"
    },
    {
      "code" : "6144.025",
      "display" : "Zoo Keeper",
      "definition" : "Zoo Keeper"
    },
    {
      "code" : "6144.026",
      "display" : "Zoo Worker",
      "definition" : "Zoo Worker"
    },
    {
      "code" : "7111.001",
      "display" : "Artificial Stone Setter",
      "definition" : "Artificial Stone Setter"
    },
    {
      "code" : "7111.002",
      "display" : "Block Layer",
      "definition" : "Block Layer"
    },
    {
      "code" : "7111.003",
      "display" : "Blocklayer",
      "definition" : "Blocklayer"
    },
    {
      "code" : "7111.004",
      "display" : "Brick Layer",
      "definition" : "Brick Layer"
    },
    {
      "code" : "7111.005",
      "display" : "Bricklayer",
      "definition" : "Bricklayer"
    },
    {
      "code" : "7111.006",
      "display" : "Bricklayer and/or Blocklayer",
      "definition" : "Bricklayer and/or Blocklayer"
    },
    {
      "code" : "7111.007",
      "display" : "Bricklaying Contractor",
      "definition" : "Bricklaying Contractor"
    },
    {
      "code" : "7111.008",
      "display" : "Bricklaying Pointer",
      "definition" : "Bricklaying Pointer"
    },
    {
      "code" : "7111.009",
      "display" : "Bricklaying Stopper",
      "definition" : "Bricklaying Stopper"
    },
    {
      "code" : "7111.010",
      "display" : "Cast Stone Products Maker",
      "definition" : "Cast Stone Products Maker"
    },
    {
      "code" : "7111.011",
      "display" : "Ceramic Tiler",
      "definition" : "Ceramic Tiler"
    },
    {
      "code" : "7111.012",
      "display" : "Chimney Repairman",
      "definition" : "Chimney Repairman"
    },
    {
      "code" : "7111.013",
      "display" : "Construction Setter",
      "definition" : "Construction Setter"
    },
    {
      "code" : "7111.014",
      "display" : "Construction Stonemason",
      "definition" : "Construction Stonemason"
    },
    {
      "code" : "7111.015",
      "display" : "Hand Carver Stone",
      "definition" : "Hand Carver Stone"
    },
    {
      "code" : "7111.016",
      "display" : "Headstone Maker",
      "definition" : "Headstone Maker"
    },
    {
      "code" : "7111.017",
      "display" : "Kiln Builder",
      "definition" : "Kiln Builder"
    },
    {
      "code" : "7111.018",
      "display" : "Marble Cutter",
      "definition" : "Marble Cutter"
    },
    {
      "code" : "7111.019",
      "display" : "Marble Mason",
      "definition" : "Marble Mason"
    },
    {
      "code" : "7111.020",
      "display" : "Marble Polisher",
      "definition" : "Marble Polisher"
    },
    {
      "code" : "7111.021",
      "display" : "Marble Processor",
      "definition" : "Marble Processor"
    },
    {
      "code" : "7111.022",
      "display" : "Marble Sawyer",
      "definition" : "Marble Sawyer"
    },
    {
      "code" : "7111.023",
      "display" : "Marble Splitter",
      "definition" : "Marble Splitter"
    },
    {
      "code" : "7111.024",
      "display" : "Masonry Carver Monumental",
      "definition" : "Masonry Carver Monumental"
    },
    {
      "code" : "7111.025",
      "display" : "Masonry Cutter Monumental",
      "definition" : "Masonry Cutter Monumental"
    },
    {
      "code" : "7111.026",
      "display" : "Masonry Fixer",
      "definition" : "Masonry Fixer"
    },
    {
      "code" : "7111.027",
      "display" : "Masonry Setter Monumental",
      "definition" : "Masonry Setter Monumental"
    },
    {
      "code" : "7111.028",
      "display" : "Monument Installer",
      "definition" : "Monument Installer"
    },
    {
      "code" : "7111.029",
      "display" : "Monumental Mason",
      "definition" : "Monumental Mason"
    },
    {
      "code" : "7111.030",
      "display" : "Polishing and Stone Cutting Lathe Operator",
      "definition" : "Polishing and Stone Cutting Lathe Operator"
    },
    {
      "code" : "7111.031",
      "display" : "Steeplejack",
      "definition" : "Steeplejack"
    },
    {
      "code" : "7111.032",
      "display" : "Stone Grinder Planer Polisher",
      "definition" : "Stone Grinder Planer Polisher"
    },
    {
      "code" : "7111.033",
      "display" : "Stone Mason",
      "definition" : "Stone Mason"
    },
    {
      "code" : "7111.034",
      "display" : "Stone Masonry Setter",
      "definition" : "Stone Masonry Setter"
    },
    {
      "code" : "7111.035",
      "display" : "Stone Sawyer Splitter",
      "definition" : "Stone Sawyer Splitter"
    },
    {
      "code" : "7111.036",
      "display" : "Stone Turner Lathe",
      "definition" : "Stone Turner Lathe"
    },
    {
      "code" : "7111.037",
      "display" : "Stonemason",
      "definition" : "Stonemason"
    },
    {
      "code" : "7111.038",
      "display" : "Terrazzo Worker",
      "definition" : "Terrazzo Worker"
    },
    {
      "code" : "7111.039",
      "display" : "Tile Layer",
      "definition" : "Tile Layer"
    },
    {
      "code" : "7111.040",
      "display" : "Tile Setter",
      "definition" : "Tile Setter"
    },
    {
      "code" : "7111.041",
      "display" : "Tiler",
      "definition" : "Tiler"
    },
    {
      "code" : "7111.042",
      "display" : "Wall and Floor Tiler",
      "definition" : "Wall and Floor Tiler"
    },
    {
      "code" : "7112.001",
      "display" : "Boatbuilding Supervisor",
      "definition" : "Boatbuilding Supervisor"
    },
    {
      "code" : "7112.002",
      "display" : "Bridge Builder",
      "definition" : "Bridge Builder"
    },
    {
      "code" : "7112.003",
      "display" : "Bridge Carpenter",
      "definition" : "Bridge Carpenter"
    },
    {
      "code" : "7112.004",
      "display" : "Builder",
      "definition" : "Builder"
    },
    {
      "code" : "7112.005",
      "display" : "Builder Housing",
      "definition" : "Builder Housing"
    },
    {
      "code" : "7112.006",
      "display" : "Building Contractor",
      "definition" : "Building Contractor"
    },
    {
      "code" : "7112.007",
      "display" : "Building Maintenance Repairman",
      "definition" : "Building Maintenance Repairman"
    },
    {
      "code" : "7112.008",
      "display" : "Building Supervisor Construction",
      "definition" : "Building Supervisor Construction"
    },
    {
      "code" : "7112.009",
      "display" : "Carpenter",
      "definition" : "Carpenter"
    },
    {
      "code" : "7112.010",
      "display" : "Carpenter Contractor",
      "definition" : "Carpenter Contractor"
    },
    {
      "code" : "7112.011",
      "display" : "Carpenter Maintenance",
      "definition" : "Carpenter Maintenance"
    },
    {
      "code" : "7112.012",
      "display" : "Carpenter or Joiner",
      "definition" : "Carpenter or Joiner"
    },
    {
      "code" : "7112.013",
      "display" : "Commercial Carpenter",
      "definition" : "Commercial Carpenter"
    },
    {
      "code" : "7112.014",
      "display" : "Construction Foreman Chargehand",
      "definition" : "Construction Foreman Chargehand"
    },
    {
      "code" : "7112.015",
      "display" : "Fibreglass Boat Builder",
      "definition" : "Fibreglass Boat Builder"
    },
    {
      "code" : "7112.016",
      "display" : "Home Renovator",
      "definition" : "Home Renovator"
    },
    {
      "code" : "7112.017",
      "display" : "Joiner",
      "definition" : "Joiner"
    },
    {
      "code" : "7112.018",
      "display" : "Kaamura Whakaaetanga Utu",
      "definition" : "Kaamura Whakaaetanga Utu"
    },
    {
      "code" : "7112.019",
      "display" : "Kaamura Whakaritenga Utu",
      "definition" : "Kaamura Whakaritenga Utu"
    },
    {
      "code" : "7112.020",
      "display" : "Kaihanga Taputapu Whare",
      "definition" : "Kaihanga Taputapu Whare"
    },
    {
      "code" : "7112.021",
      "display" : "Kamura Whakaaetanga Utu",
      "definition" : "Kamura Whakaaetanga Utu"
    },
    {
      "code" : "7112.022",
      "display" : "Kamura Whakaritenga Utu",
      "definition" : "Kamura Whakaritenga Utu"
    },
    {
      "code" : "7112.023",
      "display" : "Mine Carpenter Rough Carpentry",
      "definition" : "Mine Carpenter Rough Carpentry"
    },
    {
      "code" : "7112.024",
      "display" : "Panel Erector",
      "definition" : "Panel Erector"
    },
    {
      "code" : "7112.025",
      "display" : "Prefabricated Buildings Maker and Erector",
      "definition" : "Prefabricated Buildings Maker and Erector"
    },
    {
      "code" : "7112.026",
      "display" : "Production Supervisor Construction",
      "definition" : "Production Supervisor Construction"
    },
    {
      "code" : "7112.027",
      "display" : "Registered Master Builder",
      "definition" : "Registered Master Builder"
    },
    {
      "code" : "7112.028",
      "display" : "Residential Builder",
      "definition" : "Residential Builder"
    },
    {
      "code" : "7112.029",
      "display" : "Ship Builder",
      "definition" : "Ship Builder"
    },
    {
      "code" : "7112.030",
      "display" : "Ships Carpenter",
      "definition" : "Ships Carpenter"
    },
    {
      "code" : "7112.031",
      "display" : "Ships Joiner",
      "definition" : "Ships Joiner"
    },
    {
      "code" : "7112.032",
      "display" : "Shipwright Inspector",
      "definition" : "Shipwright Inspector"
    },
    {
      "code" : "7112.033",
      "display" : "Shopfitter",
      "definition" : "Shopfitter"
    },
    {
      "code" : "7112.034",
      "display" : "Wharf Carpenter",
      "definition" : "Wharf Carpenter"
    },
    {
      "code" : "7112.035",
      "display" : "Wood Caravan Builder",
      "definition" : "Wood Caravan Builder"
    },
    {
      "code" : "7112.036",
      "display" : "Wood Joiner",
      "definition" : "Wood Joiner"
    },
    {
      "code" : "7112.037",
      "display" : "Yacht Builder",
      "definition" : "Yacht Builder"
    },
    {
      "code" : "7121.001",
      "display" : "Dry Wall Plasterer",
      "definition" : "Dry Wall Plasterer"
    },
    {
      "code" : "7121.002",
      "display" : "Fibrous Plaster Wallboard Installer",
      "definition" : "Fibrous Plaster Wallboard Installer"
    },
    {
      "code" : "7121.003",
      "display" : "Fibrous Plasterer",
      "definition" : "Fibrous Plasterer"
    },
    {
      "code" : "7121.004",
      "display" : "Gib Board Stopper",
      "definition" : "Gib Board Stopper"
    },
    {
      "code" : "7121.005",
      "display" : "Gib Stopper",
      "definition" : "Gib Stopper"
    },
    {
      "code" : "7121.006",
      "display" : "Interior Plasterer",
      "definition" : "Interior Plasterer"
    },
    {
      "code" : "7121.007",
      "display" : "Ornamental Plasterer",
      "definition" : "Ornamental Plasterer"
    },
    {
      "code" : "7121.008",
      "display" : "Plasterboard Fixer",
      "definition" : "Plasterboard Fixer"
    },
    {
      "code" : "7121.009",
      "display" : "Plasterboard Stopper",
      "definition" : "Plasterboard Stopper"
    },
    {
      "code" : "7121.010",
      "display" : "Plasterer",
      "definition" : "Plasterer"
    },
    {
      "code" : "7121.011",
      "display" : "Solid Plasterer",
      "definition" : "Solid Plasterer"
    },
    {
      "code" : "7121.012",
      "display" : "Stucco Plasterer",
      "definition" : "Stucco Plasterer"
    },
    {
      "code" : "7122.001",
      "display" : "Auto Glazier",
      "definition" : "Auto Glazier"
    },
    {
      "code" : "7122.002",
      "display" : "Glazier",
      "definition" : "Glazier"
    },
    {
      "code" : "7122.003",
      "display" : "Glazier Leaded Glass",
      "definition" : "Glazier Leaded Glass"
    },
    {
      "code" : "7122.004",
      "display" : "Leadlight Glazier",
      "definition" : "Leadlight Glazier"
    },
    {
      "code" : "7122.005",
      "display" : "Mirror Installer",
      "definition" : "Mirror Installer"
    },
    {
      "code" : "7122.006",
      "display" : "Window Glass Fitter",
      "definition" : "Window Glass Fitter"
    },
    {
      "code" : "7123.001",
      "display" : "Kaiwhakarerewai",
      "definition" : "Kaiwhakarerewai"
    },
    {
      "code" : "7123.002",
      "display" : "Kaiwhakauru Taputapu Wai",
      "definition" : "Kaiwhakauru Taputapu Wai"
    },
    {
      "code" : "7123.003",
      "display" : "Maintenance Plumber",
      "definition" : "Maintenance Plumber"
    },
    {
      "code" : "7123.004",
      "display" : "Plumber",
      "definition" : "Plumber"
    },
    {
      "code" : "7124.001",
      "display" : "Auto Striper",
      "definition" : "Auto Striper"
    },
    {
      "code" : "7124.002",
      "display" : "Automobile Painter",
      "definition" : "Automobile Painter"
    },
    {
      "code" : "7124.003",
      "display" : "Brush Hand",
      "definition" : "Brush Hand"
    },
    {
      "code" : "7124.004",
      "display" : "Car Painter",
      "definition" : "Car Painter"
    },
    {
      "code" : "7124.005",
      "display" : "Car Spray Painter",
      "definition" : "Car Spray Painter"
    },
    {
      "code" : "7124.006",
      "display" : "Coach Painter",
      "definition" : "Coach Painter"
    },
    {
      "code" : "7124.007",
      "display" : "Coachpainter",
      "definition" : "Coachpainter"
    },
    {
      "code" : "7124.008",
      "display" : "Decorator",
      "definition" : "Decorator"
    },
    {
      "code" : "7124.009",
      "display" : "Highway Lane Marker",
      "definition" : "Highway Lane Marker"
    },
    {
      "code" : "7124.010",
      "display" : "House Painter",
      "definition" : "House Painter"
    },
    {
      "code" : "7124.011",
      "display" : "Kaipeita Kaiwhakapaipai Whare",
      "definition" : "Kaipeita Kaiwhakapaipai Whare"
    },
    {
      "code" : "7124.012",
      "display" : "Kaipeita Whare",
      "definition" : "Kaipeita Whare"
    },
    {
      "code" : "7124.013",
      "display" : "Metal Coater",
      "definition" : "Metal Coater"
    },
    {
      "code" : "7124.014",
      "display" : "Metal Sprayer",
      "definition" : "Metal Sprayer"
    },
    {
      "code" : "7124.015",
      "display" : "Motor Vehicle Painter",
      "definition" : "Motor Vehicle Painter"
    },
    {
      "code" : "7124.016",
      "display" : "Painter and Decorator",
      "definition" : "Painter and Decorator"
    },
    {
      "code" : "7124.017",
      "display" : "Painter and Paperhanger",
      "definition" : "Painter and Paperhanger"
    },
    {
      "code" : "7124.018",
      "display" : "Painter Decorator",
      "definition" : "Painter Decorator"
    },
    {
      "code" : "7124.019",
      "display" : "Painter Decorator or Paperhanger",
      "definition" : "Painter Decorator or Paperhanger"
    },
    {
      "code" : "7124.020",
      "display" : "Painter Paperhanger",
      "definition" : "Painter Paperhanger"
    },
    {
      "code" : "7124.021",
      "display" : "Painting Contractor",
      "definition" : "Painting Contractor"
    },
    {
      "code" : "7124.022",
      "display" : "Paperhanger",
      "definition" : "Paperhanger"
    },
    {
      "code" : "7124.023",
      "display" : "Road Marker",
      "definition" : "Road Marker"
    },
    {
      "code" : "7124.024",
      "display" : "Rust Proofer",
      "definition" : "Rust Proofer"
    },
    {
      "code" : "7124.025",
      "display" : "Ships Painter",
      "definition" : "Ships Painter"
    },
    {
      "code" : "7124.026",
      "display" : "Sign Maker",
      "definition" : "Sign Maker"
    },
    {
      "code" : "7124.027",
      "display" : "Sign Manufacturer",
      "definition" : "Sign Manufacturer"
    },
    {
      "code" : "7124.028",
      "display" : "Sign Painter",
      "definition" : "Sign Painter"
    },
    {
      "code" : "7124.029",
      "display" : "Sign Writer",
      "definition" : "Sign Writer"
    },
    {
      "code" : "7124.030",
      "display" : "Signcrafter",
      "definition" : "Signcrafter"
    },
    {
      "code" : "7124.031",
      "display" : "Signwriter",
      "definition" : "Signwriter"
    },
    {
      "code" : "7124.032",
      "display" : "Spray Painter",
      "definition" : "Spray Painter"
    },
    {
      "code" : "7124.033",
      "display" : "Spraypainter",
      "definition" : "Spraypainter"
    },
    {
      "code" : "7124.034",
      "display" : "Structural Steel Painter",
      "definition" : "Structural Steel Painter"
    },
    {
      "code" : "7124.035",
      "display" : "Tangata Peita Whare",
      "definition" : "Tangata Peita Whare"
    },
    {
      "code" : "7131.001",
      "display" : "Aircraft Electrician",
      "definition" : "Aircraft Electrician"
    },
    {
      "code" : "7131.002",
      "display" : "Appliance Electrician",
      "definition" : "Appliance Electrician"
    },
    {
      "code" : "7131.003",
      "display" : "Appliance Serviceman",
      "definition" : "Appliance Serviceman"
    },
    {
      "code" : "7131.004",
      "display" : "Auto Electrician",
      "definition" : "Auto Electrician"
    },
    {
      "code" : "7131.005",
      "display" : "Automotive Electrician",
      "definition" : "Automotive Electrician"
    },
    {
      "code" : "7131.006",
      "display" : "Car Electrician",
      "definition" : "Car Electrician"
    },
    {
      "code" : "7131.007",
      "display" : "Domestic Appliance Fitter",
      "definition" : "Domestic Appliance Fitter"
    },
    {
      "code" : "7131.008",
      "display" : "Domestic Electrician",
      "definition" : "Domestic Electrician"
    },
    {
      "code" : "7131.009",
      "display" : "Electrical Appliance Serviceman",
      "definition" : "Electrical Appliance Serviceman"
    },
    {
      "code" : "7131.010",
      "display" : "Electrical Appliance Servicer",
      "definition" : "Electrical Appliance Servicer"
    },
    {
      "code" : "7131.011",
      "display" : "Electrical Contractor",
      "definition" : "Electrical Contractor"
    },
    {
      "code" : "7131.012",
      "display" : "Electrical Installer",
      "definition" : "Electrical Installer"
    },
    {
      "code" : "7131.013",
      "display" : "Electrical Repairman",
      "definition" : "Electrical Repairman"
    },
    {
      "code" : "7131.014",
      "display" : "Electrician",
      "definition" : "Electrician"
    },
    {
      "code" : "7131.015",
      "display" : "Home Appliance Repairer",
      "definition" : "Home Appliance Repairer"
    },
    {
      "code" : "7131.016",
      "display" : "Home Appliance Serviceman",
      "definition" : "Home Appliance Serviceman"
    },
    {
      "code" : "7131.017",
      "display" : "Industrial Electrician",
      "definition" : "Industrial Electrician"
    },
    {
      "code" : "7131.018",
      "display" : "Kaimahi Hihiko",
      "definition" : "Kaimahi Hihiko"
    },
    {
      "code" : "7131.019",
      "display" : "Kaimahi Hiko",
      "definition" : "Kaimahi Hiko"
    },
    {
      "code" : "7131.020",
      "display" : "Kaimahi Hikohiko",
      "definition" : "Kaimahi Hikohiko"
    },
    {
      "code" : "7131.021",
      "display" : "Kaimahi Whakatikatika Taputapu Hiko",
      "definition" : "Kaimahi Whakatikatika Taputapu Hiko"
    },
    {
      "code" : "7131.022",
      "display" : "Kaimahi Whakauru Hiko",
      "definition" : "Kaimahi Whakauru Hiko"
    },
    {
      "code" : "7131.023",
      "display" : "Kaimahi Whakauru Taputapu Hiko",
      "definition" : "Kaimahi Whakauru Taputapu Hiko"
    },
    {
      "code" : "7131.024",
      "display" : "Kaiwhakatika Hihiko",
      "definition" : "Kaiwhakatika Hihiko"
    },
    {
      "code" : "7131.025",
      "display" : "Locomotive Electrician",
      "definition" : "Locomotive Electrician"
    },
    {
      "code" : "7131.026",
      "display" : "Maintenance Electrician",
      "definition" : "Maintenance Electrician"
    },
    {
      "code" : "7131.027",
      "display" : "Mine Electrician",
      "definition" : "Mine Electrician"
    },
    {
      "code" : "7131.028",
      "display" : "Neon Lighting Electrician",
      "definition" : "Neon Lighting Electrician"
    },
    {
      "code" : "7131.029",
      "display" : "Ships Electrician",
      "definition" : "Ships Electrician"
    },
    {
      "code" : "7131.030",
      "display" : "Transport Electrician",
      "definition" : "Transport Electrician"
    },
    {
      "code" : "7131.031",
      "display" : "Vehicle Electrician",
      "definition" : "Vehicle Electrician"
    },
    {
      "code" : "7131.032",
      "display" : "Whiteware Serviceman",
      "definition" : "Whiteware Serviceman"
    },
    {
      "code" : "7211.001",
      "display" : "Brass Founder Moulder",
      "definition" : "Brass Founder Moulder"
    },
    {
      "code" : "7211.002",
      "display" : "Coremaker",
      "definition" : "Coremaker"
    },
    {
      "code" : "7211.003",
      "display" : "Foundry Moulder",
      "definition" : "Foundry Moulder"
    },
    {
      "code" : "7211.004",
      "display" : "Metal Mould Maker",
      "definition" : "Metal Mould Maker"
    },
    {
      "code" : "7211.005",
      "display" : "Metal Mould Maker Supervisor",
      "definition" : "Metal Mould Maker Supervisor"
    },
    {
      "code" : "7212.001",
      "display" : "Aircraft Body Maker",
      "definition" : "Aircraft Body Maker"
    },
    {
      "code" : "7212.002",
      "display" : "Aluminium Worker",
      "definition" : "Aluminium Worker"
    },
    {
      "code" : "7212.003",
      "display" : "Auto Body Repairer",
      "definition" : "Auto Body Repairer"
    },
    {
      "code" : "7212.004",
      "display" : "Blind Maker Venetian",
      "definition" : "Blind Maker Venetian"
    },
    {
      "code" : "7212.005",
      "display" : "Blind Repairer Venetian",
      "definition" : "Blind Repairer Venetian"
    },
    {
      "code" : "7212.006",
      "display" : "Boiler Maker",
      "definition" : "Boiler Maker"
    },
    {
      "code" : "7212.007",
      "display" : "Boilermaker",
      "definition" : "Boilermaker"
    },
    {
      "code" : "7212.008",
      "display" : "Boilermaker Welder",
      "definition" : "Boilermaker Welder"
    },
    {
      "code" : "7212.009",
      "display" : "Boilermakers Supervisor",
      "definition" : "Boilermakers Supervisor"
    },
    {
      "code" : "7212.010",
      "display" : "Brassmith",
      "definition" : "Brassmith"
    },
    {
      "code" : "7212.011",
      "display" : "Canister Maker",
      "definition" : "Canister Maker"
    },
    {
      "code" : "7212.012",
      "display" : "Chassis Straightener",
      "definition" : "Chassis Straightener"
    },
    {
      "code" : "7212.013",
      "display" : "Coach Builder",
      "definition" : "Coach Builder"
    },
    {
      "code" : "7212.014",
      "display" : "Coach Building Supervisor",
      "definition" : "Coach Building Supervisor"
    },
    {
      "code" : "7212.015",
      "display" : "Coachbuilder",
      "definition" : "Coachbuilder"
    },
    {
      "code" : "7212.016",
      "display" : "Coppersmith",
      "definition" : "Coppersmith"
    },
    {
      "code" : "7212.017",
      "display" : "Duct Erector",
      "definition" : "Duct Erector"
    },
    {
      "code" : "7212.018",
      "display" : "Fabrication Engineer (Welding)",
      "definition" : "Fabrication Engineer (Welding)"
    },
    {
      "code" : "7212.019",
      "display" : "Fitter and Welder",
      "definition" : "Fitter and Welder"
    },
    {
      "code" : "7212.020",
      "display" : "Fitter and Welder Supervisor",
      "definition" : "Fitter and Welder Supervisor"
    },
    {
      "code" : "7212.021",
      "display" : "Fitter Welder",
      "definition" : "Fitter Welder"
    },
    {
      "code" : "7212.022",
      "display" : "Furniture Maker Metal",
      "definition" : "Furniture Maker Metal"
    },
    {
      "code" : "7212.023",
      "display" : "Heavy Fabrication Engineer",
      "definition" : "Heavy Fabrication Engineer"
    },
    {
      "code" : "7212.024",
      "display" : "Installer Sheetmetal",
      "definition" : "Installer Sheetmetal"
    },
    {
      "code" : "7212.025",
      "display" : "Light Farbrication Engineer",
      "definition" : "Light Farbrication Engineer"
    },
    {
      "code" : "7212.026",
      "display" : "Machine Riveter",
      "definition" : "Machine Riveter"
    },
    {
      "code" : "7212.027",
      "display" : "Metal Boat or Ship Builder",
      "definition" : "Metal Boat or Ship Builder"
    },
    {
      "code" : "7212.028",
      "display" : "Metal Caravan Builder",
      "definition" : "Metal Caravan Builder"
    },
    {
      "code" : "7212.029",
      "display" : "Metal Coach and Carriage Builder",
      "definition" : "Metal Coach and Carriage Builder"
    },
    {
      "code" : "7212.030",
      "display" : "Metal Marker Sheet Machine Shop",
      "definition" : "Metal Marker Sheet Machine Shop"
    },
    {
      "code" : "7212.031",
      "display" : "Metal Sheeter",
      "definition" : "Metal Sheeter"
    },
    {
      "code" : "7212.032",
      "display" : "Metal Shipwright",
      "definition" : "Metal Shipwright"
    },
    {
      "code" : "7212.033",
      "display" : "Motor Body Builder",
      "definition" : "Motor Body Builder"
    },
    {
      "code" : "7212.034",
      "display" : "Panel Beater",
      "definition" : "Panel Beater"
    },
    {
      "code" : "7212.035",
      "display" : "Panelbeater",
      "definition" : "Panelbeater"
    },
    {
      "code" : "7212.036",
      "display" : "Perambulator Maker",
      "definition" : "Perambulator Maker"
    },
    {
      "code" : "7212.037",
      "display" : "Plate Layer",
      "definition" : "Plate Layer"
    },
    {
      "code" : "7212.038",
      "display" : "Pressure Welder",
      "definition" : "Pressure Welder"
    },
    {
      "code" : "7212.039",
      "display" : "Process Worker Sheet Metal",
      "definition" : "Process Worker Sheet Metal"
    },
    {
      "code" : "7212.040",
      "display" : "Quality Controller Of Panelbeaters",
      "definition" : "Quality Controller Of Panelbeaters"
    },
    {
      "code" : "7212.041",
      "display" : "Riveter",
      "definition" : "Riveter"
    },
    {
      "code" : "7212.042",
      "display" : "Sheet Metal Marker",
      "definition" : "Sheet Metal Marker"
    },
    {
      "code" : "7212.043",
      "display" : "Sheet Metal Production Supervisor",
      "definition" : "Sheet Metal Production Supervisor"
    },
    {
      "code" : "7212.044",
      "display" : "Sheet Metal Work Supervisor",
      "definition" : "Sheet Metal Work Supervisor"
    },
    {
      "code" : "7212.045",
      "display" : "Sheet Metal Worker Aircraft",
      "definition" : "Sheet Metal Worker Aircraft"
    },
    {
      "code" : "7212.046",
      "display" : "Sheetmetal Engineer",
      "definition" : "Sheetmetal Engineer"
    },
    {
      "code" : "7212.047",
      "display" : "Sheetmetal Worker",
      "definition" : "Sheetmetal Worker"
    },
    {
      "code" : "7212.048",
      "display" : "Sheet-Metal Worker",
      "definition" : "Sheet-Metal Worker"
    },
    {
      "code" : "7212.049",
      "display" : "Ship Plater",
      "definition" : "Ship Plater"
    },
    {
      "code" : "7212.050",
      "display" : "Shipwright and Plater Metal Supervisor",
      "definition" : "Shipwright and Plater Metal Supervisor"
    },
    {
      "code" : "7212.051",
      "display" : "Stainless Steel Fabricator",
      "definition" : "Stainless Steel Fabricator"
    },
    {
      "code" : "7212.052",
      "display" : "Tinsmith",
      "definition" : "Tinsmith"
    },
    {
      "code" : "7212.053",
      "display" : "Truck Builder",
      "definition" : "Truck Builder"
    },
    {
      "code" : "7212.054",
      "display" : "Vehicle Body Builder",
      "definition" : "Vehicle Body Builder"
    },
    {
      "code" : "7212.055",
      "display" : "Vehicle Body Repairman",
      "definition" : "Vehicle Body Repairman"
    },
    {
      "code" : "7212.056",
      "display" : "Welding Tradesperson",
      "definition" : "Welding Tradesperson"
    },
    {
      "code" : "7221.001",
      "display" : "Blacksmith",
      "definition" : "Blacksmith"
    },
    {
      "code" : "7221.002",
      "display" : "Blacksmiths Striker",
      "definition" : "Blacksmiths Striker"
    },
    {
      "code" : "7221.003",
      "display" : "Farrier",
      "definition" : "Farrier"
    },
    {
      "code" : "7221.004",
      "display" : "Farrier Shoeing Smith",
      "definition" : "Farrier Shoeing Smith"
    },
    {
      "code" : "7221.005",
      "display" : "Wrought Iron Worker",
      "definition" : "Wrought Iron Worker"
    },
    {
      "code" : "7222.001",
      "display" : "Die Cutter",
      "definition" : "Die Cutter"
    },
    {
      "code" : "7222.002",
      "display" : "Die Maker",
      "definition" : "Die Maker"
    },
    {
      "code" : "7222.003",
      "display" : "Die Sinker",
      "definition" : "Die Sinker"
    },
    {
      "code" : "7222.004",
      "display" : "Diemaker",
      "definition" : "Diemaker"
    },
    {
      "code" : "7222.005",
      "display" : "Engineering Pattern Maker",
      "definition" : "Engineering Pattern Maker"
    },
    {
      "code" : "7222.006",
      "display" : "Engineering Pattern Maker Supervisor",
      "definition" : "Engineering Pattern Maker Supervisor"
    },
    {
      "code" : "7222.007",
      "display" : "Jig Mounter",
      "definition" : "Jig Mounter"
    },
    {
      "code" : "7222.008",
      "display" : "Metal Foundry Template Maker",
      "definition" : "Metal Foundry Template Maker"
    },
    {
      "code" : "7222.009",
      "display" : "Metal Pattern Maker",
      "definition" : "Metal Pattern Maker"
    },
    {
      "code" : "7222.010",
      "display" : "Metal Profile Cutter",
      "definition" : "Metal Profile Cutter"
    },
    {
      "code" : "7222.011",
      "display" : "Pattern Maker",
      "definition" : "Pattern Maker"
    },
    {
      "code" : "7222.012",
      "display" : "Pattern Making Supervisor",
      "definition" : "Pattern Making Supervisor"
    },
    {
      "code" : "7222.013",
      "display" : "Quality Controller Of Pattern Makers",
      "definition" : "Quality Controller Of Pattern Makers"
    },
    {
      "code" : "7222.014",
      "display" : "Tool Maker",
      "definition" : "Tool Maker"
    },
    {
      "code" : "7222.015",
      "display" : "Tool or Die Maker",
      "definition" : "Tool or Die Maker"
    },
    {
      "code" : "7222.016",
      "display" : "Tool or Die Maker Supervisor",
      "definition" : "Tool or Die Maker Supervisor"
    },
    {
      "code" : "7222.017",
      "display" : "Toolmaker",
      "definition" : "Toolmaker"
    },
    {
      "code" : "7222.018",
      "display" : "Toolmaker and Designer",
      "definition" : "Toolmaker and Designer"
    },
    {
      "code" : "7222.019",
      "display" : "Toolmakers Supervisor",
      "definition" : "Toolmakers Supervisor"
    },
    {
      "code" : "7223.001",
      "display" : "Auto Diesel Fitter",
      "definition" : "Auto Diesel Fitter"
    },
    {
      "code" : "7223.002",
      "display" : "Factory Workshop Engineering Fitter",
      "definition" : "Factory Workshop Engineering Fitter"
    },
    {
      "code" : "7223.003",
      "display" : "Fitter Turner",
      "definition" : "Fitter Turner"
    },
    {
      "code" : "7223.004",
      "display" : "Mechanical Fitter",
      "definition" : "Mechanical Fitter"
    },
    {
      "code" : "7223.005",
      "display" : "Metal Lathe Tradesperson",
      "definition" : "Metal Lathe Tradesperson"
    },
    {
      "code" : "7223.006",
      "display" : "Petrol Pump Fitter",
      "definition" : "Petrol Pump Fitter"
    },
    {
      "code" : "7223.007",
      "display" : "Quality Controller Of Fitter Turners",
      "definition" : "Quality Controller Of Fitter Turners"
    },
    {
      "code" : "7223.008",
      "display" : "Service Engineering Fitter",
      "definition" : "Service Engineering Fitter"
    },
    {
      "code" : "7223.009",
      "display" : "Water Works Fitter",
      "definition" : "Water Works Fitter"
    },
    {
      "code" : "7223.010",
      "display" : "Waterworks Fitter",
      "definition" : "Waterworks Fitter"
    },
    {
      "code" : "7223.011",
      "display" : "Waterworks Maintenance Fitter",
      "definition" : "Waterworks Maintenance Fitter"
    },
    {
      "code" : "7224.001",
      "display" : "Saw Doctor",
      "definition" : "Saw Doctor"
    },
    {
      "code" : "7224.002",
      "display" : "Saw Repairer",
      "definition" : "Saw Repairer"
    },
    {
      "code" : "7224.003",
      "display" : "Saw Setter",
      "definition" : "Saw Setter"
    },
    {
      "code" : "7224.004",
      "display" : "Saw Sharpener",
      "definition" : "Saw Sharpener"
    },
    {
      "code" : "7224.005",
      "display" : "Sawdoctor",
      "definition" : "Sawdoctor"
    },
    {
      "code" : "7231.001",
      "display" : "Agricultural Machinery Mechanic",
      "definition" : "Agricultural Machinery Mechanic"
    },
    {
      "code" : "7231.002",
      "display" : "Air Conditioning Mechanic",
      "definition" : "Air Conditioning Mechanic"
    },
    {
      "code" : "7231.003",
      "display" : "Air Transport Workshop Planner",
      "definition" : "Air Transport Workshop Planner"
    },
    {
      "code" : "7231.004",
      "display" : "Aircraft Engine Mechanic",
      "definition" : "Aircraft Engine Mechanic"
    },
    {
      "code" : "7231.005",
      "display" : "Aircraft Engineering Serviceman",
      "definition" : "Aircraft Engineering Serviceman"
    },
    {
      "code" : "7231.006",
      "display" : "Aircraft Engineering Tradesperson",
      "definition" : "Aircraft Engineering Tradesperson"
    },
    {
      "code" : "7231.007",
      "display" : "Aircraft Simulator Mechanic",
      "definition" : "Aircraft Simulator Mechanic"
    },
    {
      "code" : "7231.008",
      "display" : "Auto Engineer",
      "definition" : "Auto Engineer"
    },
    {
      "code" : "7231.009",
      "display" : "Auto Mechanic",
      "definition" : "Auto Mechanic"
    },
    {
      "code" : "7231.010",
      "display" : "Auto Wrecker",
      "definition" : "Auto Wrecker"
    },
    {
      "code" : "7231.011",
      "display" : "Automobile Mechanic",
      "definition" : "Automobile Mechanic"
    },
    {
      "code" : "7231.012",
      "display" : "Automotive Dismantler",
      "definition" : "Automotive Dismantler"
    },
    {
      "code" : "7231.013",
      "display" : "Automotive Mechanic",
      "definition" : "Automotive Mechanic"
    },
    {
      "code" : "7231.014",
      "display" : "Automotive Mechanic Engineer",
      "definition" : "Automotive Mechanic Engineer"
    },
    {
      "code" : "7231.015",
      "display" : "Automotive Surveyor",
      "definition" : "Automotive Surveyor"
    },
    {
      "code" : "7231.016",
      "display" : "Bicycle Repairman",
      "definition" : "Bicycle Repairman"
    },
    {
      "code" : "7231.017",
      "display" : "Brake Repairman",
      "definition" : "Brake Repairman"
    },
    {
      "code" : "7231.018",
      "display" : "Brake/Clutch Fitter",
      "definition" : "Brake/Clutch Fitter"
    },
    {
      "code" : "7231.019",
      "display" : "Car Dismantler",
      "definition" : "Car Dismantler"
    },
    {
      "code" : "7231.020",
      "display" : "Car Mechanic",
      "definition" : "Car Mechanic"
    },
    {
      "code" : "7231.021",
      "display" : "Car Wrecker",
      "definition" : "Car Wrecker"
    },
    {
      "code" : "7231.022",
      "display" : "Coin Machine Mechanic",
      "definition" : "Coin Machine Mechanic"
    },
    {
      "code" : "7231.023",
      "display" : "Cold Storage Maintenace Serviceman",
      "definition" : "Cold Storage Maintenace Serviceman"
    },
    {
      "code" : "7231.024",
      "display" : "Construction Machinery Mechanic",
      "definition" : "Construction Machinery Mechanic"
    },
    {
      "code" : "7231.025",
      "display" : "Cooling System Mechanic",
      "definition" : "Cooling System Mechanic"
    },
    {
      "code" : "7231.026",
      "display" : "Diesel Injector",
      "definition" : "Diesel Injector"
    },
    {
      "code" : "7231.027",
      "display" : "Diesel Mechanic",
      "definition" : "Diesel Mechanic"
    },
    {
      "code" : "7231.028",
      "display" : "Earthmoving Machinery Mechanic",
      "definition" : "Earthmoving Machinery Mechanic"
    },
    {
      "code" : "7231.029",
      "display" : "Garage Mechanic Automobile",
      "definition" : "Garage Mechanic Automobile"
    },
    {
      "code" : "7231.030",
      "display" : "Garden Machinery Repairer",
      "definition" : "Garden Machinery Repairer"
    },
    {
      "code" : "7231.031",
      "display" : "Heating and Ventilating Mechanic",
      "definition" : "Heating and Ventilating Mechanic"
    },
    {
      "code" : "7231.032",
      "display" : "Heating and Ventilation Mechanic",
      "definition" : "Heating and Ventilation Mechanic"
    },
    {
      "code" : "7231.033",
      "display" : "Heating Control Mechanic",
      "definition" : "Heating Control Mechanic"
    },
    {
      "code" : "7231.034",
      "display" : "Heating Ventilation and Air Conditioning Mechanic",
      "definition" : "Heating Ventilation and Air Conditioning Mechanic"
    },
    {
      "code" : "7231.035",
      "display" : "Hosiery Knitting Machine Mechanic",
      "definition" : "Hosiery Knitting Machine Mechanic"
    },
    {
      "code" : "7231.036",
      "display" : "Installer Refrigeration Air Conditioning",
      "definition" : "Installer Refrigeration Air Conditioning"
    },
    {
      "code" : "7231.037",
      "display" : "Jacquard Machine Repairer",
      "definition" : "Jacquard Machine Repairer"
    },
    {
      "code" : "7231.038",
      "display" : "Juke Box Serviceman",
      "definition" : "Juke Box Serviceman"
    },
    {
      "code" : "7231.039",
      "display" : "Knitting Machine Setter",
      "definition" : "Knitting Machine Setter"
    },
    {
      "code" : "7231.040",
      "display" : "Lawn Mower Mechanic",
      "definition" : "Lawn Mower Mechanic"
    },
    {
      "code" : "7231.041",
      "display" : "Lawnmower Mechanic",
      "definition" : "Lawnmower Mechanic"
    },
    {
      "code" : "7231.042",
      "display" : "Licensed Aircraft Mechanic",
      "definition" : "Licensed Aircraft Mechanic"
    },
    {
      "code" : "7231.043",
      "display" : "Locomotive Maintainer",
      "definition" : "Locomotive Maintainer"
    },
    {
      "code" : "7231.044",
      "display" : "Loom Fixer",
      "definition" : "Loom Fixer"
    },
    {
      "code" : "7231.045",
      "display" : "Loom Tuner",
      "definition" : "Loom Tuner"
    },
    {
      "code" : "7231.046",
      "display" : "Lube Bay Attendant or Operator",
      "definition" : "Lube Bay Attendant or Operator"
    },
    {
      "code" : "7231.047",
      "display" : "Machinery Mechanic",
      "definition" : "Machinery Mechanic"
    },
    {
      "code" : "7231.048",
      "display" : "Maintenance Fitter",
      "definition" : "Maintenance Fitter"
    },
    {
      "code" : "7231.049",
      "display" : "Maintenance Mechanic",
      "definition" : "Maintenance Mechanic"
    },
    {
      "code" : "7231.050",
      "display" : "Maintenance Plant Serviceman",
      "definition" : "Maintenance Plant Serviceman"
    },
    {
      "code" : "7231.051",
      "display" : "Maintenance Serviceman Cold Storage",
      "definition" : "Maintenance Serviceman Cold Storage"
    },
    {
      "code" : "7231.052",
      "display" : "Marine Engine Fitter",
      "definition" : "Marine Engine Fitter"
    },
    {
      "code" : "7231.053",
      "display" : "Marine Mechanic",
      "definition" : "Marine Mechanic"
    },
    {
      "code" : "7231.054",
      "display" : "Marine Superintendant Maintenance",
      "definition" : "Marine Superintendant Maintenance"
    },
    {
      "code" : "7231.055",
      "display" : "Mechanical Products Inspector and Tester",
      "definition" : "Mechanical Products Inspector and Tester"
    },
    {
      "code" : "7231.056",
      "display" : "Metal Working Machine Mechanic",
      "definition" : "Metal Working Machine Mechanic"
    },
    {
      "code" : "7231.057",
      "display" : "Meter Tester",
      "definition" : "Meter Tester"
    },
    {
      "code" : "7231.058",
      "display" : "Mill Serviceman Sawmill Maintenance",
      "definition" : "Mill Serviceman Sawmill Maintenance"
    },
    {
      "code" : "7231.059",
      "display" : "Mine Machinery Mechanic",
      "definition" : "Mine Machinery Mechanic"
    },
    {
      "code" : "7231.060",
      "display" : "Motor Mechanic",
      "definition" : "Motor Mechanic"
    },
    {
      "code" : "7231.061",
      "display" : "Motor Mower Mechanic",
      "definition" : "Motor Mower Mechanic"
    },
    {
      "code" : "7231.062",
      "display" : "Motor Mower Repairer",
      "definition" : "Motor Mower Repairer"
    },
    {
      "code" : "7231.063",
      "display" : "Motor Vehicle Inspector",
      "definition" : "Motor Vehicle Inspector"
    },
    {
      "code" : "7231.064",
      "display" : "Motor Vehicle Mechanic",
      "definition" : "Motor Vehicle Mechanic"
    },
    {
      "code" : "7231.065",
      "display" : "Motorcycle Mechanic",
      "definition" : "Motorcycle Mechanic"
    },
    {
      "code" : "7231.066",
      "display" : "Muffler/Exhaust Fitter",
      "definition" : "Muffler/Exhaust Fitter"
    },
    {
      "code" : "7231.067",
      "display" : "Outboard Motor Mechanic",
      "definition" : "Outboard Motor Mechanic"
    },
    {
      "code" : "7231.068",
      "display" : "Parking Meter Mechanic",
      "definition" : "Parking Meter Mechanic"
    },
    {
      "code" : "7231.069",
      "display" : "Patrol Officer Automobile Association",
      "definition" : "Patrol Officer Automobile Association"
    },
    {
      "code" : "7231.070",
      "display" : "Petrol Pump Maintenance Mechanic",
      "definition" : "Petrol Pump Maintenance Mechanic"
    },
    {
      "code" : "7231.071",
      "display" : "Plant Maintenance Mechanic",
      "definition" : "Plant Maintenance Mechanic"
    },
    {
      "code" : "7231.072",
      "display" : "Printing Machine Mechanic",
      "definition" : "Printing Machine Mechanic"
    },
    {
      "code" : "7231.073",
      "display" : "Pump Mechanic",
      "definition" : "Pump Mechanic"
    },
    {
      "code" : "7231.074",
      "display" : "Refrigeration Installer",
      "definition" : "Refrigeration Installer"
    },
    {
      "code" : "7231.075",
      "display" : "Refrigeration Mechanic",
      "definition" : "Refrigeration Mechanic"
    },
    {
      "code" : "7231.076",
      "display" : "Refrigeration Serviceman",
      "definition" : "Refrigeration Serviceman"
    },
    {
      "code" : "7231.077",
      "display" : "Refrigeration Systems Mechanic",
      "definition" : "Refrigeration Systems Mechanic"
    },
    {
      "code" : "7231.078",
      "display" : "Scooter Motorbike Mechanic",
      "definition" : "Scooter Motorbike Mechanic"
    },
    {
      "code" : "7231.079",
      "display" : "Sewing Machine Mechanic",
      "definition" : "Sewing Machine Mechanic"
    },
    {
      "code" : "7231.080",
      "display" : "Ships Engine Room Mechanic",
      "definition" : "Ships Engine Room Mechanic"
    },
    {
      "code" : "7231.081",
      "display" : "Slot Machine Serviceman",
      "definition" : "Slot Machine Serviceman"
    },
    {
      "code" : "7231.082",
      "display" : "Small Engine Mechanic",
      "definition" : "Small Engine Mechanic"
    },
    {
      "code" : "7231.083",
      "display" : "Testing Machine Engineer",
      "definition" : "Testing Machine Engineer"
    },
    {
      "code" : "7231.084",
      "display" : "Textile Machine Mechanic",
      "definition" : "Textile Machine Mechanic"
    },
    {
      "code" : "7231.085",
      "display" : "Tractor Mechanic",
      "definition" : "Tractor Mechanic"
    },
    {
      "code" : "7231.086",
      "display" : "Tractor Servicer",
      "definition" : "Tractor Servicer"
    },
    {
      "code" : "7231.087",
      "display" : "Truck Mechanic",
      "definition" : "Truck Mechanic"
    },
    {
      "code" : "7231.088",
      "display" : "Vehicle Dismantler",
      "definition" : "Vehicle Dismantler"
    },
    {
      "code" : "7231.089",
      "display" : "Vehicle Radiator Mechanic",
      "definition" : "Vehicle Radiator Mechanic"
    },
    {
      "code" : "7231.090",
      "display" : "Ventilation and Air Conditioning Installer",
      "definition" : "Ventilation and Air Conditioning Installer"
    },
    {
      "code" : "7231.091",
      "display" : "Ventilation Mechanic",
      "definition" : "Ventilation Mechanic"
    },
    {
      "code" : "7231.092",
      "display" : "Weaving and Knitting Machine Setter",
      "definition" : "Weaving and Knitting Machine Setter"
    },
    {
      "code" : "7231.093",
      "display" : "Woodworking Machine Mechanic",
      "definition" : "Woodworking Machine Mechanic"
    },
    {
      "code" : "7241.001",
      "display" : "Automatic Signal Maintenance Man",
      "definition" : "Automatic Signal Maintenance Man"
    },
    {
      "code" : "7241.002",
      "display" : "Dynamo Fitter",
      "definition" : "Dynamo Fitter"
    },
    {
      "code" : "7241.003",
      "display" : "Electric Motor and Generator Fitter",
      "definition" : "Electric Motor and Generator Fitter"
    },
    {
      "code" : "7241.004",
      "display" : "Electrical Air Conditioning Fitter",
      "definition" : "Electrical Air Conditioning Fitter"
    },
    {
      "code" : "7241.005",
      "display" : "Electrical Fitter",
      "definition" : "Electrical Fitter"
    },
    {
      "code" : "7241.006",
      "display" : "Electrical Instrument Fitter",
      "definition" : "Electrical Instrument Fitter"
    },
    {
      "code" : "7241.007",
      "display" : "Electrical Mechanic Fitter",
      "definition" : "Electrical Mechanic Fitter"
    },
    {
      "code" : "7241.008",
      "display" : "Electrical Signal Adjuster Fitter",
      "definition" : "Electrical Signal Adjuster Fitter"
    },
    {
      "code" : "7241.009",
      "display" : "Electrical Signalling Systems Fitter",
      "definition" : "Electrical Signalling Systems Fitter"
    },
    {
      "code" : "7241.010",
      "display" : "Electrical Switch and Control Gear Fitter",
      "definition" : "Electrical Switch and Control Gear Fitter"
    },
    {
      "code" : "7241.011",
      "display" : "Electrical Switchboard Fitter",
      "definition" : "Electrical Switchboard Fitter"
    },
    {
      "code" : "7241.012",
      "display" : "Elevator Fitter",
      "definition" : "Elevator Fitter"
    },
    {
      "code" : "7241.013",
      "display" : "Elevator Repair Person",
      "definition" : "Elevator Repair Person"
    },
    {
      "code" : "7241.014",
      "display" : "Fire Alarm Technician",
      "definition" : "Fire Alarm Technician"
    },
    {
      "code" : "7241.015",
      "display" : "Fire Equipment Serviceman Electrical",
      "definition" : "Fire Equipment Serviceman Electrical"
    },
    {
      "code" : "7241.016",
      "display" : "Lift Fitter",
      "definition" : "Lift Fitter"
    },
    {
      "code" : "7241.017",
      "display" : "Lift Mechanic",
      "definition" : "Lift Mechanic"
    },
    {
      "code" : "7241.018",
      "display" : "Transformer Fitter",
      "definition" : "Transformer Fitter"
    },
    {
      "code" : "7242.001",
      "display" : "Alarm Installer",
      "definition" : "Alarm Installer"
    },
    {
      "code" : "7242.002",
      "display" : "Avionics Engineering Tradesperson",
      "definition" : "Avionics Engineering Tradesperson"
    },
    {
      "code" : "7242.003",
      "display" : "Avionics Mechanic",
      "definition" : "Avionics Mechanic"
    },
    {
      "code" : "7242.004",
      "display" : "Burglar Alarm Installer",
      "definition" : "Burglar Alarm Installer"
    },
    {
      "code" : "7242.005",
      "display" : "Computer Engineering Mechanic",
      "definition" : "Computer Engineering Mechanic"
    },
    {
      "code" : "7242.006",
      "display" : "Computer Engineering Serviceman",
      "definition" : "Computer Engineering Serviceman"
    },
    {
      "code" : "7242.007",
      "display" : "Electronic Adjuster",
      "definition" : "Electronic Adjuster"
    },
    {
      "code" : "7242.008",
      "display" : "Electronic Fitter",
      "definition" : "Electronic Fitter"
    },
    {
      "code" : "7242.009",
      "display" : "Electronic Serviceman",
      "definition" : "Electronic Serviceman"
    },
    {
      "code" : "7242.010",
      "display" : "Electronic Signal Adjuster Fitter",
      "definition" : "Electronic Signal Adjuster Fitter"
    },
    {
      "code" : "7242.011",
      "display" : "Electronics Serviceperson",
      "definition" : "Electronics Serviceperson"
    },
    {
      "code" : "7242.012",
      "display" : "Industrial Electronics Repairer",
      "definition" : "Industrial Electronics Repairer"
    },
    {
      "code" : "7242.013",
      "display" : "Office Machinery Mechanic",
      "definition" : "Office Machinery Mechanic"
    },
    {
      "code" : "7242.014",
      "display" : "Photocopier Technician",
      "definition" : "Photocopier Technician"
    },
    {
      "code" : "7242.015",
      "display" : "Photocopying Machine Mechanic",
      "definition" : "Photocopying Machine Mechanic"
    },
    {
      "code" : "7242.016",
      "display" : "Reprographic Machine Mechanic",
      "definition" : "Reprographic Machine Mechanic"
    },
    {
      "code" : "7242.017",
      "display" : "Security Systems Fitter",
      "definition" : "Security Systems Fitter"
    },
    {
      "code" : "7242.018",
      "display" : "Security Systems Installer",
      "definition" : "Security Systems Installer"
    },
    {
      "code" : "7242.019",
      "display" : "Typewriter Serviceman Mechanic",
      "definition" : "Typewriter Serviceman Mechanic"
    },
    {
      "code" : "7243.001",
      "display" : "Aerial Erector Radio Television",
      "definition" : "Aerial Erector Radio Television"
    },
    {
      "code" : "7243.002",
      "display" : "Aerial Installer",
      "definition" : "Aerial Installer"
    },
    {
      "code" : "7243.003",
      "display" : "Radar Fitter and Repairer",
      "definition" : "Radar Fitter and Repairer"
    },
    {
      "code" : "7243.004",
      "display" : "Radio and Television Fitter",
      "definition" : "Radio and Television Fitter"
    },
    {
      "code" : "7243.005",
      "display" : "Radio and Television Repairer",
      "definition" : "Radio and Television Repairer"
    },
    {
      "code" : "7243.006",
      "display" : "Rigger Television Repairer",
      "definition" : "Rigger Television Repairer"
    },
    {
      "code" : "7243.007",
      "display" : "Televions or Audio Equipment Repairer",
      "definition" : "Televions or Audio Equipment Repairer"
    },
    {
      "code" : "7243.008",
      "display" : "Television Serviceman",
      "definition" : "Television Serviceman"
    },
    {
      "code" : "7243.009",
      "display" : "Television Technician Repair",
      "definition" : "Television Technician Repair"
    },
    {
      "code" : "7243.010",
      "display" : "TV Repairman",
      "definition" : "TV Repairman"
    },
    {
      "code" : "7311.001",
      "display" : "Camera Repairer",
      "definition" : "Camera Repairer"
    },
    {
      "code" : "7311.002",
      "display" : "Camera Repairman",
      "definition" : "Camera Repairman"
    },
    {
      "code" : "7311.003",
      "display" : "Clock Maker",
      "definition" : "Clock Maker"
    },
    {
      "code" : "7311.004",
      "display" : "Gunsmith",
      "definition" : "Gunsmith"
    },
    {
      "code" : "7311.005",
      "display" : "Horologist",
      "definition" : "Horologist"
    },
    {
      "code" : "7311.006",
      "display" : "Industrial Instrument Maker",
      "definition" : "Industrial Instrument Maker"
    },
    {
      "code" : "7311.007",
      "display" : "Industrial Instrument Repairer",
      "definition" : "Industrial Instrument Repairer"
    },
    {
      "code" : "7311.008",
      "display" : "Industrial Instrument Serviceman",
      "definition" : "Industrial Instrument Serviceman"
    },
    {
      "code" : "7311.009",
      "display" : "Industrial Precision Instrument Maker Repairer",
      "definition" : "Industrial Precision Instrument Maker Repairer"
    },
    {
      "code" : "7311.010",
      "display" : "Key Maker",
      "definition" : "Key Maker"
    },
    {
      "code" : "7311.011",
      "display" : "Locksmith",
      "definition" : "Locksmith"
    },
    {
      "code" : "7311.012",
      "display" : "Locksmiths Supervisor",
      "definition" : "Locksmiths Supervisor"
    },
    {
      "code" : "7311.013",
      "display" : "Medical Instrument Repairer",
      "definition" : "Medical Instrument Repairer"
    },
    {
      "code" : "7311.014",
      "display" : "Optical Glass Cutter",
      "definition" : "Optical Glass Cutter"
    },
    {
      "code" : "7311.015",
      "display" : "Optical Glass Grinder",
      "definition" : "Optical Glass Grinder"
    },
    {
      "code" : "7311.016",
      "display" : "Optical Glass Polisher",
      "definition" : "Optical Glass Polisher"
    },
    {
      "code" : "7311.017",
      "display" : "Optical Instrument Maker and Repairer",
      "definition" : "Optical Instrument Maker and Repairer"
    },
    {
      "code" : "7311.018",
      "display" : "Optical Instrument Repairer",
      "definition" : "Optical Instrument Repairer"
    },
    {
      "code" : "7311.019",
      "display" : "Optical Mechanic",
      "definition" : "Optical Mechanic"
    },
    {
      "code" : "7311.020",
      "display" : "Optical Technician",
      "definition" : "Optical Technician"
    },
    {
      "code" : "7311.021",
      "display" : "Photographic Equipment Assembler",
      "definition" : "Photographic Equipment Assembler"
    },
    {
      "code" : "7311.022",
      "display" : "Photographic Equipment Mechanic",
      "definition" : "Photographic Equipment Mechanic"
    },
    {
      "code" : "7311.023",
      "display" : "Precision Instrument Maker",
      "definition" : "Precision Instrument Maker"
    },
    {
      "code" : "7311.024",
      "display" : "Precision Instrument Maker Repairer Supervisor",
      "definition" : "Precision Instrument Maker Repairer Supervisor"
    },
    {
      "code" : "7311.025",
      "display" : "Precision Instrument Repairer",
      "definition" : "Precision Instrument Repairer"
    },
    {
      "code" : "7311.026",
      "display" : "Quality Controller Of Locksmiths",
      "definition" : "Quality Controller Of Locksmiths"
    },
    {
      "code" : "7311.027",
      "display" : "Scale Mechanic Weights and Measures",
      "definition" : "Scale Mechanic Weights and Measures"
    },
    {
      "code" : "7311.028",
      "display" : "Scientific Instrument Repairer",
      "definition" : "Scientific Instrument Repairer"
    },
    {
      "code" : "7311.029",
      "display" : "Surgical Instrument Maker",
      "definition" : "Surgical Instrument Maker"
    },
    {
      "code" : "7311.030",
      "display" : "Survey Instrument Repairer",
      "definition" : "Survey Instrument Repairer"
    },
    {
      "code" : "7311.031",
      "display" : "Surveying Instrument Manufacturer",
      "definition" : "Surveying Instrument Manufacturer"
    },
    {
      "code" : "7311.032",
      "display" : "Watch Maker",
      "definition" : "Watch Maker"
    },
    {
      "code" : "7311.033",
      "display" : "Watch Repairer",
      "definition" : "Watch Repairer"
    },
    {
      "code" : "7311.034",
      "display" : "Watchmaker",
      "definition" : "Watchmaker"
    },
    {
      "code" : "7311.035",
      "display" : "Watchmaker and Repairer",
      "definition" : "Watchmaker and Repairer"
    },
    {
      "code" : "7312.001",
      "display" : "Musical Instrument Maker",
      "definition" : "Musical Instrument Maker"
    },
    {
      "code" : "7312.002",
      "display" : "Musical Instrument Repairer",
      "definition" : "Musical Instrument Repairer"
    },
    {
      "code" : "7312.003",
      "display" : "Musical Instrument Tuner",
      "definition" : "Musical Instrument Tuner"
    },
    {
      "code" : "7312.004",
      "display" : "Piano Tuner",
      "definition" : "Piano Tuner"
    },
    {
      "code" : "7313.001",
      "display" : "Faceter",
      "definition" : "Faceter"
    },
    {
      "code" : "7313.002",
      "display" : "Gem Cutter",
      "definition" : "Gem Cutter"
    },
    {
      "code" : "7313.003",
      "display" : "Gem Cutter and Polisher",
      "definition" : "Gem Cutter and Polisher"
    },
    {
      "code" : "7313.004",
      "display" : "Gem Polisher",
      "definition" : "Gem Polisher"
    },
    {
      "code" : "7313.005",
      "display" : "Gem Setter",
      "definition" : "Gem Setter"
    },
    {
      "code" : "7313.006",
      "display" : "Goldsmith",
      "definition" : "Goldsmith"
    },
    {
      "code" : "7313.007",
      "display" : "Greenstone Worker",
      "definition" : "Greenstone Worker"
    },
    {
      "code" : "7313.008",
      "display" : "Jade Worker",
      "definition" : "Jade Worker"
    },
    {
      "code" : "7313.009",
      "display" : "Jeweller",
      "definition" : "Jeweller"
    },
    {
      "code" : "7313.010",
      "display" : "Jewellery Engraver",
      "definition" : "Jewellery Engraver"
    },
    {
      "code" : "7313.011",
      "display" : "Jewellery Form Caster",
      "definition" : "Jewellery Form Caster"
    },
    {
      "code" : "7313.012",
      "display" : "Jewellery Manufacturer",
      "definition" : "Jewellery Manufacturer"
    },
    {
      "code" : "7313.013",
      "display" : "Jewellery Repairer",
      "definition" : "Jewellery Repairer"
    },
    {
      "code" : "7313.014",
      "display" : "Jewellery Worker",
      "definition" : "Jewellery Worker"
    },
    {
      "code" : "7313.015",
      "display" : "Lapidary",
      "definition" : "Lapidary"
    },
    {
      "code" : "7313.016",
      "display" : "Manufacturing Jeweller",
      "definition" : "Manufacturing Jeweller"
    },
    {
      "code" : "7313.017",
      "display" : "Paua Shell Cutter Polisher",
      "definition" : "Paua Shell Cutter Polisher"
    },
    {
      "code" : "7313.018",
      "display" : "Precious Metal Cutter",
      "definition" : "Precious Metal Cutter"
    },
    {
      "code" : "7313.019",
      "display" : "Quality Controller Of Gem Cutter And Polishers",
      "definition" : "Quality Controller Of Gem Cutter And Polishers"
    },
    {
      "code" : "7313.020",
      "display" : "Quality Controller Of Jeweller And Jewellery Workers",
      "definition" : "Quality Controller Of Jeweller And Jewellery Workers"
    },
    {
      "code" : "7313.021",
      "display" : "Silversmith",
      "definition" : "Silversmith"
    },
    {
      "code" : "7321.001",
      "display" : "Glass Beveller",
      "definition" : "Glass Beveller"
    },
    {
      "code" : "7321.002",
      "display" : "Glass Cutter",
      "definition" : "Glass Cutter"
    },
    {
      "code" : "7321.003",
      "display" : "Glass Cutter and Beveller",
      "definition" : "Glass Cutter and Beveller"
    },
    {
      "code" : "7321.004",
      "display" : "Glass Engraver",
      "definition" : "Glass Engraver"
    },
    {
      "code" : "7321.005",
      "display" : "Glass Etcher",
      "definition" : "Glass Etcher"
    },
    {
      "code" : "7321.006",
      "display" : "Glass Finisher",
      "definition" : "Glass Finisher"
    },
    {
      "code" : "7321.007",
      "display" : "Glass Sandblaster",
      "definition" : "Glass Sandblaster"
    },
    {
      "code" : "7321.008",
      "display" : "Lens Glass Moulder",
      "definition" : "Lens Glass Moulder"
    },
    {
      "code" : "7321.009",
      "display" : "Lens Grinding Machine Operator",
      "definition" : "Lens Grinding Machine Operator"
    },
    {
      "code" : "7321.010",
      "display" : "Lens Polishing Machine Operator",
      "definition" : "Lens Polishing Machine Operator"
    },
    {
      "code" : "7321.011",
      "display" : "Quality Controller Of Glass Cutter And Bevellers",
      "definition" : "Quality Controller Of Glass Cutter And Bevellers"
    },
    {
      "code" : "7321.012",
      "display" : "Slitter Optical Glass",
      "definition" : "Slitter Optical Glass"
    },
    {
      "code" : "7331.001",
      "display" : "Balloon Printer",
      "definition" : "Balloon Printer"
    },
    {
      "code" : "7331.002",
      "display" : "Block Engraver Maker Printing",
      "definition" : "Block Engraver Maker Printing"
    },
    {
      "code" : "7331.003",
      "display" : "Block Printer",
      "definition" : "Block Printer"
    },
    {
      "code" : "7331.004",
      "display" : "Carton Printer",
      "definition" : "Carton Printer"
    },
    {
      "code" : "7331.005",
      "display" : "Compositor",
      "definition" : "Compositor"
    },
    {
      "code" : "7331.006",
      "display" : "Computer Typesetter",
      "definition" : "Computer Typesetter"
    },
    {
      "code" : "7331.007",
      "display" : "Desktop Publisher",
      "definition" : "Desktop Publisher"
    },
    {
      "code" : "7331.008",
      "display" : "Electrotyper",
      "definition" : "Electrotyper"
    },
    {
      "code" : "7331.009",
      "display" : "Engraver Machine Operator Signs",
      "definition" : "Engraver Machine Operator Signs"
    },
    {
      "code" : "7331.010",
      "display" : "Feeder Printing Press Supervisor",
      "definition" : "Feeder Printing Press Supervisor"
    },
    {
      "code" : "7331.011",
      "display" : "Flexographic Printer",
      "definition" : "Flexographic Printer"
    },
    {
      "code" : "7331.012",
      "display" : "Flyer Flyhand Printing",
      "definition" : "Flyer Flyhand Printing"
    },
    {
      "code" : "7331.013",
      "display" : "Graphic Pre-Press Tradesperson",
      "definition" : "Graphic Pre-Press Tradesperson"
    },
    {
      "code" : "7331.014",
      "display" : "Gravure Printer",
      "definition" : "Gravure Printer"
    },
    {
      "code" : "7331.015",
      "display" : "Hot Metal Compositor",
      "definition" : "Hot Metal Compositor"
    },
    {
      "code" : "7331.016",
      "display" : "Intertype Operator",
      "definition" : "Intertype Operator"
    },
    {
      "code" : "7331.017",
      "display" : "Jobbing Printer",
      "definition" : "Jobbing Printer"
    },
    {
      "code" : "7331.018",
      "display" : "Letter Press Printer",
      "definition" : "Letter Press Printer"
    },
    {
      "code" : "7331.019",
      "display" : "Letterpress Machine Printer",
      "definition" : "Letterpress Machine Printer"
    },
    {
      "code" : "7331.020",
      "display" : "Letterpress Machine Supervisor",
      "definition" : "Letterpress Machine Supervisor"
    },
    {
      "code" : "7331.021",
      "display" : "Letterpress Machinist",
      "definition" : "Letterpress Machinist"
    },
    {
      "code" : "7331.022",
      "display" : "Letterpress Printer",
      "definition" : "Letterpress Printer"
    },
    {
      "code" : "7331.023",
      "display" : "Litho Carton Printer",
      "definition" : "Litho Carton Printer"
    },
    {
      "code" : "7331.024",
      "display" : "Lithographic Machinist",
      "definition" : "Lithographic Machinist"
    },
    {
      "code" : "7331.025",
      "display" : "Lithographic Plate Stone Engraver",
      "definition" : "Lithographic Plate Stone Engraver"
    },
    {
      "code" : "7331.026",
      "display" : "Lithographic Plate Stone Maker polisher",
      "definition" : "Lithographic Plate Stone Maker polisher"
    },
    {
      "code" : "7331.027",
      "display" : "Offset Duplicator",
      "definition" : "Offset Duplicator"
    },
    {
      "code" : "7331.028",
      "display" : "Offset Machinist",
      "definition" : "Offset Machinist"
    },
    {
      "code" : "7331.029",
      "display" : "Offset Pressman",
      "definition" : "Offset Pressman"
    },
    {
      "code" : "7331.030",
      "display" : "Offset Printer",
      "definition" : "Offset Printer"
    },
    {
      "code" : "7331.031",
      "display" : "Paperboard Packaging Printer",
      "definition" : "Paperboard Packaging Printer"
    },
    {
      "code" : "7331.032",
      "display" : "Photo Typesetting Machine Operator",
      "definition" : "Photo Typesetting Machine Operator"
    },
    {
      "code" : "7331.033",
      "display" : "Printer",
      "definition" : "Printer"
    },
    {
      "code" : "7331.034",
      "display" : "Printer Wallpaper",
      "definition" : "Printer Wallpaper"
    },
    {
      "code" : "7331.035",
      "display" : "Printing and Publishing Production Supervisor",
      "definition" : "Printing and Publishing Production Supervisor"
    },
    {
      "code" : "7331.036",
      "display" : "Printing Founder",
      "definition" : "Printing Founder"
    },
    {
      "code" : "7331.037",
      "display" : "Printing Imposer",
      "definition" : "Printing Imposer"
    },
    {
      "code" : "7331.038",
      "display" : "Printing Machine Operator",
      "definition" : "Printing Machine Operator"
    },
    {
      "code" : "7331.039",
      "display" : "Printing Machinist",
      "definition" : "Printing Machinist"
    },
    {
      "code" : "7331.040",
      "display" : "Printing Press Feeder",
      "definition" : "Printing Press Feeder"
    },
    {
      "code" : "7331.041",
      "display" : "Printing Supervisor",
      "definition" : "Printing Supervisor"
    },
    {
      "code" : "7331.042",
      "display" : "Printing Typesetter",
      "definition" : "Printing Typesetter"
    },
    {
      "code" : "7331.043",
      "display" : "Printing Worker",
      "definition" : "Printing Worker"
    },
    {
      "code" : "7331.044",
      "display" : "Quality Controller Of Screen Printers",
      "definition" : "Quality Controller Of Screen Printers"
    },
    {
      "code" : "7331.045",
      "display" : "Reel Fed Machine Supervisor",
      "definition" : "Reel Fed Machine Supervisor"
    },
    {
      "code" : "7331.046",
      "display" : "Reel-Fed Machinist",
      "definition" : "Reel-Fed Machinist"
    },
    {
      "code" : "7331.047",
      "display" : "Roll Winder",
      "definition" : "Roll Winder"
    },
    {
      "code" : "7331.048",
      "display" : "Rotary Machinist",
      "definition" : "Rotary Machinist"
    },
    {
      "code" : "7331.049",
      "display" : "Rotary Press Operator",
      "definition" : "Rotary Press Operator"
    },
    {
      "code" : "7331.050",
      "display" : "Screen Printer",
      "definition" : "Screen Printer"
    },
    {
      "code" : "7331.051",
      "display" : "Screen Printing Supervisor",
      "definition" : "Screen Printing Supervisor"
    },
    {
      "code" : "7331.052",
      "display" : "Screener",
      "definition" : "Screener"
    },
    {
      "code" : "7331.053",
      "display" : "Screenprinter",
      "definition" : "Screenprinter"
    },
    {
      "code" : "7331.054",
      "display" : "Screenprinting Supervisor",
      "definition" : "Screenprinting Supervisor"
    },
    {
      "code" : "7331.055",
      "display" : "Sheet Fed Machine Supervisor",
      "definition" : "Sheet Fed Machine Supervisor"
    },
    {
      "code" : "7331.056",
      "display" : "Sheet Fed Machinist",
      "definition" : "Sheet Fed Machinist"
    },
    {
      "code" : "7331.057",
      "display" : "Sheet Fed Printer",
      "definition" : "Sheet Fed Printer"
    },
    {
      "code" : "7331.058",
      "display" : "Silk Screen Printer",
      "definition" : "Silk Screen Printer"
    },
    {
      "code" : "7331.059",
      "display" : "Stencil Cutter Screen Printing",
      "definition" : "Stencil Cutter Screen Printing"
    },
    {
      "code" : "7331.060",
      "display" : "Stereotyper",
      "definition" : "Stereotyper"
    },
    {
      "code" : "7331.061",
      "display" : "T Shirt Printer",
      "definition" : "T Shirt Printer"
    },
    {
      "code" : "7331.062",
      "display" : "Template Printer",
      "definition" : "Template Printer"
    },
    {
      "code" : "7331.063",
      "display" : "Type Operator",
      "definition" : "Type Operator"
    },
    {
      "code" : "7331.064",
      "display" : "Typecaster Metal",
      "definition" : "Typecaster Metal"
    },
    {
      "code" : "7331.065",
      "display" : "Typecasting Machine Operator",
      "definition" : "Typecasting Machine Operator"
    },
    {
      "code" : "7331.066",
      "display" : "Typesetter",
      "definition" : "Typesetter"
    },
    {
      "code" : "7331.067",
      "display" : "Typesetter and Compositor",
      "definition" : "Typesetter and Compositor"
    },
    {
      "code" : "7331.068",
      "display" : "Typesetter Linotype",
      "definition" : "Typesetter Linotype"
    },
    {
      "code" : "7331.069",
      "display" : "Typesetting and Compositing Supervisor",
      "definition" : "Typesetting and Compositing Supervisor"
    },
    {
      "code" : "7331.070",
      "display" : "Typographer",
      "definition" : "Typographer"
    },
    {
      "code" : "7332.001",
      "display" : "Binder",
      "definition" : "Binder"
    },
    {
      "code" : "7332.002",
      "display" : "Bindery Worker",
      "definition" : "Bindery Worker"
    },
    {
      "code" : "7332.003",
      "display" : "Binding Assistant Worker",
      "definition" : "Binding Assistant Worker"
    },
    {
      "code" : "7332.004",
      "display" : "Book Binder",
      "definition" : "Book Binder"
    },
    {
      "code" : "7332.005",
      "display" : "Book Binding Supervisor",
      "definition" : "Book Binding Supervisor"
    },
    {
      "code" : "7332.006",
      "display" : "Book Embosser",
      "definition" : "Book Embosser"
    },
    {
      "code" : "7332.007",
      "display" : "Book Finisher",
      "definition" : "Book Finisher"
    },
    {
      "code" : "7332.008",
      "display" : "Book Repairer",
      "definition" : "Book Repairer"
    },
    {
      "code" : "7332.009",
      "display" : "Bookbinder",
      "definition" : "Bookbinder"
    },
    {
      "code" : "7332.010",
      "display" : "Bookbinder Machinist",
      "definition" : "Bookbinder Machinist"
    },
    {
      "code" : "7332.011",
      "display" : "Bookbinding Supervisor",
      "definition" : "Bookbinding Supervisor"
    },
    {
      "code" : "7332.012",
      "display" : "Paper Embosser",
      "definition" : "Paper Embosser"
    },
    {
      "code" : "7333.001",
      "display" : "Camera Operator Printing",
      "definition" : "Camera Operator Printing"
    },
    {
      "code" : "7333.002",
      "display" : "Cameraman Photogravure",
      "definition" : "Cameraman Photogravure"
    },
    {
      "code" : "7333.003",
      "display" : "Graphic Photoprocessor",
      "definition" : "Graphic Photoprocessor"
    },
    {
      "code" : "7333.004",
      "display" : "Metal Engraver Etcher Printing",
      "definition" : "Metal Engraver Etcher Printing"
    },
    {
      "code" : "7333.005",
      "display" : "Photo Engraver",
      "definition" : "Photo Engraver"
    },
    {
      "code" : "7333.006",
      "display" : "Photo Lithographer",
      "definition" : "Photo Lithographer"
    },
    {
      "code" : "7333.007",
      "display" : "Photo Mechanical Cameraman Printing",
      "definition" : "Photo Mechanical Cameraman Printing"
    },
    {
      "code" : "7333.008",
      "display" : "Photo Mounter Router Printing",
      "definition" : "Photo Mounter Router Printing"
    },
    {
      "code" : "7333.009",
      "display" : "Photo Retoucher",
      "definition" : "Photo Retoucher"
    },
    {
      "code" : "7333.010",
      "display" : "Photoengraver",
      "definition" : "Photoengraver"
    },
    {
      "code" : "7333.011",
      "display" : "Photographic Etcher",
      "definition" : "Photographic Etcher"
    },
    {
      "code" : "7333.012",
      "display" : "Photolithographer",
      "definition" : "Photolithographer"
    },
    {
      "code" : "7333.013",
      "display" : "Printing Process Engraver Etcher",
      "definition" : "Printing Process Engraver Etcher"
    },
    {
      "code" : "7411.001",
      "display" : "Butcher",
      "definition" : "Butcher"
    },
    {
      "code" : "7411.002",
      "display" : "Butcher Wholesale and Retail",
      "definition" : "Butcher Wholesale and Retail"
    },
    {
      "code" : "7411.003",
      "display" : "Kaihoko Miiti",
      "definition" : "Kaihoko Miiti"
    },
    {
      "code" : "7411.004",
      "display" : "Kaihoko Miti",
      "definition" : "Kaihoko Miti"
    },
    {
      "code" : "7411.005",
      "display" : "Kaitapahi Miiti",
      "definition" : "Kaitapahi Miiti"
    },
    {
      "code" : "7411.006",
      "display" : "Kaitapahi Miti",
      "definition" : "Kaitapahi Miti"
    },
    {
      "code" : "7411.007",
      "display" : "Meat Grader",
      "definition" : "Meat Grader"
    },
    {
      "code" : "7411.008",
      "display" : "Putia",
      "definition" : "Putia"
    },
    {
      "code" : "7411.009",
      "display" : "Puutia",
      "definition" : "Puutia"
    },
    {
      "code" : "7412.001",
      "display" : "Baker",
      "definition" : "Baker"
    },
    {
      "code" : "7412.002",
      "display" : "Baker Cake Pastry",
      "definition" : "Baker Cake Pastry"
    },
    {
      "code" : "7412.003",
      "display" : "Biscuit Maker",
      "definition" : "Biscuit Maker"
    },
    {
      "code" : "7412.004",
      "display" : "Bread Baker",
      "definition" : "Bread Baker"
    },
    {
      "code" : "7412.005",
      "display" : "Cake Decorator",
      "definition" : "Cake Decorator"
    },
    {
      "code" : "7412.006",
      "display" : "Cake Decorator or Finisher",
      "definition" : "Cake Decorator or Finisher"
    },
    {
      "code" : "7412.007",
      "display" : "Cake Maker",
      "definition" : "Cake Maker"
    },
    {
      "code" : "7412.008",
      "display" : "Food Cake Decorator Finisher",
      "definition" : "Food Cake Decorator Finisher"
    },
    {
      "code" : "7412.009",
      "display" : "Kaitaka Paraoa",
      "definition" : "Kaitaka Paraoa"
    },
    {
      "code" : "7412.010",
      "display" : "Kaiwhakamaoa Paraoa",
      "definition" : "Kaiwhakamaoa Paraoa"
    },
    {
      "code" : "7412.011",
      "display" : "Pastry Cook",
      "definition" : "Pastry Cook"
    },
    {
      "code" : "7412.012",
      "display" : "Pastrycook",
      "definition" : "Pastrycook"
    },
    {
      "code" : "7412.013",
      "display" : "Pastrycook Cake Maker",
      "definition" : "Pastrycook Cake Maker"
    },
    {
      "code" : "7412.014",
      "display" : "Quality Controller Of Bakers",
      "definition" : "Quality Controller Of Bakers"
    },
    {
      "code" : "7412.015",
      "display" : "Tangata Mahi Paraoa",
      "definition" : "Tangata Mahi Paraoa"
    },
    {
      "code" : "7421.001",
      "display" : "Antique Furniture Restorer",
      "definition" : "Antique Furniture Restorer"
    },
    {
      "code" : "7421.002",
      "display" : "Antique Restorer Wooden",
      "definition" : "Antique Restorer Wooden"
    },
    {
      "code" : "7421.003",
      "display" : "Architects Model Maker",
      "definition" : "Architects Model Maker"
    },
    {
      "code" : "7421.004",
      "display" : "Cabinet Maker",
      "definition" : "Cabinet Maker"
    },
    {
      "code" : "7421.005",
      "display" : "Cabinet Making Supervisor",
      "definition" : "Cabinet Making Supervisor"
    },
    {
      "code" : "7421.006",
      "display" : "Cabinetmaker",
      "definition" : "Cabinetmaker"
    },
    {
      "code" : "7421.007",
      "display" : "Chair Maker",
      "definition" : "Chair Maker"
    },
    {
      "code" : "7421.008",
      "display" : "Coffin Maker",
      "definition" : "Coffin Maker"
    },
    {
      "code" : "7421.009",
      "display" : "Cooper",
      "definition" : "Cooper"
    },
    {
      "code" : "7421.010",
      "display" : "French Polisher",
      "definition" : "French Polisher"
    },
    {
      "code" : "7421.011",
      "display" : "Furniture Finisher",
      "definition" : "Furniture Finisher"
    },
    {
      "code" : "7421.012",
      "display" : "Furniture Maker Wood",
      "definition" : "Furniture Maker Wood"
    },
    {
      "code" : "7421.013",
      "display" : "Furniture Polisher",
      "definition" : "Furniture Polisher"
    },
    {
      "code" : "7421.014",
      "display" : "Furniture Restorer",
      "definition" : "Furniture Restorer"
    },
    {
      "code" : "7421.015",
      "display" : "Marquetry Inlayer",
      "definition" : "Marquetry Inlayer"
    },
    {
      "code" : "7421.016",
      "display" : "Model Maker Wood",
      "definition" : "Model Maker Wood"
    },
    {
      "code" : "7421.017",
      "display" : "Overseer Wood Joinery Furniture",
      "definition" : "Overseer Wood Joinery Furniture"
    },
    {
      "code" : "7421.018",
      "display" : "Parquetry Worker",
      "definition" : "Parquetry Worker"
    },
    {
      "code" : "7421.019",
      "display" : "Picture Framer",
      "definition" : "Picture Framer"
    },
    {
      "code" : "7421.020",
      "display" : "Production Chargehand Wood Joinery Furniture",
      "definition" : "Production Chargehand Wood Joinery Furniture"
    },
    {
      "code" : "7421.021",
      "display" : "Quality Controller Of Cabinet Makers",
      "definition" : "Quality Controller Of Cabinet Makers"
    },
    {
      "code" : "7421.022",
      "display" : "Spray Polisher Wood",
      "definition" : "Spray Polisher Wood"
    },
    {
      "code" : "7421.023",
      "display" : "Veneer Worker",
      "definition" : "Veneer Worker"
    },
    {
      "code" : "7421.024",
      "display" : "Wheelwright",
      "definition" : "Wheelwright"
    },
    {
      "code" : "7421.025",
      "display" : "Wood Bender",
      "definition" : "Wood Bender"
    },
    {
      "code" : "7421.026",
      "display" : "Wooden Pattern Maker",
      "definition" : "Wooden Pattern Maker"
    },
    {
      "code" : "7421.027",
      "display" : "Woodwork Instructor",
      "definition" : "Woodwork Instructor"
    },
    {
      "code" : "7431.001",
      "display" : "Bespoke Tailor",
      "definition" : "Bespoke Tailor"
    },
    {
      "code" : "7431.002",
      "display" : "Boutique Dressmaker",
      "definition" : "Boutique Dressmaker"
    },
    {
      "code" : "7431.003",
      "display" : "Chart Cutter",
      "definition" : "Chart Cutter"
    },
    {
      "code" : "7431.004",
      "display" : "Clothing Cutter",
      "definition" : "Clothing Cutter"
    },
    {
      "code" : "7431.005",
      "display" : "Coat Hand",
      "definition" : "Coat Hand"
    },
    {
      "code" : "7431.006",
      "display" : "Corset and Foundations Corsetiere",
      "definition" : "Corset and Foundations Corsetiere"
    },
    {
      "code" : "7431.007",
      "display" : "Cutter Fur",
      "definition" : "Cutter Fur"
    },
    {
      "code" : "7431.008",
      "display" : "Dress Maker",
      "definition" : "Dress Maker"
    },
    {
      "code" : "7431.009",
      "display" : "Dressmaker",
      "definition" : "Dressmaker"
    },
    {
      "code" : "7431.010",
      "display" : "Fabric Cutter",
      "definition" : "Fabric Cutter"
    },
    {
      "code" : "7431.011",
      "display" : "Fur Grader",
      "definition" : "Fur Grader"
    },
    {
      "code" : "7431.012",
      "display" : "Fur Tailor",
      "definition" : "Fur Tailor"
    },
    {
      "code" : "7431.013",
      "display" : "Furrier",
      "definition" : "Furrier"
    },
    {
      "code" : "7431.014",
      "display" : "Garment Cutter",
      "definition" : "Garment Cutter"
    },
    {
      "code" : "7431.015",
      "display" : "Garment Maker",
      "definition" : "Garment Maker"
    },
    {
      "code" : "7431.016",
      "display" : "Garment Marker",
      "definition" : "Garment Marker"
    },
    {
      "code" : "7431.017",
      "display" : "Garment Pattern Cutter",
      "definition" : "Garment Pattern Cutter"
    },
    {
      "code" : "7431.018",
      "display" : "Garment Pattern Maker",
      "definition" : "Garment Pattern Maker"
    },
    {
      "code" : "7431.019",
      "display" : "Glove Cutter",
      "definition" : "Glove Cutter"
    },
    {
      "code" : "7431.020",
      "display" : "Glove Maker Fabric",
      "definition" : "Glove Maker Fabric"
    },
    {
      "code" : "7431.021",
      "display" : "Leather Chart Cutter",
      "definition" : "Leather Chart Cutter"
    },
    {
      "code" : "7431.022",
      "display" : "Leather Garment Cutter",
      "definition" : "Leather Garment Cutter"
    },
    {
      "code" : "7431.023",
      "display" : "Lingerie Maker",
      "definition" : "Lingerie Maker"
    },
    {
      "code" : "7431.024",
      "display" : "Quality Controller Of Textile Products Marker",
      "definition" : "Quality Controller Of Textile Products Marker"
    },
    {
      "code" : "7431.025",
      "display" : "Sewer Fur",
      "definition" : "Sewer Fur"
    },
    {
      "code" : "7431.026",
      "display" : "Shirt Maker",
      "definition" : "Shirt Maker"
    },
    {
      "code" : "7431.027",
      "display" : "Tailor",
      "definition" : "Tailor"
    },
    {
      "code" : "7431.028",
      "display" : "Tailors Trimmer",
      "definition" : "Tailors Trimmer"
    },
    {
      "code" : "7431.029",
      "display" : "Textile Products Cutter",
      "definition" : "Textile Products Cutter"
    },
    {
      "code" : "7431.030",
      "display" : "Textile Products Cutting Worker",
      "definition" : "Textile Products Cutting Worker"
    },
    {
      "code" : "7431.031",
      "display" : "Textile Products Maker",
      "definition" : "Textile Products Maker"
    },
    {
      "code" : "7431.032",
      "display" : "Textile Products Marker and Cutter",
      "definition" : "Textile Products Marker and Cutter"
    },
    {
      "code" : "7431.033",
      "display" : "Textile Products Marking Worker",
      "definition" : "Textile Products Marking Worker"
    },
    {
      "code" : "7431.034",
      "display" : "Textile Products Pattern Maker",
      "definition" : "Textile Products Pattern Maker"
    },
    {
      "code" : "7431.035",
      "display" : "Tie Maker",
      "definition" : "Tie Maker"
    },
    {
      "code" : "7431.036",
      "display" : "Trouser Hand",
      "definition" : "Trouser Hand"
    },
    {
      "code" : "7431.037",
      "display" : "Upholsterer Pattern Maker",
      "definition" : "Upholsterer Pattern Maker"
    },
    {
      "code" : "7431.038",
      "display" : "Upholstery Pattern Maker",
      "definition" : "Upholstery Pattern Maker"
    },
    {
      "code" : "7431.039",
      "display" : "Vest Hand",
      "definition" : "Vest Hand"
    },
    {
      "code" : "7431.040",
      "display" : "Viewer Clothing Factory",
      "definition" : "Viewer Clothing Factory"
    },
    {
      "code" : "7431.041",
      "display" : "Wardrobe Assistant",
      "definition" : "Wardrobe Assistant"
    },
    {
      "code" : "7431.042",
      "display" : "Wardrobe Mistress",
      "definition" : "Wardrobe Mistress"
    },
    {
      "code" : "7432.001",
      "display" : "Automobile Upholsterer",
      "definition" : "Automobile Upholsterer"
    },
    {
      "code" : "7432.002",
      "display" : "Awning Maker",
      "definition" : "Awning Maker"
    },
    {
      "code" : "7432.003",
      "display" : "Blind Maker and Installer not Venetian",
      "definition" : "Blind Maker and Installer not Venetian"
    },
    {
      "code" : "7432.004",
      "display" : "Blind Maker not Venetian",
      "definition" : "Blind Maker not Venetian"
    },
    {
      "code" : "7432.005",
      "display" : "Canvas Awning Installer",
      "definition" : "Canvas Awning Installer"
    },
    {
      "code" : "7432.006",
      "display" : "Canvas Upholstery Cutter",
      "definition" : "Canvas Upholstery Cutter"
    },
    {
      "code" : "7432.007",
      "display" : "Canvas Worker",
      "definition" : "Canvas Worker"
    },
    {
      "code" : "7432.008",
      "display" : "Canvas Worker Supervisor",
      "definition" : "Canvas Worker Supervisor"
    },
    {
      "code" : "7432.009",
      "display" : "Car Coach Trimmer",
      "definition" : "Car Coach Trimmer"
    },
    {
      "code" : "7432.010",
      "display" : "Car Coach Upholsterer",
      "definition" : "Car Coach Upholsterer"
    },
    {
      "code" : "7432.011",
      "display" : "Car Trimmer",
      "definition" : "Car Trimmer"
    },
    {
      "code" : "7432.012",
      "display" : "Car Upholsterer",
      "definition" : "Car Upholsterer"
    },
    {
      "code" : "7432.013",
      "display" : "Chair Upholsterer",
      "definition" : "Chair Upholsterer"
    },
    {
      "code" : "7432.014",
      "display" : "Furniture Trimmer",
      "definition" : "Furniture Trimmer"
    },
    {
      "code" : "7432.015",
      "display" : "Furniture Upholsterer",
      "definition" : "Furniture Upholsterer"
    },
    {
      "code" : "7432.016",
      "display" : "Horsehair Worker",
      "definition" : "Horsehair Worker"
    },
    {
      "code" : "7432.017",
      "display" : "Mattress Maker",
      "definition" : "Mattress Maker"
    },
    {
      "code" : "7432.018",
      "display" : "Mattress Maker Worker",
      "definition" : "Mattress Maker Worker"
    },
    {
      "code" : "7432.019",
      "display" : "Mattress Sewer",
      "definition" : "Mattress Sewer"
    },
    {
      "code" : "7432.020",
      "display" : "Motor Trimmer",
      "definition" : "Motor Trimmer"
    },
    {
      "code" : "7432.021",
      "display" : "Quality Controller Of Canvas Workers",
      "definition" : "Quality Controller Of Canvas Workers"
    },
    {
      "code" : "7432.022",
      "display" : "Quality Controller Of Furniture Upholsterers",
      "definition" : "Quality Controller Of Furniture Upholsterers"
    },
    {
      "code" : "7432.023",
      "display" : "Quality Controller Of Vehicle Upholsterer And Trimmer",
      "definition" : "Quality Controller Of Vehicle Upholsterer And Trimmer"
    },
    {
      "code" : "7432.024",
      "display" : "Soft Furnishing Upholsterer",
      "definition" : "Soft Furnishing Upholsterer"
    },
    {
      "code" : "7432.025",
      "display" : "Springerup Upholstery Mattresses",
      "definition" : "Springerup Upholstery Mattresses"
    },
    {
      "code" : "7432.026",
      "display" : "Tarpaulin Maker",
      "definition" : "Tarpaulin Maker"
    },
    {
      "code" : "7432.027",
      "display" : "Vehicle Trimmer",
      "definition" : "Vehicle Trimmer"
    },
    {
      "code" : "7432.028",
      "display" : "Vehicle Upholsterer",
      "definition" : "Vehicle Upholsterer"
    },
    {
      "code" : "7432.029",
      "display" : "Vehicle Upholsterer and Trimmer",
      "definition" : "Vehicle Upholsterer and Trimmer"
    },
    {
      "code" : "7432.030",
      "display" : "Wire Mattress Maker",
      "definition" : "Wire Mattress Maker"
    },
    {
      "code" : "7433.001",
      "display" : "Carpet and Other Floor Covering Layer",
      "definition" : "Carpet and Other Floor Covering Layer"
    },
    {
      "code" : "7433.002",
      "display" : "Carpet and Vinyl Layer",
      "definition" : "Carpet and Vinyl Layer"
    },
    {
      "code" : "7433.003",
      "display" : "Carpet Cutter",
      "definition" : "Carpet Cutter"
    },
    {
      "code" : "7433.004",
      "display" : "Carpet Installer",
      "definition" : "Carpet Installer"
    },
    {
      "code" : "7433.005",
      "display" : "Carpet Layer",
      "definition" : "Carpet Layer"
    },
    {
      "code" : "7433.006",
      "display" : "Carpet Layer Planner",
      "definition" : "Carpet Layer Planner"
    },
    {
      "code" : "7433.007",
      "display" : "Carpet Vinyl Fitter",
      "definition" : "Carpet Vinyl Fitter"
    },
    {
      "code" : "7433.008",
      "display" : "Floor Covering Installer",
      "definition" : "Floor Covering Installer"
    },
    {
      "code" : "7433.009",
      "display" : "Floor Layer Parquetry",
      "definition" : "Floor Layer Parquetry"
    },
    {
      "code" : "7433.010",
      "display" : "Floor Sander",
      "definition" : "Floor Sander"
    },
    {
      "code" : "7433.011",
      "display" : "Flooring Contractor",
      "definition" : "Flooring Contractor"
    },
    {
      "code" : "7433.012",
      "display" : "Flooring Specialist",
      "definition" : "Flooring Specialist"
    },
    {
      "code" : "7433.013",
      "display" : "Floorsander",
      "definition" : "Floorsander"
    },
    {
      "code" : "7433.014",
      "display" : "Layer Flooring",
      "definition" : "Layer Flooring"
    },
    {
      "code" : "7433.015",
      "display" : "Layer Flooring Particle Board",
      "definition" : "Layer Flooring Particle Board"
    },
    {
      "code" : "7433.016",
      "display" : "Lino Layer",
      "definition" : "Lino Layer"
    },
    {
      "code" : "7433.017",
      "display" : "Linoleum Layer",
      "definition" : "Linoleum Layer"
    },
    {
      "code" : "7433.018",
      "display" : "Quality Controller of Carpet and Other Floor Layers",
      "definition" : "Quality Controller of Carpet and Other Floor Layers"
    },
    {
      "code" : "7433.019",
      "display" : "Vinyl Layer",
      "definition" : "Vinyl Layer"
    },
    {
      "code" : "7441.001",
      "display" : "Boot Repairer",
      "definition" : "Boot Repairer"
    },
    {
      "code" : "7441.002",
      "display" : "Cobbler",
      "definition" : "Cobbler"
    },
    {
      "code" : "7441.003",
      "display" : "Footwear Repairer",
      "definition" : "Footwear Repairer"
    },
    {
      "code" : "7441.004",
      "display" : "Quality Controller Of Shoe Repairers",
      "definition" : "Quality Controller Of Shoe Repairers"
    },
    {
      "code" : "7441.005",
      "display" : "Saddler and Harness Maker",
      "definition" : "Saddler and Harness Maker"
    },
    {
      "code" : "7441.006",
      "display" : "Shoe Repairer",
      "definition" : "Shoe Repairer"
    },
    {
      "code" : "8111.001",
      "display" : "Bentonite Miner Sluicer",
      "definition" : "Bentonite Miner Sluicer"
    },
    {
      "code" : "8111.002",
      "display" : "Building Stone Quarryman",
      "definition" : "Building Stone Quarryman"
    },
    {
      "code" : "8111.003",
      "display" : "Cement Clay Lime Quarryman",
      "definition" : "Cement Clay Lime Quarryman"
    },
    {
      "code" : "8111.004",
      "display" : "Coal Crushing Machine Operator",
      "definition" : "Coal Crushing Machine Operator"
    },
    {
      "code" : "8111.005",
      "display" : "Coal Hewer",
      "definition" : "Coal Hewer"
    },
    {
      "code" : "8111.006",
      "display" : "Coal Miner",
      "definition" : "Coal Miner"
    },
    {
      "code" : "8111.007",
      "display" : "Collier",
      "definition" : "Collier"
    },
    {
      "code" : "8111.008",
      "display" : "Copper Miner",
      "definition" : "Copper Miner"
    },
    {
      "code" : "8111.009",
      "display" : "Crusher Operator Minerals",
      "definition" : "Crusher Operator Minerals"
    },
    {
      "code" : "8111.010",
      "display" : "Gold Miner",
      "definition" : "Gold Miner"
    },
    {
      "code" : "8111.011",
      "display" : "Gravel Worker",
      "definition" : "Gravel Worker"
    },
    {
      "code" : "8111.012",
      "display" : "Marble Quarryman",
      "definition" : "Marble Quarryman"
    },
    {
      "code" : "8111.013",
      "display" : "Mine Driller",
      "definition" : "Mine Driller"
    },
    {
      "code" : "8111.014",
      "display" : "Mine Sampler",
      "definition" : "Mine Sampler"
    },
    {
      "code" : "8111.015",
      "display" : "Mine Worker",
      "definition" : "Mine Worker"
    },
    {
      "code" : "8111.016",
      "display" : "Miner",
      "definition" : "Miner"
    },
    {
      "code" : "8111.017",
      "display" : "Mining Blaster",
      "definition" : "Mining Blaster"
    },
    {
      "code" : "8111.018",
      "display" : "Mining Chargeman",
      "definition" : "Mining Chargeman"
    },
    {
      "code" : "8111.019",
      "display" : "Mining Plant Operator",
      "definition" : "Mining Plant Operator"
    },
    {
      "code" : "8111.020",
      "display" : "Mining Surfaceman",
      "definition" : "Mining Surfaceman"
    },
    {
      "code" : "8111.021",
      "display" : "Mining Worker",
      "definition" : "Mining Worker"
    },
    {
      "code" : "8111.022",
      "display" : "Production Foreman Overseer Mining Quarrying",
      "definition" : "Production Foreman Overseer Mining Quarrying"
    },
    {
      "code" : "8111.023",
      "display" : "Production Supervisor Miners Quarrymen",
      "definition" : "Production Supervisor Miners Quarrymen"
    },
    {
      "code" : "8111.024",
      "display" : "Production Supervisor Mining Plant Operators",
      "definition" : "Production Supervisor Mining Plant Operators"
    },
    {
      "code" : "8111.025",
      "display" : "Quality Controller of Quarry and Mine Workers",
      "definition" : "Quality Controller of Quarry and Mine Workers"
    },
    {
      "code" : "8111.026",
      "display" : "Quarry and Mine Working Supervisor",
      "definition" : "Quarry and Mine Working Supervisor"
    },
    {
      "code" : "8111.027",
      "display" : "Quarry Hand",
      "definition" : "Quarry Hand"
    },
    {
      "code" : "8111.028",
      "display" : "Quarry Worker",
      "definition" : "Quarry Worker"
    },
    {
      "code" : "8111.029",
      "display" : "Quarrying Blaster",
      "definition" : "Quarrying Blaster"
    },
    {
      "code" : "8111.030",
      "display" : "Quarrying Overseer Foreman",
      "definition" : "Quarrying Overseer Foreman"
    },
    {
      "code" : "8111.031",
      "display" : "Quarrying Shot Firer",
      "definition" : "Quarrying Shot Firer"
    },
    {
      "code" : "8111.032",
      "display" : "Quarrying Worker",
      "definition" : "Quarrying Worker"
    },
    {
      "code" : "8111.033",
      "display" : "Sand Pit Worker",
      "definition" : "Sand Pit Worker"
    },
    {
      "code" : "8111.034",
      "display" : "Scheelite Miner",
      "definition" : "Scheelite Miner"
    },
    {
      "code" : "8111.035",
      "display" : "Shift Boss Mine",
      "definition" : "Shift Boss Mine"
    },
    {
      "code" : "8111.036",
      "display" : "Shot Firer",
      "definition" : "Shot Firer"
    },
    {
      "code" : "8111.037",
      "display" : "Shuttle Car Operator Mine",
      "definition" : "Shuttle Car Operator Mine"
    },
    {
      "code" : "8111.038",
      "display" : "Silver Miner",
      "definition" : "Silver Miner"
    },
    {
      "code" : "8112.001",
      "display" : "Crusher Quarry",
      "definition" : "Crusher Quarry"
    },
    {
      "code" : "8112.002",
      "display" : "Grinder Quarry",
      "definition" : "Grinder Quarry"
    },
    {
      "code" : "8112.003",
      "display" : "Lime Miller",
      "definition" : "Lime Miller"
    },
    {
      "code" : "8112.004",
      "display" : "Mineral and Stone Treater",
      "definition" : "Mineral and Stone Treater"
    },
    {
      "code" : "8112.005",
      "display" : "Ore Crusher Operator",
      "definition" : "Ore Crusher Operator"
    },
    {
      "code" : "8112.006",
      "display" : "Quarry Jig Operator",
      "definition" : "Quarry Jig Operator"
    },
    {
      "code" : "8112.007",
      "display" : "Rock and Clay Grinder",
      "definition" : "Rock and Clay Grinder"
    },
    {
      "code" : "8112.008",
      "display" : "Screen Worker Mine or Quarry",
      "definition" : "Screen Worker Mine or Quarry"
    },
    {
      "code" : "8112.009",
      "display" : "Stone Crusher",
      "definition" : "Stone Crusher"
    },
    {
      "code" : "8112.010",
      "display" : "Stone Splitter",
      "definition" : "Stone Splitter"
    },
    {
      "code" : "8113.001",
      "display" : "Bore Driller",
      "definition" : "Bore Driller"
    },
    {
      "code" : "8113.002",
      "display" : "Bore Driller Thermal Steam",
      "definition" : "Bore Driller Thermal Steam"
    },
    {
      "code" : "8113.003",
      "display" : "Cable Driller",
      "definition" : "Cable Driller"
    },
    {
      "code" : "8113.004",
      "display" : "Derrick Worker",
      "definition" : "Derrick Worker"
    },
    {
      "code" : "8113.005",
      "display" : "Driller",
      "definition" : "Driller"
    },
    {
      "code" : "8113.006",
      "display" : "Oil and Gas Caser",
      "definition" : "Oil and Gas Caser"
    },
    {
      "code" : "8113.007",
      "display" : "Oil and Gas Cementer",
      "definition" : "Oil and Gas Cementer"
    },
    {
      "code" : "8113.008",
      "display" : "Oil and Gas Derrickman",
      "definition" : "Oil and Gas Derrickman"
    },
    {
      "code" : "8113.009",
      "display" : "Oil Rig Floorman",
      "definition" : "Oil Rig Floorman"
    },
    {
      "code" : "8113.010",
      "display" : "Overseer Foreman Oil and Gas Drilling",
      "definition" : "Overseer Foreman Oil and Gas Drilling"
    },
    {
      "code" : "8113.011",
      "display" : "Rotary Driller",
      "definition" : "Rotary Driller"
    },
    {
      "code" : "8113.012",
      "display" : "Roughneck Oil Well Drilling",
      "definition" : "Roughneck Oil Well Drilling"
    },
    {
      "code" : "8113.013",
      "display" : "Supervisor Oil And Gas Drilling",
      "definition" : "Supervisor Oil And Gas Drilling"
    },
    {
      "code" : "8113.014",
      "display" : "Well Borer",
      "definition" : "Well Borer"
    },
    {
      "code" : "8113.015",
      "display" : "Well Caser",
      "definition" : "Well Caser"
    },
    {
      "code" : "8113.016",
      "display" : "Well Driller",
      "definition" : "Well Driller"
    },
    {
      "code" : "8113.017",
      "display" : "Well Sinker",
      "definition" : "Well Sinker"
    },
    {
      "code" : "8121.001",
      "display" : "Cupola Furnaceman",
      "definition" : "Cupola Furnaceman"
    },
    {
      "code" : "8121.002",
      "display" : "Die Press Operator Forging",
      "definition" : "Die Press Operator Forging"
    },
    {
      "code" : "8121.003",
      "display" : "Drop Hammer Operator",
      "definition" : "Drop Hammer Operator"
    },
    {
      "code" : "8121.004",
      "display" : "Electric Arc Furnaceman",
      "definition" : "Electric Arc Furnaceman"
    },
    {
      "code" : "8121.005",
      "display" : "Forge Hammer Operator",
      "definition" : "Forge Hammer Operator"
    },
    {
      "code" : "8121.006",
      "display" : "Forging Press Operator",
      "definition" : "Forging Press Operator"
    },
    {
      "code" : "8121.007",
      "display" : "Furnace Operator Metallic Supervisor",
      "definition" : "Furnace Operator Metallic Supervisor"
    },
    {
      "code" : "8121.008",
      "display" : "Furnaceman Ore Smelting",
      "definition" : "Furnaceman Ore Smelting"
    },
    {
      "code" : "8121.009",
      "display" : "Ingot Operator",
      "definition" : "Ingot Operator"
    },
    {
      "code" : "8121.010",
      "display" : "Metal Annealer",
      "definition" : "Metal Annealer"
    },
    {
      "code" : "8121.011",
      "display" : "Metal Hardener",
      "definition" : "Metal Hardener"
    },
    {
      "code" : "8121.012",
      "display" : "Metal Melter Reheater",
      "definition" : "Metal Melter Reheater"
    },
    {
      "code" : "8121.013",
      "display" : "Metal Temperer",
      "definition" : "Metal Temperer"
    },
    {
      "code" : "8121.014",
      "display" : "Metallic Furnace Operator",
      "definition" : "Metallic Furnace Operator"
    },
    {
      "code" : "8121.015",
      "display" : "Metallic Furnace Supervisor",
      "definition" : "Metallic Furnace Supervisor"
    },
    {
      "code" : "8121.016",
      "display" : "Pot Operator",
      "definition" : "Pot Operator"
    },
    {
      "code" : "8121.017",
      "display" : "Power Hammer Operator",
      "definition" : "Power Hammer Operator"
    },
    {
      "code" : "8121.018",
      "display" : "Press Operator Metal Forging",
      "definition" : "Press Operator Metal Forging"
    },
    {
      "code" : "8121.019",
      "display" : "Quality Controller Of Metallic Furnace Operators",
      "definition" : "Quality Controller Of Metallic Furnace Operators"
    },
    {
      "code" : "8121.020",
      "display" : "Steam Hammer Operator",
      "definition" : "Steam Hammer Operator"
    },
    {
      "code" : "8122.001",
      "display" : "Continuous Rod Casting Machine Operator",
      "definition" : "Continuous Rod Casting Machine Operator"
    },
    {
      "code" : "8122.002",
      "display" : "Die Casting Machine Operator",
      "definition" : "Die Casting Machine Operator"
    },
    {
      "code" : "8122.003",
      "display" : "Fettler",
      "definition" : "Fettler"
    },
    {
      "code" : "8122.004",
      "display" : "Foundry Worker",
      "definition" : "Foundry Worker"
    },
    {
      "code" : "8122.005",
      "display" : "Iron Machinist Foundry",
      "definition" : "Iron Machinist Foundry"
    },
    {
      "code" : "8122.006",
      "display" : "Metal Burnisher",
      "definition" : "Metal Burnisher"
    },
    {
      "code" : "8122.007",
      "display" : "Metal Caster",
      "definition" : "Metal Caster"
    },
    {
      "code" : "8122.008",
      "display" : "Metal Casting Supervisor",
      "definition" : "Metal Casting Supervisor"
    },
    {
      "code" : "8122.009",
      "display" : "Metal Conveyor Operator",
      "definition" : "Metal Conveyor Operator"
    },
    {
      "code" : "8122.010",
      "display" : "Metal Pourer Foundry",
      "definition" : "Metal Pourer Foundry"
    },
    {
      "code" : "8122.011",
      "display" : "Quality Controller of Metal Casters",
      "definition" : "Quality Controller of Metal Casters"
    },
    {
      "code" : "8122.012",
      "display" : "Rolling Mill Operator",
      "definition" : "Rolling Mill Operator"
    },
    {
      "code" : "8122.013",
      "display" : "Sandblaster Metal Castings",
      "definition" : "Sandblaster Metal Castings"
    },
    {
      "code" : "8122.014",
      "display" : "Shot Blaster Castings",
      "definition" : "Shot Blaster Castings"
    },
    {
      "code" : "8122.015",
      "display" : "Steel Caster",
      "definition" : "Steel Caster"
    },
    {
      "code" : "8122.016",
      "display" : "Steel Tube Mill Operator",
      "definition" : "Steel Tube Mill Operator"
    },
    {
      "code" : "8122.017",
      "display" : "Steel Worker",
      "definition" : "Steel Worker"
    },
    {
      "code" : "8122.018",
      "display" : "Steel Working Process Worker",
      "definition" : "Steel Working Process Worker"
    },
    {
      "code" : "8122.019",
      "display" : "Steelworker",
      "definition" : "Steelworker"
    },
    {
      "code" : "8122.020",
      "display" : "Steelworking Process Worker",
      "definition" : "Steelworking Process Worker"
    },
    {
      "code" : "8123.001",
      "display" : "Argon Welder",
      "definition" : "Argon Welder"
    },
    {
      "code" : "8123.002",
      "display" : "Brazer",
      "definition" : "Brazer"
    },
    {
      "code" : "8123.003",
      "display" : "Carbon Dioxide Welder",
      "definition" : "Carbon Dioxide Welder"
    },
    {
      "code" : "8123.004",
      "display" : "Electric Arc Cutter",
      "definition" : "Electric Arc Cutter"
    },
    {
      "code" : "8123.005",
      "display" : "Electric Arc Welder",
      "definition" : "Electric Arc Welder"
    },
    {
      "code" : "8123.006",
      "display" : "Flame Cutter",
      "definition" : "Flame Cutter"
    },
    {
      "code" : "8123.007",
      "display" : "Gas Cutter",
      "definition" : "Gas Cutter"
    },
    {
      "code" : "8123.008",
      "display" : "General Welder",
      "definition" : "General Welder"
    },
    {
      "code" : "8123.009",
      "display" : "Lead Burner",
      "definition" : "Lead Burner"
    },
    {
      "code" : "8123.010",
      "display" : "Lead Worker",
      "definition" : "Lead Worker"
    },
    {
      "code" : "8123.011",
      "display" : "Oxyacetylene Gas Welder",
      "definition" : "Oxyacetylene Gas Welder"
    },
    {
      "code" : "8123.012",
      "display" : "Solderer and Brazer",
      "definition" : "Solderer and Brazer"
    },
    {
      "code" : "8123.013",
      "display" : "Spot Welder Operator",
      "definition" : "Spot Welder Operator"
    },
    {
      "code" : "8123.014",
      "display" : "Welder and Flame Cutter",
      "definition" : "Welder and Flame Cutter"
    },
    {
      "code" : "8123.015",
      "display" : "Welding Inspector",
      "definition" : "Welding Inspector"
    },
    {
      "code" : "8123.016",
      "display" : "Welding Superintendent",
      "definition" : "Welding Superintendent"
    },
    {
      "code" : "8124.001",
      "display" : "Manipulator Metal Rolling Mill Worker",
      "definition" : "Manipulator Metal Rolling Mill Worker"
    },
    {
      "code" : "8124.002",
      "display" : "Metal Drawer",
      "definition" : "Metal Drawer"
    },
    {
      "code" : "8124.003",
      "display" : "Metal Drawer or Extruder",
      "definition" : "Metal Drawer or Extruder"
    },
    {
      "code" : "8124.004",
      "display" : "Metal Drawer Supervisor",
      "definition" : "Metal Drawer Supervisor"
    },
    {
      "code" : "8124.005",
      "display" : "Metal Extruder",
      "definition" : "Metal Extruder"
    },
    {
      "code" : "8124.006",
      "display" : "Metal Extruder Operator",
      "definition" : "Metal Extruder Operator"
    },
    {
      "code" : "8124.007",
      "display" : "Metal Extrusion Press Operator",
      "definition" : "Metal Extrusion Press Operator"
    },
    {
      "code" : "8124.008",
      "display" : "Metal Normaliser",
      "definition" : "Metal Normaliser"
    },
    {
      "code" : "8124.009",
      "display" : "Metal Pipe and Tube Drawer",
      "definition" : "Metal Pipe and Tube Drawer"
    },
    {
      "code" : "8124.010",
      "display" : "Wire Drawer",
      "definition" : "Wire Drawer"
    },
    {
      "code" : "8124.011",
      "display" : "Wire Drawing Process Worker",
      "definition" : "Wire Drawing Process Worker"
    },
    {
      "code" : "8131.001",
      "display" : "Brick and Tile Drawer and Setter",
      "definition" : "Brick and Tile Drawer and Setter"
    },
    {
      "code" : "8131.002",
      "display" : "Brick and Tile Kilnman",
      "definition" : "Brick and Tile Kilnman"
    },
    {
      "code" : "8131.003",
      "display" : "Brick and Tile Maker Moulder Presser",
      "definition" : "Brick and Tile Maker Moulder Presser"
    },
    {
      "code" : "8131.004",
      "display" : "Brick Maker",
      "definition" : "Brick Maker"
    },
    {
      "code" : "8131.005",
      "display" : "Brickmaker",
      "definition" : "Brickmaker"
    },
    {
      "code" : "8131.006",
      "display" : "Brickmaking Process Worker",
      "definition" : "Brickmaking Process Worker"
    },
    {
      "code" : "8131.007",
      "display" : "Ceramic Porcelain Pottery Presser",
      "definition" : "Ceramic Porcelain Pottery Presser"
    },
    {
      "code" : "8131.008",
      "display" : "Ceramics Worker",
      "definition" : "Ceramics Worker"
    },
    {
      "code" : "8131.009",
      "display" : "Ceramist",
      "definition" : "Ceramist"
    },
    {
      "code" : "8131.010",
      "display" : "Clay Mixer",
      "definition" : "Clay Mixer"
    },
    {
      "code" : "8131.011",
      "display" : "Clay Mould Plant Operator",
      "definition" : "Clay Mould Plant Operator"
    },
    {
      "code" : "8131.012",
      "display" : "Clay Product Plant Operator",
      "definition" : "Clay Product Plant Operator"
    },
    {
      "code" : "8131.013",
      "display" : "Glass Furnaceman",
      "definition" : "Glass Furnaceman"
    },
    {
      "code" : "8131.014",
      "display" : "Kiln Burner Lime",
      "definition" : "Kiln Burner Lime"
    },
    {
      "code" : "8131.015",
      "display" : "Kilnman Ovenman Kilnburner",
      "definition" : "Kilnman Ovenman Kilnburner"
    },
    {
      "code" : "8131.016",
      "display" : "Non Metallic Mineral Products Kiln Operator",
      "definition" : "Non Metallic Mineral Products Kiln Operator"
    },
    {
      "code" : "8131.017",
      "display" : "Non Metallic Mineral Products Kiln or Furnace Operator",
      "definition" : "Non Metallic Mineral Products Kiln or Furnace Operator"
    },
    {
      "code" : "8131.018",
      "display" : "Nonmetallic Mineral Products Kiln Operator",
      "definition" : "Nonmetallic Mineral Products Kiln Operator"
    },
    {
      "code" : "8131.019",
      "display" : "Porcelain Factory Worker",
      "definition" : "Porcelain Factory Worker"
    },
    {
      "code" : "8131.020",
      "display" : "Potter",
      "definition" : "Potter"
    },
    {
      "code" : "8131.021",
      "display" : "Pottery and Porcelain Cutter",
      "definition" : "Pottery and Porcelain Cutter"
    },
    {
      "code" : "8131.022",
      "display" : "Pottery and Porcelain Modeller",
      "definition" : "Pottery and Porcelain Modeller"
    },
    {
      "code" : "8131.023",
      "display" : "Pottery and Porcelain Mould Maker",
      "definition" : "Pottery and Porcelain Mould Maker"
    },
    {
      "code" : "8131.024",
      "display" : "Pottery and Porcelain Mould Making Supervisor",
      "definition" : "Pottery and Porcelain Mould Making Supervisor"
    },
    {
      "code" : "8131.025",
      "display" : "Pottery Insulator Maker",
      "definition" : "Pottery Insulator Maker"
    },
    {
      "code" : "8131.026",
      "display" : "Pottery Pipe Maker",
      "definition" : "Pottery Pipe Maker"
    },
    {
      "code" : "8131.027",
      "display" : "Pottery Process Worker",
      "definition" : "Pottery Process Worker"
    },
    {
      "code" : "8131.028",
      "display" : "Tile Maker",
      "definition" : "Tile Maker"
    },
    {
      "code" : "8132.001",
      "display" : "Bottle Making Machine Operator",
      "definition" : "Bottle Making Machine Operator"
    },
    {
      "code" : "8132.002",
      "display" : "Ceramics Dipper and Glazer",
      "definition" : "Ceramics Dipper and Glazer"
    },
    {
      "code" : "8132.003",
      "display" : "Ceramics Enameller",
      "definition" : "Ceramics Enameller"
    },
    {
      "code" : "8132.004",
      "display" : "Decorative Glass Finisher",
      "definition" : "Decorative Glass Finisher"
    },
    {
      "code" : "8132.005",
      "display" : "Factory Hand Fibreglass Moulding",
      "definition" : "Factory Hand Fibreglass Moulding"
    },
    {
      "code" : "8132.006",
      "display" : "Fibreglass Laminating Process Worker",
      "definition" : "Fibreglass Laminating Process Worker"
    },
    {
      "code" : "8132.007",
      "display" : "Fibreglass Laminator",
      "definition" : "Fibreglass Laminator"
    },
    {
      "code" : "8132.008",
      "display" : "Fibreglass Pattern Maker",
      "definition" : "Fibreglass Pattern Maker"
    },
    {
      "code" : "8132.009",
      "display" : "Fibreglass Process Worker",
      "definition" : "Fibreglass Process Worker"
    },
    {
      "code" : "8132.010",
      "display" : "Fibreglass Worker",
      "definition" : "Fibreglass Worker"
    },
    {
      "code" : "8132.011",
      "display" : "Fibreglass Worker and Maker",
      "definition" : "Fibreglass Worker and Maker"
    },
    {
      "code" : "8132.012",
      "display" : "Fibreglasser",
      "definition" : "Fibreglasser"
    },
    {
      "code" : "8132.013",
      "display" : "Glass and Ceramics Decorator",
      "definition" : "Glass and Ceramics Decorator"
    },
    {
      "code" : "8132.014",
      "display" : "Glass and Ceramics Decorator Supervisor",
      "definition" : "Glass and Ceramics Decorator Supervisor"
    },
    {
      "code" : "8132.015",
      "display" : "Glass and Ceramics Painter and Decorator",
      "definition" : "Glass and Ceramics Painter and Decorator"
    },
    {
      "code" : "8132.016",
      "display" : "Glass Bender",
      "definition" : "Glass Bender"
    },
    {
      "code" : "8132.017",
      "display" : "Glass Blower",
      "definition" : "Glass Blower"
    },
    {
      "code" : "8132.018",
      "display" : "Glass Decorator",
      "definition" : "Glass Decorator"
    },
    {
      "code" : "8132.019",
      "display" : "Glass Drawing Machine Operator",
      "definition" : "Glass Drawing Machine Operator"
    },
    {
      "code" : "8132.020",
      "display" : "Glass Drawing Machine Operator Supervisor",
      "definition" : "Glass Drawing Machine Operator Supervisor"
    },
    {
      "code" : "8132.021",
      "display" : "Glass Fibre Maker",
      "definition" : "Glass Fibre Maker"
    },
    {
      "code" : "8132.022",
      "display" : "Glass Fibre Process Worker",
      "definition" : "Glass Fibre Process Worker"
    },
    {
      "code" : "8132.023",
      "display" : "Glass Flanger",
      "definition" : "Glass Flanger"
    },
    {
      "code" : "8132.024",
      "display" : "Glass Maker",
      "definition" : "Glass Maker"
    },
    {
      "code" : "8132.025",
      "display" : "Glass Making Process Worker",
      "definition" : "Glass Making Process Worker"
    },
    {
      "code" : "8132.026",
      "display" : "Glass Mould Blower",
      "definition" : "Glass Mould Blower"
    },
    {
      "code" : "8132.027",
      "display" : "Glass Polisher",
      "definition" : "Glass Polisher"
    },
    {
      "code" : "8132.028",
      "display" : "Glass Pressing and Drawing Machine Supervisor",
      "definition" : "Glass Pressing and Drawing Machine Supervisor"
    },
    {
      "code" : "8132.029",
      "display" : "Glass Pressing Machine Operator",
      "definition" : "Glass Pressing Machine Operator"
    },
    {
      "code" : "8132.030",
      "display" : "Glass Silverer",
      "definition" : "Glass Silverer"
    },
    {
      "code" : "8132.031",
      "display" : "Glass Worker",
      "definition" : "Glass Worker"
    },
    {
      "code" : "8132.032",
      "display" : "Glaze Maker",
      "definition" : "Glaze Maker"
    },
    {
      "code" : "8132.033",
      "display" : "Mirror Silverer",
      "definition" : "Mirror Silverer"
    },
    {
      "code" : "8132.034",
      "display" : "Plate Glass Roller",
      "definition" : "Plate Glass Roller"
    },
    {
      "code" : "8132.035",
      "display" : "Quality Controller Of Glass And Ceramics Painters",
      "definition" : "Quality Controller Of Glass And Ceramics Painters"
    },
    {
      "code" : "8132.036",
      "display" : "Scientific Glass Blower",
      "definition" : "Scientific Glass Blower"
    },
    {
      "code" : "8132.037",
      "display" : "Sun Tint Filmer Glass",
      "definition" : "Sun Tint Filmer Glass"
    },
    {
      "code" : "8141.001",
      "display" : "Benchman Sawmill",
      "definition" : "Benchman Sawmill"
    },
    {
      "code" : "8141.002",
      "display" : "Breast Bench Sawyer",
      "definition" : "Breast Bench Sawyer"
    },
    {
      "code" : "8141.003",
      "display" : "Chipper Operator",
      "definition" : "Chipper Operator"
    },
    {
      "code" : "8141.004",
      "display" : "Log Chipping Machine Operator",
      "definition" : "Log Chipping Machine Operator"
    },
    {
      "code" : "8141.005",
      "display" : "Planer Timber Machinery",
      "definition" : "Planer Timber Machinery"
    },
    {
      "code" : "8141.006",
      "display" : "Post Cutter",
      "definition" : "Post Cutter"
    },
    {
      "code" : "8141.007",
      "display" : "Precision Timber Machinist",
      "definition" : "Precision Timber Machinist"
    },
    {
      "code" : "8141.008",
      "display" : "Quality Controller Of Timber Grader Classers",
      "definition" : "Quality Controller Of Timber Grader Classers"
    },
    {
      "code" : "8141.009",
      "display" : "Sawmill Band Saw Operator",
      "definition" : "Sawmill Band Saw Operator"
    },
    {
      "code" : "8141.010",
      "display" : "Sawmill Docker",
      "definition" : "Sawmill Docker"
    },
    {
      "code" : "8141.011",
      "display" : "Sawmill Firewood Machinist",
      "definition" : "Sawmill Firewood Machinist"
    },
    {
      "code" : "8141.012",
      "display" : "Sawmill Hand",
      "definition" : "Sawmill Hand"
    },
    {
      "code" : "8141.013",
      "display" : "Sawmill Peel Operator",
      "definition" : "Sawmill Peel Operator"
    },
    {
      "code" : "8141.014",
      "display" : "Sawmill Process Worker",
      "definition" : "Sawmill Process Worker"
    },
    {
      "code" : "8141.015",
      "display" : "Sawmill Skidman",
      "definition" : "Sawmill Skidman"
    },
    {
      "code" : "8141.016",
      "display" : "Sawmill Table Hand",
      "definition" : "Sawmill Table Hand"
    },
    {
      "code" : "8141.017",
      "display" : "Sawmill Tallyman",
      "definition" : "Sawmill Tallyman"
    },
    {
      "code" : "8141.018",
      "display" : "Sawmill Timber Machine Operator",
      "definition" : "Sawmill Timber Machine Operator"
    },
    {
      "code" : "8141.019",
      "display" : "Sawmill Worker",
      "definition" : "Sawmill Worker"
    },
    {
      "code" : "8141.020",
      "display" : "Sawmill Yardman",
      "definition" : "Sawmill Yardman"
    },
    {
      "code" : "8141.021",
      "display" : "Sawmiller",
      "definition" : "Sawmiller"
    },
    {
      "code" : "8141.022",
      "display" : "Sawyer",
      "definition" : "Sawyer"
    },
    {
      "code" : "8141.023",
      "display" : "Sawyer Woodwork",
      "definition" : "Sawyer Woodwork"
    },
    {
      "code" : "8141.024",
      "display" : "Solidwood Process Operator",
      "definition" : "Solidwood Process Operator"
    },
    {
      "code" : "8141.025",
      "display" : "Tailer Out Sawmill",
      "definition" : "Tailer Out Sawmill"
    },
    {
      "code" : "8141.026",
      "display" : "Tallyman Timber Yard",
      "definition" : "Tallyman Timber Yard"
    },
    {
      "code" : "8141.027",
      "display" : "Timber Classer Grader Supervisor",
      "definition" : "Timber Classer Grader Supervisor"
    },
    {
      "code" : "8141.028",
      "display" : "Timber Forest Products Inspector",
      "definition" : "Timber Forest Products Inspector"
    },
    {
      "code" : "8141.029",
      "display" : "Timber Grader Classer",
      "definition" : "Timber Grader Classer"
    },
    {
      "code" : "8141.030",
      "display" : "Timber Inspector Forests",
      "definition" : "Timber Inspector Forests"
    },
    {
      "code" : "8141.031",
      "display" : "Timber Overseer Forestry",
      "definition" : "Timber Overseer Forestry"
    },
    {
      "code" : "8141.032",
      "display" : "Timber Processing Machine Operator",
      "definition" : "Timber Processing Machine Operator"
    },
    {
      "code" : "8141.033",
      "display" : "Timber Processing Machine Supervisor",
      "definition" : "Timber Processing Machine Supervisor"
    },
    {
      "code" : "8141.034",
      "display" : "Timber Sorter",
      "definition" : "Timber Sorter"
    },
    {
      "code" : "8141.035",
      "display" : "Timber Stripper",
      "definition" : "Timber Stripper"
    },
    {
      "code" : "8142.001",
      "display" : "Beater Operator Pulp",
      "definition" : "Beater Operator Pulp"
    },
    {
      "code" : "8142.002",
      "display" : "Bleacher Operator Pulp Making",
      "definition" : "Bleacher Operator Pulp Making"
    },
    {
      "code" : "8142.003",
      "display" : "Boilerman Paper Pulp Production",
      "definition" : "Boilerman Paper Pulp Production"
    },
    {
      "code" : "8142.004",
      "display" : "Paper Pulp Digestor Operator",
      "definition" : "Paper Pulp Digestor Operator"
    },
    {
      "code" : "8142.005",
      "display" : "Paper Pulp Preparer Production Worker",
      "definition" : "Paper Pulp Preparer Production Worker"
    },
    {
      "code" : "8142.006",
      "display" : "Paper Pulp Production Supervisor",
      "definition" : "Paper Pulp Production Supervisor"
    },
    {
      "code" : "8142.007",
      "display" : "Pulp Mill Worker",
      "definition" : "Pulp Mill Worker"
    },
    {
      "code" : "8142.008",
      "display" : "Pulp Production Supervisor",
      "definition" : "Pulp Production Supervisor"
    },
    {
      "code" : "8142.009",
      "display" : "Pulp Production Worker",
      "definition" : "Pulp Production Worker"
    },
    {
      "code" : "8142.010",
      "display" : "Quality Controller Of Pulp Production Workers",
      "definition" : "Quality Controller Of Pulp Production Workers"
    },
    {
      "code" : "8142.011",
      "display" : "Wood Grinder Paper Pulp",
      "definition" : "Wood Grinder Paper Pulp"
    },
    {
      "code" : "8142.012",
      "display" : "Wood Pulp Worker",
      "definition" : "Wood Pulp Worker"
    },
    {
      "code" : "8143.001",
      "display" : "Fibreboard Maker",
      "definition" : "Fibreboard Maker"
    },
    {
      "code" : "8143.002",
      "display" : "Paper Blendman",
      "definition" : "Paper Blendman"
    },
    {
      "code" : "8143.003",
      "display" : "Paper Maker",
      "definition" : "Paper Maker"
    },
    {
      "code" : "8143.004",
      "display" : "Paper Making Machine Operator",
      "definition" : "Paper Making Machine Operator"
    },
    {
      "code" : "8143.005",
      "display" : "Paper Making Production Supervisor",
      "definition" : "Paper Making Production Supervisor"
    },
    {
      "code" : "8143.006",
      "display" : "Paper Mill Drier Man",
      "definition" : "Paper Mill Drier Man"
    },
    {
      "code" : "8143.007",
      "display" : "Paper Mill Finisher",
      "definition" : "Paper Mill Finisher"
    },
    {
      "code" : "8143.008",
      "display" : "Paper Mill Machinist",
      "definition" : "Paper Mill Machinist"
    },
    {
      "code" : "8143.009",
      "display" : "Paper Production Back End Machine Operator",
      "definition" : "Paper Production Back End Machine Operator"
    },
    {
      "code" : "8143.010",
      "display" : "Paper Production Supervisor",
      "definition" : "Paper Production Supervisor"
    },
    {
      "code" : "8143.011",
      "display" : "Paper Production Worker",
      "definition" : "Paper Production Worker"
    },
    {
      "code" : "8143.012",
      "display" : "Paper Products Coating Machinist",
      "definition" : "Paper Products Coating Machinist"
    },
    {
      "code" : "8143.013",
      "display" : "Paper Slitting Machine Operator",
      "definition" : "Paper Slitting Machine Operator"
    },
    {
      "code" : "8143.014",
      "display" : "Paper Supercalender Operator",
      "definition" : "Paper Supercalender Operator"
    },
    {
      "code" : "8143.015",
      "display" : "Paper Tester",
      "definition" : "Paper Tester"
    },
    {
      "code" : "8143.016",
      "display" : "Quality Controller of Paper Production Workers",
      "definition" : "Quality Controller of Paper Production Workers"
    },
    {
      "code" : "8143.017",
      "display" : "Strawboard Maker",
      "definition" : "Strawboard Maker"
    },
    {
      "code" : "8143.018",
      "display" : "Wet End Machine Operator Paper Making",
      "definition" : "Wet End Machine Operator Paper Making"
    },
    {
      "code" : "8143.019",
      "display" : "Wood Grinding Paper Pulp Worker",
      "definition" : "Wood Grinding Paper Pulp Worker"
    },
    {
      "code" : "8151.001",
      "display" : "Cement Grinder Miller",
      "definition" : "Cement Grinder Miller"
    },
    {
      "code" : "8151.002",
      "display" : "Chemical Crusher",
      "definition" : "Chemical Crusher"
    },
    {
      "code" : "8151.003",
      "display" : "Chemical Crusher Grinder Mixer Supervisor",
      "definition" : "Chemical Crusher Grinder Mixer Supervisor"
    },
    {
      "code" : "8151.004",
      "display" : "Chemical Crushing Grinding and Mixing Operators",
      "definition" : "Chemical Crushing Grinding and Mixing Operators"
    },
    {
      "code" : "8151.005",
      "display" : "Chemical Grinder",
      "definition" : "Chemical Grinder"
    },
    {
      "code" : "8151.006",
      "display" : "Chemical Mixer",
      "definition" : "Chemical Mixer"
    },
    {
      "code" : "8151.007",
      "display" : "Chemical Processes Crusher",
      "definition" : "Chemical Processes Crusher"
    },
    {
      "code" : "8151.008",
      "display" : "Chemical Processes Grinder",
      "definition" : "Chemical Processes Grinder"
    },
    {
      "code" : "8151.009",
      "display" : "Chemical Processes Mixer",
      "definition" : "Chemical Processes Mixer"
    },
    {
      "code" : "8151.010",
      "display" : "Chemical Processing Digester Operator",
      "definition" : "Chemical Processing Digester Operator"
    },
    {
      "code" : "8151.011",
      "display" : "Dag Crusher",
      "definition" : "Dag Crusher"
    },
    {
      "code" : "8151.012",
      "display" : "Fertilisers Mixer",
      "definition" : "Fertilisers Mixer"
    },
    {
      "code" : "8151.013",
      "display" : "Glass Mixer",
      "definition" : "Glass Mixer"
    },
    {
      "code" : "8151.014",
      "display" : "Glass Mixer Supervisor",
      "definition" : "Glass Mixer Supervisor"
    },
    {
      "code" : "8151.015",
      "display" : "Mixer Abrasives Glass and Ceramics",
      "definition" : "Mixer Abrasives Glass and Ceramics"
    },
    {
      "code" : "8151.016",
      "display" : "Starch Mill Worker",
      "definition" : "Starch Mill Worker"
    },
    {
      "code" : "8152.001",
      "display" : "Chemicals Extractor Operator",
      "definition" : "Chemicals Extractor Operator"
    },
    {
      "code" : "8152.002",
      "display" : "Filtering and Separating Equipment Operator",
      "definition" : "Filtering and Separating Equipment Operator"
    },
    {
      "code" : "8152.003",
      "display" : "Filtering Equipment Operator",
      "definition" : "Filtering Equipment Operator"
    },
    {
      "code" : "8152.004",
      "display" : "Press and Filter Operator Chemical Processes",
      "definition" : "Press and Filter Operator Chemical Processes"
    },
    {
      "code" : "8152.005",
      "display" : "Quality Controller Of Water Treatment Plant Operators",
      "definition" : "Quality Controller Of Water Treatment Plant Operators"
    },
    {
      "code" : "8152.006",
      "display" : "Separating Equipment Operator",
      "definition" : "Separating Equipment Operator"
    },
    {
      "code" : "8152.007",
      "display" : "Treatment Plant Operator Waterworks",
      "definition" : "Treatment Plant Operator Waterworks"
    },
    {
      "code" : "8152.008",
      "display" : "Water Filter Operator Attendant",
      "definition" : "Water Filter Operator Attendant"
    },
    {
      "code" : "8152.009",
      "display" : "Water Treatment Plant Operator",
      "definition" : "Water Treatment Plant Operator"
    },
    {
      "code" : "8152.010",
      "display" : "Water Treatment Plant Supervisor",
      "definition" : "Water Treatment Plant Supervisor"
    },
    {
      "code" : "8152.011",
      "display" : "Waterworks Attendant",
      "definition" : "Waterworks Attendant"
    },
    {
      "code" : "8152.012",
      "display" : "Waterworks Plant Operator",
      "definition" : "Waterworks Plant Operator"
    },
    {
      "code" : "8152.013",
      "display" : "Waterworks Serviceman",
      "definition" : "Waterworks Serviceman"
    },
    {
      "code" : "8153.001",
      "display" : "Acetylene Gas Plant Operator",
      "definition" : "Acetylene Gas Plant Operator"
    },
    {
      "code" : "8153.002",
      "display" : "Chemical Processes Evaporator Operator",
      "definition" : "Chemical Processes Evaporator Operator"
    },
    {
      "code" : "8153.003",
      "display" : "Chemical Processes Reactor Convertor Operator",
      "definition" : "Chemical Processes Reactor Convertor Operator"
    },
    {
      "code" : "8153.004",
      "display" : "Chemical Reactor Operator",
      "definition" : "Chemical Reactor Operator"
    },
    {
      "code" : "8153.005",
      "display" : "Distillation Operator",
      "definition" : "Distillation Operator"
    },
    {
      "code" : "8153.006",
      "display" : "Natural Gas Refining Worker",
      "definition" : "Natural Gas Refining Worker"
    },
    {
      "code" : "8153.007",
      "display" : "Oil Blender and Mixer Petroleum Refinery",
      "definition" : "Oil Blender and Mixer Petroleum Refinery"
    },
    {
      "code" : "8153.008",
      "display" : "Oil Panel Man Refinery Operator",
      "definition" : "Oil Panel Man Refinery Operator"
    },
    {
      "code" : "8153.009",
      "display" : "Petroleum Refinery Operator",
      "definition" : "Petroleum Refinery Operator"
    },
    {
      "code" : "8153.010",
      "display" : "Petroleum Refining Worker",
      "definition" : "Petroleum Refining Worker"
    },
    {
      "code" : "8153.011",
      "display" : "Process Worker Oil Products",
      "definition" : "Process Worker Oil Products"
    },
    {
      "code" : "8153.012",
      "display" : "Quality Controller Of Still And Reactor Operators",
      "definition" : "Quality Controller Of Still And Reactor Operators"
    },
    {
      "code" : "8153.013",
      "display" : "Still and Reactor Operator",
      "definition" : "Still and Reactor Operator"
    },
    {
      "code" : "8153.014",
      "display" : "Still and Reactor Supervisor",
      "definition" : "Still and Reactor Supervisor"
    },
    {
      "code" : "8153.015",
      "display" : "Still and Reactor Supervisor Chemical",
      "definition" : "Still and Reactor Supervisor Chemical"
    },
    {
      "code" : "8153.016",
      "display" : "Still and Reactor Supervisor Gas",
      "definition" : "Still and Reactor Supervisor Gas"
    },
    {
      "code" : "8153.017",
      "display" : "Still Batch Chemical Operator",
      "definition" : "Still Batch Chemical Operator"
    },
    {
      "code" : "8153.018",
      "display" : "Still Pump Operator Petroleum Refinery",
      "definition" : "Still Pump Operator Petroleum Refinery"
    },
    {
      "code" : "8153.019",
      "display" : "Wood Distillation Extractor Operator",
      "definition" : "Wood Distillation Extractor Operator"
    },
    {
      "code" : "8154.001",
      "display" : "Ammunition Maker",
      "definition" : "Ammunition Maker"
    },
    {
      "code" : "8154.002",
      "display" : "Asphalt Blender",
      "definition" : "Asphalt Blender"
    },
    {
      "code" : "8154.003",
      "display" : "Battery Maker and Reconditioner",
      "definition" : "Battery Maker and Reconditioner"
    },
    {
      "code" : "8154.004",
      "display" : "Charcoal Burner",
      "definition" : "Charcoal Burner"
    },
    {
      "code" : "8154.005",
      "display" : "Chemical Bleacher Operator",
      "definition" : "Chemical Bleacher Operator"
    },
    {
      "code" : "8154.006",
      "display" : "Chemical Fertilizer Worker",
      "definition" : "Chemical Fertilizer Worker"
    },
    {
      "code" : "8154.007",
      "display" : "Chemical Processes Burner",
      "definition" : "Chemical Processes Burner"
    },
    {
      "code" : "8154.008",
      "display" : "Chemical Processing Plant Supervisor",
      "definition" : "Chemical Processing Plant Supervisor"
    },
    {
      "code" : "8154.009",
      "display" : "Chemical Processor",
      "definition" : "Chemical Processor"
    },
    {
      "code" : "8154.010",
      "display" : "Cleaning Materials Maker",
      "definition" : "Cleaning Materials Maker"
    },
    {
      "code" : "8154.011",
      "display" : "Coke or Coal Gas Maker",
      "definition" : "Coke or Coal Gas Maker"
    },
    {
      "code" : "8154.012",
      "display" : "Coke Production Burner",
      "definition" : "Coke Production Burner"
    },
    {
      "code" : "8154.013",
      "display" : "Compounder",
      "definition" : "Compounder"
    },
    {
      "code" : "8154.014",
      "display" : "Cooker Roaster and Related Heat Treaters",
      "definition" : "Cooker Roaster and Related Heat Treaters"
    },
    {
      "code" : "8154.015",
      "display" : "Explosives Worker",
      "definition" : "Explosives Worker"
    },
    {
      "code" : "8154.016",
      "display" : "Floor Polish Maker",
      "definition" : "Floor Polish Maker"
    },
    {
      "code" : "8154.017",
      "display" : "Furnaceman Electrode Baking",
      "definition" : "Furnaceman Electrode Baking"
    },
    {
      "code" : "8154.018",
      "display" : "Furnaceman Lime and Cement",
      "definition" : "Furnaceman Lime and Cement"
    },
    {
      "code" : "8154.019",
      "display" : "Gas Carboniser Operator",
      "definition" : "Gas Carboniser Operator"
    },
    {
      "code" : "8154.020",
      "display" : "Gas Chargehand",
      "definition" : "Gas Chargehand"
    },
    {
      "code" : "8154.021",
      "display" : "Gas Retort Stoker",
      "definition" : "Gas Retort Stoker"
    },
    {
      "code" : "8154.022",
      "display" : "Gas Worker",
      "definition" : "Gas Worker"
    },
    {
      "code" : "8154.023",
      "display" : "Glue Worker",
      "definition" : "Glue Worker"
    },
    {
      "code" : "8154.024",
      "display" : "Grease Maker",
      "definition" : "Grease Maker"
    },
    {
      "code" : "8154.025",
      "display" : "Grease Press Hand",
      "definition" : "Grease Press Hand"
    },
    {
      "code" : "8154.026",
      "display" : "Ink Factory Hand",
      "definition" : "Ink Factory Hand"
    },
    {
      "code" : "8154.027",
      "display" : "Kettleman",
      "definition" : "Kettleman"
    },
    {
      "code" : "8154.028",
      "display" : "Other Chemical Processing Plant Operator",
      "definition" : "Other Chemical Processing Plant Operator"
    },
    {
      "code" : "8154.029",
      "display" : "Overseer Chemical Products",
      "definition" : "Overseer Chemical Products"
    },
    {
      "code" : "8154.030",
      "display" : "Paint and Colour Mixer",
      "definition" : "Paint and Colour Mixer"
    },
    {
      "code" : "8154.031",
      "display" : "Paint Drying Oven Tender",
      "definition" : "Paint Drying Oven Tender"
    },
    {
      "code" : "8154.032",
      "display" : "Paint Grinder Mixer",
      "definition" : "Paint Grinder Mixer"
    },
    {
      "code" : "8154.033",
      "display" : "Radioactive Waste Material Treatment Operator",
      "definition" : "Radioactive Waste Material Treatment Operator"
    },
    {
      "code" : "8154.034",
      "display" : "Rotary Burner Furnaceman Cement Lime",
      "definition" : "Rotary Burner Furnaceman Cement Lime"
    },
    {
      "code" : "8154.035",
      "display" : "Synthetic Fibre Maker",
      "definition" : "Synthetic Fibre Maker"
    },
    {
      "code" : "8154.036",
      "display" : "Tar Maker",
      "definition" : "Tar Maker"
    },
    {
      "code" : "8161.001",
      "display" : "Air Compressor Operator Driver",
      "definition" : "Air Compressor Operator Driver"
    },
    {
      "code" : "8161.002",
      "display" : "Aircraft Refueller",
      "definition" : "Aircraft Refueller"
    },
    {
      "code" : "8161.003",
      "display" : "Boiler Attendant",
      "definition" : "Boiler Attendant"
    },
    {
      "code" : "8161.004",
      "display" : "Boiler Operator",
      "definition" : "Boiler Operator"
    },
    {
      "code" : "8161.005",
      "display" : "Boilerman",
      "definition" : "Boilerman"
    },
    {
      "code" : "8161.006",
      "display" : "Boilerman Fireman Steam Boiler",
      "definition" : "Boilerman Fireman Steam Boiler"
    },
    {
      "code" : "8161.007",
      "display" : "Control Gate Attendant Operator Power",
      "definition" : "Control Gate Attendant Operator Power"
    },
    {
      "code" : "8161.008",
      "display" : "Control Room Operator Electric Power",
      "definition" : "Control Room Operator Electric Power"
    },
    {
      "code" : "8161.009",
      "display" : "Donkey Engine Operator",
      "definition" : "Donkey Engine Operator"
    },
    {
      "code" : "8161.010",
      "display" : "Drain Flusher",
      "definition" : "Drain Flusher"
    },
    {
      "code" : "8161.011",
      "display" : "Driver Turbine Electric Power",
      "definition" : "Driver Turbine Electric Power"
    },
    {
      "code" : "8161.012",
      "display" : "Electric Power Load Dispatcher",
      "definition" : "Electric Power Load Dispatcher"
    },
    {
      "code" : "8161.013",
      "display" : "Electric Power Substation Operator",
      "definition" : "Electric Power Substation Operator"
    },
    {
      "code" : "8161.014",
      "display" : "Electrical Switchboard Operator",
      "definition" : "Electrical Switchboard Operator"
    },
    {
      "code" : "8161.015",
      "display" : "Fireman Stoker Stationary Engine",
      "definition" : "Fireman Stoker Stationary Engine"
    },
    {
      "code" : "8161.016",
      "display" : "Heating and Ventilation Equipment Operator",
      "definition" : "Heating and Ventilation Equipment Operator"
    },
    {
      "code" : "8161.017",
      "display" : "Hydraulic Power Worker",
      "definition" : "Hydraulic Power Worker"
    },
    {
      "code" : "8161.018",
      "display" : "Hydroelectric Shift Operator",
      "definition" : "Hydroelectric Shift Operator"
    },
    {
      "code" : "8161.019",
      "display" : "Hydroelectric Station Operator",
      "definition" : "Hydroelectric Station Operator"
    },
    {
      "code" : "8161.020",
      "display" : "Lubricator",
      "definition" : "Lubricator"
    },
    {
      "code" : "8161.021",
      "display" : "Oil Dispatcher Pipelines",
      "definition" : "Oil Dispatcher Pipelines"
    },
    {
      "code" : "8161.022",
      "display" : "Oiler and Greaser",
      "definition" : "Oiler and Greaser"
    },
    {
      "code" : "8161.023",
      "display" : "Other Stationary Engine Operator",
      "definition" : "Other Stationary Engine Operator"
    },
    {
      "code" : "8161.024",
      "display" : "Overseer Chargehand Electricity",
      "definition" : "Overseer Chargehand Electricity"
    },
    {
      "code" : "8161.025",
      "display" : "Overseer Chargehand Supervisor Drainage",
      "definition" : "Overseer Chargehand Supervisor Drainage"
    },
    {
      "code" : "8161.026",
      "display" : "Overseer Chargehand Supervisor Sewerage",
      "definition" : "Overseer Chargehand Supervisor Sewerage"
    },
    {
      "code" : "8161.027",
      "display" : "Overseer Chargehand Supervisor Water",
      "definition" : "Overseer Chargehand Supervisor Water"
    },
    {
      "code" : "8161.028",
      "display" : "Power Generating Machine Fitter Operator",
      "definition" : "Power Generating Machine Fitter Operator"
    },
    {
      "code" : "8161.029",
      "display" : "Power Generating Plant Operator",
      "definition" : "Power Generating Plant Operator"
    },
    {
      "code" : "8161.030",
      "display" : "Power Generating Plant Supervisor",
      "definition" : "Power Generating Plant Supervisor"
    },
    {
      "code" : "8161.031",
      "display" : "Power Reticulation Utilities Officer",
      "definition" : "Power Reticulation Utilities Officer"
    },
    {
      "code" : "8161.032",
      "display" : "Power Station Attendant",
      "definition" : "Power Station Attendant"
    },
    {
      "code" : "8161.033",
      "display" : "Power Station Switchboard Operator",
      "definition" : "Power Station Switchboard Operator"
    },
    {
      "code" : "8161.034",
      "display" : "Power System Operator",
      "definition" : "Power System Operator"
    },
    {
      "code" : "8161.035",
      "display" : "Powerhouse Plant Station Attendant",
      "definition" : "Powerhouse Plant Station Attendant"
    },
    {
      "code" : "8161.036",
      "display" : "Powerhouse Shift Operator",
      "definition" : "Powerhouse Shift Operator"
    },
    {
      "code" : "8161.037",
      "display" : "Pumping Station Operator",
      "definition" : "Pumping Station Operator"
    },
    {
      "code" : "8161.038",
      "display" : "Quality Controller of Power Generating Plant Operators",
      "definition" : "Quality Controller of Power Generating Plant Operators"
    },
    {
      "code" : "8161.039",
      "display" : "Raceman Power House",
      "definition" : "Raceman Power House"
    },
    {
      "code" : "8161.040",
      "display" : "Sewerage Plant Operator",
      "definition" : "Sewerage Plant Operator"
    },
    {
      "code" : "8161.041",
      "display" : "Sewerage Plant Treatment Operator",
      "definition" : "Sewerage Plant Treatment Operator"
    },
    {
      "code" : "8161.042",
      "display" : "Ships Engineroom Rating",
      "definition" : "Ships Engineroom Rating"
    },
    {
      "code" : "8161.043",
      "display" : "Ships Fireman Stoker",
      "definition" : "Ships Fireman Stoker"
    },
    {
      "code" : "8161.044",
      "display" : "Station Supervisor Hydroelectric Steam or Thermal",
      "definition" : "Station Supervisor Hydroelectric Steam or Thermal"
    },
    {
      "code" : "8161.045",
      "display" : "Stationary Engine Operator Driver",
      "definition" : "Stationary Engine Operator Driver"
    },
    {
      "code" : "8161.046",
      "display" : "Stationary Traction Engine Driver",
      "definition" : "Stationary Traction Engine Driver"
    },
    {
      "code" : "8161.047",
      "display" : "Steam or Thermal Shift Operator",
      "definition" : "Steam or Thermal Shift Operator"
    },
    {
      "code" : "8161.048",
      "display" : "Steam or Thermal Station Operator",
      "definition" : "Steam or Thermal Station Operator"
    },
    {
      "code" : "8161.049",
      "display" : "Steam Plant Operator",
      "definition" : "Steam Plant Operator"
    },
    {
      "code" : "8161.050",
      "display" : "Turbine Operator Electricity Production",
      "definition" : "Turbine Operator Electricity Production"
    },
    {
      "code" : "8211.001",
      "display" : "Automated Machine Operator",
      "definition" : "Automated Machine Operator"
    },
    {
      "code" : "8211.002",
      "display" : "Automated Metal Machine Supervisor",
      "definition" : "Automated Metal Machine Supervisor"
    },
    {
      "code" : "8211.003",
      "display" : "Bolt Maker",
      "definition" : "Bolt Maker"
    },
    {
      "code" : "8211.004",
      "display" : "Boring Machine Tool Operator",
      "definition" : "Boring Machine Tool Operator"
    },
    {
      "code" : "8211.005",
      "display" : "Cable Maker",
      "definition" : "Cable Maker"
    },
    {
      "code" : "8211.006",
      "display" : "Die Setter",
      "definition" : "Die Setter"
    },
    {
      "code" : "8211.007",
      "display" : "Fishing Tackle Maker",
      "definition" : "Fishing Tackle Maker"
    },
    {
      "code" : "8211.008",
      "display" : "Gear Cutter",
      "definition" : "Gear Cutter"
    },
    {
      "code" : "8211.009",
      "display" : "Guillotine Operator Metal",
      "definition" : "Guillotine Operator Metal"
    },
    {
      "code" : "8211.010",
      "display" : "Kaiwhakahaere Mihini",
      "definition" : "Kaiwhakahaere Mihini"
    },
    {
      "code" : "8211.011",
      "display" : "Kaiwhakahaere Mihini Aunoa",
      "definition" : "Kaiwhakahaere Mihini Aunoa"
    },
    {
      "code" : "8211.012",
      "display" : "Kaiwhakahaere Miihini",
      "definition" : "Kaiwhakahaere Miihini"
    },
    {
      "code" : "8211.013",
      "display" : "Kaiwhakahaere Miihini Aunoa",
      "definition" : "Kaiwhakahaere Miihini Aunoa"
    },
    {
      "code" : "8211.014",
      "display" : "Knife Maker",
      "definition" : "Knife Maker"
    },
    {
      "code" : "8211.015",
      "display" : "Lathe Operator",
      "definition" : "Lathe Operator"
    },
    {
      "code" : "8211.016",
      "display" : "Machine Setter",
      "definition" : "Machine Setter"
    },
    {
      "code" : "8211.017",
      "display" : "Machine Tool Grinder",
      "definition" : "Machine Tool Grinder"
    },
    {
      "code" : "8211.018",
      "display" : "Machine Tool Operating Supervisor",
      "definition" : "Machine Tool Operating Supervisor"
    },
    {
      "code" : "8211.019",
      "display" : "Machine Tool Operator",
      "definition" : "Machine Tool Operator"
    },
    {
      "code" : "8211.020",
      "display" : "Machine Tool Sharpener",
      "definition" : "Machine Tool Sharpener"
    },
    {
      "code" : "8211.021",
      "display" : "Metal Badge Maker",
      "definition" : "Metal Badge Maker"
    },
    {
      "code" : "8211.022",
      "display" : "Metal Grinder Precision Machine Operator",
      "definition" : "Metal Grinder Precision Machine Operator"
    },
    {
      "code" : "8211.023",
      "display" : "Metal Machine Tool Supervisor",
      "definition" : "Metal Machine Tool Supervisor"
    },
    {
      "code" : "8211.024",
      "display" : "Metal Machinist",
      "definition" : "Metal Machinist"
    },
    {
      "code" : "8211.025",
      "display" : "Metal Milling Machine Operator",
      "definition" : "Metal Milling Machine Operator"
    },
    {
      "code" : "8211.026",
      "display" : "Metal Planing Machine Operator",
      "definition" : "Metal Planing Machine Operator"
    },
    {
      "code" : "8211.027",
      "display" : "Metal Press Operator",
      "definition" : "Metal Press Operator"
    },
    {
      "code" : "8211.028",
      "display" : "Metal Sawing Machine Operator",
      "definition" : "Metal Sawing Machine Operator"
    },
    {
      "code" : "8211.029",
      "display" : "Metal Shaping Machine Operator",
      "definition" : "Metal Shaping Machine Operator"
    },
    {
      "code" : "8211.030",
      "display" : "Metal Spinner",
      "definition" : "Metal Spinner"
    },
    {
      "code" : "8211.031",
      "display" : "Metal Spinning Lathe Operator",
      "definition" : "Metal Spinning Lathe Operator"
    },
    {
      "code" : "8211.032",
      "display" : "Metal Working Lathe Operator",
      "definition" : "Metal Working Lathe Operator"
    },
    {
      "code" : "8211.033",
      "display" : "Metal Working Lathe Setter",
      "definition" : "Metal Working Lathe Setter"
    },
    {
      "code" : "8211.034",
      "display" : "Metal Working Machine Tool Setter Operator",
      "definition" : "Metal Working Machine Tool Setter Operator"
    },
    {
      "code" : "8211.035",
      "display" : "Milling Machine Setter Operator",
      "definition" : "Milling Machine Setter Operator"
    },
    {
      "code" : "8211.036",
      "display" : "Nail Maker",
      "definition" : "Nail Maker"
    },
    {
      "code" : "8211.037",
      "display" : "Needle Maker",
      "definition" : "Needle Maker"
    },
    {
      "code" : "8211.038",
      "display" : "Nut Maker",
      "definition" : "Nut Maker"
    },
    {
      "code" : "8211.039",
      "display" : "Pneumatic Press Operator",
      "definition" : "Pneumatic Press Operator"
    },
    {
      "code" : "8211.040",
      "display" : "Power Press Operator Metal",
      "definition" : "Power Press Operator Metal"
    },
    {
      "code" : "8211.041",
      "display" : "Power Shear Operator",
      "definition" : "Power Shear Operator"
    },
    {
      "code" : "8211.042",
      "display" : "Power Shear Operator Supervisor",
      "definition" : "Power Shear Operator Supervisor"
    },
    {
      "code" : "8211.043",
      "display" : "Press Setter Metal",
      "definition" : "Press Setter Metal"
    },
    {
      "code" : "8211.044",
      "display" : "Pressworker Metal",
      "definition" : "Pressworker Metal"
    },
    {
      "code" : "8211.045",
      "display" : "Quality Controller of Automated Machine Operators",
      "definition" : "Quality Controller of Automated Machine Operators"
    },
    {
      "code" : "8211.046",
      "display" : "Quality Controller of Power Shear Operators",
      "definition" : "Quality Controller of Power Shear Operators"
    },
    {
      "code" : "8211.047",
      "display" : "Quality Controller of Spring Maker And Wire Workers",
      "definition" : "Quality Controller of Spring Maker And Wire Workers"
    },
    {
      "code" : "8211.048",
      "display" : "Rough Grinder Metal Foundry",
      "definition" : "Rough Grinder Metal Foundry"
    },
    {
      "code" : "8211.049",
      "display" : "Screw Maker",
      "definition" : "Screw Maker"
    },
    {
      "code" : "8211.050",
      "display" : "Spring Maker",
      "definition" : "Spring Maker"
    },
    {
      "code" : "8211.051",
      "display" : "Spring Maker and Wire Worker",
      "definition" : "Spring Maker and Wire Worker"
    },
    {
      "code" : "8211.052",
      "display" : "Spring Maker Supervisor",
      "definition" : "Spring Maker Supervisor"
    },
    {
      "code" : "8211.053",
      "display" : "Steel Machine Operator",
      "definition" : "Steel Machine Operator"
    },
    {
      "code" : "8211.054",
      "display" : "Steel Ropes Machine Operator",
      "definition" : "Steel Ropes Machine Operator"
    },
    {
      "code" : "8211.055",
      "display" : "Tool Grinder",
      "definition" : "Tool Grinder"
    },
    {
      "code" : "8211.056",
      "display" : "Tool Grinder and Sharpener",
      "definition" : "Tool Grinder and Sharpener"
    },
    {
      "code" : "8211.057",
      "display" : "Tool Setter Operator Lathe",
      "definition" : "Tool Setter Operator Lathe"
    },
    {
      "code" : "8211.058",
      "display" : "Tool Sharpener",
      "definition" : "Tool Sharpener"
    },
    {
      "code" : "8211.059",
      "display" : "Universal Machine Operator Metal",
      "definition" : "Universal Machine Operator Metal"
    },
    {
      "code" : "8211.060",
      "display" : "Wire Goods Maker",
      "definition" : "Wire Goods Maker"
    },
    {
      "code" : "8211.061",
      "display" : "Wire Product Machine Operator",
      "definition" : "Wire Product Machine Operator"
    },
    {
      "code" : "8211.062",
      "display" : "Wire Worker",
      "definition" : "Wire Worker"
    },
    {
      "code" : "8212.001",
      "display" : "Artificial Stone Maker Building",
      "definition" : "Artificial Stone Maker Building"
    },
    {
      "code" : "8212.002",
      "display" : "Asbestos Cement Product Worker",
      "definition" : "Asbestos Cement Product Worker"
    },
    {
      "code" : "8212.003",
      "display" : "Cement Finisher Worker",
      "definition" : "Cement Finisher Worker"
    },
    {
      "code" : "8212.004",
      "display" : "Central Concrete Mixing Plant Operator",
      "definition" : "Central Concrete Mixing Plant Operator"
    },
    {
      "code" : "8212.005",
      "display" : "Concrete Batcher",
      "definition" : "Concrete Batcher"
    },
    {
      "code" : "8212.006",
      "display" : "Concrete Block Maker",
      "definition" : "Concrete Block Maker"
    },
    {
      "code" : "8212.007",
      "display" : "Concrete Finisher",
      "definition" : "Concrete Finisher"
    },
    {
      "code" : "8212.008",
      "display" : "Concrete Layer",
      "definition" : "Concrete Layer"
    },
    {
      "code" : "8212.009",
      "display" : "Concrete Placer",
      "definition" : "Concrete Placer"
    },
    {
      "code" : "8212.010",
      "display" : "Concrete Processing Production Supervisor",
      "definition" : "Concrete Processing Production Supervisor"
    },
    {
      "code" : "8212.011",
      "display" : "Concrete Processing Worker",
      "definition" : "Concrete Processing Worker"
    },
    {
      "code" : "8212.012",
      "display" : "Concrete Products Caster Maker",
      "definition" : "Concrete Products Caster Maker"
    },
    {
      "code" : "8212.013",
      "display" : "Concrete Pump Operator",
      "definition" : "Concrete Pump Operator"
    },
    {
      "code" : "8212.014",
      "display" : "Concrete Reinforcing Steel Placer",
      "definition" : "Concrete Reinforcing Steel Placer"
    },
    {
      "code" : "8212.015",
      "display" : "Concrete Worker",
      "definition" : "Concrete Worker"
    },
    {
      "code" : "8212.016",
      "display" : "Concrete Worker Construction",
      "definition" : "Concrete Worker Construction"
    },
    {
      "code" : "8212.017",
      "display" : "Concreting Contractor",
      "definition" : "Concreting Contractor"
    },
    {
      "code" : "8212.018",
      "display" : "Pile Post Pipe Maker Concrete",
      "definition" : "Pile Post Pipe Maker Concrete"
    },
    {
      "code" : "8212.019",
      "display" : "Precast Prestressed Concrete Products Worker",
      "definition" : "Precast Prestressed Concrete Products Worker"
    },
    {
      "code" : "8212.020",
      "display" : "Quality Controller of Concrete Workers",
      "definition" : "Quality Controller of Concrete Workers"
    },
    {
      "code" : "8221.001",
      "display" : "Cosmetic Production Worker",
      "definition" : "Cosmetic Production Worker"
    },
    {
      "code" : "8221.002",
      "display" : "Overseer Pharmaceutical Products",
      "definition" : "Overseer Pharmaceutical Products"
    },
    {
      "code" : "8221.003",
      "display" : "Pharmaceutical and Toiletry Products Machine Operator",
      "definition" : "Pharmaceutical and Toiletry Products Machine Operator"
    },
    {
      "code" : "8221.004",
      "display" : "Pharmaceutical and Toiletry Products Supervisor",
      "definition" : "Pharmaceutical and Toiletry Products Supervisor"
    },
    {
      "code" : "8221.005",
      "display" : "Pharmaceutical Production Worker",
      "definition" : "Pharmaceutical Production Worker"
    },
    {
      "code" : "8221.006",
      "display" : "Pharmacy Products Factory Worker",
      "definition" : "Pharmacy Products Factory Worker"
    },
    {
      "code" : "8221.007",
      "display" : "Pharmacy Products Machine Operator",
      "definition" : "Pharmacy Products Machine Operator"
    },
    {
      "code" : "8221.008",
      "display" : "Quality Controller of Pharmaceutical Toiletry Machine Operators",
      "definition" : "Quality Controller of Pharmaceutical Toiletry Machine Operators"
    },
    {
      "code" : "8221.009",
      "display" : "Soap Maker",
      "definition" : "Soap Maker"
    },
    {
      "code" : "8221.010",
      "display" : "Supervisor Pharmaceutical Products",
      "definition" : "Supervisor Pharmaceutical Products"
    },
    {
      "code" : "8221.011",
      "display" : "Toiletry Products Machine Operator",
      "definition" : "Toiletry Products Machine Operator"
    },
    {
      "code" : "8222.001",
      "display" : "Anodiser",
      "definition" : "Anodiser"
    },
    {
      "code" : "8222.002",
      "display" : "Brass Finisher Polisher",
      "definition" : "Brass Finisher Polisher"
    },
    {
      "code" : "8222.003",
      "display" : "Electro Polisher",
      "definition" : "Electro Polisher"
    },
    {
      "code" : "8222.004",
      "display" : "Electroplater",
      "definition" : "Electroplater"
    },
    {
      "code" : "8222.005",
      "display" : "Enameller",
      "definition" : "Enameller"
    },
    {
      "code" : "8222.006",
      "display" : "Finisher Brass Foundry",
      "definition" : "Finisher Brass Foundry"
    },
    {
      "code" : "8222.007",
      "display" : "Galvaniser",
      "definition" : "Galvaniser"
    },
    {
      "code" : "8222.008",
      "display" : "Hot Dip Plater",
      "definition" : "Hot Dip Plater"
    },
    {
      "code" : "8222.009",
      "display" : "Metal Cleaner",
      "definition" : "Metal Cleaner"
    },
    {
      "code" : "8222.010",
      "display" : "Metal Enameller",
      "definition" : "Metal Enameller"
    },
    {
      "code" : "8222.011",
      "display" : "Metal Finisher",
      "definition" : "Metal Finisher"
    },
    {
      "code" : "8222.012",
      "display" : "Metal Plater",
      "definition" : "Metal Plater"
    },
    {
      "code" : "8222.013",
      "display" : "Metal Polisher",
      "definition" : "Metal Polisher"
    },
    {
      "code" : "8222.014",
      "display" : "Metal Working Burnisher",
      "definition" : "Metal Working Burnisher"
    },
    {
      "code" : "8222.015",
      "display" : "Quality Controller of Electroplaters",
      "definition" : "Quality Controller of Electroplaters"
    },
    {
      "code" : "8222.016",
      "display" : "Quality Controller of Hot Dip Platers",
      "definition" : "Quality Controller of Hot Dip Platers"
    },
    {
      "code" : "8222.017",
      "display" : "Ultrasonic Cleaner Metal",
      "definition" : "Ultrasonic Cleaner Metal"
    },
    {
      "code" : "8223.001",
      "display" : "Dark Room Technician",
      "definition" : "Dark Room Technician"
    },
    {
      "code" : "8223.002",
      "display" : "Film Developer",
      "definition" : "Film Developer"
    },
    {
      "code" : "8223.003",
      "display" : "Film Printer",
      "definition" : "Film Printer"
    },
    {
      "code" : "8223.004",
      "display" : "Film Processing Worker",
      "definition" : "Film Processing Worker"
    },
    {
      "code" : "8223.005",
      "display" : "Film Processor",
      "definition" : "Film Processor"
    },
    {
      "code" : "8223.006",
      "display" : "Minilab Operator",
      "definition" : "Minilab Operator"
    },
    {
      "code" : "8223.007",
      "display" : "Photo Lab Assistant",
      "definition" : "Photo Lab Assistant"
    },
    {
      "code" : "8223.008",
      "display" : "Photo Lab Operator",
      "definition" : "Photo Lab Operator"
    },
    {
      "code" : "8223.009",
      "display" : "Photo Processor",
      "definition" : "Photo Processor"
    },
    {
      "code" : "8223.010",
      "display" : "Photographic Darkroom Operator",
      "definition" : "Photographic Darkroom Operator"
    },
    {
      "code" : "8223.011",
      "display" : "Photographic Darkroom Worker",
      "definition" : "Photographic Darkroom Worker"
    },
    {
      "code" : "8223.012",
      "display" : "Photographic Developer and Printer",
      "definition" : "Photographic Developer and Printer"
    },
    {
      "code" : "8223.013",
      "display" : "Photographic Laboratory Assistant",
      "definition" : "Photographic Laboratory Assistant"
    },
    {
      "code" : "8223.014",
      "display" : "Quality Controller of Photographic Darkroom Operators",
      "definition" : "Quality Controller of Photographic Darkroom Operators"
    },
    {
      "code" : "8231.001",
      "display" : "Maintenance Fitter Tyres",
      "definition" : "Maintenance Fitter Tyres"
    },
    {
      "code" : "8231.002",
      "display" : "Quality Controller of Tyre Retreaders",
      "definition" : "Quality Controller of Tyre Retreaders"
    },
    {
      "code" : "8231.003",
      "display" : "Rubber Mould Press Operator Tyres Tubes",
      "definition" : "Rubber Mould Press Operator Tyres Tubes"
    },
    {
      "code" : "8231.004",
      "display" : "Rubber Tyre Vulcaniser",
      "definition" : "Rubber Tyre Vulcaniser"
    },
    {
      "code" : "8231.005",
      "display" : "Tube Vulcaniser",
      "definition" : "Tube Vulcaniser"
    },
    {
      "code" : "8231.006",
      "display" : "Tyre Builder",
      "definition" : "Tyre Builder"
    },
    {
      "code" : "8231.007",
      "display" : "Tyre Builder Supervisor",
      "definition" : "Tyre Builder Supervisor"
    },
    {
      "code" : "8231.008",
      "display" : "Tyre Fitter",
      "definition" : "Tyre Fitter"
    },
    {
      "code" : "8231.009",
      "display" : "Tyre Moulder",
      "definition" : "Tyre Moulder"
    },
    {
      "code" : "8231.010",
      "display" : "Tyre Moulder and Vulcaniser",
      "definition" : "Tyre Moulder and Vulcaniser"
    },
    {
      "code" : "8231.011",
      "display" : "Tyre Retreader",
      "definition" : "Tyre Retreader"
    },
    {
      "code" : "8231.012",
      "display" : "Tyre Retreader Supervisor",
      "definition" : "Tyre Retreader Supervisor"
    },
    {
      "code" : "8231.013",
      "display" : "Tyre Serviceperson",
      "definition" : "Tyre Serviceperson"
    },
    {
      "code" : "8231.014",
      "display" : "Tyre Vulcaniser",
      "definition" : "Tyre Vulcaniser"
    },
    {
      "code" : "8232.001",
      "display" : "Formica Worker",
      "definition" : "Formica Worker"
    },
    {
      "code" : "8232.002",
      "display" : "Laminated Sheet Plastic Worker",
      "definition" : "Laminated Sheet Plastic Worker"
    },
    {
      "code" : "8232.003",
      "display" : "Laminator Plastic Products",
      "definition" : "Laminator Plastic Products"
    },
    {
      "code" : "8232.004",
      "display" : "Overseer Plastic Products",
      "definition" : "Overseer Plastic Products"
    },
    {
      "code" : "8232.005",
      "display" : "Overseer Rubber Products",
      "definition" : "Overseer Rubber Products"
    },
    {
      "code" : "8232.006",
      "display" : "Plastic Goods Casting Machine Operator",
      "definition" : "Plastic Goods Casting Machine Operator"
    },
    {
      "code" : "8232.007",
      "display" : "Plastic Moulding Machine Operator",
      "definition" : "Plastic Moulding Machine Operator"
    },
    {
      "code" : "8232.008",
      "display" : "Plastics Extruding Machine Operator",
      "definition" : "Plastics Extruding Machine Operator"
    },
    {
      "code" : "8232.009",
      "display" : "Plastics Laminator",
      "definition" : "Plastics Laminator"
    },
    {
      "code" : "8232.010",
      "display" : "Plastics Laminator Supervisor",
      "definition" : "Plastics Laminator Supervisor"
    },
    {
      "code" : "8232.011",
      "display" : "Plastics Machine Operator",
      "definition" : "Plastics Machine Operator"
    },
    {
      "code" : "8232.012",
      "display" : "Plastics Machine Supervisor",
      "definition" : "Plastics Machine Supervisor"
    },
    {
      "code" : "8232.013",
      "display" : "Plastics Machine Supervisor Excl Plastics Laminator",
      "definition" : "Plastics Machine Supervisor Excl Plastics Laminator"
    },
    {
      "code" : "8232.014",
      "display" : "Production Chargehand Foreman Rubber",
      "definition" : "Production Chargehand Foreman Rubber"
    },
    {
      "code" : "8232.015",
      "display" : "Production Supervisor Rubber",
      "definition" : "Production Supervisor Rubber"
    },
    {
      "code" : "8232.016",
      "display" : "Quality Controller Of Plastics Laminators",
      "definition" : "Quality Controller Of Plastics Laminators"
    },
    {
      "code" : "8232.017",
      "display" : "Quality Controller Of Plastics Machine Operators",
      "definition" : "Quality Controller Of Plastics Machine Operators"
    },
    {
      "code" : "8232.018",
      "display" : "Rubber Extruding Machine Operator",
      "definition" : "Rubber Extruding Machine Operator"
    },
    {
      "code" : "8232.019",
      "display" : "Rubber Machine Operator",
      "definition" : "Rubber Machine Operator"
    },
    {
      "code" : "8232.020",
      "display" : "Rubber Machine Supervisor",
      "definition" : "Rubber Machine Supervisor"
    },
    {
      "code" : "8232.021",
      "display" : "Rubber Millman",
      "definition" : "Rubber Millman"
    },
    {
      "code" : "8232.022",
      "display" : "Rubber Moulding Press Operator",
      "definition" : "Rubber Moulding Press Operator"
    },
    {
      "code" : "8232.023",
      "display" : "Rubber Rollerman",
      "definition" : "Rubber Rollerman"
    },
    {
      "code" : "8241.001",
      "display" : "Carpenters Benchhand",
      "definition" : "Carpenters Benchhand"
    },
    {
      "code" : "8241.002",
      "display" : "Chipboard Block Setter",
      "definition" : "Chipboard Block Setter"
    },
    {
      "code" : "8241.003",
      "display" : "Joiners Benchhand",
      "definition" : "Joiners Benchhand"
    },
    {
      "code" : "8241.004",
      "display" : "Joinery Machinist",
      "definition" : "Joinery Machinist"
    },
    {
      "code" : "8241.005",
      "display" : "Joinery Worker",
      "definition" : "Joinery Worker"
    },
    {
      "code" : "8241.006",
      "display" : "Joinery Worker Supervisor",
      "definition" : "Joinery Worker Supervisor"
    },
    {
      "code" : "8241.007",
      "display" : "Lathe Operator Wood",
      "definition" : "Lathe Operator Wood"
    },
    {
      "code" : "8241.008",
      "display" : "Lathe Setter Operator Wood",
      "definition" : "Lathe Setter Operator Wood"
    },
    {
      "code" : "8241.009",
      "display" : "Panel Production Worker",
      "definition" : "Panel Production Worker"
    },
    {
      "code" : "8241.010",
      "display" : "Particle Board Fixer",
      "definition" : "Particle Board Fixer"
    },
    {
      "code" : "8241.011",
      "display" : "Precision Band Sawyer",
      "definition" : "Precision Band Sawyer"
    },
    {
      "code" : "8241.012",
      "display" : "Timber Machinist",
      "definition" : "Timber Machinist"
    },
    {
      "code" : "8241.013",
      "display" : "Turner Wood",
      "definition" : "Turner Wood"
    },
    {
      "code" : "8241.014",
      "display" : "Wallboard Worker",
      "definition" : "Wallboard Worker"
    },
    {
      "code" : "8241.015",
      "display" : "Wood Carver Not Creative",
      "definition" : "Wood Carver Not Creative"
    },
    {
      "code" : "8241.016",
      "display" : "Wood Panel Production Supervisor",
      "definition" : "Wood Panel Production Supervisor"
    },
    {
      "code" : "8241.017",
      "display" : "Wood Panel Production Worker",
      "definition" : "Wood Panel Production Worker"
    },
    {
      "code" : "8241.018",
      "display" : "Wood Worker Machinist",
      "definition" : "Wood Worker Machinist"
    },
    {
      "code" : "8241.019",
      "display" : "Wooden Box Maker",
      "definition" : "Wooden Box Maker"
    },
    {
      "code" : "8241.020",
      "display" : "Woodwork Shaping Machine Operator",
      "definition" : "Woodwork Shaping Machine Operator"
    },
    {
      "code" : "8241.021",
      "display" : "Woodworking Boring Machine Operator",
      "definition" : "Woodworking Boring Machine Operator"
    },
    {
      "code" : "8241.022",
      "display" : "Woodworking Machine Setter Operator",
      "definition" : "Woodworking Machine Setter Operator"
    },
    {
      "code" : "8241.023",
      "display" : "Woodworking Machine Tool Setter Operator",
      "definition" : "Woodworking Machine Tool Setter Operator"
    },
    {
      "code" : "8241.024",
      "display" : "Woodworking Machinist",
      "definition" : "Woodworking Machinist"
    },
    {
      "code" : "8241.025",
      "display" : "Woodworking Machinist Precision",
      "definition" : "Woodworking Machinist Precision"
    },
    {
      "code" : "8242.001",
      "display" : "Preservation Plant Operator",
      "definition" : "Preservation Plant Operator"
    },
    {
      "code" : "8242.002",
      "display" : "Preservation Plant Supervisor",
      "definition" : "Preservation Plant Supervisor"
    },
    {
      "code" : "8242.003",
      "display" : "Quality Controller Of Wood Seasoning Kiln Operators",
      "definition" : "Quality Controller Of Wood Seasoning Kiln Operators"
    },
    {
      "code" : "8242.004",
      "display" : "Timber Treatment Kiln Operator",
      "definition" : "Timber Treatment Kiln Operator"
    },
    {
      "code" : "8242.005",
      "display" : "Timber Treatment Supervisor",
      "definition" : "Timber Treatment Supervisor"
    },
    {
      "code" : "8242.006",
      "display" : "Timber Treatment Worker",
      "definition" : "Timber Treatment Worker"
    },
    {
      "code" : "8242.007",
      "display" : "Wood Changer",
      "definition" : "Wood Changer"
    },
    {
      "code" : "8242.008",
      "display" : "Wood Impregnator",
      "definition" : "Wood Impregnator"
    },
    {
      "code" : "8242.009",
      "display" : "Wood Perforating Machine Operator",
      "definition" : "Wood Perforating Machine Operator"
    },
    {
      "code" : "8242.010",
      "display" : "Wood Seasoner",
      "definition" : "Wood Seasoner"
    },
    {
      "code" : "8242.011",
      "display" : "Wood Seasoning Kiln Operator",
      "definition" : "Wood Seasoning Kiln Operator"
    },
    {
      "code" : "8242.012",
      "display" : "Wood Seasoning Kiln Operator Supervisor",
      "definition" : "Wood Seasoning Kiln Operator Supervisor"
    },
    {
      "code" : "8242.013",
      "display" : "Wood Seasoning Worker",
      "definition" : "Wood Seasoning Worker"
    },
    {
      "code" : "8242.014",
      "display" : "Wood Treating Dipper",
      "definition" : "Wood Treating Dipper"
    },
    {
      "code" : "8242.015",
      "display" : "Wood Treating Tank Operator",
      "definition" : "Wood Treating Tank Operator"
    },
    {
      "code" : "8251.001",
      "display" : "Cardboard Assembler Fitter Worker",
      "definition" : "Cardboard Assembler Fitter Worker"
    },
    {
      "code" : "8251.002",
      "display" : "Cardboard Box Maker",
      "definition" : "Cardboard Box Maker"
    },
    {
      "code" : "8251.003",
      "display" : "Cardboard Forme Maker and Finisher",
      "definition" : "Cardboard Forme Maker and Finisher"
    },
    {
      "code" : "8251.004",
      "display" : "Cardboard Forme Maker and Finisher Supervisor",
      "definition" : "Cardboard Forme Maker and Finisher Supervisor"
    },
    {
      "code" : "8251.005",
      "display" : "Cardboard Lining Machine Operator",
      "definition" : "Cardboard Lining Machine Operator"
    },
    {
      "code" : "8251.006",
      "display" : "Cardboard Machine Operator",
      "definition" : "Cardboard Machine Operator"
    },
    {
      "code" : "8251.007",
      "display" : "Cardboard Maker",
      "definition" : "Cardboard Maker"
    },
    {
      "code" : "8251.008",
      "display" : "Carton Maker",
      "definition" : "Carton Maker"
    },
    {
      "code" : "8251.009",
      "display" : "Cellophane Bag Maker",
      "definition" : "Cellophane Bag Maker"
    },
    {
      "code" : "8251.010",
      "display" : "Cutting Machine Operator",
      "definition" : "Cutting Machine Operator"
    },
    {
      "code" : "8251.011",
      "display" : "Envelope Maker",
      "definition" : "Envelope Maker"
    },
    {
      "code" : "8251.012",
      "display" : "Guillotine Operator",
      "definition" : "Guillotine Operator"
    },
    {
      "code" : "8251.013",
      "display" : "Guillotine Operator Paper Products",
      "definition" : "Guillotine Operator Paper Products"
    },
    {
      "code" : "8251.014",
      "display" : "Guillotine Operator Paper Products Supervisor",
      "definition" : "Guillotine Operator Paper Products Supervisor"
    },
    {
      "code" : "8251.015",
      "display" : "Overseer Paper Products",
      "definition" : "Overseer Paper Products"
    },
    {
      "code" : "8251.016",
      "display" : "Paper Bag Maker",
      "definition" : "Paper Bag Maker"
    },
    {
      "code" : "8251.017",
      "display" : "Paper Box Folding Machine Operator",
      "definition" : "Paper Box Folding Machine Operator"
    },
    {
      "code" : "8251.018",
      "display" : "Paper Box Maker",
      "definition" : "Paper Box Maker"
    },
    {
      "code" : "8251.019",
      "display" : "Paper Folder",
      "definition" : "Paper Folder"
    },
    {
      "code" : "8251.020",
      "display" : "Paper Pattern Machine Operator",
      "definition" : "Paper Pattern Machine Operator"
    },
    {
      "code" : "8251.021",
      "display" : "Paper Product Maker",
      "definition" : "Paper Product Maker"
    },
    {
      "code" : "8251.022",
      "display" : "Paper Products Machine Operator",
      "definition" : "Paper Products Machine Operator"
    },
    {
      "code" : "8251.023",
      "display" : "Paper Products Making Supervisor",
      "definition" : "Paper Products Making Supervisor"
    },
    {
      "code" : "8251.024",
      "display" : "Press Operator Creasing and Cutting",
      "definition" : "Press Operator Creasing and Cutting"
    },
    {
      "code" : "8251.025",
      "display" : "Printing Forme Cutter",
      "definition" : "Printing Forme Cutter"
    },
    {
      "code" : "8251.026",
      "display" : "Production Chargehand Foreman Paper",
      "definition" : "Production Chargehand Foreman Paper"
    },
    {
      "code" : "8251.027",
      "display" : "Production Chargehand Foreman Paper Products",
      "definition" : "Production Chargehand Foreman Paper Products"
    },
    {
      "code" : "8251.028",
      "display" : "Production Supervisor Paper",
      "definition" : "Production Supervisor Paper"
    },
    {
      "code" : "8251.029",
      "display" : "Quality Controller Of Cardboard Forme Maker",
      "definition" : "Quality Controller Of Cardboard Forme Maker"
    },
    {
      "code" : "8251.030",
      "display" : "Quality Controller Of Guillotine Operators",
      "definition" : "Quality Controller Of Guillotine Operators"
    },
    {
      "code" : "8251.031",
      "display" : "Quality Controller Of Paper Products Machine Operators",
      "definition" : "Quality Controller Of Paper Products Machine Operators"
    },
    {
      "code" : "8261.001",
      "display" : "Back Winder (Fibre)",
      "definition" : "Back Winder (Fibre)"
    },
    {
      "code" : "8261.002",
      "display" : "Fibre Doubler",
      "definition" : "Fibre Doubler"
    },
    {
      "code" : "8261.003",
      "display" : "Fibre Twister",
      "definition" : "Fibre Twister"
    },
    {
      "code" : "8261.004",
      "display" : "Rope and Twine Machinist",
      "definition" : "Rope and Twine Machinist"
    },
    {
      "code" : "8261.005",
      "display" : "Rope and Twine Machinist Supervisor",
      "definition" : "Rope and Twine Machinist Supervisor"
    },
    {
      "code" : "8261.006",
      "display" : "Spinner and Winder",
      "definition" : "Spinner and Winder"
    },
    {
      "code" : "8261.007",
      "display" : "Spinning and Winding Supervisor",
      "definition" : "Spinning and Winding Supervisor"
    },
    {
      "code" : "8261.008",
      "display" : "Textile Industry Winder",
      "definition" : "Textile Industry Winder"
    },
    {
      "code" : "8261.009",
      "display" : "Thread and Yarn Piecer",
      "definition" : "Thread and Yarn Piecer"
    },
    {
      "code" : "8261.010",
      "display" : "Woollen Winder",
      "definition" : "Woollen Winder"
    },
    {
      "code" : "8262.001",
      "display" : "Bar Filler",
      "definition" : "Bar Filler"
    },
    {
      "code" : "8262.002",
      "display" : "Beam Warper",
      "definition" : "Beam Warper"
    },
    {
      "code" : "8262.003",
      "display" : "Braid Maker",
      "definition" : "Braid Maker"
    },
    {
      "code" : "8262.004",
      "display" : "Carpet Maker",
      "definition" : "Carpet Maker"
    },
    {
      "code" : "8262.005",
      "display" : "Carpet Making Machine Setter",
      "definition" : "Carpet Making Machine Setter"
    },
    {
      "code" : "8262.006",
      "display" : "Carpet Tufter",
      "definition" : "Carpet Tufter"
    },
    {
      "code" : "8262.007",
      "display" : "Carpet Weaver",
      "definition" : "Carpet Weaver"
    },
    {
      "code" : "8262.008",
      "display" : "Carpet Weaving Loom Operator",
      "definition" : "Carpet Weaving Loom Operator"
    },
    {
      "code" : "8262.009",
      "display" : "Carpet Weaving Loom Supervisor",
      "definition" : "Carpet Weaving Loom Supervisor"
    },
    {
      "code" : "8262.010",
      "display" : "Carpet Weaving Supervisor",
      "definition" : "Carpet Weaving Supervisor"
    },
    {
      "code" : "8262.011",
      "display" : "Cloth Burler",
      "definition" : "Cloth Burler"
    },
    {
      "code" : "8262.012",
      "display" : "Cloth Weaver",
      "definition" : "Cloth Weaver"
    },
    {
      "code" : "8262.013",
      "display" : "Cloth Weaving Loom Supervisor",
      "definition" : "Cloth Weaving Loom Supervisor"
    },
    {
      "code" : "8262.014",
      "display" : "Cloth Weaving Supervisor",
      "definition" : "Cloth Weaving Supervisor"
    },
    {
      "code" : "8262.015",
      "display" : "Creeler Weaving",
      "definition" : "Creeler Weaving"
    },
    {
      "code" : "8262.016",
      "display" : "Crochet Weaver",
      "definition" : "Crochet Weaver"
    },
    {
      "code" : "8262.017",
      "display" : "Crochet Worker",
      "definition" : "Crochet Worker"
    },
    {
      "code" : "8262.018",
      "display" : "Darner Textile Fabric",
      "definition" : "Darner Textile Fabric"
    },
    {
      "code" : "8262.019",
      "display" : "Fabrics Examiner Textiles",
      "definition" : "Fabrics Examiner Textiles"
    },
    {
      "code" : "8262.020",
      "display" : "Fabrics Inspector",
      "definition" : "Fabrics Inspector"
    },
    {
      "code" : "8262.021",
      "display" : "Hand Knitter",
      "definition" : "Hand Knitter"
    },
    {
      "code" : "8262.022",
      "display" : "Hosiery Finisher",
      "definition" : "Hosiery Finisher"
    },
    {
      "code" : "8262.023",
      "display" : "Hosiery Knitter",
      "definition" : "Hosiery Knitter"
    },
    {
      "code" : "8262.024",
      "display" : "Jacquard Weaver Loom Operator",
      "definition" : "Jacquard Weaver Loom Operator"
    },
    {
      "code" : "8262.025",
      "display" : "Knitter",
      "definition" : "Knitter"
    },
    {
      "code" : "8262.026",
      "display" : "Knitting Machine Operator",
      "definition" : "Knitting Machine Operator"
    },
    {
      "code" : "8262.027",
      "display" : "Knitting Machine Supervisor",
      "definition" : "Knitting Machine Supervisor"
    },
    {
      "code" : "8262.028",
      "display" : "Knitting Machinist",
      "definition" : "Knitting Machinist"
    },
    {
      "code" : "8262.029",
      "display" : "Knitwear Factory Bar Filler",
      "definition" : "Knitwear Factory Bar Filler"
    },
    {
      "code" : "8262.030",
      "display" : "Linker Weaving",
      "definition" : "Linker Weaving"
    },
    {
      "code" : "8262.031",
      "display" : "Loom Operator Cloth Weaving",
      "definition" : "Loom Operator Cloth Weaving"
    },
    {
      "code" : "8262.032",
      "display" : "Loom Operator Weaving Lace Making",
      "definition" : "Loom Operator Weaving Lace Making"
    },
    {
      "code" : "8262.033",
      "display" : "Loom Threader",
      "definition" : "Loom Threader"
    },
    {
      "code" : "8262.034",
      "display" : "Machine Knitter",
      "definition" : "Machine Knitter"
    },
    {
      "code" : "8262.035",
      "display" : "Mender Textile Fabric",
      "definition" : "Mender Textile Fabric"
    },
    {
      "code" : "8262.036",
      "display" : "Quality Controller of Cloth Weavers",
      "definition" : "Quality Controller of Cloth Weavers"
    },
    {
      "code" : "8262.037",
      "display" : "Quality Controller of Knitting Machinists",
      "definition" : "Quality Controller of Knitting Machinists"
    },
    {
      "code" : "8262.038",
      "display" : "Repairer Textile Fabric",
      "definition" : "Repairer Textile Fabric"
    },
    {
      "code" : "8262.039",
      "display" : "Rug Maker",
      "definition" : "Rug Maker"
    },
    {
      "code" : "8262.040",
      "display" : "Rug Weaver",
      "definition" : "Rug Weaver"
    },
    {
      "code" : "8262.041",
      "display" : "Tapestry Maker",
      "definition" : "Tapestry Maker"
    },
    {
      "code" : "8262.042",
      "display" : "Tapestry Weaver",
      "definition" : "Tapestry Weaver"
    },
    {
      "code" : "8262.043",
      "display" : "Textile Weaver",
      "definition" : "Textile Weaver"
    },
    {
      "code" : "8262.044",
      "display" : "Tying Machine Operator Woollen Mill",
      "definition" : "Tying Machine Operator Woollen Mill"
    },
    {
      "code" : "8262.045",
      "display" : "Warper Winder",
      "definition" : "Warper Winder"
    },
    {
      "code" : "8262.046",
      "display" : "Wool Felt Maker",
      "definition" : "Wool Felt Maker"
    },
    {
      "code" : "8263.001",
      "display" : "Alteration Hand",
      "definition" : "Alteration Hand"
    },
    {
      "code" : "8263.002",
      "display" : "Artificial Flower Maker",
      "definition" : "Artificial Flower Maker"
    },
    {
      "code" : "8263.003",
      "display" : "Buttonhole Maker",
      "definition" : "Buttonhole Maker"
    },
    {
      "code" : "8263.004",
      "display" : "Clothing Machinist",
      "definition" : "Clothing Machinist"
    },
    {
      "code" : "8263.005",
      "display" : "Clothing Outworker",
      "definition" : "Clothing Outworker"
    },
    {
      "code" : "8263.006",
      "display" : "Clothing Production Supervisor",
      "definition" : "Clothing Production Supervisor"
    },
    {
      "code" : "8263.007",
      "display" : "Curtain Making Sewing Machinist",
      "definition" : "Curtain Making Sewing Machinist"
    },
    {
      "code" : "8263.008",
      "display" : "Disposable Clothes Machine Operator",
      "definition" : "Disposable Clothes Machine Operator"
    },
    {
      "code" : "8263.009",
      "display" : "Doll and Stuffed Toy Making Supervisor",
      "definition" : "Doll and Stuffed Toy Making Supervisor"
    },
    {
      "code" : "8263.010",
      "display" : "Doll Repairer",
      "definition" : "Doll Repairer"
    },
    {
      "code" : "8263.011",
      "display" : "Embroiderer",
      "definition" : "Embroiderer"
    },
    {
      "code" : "8263.012",
      "display" : "Garment Stitcher",
      "definition" : "Garment Stitcher"
    },
    {
      "code" : "8263.013",
      "display" : "Garment Worker",
      "definition" : "Garment Worker"
    },
    {
      "code" : "8263.014",
      "display" : "Hand Needleworker",
      "definition" : "Hand Needleworker"
    },
    {
      "code" : "8263.015",
      "display" : "Hand Sewer",
      "definition" : "Hand Sewer"
    },
    {
      "code" : "8263.016",
      "display" : "Hat Blocker",
      "definition" : "Hat Blocker"
    },
    {
      "code" : "8263.017",
      "display" : "Hat Finisher",
      "definition" : "Hat Finisher"
    },
    {
      "code" : "8263.018",
      "display" : "Hat Maker",
      "definition" : "Hat Maker"
    },
    {
      "code" : "8263.019",
      "display" : "Hat or Cap Maker Machinist Sewer",
      "definition" : "Hat or Cap Maker Machinist Sewer"
    },
    {
      "code" : "8263.020",
      "display" : "Hat Trimmer",
      "definition" : "Hat Trimmer"
    },
    {
      "code" : "8263.021",
      "display" : "Hatter",
      "definition" : "Hatter"
    },
    {
      "code" : "8263.022",
      "display" : "Kaimahi Mihini Kakahu",
      "definition" : "Kaimahi Mihini Kakahu"
    },
    {
      "code" : "8263.023",
      "display" : "Kaimahi Mihini Tuitui",
      "definition" : "Kaimahi Mihini Tuitui"
    },
    {
      "code" : "8263.024",
      "display" : "Kaimahi Miihini Kaakahu",
      "definition" : "Kaimahi Miihini Kaakahu"
    },
    {
      "code" : "8263.025",
      "display" : "Kaimahi Miihini Tuitui",
      "definition" : "Kaimahi Miihini Tuitui"
    },
    {
      "code" : "8263.026",
      "display" : "Kaimahi Purere Tuitui",
      "definition" : "Kaimahi Purere Tuitui"
    },
    {
      "code" : "8263.027",
      "display" : "Kaimahi Puurere Tuitui",
      "definition" : "Kaimahi Puurere Tuitui"
    },
    {
      "code" : "8263.028",
      "display" : "Kaiwhakahaere Mihini Tuitui",
      "definition" : "Kaiwhakahaere Mihini Tuitui"
    },
    {
      "code" : "8263.029",
      "display" : "Kaiwhakahaere Miihini Tuitui",
      "definition" : "Kaiwhakahaere Miihini Tuitui"
    },
    {
      "code" : "8263.030",
      "display" : "Kaiwhakamahi Purere Tuitui",
      "definition" : "Kaiwhakamahi Purere Tuitui"
    },
    {
      "code" : "8263.031",
      "display" : "Kaiwhakamahi Puurere Tuitui",
      "definition" : "Kaiwhakamahi Puurere Tuitui"
    },
    {
      "code" : "8263.032",
      "display" : "Milliner",
      "definition" : "Milliner"
    },
    {
      "code" : "8263.033",
      "display" : "Needleworker",
      "definition" : "Needleworker"
    },
    {
      "code" : "8263.034",
      "display" : "Net Maker",
      "definition" : "Net Maker"
    },
    {
      "code" : "8263.035",
      "display" : "Outworker",
      "definition" : "Outworker"
    },
    {
      "code" : "8263.036",
      "display" : "Overlocker",
      "definition" : "Overlocker"
    },
    {
      "code" : "8263.037",
      "display" : "Overseer Textiles Clothing",
      "definition" : "Overseer Textiles Clothing"
    },
    {
      "code" : "8263.038",
      "display" : "Parachute Rigger",
      "definition" : "Parachute Rigger"
    },
    {
      "code" : "8263.039",
      "display" : "Process Worker Doll And Stuffed Toy",
      "definition" : "Process Worker Doll And Stuffed Toy"
    },
    {
      "code" : "8263.040",
      "display" : "Quality Controller of Embroiderers",
      "definition" : "Quality Controller of Embroiderers"
    },
    {
      "code" : "8263.041",
      "display" : "Quality Controller of Sewing Machinists",
      "definition" : "Quality Controller of Sewing Machinists"
    },
    {
      "code" : "8263.042",
      "display" : "Scarfmaker",
      "definition" : "Scarfmaker"
    },
    {
      "code" : "8263.043",
      "display" : "Seamstress",
      "definition" : "Seamstress"
    },
    {
      "code" : "8263.044",
      "display" : "Sewer Bag or Sack Maker",
      "definition" : "Sewer Bag or Sack Maker"
    },
    {
      "code" : "8263.045",
      "display" : "Sewing Machinist",
      "definition" : "Sewing Machinist"
    },
    {
      "code" : "8263.046",
      "display" : "Sewing Machinist Supervisor",
      "definition" : "Sewing Machinist Supervisor"
    },
    {
      "code" : "8263.047",
      "display" : "Soft Goods Machinist",
      "definition" : "Soft Goods Machinist"
    },
    {
      "code" : "8263.048",
      "display" : "Stuffed Toy Maker",
      "definition" : "Stuffed Toy Maker"
    },
    {
      "code" : "8263.049",
      "display" : "Textile Bag Making Machine Operator",
      "definition" : "Textile Bag Making Machine Operator"
    },
    {
      "code" : "8263.050",
      "display" : "Textile Bag Making Worker",
      "definition" : "Textile Bag Making Worker"
    },
    {
      "code" : "8263.051",
      "display" : "Textile Production Supervisor",
      "definition" : "Textile Production Supervisor"
    },
    {
      "code" : "8263.052",
      "display" : "Umbrella Maker",
      "definition" : "Umbrella Maker"
    },
    {
      "code" : "8263.053",
      "display" : "Umbrella Repairer",
      "definition" : "Umbrella Repairer"
    },
    {
      "code" : "8263.054",
      "display" : "Upholstery Machinist Car",
      "definition" : "Upholstery Machinist Car"
    },
    {
      "code" : "8263.055",
      "display" : "Upholstery Machinist Furniture",
      "definition" : "Upholstery Machinist Furniture"
    },
    {
      "code" : "8263.056",
      "display" : "Upholstery Machinist Soft Goods",
      "definition" : "Upholstery Machinist Soft Goods"
    },
    {
      "code" : "8263.057",
      "display" : "Upholstery Sewer Hand",
      "definition" : "Upholstery Sewer Hand"
    },
    {
      "code" : "8263.058",
      "display" : "Upholstery Sewer Machine",
      "definition" : "Upholstery Sewer Machine"
    },
    {
      "code" : "8263.059",
      "display" : "Wet Suit Machinist",
      "definition" : "Wet Suit Machinist"
    },
    {
      "code" : "8263.060",
      "display" : "Zip Machinist",
      "definition" : "Zip Machinist"
    },
    {
      "code" : "8264.001",
      "display" : "Bleacher",
      "definition" : "Bleacher"
    },
    {
      "code" : "8264.002",
      "display" : "Bleacher and Dyer",
      "definition" : "Bleacher and Dyer"
    },
    {
      "code" : "8264.003",
      "display" : "Bleacher Textiles and Garments",
      "definition" : "Bleacher Textiles and Garments"
    },
    {
      "code" : "8264.004",
      "display" : "Carpet Cleaner",
      "definition" : "Carpet Cleaner"
    },
    {
      "code" : "8264.005",
      "display" : "Carpet Cleaning Contractor",
      "definition" : "Carpet Cleaning Contractor"
    },
    {
      "code" : "8264.006",
      "display" : "Central Sterile Supply Assistant",
      "definition" : "Central Sterile Supply Assistant"
    },
    {
      "code" : "8264.007",
      "display" : "Cloth and Texiles Finisher",
      "definition" : "Cloth and Texiles Finisher"
    },
    {
      "code" : "8264.008",
      "display" : "Clothes Cleaner",
      "definition" : "Clothes Cleaner"
    },
    {
      "code" : "8264.009",
      "display" : "Clothing Presser",
      "definition" : "Clothing Presser"
    },
    {
      "code" : "8264.010",
      "display" : "Clothing Washer",
      "definition" : "Clothing Washer"
    },
    {
      "code" : "8264.011",
      "display" : "Dry Cleaner",
      "definition" : "Dry Cleaner"
    },
    {
      "code" : "8264.012",
      "display" : "Dry Cleaning Depot Assistant",
      "definition" : "Dry Cleaning Depot Assistant"
    },
    {
      "code" : "8264.013",
      "display" : "Dry Cleaning Presser",
      "definition" : "Dry Cleaning Presser"
    },
    {
      "code" : "8264.014",
      "display" : "Dry Cleaning Spotter",
      "definition" : "Dry Cleaning Spotter"
    },
    {
      "code" : "8264.015",
      "display" : "Drycleaner",
      "definition" : "Drycleaner"
    },
    {
      "code" : "8264.016",
      "display" : "Dyer Clothing",
      "definition" : "Dyer Clothing"
    },
    {
      "code" : "8264.017",
      "display" : "Folder Clothing Factory",
      "definition" : "Folder Clothing Factory"
    },
    {
      "code" : "8264.018",
      "display" : "Garment Cleaner",
      "definition" : "Garment Cleaner"
    },
    {
      "code" : "8264.019",
      "display" : "Garment Finisher",
      "definition" : "Garment Finisher"
    },
    {
      "code" : "8264.020",
      "display" : "Iron Machinist",
      "definition" : "Iron Machinist"
    },
    {
      "code" : "8264.021",
      "display" : "Launderer",
      "definition" : "Launderer"
    },
    {
      "code" : "8264.022",
      "display" : "Launderess",
      "definition" : "Launderess"
    },
    {
      "code" : "8264.023",
      "display" : "Laundress",
      "definition" : "Laundress"
    },
    {
      "code" : "8264.024",
      "display" : "Laundry Employee",
      "definition" : "Laundry Employee"
    },
    {
      "code" : "8264.025",
      "display" : "Laundry Machine Operator",
      "definition" : "Laundry Machine Operator"
    },
    {
      "code" : "8264.026",
      "display" : "Laundry Maid",
      "definition" : "Laundry Maid"
    },
    {
      "code" : "8264.027",
      "display" : "Laundry Mangler",
      "definition" : "Laundry Mangler"
    },
    {
      "code" : "8264.028",
      "display" : "Laundry Supervisor",
      "definition" : "Laundry Supervisor"
    },
    {
      "code" : "8264.029",
      "display" : "Laundry Worker",
      "definition" : "Laundry Worker"
    },
    {
      "code" : "8264.030",
      "display" : "Laundryman",
      "definition" : "Laundryman"
    },
    {
      "code" : "8264.031",
      "display" : "Presser",
      "definition" : "Presser"
    },
    {
      "code" : "8264.032",
      "display" : "Presser Cloth Woollen Mills",
      "definition" : "Presser Cloth Woollen Mills"
    },
    {
      "code" : "8264.033",
      "display" : "Presser Clothing Factory",
      "definition" : "Presser Clothing Factory"
    },
    {
      "code" : "8264.034",
      "display" : "Presser Woollen Mills",
      "definition" : "Presser Woollen Mills"
    },
    {
      "code" : "8264.035",
      "display" : "Quality Controller of Bleachers And Dyers",
      "definition" : "Quality Controller of Bleachers And Dyers"
    },
    {
      "code" : "8264.036",
      "display" : "Quality Controller of Pressers",
      "definition" : "Quality Controller of Pressers"
    },
    {
      "code" : "8264.037",
      "display" : "Quality Controller of Textile Finishers",
      "definition" : "Quality Controller of Textile Finishers"
    },
    {
      "code" : "8264.038",
      "display" : "Starcher",
      "definition" : "Starcher"
    },
    {
      "code" : "8264.039",
      "display" : "Textile Dyeing Worker",
      "definition" : "Textile Dyeing Worker"
    },
    {
      "code" : "8264.040",
      "display" : "Textile Dyer",
      "definition" : "Textile Dyer"
    },
    {
      "code" : "8264.041",
      "display" : "Textile Finisher",
      "definition" : "Textile Finisher"
    },
    {
      "code" : "8264.042",
      "display" : "Textile Finisher Supervisor",
      "definition" : "Textile Finisher Supervisor"
    },
    {
      "code" : "8264.043",
      "display" : "Textile Finishing Worker",
      "definition" : "Textile Finishing Worker"
    },
    {
      "code" : "8264.044",
      "display" : "Textile Press Operating Worker",
      "definition" : "Textile Press Operating Worker"
    },
    {
      "code" : "8264.045",
      "display" : "Textile Press Operator",
      "definition" : "Textile Press Operator"
    },
    {
      "code" : "8264.046",
      "display" : "Textile Shrinker",
      "definition" : "Textile Shrinker"
    },
    {
      "code" : "8264.047",
      "display" : "Textile Sizer",
      "definition" : "Textile Sizer"
    },
    {
      "code" : "8264.048",
      "display" : "Textile Slasher",
      "definition" : "Textile Slasher"
    },
    {
      "code" : "8264.049",
      "display" : "Textile Taper",
      "definition" : "Textile Taper"
    },
    {
      "code" : "8264.050",
      "display" : "Textile Washer",
      "definition" : "Textile Washer"
    },
    {
      "code" : "8264.051",
      "display" : "Washing Machine Operator",
      "definition" : "Washing Machine Operator"
    },
    {
      "code" : "8264.052",
      "display" : "Washing Machine Operator Laundry",
      "definition" : "Washing Machine Operator Laundry"
    },
    {
      "code" : "8264.053",
      "display" : "Waterproofer Textile Fabrics",
      "definition" : "Waterproofer Textile Fabrics"
    },
    {
      "code" : "8264.054",
      "display" : "Waterproofing Applicator",
      "definition" : "Waterproofing Applicator"
    },
    {
      "code" : "8265.001",
      "display" : "Fibre Blender",
      "definition" : "Fibre Blender"
    },
    {
      "code" : "8265.002",
      "display" : "Fibre Carder",
      "definition" : "Fibre Carder"
    },
    {
      "code" : "8265.003",
      "display" : "Fibre Classer",
      "definition" : "Fibre Classer"
    },
    {
      "code" : "8265.004",
      "display" : "Fibre Comber",
      "definition" : "Fibre Comber"
    },
    {
      "code" : "8265.005",
      "display" : "Fibre Drawer",
      "definition" : "Fibre Drawer"
    },
    {
      "code" : "8265.006",
      "display" : "Fibre Frame Operator",
      "definition" : "Fibre Frame Operator"
    },
    {
      "code" : "8265.007",
      "display" : "Fibre Grader",
      "definition" : "Fibre Grader"
    },
    {
      "code" : "8265.008",
      "display" : "Fibre Lapper",
      "definition" : "Fibre Lapper"
    },
    {
      "code" : "8265.009",
      "display" : "Fibre Mixer",
      "definition" : "Fibre Mixer"
    },
    {
      "code" : "8265.010",
      "display" : "Fibre Picker",
      "definition" : "Fibre Picker"
    },
    {
      "code" : "8265.011",
      "display" : "Fibre Preparer",
      "definition" : "Fibre Preparer"
    },
    {
      "code" : "8265.012",
      "display" : "Fibre Rover",
      "definition" : "Fibre Rover"
    },
    {
      "code" : "8265.013",
      "display" : "Fibre Supervisor",
      "definition" : "Fibre Supervisor"
    },
    {
      "code" : "8265.014",
      "display" : "Flax Preparer",
      "definition" : "Flax Preparer"
    },
    {
      "code" : "8265.015",
      "display" : "Flock Maker Teaser",
      "definition" : "Flock Maker Teaser"
    },
    {
      "code" : "8265.016",
      "display" : "Gill Box Finisher Weaving",
      "definition" : "Gill Box Finisher Weaving"
    },
    {
      "code" : "8265.017",
      "display" : "Washer Raw Fibres",
      "definition" : "Washer Raw Fibres"
    },
    {
      "code" : "8265.018",
      "display" : "Wool Blender",
      "definition" : "Wool Blender"
    },
    {
      "code" : "8265.019",
      "display" : "Wool Carder",
      "definition" : "Wool Carder"
    },
    {
      "code" : "8265.020",
      "display" : "Wool Comber",
      "definition" : "Wool Comber"
    },
    {
      "code" : "8265.021",
      "display" : "Wool Drawer",
      "definition" : "Wool Drawer"
    },
    {
      "code" : "8265.022",
      "display" : "Wool Dryer",
      "definition" : "Wool Dryer"
    },
    {
      "code" : "8265.023",
      "display" : "Wool Preparer",
      "definition" : "Wool Preparer"
    },
    {
      "code" : "8265.024",
      "display" : "Wool Scourer",
      "definition" : "Wool Scourer"
    },
    {
      "code" : "8265.025",
      "display" : "Wool Scourer Supervisor",
      "definition" : "Wool Scourer Supervisor"
    },
    {
      "code" : "8265.026",
      "display" : "Wool Stapler",
      "definition" : "Wool Stapler"
    },
    {
      "code" : "8265.027",
      "display" : "Wool Top Machine Operator",
      "definition" : "Wool Top Machine Operator"
    },
    {
      "code" : "8271.001",
      "display" : "Boner",
      "definition" : "Boner"
    },
    {
      "code" : "8271.002",
      "display" : "Butcher Freezing Worker Abattoir",
      "definition" : "Butcher Freezing Worker Abattoir"
    },
    {
      "code" : "8271.003",
      "display" : "Butchers Labourer",
      "definition" : "Butchers Labourer"
    },
    {
      "code" : "8271.004",
      "display" : "Butchery Assistant",
      "definition" : "Butchery Assistant"
    },
    {
      "code" : "8271.005",
      "display" : "Chicken Processor",
      "definition" : "Chicken Processor"
    },
    {
      "code" : "8271.006",
      "display" : "Curing and Pickling Worker",
      "definition" : "Curing and Pickling Worker"
    },
    {
      "code" : "8271.007",
      "display" : "Fish Boner",
      "definition" : "Fish Boner"
    },
    {
      "code" : "8271.008",
      "display" : "Fish Canning Process Supervisor",
      "definition" : "Fish Canning Process Supervisor"
    },
    {
      "code" : "8271.009",
      "display" : "Fish Canning Process Worker",
      "definition" : "Fish Canning Process Worker"
    },
    {
      "code" : "8271.010",
      "display" : "Fish Cutter",
      "definition" : "Fish Cutter"
    },
    {
      "code" : "8271.011",
      "display" : "Fish Dehydrator",
      "definition" : "Fish Dehydrator"
    },
    {
      "code" : "8271.012",
      "display" : "Fish Factory Supervisor",
      "definition" : "Fish Factory Supervisor"
    },
    {
      "code" : "8271.013",
      "display" : "Fish Filleter",
      "definition" : "Fish Filleter"
    },
    {
      "code" : "8271.014",
      "display" : "Fish Preserver",
      "definition" : "Fish Preserver"
    },
    {
      "code" : "8271.015",
      "display" : "Fish Preserving Supervisor",
      "definition" : "Fish Preserving Supervisor"
    },
    {
      "code" : "8271.016",
      "display" : "Fish Process Worker",
      "definition" : "Fish Process Worker"
    },
    {
      "code" : "8271.017",
      "display" : "Fish Process Worker Supervisor",
      "definition" : "Fish Process Worker Supervisor"
    },
    {
      "code" : "8271.018",
      "display" : "Fish Processing Worker",
      "definition" : "Fish Processing Worker"
    },
    {
      "code" : "8271.019",
      "display" : "Fish Processor",
      "definition" : "Fish Processor"
    },
    {
      "code" : "8271.020",
      "display" : "Fish Shed Assistant",
      "definition" : "Fish Shed Assistant"
    },
    {
      "code" : "8271.021",
      "display" : "Food Smoker",
      "definition" : "Food Smoker"
    },
    {
      "code" : "8271.022",
      "display" : "Freezer Hand",
      "definition" : "Freezer Hand"
    },
    {
      "code" : "8271.023",
      "display" : "Freezing and Abattoir Worker Killing Chain",
      "definition" : "Freezing and Abattoir Worker Killing Chain"
    },
    {
      "code" : "8271.024",
      "display" : "Freezing Worker",
      "definition" : "Freezing Worker"
    },
    {
      "code" : "8271.025",
      "display" : "Freezing Works Chainman",
      "definition" : "Freezing Works Chainman"
    },
    {
      "code" : "8271.026",
      "display" : "Freezing Works Chamberman",
      "definition" : "Freezing Works Chamberman"
    },
    {
      "code" : "8271.027",
      "display" : "Freezing Works Chiller Hand",
      "definition" : "Freezing Works Chiller Hand"
    },
    {
      "code" : "8271.028",
      "display" : "Freezing Works Cooling Floor Hand",
      "definition" : "Freezing Works Cooling Floor Hand"
    },
    {
      "code" : "8271.029",
      "display" : "Freezing Works Dollyman",
      "definition" : "Freezing Works Dollyman"
    },
    {
      "code" : "8271.030",
      "display" : "Freezing Works Freezer Hand",
      "definition" : "Freezing Works Freezer Hand"
    },
    {
      "code" : "8271.031",
      "display" : "Freezing Works Meat Cutter",
      "definition" : "Freezing Works Meat Cutter"
    },
    {
      "code" : "8271.032",
      "display" : "Freezing Works Scraper",
      "definition" : "Freezing Works Scraper"
    },
    {
      "code" : "8271.033",
      "display" : "Freezing Works Slaughterer",
      "definition" : "Freezing Works Slaughterer"
    },
    {
      "code" : "8271.034",
      "display" : "Freezing Works Stripper",
      "definition" : "Freezing Works Stripper"
    },
    {
      "code" : "8271.035",
      "display" : "Kaimahi Miiti",
      "definition" : "Kaimahi Miiti"
    },
    {
      "code" : "8271.036",
      "display" : "Kaimahi Miti",
      "definition" : "Kaimahi Miti"
    },
    {
      "code" : "8271.037",
      "display" : "Kaipatu Hipi",
      "definition" : "Kaipatu Hipi"
    },
    {
      "code" : "8271.038",
      "display" : "Kaipatu Kararehe",
      "definition" : "Kaipatu Kararehe"
    },
    {
      "code" : "8271.039",
      "display" : "Kaipatu Kau",
      "definition" : "Kaipatu Kau"
    },
    {
      "code" : "8271.040",
      "display" : "Kaipatu Miiti",
      "definition" : "Kaipatu Miiti"
    },
    {
      "code" : "8271.041",
      "display" : "Kaipatu Miti",
      "definition" : "Kaipatu Miti"
    },
    {
      "code" : "8271.042",
      "display" : "Knife Hand",
      "definition" : "Knife Hand"
    },
    {
      "code" : "8271.043",
      "display" : "Land Based Oyster Opener",
      "definition" : "Land Based Oyster Opener"
    },
    {
      "code" : "8271.044",
      "display" : "Meat Boner",
      "definition" : "Meat Boner"
    },
    {
      "code" : "8271.045",
      "display" : "Meat Canning Process Supervisor",
      "definition" : "Meat Canning Process Supervisor"
    },
    {
      "code" : "8271.046",
      "display" : "Meat Canning Process Worker",
      "definition" : "Meat Canning Process Worker"
    },
    {
      "code" : "8271.047",
      "display" : "Meat Cutter",
      "definition" : "Meat Cutter"
    },
    {
      "code" : "8271.048",
      "display" : "Meat Dehydrator",
      "definition" : "Meat Dehydrator"
    },
    {
      "code" : "8271.049",
      "display" : "Meat Preserver",
      "definition" : "Meat Preserver"
    },
    {
      "code" : "8271.050",
      "display" : "Meat Preserving Supervisor",
      "definition" : "Meat Preserving Supervisor"
    },
    {
      "code" : "8271.051",
      "display" : "Meat Processing Worker",
      "definition" : "Meat Processing Worker"
    },
    {
      "code" : "8271.052",
      "display" : "Meat Slicer",
      "definition" : "Meat Slicer"
    },
    {
      "code" : "8271.053",
      "display" : "Meat Trimmer",
      "definition" : "Meat Trimmer"
    },
    {
      "code" : "8271.054",
      "display" : "Meat Worker",
      "definition" : "Meat Worker"
    },
    {
      "code" : "8271.055",
      "display" : "Mussel Opener",
      "definition" : "Mussel Opener"
    },
    {
      "code" : "8271.056",
      "display" : "Mussel Processor",
      "definition" : "Mussel Processor"
    },
    {
      "code" : "8271.057",
      "display" : "Offal Man",
      "definition" : "Offal Man"
    },
    {
      "code" : "8271.058",
      "display" : "Onshore Seafood Processor",
      "definition" : "Onshore Seafood Processor"
    },
    {
      "code" : "8271.059",
      "display" : "Oyster Canner",
      "definition" : "Oyster Canner"
    },
    {
      "code" : "8271.060",
      "display" : "Oyster Canner Opener Supervisor",
      "definition" : "Oyster Canner Opener Supervisor"
    },
    {
      "code" : "8271.061",
      "display" : "Oyster Opener",
      "definition" : "Oyster Opener"
    },
    {
      "code" : "8271.062",
      "display" : "Oyster Opener and Canner",
      "definition" : "Oyster Opener and Canner"
    },
    {
      "code" : "8271.063",
      "display" : "Poultry Worker Abattoir Freezing Works",
      "definition" : "Poultry Worker Abattoir Freezing Works"
    },
    {
      "code" : "8271.064",
      "display" : "Quality Controller of Fish Canning Process Workers",
      "definition" : "Quality Controller of Fish Canning Process Workers"
    },
    {
      "code" : "8271.065",
      "display" : "Quality Controller of Fish Process Workers",
      "definition" : "Quality Controller of Fish Process Workers"
    },
    {
      "code" : "8271.066",
      "display" : "Quality Controller of Meat Canning Process Workers",
      "definition" : "Quality Controller of Meat Canning Process Workers"
    },
    {
      "code" : "8271.067",
      "display" : "Quality Controller of Slaughterers",
      "definition" : "Quality Controller of Slaughterers"
    },
    {
      "code" : "8271.068",
      "display" : "Quality Controller of Smallgoods Makers",
      "definition" : "Quality Controller of Smallgoods Makers"
    },
    {
      "code" : "8271.069",
      "display" : "Sausage Casing Maker",
      "definition" : "Sausage Casing Maker"
    },
    {
      "code" : "8271.070",
      "display" : "Sausage Maker",
      "definition" : "Sausage Maker"
    },
    {
      "code" : "8271.071",
      "display" : "Seafood Factory Supervisor",
      "definition" : "Seafood Factory Supervisor"
    },
    {
      "code" : "8271.072",
      "display" : "Slaughter Man",
      "definition" : "Slaughter Man"
    },
    {
      "code" : "8271.073",
      "display" : "Slaughterer",
      "definition" : "Slaughterer"
    },
    {
      "code" : "8271.074",
      "display" : "Slaughterhouse Assistant",
      "definition" : "Slaughterhouse Assistant"
    },
    {
      "code" : "8271.075",
      "display" : "Slaughtering Assistant",
      "definition" : "Slaughtering Assistant"
    },
    {
      "code" : "8271.076",
      "display" : "Slaughtering Supervisor",
      "definition" : "Slaughtering Supervisor"
    },
    {
      "code" : "8271.077",
      "display" : "Slaughterman",
      "definition" : "Slaughterman"
    },
    {
      "code" : "8271.078",
      "display" : "Smallgoods Maker",
      "definition" : "Smallgoods Maker"
    },
    {
      "code" : "8271.079",
      "display" : "Smallgoods Supervisor Maker",
      "definition" : "Smallgoods Supervisor Maker"
    },
    {
      "code" : "8271.080",
      "display" : "Wetfish Processor",
      "definition" : "Wetfish Processor"
    },
    {
      "code" : "8272.001",
      "display" : "Butter and Milk Fats Products Maker",
      "definition" : "Butter and Milk Fats Products Maker"
    },
    {
      "code" : "8272.002",
      "display" : "Butter Maker Grader Tester",
      "definition" : "Butter Maker Grader Tester"
    },
    {
      "code" : "8272.003",
      "display" : "Casein Worker Maker",
      "definition" : "Casein Worker Maker"
    },
    {
      "code" : "8272.004",
      "display" : "Cheese Factory Worker",
      "definition" : "Cheese Factory Worker"
    },
    {
      "code" : "8272.005",
      "display" : "Cheese Grader Tester",
      "definition" : "Cheese Grader Tester"
    },
    {
      "code" : "8272.006",
      "display" : "Cheese Maker",
      "definition" : "Cheese Maker"
    },
    {
      "code" : "8272.007",
      "display" : "Cheese Making Supervisor",
      "definition" : "Cheese Making Supervisor"
    },
    {
      "code" : "8272.008",
      "display" : "Cheese Salter",
      "definition" : "Cheese Salter"
    },
    {
      "code" : "8272.009",
      "display" : "Condensed Milk Maker Process Worker",
      "definition" : "Condensed Milk Maker Process Worker"
    },
    {
      "code" : "8272.010",
      "display" : "Cooker Operator Dairy Products",
      "definition" : "Cooker Operator Dairy Products"
    },
    {
      "code" : "8272.011",
      "display" : "Cottage Cheese Maker",
      "definition" : "Cottage Cheese Maker"
    },
    {
      "code" : "8272.012",
      "display" : "Dairy Factory Worker",
      "definition" : "Dairy Factory Worker"
    },
    {
      "code" : "8272.013",
      "display" : "Dairy Products Inspector Grader Tester",
      "definition" : "Dairy Products Inspector Grader Tester"
    },
    {
      "code" : "8272.014",
      "display" : "Dairy Products Instructor",
      "definition" : "Dairy Products Instructor"
    },
    {
      "code" : "8272.015",
      "display" : "Dairy Products Processor",
      "definition" : "Dairy Products Processor"
    },
    {
      "code" : "8272.016",
      "display" : "Dried Milk Worker",
      "definition" : "Dried Milk Worker"
    },
    {
      "code" : "8272.017",
      "display" : "Ice Cream Maker",
      "definition" : "Ice Cream Maker"
    },
    {
      "code" : "8272.018",
      "display" : "Milk and Other Dairy Products Maker",
      "definition" : "Milk and Other Dairy Products Maker"
    },
    {
      "code" : "8272.019",
      "display" : "Milk and Other Dairy Products Supervisor",
      "definition" : "Milk and Other Dairy Products Supervisor"
    },
    {
      "code" : "8272.020",
      "display" : "Milk Pasteuriser",
      "definition" : "Milk Pasteuriser"
    },
    {
      "code" : "8272.021",
      "display" : "Milk Powder Maker",
      "definition" : "Milk Powder Maker"
    },
    {
      "code" : "8272.022",
      "display" : "Milk Process Supervisor",
      "definition" : "Milk Process Supervisor"
    },
    {
      "code" : "8272.023",
      "display" : "Milk Process Worker",
      "definition" : "Milk Process Worker"
    },
    {
      "code" : "8272.024",
      "display" : "Milk Treatment Station Worker",
      "definition" : "Milk Treatment Station Worker"
    },
    {
      "code" : "8272.025",
      "display" : "Other Dairy Products Maker",
      "definition" : "Other Dairy Products Maker"
    },
    {
      "code" : "8272.026",
      "display" : "Pasteurising Worker",
      "definition" : "Pasteurising Worker"
    },
    {
      "code" : "8272.027",
      "display" : "Yogurt Maker",
      "definition" : "Yogurt Maker"
    },
    {
      "code" : "8273.001",
      "display" : "Cereal Miller",
      "definition" : "Cereal Miller"
    },
    {
      "code" : "8273.002",
      "display" : "Flour Mill Worker",
      "definition" : "Flour Mill Worker"
    },
    {
      "code" : "8273.003",
      "display" : "Flour Miller",
      "definition" : "Flour Miller"
    },
    {
      "code" : "8273.004",
      "display" : "Flour or Grain Millhand",
      "definition" : "Flour or Grain Millhand"
    },
    {
      "code" : "8273.005",
      "display" : "Flourmill Kilnman",
      "definition" : "Flourmill Kilnman"
    },
    {
      "code" : "8273.006",
      "display" : "Grain Cleaner",
      "definition" : "Grain Cleaner"
    },
    {
      "code" : "8273.007",
      "display" : "Grain Crusher",
      "definition" : "Grain Crusher"
    },
    {
      "code" : "8273.008",
      "display" : "Grain Dryer",
      "definition" : "Grain Dryer"
    },
    {
      "code" : "8273.009",
      "display" : "Grain Grader",
      "definition" : "Grain Grader"
    },
    {
      "code" : "8273.010",
      "display" : "Grain Miller",
      "definition" : "Grain Miller"
    },
    {
      "code" : "8273.011",
      "display" : "Grain Miller Supervisor",
      "definition" : "Grain Miller Supervisor"
    },
    {
      "code" : "8273.012",
      "display" : "Lucerne Pellets Maker",
      "definition" : "Lucerne Pellets Maker"
    },
    {
      "code" : "8273.013",
      "display" : "Seed Cleaning Machine Operator",
      "definition" : "Seed Cleaning Machine Operator"
    },
    {
      "code" : "8273.014",
      "display" : "Seed Grading Machine Operator",
      "definition" : "Seed Grading Machine Operator"
    },
    {
      "code" : "8273.015",
      "display" : "Spice Miller Factory Worker",
      "definition" : "Spice Miller Factory Worker"
    },
    {
      "code" : "8273.016",
      "display" : "Wheat Miller",
      "definition" : "Wheat Miller"
    },
    {
      "code" : "8274.001",
      "display" : "Animal Food Processor",
      "definition" : "Animal Food Processor"
    },
    {
      "code" : "8274.002",
      "display" : "Baked Goods and Cereals Producing Machine Operator",
      "definition" : "Baked Goods and Cereals Producing Machine Operator"
    },
    {
      "code" : "8274.003",
      "display" : "Baked Goods and Cereals Producing Machine Supervisor",
      "definition" : "Baked Goods and Cereals Producing Machine Supervisor"
    },
    {
      "code" : "8274.004",
      "display" : "Bakehouse Assistant",
      "definition" : "Bakehouse Assistant"
    },
    {
      "code" : "8274.005",
      "display" : "Bakers Assistant",
      "definition" : "Bakers Assistant"
    },
    {
      "code" : "8274.006",
      "display" : "Bakers Labourer",
      "definition" : "Bakers Labourer"
    },
    {
      "code" : "8274.007",
      "display" : "Bakery Assistant",
      "definition" : "Bakery Assistant"
    },
    {
      "code" : "8274.008",
      "display" : "Bakery Labourer",
      "definition" : "Bakery Labourer"
    },
    {
      "code" : "8274.009",
      "display" : "Bakery Machinist",
      "definition" : "Bakery Machinist"
    },
    {
      "code" : "8274.010",
      "display" : "Bakery Ovenman",
      "definition" : "Bakery Ovenman"
    },
    {
      "code" : "8274.011",
      "display" : "Bakery Supervisor",
      "definition" : "Bakery Supervisor"
    },
    {
      "code" : "8274.012",
      "display" : "Bakery Table Hand",
      "definition" : "Bakery Table Hand"
    },
    {
      "code" : "8274.013",
      "display" : "Bakery Worker",
      "definition" : "Bakery Worker"
    },
    {
      "code" : "8274.014",
      "display" : "Cereal Grain Machinist",
      "definition" : "Cereal Grain Machinist"
    },
    {
      "code" : "8274.015",
      "display" : "Macaroni Maker",
      "definition" : "Macaroni Maker"
    },
    {
      "code" : "8274.016",
      "display" : "Stock Food Making Machine Operator",
      "definition" : "Stock Food Making Machine Operator"
    },
    {
      "code" : "8275.001",
      "display" : "Aerated Water Cordial Worker",
      "definition" : "Aerated Water Cordial Worker"
    },
    {
      "code" : "8275.002",
      "display" : "Beverage Processor Non Alcoholic",
      "definition" : "Beverage Processor Non Alcoholic"
    },
    {
      "code" : "8275.003",
      "display" : "Canning and Bottling Process Worker",
      "definition" : "Canning and Bottling Process Worker"
    },
    {
      "code" : "8275.004",
      "display" : "Cannister Viewer",
      "definition" : "Cannister Viewer"
    },
    {
      "code" : "8275.005",
      "display" : "Food Dehydrator",
      "definition" : "Food Dehydrator"
    },
    {
      "code" : "8275.006",
      "display" : "Food Preserver",
      "definition" : "Food Preserver"
    },
    {
      "code" : "8275.007",
      "display" : "Freezer Foodstuffs",
      "definition" : "Freezer Foodstuffs"
    },
    {
      "code" : "8275.008",
      "display" : "Fruit Press Operator",
      "definition" : "Fruit Press Operator"
    },
    {
      "code" : "8275.009",
      "display" : "Fruit Vegetable and Nut Processing Machine Operator",
      "definition" : "Fruit Vegetable and Nut Processing Machine Operator"
    },
    {
      "code" : "8275.010",
      "display" : "Fruit Vegetable and Nut Processing Machine Supervisor",
      "definition" : "Fruit Vegetable and Nut Processing Machine Supervisor"
    },
    {
      "code" : "8275.011",
      "display" : "Jam Maker",
      "definition" : "Jam Maker"
    },
    {
      "code" : "8275.012",
      "display" : "Margarine Worker",
      "definition" : "Margarine Worker"
    },
    {
      "code" : "8275.013",
      "display" : "Overseer Fruit Vegetable Nut Processing",
      "definition" : "Overseer Fruit Vegetable Nut Processing"
    },
    {
      "code" : "8275.014",
      "display" : "Preserving and Canning Worker",
      "definition" : "Preserving and Canning Worker"
    },
    {
      "code" : "8275.015",
      "display" : "Quality Controller of Fruit Nut Vegetable Machine Operators",
      "definition" : "Quality Controller of Fruit Nut Vegetable Machine Operators"
    },
    {
      "code" : "8275.016",
      "display" : "Syrup Maker Cordials",
      "definition" : "Syrup Maker Cordials"
    },
    {
      "code" : "8275.017",
      "display" : "Syrup Maker Foods",
      "definition" : "Syrup Maker Foods"
    },
    {
      "code" : "8275.018",
      "display" : "Vegetable Preparer Canning",
      "definition" : "Vegetable Preparer Canning"
    },
    {
      "code" : "8276.001",
      "display" : "Chocolate Confectionary Maker",
      "definition" : "Chocolate Confectionary Maker"
    },
    {
      "code" : "8276.002",
      "display" : "Confectionery Maker",
      "definition" : "Confectionery Maker"
    },
    {
      "code" : "8276.003",
      "display" : "Confectionery Maker Supervisor",
      "definition" : "Confectionery Maker Supervisor"
    },
    {
      "code" : "8276.004",
      "display" : "Quality Controller of Confectionery Makers",
      "definition" : "Quality Controller of Confectionery Makers"
    },
    {
      "code" : "8276.005",
      "display" : "Sugar Processor and Refiner",
      "definition" : "Sugar Processor and Refiner"
    },
    {
      "code" : "8276.006",
      "display" : "Sugar Processor and Refinery Supervisor",
      "definition" : "Sugar Processor and Refinery Supervisor"
    },
    {
      "code" : "8276.007",
      "display" : "Sugar Refinery Worker",
      "definition" : "Sugar Refinery Worker"
    },
    {
      "code" : "8276.008",
      "display" : "Sugar Refining Crystalliser Operator",
      "definition" : "Sugar Refining Crystalliser Operator"
    },
    {
      "code" : "8277.001",
      "display" : "Chocolate Maker",
      "definition" : "Chocolate Maker"
    },
    {
      "code" : "8277.002",
      "display" : "Chocolate Making Supervisor",
      "definition" : "Chocolate Making Supervisor"
    },
    {
      "code" : "8277.003",
      "display" : "Coffee and Chicory Roaster and Grinder",
      "definition" : "Coffee and Chicory Roaster and Grinder"
    },
    {
      "code" : "8277.004",
      "display" : "Coffee and Tea Blender",
      "definition" : "Coffee and Tea Blender"
    },
    {
      "code" : "8277.005",
      "display" : "Coffee Blender",
      "definition" : "Coffee Blender"
    },
    {
      "code" : "8277.006",
      "display" : "Coffee Taster",
      "definition" : "Coffee Taster"
    },
    {
      "code" : "8277.007",
      "display" : "Malt Worker",
      "definition" : "Malt Worker"
    },
    {
      "code" : "8277.008",
      "display" : "Malt Works Supervisor",
      "definition" : "Malt Works Supervisor"
    },
    {
      "code" : "8277.009",
      "display" : "Maltster",
      "definition" : "Maltster"
    },
    {
      "code" : "8277.010",
      "display" : "Tea Blender",
      "definition" : "Tea Blender"
    },
    {
      "code" : "8277.011",
      "display" : "Tea Coffee Blender Supervisor",
      "definition" : "Tea Coffee Blender Supervisor"
    },
    {
      "code" : "8277.012",
      "display" : "Tea Taster",
      "definition" : "Tea Taster"
    },
    {
      "code" : "8277.013",
      "display" : "Vinegar Worker",
      "definition" : "Vinegar Worker"
    },
    {
      "code" : "8278.001",
      "display" : "Cigarette Maker",
      "definition" : "Cigarette Maker"
    },
    {
      "code" : "8278.002",
      "display" : "Cigarette Making Machine Operator",
      "definition" : "Cigarette Making Machine Operator"
    },
    {
      "code" : "8278.003",
      "display" : "Overseer Tobacco",
      "definition" : "Overseer Tobacco"
    },
    {
      "code" : "8278.004",
      "display" : "Production Chargehand Foreman Supervisor Tobacco",
      "definition" : "Production Chargehand Foreman Supervisor Tobacco"
    },
    {
      "code" : "8278.005",
      "display" : "Tobacco Grader",
      "definition" : "Tobacco Grader"
    },
    {
      "code" : "8278.006",
      "display" : "Tobacco Machine Operator",
      "definition" : "Tobacco Machine Operator"
    },
    {
      "code" : "8278.007",
      "display" : "Tobacco Product Maker Worker",
      "definition" : "Tobacco Product Maker Worker"
    },
    {
      "code" : "8278.008",
      "display" : "Tobacco Product Process Worker",
      "definition" : "Tobacco Product Process Worker"
    },
    {
      "code" : "8279.001",
      "display" : "Alcoholic Beverage Processor",
      "definition" : "Alcoholic Beverage Processor"
    },
    {
      "code" : "8279.002",
      "display" : "Beer Brewer",
      "definition" : "Beer Brewer"
    },
    {
      "code" : "8279.003",
      "display" : "Beer Production Worker",
      "definition" : "Beer Production Worker"
    },
    {
      "code" : "8279.004",
      "display" : "Brewer",
      "definition" : "Brewer"
    },
    {
      "code" : "8279.005",
      "display" : "Brewery Worker",
      "definition" : "Brewery Worker"
    },
    {
      "code" : "8279.006",
      "display" : "Brewery Worker Supervisor",
      "definition" : "Brewery Worker Supervisor"
    },
    {
      "code" : "8279.007",
      "display" : "Brewmaster",
      "definition" : "Brewmaster"
    },
    {
      "code" : "8279.008",
      "display" : "Distiller",
      "definition" : "Distiller"
    },
    {
      "code" : "8279.009",
      "display" : "Distiller Alcoholic Beverages",
      "definition" : "Distiller Alcoholic Beverages"
    },
    {
      "code" : "8279.010",
      "display" : "Distillery Worker",
      "definition" : "Distillery Worker"
    },
    {
      "code" : "8279.011",
      "display" : "Distillery Worker (Alcoholic Beverages)",
      "definition" : "Distillery Worker (Alcoholic Beverages)"
    },
    {
      "code" : "8279.012",
      "display" : "Distillery Worker Alcoholic Beverages Supervisor",
      "definition" : "Distillery Worker Alcoholic Beverages Supervisor"
    },
    {
      "code" : "8279.013",
      "display" : "Liquor Taster",
      "definition" : "Liquor Taster"
    },
    {
      "code" : "8279.014",
      "display" : "Other Brewery Worker",
      "definition" : "Other Brewery Worker"
    },
    {
      "code" : "8279.015",
      "display" : "Quality Controller of Brewery Workers",
      "definition" : "Quality Controller of Brewery Workers"
    },
    {
      "code" : "8279.016",
      "display" : "Quality Controller of Distillery Worker Alcohic Beverages",
      "definition" : "Quality Controller of Distillery Worker Alcohic Beverages"
    },
    {
      "code" : "8279.017",
      "display" : "Wine Making Machine Operator",
      "definition" : "Wine Making Machine Operator"
    },
    {
      "code" : "8279.018",
      "display" : "Wine Making Machine Operator Supervisor",
      "definition" : "Wine Making Machine Operator Supervisor"
    },
    {
      "code" : "8279.019",
      "display" : "Winery Worker",
      "definition" : "Winery Worker"
    },
    {
      "code" : "8281.001",
      "display" : "Fellmonger",
      "definition" : "Fellmonger"
    },
    {
      "code" : "8281.002",
      "display" : "Fellmongery Beaterman",
      "definition" : "Fellmongery Beaterman"
    },
    {
      "code" : "8281.003",
      "display" : "Hide and Pelt Processor",
      "definition" : "Hide and Pelt Processor"
    },
    {
      "code" : "8281.004",
      "display" : "Hide Classer",
      "definition" : "Hide Classer"
    },
    {
      "code" : "8281.005",
      "display" : "Hide Cleaner",
      "definition" : "Hide Cleaner"
    },
    {
      "code" : "8281.006",
      "display" : "Hide Dresser",
      "definition" : "Hide Dresser"
    },
    {
      "code" : "8281.007",
      "display" : "Hide Flesher",
      "definition" : "Hide Flesher"
    },
    {
      "code" : "8281.008",
      "display" : "Hide Grader",
      "definition" : "Hide Grader"
    },
    {
      "code" : "8281.009",
      "display" : "Hide Splitter",
      "definition" : "Hide Splitter"
    },
    {
      "code" : "8281.010",
      "display" : "Hides and Pelts Scudder Tanning",
      "definition" : "Hides and Pelts Scudder Tanning"
    },
    {
      "code" : "8281.011",
      "display" : "Leather Dresser",
      "definition" : "Leather Dresser"
    },
    {
      "code" : "8281.012",
      "display" : "Leather Dyer Stainer",
      "definition" : "Leather Dyer Stainer"
    },
    {
      "code" : "8281.013",
      "display" : "Leather Stretcher Tanner",
      "definition" : "Leather Stretcher Tanner"
    },
    {
      "code" : "8281.014",
      "display" : "Pelt Classer",
      "definition" : "Pelt Classer"
    },
    {
      "code" : "8281.015",
      "display" : "Pelt Cleaner",
      "definition" : "Pelt Cleaner"
    },
    {
      "code" : "8281.016",
      "display" : "Pelt Dresser",
      "definition" : "Pelt Dresser"
    },
    {
      "code" : "8281.017",
      "display" : "Pelt Flesher",
      "definition" : "Pelt Flesher"
    },
    {
      "code" : "8281.018",
      "display" : "Pelt Grader",
      "definition" : "Pelt Grader"
    },
    {
      "code" : "8281.019",
      "display" : "Pelt Plucker",
      "definition" : "Pelt Plucker"
    },
    {
      "code" : "8281.020",
      "display" : "Pelt Sorter",
      "definition" : "Pelt Sorter"
    },
    {
      "code" : "8281.021",
      "display" : "Pelt Stretcher",
      "definition" : "Pelt Stretcher"
    },
    {
      "code" : "8281.022",
      "display" : "Pelt Trimmer",
      "definition" : "Pelt Trimmer"
    },
    {
      "code" : "8281.023",
      "display" : "Quality Controller of Hide Skin And Pelts",
      "definition" : "Quality Controller of Hide Skin And Pelts"
    },
    {
      "code" : "8281.024",
      "display" : "Sheepskin Product Maker",
      "definition" : "Sheepskin Product Maker"
    },
    {
      "code" : "8281.025",
      "display" : "Skin Classer",
      "definition" : "Skin Classer"
    },
    {
      "code" : "8281.026",
      "display" : "Skin Grader",
      "definition" : "Skin Grader"
    },
    {
      "code" : "8281.027",
      "display" : "Tanner Currier",
      "definition" : "Tanner Currier"
    },
    {
      "code" : "8281.028",
      "display" : "Tanner Splitter and Dyer",
      "definition" : "Tanner Splitter and Dyer"
    },
    {
      "code" : "8281.029",
      "display" : "Tannery Hand",
      "definition" : "Tannery Hand"
    },
    {
      "code" : "8281.030",
      "display" : "Tanning Liquor Maker",
      "definition" : "Tanning Liquor Maker"
    },
    {
      "code" : "8281.031",
      "display" : "Wool Puller",
      "definition" : "Wool Puller"
    },
    {
      "code" : "8291.001",
      "display" : "Car Assembler",
      "definition" : "Car Assembler"
    },
    {
      "code" : "8291.002",
      "display" : "Car Assembly Setter",
      "definition" : "Car Assembly Setter"
    },
    {
      "code" : "8291.003",
      "display" : "Car Assembly Supervisor",
      "definition" : "Car Assembly Supervisor"
    },
    {
      "code" : "8291.004",
      "display" : "Car Assembly Worker",
      "definition" : "Car Assembly Worker"
    },
    {
      "code" : "8291.005",
      "display" : "Chassis Assembler",
      "definition" : "Chassis Assembler"
    },
    {
      "code" : "8291.006",
      "display" : "Machinery Assembler",
      "definition" : "Machinery Assembler"
    },
    {
      "code" : "8291.007",
      "display" : "Machinery Fitter Assembler",
      "definition" : "Machinery Fitter Assembler"
    },
    {
      "code" : "8291.008",
      "display" : "Machinery Installer Erector",
      "definition" : "Machinery Installer Erector"
    },
    {
      "code" : "8291.009",
      "display" : "Marine Engine Assembler",
      "definition" : "Marine Engine Assembler"
    },
    {
      "code" : "8291.010",
      "display" : "Mechanical Machinery Assembler",
      "definition" : "Mechanical Machinery Assembler"
    },
    {
      "code" : "8291.011",
      "display" : "Mechanical Machinery Assembly Supervisor",
      "definition" : "Mechanical Machinery Assembly Supervisor"
    },
    {
      "code" : "8291.012",
      "display" : "Meter Maker Repairer",
      "definition" : "Meter Maker Repairer"
    },
    {
      "code" : "8291.013",
      "display" : "Motor Vehicle Assembly Supervisor",
      "definition" : "Motor Vehicle Assembly Supervisor"
    },
    {
      "code" : "8291.014",
      "display" : "Motor Vehicle Assembly Worker",
      "definition" : "Motor Vehicle Assembly Worker"
    },
    {
      "code" : "8291.015",
      "display" : "Motor Vehicle Process Worker",
      "definition" : "Motor Vehicle Process Worker"
    },
    {
      "code" : "8291.016",
      "display" : "Quality Controller of Mechanical Machinery Assemblers",
      "definition" : "Quality Controller of Mechanical Machinery Assemblers"
    },
    {
      "code" : "8291.017",
      "display" : "Vehicle Assembler",
      "definition" : "Vehicle Assembler"
    },
    {
      "code" : "8292.001",
      "display" : "Armature Winder",
      "definition" : "Armature Winder"
    },
    {
      "code" : "8292.002",
      "display" : "Cable Jointer",
      "definition" : "Cable Jointer"
    },
    {
      "code" : "8292.003",
      "display" : "Cable Jointer Supervisor",
      "definition" : "Cable Jointer Supervisor"
    },
    {
      "code" : "8292.004",
      "display" : "Cable Layer",
      "definition" : "Cable Layer"
    },
    {
      "code" : "8292.005",
      "display" : "Circuit Board Assembler",
      "definition" : "Circuit Board Assembler"
    },
    {
      "code" : "8292.006",
      "display" : "Coil Winder",
      "definition" : "Coil Winder"
    },
    {
      "code" : "8292.007",
      "display" : "Communication Equipment Assembler",
      "definition" : "Communication Equipment Assembler"
    },
    {
      "code" : "8292.008",
      "display" : "Electric and Electronic Equipment Assembler",
      "definition" : "Electric and Electronic Equipment Assembler"
    },
    {
      "code" : "8292.009",
      "display" : "Electric Cable Jointer",
      "definition" : "Electric Cable Jointer"
    },
    {
      "code" : "8292.010",
      "display" : "Electric Cable Layer",
      "definition" : "Electric Cable Layer"
    },
    {
      "code" : "8292.011",
      "display" : "Electric Cable Puller",
      "definition" : "Electric Cable Puller"
    },
    {
      "code" : "8292.012",
      "display" : "Electric Equipment Assembler",
      "definition" : "Electric Equipment Assembler"
    },
    {
      "code" : "8292.013",
      "display" : "Electric Equipment Assembly Supervisor",
      "definition" : "Electric Equipment Assembly Supervisor"
    },
    {
      "code" : "8292.014",
      "display" : "Electric Power Line Mechanic",
      "definition" : "Electric Power Line Mechanic"
    },
    {
      "code" : "8292.015",
      "display" : "Electric Power Lines Faultsman",
      "definition" : "Electric Power Lines Faultsman"
    },
    {
      "code" : "8292.016",
      "display" : "Electric Power Lines Serviceman",
      "definition" : "Electric Power Lines Serviceman"
    },
    {
      "code" : "8292.017",
      "display" : "Electric Power Linesman",
      "definition" : "Electric Power Linesman"
    },
    {
      "code" : "8292.018",
      "display" : "Electric Power Linesperson",
      "definition" : "Electric Power Linesperson"
    },
    {
      "code" : "8292.019",
      "display" : "Electric Traction Lineman",
      "definition" : "Electric Traction Lineman"
    },
    {
      "code" : "8292.020",
      "display" : "Electrical Assembler",
      "definition" : "Electrical Assembler"
    },
    {
      "code" : "8292.021",
      "display" : "Electrical Goods Assembler",
      "definition" : "Electrical Goods Assembler"
    },
    {
      "code" : "8292.022",
      "display" : "Electrical Inspector Lines",
      "definition" : "Electrical Inspector Lines"
    },
    {
      "code" : "8292.023",
      "display" : "Electrical Insulator Worker",
      "definition" : "Electrical Insulator Worker"
    },
    {
      "code" : "8292.024",
      "display" : "Electrical Lineman",
      "definition" : "Electrical Lineman"
    },
    {
      "code" : "8292.025",
      "display" : "Electrical Linesman",
      "definition" : "Electrical Linesman"
    },
    {
      "code" : "8292.026",
      "display" : "Electrical Products Process Worker",
      "definition" : "Electrical Products Process Worker"
    },
    {
      "code" : "8292.027",
      "display" : "Electrical Rewinder",
      "definition" : "Electrical Rewinder"
    },
    {
      "code" : "8292.028",
      "display" : "Electronic Assembler",
      "definition" : "Electronic Assembler"
    },
    {
      "code" : "8292.029",
      "display" : "Electronic Equipment Assembler",
      "definition" : "Electronic Equipment Assembler"
    },
    {
      "code" : "8292.030",
      "display" : "Electronic Equipment Assembly Supervisor",
      "definition" : "Electronic Equipment Assembly Supervisor"
    },
    {
      "code" : "8292.031",
      "display" : "Electronic Goods Assembler",
      "definition" : "Electronic Goods Assembler"
    },
    {
      "code" : "8292.032",
      "display" : "Electronics Inspector Tester",
      "definition" : "Electronics Inspector Tester"
    },
    {
      "code" : "8292.033",
      "display" : "Erector Electric Power Lines",
      "definition" : "Erector Electric Power Lines"
    },
    {
      "code" : "8292.034",
      "display" : "Lighting Assembler",
      "definition" : "Lighting Assembler"
    },
    {
      "code" : "8292.035",
      "display" : "Line Mechanic",
      "definition" : "Line Mechanic"
    },
    {
      "code" : "8292.036",
      "display" : "Linesperson",
      "definition" : "Linesperson"
    },
    {
      "code" : "8292.037",
      "display" : "Mains Layer and Jointer",
      "definition" : "Mains Layer and Jointer"
    },
    {
      "code" : "8292.038",
      "display" : "Overseer Cable Laying",
      "definition" : "Overseer Cable Laying"
    },
    {
      "code" : "8292.039",
      "display" : "Overseer Electrical Electronic Equipment Manufacture",
      "definition" : "Overseer Electrical Electronic Equipment Manufacture"
    },
    {
      "code" : "8292.040",
      "display" : "Production Chargehand Foreman Supervisor Electric",
      "definition" : "Production Chargehand Foreman Supervisor Electric"
    },
    {
      "code" : "8292.041",
      "display" : "Production Chargehand Foreman Supervisor Electronic",
      "definition" : "Production Chargehand Foreman Supervisor Electronic"
    },
    {
      "code" : "8292.042",
      "display" : "Quality Controller of Electric Electronic Equipment Assemblers",
      "definition" : "Quality Controller of Electric Electronic Equipment Assemblers"
    },
    {
      "code" : "8292.043",
      "display" : "Radio Assembler",
      "definition" : "Radio Assembler"
    },
    {
      "code" : "8292.044",
      "display" : "Range Fitter Assembler",
      "definition" : "Range Fitter Assembler"
    },
    {
      "code" : "8292.045",
      "display" : "Registered Electric Power Linesperson",
      "definition" : "Registered Electric Power Linesperson"
    },
    {
      "code" : "8292.046",
      "display" : "Registered Telephone Linesperson",
      "definition" : "Registered Telephone Linesperson"
    },
    {
      "code" : "8292.047",
      "display" : "Rotoarmature Winder",
      "definition" : "Rotoarmature Winder"
    },
    {
      "code" : "8292.048",
      "display" : "Signals and Electric Line Inspector",
      "definition" : "Signals and Electric Line Inspector"
    },
    {
      "code" : "8292.049",
      "display" : "Stove Fitter Maker Assembler",
      "definition" : "Stove Fitter Maker Assembler"
    },
    {
      "code" : "8292.050",
      "display" : "Supervisor Linesman",
      "definition" : "Supervisor Linesman"
    },
    {
      "code" : "8292.051",
      "display" : "Telecom Lineman",
      "definition" : "Telecom Lineman"
    },
    {
      "code" : "8292.052",
      "display" : "Telecom Transmission Serviceman",
      "definition" : "Telecom Transmission Serviceman"
    },
    {
      "code" : "8292.053",
      "display" : "Telephone Linesperson and Installer",
      "definition" : "Telephone Linesperson and Installer"
    },
    {
      "code" : "8292.054",
      "display" : "Telephone Serviceman Repairer",
      "definition" : "Telephone Serviceman Repairer"
    },
    {
      "code" : "8292.055",
      "display" : "Television Assembler",
      "definition" : "Television Assembler"
    },
    {
      "code" : "8292.056",
      "display" : "Transformer Assembler",
      "definition" : "Transformer Assembler"
    },
    {
      "code" : "8292.057",
      "display" : "Transformer Serviceman Winder",
      "definition" : "Transformer Serviceman Winder"
    },
    {
      "code" : "8293.001",
      "display" : "Brush and Broom Maker",
      "definition" : "Brush and Broom Maker"
    },
    {
      "code" : "8293.002",
      "display" : "Button Maker",
      "definition" : "Button Maker"
    },
    {
      "code" : "8293.003",
      "display" : "Cassette Assembler",
      "definition" : "Cassette Assembler"
    },
    {
      "code" : "8293.004",
      "display" : "Cutter Plastics and Rubber",
      "definition" : "Cutter Plastics and Rubber"
    },
    {
      "code" : "8293.005",
      "display" : "Factory Hand Vinyl Coated Fabrics",
      "definition" : "Factory Hand Vinyl Coated Fabrics"
    },
    {
      "code" : "8293.006",
      "display" : "Finisher Plastics",
      "definition" : "Finisher Plastics"
    },
    {
      "code" : "8293.007",
      "display" : "Golf Club Maker",
      "definition" : "Golf Club Maker"
    },
    {
      "code" : "8293.008",
      "display" : "Installer Plastic Awning",
      "definition" : "Installer Plastic Awning"
    },
    {
      "code" : "8293.009",
      "display" : "Linoleum Maker",
      "definition" : "Linoleum Maker"
    },
    {
      "code" : "8293.010",
      "display" : "Metal Goods Assembler",
      "definition" : "Metal Goods Assembler"
    },
    {
      "code" : "8293.011",
      "display" : "Metal Goods Assembly Supervisor",
      "definition" : "Metal Goods Assembly Supervisor"
    },
    {
      "code" : "8293.012",
      "display" : "Metal Products Fitter Assembler",
      "definition" : "Metal Products Fitter Assembler"
    },
    {
      "code" : "8293.013",
      "display" : "Mop Maker",
      "definition" : "Mop Maker"
    },
    {
      "code" : "8293.014",
      "display" : "Outworker Plastic Rubber Toys",
      "definition" : "Outworker Plastic Rubber Toys"
    },
    {
      "code" : "8293.015",
      "display" : "Placemat Maker",
      "definition" : "Placemat Maker"
    },
    {
      "code" : "8293.016",
      "display" : "Plastic Boat Builder",
      "definition" : "Plastic Boat Builder"
    },
    {
      "code" : "8293.017",
      "display" : "Plastic Rubber Clothing Maker",
      "definition" : "Plastic Rubber Clothing Maker"
    },
    {
      "code" : "8293.018",
      "display" : "Plastics and Rubber Goods Assembler",
      "definition" : "Plastics and Rubber Goods Assembler"
    },
    {
      "code" : "8293.019",
      "display" : "Plastics and Rubber Goods Assembler Supervisor",
      "definition" : "Plastics and Rubber Goods Assembler Supervisor"
    },
    {
      "code" : "8293.020",
      "display" : "Plastics Assembler",
      "definition" : "Plastics Assembler"
    },
    {
      "code" : "8293.021",
      "display" : "Plastics Fabricator",
      "definition" : "Plastics Fabricator"
    },
    {
      "code" : "8293.022",
      "display" : "Plastics Process Worker",
      "definition" : "Plastics Process Worker"
    },
    {
      "code" : "8293.023",
      "display" : "Plastics Welder",
      "definition" : "Plastics Welder"
    },
    {
      "code" : "8293.024",
      "display" : "Process Worker Plastic Rubber Toys",
      "definition" : "Process Worker Plastic Rubber Toys"
    },
    {
      "code" : "8293.025",
      "display" : "Projection Screen Maker",
      "definition" : "Projection Screen Maker"
    },
    {
      "code" : "8293.026",
      "display" : "Quality Controller of Metal Goods Assemblers",
      "definition" : "Quality Controller of Metal Goods Assemblers"
    },
    {
      "code" : "8293.027",
      "display" : "Quality Controller of Plastics and Rubber Goods Assemblers",
      "definition" : "Quality Controller of Plastics and Rubber Goods Assemblers"
    },
    {
      "code" : "8293.028",
      "display" : "Racing Sulky Maker",
      "definition" : "Racing Sulky Maker"
    },
    {
      "code" : "8293.029",
      "display" : "Rubber Goods Assembler",
      "definition" : "Rubber Goods Assembler"
    },
    {
      "code" : "8293.030",
      "display" : "Rubber Stamp Maker",
      "definition" : "Rubber Stamp Maker"
    },
    {
      "code" : "8293.031",
      "display" : "Rubber Worker",
      "definition" : "Rubber Worker"
    },
    {
      "code" : "8293.032",
      "display" : "Sealing Fitter Rubber",
      "definition" : "Sealing Fitter Rubber"
    },
    {
      "code" : "8293.033",
      "display" : "Toy Maker Plastic",
      "definition" : "Toy Maker Plastic"
    },
    {
      "code" : "8293.034",
      "display" : "Vinyl Colour Matcher",
      "definition" : "Vinyl Colour Matcher"
    },
    {
      "code" : "8293.035",
      "display" : "Vinyl Worker",
      "definition" : "Vinyl Worker"
    },
    {
      "code" : "8293.036",
      "display" : "Waterproof Garment Maker",
      "definition" : "Waterproof Garment Maker"
    },
    {
      "code" : "8294.001",
      "display" : "Basket and Wicker Worker",
      "definition" : "Basket and Wicker Worker"
    },
    {
      "code" : "8294.002",
      "display" : "Basket and Wicker Worker Supervisor",
      "definition" : "Basket and Wicker Worker Supervisor"
    },
    {
      "code" : "8294.003",
      "display" : "Cane and Wicker Furniture Maker",
      "definition" : "Cane and Wicker Furniture Maker"
    },
    {
      "code" : "8294.004",
      "display" : "Farm Fencer",
      "definition" : "Farm Fencer"
    },
    {
      "code" : "8294.005",
      "display" : "Fencer",
      "definition" : "Fencer"
    },
    {
      "code" : "8294.006",
      "display" : "Fencing Contractor",
      "definition" : "Fencing Contractor"
    },
    {
      "code" : "8294.007",
      "display" : "Gang Nail Process Worker",
      "definition" : "Gang Nail Process Worker"
    },
    {
      "code" : "8294.008",
      "display" : "Match Making Machine Operator",
      "definition" : "Match Making Machine Operator"
    },
    {
      "code" : "8294.009",
      "display" : "Process Worker Furniture",
      "definition" : "Process Worker Furniture"
    },
    {
      "code" : "8294.010",
      "display" : "Process Worker Wooden Toys",
      "definition" : "Process Worker Wooden Toys"
    },
    {
      "code" : "8294.011",
      "display" : "Quality Controller Of Basket And Wicker Workers",
      "definition" : "Quality Controller Of Basket And Wicker Workers"
    },
    {
      "code" : "8294.012",
      "display" : "Quality Controller of Wood and Related Materials Assemblers",
      "definition" : "Quality Controller of Wood and Related Materials Assemblers"
    },
    {
      "code" : "8294.013",
      "display" : "Sanding Machine Operator Woodworking",
      "definition" : "Sanding Machine Operator Woodworking"
    },
    {
      "code" : "8294.014",
      "display" : "Ski Maker Wood",
      "definition" : "Ski Maker Wood"
    },
    {
      "code" : "8294.015",
      "display" : "Wire Fence Erector",
      "definition" : "Wire Fence Erector"
    },
    {
      "code" : "8294.016",
      "display" : "Wood and Related Materials Products Assembler",
      "definition" : "Wood and Related Materials Products Assembler"
    },
    {
      "code" : "8294.017",
      "display" : "Wood and Related Materials Products Assembly Supervisor",
      "definition" : "Wood and Related Materials Products Assembly Supervisor"
    },
    {
      "code" : "8294.018",
      "display" : "Wood and Related Materials Products Assembly Worker",
      "definition" : "Wood and Related Materials Products Assembly Worker"
    },
    {
      "code" : "8294.019",
      "display" : "Woodworker Games and Sports Equipment",
      "definition" : "Woodworker Games and Sports Equipment"
    },
    {
      "code" : "8295.001",
      "display" : "Bespoke Shoemaker",
      "definition" : "Bespoke Shoemaker"
    },
    {
      "code" : "8295.002",
      "display" : "Footwear Bench Worker",
      "definition" : "Footwear Bench Worker"
    },
    {
      "code" : "8295.003",
      "display" : "Footwear Examiner",
      "definition" : "Footwear Examiner"
    },
    {
      "code" : "8295.004",
      "display" : "Footwear Factory Journeyman",
      "definition" : "Footwear Factory Journeyman"
    },
    {
      "code" : "8295.005",
      "display" : "Footwear Factory Sewing Machinist",
      "definition" : "Footwear Factory Sewing Machinist"
    },
    {
      "code" : "8295.006",
      "display" : "Footwear Factory Worker",
      "definition" : "Footwear Factory Worker"
    },
    {
      "code" : "8295.007",
      "display" : "Footwear Laster",
      "definition" : "Footwear Laster"
    },
    {
      "code" : "8295.008",
      "display" : "Footwear Maker",
      "definition" : "Footwear Maker"
    },
    {
      "code" : "8295.009",
      "display" : "Footwear Production Machine Operator",
      "definition" : "Footwear Production Machine Operator"
    },
    {
      "code" : "8295.010",
      "display" : "Footwear Shanker",
      "definition" : "Footwear Shanker"
    },
    {
      "code" : "8295.011",
      "display" : "Footwear Sole Fitter",
      "definition" : "Footwear Sole Fitter"
    },
    {
      "code" : "8295.012",
      "display" : "Footwear Sole Presser",
      "definition" : "Footwear Sole Presser"
    },
    {
      "code" : "8295.013",
      "display" : "Hand Sewer Leather Goods",
      "definition" : "Hand Sewer Leather Goods"
    },
    {
      "code" : "8295.014",
      "display" : "Leather Facotry Worker",
      "definition" : "Leather Facotry Worker"
    },
    {
      "code" : "8295.015",
      "display" : "Leather Goods Assembler",
      "definition" : "Leather Goods Assembler"
    },
    {
      "code" : "8295.016",
      "display" : "Leather Goods Cutter",
      "definition" : "Leather Goods Cutter"
    },
    {
      "code" : "8295.017",
      "display" : "Leather Goods Machine Operator",
      "definition" : "Leather Goods Machine Operator"
    },
    {
      "code" : "8295.018",
      "display" : "Leather Goods Machine Operator Supervisor",
      "definition" : "Leather Goods Machine Operator Supervisor"
    },
    {
      "code" : "8295.019",
      "display" : "Leather Goods Maker",
      "definition" : "Leather Goods Maker"
    },
    {
      "code" : "8295.020",
      "display" : "Leather Product Maker",
      "definition" : "Leather Product Maker"
    },
    {
      "code" : "8295.021",
      "display" : "Leather Safety Belt Assembler",
      "definition" : "Leather Safety Belt Assembler"
    },
    {
      "code" : "8295.022",
      "display" : "Leather Sewing Machine Operator",
      "definition" : "Leather Sewing Machine Operator"
    },
    {
      "code" : "8295.023",
      "display" : "Leather Worker",
      "definition" : "Leather Worker"
    },
    {
      "code" : "8295.024",
      "display" : "Outworker Shoe Finishing",
      "definition" : "Outworker Shoe Finishing"
    },
    {
      "code" : "8295.025",
      "display" : "Production Chargehand Overseer Footwear Manuf",
      "definition" : "Production Chargehand Overseer Footwear Manuf"
    },
    {
      "code" : "8295.026",
      "display" : "Production Supervisor Footwear Assembly",
      "definition" : "Production Supervisor Footwear Assembly"
    },
    {
      "code" : "8295.027",
      "display" : "Quality Controller of Leather Goods Assemblers",
      "definition" : "Quality Controller of Leather Goods Assemblers"
    },
    {
      "code" : "8295.028",
      "display" : "Quality Controller Of Shoe Assemblers",
      "definition" : "Quality Controller Of Shoe Assemblers"
    },
    {
      "code" : "8295.029",
      "display" : "Shoe Assembler",
      "definition" : "Shoe Assembler"
    },
    {
      "code" : "8295.030",
      "display" : "Shoe Assembly Supervisor",
      "definition" : "Shoe Assembly Supervisor"
    },
    {
      "code" : "8295.031",
      "display" : "Shoe Clicker",
      "definition" : "Shoe Clicker"
    },
    {
      "code" : "8295.032",
      "display" : "Shoe Cutter",
      "definition" : "Shoe Cutter"
    },
    {
      "code" : "8295.033",
      "display" : "Shoe Maker",
      "definition" : "Shoe Maker"
    },
    {
      "code" : "8295.034",
      "display" : "Shoe Pattern Cutter",
      "definition" : "Shoe Pattern Cutter"
    },
    {
      "code" : "8295.035",
      "display" : "Shoe Sewing Machine Supervisor",
      "definition" : "Shoe Sewing Machine Supervisor"
    },
    {
      "code" : "8295.036",
      "display" : "Shoe Sewing Machinist",
      "definition" : "Shoe Sewing Machinist"
    },
    {
      "code" : "8295.037",
      "display" : "Wooden Shoe Maker",
      "definition" : "Wooden Shoe Maker"
    },
    {
      "code" : "8311.001",
      "display" : "Cable Car Operator",
      "definition" : "Cable Car Operator"
    },
    {
      "code" : "8311.002",
      "display" : "Chair Lift Operator",
      "definition" : "Chair Lift Operator"
    },
    {
      "code" : "8311.003",
      "display" : "Diesel Locomotive and Railcar Engine Driver",
      "definition" : "Diesel Locomotive and Railcar Engine Driver"
    },
    {
      "code" : "8311.004",
      "display" : "Locomotive Engine Driver",
      "definition" : "Locomotive Engine Driver"
    },
    {
      "code" : "8311.005",
      "display" : "Locomotive Engineer",
      "definition" : "Locomotive Engineer"
    },
    {
      "code" : "8311.006",
      "display" : "Locomotive Foreman",
      "definition" : "Locomotive Foreman"
    },
    {
      "code" : "8311.007",
      "display" : "Mine and Quarry Engine Driver",
      "definition" : "Mine and Quarry Engine Driver"
    },
    {
      "code" : "8311.008",
      "display" : "Railway Engine Driver",
      "definition" : "Railway Engine Driver"
    },
    {
      "code" : "8311.009",
      "display" : "Railway Engine Drivers Assistant",
      "definition" : "Railway Engine Drivers Assistant"
    },
    {
      "code" : "8311.010",
      "display" : "Railway Locomotive Driver",
      "definition" : "Railway Locomotive Driver"
    },
    {
      "code" : "8311.011",
      "display" : "Railway Locomotive Fireman",
      "definition" : "Railway Locomotive Fireman"
    },
    {
      "code" : "8311.012",
      "display" : "Train Driver",
      "definition" : "Train Driver"
    },
    {
      "code" : "8311.013",
      "display" : "Train Operator",
      "definition" : "Train Operator"
    },
    {
      "code" : "8311.014",
      "display" : "Underground or Elevator Train Driver",
      "definition" : "Underground or Elevator Train Driver"
    },
    {
      "code" : "8321.001",
      "display" : "Cab Driver",
      "definition" : "Cab Driver"
    },
    {
      "code" : "8321.002",
      "display" : "Chauffeur",
      "definition" : "Chauffeur"
    },
    {
      "code" : "8321.003",
      "display" : "Contract Car Driver",
      "definition" : "Contract Car Driver"
    },
    {
      "code" : "8321.004",
      "display" : "Driver Education Teacher",
      "definition" : "Driver Education Teacher"
    },
    {
      "code" : "8321.005",
      "display" : "Driver Trainer",
      "definition" : "Driver Trainer"
    },
    {
      "code" : "8321.006",
      "display" : "Driving Instructor",
      "definition" : "Driving Instructor"
    },
    {
      "code" : "8321.007",
      "display" : "Driving Tutor",
      "definition" : "Driving Tutor"
    },
    {
      "code" : "8321.008",
      "display" : "Kaitaraiwa Takihi",
      "definition" : "Kaitaraiwa Takihi"
    },
    {
      "code" : "8321.009",
      "display" : "Kaitaraiwa Takihii",
      "definition" : "Kaitaraiwa Takihii"
    },
    {
      "code" : "8321.010",
      "display" : "Light Lorry Driver",
      "definition" : "Light Lorry Driver"
    },
    {
      "code" : "8321.011",
      "display" : "Light Truck Driver",
      "definition" : "Light Truck Driver"
    },
    {
      "code" : "8321.012",
      "display" : "Light Van Driver",
      "definition" : "Light Van Driver"
    },
    {
      "code" : "8321.013",
      "display" : "Limousine Driver",
      "definition" : "Limousine Driver"
    },
    {
      "code" : "8321.014",
      "display" : "Motor Car Driver",
      "definition" : "Motor Car Driver"
    },
    {
      "code" : "8321.015",
      "display" : "Service Car Driver",
      "definition" : "Service Car Driver"
    },
    {
      "code" : "8321.016",
      "display" : "Shuttle Driver",
      "definition" : "Shuttle Driver"
    },
    {
      "code" : "8321.017",
      "display" : "Storeman Driver",
      "definition" : "Storeman Driver"
    },
    {
      "code" : "8321.018",
      "display" : "Storeperson Driver General",
      "definition" : "Storeperson Driver General"
    },
    {
      "code" : "8321.019",
      "display" : "Taxi Driver",
      "definition" : "Taxi Driver"
    },
    {
      "code" : "8321.020",
      "display" : "Taxi Operator",
      "definition" : "Taxi Operator"
    },
    {
      "code" : "8321.021",
      "display" : "Taxi Owner",
      "definition" : "Taxi Owner"
    },
    {
      "code" : "8321.022",
      "display" : "Taxi Proprietor",
      "definition" : "Taxi Proprietor"
    },
    {
      "code" : "8321.023",
      "display" : "Tourist Car Operator",
      "definition" : "Tourist Car Operator"
    },
    {
      "code" : "8321.024",
      "display" : "Van Driver",
      "definition" : "Van Driver"
    },
    {
      "code" : "8322.001",
      "display" : "Bus Driver",
      "definition" : "Bus Driver"
    },
    {
      "code" : "8322.002",
      "display" : "Bus Operator",
      "definition" : "Bus Operator"
    },
    {
      "code" : "8322.003",
      "display" : "Coach Captain (Bus)",
      "definition" : "Coach Captain (Bus)"
    },
    {
      "code" : "8322.004",
      "display" : "Coach Driver",
      "definition" : "Coach Driver"
    },
    {
      "code" : "8322.005",
      "display" : "Coach Tour Driver",
      "definition" : "Coach Tour Driver"
    },
    {
      "code" : "8322.006",
      "display" : "Kaitaraiwa Pahi",
      "definition" : "Kaitaraiwa Pahi"
    },
    {
      "code" : "8322.007",
      "display" : "Motor or Trolley Bus Driver",
      "definition" : "Motor or Trolley Bus Driver"
    },
    {
      "code" : "8322.008",
      "display" : "Passenger Coach Driver",
      "definition" : "Passenger Coach Driver"
    },
    {
      "code" : "8322.009",
      "display" : "School Bus Driver",
      "definition" : "School Bus Driver"
    },
    {
      "code" : "8322.010",
      "display" : "Tour Bus Driver",
      "definition" : "Tour Bus Driver"
    },
    {
      "code" : "8322.011",
      "display" : "Tour Bus Operator",
      "definition" : "Tour Bus Operator"
    },
    {
      "code" : "8322.012",
      "display" : "Tourist Bus Operator",
      "definition" : "Tourist Bus Operator"
    },
    {
      "code" : "8322.013",
      "display" : "Tram Driver",
      "definition" : "Tram Driver"
    },
    {
      "code" : "8322.014",
      "display" : "Tram Motorman",
      "definition" : "Tram Motorman"
    },
    {
      "code" : "8322.015",
      "display" : "Trolley Bus Driver",
      "definition" : "Trolley Bus Driver"
    },
    {
      "code" : "8323.001",
      "display" : "Articulated Truck Drvier",
      "definition" : "Articulated Truck Drvier"
    },
    {
      "code" : "8323.002",
      "display" : "Articulator Driver",
      "definition" : "Articulator Driver"
    },
    {
      "code" : "8323.003",
      "display" : "Car Freighter Driver",
      "definition" : "Car Freighter Driver"
    },
    {
      "code" : "8323.004",
      "display" : "Cartage Contractor",
      "definition" : "Cartage Contractor"
    },
    {
      "code" : "8323.005",
      "display" : "Concrete Delivery Driver",
      "definition" : "Concrete Delivery Driver"
    },
    {
      "code" : "8323.006",
      "display" : "Driver Car Delivery",
      "definition" : "Driver Car Delivery"
    },
    {
      "code" : "8323.007",
      "display" : "Freight Operator",
      "definition" : "Freight Operator"
    },
    {
      "code" : "8323.008",
      "display" : "Heavy Lorry Driver",
      "definition" : "Heavy Lorry Driver"
    },
    {
      "code" : "8323.009",
      "display" : "Heavy Tanker Driver",
      "definition" : "Heavy Tanker Driver"
    },
    {
      "code" : "8323.010",
      "display" : "Heavy Truck Driver",
      "definition" : "Heavy Truck Driver"
    },
    {
      "code" : "8323.011",
      "display" : "Kaitairaiwa Waka Taumaha",
      "definition" : "Kaitairaiwa Waka Taumaha"
    },
    {
      "code" : "8323.012",
      "display" : "Kaitaraiwa Taraka",
      "definition" : "Kaitaraiwa Taraka"
    },
    {
      "code" : "8323.013",
      "display" : "Kaitaraiwa Waka",
      "definition" : "Kaitaraiwa Waka"
    },
    {
      "code" : "8323.014",
      "display" : "Lorry Driver",
      "definition" : "Lorry Driver"
    },
    {
      "code" : "8323.015",
      "display" : "Milk Tanker Driver",
      "definition" : "Milk Tanker Driver"
    },
    {
      "code" : "8323.016",
      "display" : "Removal Van Driver",
      "definition" : "Removal Van Driver"
    },
    {
      "code" : "8323.017",
      "display" : "Stock Transporter Driver",
      "definition" : "Stock Transporter Driver"
    },
    {
      "code" : "8323.018",
      "display" : "Tanker Driver",
      "definition" : "Tanker Driver"
    },
    {
      "code" : "8323.019",
      "display" : "Truck Driver",
      "definition" : "Truck Driver"
    },
    {
      "code" : "8323.020",
      "display" : "Trucker",
      "definition" : "Trucker"
    },
    {
      "code" : "8323.021",
      "display" : "Vehicle Transporter Carrier Driver",
      "definition" : "Vehicle Transporter Carrier Driver"
    },
    {
      "code" : "8331.001",
      "display" : "Agricultural Contractor",
      "definition" : "Agricultural Contractor"
    },
    {
      "code" : "8331.002",
      "display" : "Agricultural Machine and Equipment Operator",
      "definition" : "Agricultural Machine and Equipment Operator"
    },
    {
      "code" : "8331.003",
      "display" : "Agricultural Sprayer",
      "definition" : "Agricultural Sprayer"
    },
    {
      "code" : "8331.004",
      "display" : "Bulk Lime Spreader",
      "definition" : "Bulk Lime Spreader"
    },
    {
      "code" : "8331.005",
      "display" : "Chemical Applicator",
      "definition" : "Chemical Applicator"
    },
    {
      "code" : "8331.006",
      "display" : "Combine Operator",
      "definition" : "Combine Operator"
    },
    {
      "code" : "8331.007",
      "display" : "Contractor Topdressing on Land",
      "definition" : "Contractor Topdressing on Land"
    },
    {
      "code" : "8331.008",
      "display" : "Farm Contractor",
      "definition" : "Farm Contractor"
    },
    {
      "code" : "8331.009",
      "display" : "Farm Equipment Operator",
      "definition" : "Farm Equipment Operator"
    },
    {
      "code" : "8331.010",
      "display" : "Farm Machinery Contractor",
      "definition" : "Farm Machinery Contractor"
    },
    {
      "code" : "8331.011",
      "display" : "Farm Machinery Operator",
      "definition" : "Farm Machinery Operator"
    },
    {
      "code" : "8331.012",
      "display" : "Fertilizer Spreader",
      "definition" : "Fertilizer Spreader"
    },
    {
      "code" : "8331.013",
      "display" : "Ground Chemical Applicator",
      "definition" : "Ground Chemical Applicator"
    },
    {
      "code" : "8331.014",
      "display" : "Ground Spraying or Dusting Contractor",
      "definition" : "Ground Spraying or Dusting Contractor"
    },
    {
      "code" : "8331.015",
      "display" : "Ploughing Contractor",
      "definition" : "Ploughing Contractor"
    },
    {
      "code" : "8331.016",
      "display" : "Potato Digging Contractor",
      "definition" : "Potato Digging Contractor"
    },
    {
      "code" : "8331.017",
      "display" : "Seed Cleaning Contractor",
      "definition" : "Seed Cleaning Contractor"
    },
    {
      "code" : "8331.018",
      "display" : "Seed Machine Operator Farm",
      "definition" : "Seed Machine Operator Farm"
    },
    {
      "code" : "8331.019",
      "display" : "Soil Fumigator",
      "definition" : "Soil Fumigator"
    },
    {
      "code" : "8331.020",
      "display" : "Spraying Contractor on Land",
      "definition" : "Spraying Contractor on Land"
    },
    {
      "code" : "8331.021",
      "display" : "Threshing Mill Operator Worker",
      "definition" : "Threshing Mill Operator Worker"
    },
    {
      "code" : "8331.022",
      "display" : "Tractor Driver",
      "definition" : "Tractor Driver"
    },
    {
      "code" : "8331.023",
      "display" : "Tractor Driver Farm",
      "definition" : "Tractor Driver Farm"
    },
    {
      "code" : "8331.024",
      "display" : "Weed Sprayer Contractor Worker",
      "definition" : "Weed Sprayer Contractor Worker"
    },
    {
      "code" : "8332.001",
      "display" : "Asphalt Spreader Machine Operator",
      "definition" : "Asphalt Spreader Machine Operator"
    },
    {
      "code" : "8332.002",
      "display" : "Bitumen Sprayer Operator",
      "definition" : "Bitumen Sprayer Operator"
    },
    {
      "code" : "8332.003",
      "display" : "Bobcat Operator",
      "definition" : "Bobcat Operator"
    },
    {
      "code" : "8332.004",
      "display" : "Bulldozer Driver",
      "definition" : "Bulldozer Driver"
    },
    {
      "code" : "8332.005",
      "display" : "Bulldozer Operator",
      "definition" : "Bulldozer Operator"
    },
    {
      "code" : "8332.006",
      "display" : "Bulldozing Contractor Driver Operator Farm",
      "definition" : "Bulldozing Contractor Driver Operator Farm"
    },
    {
      "code" : "8332.007",
      "display" : "Digger Driver",
      "definition" : "Digger Driver"
    },
    {
      "code" : "8332.008",
      "display" : "Digging Machine Operator",
      "definition" : "Digging Machine Operator"
    },
    {
      "code" : "8332.009",
      "display" : "Dragline Operator Driver",
      "definition" : "Dragline Operator Driver"
    },
    {
      "code" : "8332.010",
      "display" : "Dredge Operator",
      "definition" : "Dredge Operator"
    },
    {
      "code" : "8332.011",
      "display" : "Dredger",
      "definition" : "Dredger"
    },
    {
      "code" : "8332.012",
      "display" : "Driller Operator",
      "definition" : "Driller Operator"
    },
    {
      "code" : "8332.013",
      "display" : "Driver Dumper",
      "definition" : "Driver Dumper"
    },
    {
      "code" : "8332.014",
      "display" : "Driver Front End Loader",
      "definition" : "Driver Front End Loader"
    },
    {
      "code" : "8332.015",
      "display" : "Earthmoving and Construction Machinery Operator",
      "definition" : "Earthmoving and Construction Machinery Operator"
    },
    {
      "code" : "8332.016",
      "display" : "Earthmoving Contractor",
      "definition" : "Earthmoving Contractor"
    },
    {
      "code" : "8332.017",
      "display" : "Earthmoving Machine Operator",
      "definition" : "Earthmoving Machine Operator"
    },
    {
      "code" : "8332.018",
      "display" : "Earthwork Contractor",
      "definition" : "Earthwork Contractor"
    },
    {
      "code" : "8332.019",
      "display" : "Excavating Machine Operator",
      "definition" : "Excavating Machine Operator"
    },
    {
      "code" : "8332.020",
      "display" : "Grab Bucket Operator Driver",
      "definition" : "Grab Bucket Operator Driver"
    },
    {
      "code" : "8332.021",
      "display" : "Grader Driver",
      "definition" : "Grader Driver"
    },
    {
      "code" : "8332.022",
      "display" : "Hot Mix Sprayer",
      "definition" : "Hot Mix Sprayer"
    },
    {
      "code" : "8332.023",
      "display" : "Paving Contractor",
      "definition" : "Paving Contractor"
    },
    {
      "code" : "8332.024",
      "display" : "Paving Machine Operator Concrete Bitumen",
      "definition" : "Paving Machine Operator Concrete Bitumen"
    },
    {
      "code" : "8332.025",
      "display" : "Pile Driver Operator",
      "definition" : "Pile Driver Operator"
    },
    {
      "code" : "8332.026",
      "display" : "Road Grader Driver",
      "definition" : "Road Grader Driver"
    },
    {
      "code" : "8332.027",
      "display" : "Road Making Machine Operator",
      "definition" : "Road Making Machine Operator"
    },
    {
      "code" : "8332.028",
      "display" : "Road Making Machine Operator Supervisor",
      "definition" : "Road Making Machine Operator Supervisor"
    },
    {
      "code" : "8332.029",
      "display" : "Road Repairer",
      "definition" : "Road Repairer"
    },
    {
      "code" : "8332.030",
      "display" : "Road Roller Driver",
      "definition" : "Road Roller Driver"
    },
    {
      "code" : "8332.031",
      "display" : "Road Scraper Driver Operator",
      "definition" : "Road Scraper Driver Operator"
    },
    {
      "code" : "8332.032",
      "display" : "Roading Construction Worker",
      "definition" : "Roading Construction Worker"
    },
    {
      "code" : "8332.033",
      "display" : "Roading or Paving Machine Operator",
      "definition" : "Roading or Paving Machine Operator"
    },
    {
      "code" : "8332.034",
      "display" : "Roading Supervisor",
      "definition" : "Roading Supervisor"
    },
    {
      "code" : "8332.035",
      "display" : "Scoop Truck Operator Driver",
      "definition" : "Scoop Truck Operator Driver"
    },
    {
      "code" : "8332.036",
      "display" : "Special Operator Roading",
      "definition" : "Special Operator Roading"
    },
    {
      "code" : "8332.037",
      "display" : "Sprayer Tar or Bitumen",
      "definition" : "Sprayer Tar or Bitumen"
    },
    {
      "code" : "8332.038",
      "display" : "Steam Shovel Driver",
      "definition" : "Steam Shovel Driver"
    },
    {
      "code" : "8332.039",
      "display" : "Tar Sealing Machine Operator",
      "definition" : "Tar Sealing Machine Operator"
    },
    {
      "code" : "8332.040",
      "display" : "Traffic Counter Layer",
      "definition" : "Traffic Counter Layer"
    },
    {
      "code" : "8332.041",
      "display" : "Trench Digging Machine Operator",
      "definition" : "Trench Digging Machine Operator"
    },
    {
      "code" : "8332.042",
      "display" : "Trench Ditch Digger",
      "definition" : "Trench Ditch Digger"
    },
    {
      "code" : "8333.001",
      "display" : "Bridge or Gantry Crane Operator",
      "definition" : "Bridge or Gantry Crane Operator"
    },
    {
      "code" : "8333.002",
      "display" : "Crane Driver",
      "definition" : "Crane Driver"
    },
    {
      "code" : "8333.003",
      "display" : "Crane Operator",
      "definition" : "Crane Operator"
    },
    {
      "code" : "8333.004",
      "display" : "Derrick Operator",
      "definition" : "Derrick Operator"
    },
    {
      "code" : "8333.005",
      "display" : "Elevator Operator Material Handling",
      "definition" : "Elevator Operator Material Handling"
    },
    {
      "code" : "8333.006",
      "display" : "Foundry Lifter",
      "definition" : "Foundry Lifter"
    },
    {
      "code" : "8333.007",
      "display" : "Hoist Driver Operator Construction",
      "definition" : "Hoist Driver Operator Construction"
    },
    {
      "code" : "8333.008",
      "display" : "Hoist Operator Mine",
      "definition" : "Hoist Operator Mine"
    },
    {
      "code" : "8333.009",
      "display" : "Jib Operator",
      "definition" : "Jib Operator"
    },
    {
      "code" : "8333.010",
      "display" : "Lift Attendant Goods",
      "definition" : "Lift Attendant Goods"
    },
    {
      "code" : "8333.011",
      "display" : "Lifter Railway Workshops",
      "definition" : "Lifter Railway Workshops"
    },
    {
      "code" : "8333.012",
      "display" : "Mobile Crane Driver",
      "definition" : "Mobile Crane Driver"
    },
    {
      "code" : "8333.013",
      "display" : "Mobile Crane Operator",
      "definition" : "Mobile Crane Operator"
    },
    {
      "code" : "8333.014",
      "display" : "Stationary Crane Driver",
      "definition" : "Stationary Crane Driver"
    },
    {
      "code" : "8333.015",
      "display" : "Stationary Crane Operator",
      "definition" : "Stationary Crane Operator"
    },
    {
      "code" : "8333.016",
      "display" : "Tower Crane Operator",
      "definition" : "Tower Crane Operator"
    },
    {
      "code" : "8333.017",
      "display" : "Winch Driver Operator",
      "definition" : "Winch Driver Operator"
    },
    {
      "code" : "8334.001",
      "display" : "Car Wreck Tow Operator",
      "definition" : "Car Wreck Tow Operator"
    },
    {
      "code" : "8334.002",
      "display" : "Driver Material Handling Equipment",
      "definition" : "Driver Material Handling Equipment"
    },
    {
      "code" : "8334.003",
      "display" : "Fork Hoist Driver",
      "definition" : "Fork Hoist Driver"
    },
    {
      "code" : "8334.004",
      "display" : "Fork Hoist Operator",
      "definition" : "Fork Hoist Operator"
    },
    {
      "code" : "8334.005",
      "display" : "Fork Lift Driver",
      "definition" : "Fork Lift Driver"
    },
    {
      "code" : "8334.006",
      "display" : "Forklift Driver",
      "definition" : "Forklift Driver"
    },
    {
      "code" : "8334.007",
      "display" : "Forklift Operator",
      "definition" : "Forklift Operator"
    },
    {
      "code" : "8334.008",
      "display" : "Hoist Truck Operator",
      "definition" : "Hoist Truck Operator"
    },
    {
      "code" : "8334.009",
      "display" : "Kaitaraiwa Waka Uta",
      "definition" : "Kaitaraiwa Waka Uta"
    },
    {
      "code" : "8334.010",
      "display" : "Lumber Carrier Driver",
      "definition" : "Lumber Carrier Driver"
    },
    {
      "code" : "8334.011",
      "display" : "Straddle Carrier Driver",
      "definition" : "Straddle Carrier Driver"
    },
    {
      "code" : "8334.012",
      "display" : "Straddle Carrier Operator",
      "definition" : "Straddle Carrier Operator"
    },
    {
      "code" : "8334.013",
      "display" : "Straddle Truck Driver",
      "definition" : "Straddle Truck Driver"
    },
    {
      "code" : "8334.014",
      "display" : "Timber Carrier Driver",
      "definition" : "Timber Carrier Driver"
    },
    {
      "code" : "8334.015",
      "display" : "Tow Truck Driver",
      "definition" : "Tow Truck Driver"
    },
    {
      "code" : "8334.016",
      "display" : "Tow Truck Operator",
      "definition" : "Tow Truck Operator"
    },
    {
      "code" : "8334.017",
      "display" : "Vehicle Recovery Operator",
      "definition" : "Vehicle Recovery Operator"
    },
    {
      "code" : "8334.018",
      "display" : "Warehouse Forklift Driver",
      "definition" : "Warehouse Forklift Driver"
    },
    {
      "code" : "8341.001",
      "display" : "Able Seaman Merchant Marine",
      "definition" : "Able Seaman Merchant Marine"
    },
    {
      "code" : "8341.002",
      "display" : "Boatman Boat Barge Ship",
      "definition" : "Boatman Boat Barge Ship"
    },
    {
      "code" : "8341.003",
      "display" : "Charter Boat Operator",
      "definition" : "Charter Boat Operator"
    },
    {
      "code" : "8341.004",
      "display" : "Cruise Boat Proprietor",
      "definition" : "Cruise Boat Proprietor"
    },
    {
      "code" : "8341.005",
      "display" : "Deck Hand",
      "definition" : "Deck Hand"
    },
    {
      "code" : "8341.006",
      "display" : "Deck Rating",
      "definition" : "Deck Rating"
    },
    {
      "code" : "8341.007",
      "display" : "Deckhand",
      "definition" : "Deckhand"
    },
    {
      "code" : "8341.008",
      "display" : "Ferryman",
      "definition" : "Ferryman"
    },
    {
      "code" : "8341.009",
      "display" : "Jet Boat Operator",
      "definition" : "Jet Boat Operator"
    },
    {
      "code" : "8341.010",
      "display" : "Launchman",
      "definition" : "Launchman"
    },
    {
      "code" : "8341.011",
      "display" : "Mariner",
      "definition" : "Mariner"
    },
    {
      "code" : "8341.012",
      "display" : "Merchant Sailor",
      "definition" : "Merchant Sailor"
    },
    {
      "code" : "8341.013",
      "display" : "Merchant Seaman",
      "definition" : "Merchant Seaman"
    },
    {
      "code" : "8341.014",
      "display" : "Ordinary Seaman",
      "definition" : "Ordinary Seaman"
    },
    {
      "code" : "8341.015",
      "display" : "Other Ship or Boat Hand",
      "definition" : "Other Ship or Boat Hand"
    },
    {
      "code" : "8341.016",
      "display" : "Quartermaster Ship",
      "definition" : "Quartermaster Ship"
    },
    {
      "code" : "8341.017",
      "display" : "Seaman",
      "definition" : "Seaman"
    },
    {
      "code" : "8341.018",
      "display" : "Ship Crew Member",
      "definition" : "Ship Crew Member"
    },
    {
      "code" : "8411.001",
      "display" : "Accoustical Engineering Insulator",
      "definition" : "Accoustical Engineering Insulator"
    },
    {
      "code" : "8411.002",
      "display" : "Aluminium Joiner",
      "definition" : "Aluminium Joiner"
    },
    {
      "code" : "8411.003",
      "display" : "Aluminum Worker",
      "definition" : "Aluminum Worker"
    },
    {
      "code" : "8411.004",
      "display" : "Building Exterior Cleaner",
      "definition" : "Building Exterior Cleaner"
    },
    {
      "code" : "8411.005",
      "display" : "Building Insulator",
      "definition" : "Building Insulator"
    },
    {
      "code" : "8411.006",
      "display" : "Cable Splicer",
      "definition" : "Cable Splicer"
    },
    {
      "code" : "8411.007",
      "display" : "Construction Bracer",
      "definition" : "Construction Bracer"
    },
    {
      "code" : "8411.008",
      "display" : "Construction Cable Layer",
      "definition" : "Construction Cable Layer"
    },
    {
      "code" : "8411.009",
      "display" : "Construction Cable Puller",
      "definition" : "Construction Cable Puller"
    },
    {
      "code" : "8411.010",
      "display" : "Construction Steel Erector",
      "definition" : "Construction Steel Erector"
    },
    {
      "code" : "8411.011",
      "display" : "Construction Steel Worker",
      "definition" : "Construction Steel Worker"
    },
    {
      "code" : "8411.012",
      "display" : "Drain Layer",
      "definition" : "Drain Layer"
    },
    {
      "code" : "8411.013",
      "display" : "Drain Layers Labourer",
      "definition" : "Drain Layers Labourer"
    },
    {
      "code" : "8411.014",
      "display" : "Drain Pipe Layer",
      "definition" : "Drain Pipe Layer"
    },
    {
      "code" : "8411.015",
      "display" : "Drainage Contractor",
      "definition" : "Drainage Contractor"
    },
    {
      "code" : "8411.016",
      "display" : "Drainlayer",
      "definition" : "Drainlayer"
    },
    {
      "code" : "8411.017",
      "display" : "Drainlayers Labourer",
      "definition" : "Drainlayers Labourer"
    },
    {
      "code" : "8411.018",
      "display" : "Fibreglass Batts Installer",
      "definition" : "Fibreglass Batts Installer"
    },
    {
      "code" : "8411.019",
      "display" : "Fire Hydrant Repairman",
      "definition" : "Fire Hydrant Repairman"
    },
    {
      "code" : "8411.020",
      "display" : "Forest Rigger",
      "definition" : "Forest Rigger"
    },
    {
      "code" : "8411.021",
      "display" : "Gas Fitter",
      "definition" : "Gas Fitter"
    },
    {
      "code" : "8411.022",
      "display" : "Gasfitter",
      "definition" : "Gasfitter"
    },
    {
      "code" : "8411.023",
      "display" : "Heating Ventilation Air Conditioning Lagger",
      "definition" : "Heating Ventilation Air Conditioning Lagger"
    },
    {
      "code" : "8411.024",
      "display" : "Hoisting Equipment Rigger",
      "definition" : "Hoisting Equipment Rigger"
    },
    {
      "code" : "8411.025",
      "display" : "Insulating Contractor",
      "definition" : "Insulating Contractor"
    },
    {
      "code" : "8411.026",
      "display" : "Insulation Installer",
      "definition" : "Insulation Installer"
    },
    {
      "code" : "8411.027",
      "display" : "Insulator",
      "definition" : "Insulator"
    },
    {
      "code" : "8411.028",
      "display" : "Logging Rigger",
      "definition" : "Logging Rigger"
    },
    {
      "code" : "8411.029",
      "display" : "LPG Fitter",
      "definition" : "LPG Fitter"
    },
    {
      "code" : "8411.030",
      "display" : "Marker Structural Steel",
      "definition" : "Marker Structural Steel"
    },
    {
      "code" : "8411.031",
      "display" : "Metal Plate Bender",
      "definition" : "Metal Plate Bender"
    },
    {
      "code" : "8411.032",
      "display" : "Pipe Fitter",
      "definition" : "Pipe Fitter"
    },
    {
      "code" : "8411.033",
      "display" : "Pipe Lagger",
      "definition" : "Pipe Lagger"
    },
    {
      "code" : "8411.034",
      "display" : "Pipe Layer",
      "definition" : "Pipe Layer"
    },
    {
      "code" : "8411.035",
      "display" : "Process Worker Metal Doors Windows",
      "definition" : "Process Worker Metal Doors Windows"
    },
    {
      "code" : "8411.036",
      "display" : "Process Worker Metal Heaters",
      "definition" : "Process Worker Metal Heaters"
    },
    {
      "code" : "8411.037",
      "display" : "Reinforcing Iron Worker Construction",
      "definition" : "Reinforcing Iron Worker Construction"
    },
    {
      "code" : "8411.038",
      "display" : "Rigger",
      "definition" : "Rigger"
    },
    {
      "code" : "8411.039",
      "display" : "Roof Repairer",
      "definition" : "Roof Repairer"
    },
    {
      "code" : "8411.040",
      "display" : "Roof Slater",
      "definition" : "Roof Slater"
    },
    {
      "code" : "8411.041",
      "display" : "Roof Tiler",
      "definition" : "Roof Tiler"
    },
    {
      "code" : "8411.042",
      "display" : "Roof Worker",
      "definition" : "Roof Worker"
    },
    {
      "code" : "8411.043",
      "display" : "Roofer",
      "definition" : "Roofer"
    },
    {
      "code" : "8411.044",
      "display" : "Roofer Tiles and Slates",
      "definition" : "Roofer Tiles and Slates"
    },
    {
      "code" : "8411.045",
      "display" : "Rope Splicer",
      "definition" : "Rope Splicer"
    },
    {
      "code" : "8411.046",
      "display" : "Sandblaster",
      "definition" : "Sandblaster"
    },
    {
      "code" : "8411.047",
      "display" : "Sandblaster Building Cleaning",
      "definition" : "Sandblaster Building Cleaning"
    },
    {
      "code" : "8411.048",
      "display" : "Scaffolder",
      "definition" : "Scaffolder"
    },
    {
      "code" : "8411.049",
      "display" : "Scaffolding Rigger",
      "definition" : "Scaffolding Rigger"
    },
    {
      "code" : "8411.050",
      "display" : "Sewer Pipe Layer",
      "definition" : "Sewer Pipe Layer"
    },
    {
      "code" : "8411.051",
      "display" : "Ship Rigger",
      "definition" : "Ship Rigger"
    },
    {
      "code" : "8411.052",
      "display" : "Signal Erector",
      "definition" : "Signal Erector"
    },
    {
      "code" : "8411.053",
      "display" : "Steam Cleaner",
      "definition" : "Steam Cleaner"
    },
    {
      "code" : "8411.054",
      "display" : "Steam Cleaner Building Exteriors",
      "definition" : "Steam Cleaner Building Exteriors"
    },
    {
      "code" : "8411.055",
      "display" : "Steel Bender",
      "definition" : "Steel Bender"
    },
    {
      "code" : "8411.056",
      "display" : "Steel Fixer",
      "definition" : "Steel Fixer"
    },
    {
      "code" : "8411.057",
      "display" : "Steel Roofer",
      "definition" : "Steel Roofer"
    },
    {
      "code" : "8411.058",
      "display" : "Structural Metal Preparers",
      "definition" : "Structural Metal Preparers"
    },
    {
      "code" : "8411.059",
      "display" : "Structural Steel Erector",
      "definition" : "Structural Steel Erector"
    },
    {
      "code" : "8411.060",
      "display" : "Underground Drainlayer",
      "definition" : "Underground Drainlayer"
    },
    {
      "code" : "8411.061",
      "display" : "Undersealer",
      "definition" : "Undersealer"
    },
    {
      "code" : "8411.062",
      "display" : "Water Blaster",
      "definition" : "Water Blaster"
    },
    {
      "code" : "8411.063",
      "display" : "Water Blaster Buildings",
      "definition" : "Water Blaster Buildings"
    },
    {
      "code" : "8411.064",
      "display" : "Waterblaster",
      "definition" : "Waterblaster"
    },
    {
      "code" : "8411.065",
      "display" : "Well Drilling Rigger",
      "definition" : "Well Drilling Rigger"
    },
    {
      "code" : "8412.001",
      "display" : "Construction Diver",
      "definition" : "Construction Diver"
    },
    {
      "code" : "8412.002",
      "display" : "Diver",
      "definition" : "Diver"
    },
    {
      "code" : "8412.003",
      "display" : "Police Diver",
      "definition" : "Police Diver"
    },
    {
      "code" : "8412.004",
      "display" : "Underwater Salvage Worker",
      "definition" : "Underwater Salvage Worker"
    },
    {
      "code" : "8412.005",
      "display" : "Underwater Worker",
      "definition" : "Underwater Worker"
    },
    {
      "code" : "9111.001",
      "display" : "Aeroplane and Bus Washer",
      "definition" : "Aeroplane and Bus Washer"
    },
    {
      "code" : "9111.002",
      "display" : "Aircraft Interior Cleaner",
      "definition" : "Aircraft Interior Cleaner"
    },
    {
      "code" : "9111.003",
      "display" : "Borer Controller",
      "definition" : "Borer Controller"
    },
    {
      "code" : "9111.004",
      "display" : "Building Caretaker",
      "definition" : "Building Caretaker"
    },
    {
      "code" : "9111.005",
      "display" : "Building Caretaker Supervisor",
      "definition" : "Building Caretaker Supervisor"
    },
    {
      "code" : "9111.006",
      "display" : "Building Custodian",
      "definition" : "Building Custodian"
    },
    {
      "code" : "9111.007",
      "display" : "Building Interior Cleaner",
      "definition" : "Building Interior Cleaner"
    },
    {
      "code" : "9111.008",
      "display" : "Building Superintendent",
      "definition" : "Building Superintendent"
    },
    {
      "code" : "9111.009",
      "display" : "Bus and Car Interior Cleaner",
      "definition" : "Bus and Car Interior Cleaner"
    },
    {
      "code" : "9111.010",
      "display" : "Bus Cleaner Washer",
      "definition" : "Bus Cleaner Washer"
    },
    {
      "code" : "9111.011",
      "display" : "Camp Attendant Supervisor",
      "definition" : "Camp Attendant Supervisor"
    },
    {
      "code" : "9111.012",
      "display" : "Car Cleaner",
      "definition" : "Car Cleaner"
    },
    {
      "code" : "9111.013",
      "display" : "Car Detailer",
      "definition" : "Car Detailer"
    },
    {
      "code" : "9111.014",
      "display" : "Car Groomer",
      "definition" : "Car Groomer"
    },
    {
      "code" : "9111.015",
      "display" : "Car Valet",
      "definition" : "Car Valet"
    },
    {
      "code" : "9111.016",
      "display" : "Car Washer",
      "definition" : "Car Washer"
    },
    {
      "code" : "9111.017",
      "display" : "Car Yard Assistant",
      "definition" : "Car Yard Assistant"
    },
    {
      "code" : "9111.018",
      "display" : "Caretaker",
      "definition" : "Caretaker"
    },
    {
      "code" : "9111.019",
      "display" : "Ceiling Cleaner",
      "definition" : "Ceiling Cleaner"
    },
    {
      "code" : "9111.020",
      "display" : "Chimney Sweep",
      "definition" : "Chimney Sweep"
    },
    {
      "code" : "9111.021",
      "display" : "Cleaner",
      "definition" : "Cleaner"
    },
    {
      "code" : "9111.022",
      "display" : "Cleaning Contractor",
      "definition" : "Cleaning Contractor"
    },
    {
      "code" : "9111.023",
      "display" : "Cleaning Supervisor",
      "definition" : "Cleaning Supervisor"
    },
    {
      "code" : "9111.024",
      "display" : "Commercial Cleaner",
      "definition" : "Commercial Cleaner"
    },
    {
      "code" : "9111.025",
      "display" : "Commercial Cleaning Supervisor",
      "definition" : "Commercial Cleaning Supervisor"
    },
    {
      "code" : "9111.026",
      "display" : "Contract Cleaner",
      "definition" : "Contract Cleaner"
    },
    {
      "code" : "9111.027",
      "display" : "Custodian",
      "definition" : "Custodian"
    },
    {
      "code" : "9111.028",
      "display" : "Dish Washer",
      "definition" : "Dish Washer"
    },
    {
      "code" : "9111.029",
      "display" : "Dishwasher",
      "definition" : "Dishwasher"
    },
    {
      "code" : "9111.030",
      "display" : "Domestic Cleaner",
      "definition" : "Domestic Cleaner"
    },
    {
      "code" : "9111.031",
      "display" : "Factory Cleaner",
      "definition" : "Factory Cleaner"
    },
    {
      "code" : "9111.032",
      "display" : "Factory Sweeper",
      "definition" : "Factory Sweeper"
    },
    {
      "code" : "9111.033",
      "display" : "Farm and Other Pest Control Worker",
      "definition" : "Farm and Other Pest Control Worker"
    },
    {
      "code" : "9111.034",
      "display" : "Hospital Cleaner",
      "definition" : "Hospital Cleaner"
    },
    {
      "code" : "9111.035",
      "display" : "Hotel Cleaner",
      "definition" : "Hotel Cleaner"
    },
    {
      "code" : "9111.036",
      "display" : "House Cleaner",
      "definition" : "House Cleaner"
    },
    {
      "code" : "9111.037",
      "display" : "Housecleaner",
      "definition" : "Housecleaner"
    },
    {
      "code" : "9111.038",
      "display" : "Industrial Cleaner",
      "definition" : "Industrial Cleaner"
    },
    {
      "code" : "9111.039",
      "display" : "Industrial Factory Cleaner",
      "definition" : "Industrial Factory Cleaner"
    },
    {
      "code" : "9111.040",
      "display" : "Janitor",
      "definition" : "Janitor"
    },
    {
      "code" : "9111.041",
      "display" : "Kaitahitahi",
      "definition" : "Kaitahitahi"
    },
    {
      "code" : "9111.042",
      "display" : "Kaitiaki",
      "definition" : "Kaitiaki"
    },
    {
      "code" : "9111.043",
      "display" : "Kaiwhakapai Whare",
      "definition" : "Kaiwhakapai Whare"
    },
    {
      "code" : "9111.044",
      "display" : "Locomotive and Train Cleaner",
      "definition" : "Locomotive and Train Cleaner"
    },
    {
      "code" : "9111.045",
      "display" : "Maintenance Officer Caretaker",
      "definition" : "Maintenance Officer Caretaker"
    },
    {
      "code" : "9111.046",
      "display" : "Moss and Fungi Eradicator",
      "definition" : "Moss and Fungi Eradicator"
    },
    {
      "code" : "9111.047",
      "display" : "Motel Cleaner",
      "definition" : "Motel Cleaner"
    },
    {
      "code" : "9111.048",
      "display" : "Motor Camp Attendant",
      "definition" : "Motor Camp Attendant"
    },
    {
      "code" : "9111.049",
      "display" : "Motor Vehicle Detailer",
      "definition" : "Motor Vehicle Detailer"
    },
    {
      "code" : "9111.050",
      "display" : "Office Cleaner",
      "definition" : "Office Cleaner"
    },
    {
      "code" : "9111.051",
      "display" : "Pest and Vermin Control Worker",
      "definition" : "Pest and Vermin Control Worker"
    },
    {
      "code" : "9111.052",
      "display" : "Pest Control Worker",
      "definition" : "Pest Control Worker"
    },
    {
      "code" : "9111.053",
      "display" : "Pest Eradication Worker",
      "definition" : "Pest Eradication Worker"
    },
    {
      "code" : "9111.054",
      "display" : "Porter Apartment House",
      "definition" : "Porter Apartment House"
    },
    {
      "code" : "9111.055",
      "display" : "Property Supervisor Caretaker",
      "definition" : "Property Supervisor Caretaker"
    },
    {
      "code" : "9111.056",
      "display" : "Quality Controller of Cleaners",
      "definition" : "Quality Controller of Cleaners"
    },
    {
      "code" : "9111.057",
      "display" : "Rat and Mouse Control Worker",
      "definition" : "Rat and Mouse Control Worker"
    },
    {
      "code" : "9111.058",
      "display" : "School Caretaker",
      "definition" : "School Caretaker"
    },
    {
      "code" : "9111.059",
      "display" : "School Cleaner",
      "definition" : "School Cleaner"
    },
    {
      "code" : "9111.060",
      "display" : "Septic Tank Cleaner",
      "definition" : "Septic Tank Cleaner"
    },
    {
      "code" : "9111.061",
      "display" : "Sexton C6146",
      "definition" : "Sexton C6146"
    },
    {
      "code" : "9111.062",
      "display" : "Spider Proofer",
      "definition" : "Spider Proofer"
    },
    {
      "code" : "9111.063",
      "display" : "Train Washer Cleaner",
      "definition" : "Train Washer Cleaner"
    },
    {
      "code" : "9111.064",
      "display" : "Vehicle Cleaner",
      "definition" : "Vehicle Cleaner"
    },
    {
      "code" : "9111.065",
      "display" : "Vehicle Groomer",
      "definition" : "Vehicle Groomer"
    },
    {
      "code" : "9111.066",
      "display" : "Vehicle Washer",
      "definition" : "Vehicle Washer"
    },
    {
      "code" : "9111.067",
      "display" : "Verger Church Janitor",
      "definition" : "Verger Church Janitor"
    },
    {
      "code" : "9111.068",
      "display" : "Wards Maid",
      "definition" : "Wards Maid"
    },
    {
      "code" : "9111.069",
      "display" : "Wardsmaid",
      "definition" : "Wardsmaid"
    },
    {
      "code" : "9111.070",
      "display" : "Window Cleaner",
      "definition" : "Window Cleaner"
    },
    {
      "code" : "9111.071",
      "display" : "Window Cleaning Contracter",
      "definition" : "Window Cleaning Contracter"
    },
    {
      "code" : "9111.072",
      "display" : "Window Washer",
      "definition" : "Window Washer"
    },
    {
      "code" : "9121.001",
      "display" : "Baggage Checker",
      "definition" : "Baggage Checker"
    },
    {
      "code" : "9121.002",
      "display" : "Baggage Handler",
      "definition" : "Baggage Handler"
    },
    {
      "code" : "9121.003",
      "display" : "Bicycle Courier",
      "definition" : "Bicycle Courier"
    },
    {
      "code" : "9121.004",
      "display" : "Circular Distributor",
      "definition" : "Circular Distributor"
    },
    {
      "code" : "9121.005",
      "display" : "Commissionaire Porter",
      "definition" : "Commissionaire Porter"
    },
    {
      "code" : "9121.006",
      "display" : "Concierge",
      "definition" : "Concierge"
    },
    {
      "code" : "9121.007",
      "display" : "Courier",
      "definition" : "Courier"
    },
    {
      "code" : "9121.008",
      "display" : "Courier and Deliverer",
      "definition" : "Courier and Deliverer"
    },
    {
      "code" : "9121.009",
      "display" : "Courier Driver",
      "definition" : "Courier Driver"
    },
    {
      "code" : "9121.010",
      "display" : "Courier Messenger",
      "definition" : "Courier Messenger"
    },
    {
      "code" : "9121.011",
      "display" : "Delivery Driver",
      "definition" : "Delivery Driver"
    },
    {
      "code" : "9121.012",
      "display" : "Delivery Person",
      "definition" : "Delivery Person"
    },
    {
      "code" : "9121.013",
      "display" : "Deliveryman",
      "definition" : "Deliveryman"
    },
    {
      "code" : "9121.014",
      "display" : "Drycleaning Deliverer",
      "definition" : "Drycleaning Deliverer"
    },
    {
      "code" : "9121.015",
      "display" : "Errand Boy",
      "definition" : "Errand Boy"
    },
    {
      "code" : "9121.016",
      "display" : "Fleet Courier",
      "definition" : "Fleet Courier"
    },
    {
      "code" : "9121.017",
      "display" : "Floral Courier",
      "definition" : "Floral Courier"
    },
    {
      "code" : "9121.018",
      "display" : "Government Messenger",
      "definition" : "Government Messenger"
    },
    {
      "code" : "9121.019",
      "display" : "Hotel Bell Boy",
      "definition" : "Hotel Bell Boy"
    },
    {
      "code" : "9121.020",
      "display" : "Hotel Concierge",
      "definition" : "Hotel Concierge"
    },
    {
      "code" : "9121.021",
      "display" : "Hotel Porter",
      "definition" : "Hotel Porter"
    },
    {
      "code" : "9121.022",
      "display" : "Kaikawe Kopaki",
      "definition" : "Kaikawe Kopaki"
    },
    {
      "code" : "9121.023",
      "display" : "Kaikawe Meera",
      "definition" : "Kaikawe Meera"
    },
    {
      "code" : "9121.024",
      "display" : "Kaitukunga",
      "definition" : "Kaitukunga"
    },
    {
      "code" : "9121.025",
      "display" : "Letter Carrier",
      "definition" : "Letter Carrier"
    },
    {
      "code" : "9121.026",
      "display" : "Messenger",
      "definition" : "Messenger"
    },
    {
      "code" : "9121.027",
      "display" : "Milk Boy",
      "definition" : "Milk Boy"
    },
    {
      "code" : "9121.028",
      "display" : "Milk Delivery Boy",
      "definition" : "Milk Delivery Boy"
    },
    {
      "code" : "9121.029",
      "display" : "Milkboy",
      "definition" : "Milkboy"
    },
    {
      "code" : "9121.030",
      "display" : "Motor Cycle Courier",
      "definition" : "Motor Cycle Courier"
    },
    {
      "code" : "9121.031",
      "display" : "Newspaper Deliverer",
      "definition" : "Newspaper Deliverer"
    },
    {
      "code" : "9121.032",
      "display" : "Newspaper Delivery Boy",
      "definition" : "Newspaper Delivery Boy"
    },
    {
      "code" : "9121.033",
      "display" : "Pamphlet Deliverer",
      "definition" : "Pamphlet Deliverer"
    },
    {
      "code" : "9121.034",
      "display" : "Paper Boy",
      "definition" : "Paper Boy"
    },
    {
      "code" : "9121.035",
      "display" : "Paper Deliverer",
      "definition" : "Paper Deliverer"
    },
    {
      "code" : "9121.036",
      "display" : "Paper Delivery Boy",
      "definition" : "Paper Delivery Boy"
    },
    {
      "code" : "9121.037",
      "display" : "Paper Girl",
      "definition" : "Paper Girl"
    },
    {
      "code" : "9121.038",
      "display" : "Paper Runner",
      "definition" : "Paper Runner"
    },
    {
      "code" : "9121.039",
      "display" : "Paperboy",
      "definition" : "Paperboy"
    },
    {
      "code" : "9121.040",
      "display" : "Pizza Deliverer",
      "definition" : "Pizza Deliverer"
    },
    {
      "code" : "9121.041",
      "display" : "Pizza Delivery Person",
      "definition" : "Pizza Delivery Person"
    },
    {
      "code" : "9131.001",
      "display" : "Council Sweeper",
      "definition" : "Council Sweeper"
    },
    {
      "code" : "9131.002",
      "display" : "Dustman",
      "definition" : "Dustman"
    },
    {
      "code" : "9131.003",
      "display" : "Garbage Collector",
      "definition" : "Garbage Collector"
    },
    {
      "code" : "9131.004",
      "display" : "Garden Rubbish Collector",
      "definition" : "Garden Rubbish Collector"
    },
    {
      "code" : "9131.005",
      "display" : "Litter Control Officer",
      "definition" : "Litter Control Officer"
    },
    {
      "code" : "9131.006",
      "display" : "Park and Gardens Sweeper",
      "definition" : "Park and Gardens Sweeper"
    },
    {
      "code" : "9131.007",
      "display" : "Park and Public Garden Cleaner",
      "definition" : "Park and Public Garden Cleaner"
    },
    {
      "code" : "9131.008",
      "display" : "Park Cleaner",
      "definition" : "Park Cleaner"
    },
    {
      "code" : "9131.009",
      "display" : "Parks and Reserves Labourer",
      "definition" : "Parks and Reserves Labourer"
    },
    {
      "code" : "9131.010",
      "display" : "Recycler",
      "definition" : "Recycler"
    },
    {
      "code" : "9131.011",
      "display" : "Refuse Collector",
      "definition" : "Refuse Collector"
    },
    {
      "code" : "9131.012",
      "display" : "Road Sweeper",
      "definition" : "Road Sweeper"
    },
    {
      "code" : "9131.013",
      "display" : "Rubbish Collection Contractor",
      "definition" : "Rubbish Collection Contractor"
    },
    {
      "code" : "9131.014",
      "display" : "Rubbish Collector",
      "definition" : "Rubbish Collector"
    },
    {
      "code" : "9131.015",
      "display" : "Street or Park Cleaner",
      "definition" : "Street or Park Cleaner"
    },
    {
      "code" : "9131.016",
      "display" : "Street Sweeper Cleaner",
      "definition" : "Street Sweeper Cleaner"
    },
    {
      "code" : "9141.001",
      "display" : "Aircraft Loader",
      "definition" : "Aircraft Loader"
    },
    {
      "code" : "9141.002",
      "display" : "Baggage Handler Freight",
      "definition" : "Baggage Handler Freight"
    },
    {
      "code" : "9141.003",
      "display" : "Baggage Officer Storeman",
      "definition" : "Baggage Officer Storeman"
    },
    {
      "code" : "9141.004",
      "display" : "Boat and Ship Cargo Loader",
      "definition" : "Boat and Ship Cargo Loader"
    },
    {
      "code" : "9141.005",
      "display" : "Boxer Packer",
      "definition" : "Boxer Packer"
    },
    {
      "code" : "9141.006",
      "display" : "Bread Packer",
      "definition" : "Bread Packer"
    },
    {
      "code" : "9141.007",
      "display" : "Can and Tin Filler",
      "definition" : "Can and Tin Filler"
    },
    {
      "code" : "9141.008",
      "display" : "Candle Maker Moulder Dipper",
      "definition" : "Candle Maker Moulder Dipper"
    },
    {
      "code" : "9141.009",
      "display" : "Cargo Handler",
      "definition" : "Cargo Handler"
    },
    {
      "code" : "9141.010",
      "display" : "Cargo Serviceman",
      "definition" : "Cargo Serviceman"
    },
    {
      "code" : "9141.011",
      "display" : "Cargo Worker",
      "definition" : "Cargo Worker"
    },
    {
      "code" : "9141.012",
      "display" : "Checker and Loader Transport Vehicle",
      "definition" : "Checker and Loader Transport Vehicle"
    },
    {
      "code" : "9141.013",
      "display" : "Confectionery Packer",
      "definition" : "Confectionery Packer"
    },
    {
      "code" : "9141.014",
      "display" : "Conveyer Belt Operator",
      "definition" : "Conveyer Belt Operator"
    },
    {
      "code" : "9141.015",
      "display" : "Docker Wharf",
      "definition" : "Docker Wharf"
    },
    {
      "code" : "9141.016",
      "display" : "Egg Grader and Packer",
      "definition" : "Egg Grader and Packer"
    },
    {
      "code" : "9141.017",
      "display" : "Egg Processor",
      "definition" : "Egg Processor"
    },
    {
      "code" : "9141.018",
      "display" : "Engineering Storeman",
      "definition" : "Engineering Storeman"
    },
    {
      "code" : "9141.019",
      "display" : "Engineering Storeperson",
      "definition" : "Engineering Storeperson"
    },
    {
      "code" : "9141.020",
      "display" : "Filling Machine Operator",
      "definition" : "Filling Machine Operator"
    },
    {
      "code" : "9141.021",
      "display" : "Food Packer",
      "definition" : "Food Packer"
    },
    {
      "code" : "9141.022",
      "display" : "Freight Handler Labourer Wharf",
      "definition" : "Freight Handler Labourer Wharf"
    },
    {
      "code" : "9141.023",
      "display" : "Freight Handler Offsider",
      "definition" : "Freight Handler Offsider"
    },
    {
      "code" : "9141.024",
      "display" : "Fruit Grader and Packer Market",
      "definition" : "Fruit Grader and Packer Market"
    },
    {
      "code" : "9141.025",
      "display" : "Furniture Mover Offsider",
      "definition" : "Furniture Mover Offsider"
    },
    {
      "code" : "9141.026",
      "display" : "Furniture Packer Remover",
      "definition" : "Furniture Packer Remover"
    },
    {
      "code" : "9141.027",
      "display" : "Furniture Removal Person",
      "definition" : "Furniture Removal Person"
    },
    {
      "code" : "9141.028",
      "display" : "General Storeperson",
      "definition" : "General Storeperson"
    },
    {
      "code" : "9141.029",
      "display" : "Goodshed Labourer Railway",
      "definition" : "Goodshed Labourer Railway"
    },
    {
      "code" : "9141.030",
      "display" : "Hand or Machine Labeller",
      "definition" : "Hand or Machine Labeller"
    },
    {
      "code" : "9141.031",
      "display" : "Harbour Board Worker",
      "definition" : "Harbour Board Worker"
    },
    {
      "code" : "9141.032",
      "display" : "Hose Handler",
      "definition" : "Hose Handler"
    },
    {
      "code" : "9141.033",
      "display" : "Jar or Bottle Filler",
      "definition" : "Jar or Bottle Filler"
    },
    {
      "code" : "9141.034",
      "display" : "Kaitakupe",
      "definition" : "Kaitakupe"
    },
    {
      "code" : "9141.035",
      "display" : "Kaiwhawhao",
      "definition" : "Kaiwhawhao"
    },
    {
      "code" : "9141.036",
      "display" : "Kaiwhawhao Miiti",
      "definition" : "Kaiwhawhao Miiti"
    },
    {
      "code" : "9141.037",
      "display" : "Kaiwhawhao Miti",
      "definition" : "Kaiwhawhao Miti"
    },
    {
      "code" : "9141.038",
      "display" : "Leading Freight Hand",
      "definition" : "Leading Freight Hand"
    },
    {
      "code" : "9141.039",
      "display" : "Liquid and Gas Loader Ship or Boat",
      "definition" : "Liquid and Gas Loader Ship or Boat"
    },
    {
      "code" : "9141.040",
      "display" : "Loader Aerial Topdressing",
      "definition" : "Loader Aerial Topdressing"
    },
    {
      "code" : "9141.041",
      "display" : "Loader Driver",
      "definition" : "Loader Driver"
    },
    {
      "code" : "9141.042",
      "display" : "Loader Operator",
      "definition" : "Loader Operator"
    },
    {
      "code" : "9141.043",
      "display" : "Loader or Checker",
      "definition" : "Loader or Checker"
    },
    {
      "code" : "9141.044",
      "display" : "Longshoreman",
      "definition" : "Longshoreman"
    },
    {
      "code" : "9141.045",
      "display" : "Lorry Loader",
      "definition" : "Lorry Loader"
    },
    {
      "code" : "9141.046",
      "display" : "Market Warehouse Porter",
      "definition" : "Market Warehouse Porter"
    },
    {
      "code" : "9141.047",
      "display" : "Match Packer Filler",
      "definition" : "Match Packer Filler"
    },
    {
      "code" : "9141.048",
      "display" : "Meat Packer",
      "definition" : "Meat Packer"
    },
    {
      "code" : "9141.049",
      "display" : "Meat Preparer and Packer Freezing Works",
      "definition" : "Meat Preparer and Packer Freezing Works"
    },
    {
      "code" : "9141.050",
      "display" : "Milk Bottler",
      "definition" : "Milk Bottler"
    },
    {
      "code" : "9141.051",
      "display" : "Mussel Packer",
      "definition" : "Mussel Packer"
    },
    {
      "code" : "9141.052",
      "display" : "Packer",
      "definition" : "Packer"
    },
    {
      "code" : "9141.053",
      "display" : "Packer and Examiner",
      "definition" : "Packer and Examiner"
    },
    {
      "code" : "9141.054",
      "display" : "Packing Machine Operator",
      "definition" : "Packing Machine Operator"
    },
    {
      "code" : "9141.055",
      "display" : "Paint Tin Filler",
      "definition" : "Paint Tin Filler"
    },
    {
      "code" : "9141.056",
      "display" : "Paper Mill Baler",
      "definition" : "Paper Mill Baler"
    },
    {
      "code" : "9141.057",
      "display" : "Press Operator Bale",
      "definition" : "Press Operator Bale"
    },
    {
      "code" : "9141.058",
      "display" : "Quality Controller of Packers",
      "definition" : "Quality Controller of Packers"
    },
    {
      "code" : "9141.059",
      "display" : "Rail and Road Transport Vehicle Loader",
      "definition" : "Rail and Road Transport Vehicle Loader"
    },
    {
      "code" : "9141.060",
      "display" : "Railway Brakeman",
      "definition" : "Railway Brakeman"
    },
    {
      "code" : "9141.061",
      "display" : "Railway Checker",
      "definition" : "Railway Checker"
    },
    {
      "code" : "9141.062",
      "display" : "Railway Employee Rail Freight",
      "definition" : "Railway Employee Rail Freight"
    },
    {
      "code" : "9141.063",
      "display" : "Railway Operator",
      "definition" : "Railway Operator"
    },
    {
      "code" : "9141.064",
      "display" : "Railway Pointsman",
      "definition" : "Railway Pointsman"
    },
    {
      "code" : "9141.065",
      "display" : "Railway Porter",
      "definition" : "Railway Porter"
    },
    {
      "code" : "9141.066",
      "display" : "Railway Shunter",
      "definition" : "Railway Shunter"
    },
    {
      "code" : "9141.067",
      "display" : "Railway Signalman",
      "definition" : "Railway Signalman"
    },
    {
      "code" : "9141.068",
      "display" : "Railway Traffic Assistant",
      "definition" : "Railway Traffic Assistant"
    },
    {
      "code" : "9141.069",
      "display" : "Railway Traffic Operator",
      "definition" : "Railway Traffic Operator"
    },
    {
      "code" : "9141.070",
      "display" : "Sack or Bag Filler",
      "definition" : "Sack or Bag Filler"
    },
    {
      "code" : "9141.071",
      "display" : "Sealing and Capping Machine Operator",
      "definition" : "Sealing and Capping Machine Operator"
    },
    {
      "code" : "9141.072",
      "display" : "Shunter",
      "definition" : "Shunter"
    },
    {
      "code" : "9141.073",
      "display" : "Signal Man",
      "definition" : "Signal Man"
    },
    {
      "code" : "9141.074",
      "display" : "Stacker Textiles",
      "definition" : "Stacker Textiles"
    },
    {
      "code" : "9141.075",
      "display" : "Stevedore",
      "definition" : "Stevedore"
    },
    {
      "code" : "9141.076",
      "display" : "Store Hand",
      "definition" : "Store Hand"
    },
    {
      "code" : "9141.077",
      "display" : "Storeman Packer",
      "definition" : "Storeman Packer"
    },
    {
      "code" : "9141.078",
      "display" : "Storeperson Packer",
      "definition" : "Storeperson Packer"
    },
    {
      "code" : "9141.079",
      "display" : "Storeperson Shelver",
      "definition" : "Storeperson Shelver"
    },
    {
      "code" : "9141.080",
      "display" : "Tube Filler Food",
      "definition" : "Tube Filler Food"
    },
    {
      "code" : "9141.081",
      "display" : "Warehouse Assistant",
      "definition" : "Warehouse Assistant"
    },
    {
      "code" : "9141.082",
      "display" : "Warehouse Assistant Sales",
      "definition" : "Warehouse Assistant Sales"
    },
    {
      "code" : "9141.083",
      "display" : "Warehouse Offsider",
      "definition" : "Warehouse Offsider"
    },
    {
      "code" : "9141.084",
      "display" : "Warehouse Packer",
      "definition" : "Warehouse Packer"
    },
    {
      "code" : "9141.085",
      "display" : "Warehouse Person",
      "definition" : "Warehouse Person"
    },
    {
      "code" : "9141.086",
      "display" : "Warehouse Shelver",
      "definition" : "Warehouse Shelver"
    },
    {
      "code" : "9141.087",
      "display" : "Warehouse Supervisor Loader Packer",
      "definition" : "Warehouse Supervisor Loader Packer"
    },
    {
      "code" : "9141.088",
      "display" : "Warehouse Worker",
      "definition" : "Warehouse Worker"
    },
    {
      "code" : "9141.089",
      "display" : "Warehouseman",
      "definition" : "Warehouseman"
    },
    {
      "code" : "9141.090",
      "display" : "Warehouseman Wholesale",
      "definition" : "Warehouseman Wholesale"
    },
    {
      "code" : "9141.091",
      "display" : "Waterside Worker",
      "definition" : "Waterside Worker"
    },
    {
      "code" : "9141.092",
      "display" : "Watersider",
      "definition" : "Watersider"
    },
    {
      "code" : "9141.093",
      "display" : "Wharf Overseer",
      "definition" : "Wharf Overseer"
    },
    {
      "code" : "9141.094",
      "display" : "Wool Packer",
      "definition" : "Wool Packer"
    },
    {
      "code" : "9141.095",
      "display" : "Wool Presser",
      "definition" : "Wool Presser"
    },
    {
      "code" : "9141.096",
      "display" : "Wrapper",
      "definition" : "Wrapper"
    },
    {
      "code" : "9141.097",
      "display" : "Wrapping Machine Operator",
      "definition" : "Wrapping Machine Operator"
    },
    {
      "code" : "9151.001",
      "display" : "Bitumen Mixer Roading",
      "definition" : "Bitumen Mixer Roading"
    },
    {
      "code" : "9151.002",
      "display" : "Boilermakers Labourer",
      "definition" : "Boilermakers Labourer"
    },
    {
      "code" : "9151.003",
      "display" : "Bricklayers Labourer",
      "definition" : "Bricklayers Labourer"
    },
    {
      "code" : "9151.004",
      "display" : "Bridge Construction Labourer",
      "definition" : "Bridge Construction Labourer"
    },
    {
      "code" : "9151.005",
      "display" : "Bridge Maintenance Man",
      "definition" : "Bridge Maintenance Man"
    },
    {
      "code" : "9151.006",
      "display" : "Bridge Maintenance Person",
      "definition" : "Bridge Maintenance Person"
    },
    {
      "code" : "9151.007",
      "display" : "Builders Labourer",
      "definition" : "Builders Labourer"
    },
    {
      "code" : "9151.008",
      "display" : "Building Construction Labourer",
      "definition" : "Building Construction Labourer"
    },
    {
      "code" : "9151.009",
      "display" : "Building Maintenance Man",
      "definition" : "Building Maintenance Man"
    },
    {
      "code" : "9151.010",
      "display" : "Car Marshall (Ferry)",
      "definition" : "Car Marshall (Ferry)"
    },
    {
      "code" : "9151.011",
      "display" : "Council Labourer",
      "definition" : "Council Labourer"
    },
    {
      "code" : "9151.012",
      "display" : "Demolition Contractor",
      "definition" : "Demolition Contractor"
    },
    {
      "code" : "9151.013",
      "display" : "Demolition Labourer",
      "definition" : "Demolition Labourer"
    },
    {
      "code" : "9151.014",
      "display" : "Digging Labourer",
      "definition" : "Digging Labourer"
    },
    {
      "code" : "9151.015",
      "display" : "Ditch Digger",
      "definition" : "Ditch Digger"
    },
    {
      "code" : "9151.016",
      "display" : "Electric Power Construction Work Labourer",
      "definition" : "Electric Power Construction Work Labourer"
    },
    {
      "code" : "9151.017",
      "display" : "Factory Hand",
      "definition" : "Factory Hand"
    },
    {
      "code" : "9151.018",
      "display" : "Factory Hand Sports Goods",
      "definition" : "Factory Hand Sports Goods"
    },
    {
      "code" : "9151.019",
      "display" : "Factory Labourer",
      "definition" : "Factory Labourer"
    },
    {
      "code" : "9151.020",
      "display" : "Fencing Labourer",
      "definition" : "Fencing Labourer"
    },
    {
      "code" : "9151.021",
      "display" : "Fitters Mate",
      "definition" : "Fitters Mate"
    },
    {
      "code" : "9151.022",
      "display" : "General Factory Hand",
      "definition" : "General Factory Hand"
    },
    {
      "code" : "9151.023",
      "display" : "General Labourer",
      "definition" : "General Labourer"
    },
    {
      "code" : "9151.024",
      "display" : "Gravedigger",
      "definition" : "Gravedigger"
    },
    {
      "code" : "9151.025",
      "display" : "Handyman",
      "definition" : "Handyman"
    },
    {
      "code" : "9151.026",
      "display" : "Harbour Construction Labourer",
      "definition" : "Harbour Construction Labourer"
    },
    {
      "code" : "9151.027",
      "display" : "Hydro Contract Labourer",
      "definition" : "Hydro Contract Labourer"
    },
    {
      "code" : "9151.028",
      "display" : "Irrigation Worker",
      "definition" : "Irrigation Worker"
    },
    {
      "code" : "9151.029",
      "display" : "Kaiawhina Hanga Whare",
      "definition" : "Kaiawhina Hanga Whare"
    },
    {
      "code" : "9151.030",
      "display" : "Kaiawhina Wheketere",
      "definition" : "Kaiawhina Wheketere"
    },
    {
      "code" : "9151.031",
      "display" : "Kaimahi",
      "definition" : "Kaimahi"
    },
    {
      "code" : "9151.032",
      "display" : "Kaimahi Hanga Whare",
      "definition" : "Kaimahi Hanga Whare"
    },
    {
      "code" : "9151.033",
      "display" : "Kaimahi Whare Papa",
      "definition" : "Kaimahi Whare Papa"
    },
    {
      "code" : "9151.034",
      "display" : "Kaimahi Wheketere",
      "definition" : "Kaimahi Wheketere"
    },
    {
      "code" : "9151.035",
      "display" : "Kaiwhakarite Raakau",
      "definition" : "Kaiwhakarite Raakau"
    },
    {
      "code" : "9151.036",
      "display" : "Kaiwhakarite Rakau",
      "definition" : "Kaiwhakarite Rakau"
    },
    {
      "code" : "9151.037",
      "display" : "Kerb Setter",
      "definition" : "Kerb Setter"
    },
    {
      "code" : "9151.038",
      "display" : "Mill Hand Worker Woollen Mill",
      "definition" : "Mill Hand Worker Woollen Mill"
    },
    {
      "code" : "9151.039",
      "display" : "Navvy",
      "definition" : "Navvy"
    },
    {
      "code" : "9151.040",
      "display" : "Navvy Railway",
      "definition" : "Navvy Railway"
    },
    {
      "code" : "9151.041",
      "display" : "Offsider",
      "definition" : "Offsider"
    },
    {
      "code" : "9151.042",
      "display" : "Plasterers Labourer",
      "definition" : "Plasterers Labourer"
    },
    {
      "code" : "9151.043",
      "display" : "Plumbers Labourer",
      "definition" : "Plumbers Labourer"
    },
    {
      "code" : "9151.044",
      "display" : "Quality Controller of Builders Labourers",
      "definition" : "Quality Controller of Builders Labourers"
    },
    {
      "code" : "9151.045",
      "display" : "Quality Controller of General Labourers",
      "definition" : "Quality Controller of General Labourers"
    },
    {
      "code" : "9151.046",
      "display" : "Quality Controller of Sawmill Labourers",
      "definition" : "Quality Controller of Sawmill Labourers"
    },
    {
      "code" : "9151.047",
      "display" : "Railway Ballastman",
      "definition" : "Railway Ballastman"
    },
    {
      "code" : "9151.048",
      "display" : "Railway Construction Labourer",
      "definition" : "Railway Construction Labourer"
    },
    {
      "code" : "9151.049",
      "display" : "Railway Ganger",
      "definition" : "Railway Ganger"
    },
    {
      "code" : "9151.050",
      "display" : "Railway Surfaceman",
      "definition" : "Railway Surfaceman"
    },
    {
      "code" : "9151.051",
      "display" : "Railway Trackman",
      "definition" : "Railway Trackman"
    },
    {
      "code" : "9151.052",
      "display" : "Railway Washout Man",
      "definition" : "Railway Washout Man"
    },
    {
      "code" : "9151.053",
      "display" : "River Construction Labourer",
      "definition" : "River Construction Labourer"
    },
    {
      "code" : "9151.054",
      "display" : "Road Construction Labourer",
      "definition" : "Road Construction Labourer"
    },
    {
      "code" : "9151.055",
      "display" : "Road Maintenance Labourer",
      "definition" : "Road Maintenance Labourer"
    },
    {
      "code" : "9151.056",
      "display" : "Road Surfaceman",
      "definition" : "Road Surfaceman"
    },
    {
      "code" : "9151.057",
      "display" : "Roadman",
      "definition" : "Roadman"
    },
    {
      "code" : "9151.058",
      "display" : "Sawmill Bullock Horseman",
      "definition" : "Sawmill Bullock Horseman"
    },
    {
      "code" : "9151.059",
      "display" : "Sawmill Labourer",
      "definition" : "Sawmill Labourer"
    },
    {
      "code" : "9151.060",
      "display" : "Scene Shifter",
      "definition" : "Scene Shifter"
    },
    {
      "code" : "9151.061",
      "display" : "Stage Hand",
      "definition" : "Stage Hand"
    },
    {
      "code" : "9151.062",
      "display" : "Survey Field Assistant",
      "definition" : "Survey Field Assistant"
    },
    {
      "code" : "9151.063",
      "display" : "Surveyors Chainman Labourer",
      "definition" : "Surveyors Chainman Labourer"
    },
    {
      "code" : "9151.064",
      "display" : "Timber Filleter",
      "definition" : "Timber Filleter"
    },
    {
      "code" : "9151.065",
      "display" : "Timber Hand",
      "definition" : "Timber Hand"
    },
    {
      "code" : "9151.066",
      "display" : "Timber Stacker Hand",
      "definition" : "Timber Stacker Hand"
    },
    {
      "code" : "9151.067",
      "display" : "Timber Worker",
      "definition" : "Timber Worker"
    },
    {
      "code" : "9151.068",
      "display" : "Timber Worker Sawmill",
      "definition" : "Timber Worker Sawmill"
    },
    {
      "code" : "9151.069",
      "display" : "Timber Yard Worker",
      "definition" : "Timber Yard Worker"
    },
    {
      "code" : "9151.070",
      "display" : "Timberworker",
      "definition" : "Timberworker"
    },
    {
      "code" : "9151.071",
      "display" : "Tunneller",
      "definition" : "Tunneller"
    },
    {
      "code" : "9151.072",
      "display" : "Waterworks Labourer",
      "definition" : "Waterworks Labourer"
    },
    {
      "code" : "9151.073",
      "display" : "Waterworks Turncock",
      "definition" : "Waterworks Turncock"
    },
    {
      "code" : "9151.074",
      "display" : "Wool Store Labourer",
      "definition" : "Wool Store Labourer"
    },
    {
      "code" : "9151.075",
      "display" : "Yard Cleanup Man",
      "definition" : "Yard Cleanup Man"
    },
    {
      "code" : "9151.076",
      "display" : "Yardman Freight",
      "definition" : "Yardman Freight"
    },
    {
      "code" : "9151.077",
      "display" : "Yardman Sawmill Wood Yards",
      "definition" : "Yardman Sawmill Wood Yards"
    },
    {
      "code" : "9970.001",
      "display" : "Prostitute",
      "definition" : "Prostitute"
    },
    {
      "code" : "9970.002",
      "display" : "Refugee",
      "definition" : "Refugee"
    },
    {
      "code" : "9970.003",
      "display" : "Sex Worker",
      "definition" : "Sex Worker"
    },
    {
      "code" : "9970.004",
      "display" : "Escort",
      "definition" : "Escort"
    },
    {
      "code" : "9980.001",
      "display" : "Not Specified",
      "definition" : "Not Specified"
    },
    {
      "code" : "9980.002",
      "display" : "N/S",
      "definition" : "N/S"
    },
    {
      "code" : "9980.003",
      "display" : "Not Defined",
      "definition" : "Not Defined"
    },
    {
      "code" : "9980.004",
      "display" : "Not Detailed",
      "definition" : "Not Detailed"
    },
    {
      "code" : "9980.005",
      "display" : "Other",
      "definition" : "Other"
    },
    {
      "code" : "9980.006",
      "display" : "Unknown",
      "definition" : "Unknown"
    },
    {
      "code" : "9991.001",
      "display" : "Domestic Executive",
      "definition" : "Domestic Executive"
    },
    {
      "code" : "9991.002",
      "display" : "Foster Mother",
      "definition" : "Foster Mother"
    },
    {
      "code" : "9991.003",
      "display" : "Foster Father",
      "definition" : "Foster Father"
    },
    {
      "code" : "9991.004",
      "display" : "Home Executive",
      "definition" : "Home Executive"
    },
    {
      "code" : "9991.005",
      "display" : "Homemaker",
      "definition" : "Homemaker"
    },
    {
      "code" : "9991.006",
      "display" : "House Husband",
      "definition" : "House Husband"
    },
    {
      "code" : "9991.007",
      "display" : "Housewife",
      "definition" : "Housewife"
    },
    {
      "code" : "9991.008",
      "display" : "Mother",
      "definition" : "Mother"
    },
    {
      "code" : "9991.009",
      "display" : "Parent",
      "definition" : "Parent"
    },
    {
      "code" : "9991.010",
      "display" : "Widow",
      "definition" : "Widow"
    },
    {
      "code" : "9991.011",
      "display" : "Widower",
      "definition" : "Widower"
    },
    {
      "code" : "9991.012",
      "display" : "Single Parent",
      "definition" : "Single Parent"
    },
    {
      "code" : "9991.013",
      "display" : "Solo Parent",
      "definition" : "Solo Parent"
    },
    {
      "code" : "9991.014",
      "display" : "Single Father",
      "definition" : "Single Father"
    },
    {
      "code" : "9991.015",
      "display" : "Solo Father",
      "definition" : "Solo Father"
    },
    {
      "code" : "9991.016",
      "display" : "Single Mother",
      "definition" : "Single Mother"
    },
    {
      "code" : "9991.017",
      "display" : "Solo Mother",
      "definition" : "Solo Mother"
    },
    {
      "code" : "9991.018",
      "display" : "Caregiver",
      "definition" : "Caregiver"
    },
    {
      "code" : "9991.019",
      "display" : "Adoptive Parent",
      "definition" : "Adoptive Parent"
    },
    {
      "code" : "9991.020",
      "display" : "Host Parent",
      "definition" : "Host Parent"
    },
    {
      "code" : "9991.021",
      "display" : "Father",
      "definition" : "Father"
    },
    {
      "code" : "9991.022",
      "display" : "Carer",
      "definition" : "Carer"
    },
    {
      "code" : "9991.023",
      "display" : "Mother At Home",
      "definition" : "Mother At Home"
    },
    {
      "code" : "9991.024",
      "display" : "Father At Home",
      "definition" : "Father At Home"
    },
    {
      "code" : "9991.025",
      "display" : "Step-parent",
      "definition" : "Step-parent"
    },
    {
      "code" : "9991.026",
      "display" : "Stepmother",
      "definition" : "Stepmother"
    },
    {
      "code" : "9991.027",
      "display" : "Stepfather",
      "definition" : "Stepfather"
    },
    {
      "code" : "9991.028",
      "display" : "Household Work/Cooking/Repairs",
      "definition" : "Household Work/Cooking/Repairs"
    },
    {
      "code" : "9991.029",
      "display" : "Looking after a Child",
      "definition" : "Looking after a Child"
    },
    {
      "code" : "9991.030",
      "display" : "Looking after Someone/Disabled",
      "definition" : "Looking after Someone/Disabled"
    },
    {
      "code" : "9991.031",
      "display" : "Voluntary Help for Organisation/Marae/Group",
      "definition" : "Voluntary Help for Organisation/Marae/Group"
    },
    {
      "code" : "9991.032",
      "display" : "Studying Less than 20Hrs Per Week",
      "definition" : "Studying Less than 20Hrs Per Week"
    },
    {
      "code" : "9992.001",
      "display" : "ACC Beneficiary",
      "definition" : "ACC Beneficiary"
    },
    {
      "code" : "9992.002",
      "display" : "Beneficiary",
      "definition" : "Beneficiary"
    },
    {
      "code" : "9992.003",
      "display" : "Illness Beneficiary",
      "definition" : "Illness Beneficiary"
    },
    {
      "code" : "9992.004",
      "display" : "Sickness Allowance Recipient",
      "definition" : "Sickness Allowance Recipient"
    },
    {
      "code" : "9992.005",
      "display" : "Sickness Beneficiary",
      "definition" : "Sickness Beneficiary"
    },
    {
      "code" : "9992.006",
      "display" : "Illness Compensation Recipient",
      "definition" : "Illness Compensation Recipient"
    },
    {
      "code" : "9992.007",
      "display" : "ACC Claimant",
      "definition" : "ACC Claimant"
    },
    {
      "code" : "9992.008",
      "display" : "ACC Client",
      "definition" : "ACC Client"
    },
    {
      "code" : "9992.009",
      "display" : "Invalids Benefit",
      "definition" : "Invalids Benefit"
    },
    {
      "code" : "9992.010",
      "display" : "Domestic Purposes Benefit Recipient",
      "definition" : "Domestic Purposes Benefit Recipient"
    },
    {
      "code" : "9992.011",
      "display" : "WINZ � Sickness Benefit",
      "definition" : "WINZ � Sickness Benefit"
    },
    {
      "code" : "9992.012",
      "display" : "Community Wage � Sickness Beneficiary",
      "definition" : "Community Wage � Sickness Beneficiary"
    },
    {
      "code" : "9993.001",
      "display" : "Pensioner",
      "definition" : "Pensioner"
    },
    {
      "code" : "9993.002",
      "display" : "Retired",
      "definition" : "Retired"
    },
    {
      "code" : "9993.003",
      "display" : "Superannuitant",
      "definition" : "Superannuitant"
    },
    {
      "code" : "9993.004",
      "display" : "Veterans Pension",
      "definition" : "Veterans Pension"
    },
    {
      "code" : "9993.005",
      "display" : "WINZ Pension",
      "definition" : "WINZ Pension"
    },
    {
      "code" : "9993.006",
      "display" : "55+ Pension",
      "definition" : "55+ Pension"
    },
    {
      "code" : "9993.007",
      "display" : "55 Plus Pension",
      "definition" : "55 Plus Pension"
    },
    {
      "code" : "9993.008",
      "display" : "Semi-Retired",
      "definition" : "Semi-Retired"
    },
    {
      "code" : "9993.009",
      "display" : "Semi Retired",
      "definition" : "Semi Retired"
    },
    {
      "code" : "9994.001",
      "display" : "Student",
      "definition" : "Student"
    },
    {
      "code" : "9994.002",
      "display" : "Studying 20Hrs or More Per Week",
      "definition" : "Studying 20Hrs or More Per Week"
    },
    {
      "code" : "9994.003",
      "display" : "Tertiary Student",
      "definition" : "Tertiary Student"
    },
    {
      "code" : "9994.004",
      "display" : "Tertiary Student and Parent",
      "definition" : "Tertiary Student and Parent"
    },
    {
      "code" : "9994.005",
      "display" : "University Student",
      "definition" : "University Student"
    },
    {
      "code" : "9994.006",
      "display" : "Polytech Student",
      "definition" : "Polytech Student"
    },
    {
      "code" : "9994.007",
      "display" : "Student at Technical Institute",
      "definition" : "Student at Technical Institute"
    },
    {
      "code" : "9994.008",
      "display" : "Part-time Student",
      "definition" : "Part-time Student"
    },
    {
      "code" : "9994.009",
      "display" : "Part Time Student",
      "definition" : "Part Time Student"
    },
    {
      "code" : "9994.010",
      "display" : "Special Education Student",
      "definition" : "Special Education Student"
    },
    {
      "code" : "9994.011",
      "display" : "Student of Work Training Course",
      "definition" : "Student of Work Training Course"
    },
    {
      "code" : "9994.012",
      "display" : "Primary School Student",
      "definition" : "Primary School Student"
    },
    {
      "code" : "9994.013",
      "display" : "Secondary School Student",
      "definition" : "Secondary School Student"
    },
    {
      "code" : "9994.014",
      "display" : "High School Student",
      "definition" : "High School Student"
    },
    {
      "code" : "9996.001",
      "display" : "Unemployed",
      "definition" : "Unemployed"
    },
    {
      "code" : "9996.002",
      "display" : "Looking for employment",
      "definition" : "Looking for employment"
    },
    {
      "code" : "9996.003",
      "display" : "Not in Labour Force",
      "definition" : "Not in Labour Force"
    },
    {
      "code" : "9996.004",
      "display" : "Community Wage � Job Seeker",
      "definition" : "Community Wage � Job Seeker"
    },
    {
      "code" : "9996.005",
      "display" : "Community Wage � Sickness Benefit",
      "definition" : "Community Wage � Sickness Benefit"
    },
    {
      "code" : "9996.006",
      "display" : "Out of the Labour Force",
      "definition" : "Out of the Labour Force"
    },
    {
      "code" : "9996.007",
      "display" : "WINZ � Sickness Benefit",
      "definition" : "WINZ � Sickness Benefit"
    },
    {
      "code" : "9996.008",
      "display" : "Discouraged Worker",
      "definition" : "Discouraged Worker"
    },
    {
      "code" : "9996.009",
      "display" : "Volunteer Worker",
      "definition" : "Volunteer Worker"
    },
    {
      "code" : "9996.010",
      "display" : "Charity Worker",
      "definition" : "Charity Worker"
    },
    {
      "code" : "9997.001",
      "display" : "Child",
      "definition" : "Child"
    },
    {
      "code" : "9997.002",
      "display" : "Infant",
      "definition" : "Infant"
    },
    {
      "code" : "9997.003",
      "display" : "School Child",
      "definition" : "School Child"
    },
    {
      "code" : "9997.004",
      "display" : "Preschool Child",
      "definition" : "Preschool Child"
    },
    {
      "code" : "9997.005",
      "display" : "Pre-school Child",
      "definition" : "Pre-school Child"
    },
    {
      "code" : "9997.006",
      "display" : "Baby",
      "definition" : "Baby"
    },
    {
      "code" : "9997.007",
      "display" : "Primary School Child",
      "definition" : "Primary School Child"
    },
    {
      "code" : "9997.008",
      "display" : "High School Child",
      "definition" : "High School Child"
    },
    {
      "code" : "9997.009",
      "display" : "Kindergarten Child",
      "definition" : "Kindergarten Child"
    },
    {
      "code" : "9997.010",
      "display" : "Secondary School Child",
      "definition" : "Secondary School Child"
    },
    {
      "code" : "9997.011",
      "display" : "Special Education Child",
      "definition" : "Special Education Child"
    },
    {
      "code" : "9997.012",
      "display" : "Primary School Student",
      "definition" : "Primary School Student"
    },
    {
      "code" : "9997.013",
      "display" : "Secondary School Student",
      "definition" : "Secondary School Student"
    },
    {
      "code" : "9997.014",
      "display" : "High School Student",
      "definition" : "High School Student"
    },
    {
      "code" : "9997.015",
      "display" : "College Student",
      "definition" : "College Student"
    },
    {
      "code" : "9999.001",
      "display" : "Not Applicable",
      "definition" : "Not Applicable"
    },
    {
      "code" : "9999.002",
      "display" : "N/A",
      "definition" : "N/A"
    },
    {
      "code" : "9999.003",
      "display" : "Work Status Unidentifiable",
      "definition" : "Work Status Unidentifiable"
    },
    {
      "code" : "9999.004",
      "display" : "No Details Recorded",
      "definition" : "No Details Recorded"
    }
  ]
}

```
