# de.fhir.medication#1.0.3: Medication IG DE

## Pages

* [FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen](index.md)
* [Schema für Kombinationen von Wochentagen](schema-wochentag-kombination.md)
* [Dosis Textgenerierung](dosierung-textgenerierung.md)
* [Fachliche Rahmenvorgaben für Dosierungen](dosierung-rahmenvorgaben.md)
* [Fachliche Rahmenvorgaben des dgMP](dosierung-dgmp.md)
* [Bereitstellung des Dosierungstextes](dosierung-text-hinzufuegen.md)
* [Schema für Kombinationen von Zeitintervallen](schema-intervall-kombination.md)
* [Schema für wiederkehrende Intervalle](schema-intervall.md)
* [FHIR Dosierungen für den digital gestützten Medikationsprozess](dosierung-einfuehrung.md)
* [Übersicht der Timing & Dosierungs-Invarianten](dosierung-constraints.md)
* [Downloads](downloads.md)
* [Schema mit Tageszeiten-Bezug](schema-tageszeit.md)
* [Freitext-Dosierung](schema-freitext.md)
* [Schema mit Wochentags-Bezug](schema-wochentag.md)
* [Schema mit Uhrzeiten-Bezug](schema-uhrzeit.md)
* [FHIR Summary](artifacts.md)
* [Beispielliste Dosierung](dosierung-beispiele.md)

## Resources

### ValueSets

* [Algorithm Language Codes dgMP ValueSet](ValueSet-AlgorithmLanguageCodesDgMP.md)
* [Dosage DoseQuantity ValueSet](ValueSet-DosageDoseQuantityDE.md)
* [Duration UnitsOfTime dgMP ValueSet](ValueSet-DosageUnitsOfTimeDgMP.md)
* [EDQM Unit of Presentation ValueSet](ValueSet-EDQMUnitOfPresentation.md)
* [Period UnitsOfTime dgMP ValueSet](ValueSet-PeriodUnitsOfTimeDgMP.md)
* [Timing When dgMP](ValueSet-TimingWhenDgMP.md)

### Complex-type Profiles

* [Dosage DE](StructureDefinition-DosageDE.md)
* [Dosage dgMP](StructureDefinition-DosageDgMP.md)
* [Timing DE](StructureDefinition-TimingDE.md)
* [Timing dgMP](StructureDefinition-TimingDgMP.md)

### Resource Profiles

* [Medication Dispense dgMP](StructureDefinition-MedicationDispenseDgMP.md)
* [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md)
* [Medication Statement dgMP](StructureDefinition-MedicationStatementDgMP.md)

### Extensions

* [Generated Dosage Instructions Meta](StructureDefinition-GeneratedDosageInstructionsMeta.md)

### ImplementationGuides

* [Medication IG DE](index.md)

### Examples

* [MD-Dosage-1020 (MedicationDispense)](MedicationDispense-MD-Dosage-1020.md)
* [MD-Dosage-Bounds-Decimals (MedicationDispense)](MedicationDispense-MD-Dosage-Bounds-Decimals.md)
* [MD-Dosage-DayOfWeek-Time (MedicationDispense)](MedicationDispense-MD-Dosage-DayOfWeek-Time.md)
* [MD-Dosage-Freetext (MedicationDispense)](MedicationDispense-MD-Dosage-Freetext.md)
* [MD-Dosage-Interval-Time (MedicationDispense)](MedicationDispense-MD-Dosage-Interval-Time.md)
* [Invalid-Dosage-C-DosageStructuredRequiresGeneratedText-01-of-01 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresGeneratedText-01-of-01.md)
* [Example-MR-Bug-EmptyLists (MedicationRequest)](MedicationRequest-Example-MR-Bug-EmptyLists.md)
* [Example-MR-Bug-MultipleTimeOfDay-Daily (MedicationRequest)](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-Daily.md)
* [Example-MR-Bug-MultipleTimeOfDay-DayOfWeek (MedicationRequest)](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-DayOfWeek.md)
* [Example-MR-Bug-MultipleTimeOfDay-Interval (MedicationRequest)](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-Interval.md)
* [Example-MR-Bug-MultipleWhen-DayOfWeek (MedicationRequest)](MedicationRequest-Example-MR-Bug-MultipleWhen-DayOfWeek.md)
* [Example-MR-Bug-MultipleWhen-Interval (MedicationRequest)](MedicationRequest-Example-MR-Bug-MultipleWhen-Interval.md)
* [Example-MR-Dosage-1000 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-1000.md)
* [Example-MR-Dosage-1010-10-Days (MedicationRequest)](MedicationRequest-Example-MR-Dosage-1010-10-Days.md)
* [Example-MR-Dosage-1010-Unsorted (MedicationRequest)](MedicationRequest-Example-MR-Dosage-1010-Unsorted.md)
* [Example-MR-Dosage-1010 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-1010.md)
* [Example-MR-Dosage-10120 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-10120.md)
* [Example-MR-Dosage-1020-Unordered (MedicationRequest)](MedicationRequest-Example-MR-Dosage-1020-Unordered.md)
* [Example-MR-Dosage-1020 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-1020.md)
* [Example-MR-Dosage-1111 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-1111.md)
* [Example-MR-Dosage-1220 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-1220.md)
* [Example-MR-Dosage-Freetext (MedicationRequest)](MedicationRequest-Example-MR-Dosage-Freetext.md)
* [Example-MR-Dosage-UnitStueck-1020 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-UnitStueck-1020.md)
* [Example-MR-Dosage-UnitTasse-1000 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-UnitTasse-1000.md)
* [Example-MR-Dosage-comb-dayofweek-1 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-comb-dayofweek-1.md)
* [Example-MR-Dosage-comb-dayofweek-2 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-comb-dayofweek-2.md)
* [Example-MR-Dosage-comb-dayofweek-3 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-comb-dayofweek-3.md)
* [Example-MR-Dosage-comb-dayofweek-unsorted (MedicationRequest)](MedicationRequest-Example-MR-Dosage-comb-dayofweek-unsorted.md)
* [Example-MR-Dosage-comb-interval-1 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-comb-interval-1.md)
* [Example-MR-Dosage-comb-interval-2 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-comb-interval-2.md)
* [Example-MR-Dosage-comb-interval-3 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-comb-interval-3.md)
* [Example-MR-Dosage-comb-interval-4 (MedicationRequest)](MedicationRequest-Example-MR-Dosage-comb-interval-4.md)
* [Example-MR-Dosage-interval-2d-bound (MedicationRequest)](MedicationRequest-Example-MR-Dosage-interval-2d-bound.md)
* [Example-MR-Dosage-interval-2wk (MedicationRequest)](MedicationRequest-Example-MR-Dosage-interval-2wk.md)
* [Example-MR-Dosage-interval-3d (MedicationRequest)](MedicationRequest-Example-MR-Dosage-interval-3d.md)
* [Example-MR-Dosage-interval-4times-d (MedicationRequest)](MedicationRequest-Example-MR-Dosage-interval-4times-d.md)
* [Example-MR-Dosage-interval-8d (MedicationRequest)](MedicationRequest-Example-MR-Dosage-interval-8d.md)
* [Example-MR-Dosage-tod-1t-8am (MedicationRequest)](MedicationRequest-Example-MR-Dosage-tod-1t-8am.md)
* [Example-MR-Dosage-tod-2-12am (MedicationRequest)](MedicationRequest-Example-MR-Dosage-tod-2-12am.md)
* [Example-MR-Dosage-tod-multi-bound (MedicationRequest)](MedicationRequest-Example-MR-Dosage-tod-multi-bound.md)
* [Example-MR-Dosage-tod-multi (MedicationRequest)](MedicationRequest-Example-MR-Dosage-tod-multi.md)
* [Example-MR-Dosage-tod-unsorted (MedicationRequest)](MedicationRequest-Example-MR-Dosage-tod-unsorted.md)
* [Example-MR-Dosage-weekday-2t-1t (MedicationRequest)](MedicationRequest-Example-MR-Dosage-weekday-2t-1t.md)
* [Example-MR-Dosage-weekday-2t-bound (MedicationRequest)](MedicationRequest-Example-MR-Dosage-weekday-2t-bound.md)
* [Example-MR-Dosage-weekday-2t (MedicationRequest)](MedicationRequest-Example-MR-Dosage-weekday-2t.md)
* [Example-MR-Dosage-weekday-3t (MedicationRequest)](MedicationRequest-Example-MR-Dosage-weekday-3t.md)
* [Example-MR-Dosage-weekday-unsorted (MedicationRequest)](MedicationRequest-Example-MR-Dosage-weekday-unsorted.md)
* [Example-MR-DosageTr-1000 (MedicationRequest)](MedicationRequest-Example-MR-DosageTr-1000.md)
* [Invalid-C-TimingOnlyOneType-01-of-08 (MedicationRequest)](MedicationRequest-Invalid-C-TimingOnlyOneType-01-of-08.md)
* [Invalid-C-TimingOnlyOneType-02-of-08 (MedicationRequest)](MedicationRequest-Invalid-C-TimingOnlyOneType-02-of-08.md)
* [Invalid-C-TimingOnlyOneType-03-of-08 (MedicationRequest)](MedicationRequest-Invalid-C-TimingOnlyOneType-03-of-08.md)
* [Invalid-C-TimingOnlyOneType-04-of-08 (MedicationRequest)](MedicationRequest-Invalid-C-TimingOnlyOneType-04-of-08.md)
* [Invalid-C-TimingOnlyOneType-05-of-08 (MedicationRequest)](MedicationRequest-Invalid-C-TimingOnlyOneType-05-of-08.md)
* [Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01 (MedicationRequest)](MedicationRequest-Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01.md)
* [Invalid-Dosage-01-of-12-FreqPeriod-When (MedicationRequest)](MedicationRequest-Invalid-Dosage-01-of-12-FreqPeriod-When.md)
* [Invalid-Dosage-02-of-12-FreqPeriod-ToD-DayOfWeek (MedicationRequest)](MedicationRequest-Invalid-Dosage-02-of-12-FreqPeriod-ToD-DayOfWeek.md)
* [Invalid-Dosage-03-of-12-FreqPeriod-When-DayOfWeek (MedicationRequest)](MedicationRequest-Invalid-Dosage-03-of-12-FreqPeriod-When-DayOfWeek.md)
* [Invalid-Dosage-04-of-12-FreeText-and-structured (MedicationRequest)](MedicationRequest-Invalid-Dosage-04-of-12-FreeText-and-structured.md)
* [Invalid-Dosage-05-of-12-multiple-types (MedicationRequest)](MedicationRequest-Invalid-Dosage-05-of-12-multiple-types.md)
* [Invalid-Dosage-06-of-12-multiple-dosagecodes (MedicationRequest)](MedicationRequest-Invalid-Dosage-06-of-12-multiple-dosagecodes.md)
* [Invalid-Dosage-07-of-12-timing-no-dose (MedicationRequest)](MedicationRequest-Invalid-Dosage-07-of-12-timing-no-dose.md)
* [Invalid-Dosage-09-of-12-C-TimingOnlyOneTimeForInterval (MedicationRequest)](MedicationRequest-Invalid-Dosage-09-of-12-C-TimingOnlyOneTimeForInterval.md)
* [Invalid-Dosage-10-of-12-When-DiffPeriodU (MedicationRequest)](MedicationRequest-Invalid-Dosage-10-of-12-When-DiffPeriodU.md)
* [Invalid-Dosage-11-of-12-C-TimingOnlyOneWhen (MedicationRequest)](MedicationRequest-Invalid-Dosage-11-of-12-C-TimingOnlyOneWhen.md)
* [Invalid-Dosage-12-of-12-C-TimingOnlyOneDayOfWeek (MedicationRequest)](MedicationRequest-Invalid-Dosage-12-of-12-C-TimingOnlyOneDayOfWeek.md)
* [Invalid-Dosage-C-DosageDoseUnitSameCode-01-of-01 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-DosageDoseUnitSameCode-01-of-01.md)
* [Invalid-Dosage-C-DosageStructuredOrFreeText-01-of-02 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-DosageStructuredOrFreeText-01-of-02.md)
* [Invalid-Dosage-C-DosageStructuredOrFreeText-02-of-02 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-DosageStructuredOrFreeText-02-of-02.md)
* [Invalid-Dosage-C-DosageStructuredRequiresBoth-01-of-02 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresBoth-01-of-02.md)
* [Invalid-Dosage-C-DosageStructuredRequiresBoth-02-of-02 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresBoth-02-of-02.md)
* [Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01.md)
* [Invalid-Dosage-C-FreeTextSingleDosageOnly-01-of-01 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-FreeTextSingleDosageOnly-01-of-01.md)
* [Invalid-Dosage-C-TimingBoundsUnitMatchesCode-01-of-01 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingBoundsUnitMatchesCode-01-of-01.md)
* [Invalid-Dosage-C-TimingFrequencyCount-01-of-05 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-01-of-05.md)
* [Invalid-Dosage-C-TimingFrequencyCount-02-of-05 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-02-of-05.md)
* [Invalid-Dosage-C-TimingFrequencyCount-03-of-05 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-03-of-05.md)
* [Invalid-Dosage-C-TimingFrequencyCount-04-of-05 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-04-of-05.md)
* [Invalid-Dosage-C-TimingFrequencyCount-05-of-05 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-05-of-05.md)
* [Invalid-Dosage-C-TimingPeriodUnit-01-of-05 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-01-of-05.md)
* [Invalid-Dosage-C-TimingPeriodUnit-02-of-05 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-02-of-05.md)
* [Invalid-Dosage-C-TimingPeriodUnit-03-of-05 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-03-of-05.md)
* [Invalid-Dosage-C-TimingPeriodUnit-04-of-05 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-04-of-05.md)
* [Invalid-Dosage-C-TimingPeriodUnit-05-of-05 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-05-of-05.md)
* [Invalid-Dosage-C-TimingSingleDosageForTimeOfDay-01-of-01 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingSingleDosageForTimeOfDay-01-of-01.md)
* [Invalid-Dosage-C-TimingSingleDosageForWhen-01-of-01 (MedicationRequest)](MedicationRequest-Invalid-Dosage-C-TimingSingleDosageForWhen-01-of-01.md)
* [Invalid-multiple-01-of-10-when (MedicationRequest)](MedicationRequest-Invalid-multiple-01-of-10-when.md)
* [Invalid-multiple-02-of-10-C-TimingOnlyOneTimeOfDay (MedicationRequest)](MedicationRequest-Invalid-multiple-02-of-10-C-TimingOnlyOneTimeOfDay.md)
* [Invalid-multiple-04-of-10-C-TimingOnlyOnePeriodForDayOfWeek (MedicationRequest)](MedicationRequest-Invalid-multiple-04-of-10-C-TimingOnlyOnePeriodForDayOfWeek.md)
* [Invalid-multiple-05-of-10-C-TimingOnlyOnePeriodForDayOfWeek (MedicationRequest)](MedicationRequest-Invalid-multiple-05-of-10-C-TimingOnlyOnePeriodForDayOfWeek.md)
* [Invalid-multiple-06-of-10-C-TimingIntervalOnlyOneFrequency (MedicationRequest)](MedicationRequest-Invalid-multiple-06-of-10-C-TimingIntervalOnlyOneFrequency.md)
* [Invalid-multiple-07-of-10-C-TimingOnlyOneWhen (MedicationRequest)](MedicationRequest-Invalid-multiple-07-of-10-C-TimingOnlyOneWhen.md)
* [Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay (MedicationRequest)](MedicationRequest-Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay.md)
* [Invalid-multiple-09-of-10-C-TimingOnlyOneTimeForInterval (MedicationRequest)](MedicationRequest-Invalid-multiple-09-of-10-C-TimingOnlyOneTimeForInterval.md)
* [Invalid-multiple-10-of-10-C-TimingOnlyOneBounds (MedicationRequest)](MedicationRequest-Invalid-multiple-10-of-10-C-TimingOnlyOneBounds.md)
* [MR-Dosage-4schema-evening-only (MedicationRequest)](MedicationRequest-MR-Dosage-4schema-evening-only.md)
* [MR-Dosage-4schema-ml-units (MedicationRequest)](MedicationRequest-MR-Dosage-4schema-ml-units.md)
* [MR-Dosage-4schema-night-only (MedicationRequest)](MedicationRequest-MR-Dosage-4schema-night-only.md)
* [MR-Dosage-4schema-noon-only (MedicationRequest)](MedicationRequest-MR-Dosage-4schema-noon-only.md)
* [MR-Dosage-freetext-german-chars (MedicationRequest)](MedicationRequest-MR-Dosage-freetext-german-chars.md)
* [MR-Dosage-interval-monthly (MedicationRequest)](MedicationRequest-MR-Dosage-interval-monthly.md)
* [MR-Dosage-interval-when-3d (MedicationRequest)](MedicationRequest-MR-Dosage-interval-when-3d.md)
* [MR-Dosage-multiple-day-time (MedicationRequest)](MedicationRequest-MR-Dosage-multiple-day-time.md)
* [MR-Dosage-single-day-time (MedicationRequest)](MedicationRequest-MR-Dosage-single-day-time.md)
* [MR-Dosage-tod-mixed-doses (MedicationRequest)](MedicationRequest-MR-Dosage-tod-mixed-doses.md)
* [MR-Dosage-weekday-mixed-doses (MedicationRequest)](MedicationRequest-MR-Dosage-weekday-mixed-doses.md)
* [MR-Unsupported-Dosage-01-of-20-Count (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-01-of-20-Count.md)
* [MR-Unsupported-Dosage-02-of-20-asNeededBoolean (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-02-of-20-asNeededBoolean.md)
* [MR-Unsupported-Dosage-03-of-20-asNeededCodeableConcept (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-03-of-20-asNeededCodeableConcept.md)
* [MR-Unsupported-Dosage-04-of-20-Method (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-04-of-20-Method.md)
* [MR-Unsupported-Dosage-05-of-20-Route (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-05-of-20-Route.md)
* [MR-Unsupported-Dosage-06-of-20-Site (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-06-of-20-Site.md)
* [MR-Unsupported-Dosage-07-of-20-DoseRange (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-07-of-20-DoseRange.md)
* [MR-Unsupported-Dosage-08-of-20-RateQuantity (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-08-of-20-RateQuantity.md)
* [MR-Unsupported-Dosage-09-of-20-RateRange (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-09-of-20-RateRange.md)
* [MR-Unsupported-Dosage-10-of-20-RateRatio (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-10-of-20-RateRatio.md)
* [MR-Unsupported-Dosage-11-of-20-AdditionalInstruction (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-11-of-20-AdditionalInstruction.md)
* [MR-Unsupported-Dosage-12-of-20-MaxDosePerPeriod (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-12-of-20-MaxDosePerPeriod.md)
* [MR-Unsupported-Dosage-13-of-20-MaxDosePerAdministration (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-13-of-20-MaxDosePerAdministration.md)
* [MR-Unsupported-Dosage-14-of-20-MaxDosePerLifetime (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-14-of-20-MaxDosePerLifetime.md)
* [MR-Unsupported-Dosage-15-of-20-Count (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-15-of-20-Count.md)
* [MR-Unsupported-Dosage-16-of-20-CountMax (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-16-of-20-CountMax.md)
* [MR-Unsupported-Dosage-17-of-20-BoundsPeriod (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-17-of-20-BoundsPeriod.md)
* [MR-Unsupported-Dosage-18-of-20-BoundsRange (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-18-of-20-BoundsRange.md)
* [MR-Unsupported-Dosage-19-of-20-Offset (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-19-of-20-Offset.md)
* [MR-Unsupported-Dosage-20-of-20-Event (MedicationRequest)](MedicationRequest-MR-Unsupported-Dosage-20-of-20-Event.md)
* [Warning-Dosage-Viererschema-Text-01 (MedicationRequest)](MedicationRequest-Warning-Dosage-Viererschema-Text-01.md)
* [Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01 (MedicationRequest)](MedicationRequest-Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01.md)
* [Warning-Dosage-W-DosageWarnungViererschemaInText-01-of-01 (MedicationRequest)](MedicationRequest-Warning-Dosage-W-DosageWarnungViererschemaInText-01-of-01.md)
* [MS-Dosage-1010 (MedicationStatement)](MedicationStatement-MS-Dosage-1010.md)
* [MS-Dosage-DayOfWeek (MedicationStatement)](MedicationStatement-MS-Dosage-DayOfWeek.md)
* [MS-Dosage-Freetext (MedicationStatement)](MedicationStatement-MS-Dosage-Freetext.md)
* [MS-Dosage-Interval (MedicationStatement)](MedicationStatement-MS-Dosage-Interval.md)
* [MS-Dosage-TimeOfDay (MedicationStatement)](MedicationStatement-MS-Dosage-TimeOfDay.md)
