# Dosage DoseQuantity ValueSet - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Dosage DoseQuantity ValueSet**

## ValueSet: Dosage DoseQuantity ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/ValueSet/DosageDoseQuantityDE | *Version*:1.0.3 |
| Active as of 2025-11-19 | *Computable Name*:DosageDoseQuantityDEVS |

 
Diese ValueSet enthält Konzepte für die Dosierungseinheit in der Dosiermenge. 

 **References** 

* [Dosage DE](StructureDefinition-DosageDE.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Include all codes defined in `https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT`version Not Stated (use latest from terminology server)
* Include all codes defined in [`http://unitsofmeasure.org`](http://unitsofmeasure.org)version Not Stated (use latest from terminology server)
* Import all the codes that are contained in [EDQM Unit of Presentation ValueSet](ValueSet-EDQMUnitOfPresentation.md)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "DosageDoseQuantityDE",
  "url" : "http://ig.fhir.de/igs/medication/ValueSet/DosageDoseQuantityDE",
  "version" : "1.0.3",
  "name" : "DosageDoseQuantityDEVS",
  "title" : "Dosage DoseQuantity ValueSet",
  "status" : "active",
  "date" : "2025-11-19T15:42:47+00:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Diese ValueSet enthält Konzepte für die Dosierungseinheit in der Dosiermenge.",
  "compose" : {
    "include" : [
      {
        "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT"
      },
      {
        "system" : "http://unitsofmeasure.org"
      },
      {
        "valueSet" : [
          "http://ig.fhir.de/igs/medication/ValueSet/EDQMUnitOfPresentation"
        ]
      }
    ]
  }
}

```
