# Timing DE - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Timing DE**

## Data Type Profile: Timing DE 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/StructureDefinition/TimingDE | *Version*:1.0.3 |
| Active as of 2025-11-19 | *Computable Name*:TimingDE |

 
Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden. 

## Hinweise zur Verwendung

 **Invariante: tim-9**
 Die Invariante `tim-9` enthält einen [bekannten Fehler](https://jira.hl7.org/browse/FHIR-37729). Dieser wurde in einigen Validatoren bereits behoben. Sollte ein Validator ohne den entsprechenden Fix verwendet werden, ist die tim-9-Definition aus FHIR R5 zu verwenden:
 `offset.empty() or (when.exists() and when.select($this in ('C' | 'CM' | 'CD' | 'CV')).allFalse())`
 Siehe auch die entsprechende Beschreibung in [FHIR R5 (Timing)](https://hl7.org/fhir/datatypes.html#timing). 

**Usages:**

* Derived from this DataType Profile: [Timing dgMP](StructureDefinition-TimingDgMP.md)
* Use this DataType Profile: [Dosage DE](StructureDefinition-DosageDE.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.fhir.medication|current/StructureDefinition/TimingDE)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TimingDE.csv), [Excel](StructureDefinition-TimingDE.xlsx), [Schematron](StructureDefinition-TimingDE.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TimingDE",
  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDE",
  "version" : "1.0.3",
  "name" : "TimingDE",
  "title" : "Timing DE",
  "status" : "active",
  "date" : "2025-11-19T15:42:47+00:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Timing",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Timing",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Timing.repeat",
        "path" : "Timing.repeat",
        "short" : "Wann das Ereignis stattfinden soll",
        "definition" : "Eine Menge von Regeln, die beschreiben, wann das Ereignis geplant ist.",
        "constraint" : [
          {
            "key" : "TimingSingleDosageForTimeOfDay",
            "severity" : "error",
            "human" : "Wenn nur timeOfDay verwendet wird und täglich dosiert wird, ist die Angabe in einem einzigen Dosage-Element zu modellieren. Mehrere Dosage-Elemente sind nur zulässig, wenn sich die Dosis (Wert) unterscheidet.",
            "expression" : "(\n  %resource.ofType(MedicationRequest).dosageInstruction\n  | %resource.ofType(MedicationDispense).dosageInstruction\n  | %resource.ofType(MedicationStatement).dosage\n).all(\n  (\n    timing.repeat.dayOfWeek.empty() and\n    timing.repeat.timeOfDay.exists() and\n    timing.repeat.when.empty() and\n    (timing.repeat.period.exists() and timing.repeat.period = 1) and\n    (timing.repeat.periodUnit.exists() and timing.repeat.periodUnit = 'd')\n  )\n  implies\n  (\n    (\n      (\n        %resource.ofType(MedicationRequest).dosageInstruction\n        | %resource.ofType(MedicationDispense).dosageInstruction\n        | %resource.ofType(MedicationStatement).dosage\n      ).where(\n        timing.repeat.dayOfWeek.empty() and timing.repeat.timeOfDay.exists() and timing.repeat.when.empty() and (timing.repeat.period.exists() and timing.repeat.period = 1) and (timing.repeat.periodUnit.exists() and timing.repeat.periodUnit = 'd')\n      ).count() = 1\n    )\n    or\n    (\n      (\n        %resource.ofType(MedicationRequest).dosageInstruction\n        | %resource.ofType(MedicationDispense).dosageInstruction\n        | %resource.ofType(MedicationStatement).dosage\n      ).where(\n        timing.repeat.dayOfWeek.empty() and timing.repeat.timeOfDay.exists() and timing.repeat.when.empty() and (timing.repeat.period.exists() and timing.repeat.period = 1) and (timing.repeat.periodUnit.exists() and timing.repeat.periodUnit = 'd')\n      ).doseAndRate.dose.ofType(Quantity).value.distinct().count() > 1\n    )\n  )\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDE"
          },
          {
            "key" : "TimingSingleDosageForWhen",
            "severity" : "error",
            "human" : "Wenn nur when verwendet wird und täglich dosiert wird, ist die Angabe in einem einzigen Dosage-Element zu modellieren. Mehrere Dosage-Elemente sind nur zulässig, wenn sich die Dosis (Wert) unterscheidet.",
            "expression" : "(\n  %resource.ofType(MedicationRequest).dosageInstruction\n  | %resource.ofType(MedicationDispense).dosageInstruction\n  | %resource.ofType(MedicationStatement).dosage\n).all(\n  (\n    timing.repeat.dayOfWeek.empty() and\n    timing.repeat.when.exists() and\n    timing.repeat.timeOfDay.empty() and\n    (timing.repeat.period.exists() and timing.repeat.period = 1) and\n    (timing.repeat.periodUnit.exists() and timing.repeat.periodUnit = 'd')\n  )\n  implies\n  (\n    (\n      (\n        %resource.ofType(MedicationRequest).dosageInstruction\n        | %resource.ofType(MedicationDispense).dosageInstruction\n        | %resource.ofType(MedicationStatement).dosage\n      ).where(\n        timing.repeat.dayOfWeek.empty() and timing.repeat.when.exists() and timing.repeat.timeOfDay.empty() and (timing.repeat.period.exists() and timing.repeat.period = 1) and (timing.repeat.periodUnit.exists() and timing.repeat.periodUnit = 'd')\n      ).count() = 1\n    )\n    or\n    (\n      (\n        %resource.ofType(MedicationRequest).dosageInstruction\n        | %resource.ofType(MedicationDispense).dosageInstruction\n        | %resource.ofType(MedicationStatement).dosage\n      ).where(\n        timing.repeat.dayOfWeek.empty() and timing.repeat.when.exists() and timing.repeat.timeOfDay.empty() and (timing.repeat.period.exists() and timing.repeat.period = 1) and (timing.repeat.periodUnit.exists() and timing.repeat.periodUnit = 'd')\n      ).doseAndRate.dose.ofType(Quantity).value.distinct().count() > 1\n    )\n  )\n)\n",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDE"
          },
          {
            "key" : "TimingBoundsUnitMatchesCode",
            "severity" : "error",
            "human" : "boundsDuration.unit muss zur UCUM boundsDuration.code passen (z. B. 'Woche(n)' nur mit code='wk').",
            "expression" : "bounds.ofType(Duration).exists().not() or (\n  (\n    bounds.ofType(Duration).code = 'd'\n    implies \n    (\n      bounds.ofType(Duration).unit = 'Tag(e)' or\n      bounds.ofType(Duration).unit = 'Tag' or\n      bounds.ofType(Duration).unit = 'Tage'\n    )\n  ) and (\n    bounds.ofType(Duration).code = 'wk'\n    implies \n    (\n      bounds.ofType(Duration).unit = 'Woche(n)' or\n      bounds.ofType(Duration).unit = 'Woche' or\n      bounds.ofType(Duration).unit = 'Wochen'\n    )\n  ) and (\n    bounds.ofType(Duration).code = 'mo'\n    implies \n    (\n      bounds.ofType(Duration).unit = 'Monat(e)' or\n      bounds.ofType(Duration).unit = 'Monat' or\n      bounds.ofType(Duration).unit = 'Monate'\n    )\n  ) and (\n    bounds.ofType(Duration).code = 'a'\n    implies \n    (\n      bounds.ofType(Duration).unit = 'Jahr(e)' or\n      bounds.ofType(Duration).unit = 'Jahr' or\n      bounds.ofType(Duration).unit = 'Jahre'\n    )\n  )\n)",
            "source" : "http://ig.fhir.de/igs/medication/StructureDefinition/TimingDE"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.bounds[x]",
        "path" : "Timing.repeat.bounds[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Länge/Bereich der Längen oder (Start- und/oder End-)Grenzen",
        "definition" : "Entweder eine Dauer für die Länge des Zeitplans, ein Bereich möglicher Längen oder äußere Begrenzungen für Start- und/oder Endgrenzen des Zeitplans.",
        "comment" : "tbd",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration",
        "path" : "Timing.repeat.bounds[x]",
        "sliceName" : "boundsDuration",
        "short" : "Dauer der Dosieranweisung ausgedrückt in UCUM-Einheiten",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Duration"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration.value",
        "path" : "Timing.repeat.bounds[x].value",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration.unit",
        "path" : "Timing.repeat.bounds[x].unit",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration.system",
        "path" : "Timing.repeat.bounds[x].system",
        "short" : "UCUM-Einheit für die Dauer",
        "comment" : "Die UCUM-Einheit für die Dauer, z. B. d für Tag, h für Stunde, min für Minute.",
        "fixedUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.bounds[x]:boundsDuration.code",
        "path" : "Timing.repeat.bounds[x].code",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.frequency",
        "path" : "Timing.repeat.frequency",
        "short" : "Ereignis tritt frequency-mal pro Zeitraum auf",
        "definition" : "Die Anzahl der Wiederholungen innerhalb des angegebenen Zeitraums. Falls frequencyMax vorhanden ist, gibt dieses Element die Untergrenze des zulässigen Bereichs der Häufigkeit an.",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.period",
        "path" : "Timing.repeat.period",
        "short" : "Ereignis tritt frequency-mal pro Zeitraum auf",
        "definition" : "Gibt die Zeitspanne an, über die die Wiederholungen stattfinden sollen; z. B. um „3-mal täglich“ auszudrücken, wäre 3 die Häufigkeit und „1 Tag“ der Zeitraum. Falls periodMax vorhanden ist, gibt dieses Element die Untergrenze des zulässigen Bereichs der Zeitspanne an.",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.periodUnit",
        "path" : "Timing.repeat.periodUnit",
        "short" : "s | min | h | d | wk | mo | a - Zeiteinheit (UCUM)",
        "definition" : "Die Zeiteinheit für den Zeitraum, in UCUM-Einheiten.",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.dayOfWeek",
        "path" : "Timing.repeat.dayOfWeek",
        "definition" : "Wenn ein oder mehrere Wochentage angegeben sind, findet die Aktion nur an den angegebenen Tagen statt.",
        "comment" : "Wenn keine Tage angegeben sind, wird angenommen, dass die Aktion an jedem Tag wie sonst angegeben stattfindet.",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.timeOfDay",
        "path" : "Timing.repeat.timeOfDay",
        "short" : "Tageszeit für die Aktion",
        "definition" : "Angegebene Tageszeit, zu der die Aktion stattfinden soll.",
        "comment" : "Wenn eine Tageszeit angegeben ist, wird angenommen, dass die Aktion jeden Tag (ggf. gefiltert durch dayOfWeek) zu den angegebenen Zeiten stattfindet.",
        "mustSupport" : true
      },
      {
        "id" : "Timing.repeat.when",
        "path" : "Timing.repeat.when",
        "short" : "Code für den Zeitraum des Auftretens",
        "definition" : "Ein ungefährer Zeitraum während des Tages, der möglicherweise mit einem Ereignis des täglichen Lebens verknüpft ist und angibt, wann die Aktion stattfinden soll.",
        "comment" : "Wenn mehr als ein Ereignis angegeben ist, bezieht sich das Ereignis auf die Vereinigung der angegebenen Ereignisse.",
        "mustSupport" : true
      }
    ]
  }
}

```
