# Generated Dosage Instructions Meta - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Generated Dosage Instructions Meta**

## Extension: Generated Dosage Instructions Meta 

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta | *Version*:1.0.3 |
| Active as of 2025-11-19 | *Computable Name*:GeneratedDosageInstructionsMetaEx |

Diese Extension enthält die Metainformationen zur generierten textuellen Dosierungsanweisung, die auf Basis der bereitgestellten strukturierten Dosierungsinformationen erstellt wurde.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [Medication Dispense dgMP](StructureDefinition-MedicationDispenseDgMP.md), [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md) and [Medication Statement dgMP](StructureDefinition-MedicationStatementDgMP.md)
* Examples for this Extension: [MedicationRequest/Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01](MedicationRequest-Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/de.fhir.medication|current/StructureDefinition/GeneratedDosageInstructionsMeta)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-GeneratedDosageInstructionsMeta.csv), [Excel](StructureDefinition-GeneratedDosageInstructionsMeta.xlsx), [Schematron](StructureDefinition-GeneratedDosageInstructionsMeta.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "GeneratedDosageInstructionsMeta",
  "url" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta",
  "version" : "1.0.3",
  "name" : "GeneratedDosageInstructionsMetaEx",
  "title" : "Generated Dosage Instructions Meta",
  "status" : "active",
  "date" : "2025-11-19T15:42:47+00:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "description" : "Diese Extension enthält die Metainformationen zur generierten textuellen Dosierungsanweisung, die auf Basis der bereitgestellten strukturierten Dosierungsinformationen erstellt wurde.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    },
    {
      "type" : "element",
      "expression" : "MedicationDispense"
    },
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Generated Dosage Instructions Meta",
        "definition" : "Diese Extension enthält die Metainformationen zur generierten textuellen Dosierungsanweisung, die auf Basis der bereitgestellten strukturierten Dosierungsinformationen erstellt wurde."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 2
      },
      {
        "id" : "Extension.extension:language",
        "path" : "Extension.extension",
        "sliceName" : "language",
        "short" : "Sprache der generierten Dosierungsanweisung",
        "comment" : "Zur Auswahl der deutschen Sprache sollte der Code 'de-DE' verwendet werden",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:language.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:language.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "language"
      },
      {
        "id" : "Extension.extension:language.value[x]",
        "path" : "Extension.extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Extension.extension:language.value[x]:valueCode",
        "path" : "Extension.extension.value[x]",
        "sliceName" : "valueCode",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/all-languages"
        }
      },
      {
        "id" : "Extension.extension:algorithmVersion",
        "path" : "Extension.extension",
        "sliceName" : "algorithmVersion",
        "short" : "Version des Algorithmus zur Generierung der Dosierungsanweisung (Version der zugrundeliegenden Python Referenzimplementierung)",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Extension.extension:algorithmVersion.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:algorithmVersion.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "algorithmVersion"
      },
      {
        "id" : "Extension.extension:algorithmVersion.value[x]",
        "path" : "Extension.extension.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Extension.extension:algorithmVersion.value[x]:valueString",
        "path" : "Extension.extension.value[x]",
        "sliceName" : "valueString",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://ig.fhir.de/igs/medication/StructureDefinition/GeneratedDosageInstructionsMeta"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
