# MedicationStatement Dosage Example - TimeOfDay - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **MedicationStatement Dosage Example - TimeOfDay**

## Example MedicationStatement: MedicationStatement Dosage Example - TimeOfDay

Profile: [Medication Statement dgMP](StructureDefinition-MedicationStatementDgMP.md)

**status**: Active

**medication**: Test Medication

**subject**: Patient

> **dosage****timing**: Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 2 Stück(Details: UCUM code1 = '1') |


> **dosage****timing**: Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: UCUM code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "MS-Dosage-TimeOfDay",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
    ]
  },
  "status" : "active",
  "medicationCodeableConcept" : {
    "text" : "Test Medication"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["08:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 2,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    },
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["20:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
