# MedicationRequest Dosage Example - Multiple Days with TimeOfDay - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **MedicationRequest Dosage Example - Multiple Days with TimeOfDay**

## Example MedicationRequest: MedicationRequest Dosage Example - Multiple Days with TimeOfDay

Profile: [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md)

**status**: Active

**intent**: Order

**medication**: Test Medication

**subject**: Patient

> **dosageInstruction****timing**: 2 per 1 week

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |


> **dosageInstruction****timing**: 4 per 1 week

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 2 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "MR-Dosage-multiple-day-time",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "medicationCodeableConcept" : {
    "text" : "Test Medication"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "wk",
          "dayOfWeek" : ["tue", "thu"],
          "timeOfDay" : ["08:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    },
    {
      "timing" : {
        "repeat" : {
          "frequency" : 4,
          "period" : 1,
          "periodUnit" : "wk",
          "dayOfWeek" : ["mon", "fri"],
          "timeOfDay" : ["08:00:00", "20:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 2,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
