# Bug Test: Multiple timeOfDay Daily - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Bug Test: Multiple timeOfDay Daily**

## Example MedicationRequest: Bug Test: Multiple timeOfDay Daily

Profile: [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md)

**status**: Active

**intent**: Order

**medication**: Test Medication

**subject**: Patient

> **dosageInstruction****timing**: 3 per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "Example-MR-Bug-MultipleTimeOfDay-Daily",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "medicationCodeableConcept" : {
    "text" : "Test Medication"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 3,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["08:00:00", "14:00:00", "22:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
