# MedicationDispense Dosage Example - DayOfWeek and Time - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **MedicationDispense Dosage Example - DayOfWeek and Time**

## Example MedicationDispense: MedicationDispense Dosage Example - DayOfWeek and Time

Profile: [Medication Dispense dgMP](StructureDefinition-MedicationDispenseDgMP.md)

**status**: Completed

**medication**: Test Medication

**subject**: Patient

> **dosageInstruction****timing**: Morning, Once per 1 week

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: UCUM code1 = '1') |


> **dosageInstruction****timing**: Evening, Once per 1 week

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 2 Stück(Details: UCUM code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "MD-Dosage-DayOfWeek-Time",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
    ]
  },
  "status" : "completed",
  "medicationCodeableConcept" : {
    "text" : "Test Medication"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "wk",
          "dayOfWeek" : ["mon"],
          "when" : ["MORN"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    },
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "wk",
          "dayOfWeek" : ["wed"],
          "when" : ["EVE"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 2,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
