# FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* **FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen**

## FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen

| | |
| :--- | :--- |
| *Official URL*:http://ig.fhir.de/igs/medication/ImplementationGuide/de.fhir.medication | *Version*:1.0.3 |
| Active as of 2025-11-19 | *Computable Name*:MedicationDE |

### Kurzbeschreibung

Dieser Implementation Guide (IG) beschreibt die standardisierte und interoperable Abbildung medikationsbezogener Informationen und Prozesse im deutschen Gesundheitswesen auf Basis von HL7® FHIR®. Ziel ist es, sektorenübergreifende Anwendungsfälle - wie beispielsweise die strukturierte Dosierungsinformation im E-Rezept, den elektronischen Medikationsplan oder den Austausch mittels [ISiK](https://fachportal.gematik.de/informationen-fuer/isik/bestaetigungsverfahren-isik) - zu ermöglichen und zu harmonisieren.

Der IG enthält die Beschreibung der jeweiligen Anwendungsfälle sowie begleitende Dokumentation.

### Aktuelle Anwendungsfälle

Dieser Implementation Guide wird kontinuierlich weiterentwickelt und verbessert. Aktuell werden folgende Anwendungsfälle unterstützt:

* Strukturierte und textuelle Darstellung von [Dosierungen](./dosierung-einfuehrung.md)

### Must Support

Elemente mit der Eigenschaft [mustSupport](https://www.hl7.org/fhir/profiling.html#mustsupport) müssen immer implementiert werden. Hierbei handelt es sich um Elemente, die unabhängig von der Kardinalität (Ausnahme: 0…0) unterstützt werden müssen, sofern die entsprechenden Informationen vorliegen.

Die Software, welche die Dateien erstellt, muss die mit „mustSupport“ gekennzeichneten Elemente (mustSupport value="true") unterstützen - befüllen und übermitteln können.

Die Software, welche die Dateien verarbeitet, muss die mit „mustSupport“ gekennzeichneten Elemente (mustSupport value="true") unterstützen - auslesen und verarbeiten können.

### Zielgruppen

* Softwarehersteller und Systemintegratoren im Gesundheitswesen
* Entwickler:innen von FHIR-basierten Systemen
* Ärzt:innen, Apotheker:innen, Pflegekräfte
* Fachexpert:innen für Interoperabilität und Arzneimitteltherapie

### Mitwirkende Organisationen

Durch Input und Feedback haben folgende Organisationen an der Erstellung dieses Implementation Guides mitgewirkt:

* Bundesvereinigung Deutscher Apothekerverbände
* Deutscher Apothekerverband
* Deutsche Krankenhausgesellschaft
* gematik GmbH
* GKV-Spitzenverband
* HL7 Deutschland
* Kassenärztliche Bundesvereinigung
* Kompetenzzentrum für Interoperabilität im Gesundheitswesen (KIG)
* Verband der Privaten Krankenversicherung

### Abhängigkeiten

Dieser IG verwendet zur Kodierung der doseQuantity [KBV_VS_SFHIR_BMP_DOSIEREINHEIT](https://fhir.kbv.de/ValueSet/KBV_VS_SFHIR_BMP_DOSIEREINHEIT) & [KBV_CS_SFHIR_BMP_DOSIEREINHEIT](https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT) welche bewusst nicht als Abhängigkeit deklariert worden sind.



#### Nutzung von Cross-Version-Extensions

Das dgMP Script schreibt den aggreggierten DosageText für MedicationRequest, MedicationRequest und MedicationStatement nach `.renderedDosageInstruction` - einem R5 Element welches nach R4 ge-backportet wurde. Dies ist ein durch die [FHIR Spezifikation definierter Mechanismus](https://hl7.org/fhir/versions.html#extensions) welcher im [Java FHIR Validator](https://confluence.hl7.org/spaces/FHIR/pages/35718580/Using+the+FHIR+Validator) bereits unterstützt wird. Andere Validatoren müssen ggfs. das passende cross-version-Paket laden.

Das offiziellen cross-version-Paket war zum Releasezeitpunkt dieses IGs noch nicht in der FHIR-Registry final verfügbar, die ID des packages ist `hl7.fhir.uv.xver-r5.r4`. Bis zum offiziellen Release des cross-version-Pakets kann der [Inhalt des Snapshot-2 releases](https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/) verwendet werden.

Im Paket sind die benötigten cross-version Extensions enthalten: [MedicationDispense.renderedDosageInstruction](https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/StructureDefinition-ext-R5-MedicationDispense.renderedDosageInstruction.html) [MedicationRequest.renderedDosageInstruction](https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/StructureDefinition-ext-R5-MedicationRequest.renderedDosageInstruction.html) [MedicationStatement.renderedDosageInstruction](https://hl7.org/fhir/uv/xver-r5.r4/0.0.1-snapshot-2/StructureDefinition-ext-R5-MedicationStatement.renderedDosageInstruction.html)

### Kontakt und Feedback

Für Fragen und Feedback wenden Sie sich bitte an [info@hl7.de](mailto:info@hl7.de) oder nutzen Sie das [GitHub-Repository](https://github.com/hl7germany/medication-ig-de-r4/issues).

### Rechtliche Hinweise

Dieser Implementation Guide wurde in Zusammenarbeit zwischen

* [HL7 Deutschland e.V.](https://hl7.de/)
* [gematik GmbH](https://www.gematik.de/)

erarbeitet.

Copyright © 2025 HL7 Deutschland e.V.

HL7®, HEALTH LEVEL SEVEN®, FHIR® und das FHIR®-Logo sind Marken von Health Level Seven International, eingetragen beim United States Patent and Trademark Office.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "de.fhir.medication",
  "url" : "http://ig.fhir.de/igs/medication/ImplementationGuide/de.fhir.medication",
  "version" : "1.0.3",
  "name" : "MedicationDE",
  "title" : "Medication IG DE",
  "status" : "active",
  "date" : "2025-11-19T15:42:47+00:00",
  "publisher" : "HL7 Deutschland e.V.",
  "contact" : [
    {
      "name" : "HL7 Deutschland e.V.",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://hl7.de"
        }
      ]
    }
  ],
  "packageId" : "de.fhir.medication",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://ig.fhir.de/igs/medication/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://ig.fhir.de/igs/medication/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AlgorithmLanguageCodesDgMP"
        },
        "name" : "Algorithm Language Codes dgMP ValueSet",
        "description" : "Dieses ValueSet enthält die im dgMP unterstützten Sprachen für Algorithmen, die in der Dosierung verwendet werden können.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-EmptyLists"
        },
        "name" : "Bug Test: Empty timeOfDay/when/dayOfWeek lists",
        "description" : "Test case with empty arrays that might cause incorrect schema detection due to non-strict boolean logic.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-Daily"
        },
        "name" : "Bug Test: Multiple timeOfDay Daily",
        "description" : "Test case for TimeOfDay schema with multiple times. Should show all times: 08:00, 14:00, and 22:00.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-DayOfWeek"
        },
        "name" : "Bug Test: Multiple timeOfDay with DayOfWeek",
        "description" : "Test case for multiple timeOfDay entries in DayOfWeek+Time schema. Should show both 09:00 and 21:00 times.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-MultipleTimeOfDay-Interval"
        },
        "name" : "Bug Test: Multiple timeOfDay with Interval",
        "description" : "Test case showing the bug where only first timeOfDay is processed in Interval+Time schema. Should show both 08:00 and 20:00 times.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-MultipleWhen-DayOfWeek"
        },
        "name" : "Bug Test: Multiple when codes with DayOfWeek",
        "description" : "Test case for multiple when codes in DayOfWeek+When schema. Should show both morning and evening patterns.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Bug-MultipleWhen-Interval"
        },
        "name" : "Bug Test: Multiple when codes with Interval",
        "description" : "Test case showing the bug where only first when code is processed in Interval+Time schema. Should show both morning and evening.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DosageDE"
        },
        "name" : "Dosage DE",
        "description" : "Gibt an, wie das Medikament eingenommen oder verabreicht wurde bzw. eingenommen oder verabreicht werden soll - entweder selbst vom Patienten eingenommen oder bei Fremdverabreichung von Dritten (z. B. Leistungserbringer, Angehörige) verabreicht.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DosageDgMP"
        },
        "name" : "Dosage dgMP",
        "description" : "Gibt an, wie das Medikament vom Patienten im Kontext dgMP eingenommen wird/wurde oder eingenommen werden soll.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/DosageDoseQuantityDE"
        },
        "name" : "Dosage DoseQuantity ValueSet",
        "description" : "Diese ValueSet enthält Konzepte für die Dosierungseinheit in der Dosiermenge.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/DosageUnitsOfTimeDgMP"
        },
        "name" : "Duration UnitsOfTime dgMP ValueSet",
        "description" : "Dieses ValueSet enthält dgMPV DurationUnit Zeiteinheiten aus dem UCUM-CodeSystem in deutscher Übersetzung",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/EDQMUnitOfPresentation"
        },
        "name" : "EDQM Unit of Presentation ValueSet",
        "description" : "ValueSet Einheit der Darreichungsform gemäß EDQM, UOP, siehe https://standardterms.edqm.eu/#",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1000"
        },
        "name" : "Example-MR-Dosage-1000",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-0-0 dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1010"
        },
        "name" : "Example-MR-Dosage-1010",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-1-0 dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1010-10-Days"
        },
        "name" : "Example-MR-Dosage-1010",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-1-0 für 10 Wochen dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1010-Unsorted"
        },
        "name" : "Example-MR-Dosage-1010-Unsorted",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-1-0 unsortiert dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-10120"
        },
        "name" : "Example-MR-Dosage-10120",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1-0-0.5-0 dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1020"
        },
        "name" : "Example-MR-Dosage-1020",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-2-0 dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1220"
        },
        "name" : "Example-MR-Dosage-1020",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-2-2-0 dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1020-Unordered"
        },
        "name" : "Example-MR-Dosage-1020-Unordered",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-2-0 unsortiert dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-1111"
        },
        "name" : "Example-MR-Dosage-1111",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-1-1-1 dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-weekday-2t-1t"
        },
        "name" : "Example-MR-Dosage-2t-1t",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Montags 2 Stück, Donnerstags 1 Stück dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-dayofweek-1"
        },
        "name" : "Example-MR-Dosage-comb-dayofweek-1",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Montags und Freitags 1-0-1-0 dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-dayofweek-2"
        },
        "name" : "Example-MR-Dosage-comb-dayofweek-2",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Montags und Freitags 1-0-2-0 dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-dayofweek-3"
        },
        "name" : "Example-MR-Dosage-comb-dayofweek-3",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Montags und Freitags 1 Stück Morgens und 2 Stück Mittags (1-1-0-0) - für 3 Wochen dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-dayofweek-unsorted"
        },
        "name" : "Example-MR-Dosage-comb-dayofweek-unsorted",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von unsortierten Wochentagen dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-interval-1"
        },
        "name" : "Example-MR-Dosage-comb-interval-1",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 Uhr und 1 Stück um 18:00 Uhr dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-interval-2"
        },
        "name" : "Example-MR-Dosage-comb-interval-2",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1 x pro Woche 1 Stück morgens dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-interval-3"
        },
        "name" : "Example-MR-Dosage-comb-interval-3",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 Uhr und jeden 2. Tag 1 Stück um 20:00 Uhr dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-comb-interval-4"
        },
        "name" : "Example-MR-Dosage-comb-interval-4",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 & 20:00 Uhr und jeden 2. Tag 1 Stück um 08:00, 14:00 und 22:00 Uhr dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-Freetext"
        },
        "name" : "Example-MR-Dosage-Freetext",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Freitext-Dosierung dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-interval-2d-bound"
        },
        "name" : "Example-MR-Dosage-interval-2d",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Alle 2 Tage 2 Stück für 6 Wochen dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-interval-2wk"
        },
        "name" : "Example-MR-Dosage-interval-2wk",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1 Stück alle 2 Wochen dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-interval-3d"
        },
        "name" : "Example-MR-Dosage-interval-3d",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Alle 3 Tage 1 Stück dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-interval-4times-d"
        },
        "name" : "Example-MR-Dosage-interval-4times-d",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 4 x 1 Stück pro Tag dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-interval-8d"
        },
        "name" : "Example-MR-Dosage-interval-8d",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1 Stück alle 8 Tage dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-tod-1t-8am"
        },
        "name" : "Example-MR-Dosage-tod-1t-8am",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1 Stück um 08:00",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-tod-2-12am"
        },
        "name" : "Example-MR-Dosage-tod-2-12am",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 2 Stück um 12:00 Uhr",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-tod-multi"
        },
        "name" : "Example-MR-Dosage-tod-multi",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 8 Uhr: 2 Stück - 11 Uhr: 1 Stück - 14 Uhr: 1 Stück - 17 Uhr: 1 Stück - 20 Uhr: 1 Stück - 23 Uhr: 1 Stück dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-tod-multi-bound"
        },
        "name" : "Example-MR-Dosage-tod-multi-bound",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 8 Uhr: 2 Stück - 11 Uhr: 1 Stück - 14 Uhr: 1 Stück - 17 Uhr: 1 Stück - 20 Uhr: 1 Stück - 23 Uhr: 1 Stück, für 10 Tage",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-tod-unsorted"
        },
        "name" : "Example-MR-Dosage-tod-unsorted",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1 Stück und unsortierten Zeiten dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-UnitStueck-1020"
        },
        "name" : "Example-MR-Dosage-UnitStueck-1020",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-2-0 und kodierter Einheit 'Stück' dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-UnitTasse-1000"
        },
        "name" : "Example-MR-Dosage-UnitTasse-1000",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-0-0 und kodierter Einheit 'Stück' dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-DosageTr-1000"
        },
        "name" : "Example-MR-Dosage-UnitTr-1000",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 20-0-0-0 und kodierter Einheit 'Tropfen' dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-weekday-2t"
        },
        "name" : "Example-MR-Dosage-weekday-2t",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Dienstags und Donnerstags je 2 Stück dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-weekday-2t-bound"
        },
        "name" : "Example-MR-Dosage-weekday-2t-bound",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Montags 2 Tabl. für 10 Wochen dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-weekday-3t"
        },
        "name" : "Example-MR-Dosage-weekday-3t",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Dienstags, Donnerstags und Samstag je 2 Stück dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Example-MR-Dosage-weekday-unsorted"
        },
        "name" : "Example-MR-Dosage-weekday-unsorted",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von unsortierten Wochentagen je 2 Stück dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/GeneratedDosageInstructionsMeta"
        },
        "name" : "Generated Dosage Instructions Meta",
        "description" : "Diese Extension enthält die Metainformationen zur generierten textuellen Dosierungsanweisung, die auf Basis der bereitgestellten strukturierten Dosierungsinformationen erstellt wurde.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingBoundsUnitMatchesCode-01-of-01"
        },
        "name" : "Invalid boundsDuration unit/code mismatch",
        "description" : "boundsDuration.code 'wk' with unit 'Tag(e)'",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageStructuredRequiresGeneratedText-01-of-01"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingFrequencyCount-01-of-05"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingFrequencyCount-02-of-05"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingFrequencyCount-03-of-05"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingFrequencyCount-04-of-05"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingFrequencyCount-05-of-05"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingPeriodUnit-01-of-05"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingPeriodUnit-02-of-05"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingPeriodUnit-03-of-05"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingPeriodUnit-04-of-05"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingPeriodUnit-05-of-05"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-01-of-12-FreqPeriod-When"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-02-of-12-FreqPeriod-ToD-DayOfWeek"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-03-of-12-FreqPeriod-When-DayOfWeek"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-04-of-12-FreeText-and-structured"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-05-of-12-multiple-types"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-06-of-12-multiple-dosagecodes"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-07-of-12-timing-no-dose"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-09-of-12-C-TimingOnlyOneTimeForInterval"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-10-of-12-When-DiffPeriodU"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-11-of-12-C-TimingOnlyOneWhen"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-12-of-12-C-TimingOnlyOneDayOfWeek"
        },
        "name" : "Invalid Dosage",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01"
        },
        "name" : "Invalid Dosage - FreeText doesn't match renderedDosageInstruction",
        "description" : "Invalid: Freitext-Dosierung vorhanden, aber der Wert in dosageInstruction.text stimmt nicht mit renderedDosageInstruction überein.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-FreeTextSingleDosageOnly-01-of-01"
        },
        "name" : "Invalid Dosage - FreeText must be single",
        "description" : "Invalid: Freitextdosierung vorhanden, aber mehr als ein Dosage-Element vorhanden.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyOneType-05-of-08"
        },
        "name" : "Invalid: dayOfWeek + interval",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageStructuredRequiresBoth-02-of-02"
        },
        "name" : "Invalid: dose without timing",
        "description" : "CAVE: Validation example - doseAndRate exists but timing missing.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageDoseUnitSameCode-01-of-01"
        },
        "name" : "Invalid: mixed dose units",
        "description" : "CAVE: Validation example - two dosageInstructions use different dose unit codes.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingSingleDosageForTimeOfDay-01-of-01"
        },
        "name" : "Invalid: split timeOfDay into two dosages (same period/dose)",
        "description" : "Zwei Dosages mit identischem Intervall und Dosis, jeweils eine Uhrzeit - sollte zu einer Dosage zusammengeführt werden.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-TimingSingleDosageForWhen-01-of-01"
        },
        "name" : "Invalid: split when into two dosages (same period/dose)",
        "description" : "Zwei Dosages mit identischem Intervall und Dosis, jeweils ein Zeitraum (MORN/EVE) - sollte zu einer Dosage zusammengeführt werden.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageStructuredOrFreeText-02-of-02"
        },
        "name" : "Invalid: text + doseAndRate",
        "description" : "CAVE: Validation example - contains both text and doseAndRate (should be either structured OR text).",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageStructuredOrFreeText-01-of-02"
        },
        "name" : "Invalid: text + timing",
        "description" : "CAVE: Validation example - contains both text and timing (should be either structured OR text).",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyOneType-03-of-08"
        },
        "name" : "Invalid: timeOfDay + dayOfWeek",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyOneType-04-of-08"
        },
        "name" : "Invalid: timeOfDay + interval",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-Dosage-C-DosageStructuredRequiresBoth-01-of-02"
        },
        "name" : "Invalid: timing without dose",
        "description" : "CAVE: Validation example - timing exists but doseAndRate missing.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyOneType-01-of-08"
        },
        "name" : "Invalid: when + dayOfWeek",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyOneType-02-of-08"
        },
        "name" : "Invalid: when + interval",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01"
        },
        "name" : "Invalid: when + timeOfDay",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationDispenseDgMP"
        },
        "name" : "Medication Dispense dgMP",
        "description" : "Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationRequestDgMP"
        },
        "name" : "Medication Request dgMP",
        "description" : "Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/MedicationStatementDgMP"
        },
        "name" : "Medication Statement dgMP",
        "description" : "Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MD-Dosage-1020"
        },
        "name" : "MedicationDispense Dosage Example - 4-Schema",
        "description" : "Example showing 4-Schema pattern in MedicationDispense",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MD-Dosage-Bounds-Decimals"
        },
        "name" : "MedicationDispense Dosage Example - Bounds and Decimals",
        "description" : "Example showing bounds and decimal doses in MedicationDispense",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MD-Dosage-DayOfWeek-Time"
        },
        "name" : "MedicationDispense Dosage Example - DayOfWeek and Time",
        "description" : "Example showing DayOfWeek and Time pattern in MedicationDispense",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MD-Dosage-Freetext"
        },
        "name" : "MedicationDispense Dosage Example - FreeText",
        "description" : "Example showing FreeText pattern in MedicationDispense",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/MD-Dosage-Interval-Time"
        },
        "name" : "MedicationDispense Dosage Example - Interval and Time",
        "description" : "Example showing Interval and Time pattern in MedicationDispense",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-4schema-evening-only"
        },
        "name" : "MedicationRequest Dosage Example - 4-Schema Evening Only",
        "description" : "Example showing 4-Schema pattern with only evening dose (0-0-1-0)",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-4schema-night-only"
        },
        "name" : "MedicationRequest Dosage Example - 4-Schema Night Only",
        "description" : "Example showing 4-Schema pattern with only night dose (0-0-0-1)",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-4schema-noon-only"
        },
        "name" : "MedicationRequest Dosage Example - 4-Schema Noon Only",
        "description" : "Example showing 4-Schema pattern with only noon dose (0-1-0-0)",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-4schema-ml-units"
        },
        "name" : "MedicationRequest Dosage Example - 4-Schema with ml Units",
        "description" : "Example showing 4-Schema pattern with ml units instead of Stück",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-weekday-mixed-doses"
        },
        "name" : "MedicationRequest Dosage Example - DayOfWeek Mixed Doses",
        "description" : "Example showing different doses on different days of the week",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-freetext-german-chars"
        },
        "name" : "MedicationRequest Dosage Example - FreeText German Characters",
        "description" : "Example showing FreeText with German special characters and complex text",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-interval-when-3d"
        },
        "name" : "MedicationRequest Dosage Example - Interval with When Codes",
        "description" : "Example showing interval dosing with when codes instead of timeOfDay",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-interval-monthly"
        },
        "name" : "MedicationRequest Dosage Example - Monthly Interval",
        "description" : "Example showing interval dosing with monthly period",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-multiple-day-time"
        },
        "name" : "MedicationRequest Dosage Example - Multiple Days with TimeOfDay",
        "description" : "Example showing multiple dayOfWeek + timeOfDay combination",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-single-day-time"
        },
        "name" : "MedicationRequest Dosage Example - Single Day with TimeOfDay",
        "description" : "Example showing minimal dayOfWeek + timeOfDay combination",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Dosage-tod-mixed-doses"
        },
        "name" : "MedicationRequest Dosage Example - TimeOfDay Mixed Doses",
        "description" : "Example showing different doses at different times of day",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MS-Dosage-1010"
        },
        "name" : "MedicationStatement Dosage Example - 4-Schema",
        "description" : "Example showing 4-Schema pattern in MedicationStatement",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MS-Dosage-DayOfWeek"
        },
        "name" : "MedicationStatement Dosage Example - DayOfWeek",
        "description" : "Example showing DayOfWeek pattern in MedicationStatement",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MS-Dosage-Freetext"
        },
        "name" : "MedicationStatement Dosage Example - FreeText",
        "description" : "Example showing FreeText pattern in MedicationStatement",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MS-Dosage-Interval"
        },
        "name" : "MedicationStatement Dosage Example - Interval",
        "description" : "Example showing Interval pattern in MedicationStatement",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/MS-Dosage-TimeOfDay"
        },
        "name" : "MedicationStatement Dosage Example - TimeOfDay",
        "description" : "Example showing TimeOfDay pattern in MedicationStatement",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/PeriodUnitsOfTimeDgMP"
        },
        "name" : "Period UnitsOfTime dgMP ValueSet",
        "description" : "Dieses ValueSet enthält dgMP PeriodUnit Zeiteinheiten aus dem UCUM-CodeSystem in deutscher Übersetzung",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TimingDE"
        },
        "name" : "Timing DE",
        "description" : "Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:complex-type"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/TimingDgMP"
        },
        "name" : "Timing dgMP",
        "description" : "Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/TimingWhenDgMP"
        },
        "name" : "Timing When dgMP",
        "description" : "Tageszeiten für Zeitmuster",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-01-of-10-when"
        },
        "name" : "Two dosages with the same period of day",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-04-of-10-C-TimingOnlyOnePeriodForDayOfWeek"
        },
        "name" : "Two dosages with the same period of day on the same day",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-02-of-10-C-TimingOnlyOneTimeOfDay"
        },
        "name" : "Two dosages with the same time of day",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-05-of-10-C-TimingOnlyOnePeriodForDayOfWeek"
        },
        "name" : "Two dosages with the same time of day on the same day",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-06-of-10-C-TimingIntervalOnlyOneFrequency"
        },
        "name" : "Two Interval Dosages",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von jeden 2. Tag 1 Stück und 3. Tag 2 Stück dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-10-of-10-C-TimingOnlyOneBounds"
        },
        "name" : "Two interval Dosages different boundsDuration",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung mit verschiedener Dauer dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-07-of-10-C-TimingOnlyOneWhen"
        },
        "name" : "Two interval Dosages same period of day",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 Uhr und 1 Stück um 10:00 Uhr dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay"
        },
        "name" : "Two interval Dosages same time",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 Uhr und 1 Stück um 10:00 Uhr dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Invalid-multiple-09-of-10-C-TimingOnlyOneTimeForInterval"
        },
        "name" : "Two interval Dosages same time",
        "description" : "Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 Uhr und 1 Stück um 10:00 Uhr dar",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-11-of-20-AdditionalInstruction"
        },
        "name" : "Unsupported Dosage 1 AdditionalInstruction",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-02-of-20-asNeededBoolean"
        },
        "name" : "Unsupported Dosage 1 asNeededBoolean",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-03-of-20-asNeededCodeableConcept"
        },
        "name" : "Unsupported Dosage 1 asNeededCodeableConcept",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-17-of-20-BoundsPeriod"
        },
        "name" : "Unsupported Dosage 1 BoundsPeriod",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-18-of-20-BoundsRange"
        },
        "name" : "Unsupported Dosage 1 BoundsRange",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-01-of-20-Count"
        },
        "name" : "Unsupported Dosage 1 Count",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-15-of-20-Count"
        },
        "name" : "Unsupported Dosage 1 Count",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-16-of-20-CountMax"
        },
        "name" : "Unsupported Dosage 1 CountMax",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-07-of-20-DoseRange"
        },
        "name" : "Unsupported Dosage 1 DoseRange",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-20-of-20-Event"
        },
        "name" : "Unsupported Dosage 1 Event",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-13-of-20-MaxDosePerAdministration"
        },
        "name" : "Unsupported Dosage 1 MaxDosePerAdministration",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-14-of-20-MaxDosePerLifetime"
        },
        "name" : "Unsupported Dosage 1 MaxDosePerLifetime",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-12-of-20-MaxDosePerPeriod"
        },
        "name" : "Unsupported Dosage 1 MaxDosePerPeriod",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-04-of-20-Method"
        },
        "name" : "Unsupported Dosage 1 Method",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-19-of-20-Offset"
        },
        "name" : "Unsupported Dosage 1 Offset",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-08-of-20-RateQuantity"
        },
        "name" : "Unsupported Dosage 1 RateQuantity",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-09-of-20-RateRange"
        },
        "name" : "Unsupported Dosage 1 RateRange",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-10-of-20-RateRatio"
        },
        "name" : "Unsupported Dosage 1 RateRatio",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-05-of-20-Route"
        },
        "name" : "Unsupported Dosage 1 Route",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/MR-Unsupported-Dosage-06-of-20-Site"
        },
        "name" : "Unsupported Dosage 1 Site",
        "description" : "CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01"
        },
        "name" : "Valid: only text",
        "description" : "Valid example - purely text dosage; allowed but structured dosage preferred.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Warning-Dosage-W-DosageWarnungViererschemaInText-01-of-01"
        },
        "name" : "Warnung: Viererschema im Freitext",
        "description" : "Freitext enthält ein Viererschema (1-0-1-0); soll strukturiert modelliert werden.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/Warning-Dosage-Viererschema-Text-01"
        },
        "name" : "Warnung: Viererschema in Dosage.text",
        "description" : "Beispiel, das ein Viererschema (1-1-1-1) in Dosage.text enthält, um die Warn-Invariante auszulösen.",
        "exampleCanonical" : "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "FHIR Implementation Guide für medikationsbezogene Anwendungsfälle im deutschen Gesundheitswesen",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-einfuehrung.html"
            }
          ],
          "nameUrl" : "dosierung-einfuehrung.html",
          "title" : "FHIR Dosierungen für den digital gestützten Medikationsprozess",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-rahmenvorgaben.html"
            }
          ],
          "nameUrl" : "dosierung-rahmenvorgaben.html",
          "title" : "Fachliche Rahmenvorgaben für Dosierungen",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-dgmp.html"
            }
          ],
          "nameUrl" : "dosierung-dgmp.html",
          "title" : "Fachliche Rahmenvorgaben des dgMP",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-textgenerierung.html"
            }
          ],
          "nameUrl" : "dosierung-textgenerierung.html",
          "title" : "Dosis Textgenerierung",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-text-hinzufuegen.html"
            }
          ],
          "nameUrl" : "dosierung-text-hinzufuegen.html",
          "title" : "Bereitstellung des Dosierungstextes",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-constraints.html"
            }
          ],
          "nameUrl" : "dosierung-constraints.html",
          "title" : "Übersicht der Timing & Dosierungs-Invarianten",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-freitext.html"
            }
          ],
          "nameUrl" : "schema-freitext.html",
          "title" : "Freitext-Dosierung",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-tageszeit.html"
            }
          ],
          "nameUrl" : "schema-tageszeit.html",
          "title" : "Schema mit Tageszeiten-Bezug",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-uhrzeit.html"
            }
          ],
          "nameUrl" : "schema-uhrzeit.html",
          "title" : "Schema mit Uhrzeiten-Bezug",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-wochentag.html"
            }
          ],
          "nameUrl" : "schema-wochentag.html",
          "title" : "Schema mit Wochentags-Bezug",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-intervall.html"
            }
          ],
          "nameUrl" : "schema-intervall.html",
          "title" : "Schema für wiederkehrende Intervalle",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-intervall-kombination.html"
            }
          ],
          "nameUrl" : "schema-intervall-kombination.html",
          "title" : "Schema für Kombinationen von Zeitintervallen",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "schema-wochentag-kombination.html"
            }
          ],
          "nameUrl" : "schema-wochentag-kombination.html",
          "title" : "Schema für Kombinationen von Wochentagen",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dosierung-beispiele.html"
            }
          ],
          "nameUrl" : "dosierung-beispiele.html",
          "title" : "Beispielliste Dosierung",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "FHIR Summary",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Downloads",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-pages",
        "value" : "input/content"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
